/********************************************************************************
*                                                                               *
*                     S h e l l   W i n d o w   O b j e c t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXShell.cpp,v 1.18 1999/11/15 17:14:53 jeroen Exp $                      *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXCursor.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXComposite.h"
#include "FXRootWindow.h"
#include "FXShell.h"

/*
  Notes:
  - FXShell handles keys to implement focus change messages.
  - The initial size should probably be determined not in create(), but in show().
  - Note that Shell is base class for transient ``popup'' override-redirect windows.
    For top level windows, we should use size hints rather than force the size.
*/

/*******************************************************************************/

// Map
FXDEFMAP(FXShell) FXShellMap[]={
  FXMAPFUNC(SEL_MAP,0,FXShell::onMap),
  FXMAPFUNC(SEL_UNMAP,0,FXShell::onUnmap),
  FXMAPFUNC(SEL_CONFIGURE,0,FXShell::onConfigure),
  FXMAPFUNC(SEL_FOCUS_NEXT,0,FXShell::onFocusNext),
  FXMAPFUNC(SEL_FOCUS_PREV,0,FXShell::onFocusPrev),
  };


// Object implementation
FXIMPLEMENT(FXShell,FXComposite,FXShellMap,ARRAYNUMBER(FXShellMap))


// Create a toplevel window
FXShell::FXShell(FXApp* a,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXComposite(a,NULL,opts,x,y,w,h){
  }


// Create a toplevel window
FXShell::FXShell(FXWindow* own,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXComposite(own->getApp(),own,opts,x,y,w,h){
  }


// Create X window
void FXShell::create(){
  FXint w,h;
  
  // Create this widget and all of its children
  FXComposite::create();
  
  // Adjust size if necessary
  w=(1<width) ? width : getDefaultWidth();
  h=(1<height) ? height : getDefaultHeight();
  
  // Resize this widget
  resize(w,h);
  }


// User determines size of shells
void FXShell::recalc(){
  flags|=FLAG_DIRTY;
  }


// Shell part of focus chain
void FXShell::setFocus(){
  if(!shown()) return;
  if(xid){
#ifndef FX_NATIVE_WIN32
    XSetInputFocus(getApp()->display,xid,RevertToPointerRoot,CurrentTime);
#else
    SetFocus((HWND)xid);
#endif
    }
  }


// Shells out of focus chain
void FXShell::killFocus(){ 
  if(xid){
#ifndef FX_NATIVE_WIN32
    Window win; int dum;
    XGetInputFocus(getApp()->display,&win,&dum);
    if(win==xid){
      XSetInputFocus(getApp()->display,PointerRoot,RevertToPointerRoot,CurrentTime);
      }
#else
    if(GetFocus()==(HWND)xid){
      if(getOwner() && getOwner()->id()) 
        SetFocus((HWND)getOwner()->id());
      else
        SetFocus((HWND)NULL);
      }
#endif
    }
  }


// Notify target that window is now on screen
long FXShell::onMap(FXObject*,FXSelector,void* ptr){
  FXTRACE((250,"%s::onMap %08x\n",getClassName(),this));
  if(target) target->handle(this,MKUINT(message,SEL_MAP),ptr);
  return 1;
  }


// Notify target that window is no longer on screen
long FXShell::onUnmap(FXObject*,FXSelector,void* ptr){
  FXTRACE((250,"%s::onUnmap %08x\n",getClassName(),this));
  if(target) target->handle(this,MKUINT(message,SEL_UNMAP),ptr);
  return 1;
  }


// Handle configure notify
long FXShell::onConfigure(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXTRACE((250,"%s::onConfigure: %08x\n",getClassName(),this));
  xpos=ev->rect.x;
  ypos=ev->rect.y;
  if((ev->rect.w!=width) || (ev->rect.h!=height)){
    width=ev->rect.w;               // Record new size
    height=ev->rect.h;
    layout();                       // Do layout
    //recalc();
    }
  if(target) target->handle(this,MKUINT(message,SEL_CONFIGURE),ptr);
  return 1;
  }


// Focus moved to next
long FXShell::onFocusNext(FXObject* sender,FXSelector sel,void* ptr){
  FXWindow *child;
  if(getFocus()){
    child=getFocus()->getNext();
    while(child){
      if(child->isEnabled() && child->canFocus()){
        child->handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
        return 1;
        }
      if(child->isComposite() && child->handle(sender,sel,ptr)) return 1;
      child=child->getNext();
      }
    getFocus()->killFocus();
    }
  child=getFirst();
  while(child){
    if(child->isEnabled() && child->canFocus()){
      child->handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
      return 1;
      }
    if(child->isComposite() && child->handle(sender,sel,ptr)) return 1;
    child=child->getNext();
    }
  return 0;
  }


// Focus moved to previous
long FXShell::onFocusPrev(FXObject* sender,FXSelector sel,void* ptr){
  FXWindow *child;
  if(getFocus()){
    child=getFocus()->getPrev();
    while(child){
      if(child->isEnabled() && child->canFocus()){
        child->handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
        return 1;
        }
      if(child->isComposite() && child->handle(sender,sel,ptr)) return 1;
      child=child->getPrev();
      }
    getFocus()->killFocus();
    }
  child=getLast();
  while(child){
    if(child->isEnabled() && child->canFocus()){
      child->handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
      return 1;
      }
    if(child->isComposite() && child->handle(sender,sel,ptr)) return 1;
    child=child->getPrev();
    }
  return 0;
  }


// Destruct
FXShell::~FXShell(){
  }



