/********************************************************************************
*                                                                               *
*                      T r e e   L i s t   B o x   W i d g e t                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXTreeListBox.h,v 1.4 1999/11/09 23:58:38 jeroen Exp $                   *
********************************************************************************/
#ifndef FXTREELISTBOX_H
#define FXTREELISTBOX_H




// Tree List Box styles
enum FXTreeListBoxStyle {
  TREELISTBOX_NORMAL         = 0          // Normal style
  };


// Tree List Box
class FXAPI FXTreeListBox : public FXPacker {
  FXDECLARE(FXTreeListBox)
protected:
  FXButton      *field;
  FXMenuButton  *button;
  FXTreeList    *tree;
  FXPopup       *pane;
protected:
  FXTreeListBox(){}
  virtual void layout();
private:
  FXTreeListBox(const FXTreeListBox&);
  FXTreeListBox& operator=(const FXTreeListBox&);
public:
  long onChanged(FXObject*,FXSelector,void*);
  long onCommand(FXObject*,FXSelector,void*);
  long onFieldButton(FXObject*,FXSelector,void*);
  long onTreeChanged(FXObject*,FXSelector,void*);
  long onTreeClicked(FXObject*,FXSelector,void*);
  long onUpdFmTree(FXObject*,FXSelector,void*);
public:
  enum{
    ID_TREE=FXPacker::ID_LAST,
    ID_FIELD,
    ID_LAST
    };
public:
  FXTreeListBox(FXComposite *p,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_SUNKEN|FRAME_THICK|TREELISTBOX_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void destroy();
  virtual void enable();
  virtual void disable();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  FXint getNumItems() const;
  FXint getNumVisible() const;
  void setNumVisible(FXint nvis);
  FXTreeItem* getFirstItem() const;
  FXTreeItem* getLastItem() const;
  FXTreeItem* addItemFirst(FXTreeItem* p,FXTreeItem* item);
  FXTreeItem* addItemLast(FXTreeItem* p,FXTreeItem* item);
  FXTreeItem* addItemAfter(FXTreeItem* other,FXTreeItem* item);
  FXTreeItem* addItemBefore(FXTreeItem* other,FXTreeItem* item);
  FXTreeItem* addItemFirst(FXTreeItem* p,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);
  FXTreeItem* addItemLast(FXTreeItem* p,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);
  FXTreeItem* addItemAfter(FXTreeItem* other,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);
  FXTreeItem* addItemBefore(FXTreeItem* other,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);
  void removeItem(FXTreeItem* item);
  void removeItems(FXTreeItem* fm,FXTreeItem* to);
  void removeAllItems();
  FXbool isItemCurrent(const FXTreeItem* item) const;
  FXbool isItemLeaf(const FXTreeItem* item) const;
  void sortChildItems(FXTreeItem* item);
  void sortItems();
  void setCurrentItem(FXTreeItem* item);
  FXTreeItem* getCurrentItem() const;
  void setItemText(FXTreeItem* item,const FXString& text);
  FXString getItemText(const FXTreeItem* item) const;
  void setItemOpenIcon(FXTreeItem* item,FXIcon* icon);
  FXIcon* getItemOpenIcon(const FXTreeItem* item) const;
  void setItemClosedIcon(FXTreeItem* item,FXIcon* icon);
  FXIcon* getItemClosedIcon(const FXTreeItem* item) const;
  void setItemData(FXTreeItem* item,void* ptr) const;
  void* getItemData(const FXTreeItem* item) const;
  FXTreeListSortFunc getSortFunc() const;
  void setSortFunc(FXTreeListSortFunc func);
  void setFont(FXFont* fnt);
  FXFont* getFont() const;
  FXuint getListStyle() const;
  void setListStyle(FXuint style);
  void setHelpText(const FXString& txt);
  FXString getHelpText() const;
  void setTipText(const FXString& txt);
  FXString getTipText() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXTreeListBox();
  };


#endif
