/********************************************************************************
*                                                                               *
*                             O p t i o n   M e n u                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOptionMenu.h,v 1.4 1999/11/09 23:58:37 jeroen Exp $                    *
********************************************************************************/
#ifndef FXOPTIONMENU_H
#define FXOPTIONMENU_H


class FXPopup;


// Option
class FXAPI FXOption : public FXLabel {
  FXDECLARE(FXOption)
protected:
  FXString tip;
  FXString help;
protected:
  FXOption(){}
private:
  FXOption(const FXOption&);
  FXOption &operator=(const FXOption&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
public:
  FXOption(FXComposite* p,const FXString& text,FXIcon* ic=NULL,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=JUSTIFY_NORMAL|ICON_BEFORE_TEXT|MENUBUTTON_DOWN,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual FXbool canFocus() const;
  virtual void setFocus();
  virtual void killFocus();
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  void setTipText(const FXString& text);
  FXString getTipText() const { return tip; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXOption();
  };


  
// Option Menu button
class FXAPI FXOptionMenu : public FXLabel {
  FXDECLARE(FXOptionMenu)
protected:
  FXPopup  *pane;
  FXOption *current;
protected:
  FXOptionMenu(){}
  virtual void layout();
private:
  FXOptionMenu(const FXOptionMenu&);
  FXOptionMenu &operator=(const FXOptionMenu&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onCmdPost(FXObject*,FXSelector,void*);
  long onCmdUnpost(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
public:
  FXOptionMenu(FXComposite* p,FXPopup* pup=NULL,FXuint opts=JUSTIFY_NORMAL|ICON_BEFORE_TEXT,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void detach();
  virtual void destroy();
  virtual void killFocus();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual FXbool contains(FXint parentx,FXint parenty) const;
  void setCurrent(FXOption *win);
  FXOption* getCurrent() const { return current; }
  void setCurrentNo(FXint no);
  FXint getCurrentNo() const;
  void setPopup(FXPopup *pup);
  FXPopup* getPopup() const { return pane; }
  virtual FXbool canFocus() const;
  FXbool isPopped() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXOptionMenu();
  };


#endif
