/********************************************************************************
*                                                                               *
*                             B i t m a p    O b j e c t                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXBitmap.h,v 1.3 1999/11/05 06:57:13 jeroen Exp $                        *
********************************************************************************/
#ifndef FXBITMAP_H
#define FXBITMAP_H


/// Image rendering hints
enum FXBitmapHints {
  BITMAP_KEEP       = 0x00000001,       /// Keep pixel data in client
  BITMAP_OWNED      = 0x00000002,       /// Pixel data is owned by image
  BITMAP_SHMI       = 0x00000020,       /// Using shared memory image
  BITMAP_SHMP       = 0x00000040        /// Using shared memory pixmap
  };
    

/// Bitmap is a one bit/pixel image used for patterning and
/// stippling operations.
class FXAPI FXBitmap : public FXDrawable {
  FXDECLARE(FXBitmap)
  friend class FXDC;
  friend class FXDCWindow;
  friend class FXDrawable;
  friend class FXTopWindow;
private:
#ifdef FX_NATIVE_WIN32
  virtual HDC GetDC() const;
  virtual int ReleaseDC(HDC hdc) const;
#endif
protected:
  FXuchar *data;                // Pixel data
  FXuint   options;             // Options
protected:
  enum{
    MAXWIDTH  = 2048,           // Maximum image size
    MAXHEIGHT = 2048
    };          
protected:
  FXBitmap();
#ifndef FX_NATIVE_WIN32
  void render_bits(XImage *xim,FXuchar *img);
#endif
private:
  FXBitmap(const FXBitmap&);
  FXBitmap &operator=(const FXBitmap&);
public:

  /// Create an image
  FXBitmap(FXApp* a,const void *pix=NULL,FXuint opts=0,FXint w=1,FXint h=1);
  
  /// Create bitmap
  virtual void create();

  /// Detach from bitmap
  virtual void detach();
  
  /// Destroy bitmap
  virtual void destroy();
  
  /// Render pixels
  virtual void render();
  
  /// Save object to stream
  virtual void save(FXStream& store) const;
  
  /// Load object from stream
  virtual void load(FXStream& store);
  
  /// Save pixel data only
  virtual void savePixels(FXStream& store) const;
  
  /// Load pixel data only
  virtual void loadPixels(FXStream& store);

  /// Cleanup
  virtual ~FXBitmap();
  };
  
    
#endif
