#
# $Header: /usr/local/cvsroot/pythondoc/docstring.py,v 1.2 1999/05/01 01:01:41 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.

"""Miscellany functions for parsing docstrings."""

import docregex
import StructuredText

def stripleadingtabs(s):
    """Strip leading tabs in the string ~s~.
	
    The leading tabs, such as the one on this line, will be
    stripped by this function for a more readable string"""

    import string
    s = StructuredText.untabify(s)
    match = docregex.leading_tab_regex.match(s)
    if match != None:
	tabs = match.group('spaces')
	return string.join(string.split(s, '\n'+tabs), '\n')
    else:
	return s

def split_doc(doc):
    """Splits docstring into the oneliner part and the rest,
    assuming there is a oneliner."""

    if not doc: return '', ''

    # Evaluate doc to remove enclosing "'s
    doc = stripleadingtabs(doc)
    match = docregex.oneliner_regex.match(doc)
    
    if match != None:
	# Strip away trailing two newlines
	oneliner = match.group('oneliner')

	doc = doc[match.end():]

    else:
	match = docregex.oneliner_only_regex.match(doc)

	if match.end() == len(doc):
	    oneliner = doc
	    doc = ''
	else:
	    oneliner = ''
    return (oneliner, doc)

def split_hyper(doc):
    """Separates hyperlink definitions from the docstring."""

    search = docregex.hyperdef_regex.search(doc)
    if search:
	return doc[:search.start()], doc[search.start():]
    else:
	return doc, ''

#
# $Log: docstring.py,v $
# Revision 1.2  1999/05/01 01:01:41  daniel
# *** empty log message ***
#
# 
# *****************  Version 2  *****************
# User: Daniel       Date: 98-08-06   Time: 17:14
# Updated in $/Pythondoc
# Added header and footer.
# Added 'split_hyper', which splits the docstring and it's hyperlink
# definitions.
#
