/* PSK31 -- Viterbi and Varicode encoder / decoder
 * based on PSK31-Code by Andrew Senior, G0TJZ
 * (C) 1998,1999 Hansi Reiser, DL9RDZ
 * subject to GPL -- see LICENSE for details
 */

#ifndef __PSK31_CODER_INCLUDED
#define __PSK31_CODER_INCLUDED

#include "psk31.h"

/* Viterbi and Varicode encoding and decoding funktions */
class psk31_coder {
private:
	/* Varicode data tables */
	static int hallo;
	static int decotab[2048];
	static int encotab[256];
	/* Convolutional coder/Viterbi coder data */
	static unsigned char symbols[32];
	static const unsigned char poly1 = 0x19, poly2 = 0x17;

	int qpsk, lsb;
	struct state {
		float dist;
		int last_abs_phase;
		long estimate;
	};
	int lastphase;

	struct state states[16];     /* QPSK decoder trellis */
	float agc,ampl;
	int vlerror, rxreg;   /* Varicode decoder state */

	unsigned int encode_qpsk(unsigned int sreg);
	unsigned int encode_bpsk(unsigned int sreg);
	int decode_qpsk(complex rxsymbol);
	int decode_bpsk(complex rxsymbol);
	float x_distance(complex rxsymb, int lastphase, int delta);
	int decode_varicode(int bit);
	static unsigned char parity(unsigned char u);
public:
	void prime_decoder();
	static int init_tables();
	psk31_coder() { 
		agc=ampl=vlerror=rxreg=0; lastphase=0; 
		qpsk=lsb=0;
		for(int i=0; i<16; i++) {
			states[i].dist=states[i].last_abs_phase=0;
			states[i].estimate=0;
		}
	}
	void setmode(int qpskfl, int lsbfl) { qpsk=qpskfl; lsb=lsbfl; }
	/* encodes shift register data in phase increment (0..3) */
	unsigned int encode(unsigned int sreg, int use_qpsk);
	int encode_varicode(int symb);
	int decode(complex rxsymbol, int symb);
	static int IQ2iphase(complex IQval);
};

#endif
