// ctfile.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef CTFILE_H
#define CTFILE_H

#include "qsofile.h"

#define CT_PREC_SIZE    2
#define CT_CHECK_SIZE   3
#define CT_CALL_SIZE    14
#define CT_NAME_SIZE    30
#define CT_ADDRESS_SIZE 40
#define CT_TOWN_SIZE    27
#define CT_STATE_SIZE   3
#define CT_ZIP_SIZE     5
#define CT_GRID_SIZE    5
#define CT_CLUB_SIZE    40
#define CT_SECTION_SIZE 5


class RCtFile : public RQsoFile {
// The first 398 bytes of the .BIN consists of this restart header
// Thereafter, the file is filled with log_data records
      typedef struct   ss_stuff
      {
         char     prec[2];
         char     chk[3];
      } ss_stuff_type;

      typedef struct   fd_stuff
      {
         uchar    ep_bonus       : 1;
         uchar    pr_bonus       : 1;
         uchar    loc_bonus      : 1;
         uchar    info_bonus     : 1;
         uchar    msg_bonus      : 1;
         uchar    sat_bonus      : 1;
         uchar    nat_bonus      : 1;
         uchar    w1aw_bonus     : 1;
         uchar    pkt_bonus      : 1;
         uchar    power          : 2;
         uchar    tx_count       : 5;
         char     category       : 4;
         uchar    tfc_bonus      : 4;
      } fd_stuff_type;

    typedef struct fd_info {
        uchar    tx_count;
        uchar    category;
    } fd_info_type;               // FD class

typedef struct   restart_header // info in front of log data in .BIN file
{
   char     contest_title[9];
   short    category_int;
   uchar    tx_pwr;           // for SS
   char     version_str[8];   // version number of CT that created this header
   char     call[14];
   char     name[30];
   char     address[40];
   char     town[27];
   char     state[3];
   char     data[20];
   struct   comm_data      // comm port setup info
   {
      char  device;
      char  baud;          // 0 = 1200, 1 = 2400, 2 = 4800, 3 = 9600, 4 = 19.2
   } comm[4];
   char     contest_type[5];
   char     mode[4];
   char     category[3];   // SO, MM, MS, etc
   char     tnc[4];        // N = node,  D = DRSI, E = EXTERNAL
   char     radio[6];      // tnc[3] => baud: 0 = 4800 1 = 1200
   char     timezone[10];  // EST. PST, UTC etc
   char     m_stn;         // mult/run station
   char     post_flag;     // post contest mode
   char     beep;          // beep on dupes
   char     band_rate;     // display rate meters by band or all
   char     cw_port[5];
   char     cq_msg[40];
   char     ex_msg[20];
   char     qrz_msg[20];
   char     sound;         // sound on when sending CW
   char     zip[6];        // zipcode in address
   char     station[5];    // station numer
   char     zone[5];       // CQWW zone
   char     F6_text[10];
   char     F7_text[10];
   char     autosav;       // autosav enabled?
   char     nocompress;    // compressed printing enable
   char     club[40];      // Club line in summary sheet
   char     cw_abbrev;     // sustitute T for 0,  A for 1 etc, sending CW
   union
   {
      ss_stuff_type ss;
      fd_stuff_type fd;
      char  my_grid[5];
   };
   char     sec[5];        // section for FD and SS
   char     dvk_port[5];   // parallel port of DVK connection
   char     dupe_msg[20];  // worked b4 msg
} CtHeader;

CtHeader ctheader;

public:

typedef struct ct_log_data_struct // binary records kept in .BIN file
{
   union {                    // anonymous unions
   short      rst;              // received RST, sent is always 59 or 599
   short      serial;           // received serial number in SS
   fd_info_type fd;};         // FD class
   ulong    freq[2];          // frequency read from TS940 VFO A and B
   long     time;             // UNIX time: seconds since Jan 1, 1970
   uchar    status;           // split or transceive, which VFO active
   uchar    band : 4;         // 1 = 160, 2 = 80 ... 6 = 10
   uchar    mode : 4;         // CW = 1, SSB = 2, RTTY = 3
   char     call[14];         // callsign of station worked
   char     info[5];          // received info: zone, power, grid, sec, etc
   union {
   uchar    tx_pwr;           // for ardxdx.  DX stations may change power.
   uchar    novice;           // novice in 10 mtr test
   uchar    qtc_num;          // number of qtc record this sent to in WAE
   uchar    check; };         // check in SS
   uchar    stn_num;          // tag identifying computer this logged on
                              // bit 7 is QSL_RCVD, bit 6 is QSL_SENT
} ct_log_data;

    RCtFile()                   {location = 0;};
    RCtFile(char *name);
#ifdef LINUX
    boolean open(char *name, int mode = ios::in);
#else
    boolean open(char *name, int mode = ios::in | ios::binary);
#endif
    boolean writeHeader(header_data newheader);  /* Write new header to the file. */
//    ct_log_data nextCTQso();                     /* Return next CT QSO record */
    virtual boolean nextQso(qso_data *);         /* Return next generic QSO record */
    virtual boolean writeQso(qso_data *);        /* Write a generic QSO record */
};
#endif
