/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_PRINT_OPTIONS_H
#define _TF_DIALOG_PRINT_OPTIONS_H 1


#include "GuiDialogYN.h"				// include gtk, gtk--
#include "GuiBufferedDrawingArea.h"
#include "GuiColormap.h"


/*
 *  TFDialogPrintOptions: display the print dialog
 */
class TFDialogPrintOptions : public GuiDialogYN
	{
	public: 
				TFDialogPrintOptions ();
				~TFDialogPrintOptions (); 
		void		buildDialogWindow ();
		void 		buttonCallbackYes ();
		void 		buttonCallbackNo ();

	protected:
		void		init ();
		void		setPaper (const gchar *paper);
		void		getMargins ( gfloat *tmargin, gfloat *bmargin,
					     gfloat *lmargin, gfloat *rmargin);
		void		setMargins ( gfloat tmargin, gfloat bmargin,
					     gfloat lmargin, gfloat rmargin);
		int		getOrientation ();
		void		setOrientation (int orient);
		gfloat		getScaling ();
		void		setScaling (gfloat scaling);
		void		getEffectiveArea (float *width, gfloat *height);
		void		getPaperSize (const gchar *paper, 
					gfloat *width, gfloat *height); 
		void		getDefaultMargins (const gchar *paper,
					gfloat *tmargin, gfloat *bmargin,
					gfloat *lmargin, gfloat *rmargin);
		void		fitToPagePressed ();
		void		sizePage ();
		gint		redraw (GdkEventExpose *e=NULL);
		int		idleRedraw ();
		void		paperSizeChange ();
		void		colorSpaceChange ();
		void		orientChanged ();
		void		marginChanged ();
		void		scaleChanged ();
		void		cmbPaperSizeCallback ();

		int			d_paperSelected,
					d_colorSpaceSelected;
		int			d_offx, d_offy, d_width, d_height;
		Gtk_Entry		d_enPaperSize;
		Gtk_HBox		d_hbOrientation;
		Gtk_VBox		d_vbPaperSize,
					d_vbColorSpace,
					d_vbScaling;
		Gtk_Frame		d_frmPaperSize,
					d_frmColorSpace,
					d_frmOrientation,
					d_frmMargins,
					d_frmScaling;
		Gtk_Label		d_lblPaperSize,
					d_lblT,
					d_lblB,
					d_lblL,
					d_lblR;
		Gtk_Button		d_btnFitToPage; 
		GdkColor		*p_col, 
					*p_colB,
					*p_colW;
		Gtk_Adjustment		*p_adjMarginT,
					*p_adjMarginB,
					*p_adjMarginL,
					*p_adjMarginR,
					*p_adjScaling;
		Gtk_Pixmap		*p_pixPortrait,
					*p_pixLandscape;
		Gtk_Menu		*p_menuPaperSize,
					*p_menuColorSpace;
		Gtk_OptionMenu		*p_optMenuPaperSize,
					*p_optMenuColorSpace;
		Gtk_SpinButton		*p_spbtnMarginT,
					*p_spbtnMarginB,
					*p_spbtnMarginL,
					*p_spbtnMarginR,
					*p_spbtnScaling;
		Gtk_RadioButton		*p_rbOrientLandscape, 
					*p_rbOrientPortrait;
		Gtk_Table		*p_tblMain,
					*p_tblMargins;
		GuiBufferedDrawingArea	*p_da;
		GuiColormap		*p_colorMap;
	};


#endif // _TF_DIALOG_PRINT_OPTIONS_H
