/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <math.h>
#include <iostream.h>
#include <stdlib.h>
#include "MathRandom.h"
#include "GlobalTrace.h"


/* 
 *  rand: return a number between floor and ceil as advised in man page 
 */ 
double MathRandom::rnd (float floor, float ceil)
{
	return (floor+(ceil*rand()/(RAND_MAX+1.0)));
}


/* 
 *  initGauss: initialize the gaussian random number generator
 *  taken from 'The Science of Fractal Images' by Peitgen & Saupe, 
 *  1988 (page 77)
 */ 
void MathRandom::initGauss (int seed)
{
	if (GlobalTrace::isSet (GlobalTrace::TRACE_VERBOSE))
		cout << "InitGauss: seed=" << seed << ", samples=" 
		     << MathRandom::s_gaussNRand << "\n";

	s_gaussAdd = sqrt(3.0 * s_gaussNRand);
	s_gaussFac = 2 * s_gaussAdd / (s_gaussNRand * s_maxGauss);
	srand ((unsigned int)seed);
}


/* 
 *  randGauss: return a gaussian random number with s_gaussNRand samples
 *  taken from 'The Science of Fractal Images' by Peitgen & Saupe, 
 *  1988 (page 77)
 */ 
double MathRandom::rndGauss ()
{
	float		sum=0.0;

	for (int i=0; i<s_gaussNRand; i++)
		sum += (MathRandom::rnd() * s_maxGauss);
	return ((s_gaussFac * sum - s_gaussAdd));
}


/*
// instantiate static data members
const int MathRandom::s_gaussNRand=4;
const double MathRandom::s_maxGauss=pow(2.0, 15.0)-1.0;
double MathRandom::s_gaussAdd=0.0;
double MathRandom::s_gaussFac=0.0;

int main (int argc, char *argv[])
{
	MathRandom::initGauss (10);
	for (int i=0; i<1000; i++)
		cout << MathRandom::rndGauss () << "\n";
}

*/
