#include <stdio.h>
#include <unistd.h>

#include "../include/jsw.h"


int main(int argc, char *argv[])
{
	int i, status;
	int strc;
	char *strv[10];

	js_data_struct jsd;


	if(argc < 3)
	{
	    printf(
 "Usage: jstest <device> <caliberation_file>\n"
	    );
	    return(1);
	}


	strc = 5;
	strv[0] = "-d";
	strv[1] = argv[1];
	strv[2] = "-f";
	strv[3] = argv[2];
	strv[4] = "--non_blocking";


	status = JSInit(&jsd, strc, strv);
	if(status != JSSuccess)
	{
	    JSClose(&jsd);
	    fprintf(stderr, "JSInit(): Error: %i\n", status);
	    return(1);
	}


	printf(
	    "Reading joystick `%s' (press ctrl+c to interupt).\n",
	    argv[1]
	);

	while(1)
	{
	    JSUpdate(&jsd);

	    fprintf(stdout, "\r");

	    for(i = 0; i < jsd.total_axises; i++)
	        fprintf(
		    stdout,
		    "A%i:%.4lf ",
		    i,
		    JSGetAxisCoeffNZ(&jsd, i)
		);

            for(i = 0; i < jsd.total_buttons; i++)
                fprintf(
                    stdout,
                    "B%i:%i ",
                    i,
                    jsd.button[i]->state
                );


	    fflush(stdout);

	    usleep(8000);
	}

	JSClose(&jsd);


	return(0);
}
