#include "swserv.h"
#include "../include/swexporteventscodes.h"



int NetHandleFireWeapon(int condescriptor, char *arg)
{
        long object_num, con_object_num;
	long sect_x, sect_y, sect_z;
	double x, y, z;
	double heading, pitch, bank;
	double velocity;
	double velocity_heading, velocity_pitch, velocity_bank;
        double freq;

	int selected_weapon;
        int objects_created;
        xsw_object_struct *con_obj_ptr;
	xsw_weapons_struct *sel_wep_ptr;

        char text[(3 * XSW_OBJ_NAME_MAX) + 512];


        if(!ConIsLoggedIn(condescriptor))
	    return(-1);

        con_object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(con_object_num))
            return(-1);
        else
            con_obj_ptr = xsw_object[con_object_num];
 

        /*
         *      SWEXTCMD_FIREWEAPON format:
         *
         *      object_num,
	 *      sect_x, sect_y, sect_z,
	 *      x, y, z,
	 *      heading, pitch, bank,
	 *      velocity,
	 *      velocity_heading, velocity_pitch, velocity_bank,
	 *      freq
         */
        sscanf(arg,
"%ld\
 %ld %ld %ld\
 %lf %lf %lf\
 %lf %lf %lf\
 %lf\
 %lf %lf %lf\
 %lf",

		&object_num,
		&sect_x, &sect_y, &sect_z,
		&x, &y, &z,
		&heading, &pitch, &bank,
		&velocity,
		&velocity_heading, &velocity_pitch, &velocity_bank,
		&freq
        );

        /* Connection must own object. */
        if(object_num != con_object_num)
            return(-3);


	/* Update the object that's firing the weapon. */
	con_obj_ptr->sect_x = sect_x;
	con_obj_ptr->sect_y = sect_y;
        con_obj_ptr->sect_z = sect_z;
        con_obj_ptr->x = x;
        con_obj_ptr->y = y;
        con_obj_ptr->z = z;
        con_obj_ptr->heading = heading;
        con_obj_ptr->pitch = pitch;
        con_obj_ptr->bank = bank;

        con_obj_ptr->velocity = velocity;
	con_obj_ptr->velocity_heading = velocity_heading;
/*
        con_obj_ptr->velocity_pitch = velocity_pitch;
        con_obj_ptr->velocity_bank = velocity_bank;
 */


	/* ********************************************************* */

        /* Get and check if selected weapon is valid. */
        selected_weapon = con_obj_ptr->selected_weapon;

        if((selected_weapon < 0) ||
           (selected_weapon >= con_obj_ptr->total_weapons)
        )
            return(-1);
        if(con_obj_ptr->weapons[selected_weapon] == NULL)
            return(-1);

	sel_wep_ptr = con_obj_ptr->weapons[selected_weapon];


        /* Did we wait the minimum delay before we can fire again? */ 
        if((sel_wep_ptr->delay + sel_wep_ptr->last_used) >=
            cur_millitime
        )
            return(0);
         
           
        /* Cannot fire weapon while cloaked. */
        if(con_obj_ptr->cloak_state == CLOAK_STATE_UP)
        {
/* Send error message? */
            sel_wep_ptr->last_used = cur_millitime;
            return(0);
        }
 
         
        /* If weapon is expendable, see if object_num has any left. */
        if(sel_wep_ptr->emission_type == WEPEMISSION_PROJECTILE)
        {   
            if(sel_wep_ptr->amount <= 0)
                return(0);
        }

        /* Does object have enough power to fire weapon? */
        if(con_obj_ptr->power < sel_wep_ptr->create_power)
            return(0); 


        /* ******************************************************** */
        /* Create the weapon. */
            
        /* Stream weapons. */
        if(sel_wep_ptr->emission_type == WEPEMISSION_STREAM)
        {
            objects_created = WepCreate(
                sel_wep_ptr->ocs_code,
                con_object_num,			/* Owner. */
                sel_wep_ptr->emission_type,
                con_obj_ptr->x,
                con_obj_ptr->y,
                con_obj_ptr->heading,
                sel_wep_ptr->power,
                sel_wep_ptr->range,
		freq
            );
        }
        /* Projectile and pulse weapons. */
        else
        {
            objects_created = WepCreate(
                sel_wep_ptr->ocs_code,
		con_object_num,			/* Owner. */
                sel_wep_ptr->emission_type,
                con_obj_ptr->x,
                con_obj_ptr->y,
                con_obj_ptr->heading,
                sel_wep_ptr->power,
                sel_wep_ptr->range,
		freq
            );
        }


        /*   Reget objects array pointer, creating objects changes the
	 *   global xsw_object pointer array!!!
         */
        con_obj_ptr = xsw_object[object_num];

        /* Were any objects created? */
        if(objects_created <= 0)
            return(objects_created);


        /* Log weapons fire. */
        sprintf(text,
 "%s: Fired: Weapon: %i  OCS: %i  Sector: %ld %ld %ld",
            DBGetFormalNameStr(con_object_num),
            selected_weapon,
            sel_wep_ptr->ocs_code,
            con_obj_ptr->sect_x,
            con_obj_ptr->sect_y,
            con_obj_ptr->sect_z
        );
        if(sysparm.log_events)
            LogAppendLineFormatted(fname.primary_log, text);


        /* Mark the last time it was fired. */
        sel_wep_ptr->last_used = cur_millitime;


        /*   Consume power on object_num for the power that was
         *   needed to create this weapon.
         */
        switch(sel_wep_ptr->emission_type)
        {
          /* Stream weapons. */
          case WEPEMISSION_STREAM:
            con_obj_ptr->power -= sel_wep_ptr->create_power;
            /* Play appropriate sound. */
            NetSendPlaySound(
                condescriptor,
                SOUND_CODE_FIRE_STREAM,
                1.0, 1.0
            );
            break;
            
          /* Projectile. */ 
          case WEPEMISSION_PROJECTILE:
            con_obj_ptr->power -= sel_wep_ptr->create_power
                * objects_created;

            /* Decrease stock for projectiles. */
            sel_wep_ptr->amount -=
                objects_created;
            if(sel_wep_ptr->amount < 0)
                sel_wep_ptr->amount = 0;

            /* Play appropriate sound. */
            NetSendPlaySound(
                condescriptor,
                SOUND_CODE_FIRE_PROJECTILE,
                1.0, 1.0
            );

            /* Export projectile weapons fire. */  
            sprintf(text,
 "Sector(%ld, %ld, %ld) %s launched projectile weapon.",
		con_obj_ptr->sect_x,
		con_obj_ptr->sect_y,
		con_obj_ptr->sect_z,
                DBGetFormalNameStr(con_object_num)
            );
            ExportEvents(
                fname.events_export,
                EVST_TYPE_PROJECTILEWEAPON_FIRED,
                text
            );
            break;

          /* Pulse. */
          case WEPEMISSION_PULSE:
            con_obj_ptr->power -= sel_wep_ptr->create_power *
                objects_created;

            /* Play appropriate sound. */
            NetSendPlaySound( 
                condescriptor,
                SOUND_CODE_FIRE_PULSE,
                1.0, 1.0
            );
            break;

          /* Default to stream weapon. */ 
          default:
            con_obj_ptr->power -= sel_wep_ptr->create_power;

            /* Play appropriate sound. */
            NetSendPlaySound(
                condescriptor,  
                SOUND_CODE_FIRE_STREAM,
                1.0, 1.0
            );
            break;
        }

        /* Sanitize power on object. */
        if(con_obj_ptr->power < 0)
            con_obj_ptr->power = 0;


        /* Set next object values update to now so it gets updated now. */
        next.object_values = cur_millitime;
        next.weapon_values = cur_millitime;


        /* Return the number of weapon objects created. */
        return(objects_created);
}


int NetSendFireWeapon(int condescriptor)
{
	return(0);
}
