#include "swserv.h"


/*
 *      Syncronize time.
 */
int CmdSyncTime(int condescriptor, char *arg)
{
        long con_object_num;
        char sndbuf[CS_DATA_MAX_LEN];
        char stringa[128 + XSW_OBJ_NAME_MAX];


        /* Get con_object_num, assumed valid. */
        con_object_num = connection[condescriptor]->object_num;


        /* Check if object's permission allows sync time. */
        if(xsw_object[con_object_num]->permission.uid > ACCESS_UID_SYNCTIME)
        {
            sprintf(sndbuf,
                "synctime: Access level %i: Permission denied.",
                ACCESS_UID_SYNCTIME
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }

        /* Log who requested timming reset. */
        sprintf(stringa,
            "%s: Syncronized global timmers.",
            DBGetFormalNameStr(con_object_num)
        );
        if(sysparm.log_general == 1)
            LogAppendLineFormatted(fname.primary_log, stringa);


        /* Warn all connections about timming reset. */
        NetSendLiveMessage(-1, "Server: Syncing global timmers...");

        /* Reset all global timmers. */
        SWServDoResetTimmers();

        /* Warn all connections about timming reset. */
        NetSendLiveMessage(-1, "Server: Global timmers syncronized.");


        return(0);
}
