#include "swserv.h"
 
 
int CmdChown(int condescriptor, char *arg)
{
        char name1[256];
        char name2[256];
        char name3[256];
        
        char *strptr;
        long new_owner;
        long object_num;
        long con_object_num;
        
        char sndbuf[CS_DATA_MAX_LEN];
        
        char stringa[CS_DATA_MAX_LEN];
        char stringb[CS_DATA_MAX_LEN];
        
        
        /* Copy arg to stringa. */
        strncpy(stringa, arg, CS_DATA_MAX_LEN);
        stringa[CS_DATA_MAX_LEN - 1] = '\0';   
        StringStripSpaces(stringa);
        
        
        /* If no argument, print usage. */
        if(strlen(stringa) < 1)
        {
            sprintf(sndbuf,
                "Usage: `chown <object>[=<owner>]'"
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }

        /* Get con_object_num, assumed valid. */
        con_object_num = connection[condescriptor]->object_num;
        
        
        /* Get object_num. */
        strncpy(stringb, stringa, CS_DATA_MAX_LEN);
        stringb[CS_DATA_MAX_LEN - 1] = '\0';
        
        strptr = strchr(stringb, '=');
        if(strptr != NULL)
            *strptr = '\0';
        StringStripSpaces(stringb);
        
        object_num = MatchObjectByName(stringb, -1);
        if(DBIsObjectGarbage(object_num))
        {
            sprintf(sndbuf,
                "%s: No such object.",
                stringb
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            return(-1);
        }
        else if(xsw_object[object_num]->type == XSW_OBJ_TYPE_PLAYER)
        {
            sprintf(sndbuf,
                "chown: Permission denied, players own themselves."
            );
            NetSendLiveMessage(condescriptor, sndbuf);
 
            return(-1);
        }
        else if(xsw_object[object_num]->type == XSW_OBJ_TYPE_GARBAGE)
        {
            sprintf(sndbuf,
                "chown: Cannot chown garbage or errors."
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            return(-1);
        }
        
            
        /* Get new_owner. */
        strptr = strchr(stringa, '=');
        if(strptr != NULL)
        {
            strptr += 1;
            strncpy(stringb, strptr, CS_DATA_MAX_LEN);
            stringb[CS_DATA_MAX_LEN - 1] = '\0';
            StringStripSpaces(stringb);
              
            new_owner = MatchObjectByName(stringb, XSW_OBJ_TYPE_PLAYER);
            if(DBIsObjectGarbage(new_owner))
            {
                sprintf(sndbuf,
                    "%s: No such player.",
                    stringb
                );
                NetSendLiveMessage(condescriptor, sndbuf);
              
                return(-1);
            }
        }
        else
        {
            new_owner = connection[condescriptor]->object_num;
        }


        /* Check permissions, allowed to chown? */
        if(xsw_object[con_object_num]->permission.uid > ACCESS_UID_CHOWN)
        {
            sprintf(sndbuf,
                "chown: Requires access level %i: Permission denied.",
                ACCESS_UID_CHOWN
            );
            NetSendLiveMessage(condescriptor, sndbuf);
         
            return(-1); 
        }
        /* If object owned by other, allowed to chown from other? */
        else if((xsw_object[con_object_num]->permission.uid >
                ACCESS_UID_CHOWNO)
                 &&
                (xsw_object[object_num]->owner > -1) &&
                (xsw_object[object_num]->owner != con_object_num)
        )
        {
            sprintf(sndbuf,
           "chown: Access level %i: Permission denied, owned by other.",
                ACCESS_UID_CHOWNO
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }

         
        /* Chown object. */
        xsw_object[object_num]->owner = new_owner;

        strncpy(name1, DBGetFormalNameStr(con_object_num), 256);
        name1[255] = '\0';
        strncpy(name2, DBGetFormalNameStr(object_num), 256);
        name2[255] = '\0';
        strncpy(name3, DBGetFormalNameStr(new_owner), 256);
        name3[255] = '\0'; 


        /* Print and log. */
        sprintf(sndbuf,
            "%s: Chowned to %s",
            name2,
            name3
        );
        NetSendLiveMessage(condescriptor, sndbuf);

        sprintf(stringa,
            "%s: Chowned %s to %s",
            name1, name2, name3
        );
        if(sysparm.log_general == 1)
            LogAppendLineFormatted(fname.primary_log, stringa);


        return(0);
}
