//
// pov file for rendering all players in all animations
//
// Program XBLAST V2.6 or higher
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
#include "colors.inc"
#include "textures.inc"

#declare myClock = int((4 * 5 * 4  - 1)* clock + 0.5)
#warning concat("Internal Clock: ",str(myClock,4,3),"\n")
// - 4 shots of each animation A,B,C,D
// - 5 : 1 animation frame standing
//       4 animation frames walking
// - 4 angles

#declare frameClock = mod(div(myClock,4),5)

#if (frameClock != 0)
  #declare wclock = (frameClock-1)/4.0
  #warning concat("Walk Clock: ",str(wclock,4,3),"\n")
  include "Walk Straight.inc"
#end

#declare angleClock = mod(div(myClock,20),4)

#declare playerClock = mod(myClock,4)

#switch (playerClock)
  #case (0)
    #include "Player A.inc"
  #break
  #case (1)
    #include "Player B.inc"
  #break
  #case (2)
    #include "Player C.inc"
  #break
  #case (3)
    #include "Player D.inc"
  #break
#end

object {Player rotate y*angleClock*90 translate z*-2.667}

// draw floor
plane {
  y, 0
  #if (mod(myClock,4) != 3)
    pigment {color rgb <0.333,0.333,0.333>}
  #else
    pigment {color rgb <1,1,1>}
  #end
  finish {ambient 0.0 diffuse 1.0}
}

// background (sky) color
background {color SkyBlue}


// light source
light_source {
  <-100,500,-250>
  color rgb <1.2,1.2,1.2>
}

// camera
#declare Entf = 500.0
camera
{
  location  <0, 0, -Entf>
  direction <0, 0,  Entf>
  up        6.0*y
  right     4.0*x
  look_at   <0.0, 0.0, 0.0>
  rotate x*48.60
}


