/* utils.c:
 * helper routines that dont really belong anywhere else
 */


#include <stdio.h>

#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xfuncs.h>

#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <errno.h>

#include "defs.h"
#include "externs.h"

/* Is a widget "mapped'? */
/* We need this because we do our own popupshell type management */
/* and we also try to handle WM_DELETE messages elegantly */
Boolean isMapped(Widget w){
	XWindowAttributes wattrs;
	XWindowAttributes *wptr=&wattrs;
	Window win;

	if(w==NULL)
		return False;

	win=XtWindow(w);
	if(win==0)
		return False;
	
	XGetWindowAttributes(display, win, wptr);

	if( (wptr->map_state)==IsUnmapped){
		return False;
	} else {
		return True;
	}
}

/* return 1 if a pipe, 0 if not */
int isapipe(FILE *fp){
	struct stat statbuf;
	int fd = fileno(fp);
	if(fstat(fd, &statbuf)==0){
		switch(errno){
		   case ENOENT:
			return 1;/* pipe, under solaris */
		   default:
			/* until I hear otherwise, I'll assume any OTHER
			 * kind of error is also meaning "pipe"
			 */
			return 1;
		}
	}

	return 0;
}

/* Generic Beep routine that we can call from anywhere.
 * This way we don't have to check for enabled bell every time in the code.
 * We can just put Beep() whereever we feel like it.
 */
void Beep(){
	if(doBell)
		XBell(display,100);
}

/* Since there is no standard util to convert hex ascii to int,...
 *  have to supply our own..
 *  It isn't incredibly efficient.. let's hope the compiler is smart.
 *  only used in readstructs()
 */
int xtoi(char * s)
{
	int out=0;
	sscanf(s,"%x",&out);
	return out;
}

/* nextword:
 *	Goes to first whitespace, then sets pointer to
 *	beginning of non-white-space.
 *
 *	Returns 1 on success, 0 on fail
 */
int nextword(unsigned char **stringp)
{
	while(!isspace(**stringp)){
		if(stringp == '\0')
			return 0;
		*stringp +=1;
	}
	/* now on space */
	while(isspace(**stringp)){
		if(stringp == '\0')
			return 0;
		*stringp +=1;
	}
	return 1;
	
}

/* nextchar:
 * returns pointer to next non-whitespace char
*/
unsigned char *nextchar(unsigned char *c)
{
	while(isspace(*c)){
		if(*c == '\0') break;
		c++;
	}
	return c;
}

XChar2b *dup_16(XChar2b *kanabuffer){
	int pronun_len;
	XChar2b *ret_str;
	
	pronun_len = strlen((char *) kanabuffer);

	ret_str = (XChar2b *) malloc(sizeof(char) * (pronun_len+4));
	if(ret_str== NULL){
		fprintf(stderr,"Not enough memory to read in dictionary\n");
		exit(0);
	}
	bcopy(kanabuffer, ret_str, sizeof(char) * (pronun_len+1));
	return ret_str;
}


/* random debugging util? */
void printline(unsigned char *s)
{
	while(*s){
		putchar(*s++);
	}
	putchar('\n');
}

FILE * open_compressed(char *dictname){
	FILE *fp;
	char command_string[100];
	int namelen;/* length of filename, and flag */
	int extlen;

	if(access(dictname,R_OK)!= 0){
		return NULL;
	}

#ifdef UNCOMPRESS
	namelen = strlen(dictname);
	extlen = strlen(UNCOMPRESSEXT);
	if(strncmp(&dictname[namelen-extlen],UNCOMPRESSEXT,extlen) != 0 ){
		namelen = 0;/* flag for later on */
		fp = fopen(dictname,"r");
	} else {
		sprintf(command_string,"%s %s",UNCOMPRESS,dictname);
		fp = (FILE *) popen(command_string,"r");
	}
#else
	fp = fopen(dictname,"r");
#endif /* UNCOMPRESS */
	if(fp == NULL){
		perror("Cannot open translation file");
		fprintf(stderr,"We were attempting to open %s\n",dictname);
#ifdef UNCOMPRESS
		if(namelen >0)
			fprintf(stderr,"Using uncompression method \"%s\"\n",
				UNCOMPRESS);
#endif
		return NULL;
	}
	return fp;

}



TRANSLATION FindField(TRANSLATION startK,
		      Boolean (*testfunc )(TRANSLATION,void *),
		      void * funcdata)
{


	/*static TRANSLATION startpoint= NULL;
	 * in case we later want
	 * to use this..
	 */

	TRANSLATION checkpoint;


	checkpoint = translations[lowestkanji];

	while(checkpoint != NULL) {
		if(testfunc(checkpoint,funcdata)){
			break;
		}
		checkpoint = checkpoint->nextk;
	}
	

	return checkpoint;
}




/*
 * FindIndex:
 *
 *  Given ascii string represending index, find actual JIS index.
 *
 *	Has to handle special prefixes:
 *
 *	0x == hex index
 *	U  == Unicode index		(in HEX )
 *	N  == Nelson dictionary index	(in DEC )
 *	H  == Halpern dictionary index    (in DEC )
 *
 *	Should set user status message on faliure
 */

int FindIndex(char *str){
	char statusmsg[100];  /* This gets seeded with potential
				* error messages, even if error does not
				* happen
				*/
				
	int retval=0;
	int tempval,findit;


	sprintf(statusmsg,"Could not find index");


	switch (str[0]){
		case '0':
			if(strncmp(str,"0x",2) == 0){
				sprintf(statusmsg,"Could not find hexadecimal index");
				retval = xtoi(&str[2]);
			}
			else
				retval = atoi(str);
 			break;
		case 'H':
			sprintf(statusmsg,"Could not find H index");
			tempval = atoi(&str[1]);
			retval = 0;
			if(tempval == 0)
				break;
			for(findit =lowestkanji;findit<highestkanji;findit++){
				if(translations[findit] == NULL)
					continue;
				if(translations[findit]->Hindex == tempval){
					retval = findit;
					break;
				}
			}
			break;
		case 'N':
			sprintf(statusmsg,"Could not find N index");
			tempval = atoi(&str[1]);
			retval = 0;
			if(tempval == 0)
				break;
			for(findit =lowestkanji;findit<highestkanji;findit++){
				if(translations[findit] == NULL)
					continue;
				if(translations[findit]->Nindex == tempval){
					retval = findit;
					break;
				}
			}
			break;
		case 'U':
			sprintf(statusmsg,"Could not find U index");
			tempval = xtoi(&str[1]);
			retval = 0;
			if(tempval == 0)
				break;
			for(findit =lowestkanji;findit<highestkanji;findit++){
				if(translations[findit] == NULL)
					continue;
				if(translations[findit]->Uindex == tempval){
					retval = findit;
					break;
				}
			}
			break;

		default:
			retval = atoi(str);
			break;
	}
	if(retval == 0){
		setstatus(statusmsg);
		Beep();
	}

	return retval;
}
