/* Groundhog -- a simple logic game
 * Copyright (C) 1998-1999 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "tube.h"
#include "tube_pair.h"

#include "tube_left.xpm"
#include "tube_right.xpm"

TubePair::TubePair(GtkWidget* table, int row, int col) 
   : _right_pair(0), _bottom_pair(0)
{
   _direction = TubePair::Right;
   _left_tube = _upper_tube = new Tube(Tube::Right);
   _right_tube = _lower_tube = new Tube(Tube::Right);

   /* now for the pixmap from gdk */
   GtkWidget* button = gtk_button_new();

   GtkStyle* style = gtk_widget_get_style(button);
   GdkBitmap* mask;
   
   _left_pixmap = 
      gdk_pixmap_create_from_xpm_d(table->window, &mask,
				   &style->bg[GTK_STATE_NORMAL],
				   tube_left_xpm);

   _right_pixmap = 
      gdk_pixmap_create_from_xpm_d(table->window, &mask,
				   &style->bg[GTK_STATE_NORMAL],
				   tube_right_xpm);
   
   /* a pixmap widget to contain the pixmap */
   _pixmapwid = gtk_pixmap_new(_right_pixmap, mask);
   gtk_widget_show(_pixmapwid);

   /* a button to contain the pixmap widget */
   gtk_container_add(GTK_CONTAINER(button), _pixmapwid);
   
   gtk_table_attach_defaults(GTK_TABLE(table), button, col, col + 1, 
			     row, row + 1);

   gtk_signal_connect(GTK_OBJECT(button), "clicked",
		      GTK_SIGNAL_FUNC(&TubePair::Toggle), (gpointer) this);

   gtk_widget_show(button);
}

void
TubePair::Toggle(GtkWidget *widget, gpointer data)
{
   ((TubePair*) data)->ToggleDirection();
}

void
TubePair::ConnectLeft(TubePair* pair)
{
   pair->ConnectRight(_left_tube);
}

void
TubePair::ConnectLeft(Element* element)
{
   _left_tube->ConnectLeft(element);
   element->ConnectRight(_left_tube);
}

void
TubePair::ConnectTop(TubePair* pair)
{
   pair->ConnectBottom(_upper_tube);
}

void
TubePair::ConnectTop(Element* element)
{
   _upper_tube->ConnectTop(element);
   element->ConnectBottom(_upper_tube);
}

void
TubePair::ConnectRight(TubePair* pair)
{
   pair->ConnectLeft(_right_tube);
   _right_pair = pair;
}

void
TubePair::ConnectRight(Element* element)
{
   _right_tube->ConnectRight(element);
   element->ConnectLeft(_right_tube);
}

void
TubePair::ConnectBottom(TubePair* pair)
{
   pair->ConnectTop(_lower_tube);
   _bottom_pair = pair;
}

void
TubePair::ConnectBottom(Element* element)
{
   _lower_tube->ConnectBottom(element);
   element->ConnectTop(_lower_tube);
}

void
TubePair::ToggleDirection()
{
   Element* left_element;
   Element* top_element;
   Element* right_element;
   Element* bottom_element;
   
   _upper_tube->ToggleDirection();
   _lower_tube->ToggleDirection();
   
   if (_direction == TubePair::Right) {
      left_element = _upper_tube->GetStart();
      top_element = _upper_tube->GetEnd();
      right_element = _lower_tube->GetEnd();
      bottom_element = _lower_tube->GetStart();
      _left_tube = _lower_tube;
      _right_tube = _upper_tube;
      _direction = TubePair::Left;
      gtk_pixmap_set(GTK_PIXMAP(_pixmapwid), _left_pixmap, 0);
   } else {
      left_element = _lower_tube->GetStart();
      top_element = _upper_tube->GetStart();
      right_element = _upper_tube->GetEnd();
      bottom_element = _lower_tube->GetEnd();
      _left_tube = _upper_tube;
      _right_tube = _lower_tube;
      _direction = TubePair::Right;
      gtk_pixmap_set(GTK_PIXMAP(_pixmapwid), _right_pixmap, 0);
   }
   ConnectLeft(left_element);
   ConnectTop(top_element);
   ConnectRight(right_element);
   ConnectBottom(bottom_element);
}

void
SetOffTubePairs::Shuffle()
{
   for (list<TubePair*>::iterator i = _set.begin(); i != _set.end(); i++)
      if (rand() % 2)
	 (*i)->ToggleDirection();
}
