/* Groundhog -- a simple logic game
 * Copyright (C) 1998 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "highscore_dialog.h"
#include "highscore_tab.h"

HighScoreDialog::HighScoreDialog()
{
   SetTitle("High scores");

   _notebook = gtk_notebook_new();
   gtk_container_border_width(GTK_CONTAINER(_notebook), 10);
   gtk_notebook_set_tab_pos (GTK_NOTEBOOK(_notebook), GTK_POS_TOP);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_window)->vbox), _notebook, TRUE, 
		      TRUE, 10);

   _beginner = new HighScoreTab(_notebook, "Beginner");
   _intermediate = new HighScoreTab(_notebook, "Intermediate");
   _expert = new HighScoreTab(_notebook, "Expert");

   gtk_widget_show(_notebook);
}

void 
HighScoreDialog::SetHighScore(HighScore& high_score)
{
   _beginner->Fill(high_score.Beginner());
   _intermediate->Fill(high_score.Intermediate());
   _expert->Fill(high_score.Expert());
}


