// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PortList.cc,v 1.2 1999/03/09 20:55:55 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_PortList.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_ComponentDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "set.hh"

IIRScram_PortList::~IIRScram_PortList() {}


void 
IIRScram_PortList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_SignalInterfaceDeclaration* i;
  for (i = first(); i != NULL; ) {
    _vhdl_out << "  ";
    i->_publish_vhdl_decl(_vhdl_out);
    i = successor(i);
    if(i != NULL) {
      _vhdl_out << ";\n";
    }
  }
}


void
IIRScram_PortList::_publish_cc_elaborate() {
 IIR_SignalInterfaceDeclaration* i;
 for (i = first(); i != NULL; ) {
   i->get_subtype()->_publish_cc_type_name();
   _cc_out << " ";
   i->_publish_cc_elaborate();
   _cc_out << ";\n";
   
   if( i->_get_implicit_declarations() != NULL &&
       i->_get_implicit_declarations()->num_elements() != 0) {
     IIR_Declaration* imp_decl = i->_get_implicit_declarations()->get_element();
     while(imp_decl != NULL) {
       if(imp_decl->get_kind() == IIR_SIGNAL_DECLARATION) {
	 ((IIR_SignalDeclaration*)imp_decl)->get_subtype()->_publish_cc_type_name();
	 _cc_out << " ";
	 (imp_decl)->_publish_cc_elaborate();
	 _cc_out << ";\n";
       }
       imp_decl = i->_get_implicit_declarations()->get_next_element();
     }     
   }
   
   i = successor(i);
 } 
}

void
IIRScram_PortList::_publish_cc_port_init() {
  IIR_SignalInterfaceDeclaration* i;
  for (i = first(); i != NULL; ) {
    i->_publish_cc_elaborate();
    _cc_out << "(ObjectBase::SIGNAL_NETINFO";
    if(i->get_subtype()->_is_array_type() == TRUE && 
       i->get_subtype()->_is_anonymous() == TRUE) {
      _cc_out << ", ";
      i->get_subtype()->_publish_cc_range();
    }
    _cc_out << ")";
    
    if( i->_get_implicit_declarations() != NULL &&
	i->_get_implicit_declarations()->num_elements() != 0) {
      IIR_Declaration* imp_decl = i->_get_implicit_declarations()->get_element();
      while(imp_decl != NULL) {
	if(imp_decl->get_kind() == IIR_SIGNAL_DECLARATION) {
	  _cc_out << ",\n";
	  (imp_decl)->_publish_cc_elaborate();
	  _cc_out << "(ObjectBase::SIGNAL_NETINFO";
	  if(((IIR_SignalDeclaration*)imp_decl)->get_subtype()->_is_array_type()) {
	    _cc_out << ", ";
	    ((IIR_SignalDeclaration*)imp_decl)->get_subtype()->_publish_cc_range();
	  }
	  _cc_out << ")";
	}
	imp_decl = i->_get_implicit_declarations()->get_next_element();
      }     
    }
    i = successor(i);
    if(i != NULL) {
      _cc_out << ",\n";
    }
  } 
}

void
IIRScram_PortList::_publish_cc_port_map_aspect() {
  ASSERT (_current_publish_node->_is_component_decl() == TRUE);
  IIR_SignalInterfaceDeclaration *local_clause = ((IIR_ComponentDeclaration*)_current_publish_node)->local_port_clause.first();
  IIR_SignalInterfaceDeclaration *actual_clause = first();
  for(; local_clause != NULL; ) {
    //       switch(local_clause->get_mode()) {
    //       case IIR_IN_MODE:
    //       case IIR_INOUT_MODE:
    _cc_out << "Add(";
    _cc_out << _current_elab_name;
    local_clause->_publish_cc_elaborate();
    _cc_out << ", ";
    
    ///### Temporary Fix
      if(actual_clause != NULL) {
	_cc_out << "((";
	actual_clause->_get_declarative_region()->_publish_cc_binding_name();
	_cc_out << "_elab *)" << _current_elab_name << "boundedEntity)->";
	actual_clause->_publish_cc_elaborate();
      }
      _cc_out << ");\n";
      
      if((local_clause->get_mode() == IIR_OUT_MODE) || 
	 (local_clause->get_mode() == IIR_INOUT_MODE)) {
	_cc_out << "addChild(";
	_cc_out << _current_elab_name;
	local_clause->_publish_cc_elaborate();
	_cc_out << ", ";
	///### Temporary Fix
	  if(actual_clause != NULL) {
	    _cc_out << "((";
	    actual_clause->_get_declarative_region()->_publish_cc_binding_name();
	    _cc_out << "_elab *)" << _current_elab_name << "boundedEntity)->";
	    actual_clause->_publish_cc_elaborate();
	  }
	  _cc_out << ");\n";
      }
      // 	break; 
      //       }
      local_clause = ((IIR_ComponentDeclaration*)_current_publish_node)->local_port_clause.successor((IIR_SignalInterfaceDeclaration*)local_clause);
      actual_clause = successor(actual_clause);
  }  
}

