// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConstantInterfaceDeclaration.cc,v 1.2 1999/03/09 20:53:49 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include <strstream.h>
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "symbol_table.hh"
#include "error_func.hh"

IIRScram_ConstantInterfaceDeclaration::~IIRScram_ConstantInterfaceDeclaration()
{ }


void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_type_name() {
  get_subtype()->_publish_cc_type_name();
}


void 
IIRScram_ConstantInterfaceDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  //  ASSERT(get_mode() == IIR_IN_MODE);
  ASSERT(get_declarator()->get_kind() == IIR_IDENTIFIER);
  
  _vhdl_out << "constant ";
  IIRScram_ObjectDeclaration::_publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_mode(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);
  _publish_vhdl_expression(_vhdl_out);
}


void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_decl() {
  ASSERT(get_mode() == IIR_IN_MODE);

  get_subtype()->_publish_cc_type_name();
  _cc_out << " ";
  _get_declarator()->_publish_cc();
  _cc_out << " = ";
  if (get_value() != NULL) {
    get_value()->_publish_cc();
  } 
  else {
    get_subtype()->_publish_cc_init_val();
  }
}


// void 
// IIRScram_ConstantInterfaceDeclaration::_publish_cc_decl_subprogram_arg() {
//   ASSERT(get_mode() == IIR_IN_MODE);

//   get_subtype()->_publish_cc_type_name();
//   _cc_out << " &";
//   _get_declarator()->_publish_cc();
//   if (get_value() != NULL) {
//     _cc_out << " = ";
//     get_value()->_publish_cc();
//   }
// }


void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_elaborate() {
  if(_get_currently_publishing_unit() == IIRScram::ENTITY_DECL) {
    _cc_out << "#include \"";
    get_subtype()->_publish_cc_elaborate();
    _cc_out << ".hh\"\n";
    _cc_out << "  extern ";
  }
  
  get_subtype()->_publish_cc_elaborate();
  _cc_out << " ";
  _get_declarator()->_publish_cc_elaborate();
  _cc_out << "_info;\n" << endl;
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_elaborate_as_pointers(IIR_Boolean publishDefinition) {
  
  if (publishDefinition == FALSE) {
    _cc_out << "  extern ";
  }
  
  get_subtype()->_publish_cc_elaborate();
  _cc_out << "* ";
  _get_declarator()->_publish_cc_elaborate();
  _cc_out << "_info;\n" << endl;
}

IIRScram_Declaration::declaration_type 
IIRScram_ConstantInterfaceDeclaration::_get_type() {
  return INTERFACE_CONSTANT;
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_initialization_value()
{
  _publish_cc();
}

void 
IIRScram_ConstantInterfaceDeclaration::_publish_cc_universal_value()
{
  _cc_out << "((";
  _publish_cc_universal_type();
  _cc_out << " &)";
  _publish_cc();
  _cc_out << ".getVHDLData()).val";
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc() {
  ASSERT(get_declarator()->get_kind() == IIR_IDENTIFIER);
  
  if(_is_currently_publishing_subprogram() == TRUE) {
    if ((_get_declarative_region() != NULL) &&
	(_get_declarative_region()->get_kind() == IIR_ENTITY_DECLARATION)) {
      _cc_out << "*";
      _get_declarator()->_publish_cc();
      _cc_out << "_info";
    }
    else {
      _get_declarator()->_publish_cc();
    }
  } else {
    if ((_get_currently_publishing_unit() == PROCESS_STATE) || 
	(_get_currently_publishing_unit() == PROCESS) || 
	(_get_currently_publishing_unit() == IIRScram::TYPE) ||
	(_get_currently_publishing_unit() == ARCHITECTURE_DECL) ||
	(_get_currently_publishing_unit() == ENTITY_DECL)) {
      _cc_out << "(*";
    }
    else {
      _publish_cc_prefix_string();
    }
    
    _get_declarator()->_publish_cc_elaborate();
    _cc_out << "_info";
    
    if ((_get_currently_publishing_unit() == PROCESS_STATE) || 
	(_get_currently_publishing_unit() == PROCESS) || 
	(_get_currently_publishing_unit() == IIRScram::TYPE) ||
	(_get_currently_publishing_unit() == ARCHITECTURE_DECL) ||
	(_get_currently_publishing_unit() == ENTITY_DECL)) {
      _cc_out << ")";
    }
  }
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_headers() {
  _cc_out << "#include \"";
  get_subtype()->_publish_cc_type_name();
  _cc_out << ".hh\"\n";
  get_subtype()->_publish_cc_headers();

  if (_get_currently_publishing_unit() == IIRScram::TYPE) {
    if (_get_declarative_region()->get_kind() == IIR_ENTITY_DECLARATION) {
      _cc_out << "#include \"";
      _get_declarative_region()->_get_declarator()->_publish_cc();
      _cc_out << "_decls.hh\"\n";
    }
  }
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_object_type() {
  _cc_out << "VARIABLE";
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_state_object_init() {
  // Initialization not done for access types.
  //   if(get_subtype()->get_kind() == IIR_ACCESS_TYPE_DEFINITION ||
  //      get_subtype()->get_kind() == IIR_ACCESS_SUBTYPE_DEFINITION) {
  //     return;
  //   }

  //   _get_declarator()->_publish_cc();
  //   _cc_out << "(";
  //   _publish_cc_constructor_args();
  //   if(get_value() != NULL) {
  //     _cc_out << ", ";
  //     get_value()->_publish_cc_initialization_value();
  //   }
  //   _cc_out << "), ";
}

void
IIRScram_ConstantInterfaceDeclaration::_publish_cc_kernel_type() {
  ASSERT ( _get_subtype() != NULL );
  _get_subtype()->_publish_cc_kernel_type();
}


IIR *
IIRScram_ConstantInterfaceDeclaration::_clone() {
  return this;
}

void 
IIRScram_ConstantInterfaceDeclaration::_type_check( IIRScram_InterfaceDeclaration::_InterfaceListType ){
  if( get_subtype()->_is_access_type() == TRUE || get_subtype()->_is_file_type() == TRUE ){
    ostrstream err;
    err << "Constant interface declaration |" << *get_declarator() << "| must have a subtype "
	<< "indication that defines a subtype that is neither an access type or a file type." 
	<< ends;
    report_error( this, err );
  }
  
  IIR_InterfaceDeclaration::_type_check();
}
