
#ifndef IIRBASE_DISCONNECT_SPECIFICATION_HH
#define IIRBASE_DISCONNECT_SPECIFICATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_DisconnectSpecification.hh,v 1.2 1999/03/09 20:49:38 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_Declaration.hh"
#include "IIR_DesignatorList.hh"

class IIR_Name;
class IIR_TypeDefinition;

class IIRBase_DisconnectSpecification : public IIR_Declaration {

public:
  IIR_Kind get_kind() {return IIR_DISCONNECT_SPECIFICATION;}
  IIR_Char *get_kind_text() {return "IIR_DisconnectSpecification";}

  void set_type_mark( IIR_TypeDefinition *type_definition );
  IIR_TypeDefinition *get_type_mark();

  void set_time_expression( IIR* time_expression);
  IIR *get_time_expression();

  IIR_DesignatorList guarded_signal_list;

protected:
  IIRBase_DisconnectSpecification();
  virtual ~IIRBase_DisconnectSpecification() = 0;
    
private:
  IIR_TypeDefinition *my_type_mark;
  IIR *my_time_expression;
};
#endif
