/* gEDA - GNU Electronic Design Automation
 * gschem - GNU Schematic Capture
 * Copyright (C) 1998 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 */

#include <config.h>
#include <gtk/gtk.h>

#include <guile/gh.h>

#include <libgeda/defines.h>
#include <libgeda/struct.h>
#include <libgeda/globals.h>
#include <libgeda/colors.h>
#include <libgeda/prototype.h>

#include "../include/x_states.h"
#include "../include/prototype.h"

void
i_update_status(TOPLEVEL *w_current, char *string)
{
	if (!w_current->status_label) {
		return;
	}

	if (string) {
		w_current->DONT_RESIZE=1;
		gtk_label_set(GTK_LABEL(w_current->status_label),
			      (char *) string);
	}
}

/* HACK: This one allows the expose events to happen. Probably should
 * create one function for both...  Now it's exactly the same as above
 * */
void
i_update_status2(TOPLEVEL *w_current, char *string)
{
	if (string) {
	 	w_current->DONT_RESIZE = 1;
#if 0
		w_current->DONT_EXPOSE = 1;
#endif
		gtk_label_set(GTK_LABEL(w_current->status_label),
			      (char *) string);
	}
}

void
i_update_left_button(char *string)
{
}

void
i_update_middle_button(TOPLEVEL *w_current, void *func_ptr, char *string)
{
	char *temp_string;

	if (func_ptr == NULL) {
		return;
	}

	if (string == NULL) {
		return;
	}	

	if (!w_current->middle_label) {
		return;
	}

	switch(w_current->middle_button) {

		/* remove this case eventually and make it a null case */
		case(ACTION):
			w_current->DONT_RESIZE = 1;
			gtk_label_set(GTK_LABEL(w_current->middle_label),
				      "Action");
			break;

#ifdef HAS_LIBSTROKE
		case(STROKE):
			w_current->DONT_RESIZE = 1;

			gtk_label_set(GTK_LABEL(w_current->middle_label),
				      "Stroke");
			break;
#else 
		/* remove this case eventually and make it a null case */
		case(STROKE):
			w_current->DONT_RESIZE = 1;
			gtk_label_set(GTK_LABEL(w_current->middle_label),
				      "none");
			break;
#endif
		
		case(REPEAT):
			w_current->DONT_RESIZE = 1;

			temp_string = u_basic_strdup_multiple(
				"Repeat/", string, NULL);

			gtk_label_set(GTK_LABEL(w_current->middle_label),
				      temp_string);
			w_current->last_callback = func_ptr;
			free(temp_string);
			break;

	}

}

void
i_update_right_button(char *string)
{
}

void
i_set_filename(TOPLEVEL *w_current, char *string)
{
	char trunc_string[41];
	int len;
	int i;

	if (!w_current->filename_label) {
		return;
	}

	if (string) {
		len = strlen(string);
                w_current->DONT_RESIZE = 1;

		if (w_current->filename_label) {
			if (len > 40) {

				trunc_string[0] = '.';
				trunc_string[1] = '.';
				trunc_string[2] = '.';

				trunc_string[40] = '\0';
				for (i = 39 ; i > 2; i--) {
					if (len >= 0) {
						trunc_string[i] = string[len];
					} else {
						break;
					}
					len--;
				}

	                	gtk_label_set(GTK_LABEL(w_current->
							filename_label),
				      			trunc_string);

			} else {

	                	gtk_label_set(GTK_LABEL(w_current->
							filename_label),
				      			(char *) string);
			}
		}
        }
}
