/*$Id: u_probe.h,v 14.13 1999/08/01 03:34:53 al Exp $ -*- C++ -*-
 * single probe item
 */
#ifndef U_PROBE_H
#define U_PROBE_H
#include "md.h"
#include "l_compar.h" // inorder
/*--------------------------------------------------------------------------*/
class CKT_BASE;
/*--------------------------------------------------------------------------*/
class PROBE {
private:
  std::string	_what;    
  int		_node;
  CKT_BASE*	_brh;
  double	_lo,_hi;
public:
  explicit  PROBE(const std::string& what, int node, double lo=0, double hi=0);
  explicit  PROBE(const std::string& what, CKT_BASE *brh,
		  double lo=0, double hi=0);
	    PROBE(const PROBE& p);
	    ~PROBE()				{detach();}

  void	    set_limit(double lo,double hi)	{_lo = lo; _hi = hi;}
  void	    detach();
  PROBE&    operator=(const PROBE& p);

  bool      operator<(const PROBE&)const;
  bool	    operator==(const PROBE&)const;
  bool	    operator!=(const PROBE& p)const	{return !(*this == p);}
  
  const std::string label()const;
  double	  value()const;
  const CKT_BASE* object()const	{return _brh;}
  double	  lo()const	{return _lo;}
  double	  hi()const	{return _hi;}
  double	  range()const	{return hi()-lo();}
  bool		  inrange()const{return inorder(lo(),value(),hi());}
private:
  double	  probe_node()const;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
