/*$Id: d_vcvs.h,v 15.11 1999/10/14 07:46:49 al Exp $ -*- C++ -*-
 * voltage controled voltage source
 */
#ifndef D_VCVS_H
#define D_VCVS_H
#include "e_vcsrc.h"
/*--------------------------------------------------------------------------*/
class DEV_VCVS : public VCSRC_BASE {
private:
  explicit DEV_VCVS(const DEV_VCVS& p) :VCSRC_BASE(p) {}
public:
  explicit DEV_VCVS()		:VCSRC_BASE() {}
private: // override virtual
  const char* dev_type()const	{return "vcvs";}
  CARD*	   clone()const		{return new DEV_VCVS(*this);}
  //void   parse(CS&);		//ELEMENT
  //void   print(OMSTREAM,int)const; //ELEMENT
  //void   expand();		//CARD/nothing
  void	   precalc();

  void	   dc_begin();
  void	   tr_begin()		{dc_begin();}
  void	   tr_restore()		{dc_begin();}
  //void   dc_advance();	//CARD/nothing
  //void   tr_advance();	//CARD/nothing
  //bool   tr_needs_eval();	//ELEMENT
  //void   tr_queue_eval();	//ELEMENT
  bool	   do_tr();
  void	   tr_load()		{tr_load_loss(); tr_load_active();}
  //double tr_review();		//CARD/nothing
  //void   tr_accept();		//CARD/nothing
  //void   tr_unload();		//VCSRC_BASE
  //double tr_involts()const;	//VCSRC_BASE

  void	    ac_begin()	{loss=1./OPT::shortckt; ev=y0.f1; acg=-loss*ev;}
  void	    do_ac();
  //COMPLEX ac_involts()const;	//VCSRC_BASE
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
