#   include	<bitmap.h>

/************************************************************************/
/*  Types of scanners.							*/
/************************************************************************/
#   define	SCANtyHPSCL		0
#   define	SCANtySCSI		1

/************************************************************************/
/*  Description of a scanner data format.				*/
/************************************************************************/

typedef	struct ScannerDataFormat
    {
    int		sdfFormat;
    int		sdfBitsPerPixel;
    char *	sdfDescription;
    int		sdfPreviewFormat;
    } ScannerDataFormat;

/************************************************************************/
/*  Description of the 'mode' of a scanner.				*/
/************************************************************************/
typedef struct ScannerMode
    {
    int		smDataFormat;		/*  Index in ScannerDefinition	*/
    int		smXResolution;
    int		smYResolution;
    int		smContrast;
    int		smIntensity;

    int		smX;
    int		smY;
    int		smWide;
    int		smHigh;
    } ScannerMode;

/************************************************************************/
/*									*/
/*  Description of a scanner.						*/
/*									*/
/************************************************************************/

typedef	struct ScannerDefinition
    {
    int		sdKind;			/* SCSI,HPSCL &c		*/
    int		(*sdConfigure)(	int				fd,
				int				target,
				struct ScannerDefinition *	sd );
					/* E.G. Determine size.		*/

    int		sdDevice;		/* like file descriptor		*/
    int		sdTarget;		/* like scsi target.		*/
    char	sdDeviceName[100];

    int		sdMetricUnit;		/* mm, inch etc.		*/
    int		sdDevicePerMetric;	/* device units/metric unit.	*/

    int		sdXMinimumResolution;	/* X Minimum resolution.	*/
    int		sdXMaximumResolution;	/* X Maximum resolution.	*/
    int		sdXOpticalResolution;	/* X Optical resolution.	*/
    int		sdXDefaultResolution;	/* X Default resolution.	*/

    int		sdYMinimumResolution;	/* Y Minimum resolution.	*/
    int		sdYMaximumResolution;	/* Y Maximum resolution.	*/
    int		sdYOpticalResolution;	/* Y Optical resolution.	*/
    int		sdYDefaultResolution;	/* Y Default resolution.	*/

    int		sdMinimumContrast;	/* Minimum contrast.		*/
    int		sdMaximumContrast;	/* Maximum contrast.		*/
    int		sdDefaultContrast;	/* Default contrast.		*/

    int		sdMinimumIntensity;	/* Minimum intensity.		*/
    int		sdMaximumIntensity;	/* Maximum intensity.		*/
    int		sdDefaultIntensity;	/* Default intensity.		*/

    int		sdHorizontalSize;	/* Horizontal Device geometry!	*/
    int		sdVerticalSize;		/* Vertical   Device geometry!	*/

    ScannerDataFormat *
		sdDataFormats;		/* Data Formats supported.	*/
    int		sdNumberOfDataFormats;	/* Number of Data Formats.	*/
    int		sdDefaultDataFormat;	/* Default data format.		*/

    char	sdDescription[40];	/* Description for external use */

    ScannerMode	sdCurrentMode;		/* Current Data Format &c.	*/
    ScannerMode	sdApplicationMode;	/* Scratch for application.	*/
    } ScannerDefinition;

/************************************************************************/
/*  Scan commands.							*/
/************************************************************************/
extern int	scanResetScanner( int fd, const ScannerDefinition * sd );
extern int	scanLightSourceTest( int fd, const ScannerDefinition * sd,
					int on_off );
extern int	scanFindScanners( ScannerDefinition * sd );
extern int	scanOpenScanner( const ScannerDefinition * sd );
extern int	scanCloseScanner( int fd, const ScannerDefinition * sd );
extern void	scanSetDefaults( const ScannerDefinition * sd,
					ScannerMode * sm );
extern int	scanSetDataFormat( int fd, ScannerDefinition * sd,
					int dataFormat );
extern int	scanSetXResolution( int fd, ScannerDefinition * sd,
					int xResolution );
extern int	scanSetYResolution( int fd, ScannerDefinition * sd,
					int yResolution );
extern int	scanSetContrast( int fd, ScannerDefinition * sd,
					int contrast );
extern int	scanSetIntensity( int fd, ScannerDefinition * sd,
					int intensity );
extern int	scanDescribeBitmap(	BitmapDescription * bd,
					const ScannerDefinition * sd,
					int fd				);
extern int	scanScanWindow(	int				fd,
				const ScannerDefinition *	sd,
				const BitmapDescription *	bd,
				unsigned char *			buffer	);

extern unsigned char * scanScanRectangle(	int			fd,
						int			x,
						int			y,
						int			wide,
						int			high,
						BitmapDescription *	bd,
						ScannerDefinition *	sd,
						ScannerMode *		sm );
