/************************************************************************/
/*  Utility functions for printing.					*/
/************************************************************************/

#   include	"config.h"

#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<string.h>

#   include	"utilPrinter.h"

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Find out what printers are available on the system.			*/
/*									*/
/*  1)  BSD/Linux style.						*/
/*  2)  SysV style.							*/
/*									*/
/************************************************************************/

static int utilPrinterGetLprPrinters(	const char *		command,
					char *			scratch,
					int *			pPrinterCount,
					PrintDestination **	pDestinations )
    {
    int				l;
    FILE *			f;
    int				found= 0;

    PrintDestination *		pd= *pDestinations;
    int				count= *pPrinterCount;

    f= popen( command, "r" );

    if  ( ! f )
	{ return 0;	}

    while( fgets( scratch, 250, f ) )
	{
	l= strlen( scratch );
	if  ( l > 0 && scratch[l-1] == '\n' )
	    { scratch[l-1]= '\0';	}

	if  ( scratch[0] == '\t' || scratch[l-2] != ':' )
	    { continue;	}

	scratch[l-2]= '\0';

	pd= (PrintDestination *)realloc( pd, (count+ 1)*sizeof( PrintDestination ) );
	if  ( ! pd )
	    { XDEB(pd); return -1;	}
	*pDestinations= pd;

	pd[count].pdCommand= (char *)malloc( l+ 23 );
	if  ( ! pd[count].pdCommand )
	    { LXDEB(l,pd[count].pdCommand); return -1;	}
#	if 0
	Has the advantage that there is no maximum on the filesize.
	Has the disadvantage that it does not work on SuSE Linux 6.0
	sprintf( pd[count].pdCommand, "lpr -r -s -P '%s' '%s'",
							scratch, "%s" );
#	else
	sprintf( pd[count].pdCommand, "lpr -r -P '%s' '%s'",
							scratch, "%s" );
#	endif
	pd[count].pdPrintKind= APPprinterTMPFILE;
	pd[count].pdPrinterName= (char *)malloc( l+ 1 );
	if  ( ! pd[count].pdPrinterName )
	    { LXDEB(l,pd[count].pdPrinterName); return -1;	}

	strcpy( pd[count].pdPrinterName, scratch );

	found++; count++;
	}

    pclose( f );

    *pPrinterCount= count;

    return found;
    }

int utilPrinterGetPrinters(	int *			pPrinterCount,
				int *			pDefaultPrinter,
				PrintDestination **	pDestinations )
    {
    PrintDestination *		pd= (PrintDestination *)0;
    int				count= 0;
    int				defaultPrinter= -1;
    char *			defaultPrinterName= (char *)0;

    FILE *			f;
    char			scratch[250+1];
    int				l;

    char *			s;

    /*  1  */
    if  ( utilPrinterGetLprPrinters(  "( lpc status ) 2>/dev/null",
					    scratch, &count, &pd ) < 1	&&
	  utilPrinterGetLprPrinters(  "( /usr/sbin/lpc status ) 2>/dev/null",
					    scratch, &count, &pd ) < 1	)
	{ /* nothing.. sys5? */;	}

    /*  2  */
    f= popen( "( lpstat -a ) 2>/dev/null", "r" );
    if  ( f )
	{
	char *	firstLpPrinter= (char *)0;

	while( fgets( scratch, 250, f ) )
	    {
	    s= strchr( scratch, ' ' );
	    if  ( ! s )
		{ continue;	}
	    *s= '\0'; l= s- scratch;

	    pd= (PrintDestination *)realloc( pd, (count+ 1)*sizeof( PrintDestination ) );
	    if  ( ! pd )
		{ XDEB(pd); return -1;	}

	    pd[count].pdCommand= (char *)malloc( l+ 12 );
	    if  ( ! pd[count].pdCommand )
		{ LXDEB(l,pd[count].pdCommand); return -1;	}
	    sprintf( pd[count].pdCommand, "lp -s -d '%s'", scratch );
	    pd[count].pdPrintKind= APPprinterPIPE;
	    pd[count].pdPrinterName= (char *)malloc( l+ 1 );
	    if  ( ! pd[count].pdPrinterName )
		{ LXDEB(l,pd[count].pdPrinterName); return -1;	}

	    strcpy( pd[count].pdPrinterName, scratch );
	    if  ( ! firstLpPrinter )
		{ firstLpPrinter= pd[count].pdPrinterName;	}

	    count++;
	    }

	pclose( f );

	defaultPrinterName= getenv( "LPDEST" );
	if  ( ! defaultPrinterName )
	    { defaultPrinterName= firstLpPrinter;	}
	}

    if  ( defaultPrinterName )
	{
	for ( l= 0; l < count; l++ )
	    {
	    if  ( ! strcmp( defaultPrinterName, pd[l].pdPrinterName ) )
		{ defaultPrinter= l; break;	}
	    }
	}

    *pPrinterCount= count;
    *pDefaultPrinter= defaultPrinter;
    *pDestinations= pd;

    return 0;
    }
