; -*- coding: iso-2022-7bit  -*-
;;; uksc5601.el --- tables between UCS and KS C 5601-1987

;; Author: Lori Hoerth <lorih@microsoft.com>
;;         K.D.Chang   <a-kchang@microsoft.com>

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, KS C 5601

;; This file is part of MULE-UCS.

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; This file is converted from

;;	ftp://ftp.unicode.org/Public/MAPPINGS/EASTASIA/KSC/KSC5601.TXT

;; by MORIOKA Tomohiko <morioka@jaist.ac.jp>.

;;; Code:

(put 'korean-ksc5601 'unicode 'ks-c-5601-1987-vs-unicode-assoc)

(defvar
  ks-c-5601-1987-vs-unicode-assoc
  '(assoc
    (char-1 . ucs-generic)
    ((?$(C!!(B . ?\x3000) ; IDEOGRAPHIC SPACE
     (?$(C!"(B . ?\x3001) ; IDEOGRAPHIC COMMA
     (?$(C!#(B . ?\x3002) ; IDEOGRAPHIC FULL STOP
     (?$(C!$(B . ?\x00B7) ; MIDDLE DOT
     (?$(C!%(B . ?\x2025) ; TWO DOT LEADER
     (?$(C!&(B . ?\x2026) ; HORIZONTAL ELLIPSIS
     (?$(C!'(B . ?\x00A8) ; DIAERESIS
     (?$(C!((B . ?\x3003) ; DITTO MARK
     (?$(C!)(B . ?\x00AD) ; SOFT HYPHEN
     (?$(C!*(B . ?\x2015) ; HORIZONTAL BAR
     (?$(C!+(B . ?\x2225) ; PARALLEL TO
     (?$(C!,(B . ?\xFF3C) ; FULLWIDTH REVERSE SOLIDUS
     (?$(C!-(B . ?\x223C) ; TILDE OPERATOR
     (?$(C!.(B . ?\x2018) ; LEFT SINGLE QUOTATION MARK
     (?$(C!/(B . ?\x2019) ; RIGHT SINGLE QUOTATION MARK
     (?$(C!0(B . ?\x201C) ; LEFT DOUBLE QUOTATION MARK
     (?$(C!1(B . ?\x201D) ; RIGHT DOUBLE QUOTATION MARK
     (?$(C!2(B . ?\x3014) ; LEFT TORTOISE SHELL BRACKET
     (?$(C!3(B . ?\x3015) ; RIGHT TORTOISE SHELL BRACKET
     (?$(C!4(B . ?\x3008) ; LEFT ANGLE BRACKET
     (?$(C!5(B . ?\x3009) ; RIGHT ANGLE BRACKET
     (?$(C!6(B . ?\x300A) ; LEFT DOUBLE ANGLE BRACKET
     (?$(C!7(B . ?\x300B) ; RIGHT DOUBLE ANGLE BRACKET
     (?$(C!8(B . ?\x300C) ; LEFT CORNER BRACKET
     (?$(C!9(B . ?\x300D) ; RIGHT CORNER BRACKET
     (?$(C!:(B . ?\x300E) ; LEFT WHITE CORNER BRACKET
     (?$(C!;(B . ?\x300F) ; RIGHT WHITE CORNER BRACKET
     (?$(C!<(B . ?\x3010) ; LEFT BLACK LENTICULAR BRACKET
     (?$(C!=(B . ?\x3011) ; RIGHT BLACK LENTICULAR BRACKET
     (?$(C!>(B . ?\x00B1) ; PLUS-MINUS SIGN
     (?$(C!?(B . ?\x00D7) ; MULTIPLICATION SIGN
     (?$(C!@(B . ?\x00F7) ; DIVISION SIGN
     (?$(C!A(B . ?\x2260) ; NOT EQUAL TO
     (?$(C!B(B . ?\x2264) ; LESS-THAN OR EQUAL TO
     (?$(C!C(B . ?\x2265) ; GREATER-THAN OR EQUAL TO
     (?$(C!D(B . ?\x221E) ; INFINITY
     (?$(C!E(B . ?\x2234) ; THEREFORE
     (?$(C!F(B . ?\x00B0) ; DEGREE SIGN
     (?$(C!G(B . ?\x2032) ; PRIME
     (?$(C!H(B . ?\x2033) ; DOUBLE PRIME
     (?$(C!I(B . ?\x2103) ; DEGREE CELSIUS
     (?$(C!J(B . ?\x212B) ; ANGSTROM SIGN
     (?$(C!K(B . ?\xFFE0) ; FULLWIDTH CENT SIGN
     (?$(C!L(B . ?\xFFE1) ; FULLWIDTH POUND SIGN
     (?$(C!M(B . ?\xFFE5) ; FULLWIDTH YEN SIGN
     (?$(C!N(B . ?\x2642) ; MALE SIGN
     (?$(C!O(B . ?\x2640) ; FEMALE SIGN
     (?$(C!P(B . ?\x2220) ; ANGLE
     (?$(C!Q(B . ?\x22A5) ; UP TACK
     (?$(C!R(B . ?\x2312) ; ARC
     (?$(C!S(B . ?\x2202) ; PARTIAL DIFFERENTIAL
     (?$(C!T(B . ?\x2207) ; NABLA
     (?$(C!U(B . ?\x2261) ; IDENTICAL TO
     (?$(C!V(B . ?\x2252) ; APPROXIMATELY EQUAL TO OR THE IMAGE OF
     (?$(C!W(B . ?\x00A7) ; SECTION SIGN
     (?$(C!X(B . ?\x203B) ; REFERENCE MARK
     (?$(C!Y(B . ?\x2606) ; WHITE STAR
     (?$(C!Z(B . ?\x2605) ; BLACK STAR
     (?$(C![(B . ?\x25CB) ; WHITE CIRCLE
     (?$(C!\(B . ?\x25CF) ; BLACK CIRCLE
     (?$(C!](B . ?\x25CE) ; BULLSEYE
     (?$(C!^(B . ?\x25C7) ; WHITE DIAMOND
     (?$(C!_(B . ?\x25C6) ; BLACK DIAMOND
     (?$(C!`(B . ?\x25A1) ; WHITE SQUARE
     (?$(C!a(B . ?\x25A0) ; BLACK SQUARE
     (?$(C!b(B . ?\x25B3) ; WHITE UP-POINTING TRIANGLE
     (?$(C!c(B . ?\x25B2) ; BLACK UP-POINTING TRIANGLE
     (?$(C!d(B . ?\x25BD) ; WHITE DOWN-POINTING TRIANGLE
     (?$(C!e(B . ?\x25BC) ; BLACK DOWN-POINTING TRIANGLE
     (?$(C!f(B . ?\x2192) ; RIGHTWARDS ARROW
     (?$(C!g(B . ?\x2190) ; LEFTWARDS ARROW
     (?$(C!h(B . ?\x2191) ; UPWARDS ARROW
     (?$(C!i(B . ?\x2193) ; DOWNWARDS ARROW
     (?$(C!j(B . ?\x2194) ; LEFT RIGHT ARROW
     (?$(C!k(B . ?\x3013) ; GETA MARK
     (?$(C!l(B . ?\x226A) ; MUCH LESS-THAN
     (?$(C!m(B . ?\x226B) ; MUCH GREATER-THAN
     (?$(C!n(B . ?\x221A) ; SQUARE ROOT
     (?$(C!o(B . ?\x223D) ; REVERSED TILDE
     (?$(C!p(B . ?\x221D) ; PROPORTIONAL TO
     (?$(C!q(B . ?\x2235) ; BECAUSE
     (?$(C!r(B . ?\x222B) ; INTEGRAL
     (?$(C!s(B . ?\x222C) ; DOUBLE INTEGRAL
     (?$(C!t(B . ?\x2208) ; ELEMENT OF
     (?$(C!u(B . ?\x220B) ; CONTAINS AS MEMBER
     (?$(C!v(B . ?\x2286) ; SUBSET OF OR EQUAL TO
     (?$(C!w(B . ?\x2287) ; SUPERSET OF OR EQUAL TO
     (?$(C!x(B . ?\x2282) ; SUBSET OF
     (?$(C!y(B . ?\x2283) ; SUPERSET OF
     (?$(C!z(B . ?\x222A) ; UNION
     (?$(C!{(B . ?\x2229) ; INTERSECTION
     (?$(C!|(B . ?\x2227) ; LOGICAL AND
     (?$(C!}(B . ?\x2228) ; LOGICAL OR
     (?$(C!~(B . ?\xFFE2) ; FULLWIDTH NOT SIGN
     (?$(C"!(B . ?\x21D2) ; RIGHTWARDS DOUBLE ARROW
     (?$(C""(B . ?\x21D4) ; LEFT RIGHT DOUBLE ARROW
     (?$(C"#(B . ?\x2200) ; FOR ALL
     (?$(C"$(B . ?\x2203) ; THERE EXISTS
     (?$(C"%(B . ?\x00B4) ; ACUTE ACCENT
     (?$(C"&(B . ?\xFF5E) ; FULLWIDTH TILDE
     (?$(C"'(B . ?\x02C7) ; CARON
     (?$(C"((B . ?\x02D8) ; BREVE
     (?$(C")(B . ?\x02DD) ; DOUBLE ACUTE ACCENT
     (?$(C"*(B . ?\x02DA) ; RING ABOVE
     (?$(C"+(B . ?\x02D9) ; DOT ABOVE
     (?$(C",(B . ?\x00B8) ; CEDILLA
     (?$(C"-(B . ?\x02DB) ; OGONEK
     (?$(C".(B . ?\x00A1) ; INVERTED EXCLAMATION MARK
     (?$(C"/(B . ?\x00BF) ; INVERTED QUESTION MARK
     (?$(C"0(B . ?\x02D0) ; MODIFIER LETTER TRIANGULAR COLON
     (?$(C"1(B . ?\x222E) ; CONTOUR INTEGRAL
     (?$(C"2(B . ?\x2211) ; N-ARY SUMMATION
     (?$(C"3(B . ?\x220F) ; N-ARY PRODUCT
     (?$(C"4(B . ?\x00A4) ; CURRENCY SIGN
     (?$(C"5(B . ?\x2109) ; DEGREE FAHRENHEIT
     (?$(C"6(B . ?\x2030) ; PER MILLE SIGN
     (?$(C"7(B . ?\x25C1) ; WHITE LEFT-POINTING TRIANGLE
     (?$(C"8(B . ?\x25C0) ; BLACK LEFT-POINTING TRIANGLE
     (?$(C"9(B . ?\x25B7) ; WHITE RIGHT-POINTING TRIANGLE
     (?$(C":(B . ?\x25B6) ; BLACK RIGHT-POINTING TRIANGLE
     (?$(C";(B . ?\x2664) ; WHITE SPADE SUIT
     (?$(C"<(B . ?\x2660) ; BLACK SPADE SUIT
     (?$(C"=(B . ?\x2661) ; WHITE HEART SUIT
     (?$(C">(B . ?\x2665) ; BLACK HEART SUIT
     (?$(C"?(B . ?\x2667) ; WHITE CLUB SUIT
     (?$(C"@(B . ?\x2663) ; BLACK CLUB SUIT
     (?$(C"A(B . ?\x2299) ; CIRCLED DOT OPERATOR
     (?$(C"B(B . ?\x25C8) ; WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
     (?$(C"C(B . ?\x25A3) ; WHITE SQUARE CONTAINING BLACK SMALL SQUARE
     (?$(C"D(B . ?\x25D0) ; CIRCLE WITH LEFT HALF BLACK
     (?$(C"E(B . ?\x25D1) ; CIRCLE WITH RIGHT HALF BLACK
     (?$(C"F(B . ?\x2592) ; MEDIUM SHADE
     (?$(C"G(B . ?\x25A4) ; SQUARE WITH HORIZONTAL FILL
     (?$(C"H(B . ?\x25A5) ; SQUARE WITH VERTICAL FILL
     (?$(C"I(B . ?\x25A8) ; SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
     (?$(C"J(B . ?\x25A7) ; SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
     (?$(C"K(B . ?\x25A6) ; SQUARE WITH ORTHOGONAL CROSSHATCH FILL
     (?$(C"L(B . ?\x25A9) ; SQUARE WITH DIAGONAL CROSSHATCH FILL
     (?$(C"M(B . ?\x2668) ; HOT SPRINGS
     (?$(C"N(B . ?\x260F) ; WHITE TELEPHONE
     (?$(C"O(B . ?\x260E) ; BLACK TELEPHONE
     (?$(C"P(B . ?\x261C) ; WHITE LEFT POINTING INDEX
     (?$(C"Q(B . ?\x261E) ; WHITE RIGHT POINTING INDEX
     (?$(C"R(B . ?\x00B6) ; PILCROW SIGN
     (?$(C"S(B . ?\x2020) ; DAGGER
     (?$(C"T(B . ?\x2021) ; DOUBLE DAGGER
     (?$(C"U(B . ?\x2195) ; UP DOWN ARROW
     (?$(C"V(B . ?\x2197) ; NORTH EAST ARROW
     (?$(C"W(B . ?\x2199) ; SOUTH WEST ARROW
     (?$(C"X(B . ?\x2196) ; NORTH WEST ARROW
     (?$(C"Y(B . ?\x2198) ; SOUTH EAST ARROW
     (?$(C"Z(B . ?\x266D) ; MUSIC FLAT SIGN
     (?$(C"[(B . ?\x2669) ; QUARTER NOTE
     (?$(C"\(B . ?\x266A) ; EIGHTH NOTE
     (?$(C"](B . ?\x266C) ; BEAMED SIXTEENTH NOTES
     (?$(C"^(B . ?\x327F) ; KOREAN STANDARD SYMBOL
     (?$(C"_(B . ?\x321C) ; PARENTHESIZED HANGUL CIEUC U
     (?$(C"`(B . ?\x2116) ; NUMERO SIGN
     (?$(C"a(B . ?\x33C7) ; SQUARE CO
     (?$(C"b(B . ?\x2122) ; TRADE MARK SIGN
     (?$(C"c(B . ?\x33C2) ; SQUARE AM
     (?$(C"d(B . ?\x33D8) ; SQUARE PM
     (?$(C"e(B . ?\x2121) ; TELEPHONE SIGN
     (?$(C#!(B . ?\xFF01) ; FULLWIDTH EXCLAMATION MARK
     (?$(C#"(B . ?\xFF02) ; FULLWIDTH QUOTATION MARK
     (?$(C##(B . ?\xFF03) ; FULLWIDTH NUMBER SIGN
     (?$(C#$(B . ?\xFF04) ; FULLWIDTH DOLLAR SIGN
     (?$(C#%(B . ?\xFF05) ; FULLWIDTH PERCENT SIGN
     (?$(C#&(B . ?\xFF06) ; FULLWIDTH AMPERSAND
     (?$(C#'(B . ?\xFF07) ; FULLWIDTH APOSTROPHE
     (?$(C#((B . ?\xFF08) ; FULLWIDTH LEFT PARENTHESIS
     (?$(C#)(B . ?\xFF09) ; FULLWIDTH RIGHT PARENTHESIS
     (?$(C#*(B . ?\xFF0A) ; FULLWIDTH ASTERISK
     (?$(C#+(B . ?\xFF0B) ; FULLWIDTH PLUS SIGN
     (?$(C#,(B . ?\xFF0C) ; FULLWIDTH COMMA
     (?$(C#-(B . ?\xFF0D) ; FULLWIDTH HYPHEN-MINUS
     (?$(C#.(B . ?\xFF0E) ; FULLWIDTH FULL STOP
     (?$(C#/(B . ?\xFF0F) ; FULLWIDTH SOLIDUS
     (?$(C#0(B . ?\xFF10) ; FULLWIDTH DIGIT ZERO
     (?$(C#1(B . ?\xFF11) ; FULLWIDTH DIGIT ONE
     (?$(C#2(B . ?\xFF12) ; FULLWIDTH DIGIT TWO
     (?$(C#3(B . ?\xFF13) ; FULLWIDTH DIGIT THREE
     (?$(C#4(B . ?\xFF14) ; FULLWIDTH DIGIT FOUR
     (?$(C#5(B . ?\xFF15) ; FULLWIDTH DIGIT FIVE
     (?$(C#6(B . ?\xFF16) ; FULLWIDTH DIGIT SIX
     (?$(C#7(B . ?\xFF17) ; FULLWIDTH DIGIT SEVEN
     (?$(C#8(B . ?\xFF18) ; FULLWIDTH DIGIT EIGHT
     (?$(C#9(B . ?\xFF19) ; FULLWIDTH DIGIT NINE
     (?$(C#:(B . ?\xFF1A) ; FULLWIDTH COLON
     (?$(C#;(B . ?\xFF1B) ; FULLWIDTH SEMICOLON
     (?$(C#<(B . ?\xFF1C) ; FULLWIDTH LESS-THAN SIGN
     (?$(C#=(B . ?\xFF1D) ; FULLWIDTH EQUALS SIGN
     (?$(C#>(B . ?\xFF1E) ; FULLWIDTH GREATER-THAN SIGN
     (?$(C#?(B . ?\xFF1F) ; FULLWIDTH QUESTION MARK
     (?$(C#@(B . ?\xFF20) ; FULLWIDTH COMMERCIAL AT
     (?$(C#A(B . ?\xFF21) ; FULLWIDTH LATIN CAPITAL LETTER A
     (?$(C#B(B . ?\xFF22) ; FULLWIDTH LATIN CAPITAL LETTER B
     (?$(C#C(B . ?\xFF23) ; FULLWIDTH LATIN CAPITAL LETTER C
     (?$(C#D(B . ?\xFF24) ; FULLWIDTH LATIN CAPITAL LETTER D
     (?$(C#E(B . ?\xFF25) ; FULLWIDTH LATIN CAPITAL LETTER E
     (?$(C#F(B . ?\xFF26) ; FULLWIDTH LATIN CAPITAL LETTER F
     (?$(C#G(B . ?\xFF27) ; FULLWIDTH LATIN CAPITAL LETTER G
     (?$(C#H(B . ?\xFF28) ; FULLWIDTH LATIN CAPITAL LETTER H
     (?$(C#I(B . ?\xFF29) ; FULLWIDTH LATIN CAPITAL LETTER I
     (?$(C#J(B . ?\xFF2A) ; FULLWIDTH LATIN CAPITAL LETTER J
     (?$(C#K(B . ?\xFF2B) ; FULLWIDTH LATIN CAPITAL LETTER K
     (?$(C#L(B . ?\xFF2C) ; FULLWIDTH LATIN CAPITAL LETTER L
     (?$(C#M(B . ?\xFF2D) ; FULLWIDTH LATIN CAPITAL LETTER M
     (?$(C#N(B . ?\xFF2E) ; FULLWIDTH LATIN CAPITAL LETTER N
     (?$(C#O(B . ?\xFF2F) ; FULLWIDTH LATIN CAPITAL LETTER O
     (?$(C#P(B . ?\xFF30) ; FULLWIDTH LATIN CAPITAL LETTER P
     (?$(C#Q(B . ?\xFF31) ; FULLWIDTH LATIN CAPITAL LETTER Q
     (?$(C#R(B . ?\xFF32) ; FULLWIDTH LATIN CAPITAL LETTER R
     (?$(C#S(B . ?\xFF33) ; FULLWIDTH LATIN CAPITAL LETTER S
     (?$(C#T(B . ?\xFF34) ; FULLWIDTH LATIN CAPITAL LETTER T
     (?$(C#U(B . ?\xFF35) ; FULLWIDTH LATIN CAPITAL LETTER U
     (?$(C#V(B . ?\xFF36) ; FULLWIDTH LATIN CAPITAL LETTER V
     (?$(C#W(B . ?\xFF37) ; FULLWIDTH LATIN CAPITAL LETTER W
     (?$(C#X(B . ?\xFF38) ; FULLWIDTH LATIN CAPITAL LETTER X
     (?$(C#Y(B . ?\xFF39) ; FULLWIDTH LATIN CAPITAL LETTER Y
     (?$(C#Z(B . ?\xFF3A) ; FULLWIDTH LATIN CAPITAL LETTER Z
     (?$(C#[(B . ?\xFF3B) ; FULLWIDTH LEFT SQUARE BRACKET
     (?$(C#\(B . ?\xFFE6) ; FULLWIDTH WON SIGN
     (?$(C#](B . ?\xFF3D) ; FULLWIDTH RIGHT SQUARE BRACKET
     (?$(C#^(B . ?\xFF3E) ; FULLWIDTH CIRCUMFLEX ACCENT
     (?$(C#_(B . ?\xFF3F) ; FULLWIDTH LOW LINE
     (?$(C#`(B . ?\xFF40) ; FULLWIDTH GRAVE ACCENT
     (?$(C#a(B . ?\xFF41) ; FULLWIDTH LATIN SMALL LETTER A
     (?$(C#b(B . ?\xFF42) ; FULLWIDTH LATIN SMALL LETTER B
     (?$(C#c(B . ?\xFF43) ; FULLWIDTH LATIN SMALL LETTER C
     (?$(C#d(B . ?\xFF44) ; FULLWIDTH LATIN SMALL LETTER D
     (?$(C#e(B . ?\xFF45) ; FULLWIDTH LATIN SMALL LETTER E
     (?$(C#f(B . ?\xFF46) ; FULLWIDTH LATIN SMALL LETTER F
     (?$(C#g(B . ?\xFF47) ; FULLWIDTH LATIN SMALL LETTER G
     (?$(C#h(B . ?\xFF48) ; FULLWIDTH LATIN SMALL LETTER H
     (?$(C#i(B . ?\xFF49) ; FULLWIDTH LATIN SMALL LETTER I
     (?$(C#j(B . ?\xFF4A) ; FULLWIDTH LATIN SMALL LETTER J
     (?$(C#k(B . ?\xFF4B) ; FULLWIDTH LATIN SMALL LETTER K
     (?$(C#l(B . ?\xFF4C) ; FULLWIDTH LATIN SMALL LETTER L
     (?$(C#m(B . ?\xFF4D) ; FULLWIDTH LATIN SMALL LETTER M
     (?$(C#n(B . ?\xFF4E) ; FULLWIDTH LATIN SMALL LETTER N
     (?$(C#o(B . ?\xFF4F) ; FULLWIDTH LATIN SMALL LETTER O
     (?$(C#p(B . ?\xFF50) ; FULLWIDTH LATIN SMALL LETTER P
     (?$(C#q(B . ?\xFF51) ; FULLWIDTH LATIN SMALL LETTER Q
     (?$(C#r(B . ?\xFF52) ; FULLWIDTH LATIN SMALL LETTER R
     (?$(C#s(B . ?\xFF53) ; FULLWIDTH LATIN SMALL LETTER S
     (?$(C#t(B . ?\xFF54) ; FULLWIDTH LATIN SMALL LETTER T
     (?$(C#u(B . ?\xFF55) ; FULLWIDTH LATIN SMALL LETTER U
     (?$(C#v(B . ?\xFF56) ; FULLWIDTH LATIN SMALL LETTER V
     (?$(C#w(B . ?\xFF57) ; FULLWIDTH LATIN SMALL LETTER W
     (?$(C#x(B . ?\xFF58) ; FULLWIDTH LATIN SMALL LETTER X
     (?$(C#y(B . ?\xFF59) ; FULLWIDTH LATIN SMALL LETTER Y
     (?$(C#z(B . ?\xFF5A) ; FULLWIDTH LATIN SMALL LETTER Z
     (?$(C#{(B . ?\xFF5B) ; FULLWIDTH LEFT CURLY BRACKET
     (?$(C#|(B . ?\xFF5C) ; FULLWIDTH VERTICAL LINE
     (?$(C#}(B . ?\xFF5D) ; FULLWIDTH RIGHT CURLY BRACKET
     (?$(C#~(B . ?\xFFE3) ; FULLWIDTH MACRON
     (?$(C$!(B . ?\x3131) ; HANGUL LETTER KIYEOK
     (?$(C$"(B . ?\x3132) ; HANGUL LETTER SSANGKIYEOK
     (?$(C$#(B . ?\x3133) ; HANGUL LETTER KIYEOK-SIOS
     (?$(C$$(B . ?\x3134) ; HANGUL LETTER NIEUN
     (?$(C$%(B . ?\x3135) ; HANGUL LETTER NIEUN-CIEUC
     (?$(C$&(B . ?\x3136) ; HANGUL LETTER NIEUN-HIEUH
     (?$(C$'(B . ?\x3137) ; HANGUL LETTER TIKEUT
     (?$(C$((B . ?\x3138) ; HANGUL LETTER SSANGTIKEUT
     (?$(C$)(B . ?\x3139) ; HANGUL LETTER RIEUL
     (?$(C$*(B . ?\x313A) ; HANGUL LETTER RIEUL-KIYEOK
     (?$(C$+(B . ?\x313B) ; HANGUL LETTER RIEUL-MIEUM
     (?$(C$,(B . ?\x313C) ; HANGUL LETTER RIEUL-PIEUP
     (?$(C$-(B . ?\x313D) ; HANGUL LETTER RIEUL-SIOS
     (?$(C$.(B . ?\x313E) ; HANGUL LETTER RIEUL-THIEUTH
     (?$(C$/(B . ?\x313F) ; HANGUL LETTER RIEUL-PHIEUPH
     (?$(C$0(B . ?\x3140) ; HANGUL LETTER RIEUL-HIEUH
     (?$(C$1(B . ?\x3141) ; HANGUL LETTER MIEUM
     (?$(C$2(B . ?\x3142) ; HANGUL LETTER PIEUP
     (?$(C$3(B . ?\x3143) ; HANGUL LETTER SSANGPIEUP
     (?$(C$4(B . ?\x3144) ; HANGUL LETTER PIEUP-SIOS
     (?$(C$5(B . ?\x3145) ; HANGUL LETTER SIOS
     (?$(C$6(B . ?\x3146) ; HANGUL LETTER SSANGSIOS
     (?$(C$7(B . ?\x3147) ; HANGUL LETTER IEUNG
     (?$(C$8(B . ?\x3148) ; HANGUL LETTER CIEUC
     (?$(C$9(B . ?\x3149) ; HANGUL LETTER SSANGCIEUC
     (?$(C$:(B . ?\x314A) ; HANGUL LETTER CHIEUCH
     (?$(C$;(B . ?\x314B) ; HANGUL LETTER KHIEUKH
     (?$(C$<(B . ?\x314C) ; HANGUL LETTER THIEUTH
     (?$(C$=(B . ?\x314D) ; HANGUL LETTER PHIEUPH
     (?$(C$>(B . ?\x314E) ; HANGUL LETTER HIEUH
     (?$(C$?(B . ?\x314F) ; HANGUL LETTER A
     (?$(C$@(B . ?\x3150) ; HANGUL LETTER AE
     (?$(C$A(B . ?\x3151) ; HANGUL LETTER YA
     (?$(C$B(B . ?\x3152) ; HANGUL LETTER YAE
     (?$(C$C(B . ?\x3153) ; HANGUL LETTER EO
     (?$(C$D(B . ?\x3154) ; HANGUL LETTER E
     (?$(C$E(B . ?\x3155) ; HANGUL LETTER YEO
     (?$(C$F(B . ?\x3156) ; HANGUL LETTER YE
     (?$(C$G(B . ?\x3157) ; HANGUL LETTER O
     (?$(C$H(B . ?\x3158) ; HANGUL LETTER WA
     (?$(C$I(B . ?\x3159) ; HANGUL LETTER WAE
     (?$(C$J(B . ?\x315A) ; HANGUL LETTER OE
     (?$(C$K(B . ?\x315B) ; HANGUL LETTER YO
     (?$(C$L(B . ?\x315C) ; HANGUL LETTER U
     (?$(C$M(B . ?\x315D) ; HANGUL LETTER WEO
     (?$(C$N(B . ?\x315E) ; HANGUL LETTER WE
     (?$(C$O(B . ?\x315F) ; HANGUL LETTER WI
     (?$(C$P(B . ?\x3160) ; HANGUL LETTER YU
     (?$(C$Q(B . ?\x3161) ; HANGUL LETTER EU
     (?$(C$R(B . ?\x3162) ; HANGUL LETTER YI
     (?$(C$S(B . ?\x3163) ; HANGUL LETTER I
     (?$(C$T(B . ?\x3164) ; HANGUL FILLER
     (?$(C$U(B . ?\x3165) ; HANGUL LETTER SSANGNIEUN
     (?$(C$V(B . ?\x3166) ; HANGUL LETTER NIEUN-TIKEUT
     (?$(C$W(B . ?\x3167) ; HANGUL LETTER NIEUN-SIOS
     (?$(C$X(B . ?\x3168) ; HANGUL LETTER NIEUN-PANSIOS
     (?$(C$Y(B . ?\x3169) ; HANGUL LETTER RIEUL-KIYEOK-SIOS
     (?$(C$Z(B . ?\x316A) ; HANGUL LETTER RIEUL-TIKEUT
     (?$(C$[(B . ?\x316B) ; HANGUL LETTER RIEUL-PIEUP-SIOS
     (?$(C$\(B . ?\x316C) ; HANGUL LETTER RIEUL-PANSIOS
     (?$(C$](B . ?\x316D) ; HANGUL LETTER RIEUL-YEORINHIEUH
     (?$(C$^(B . ?\x316E) ; HANGUL LETTER MIEUM-PIEUP
     (?$(C$_(B . ?\x316F) ; HANGUL LETTER MIEUM-SIOS
     (?$(C$`(B . ?\x3170) ; HANGUL LETTER MIEUM-PANSIOS
     (?$(C$a(B . ?\x3171) ; HANGUL LETTER KAPYEOUNMIEUM
     (?$(C$b(B . ?\x3172) ; HANGUL LETTER PIEUP-KIYEOK
     (?$(C$c(B . ?\x3173) ; HANGUL LETTER PIEUP-TIKEUT
     (?$(C$d(B . ?\x3174) ; HANGUL LETTER PIEUP-SIOS-KIYEOK
     (?$(C$e(B . ?\x3175) ; HANGUL LETTER PIEUP-SIOS-TIKEUT
     (?$(C$f(B . ?\x3176) ; HANGUL LETTER PIEUP-CIEUC
     (?$(C$g(B . ?\x3177) ; HANGUL LETTER PIEUP-THIEUTH
     (?$(C$h(B . ?\x3178) ; HANGUL LETTER KAPYEOUNPIEUP
     (?$(C$i(B . ?\x3179) ; HANGUL LETTER KAPYEOUNSSANGPIEUP
     (?$(C$j(B . ?\x317A) ; HANGUL LETTER SIOS-KIYEOK
     (?$(C$k(B . ?\x317B) ; HANGUL LETTER SIOS-NIEUN
     (?$(C$l(B . ?\x317C) ; HANGUL LETTER SIOS-TIKEUT
     (?$(C$m(B . ?\x317D) ; HANGUL LETTER SIOS-PIEUP
     (?$(C$n(B . ?\x317E) ; HANGUL LETTER SIOS-CIEUC
     (?$(C$o(B . ?\x317F) ; HANGUL LETTER PANSIOS
     (?$(C$p(B . ?\x3180) ; HANGUL LETTER SSANGIEUNG
     (?$(C$q(B . ?\x3181) ; HANGUL LETTER YESIEUNG
     (?$(C$r(B . ?\x3182) ; HANGUL LETTER YESIEUNG-SIOS
     (?$(C$s(B . ?\x3183) ; HANGUL LETTER YESIEUNG-PANSIOS
     (?$(C$t(B . ?\x3184) ; HANGUL LETTER KAPYEOUNPHIEUPH
     (?$(C$u(B . ?\x3185) ; HANGUL LETTER SSANGHIEUH
     (?$(C$v(B . ?\x3186) ; HANGUL LETTER YEORINHIEUH
     (?$(C$w(B . ?\x3187) ; HANGUL LETTER YO-YA
     (?$(C$x(B . ?\x3188) ; HANGUL LETTER YO-YAE
     (?$(C$y(B . ?\x3189) ; HANGUL LETTER YO-I
     (?$(C$z(B . ?\x318A) ; HANGUL LETTER YU-YEO
     (?$(C${(B . ?\x318B) ; HANGUL LETTER YU-YE
     (?$(C$|(B . ?\x318C) ; HANGUL LETTER YU-I
     (?$(C$}(B . ?\x318D) ; HANGUL LETTER ARAEA
     (?$(C$~(B . ?\x318E) ; HANGUL LETTER ARAEAE
     (?$(C%!(B . ?\x2170) ; SMALL ROMAN NUMERAL ONE
     (?$(C%"(B . ?\x2171) ; SMALL ROMAN NUMERAL TWO
     (?$(C%#(B . ?\x2172) ; SMALL ROMAN NUMERAL THREE
     (?$(C%$(B . ?\x2173) ; SMALL ROMAN NUMERAL FOUR
     (?$(C%%(B . ?\x2174) ; SMALL ROMAN NUMERAL FIVE
     (?$(C%&(B . ?\x2175) ; SMALL ROMAN NUMERAL SIX
     (?$(C%'(B . ?\x2176) ; SMALL ROMAN NUMERAL SEVEN
     (?$(C%((B . ?\x2177) ; SMALL ROMAN NUMERAL EIGHT
     (?$(C%)(B . ?\x2178) ; SMALL ROMAN NUMERAL NINE
     (?$(C%*(B . ?\x2179) ; SMALL ROMAN NUMERAL TEN
     (?$(C%0(B . ?\x2160) ; ROMAN NUMERAL ONE
     (?$(C%1(B . ?\x2161) ; ROMAN NUMERAL TWO
     (?$(C%2(B . ?\x2162) ; ROMAN NUMERAL THREE
     (?$(C%3(B . ?\x2163) ; ROMAN NUMERAL FOUR
     (?$(C%4(B . ?\x2164) ; ROMAN NUMERAL FIVE
     (?$(C%5(B . ?\x2165) ; ROMAN NUMERAL SIX
     (?$(C%6(B . ?\x2166) ; ROMAN NUMERAL SEVEN
     (?$(C%7(B . ?\x2167) ; ROMAN NUMERAL EIGHT
     (?$(C%8(B . ?\x2168) ; ROMAN NUMERAL NINE
     (?$(C%9(B . ?\x2169) ; ROMAN NUMERAL TEN
     (?$(C%A(B . ?\x0391) ; GREEK CAPITAL LETTER ALPHA
     (?$(C%B(B . ?\x0392) ; GREEK CAPITAL LETTER BETA
     (?$(C%C(B . ?\x0393) ; GREEK CAPITAL LETTER GAMMA
     (?$(C%D(B . ?\x0394) ; GREEK CAPITAL LETTER DELTA
     (?$(C%E(B . ?\x0395) ; GREEK CAPITAL LETTER EPSILON
     (?$(C%F(B . ?\x0396) ; GREEK CAPITAL LETTER ZETA
     (?$(C%G(B . ?\x0397) ; GREEK CAPITAL LETTER ETA
     (?$(C%H(B . ?\x0398) ; GREEK CAPITAL LETTER THETA
     (?$(C%I(B . ?\x0399) ; GREEK CAPITAL LETTER IOTA
     (?$(C%J(B . ?\x039A) ; GREEK CAPITAL LETTER KAPPA
     (?$(C%K(B . ?\x039B) ; GREEK CAPITAL LETTER LAMDA
     (?$(C%L(B . ?\x039C) ; GREEK CAPITAL LETTER MU
     (?$(C%M(B . ?\x039D) ; GREEK CAPITAL LETTER NU
     (?$(C%N(B . ?\x039E) ; GREEK CAPITAL LETTER XI
     (?$(C%O(B . ?\x039F) ; GREEK CAPITAL LETTER OMICRON
     (?$(C%P(B . ?\x03A0) ; GREEK CAPITAL LETTER PI
     (?$(C%Q(B . ?\x03A1) ; GREEK CAPITAL LETTER RHO
     (?$(C%R(B . ?\x03A3) ; GREEK CAPITAL LETTER SIGMA
     (?$(C%S(B . ?\x03A4) ; GREEK CAPITAL LETTER TAU
     (?$(C%T(B . ?\x03A5) ; GREEK CAPITAL LETTER UPSILON
     (?$(C%U(B . ?\x03A6) ; GREEK CAPITAL LETTER PHI
     (?$(C%V(B . ?\x03A7) ; GREEK CAPITAL LETTER CHI
     (?$(C%W(B . ?\x03A8) ; GREEK CAPITAL LETTER PSI
     (?$(C%X(B . ?\x03A9) ; GREEK CAPITAL LETTER OMEGA
     (?$(C%a(B . ?\x03B1) ; GREEK SMALL LETTER ALPHA
     (?$(C%b(B . ?\x03B2) ; GREEK SMALL LETTER BETA
     (?$(C%c(B . ?\x03B3) ; GREEK SMALL LETTER GAMMA
     (?$(C%d(B . ?\x03B4) ; GREEK SMALL LETTER DELTA
     (?$(C%e(B . ?\x03B5) ; GREEK SMALL LETTER EPSILON
     (?$(C%f(B . ?\x03B6) ; GREEK SMALL LETTER ZETA
     (?$(C%g(B . ?\x03B7) ; GREEK SMALL LETTER ETA
     (?$(C%h(B . ?\x03B8) ; GREEK SMALL LETTER THETA
     (?$(C%i(B . ?\x03B9) ; GREEK SMALL LETTER IOTA
     (?$(C%j(B . ?\x03BA) ; GREEK SMALL LETTER KAPPA
     (?$(C%k(B . ?\x03BB) ; GREEK SMALL LETTER LAMDA
     (?$(C%l(B . ?\x03BC) ; GREEK SMALL LETTER MU
     (?$(C%m(B . ?\x03BD) ; GREEK SMALL LETTER NU
     (?$(C%n(B . ?\x03BE) ; GREEK SMALL LETTER XI
     (?$(C%o(B . ?\x03BF) ; GREEK SMALL LETTER OMICRON
     (?$(C%p(B . ?\x03C0) ; GREEK SMALL LETTER PI
     (?$(C%q(B . ?\x03C1) ; GREEK SMALL LETTER RHO
     (?$(C%r(B . ?\x03C3) ; GREEK SMALL LETTER SIGMA
     (?$(C%s(B . ?\x03C4) ; GREEK SMALL LETTER TAU
     (?$(C%t(B . ?\x03C5) ; GREEK SMALL LETTER UPSILON
     (?$(C%u(B . ?\x03C6) ; GREEK SMALL LETTER PHI
     (?$(C%v(B . ?\x03C7) ; GREEK SMALL LETTER CHI
     (?$(C%w(B . ?\x03C8) ; GREEK SMALL LETTER PSI
     (?$(C%x(B . ?\x03C9) ; GREEK SMALL LETTER OMEGA
     (?$(C&!(B . ?\x2500) ; BOX DRAWINGS LIGHT HORIZONTAL
     (?$(C&"(B . ?\x2502) ; BOX DRAWINGS LIGHT VERTICAL
     (?$(C&#(B . ?\x250C) ; BOX DRAWINGS LIGHT DOWN AND RIGHT
     (?$(C&$(B . ?\x2510) ; BOX DRAWINGS LIGHT DOWN AND LEFT
     (?$(C&%(B . ?\x2518) ; BOX DRAWINGS LIGHT UP AND LEFT
     (?$(C&&(B . ?\x2514) ; BOX DRAWINGS LIGHT UP AND RIGHT
     (?$(C&'(B . ?\x251C) ; BOX DRAWINGS LIGHT VERTICAL AND RIGHT
     (?$(C&((B . ?\x252C) ; BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
     (?$(C&)(B . ?\x2524) ; BOX DRAWINGS LIGHT VERTICAL AND LEFT
     (?$(C&*(B . ?\x2534) ; BOX DRAWINGS LIGHT UP AND HORIZONTAL
     (?$(C&+(B . ?\x253C) ; BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
     (?$(C&,(B . ?\x2501) ; BOX DRAWINGS HEAVY HORIZONTAL
     (?$(C&-(B . ?\x2503) ; BOX DRAWINGS HEAVY VERTICAL
     (?$(C&.(B . ?\x250F) ; BOX DRAWINGS HEAVY DOWN AND RIGHT
     (?$(C&/(B . ?\x2513) ; BOX DRAWINGS HEAVY DOWN AND LEFT
     (?$(C&0(B . ?\x251B) ; BOX DRAWINGS HEAVY UP AND LEFT
     (?$(C&1(B . ?\x2517) ; BOX DRAWINGS HEAVY UP AND RIGHT
     (?$(C&2(B . ?\x2523) ; BOX DRAWINGS HEAVY VERTICAL AND RIGHT
     (?$(C&3(B . ?\x2533) ; BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
     (?$(C&4(B . ?\x252B) ; BOX DRAWINGS HEAVY VERTICAL AND LEFT
     (?$(C&5(B . ?\x253B) ; BOX DRAWINGS HEAVY UP AND HORIZONTAL
     (?$(C&6(B . ?\x254B) ; BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
     (?$(C&7(B . ?\x2520) ; BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
     (?$(C&8(B . ?\x252F) ; BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
     (?$(C&9(B . ?\x2528) ; BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
     (?$(C&:(B . ?\x2537) ; BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
     (?$(C&;(B . ?\x253F) ; BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
     (?$(C&<(B . ?\x251D) ; BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
     (?$(C&=(B . ?\x2530) ; BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
     (?$(C&>(B . ?\x2525) ; BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
     (?$(C&?(B . ?\x2538) ; BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
     (?$(C&@(B . ?\x2542) ; BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
     (?$(C&A(B . ?\x2512) ; BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
     (?$(C&B(B . ?\x2511) ; BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
     (?$(C&C(B . ?\x251A) ; BOX DRAWINGS UP HEAVY AND LEFT LIGHT
     (?$(C&D(B . ?\x2519) ; BOX DRAWINGS UP LIGHT AND LEFT HEAVY
     (?$(C&E(B . ?\x2516) ; BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
     (?$(C&F(B . ?\x2515) ; BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
     (?$(C&G(B . ?\x250E) ; BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
     (?$(C&H(B . ?\x250D) ; BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
     (?$(C&I(B . ?\x251E) ; BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
     (?$(C&J(B . ?\x251F) ; BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
     (?$(C&K(B . ?\x2521) ; BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
     (?$(C&L(B . ?\x2522) ; BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
     (?$(C&M(B . ?\x2526) ; BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
     (?$(C&N(B . ?\x2527) ; BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
     (?$(C&O(B . ?\x2529) ; BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
     (?$(C&P(B . ?\x252A) ; BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
     (?$(C&Q(B . ?\x252D) ; BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
     (?$(C&R(B . ?\x252E) ; BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
     (?$(C&S(B . ?\x2531) ; BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
     (?$(C&T(B . ?\x2532) ; BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
     (?$(C&U(B . ?\x2535) ; BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
     (?$(C&V(B . ?\x2536) ; BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
     (?$(C&W(B . ?\x2539) ; BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
     (?$(C&X(B . ?\x253A) ; BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
     (?$(C&Y(B . ?\x253D) ; BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
     (?$(C&Z(B . ?\x253E) ; BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
     (?$(C&[(B . ?\x2540) ; BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
     (?$(C&\(B . ?\x2541) ; BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
     (?$(C&](B . ?\x2543) ; BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
     (?$(C&^(B . ?\x2544) ; BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
     (?$(C&_(B . ?\x2545) ; BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
     (?$(C&`(B . ?\x2546) ; BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
     (?$(C&a(B . ?\x2547) ; BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
     (?$(C&b(B . ?\x2548) ; BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
     (?$(C&c(B . ?\x2549) ; BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
     (?$(C&d(B . ?\x254A) ; BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
     (?$(C'!(B . ?\x3395) ; SQUARE MU L
     (?$(C'"(B . ?\x3396) ; SQUARE ML
     (?$(C'#(B . ?\x3397) ; SQUARE DL
     (?$(C'$(B . ?\x2113) ; SCRIPT SMALL L
     (?$(C'%(B . ?\x3398) ; SQUARE KL
     (?$(C'&(B . ?\x33C4) ; SQUARE CC
     (?$(C''(B . ?\x33A3) ; SQUARE MM CUBED
     (?$(C'((B . ?\x33A4) ; SQUARE CM CUBED
     (?$(C')(B . ?\x33A5) ; SQUARE M CUBED
     (?$(C'*(B . ?\x33A6) ; SQUARE KM CUBED
     (?$(C'+(B . ?\x3399) ; SQUARE FM
     (?$(C',(B . ?\x339A) ; SQUARE NM
     (?$(C'-(B . ?\x339B) ; SQUARE MU M
     (?$(C'.(B . ?\x339C) ; SQUARE MM
     (?$(C'/(B . ?\x339D) ; SQUARE CM
     (?$(C'0(B . ?\x339E) ; SQUARE KM
     (?$(C'1(B . ?\x339F) ; SQUARE MM SQUARED
     (?$(C'2(B . ?\x33A0) ; SQUARE CM SQUARED
     (?$(C'3(B . ?\x33A1) ; SQUARE M SQUARED
     (?$(C'4(B . ?\x33A2) ; SQUARE KM SQUARED
     (?$(C'5(B . ?\x33CA) ; SQUARE HA
     (?$(C'6(B . ?\x338D) ; SQUARE MU G
     (?$(C'7(B . ?\x338E) ; SQUARE MG
     (?$(C'8(B . ?\x338F) ; SQUARE KG
     (?$(C'9(B . ?\x33CF) ; SQUARE KT
     (?$(C':(B . ?\x3388) ; SQUARE CAL
     (?$(C';(B . ?\x3389) ; SQUARE KCAL
     (?$(C'<(B . ?\x33C8) ; SQUARE DB
     (?$(C'=(B . ?\x33A7) ; SQUARE M OVER S
     (?$(C'>(B . ?\x33A8) ; SQUARE M OVER S SQUARED
     (?$(C'?(B . ?\x33B0) ; SQUARE PS
     (?$(C'@(B . ?\x33B1) ; SQUARE NS
     (?$(C'A(B . ?\x33B2) ; SQUARE MU S
     (?$(C'B(B . ?\x33B3) ; SQUARE MS
     (?$(C'C(B . ?\x33B4) ; SQUARE PV
     (?$(C'D(B . ?\x33B5) ; SQUARE NV
     (?$(C'E(B . ?\x33B6) ; SQUARE MU V
     (?$(C'F(B . ?\x33B7) ; SQUARE MV
     (?$(C'G(B . ?\x33B8) ; SQUARE KV
     (?$(C'H(B . ?\x33B9) ; SQUARE MV MEGA
     (?$(C'I(B . ?\x3380) ; SQUARE PA AMPS
     (?$(C'J(B . ?\x3381) ; SQUARE NA
     (?$(C'K(B . ?\x3382) ; SQUARE MU A
     (?$(C'L(B . ?\x3383) ; SQUARE MA
     (?$(C'M(B . ?\x3384) ; SQUARE KA
     (?$(C'N(B . ?\x33BA) ; SQUARE PW
     (?$(C'O(B . ?\x33BB) ; SQUARE NW
     (?$(C'P(B . ?\x33BC) ; SQUARE MU W
     (?$(C'Q(B . ?\x33BD) ; SQUARE MW
     (?$(C'R(B . ?\x33BE) ; SQUARE KW
     (?$(C'S(B . ?\x33BF) ; SQUARE MW MEGA
     (?$(C'T(B . ?\x3390) ; SQUARE HZ
     (?$(C'U(B . ?\x3391) ; SQUARE KHZ
     (?$(C'V(B . ?\x3392) ; SQUARE MHZ
     (?$(C'W(B . ?\x3393) ; SQUARE GHZ
     (?$(C'X(B . ?\x3394) ; SQUARE THZ
     (?$(C'Y(B . ?\x2126) ; OHM SIGN
     (?$(C'Z(B . ?\x33C0) ; SQUARE K OHM
     (?$(C'[(B . ?\x33C1) ; SQUARE M OHM
     (?$(C'\(B . ?\x338A) ; SQUARE PF
     (?$(C'](B . ?\x338B) ; SQUARE NF
     (?$(C'^(B . ?\x338C) ; SQUARE MU F
     (?$(C'_(B . ?\x33D6) ; SQUARE MOL
     (?$(C'`(B . ?\x33C5) ; SQUARE CD
     (?$(C'a(B . ?\x33AD) ; SQUARE RAD
     (?$(C'b(B . ?\x33AE) ; SQUARE RAD OVER S
     (?$(C'c(B . ?\x33AF) ; SQUARE RAD OVER S SQUARED
     (?$(C'd(B . ?\x33DB) ; SQUARE SR
     (?$(C'e(B . ?\x33A9) ; SQUARE PA
     (?$(C'f(B . ?\x33AA) ; SQUARE KPA
     (?$(C'g(B . ?\x33AB) ; SQUARE MPA
     (?$(C'h(B . ?\x33AC) ; SQUARE GPA
     (?$(C'i(B . ?\x33DD) ; SQUARE WB
     (?$(C'j(B . ?\x33D0) ; SQUARE LM
     (?$(C'k(B . ?\x33D3) ; SQUARE LX
     (?$(C'l(B . ?\x33C3) ; SQUARE BQ
     (?$(C'm(B . ?\x33C9) ; SQUARE GY
     (?$(C'n(B . ?\x33DC) ; SQUARE SV
     (?$(C'o(B . ?\x33C6) ; SQUARE C OVER KG
     (?$(C(!(B . ?\x00C6) ; LATIN CAPITAL LIGATURE AE
     (?$(C("(B . ?\x00D0) ; LATIN CAPITAL LETTER ETH
     (?$(C(#(B . ?\x00AA) ; FEMININE ORDINAL INDICATOR
     (?$(C($(B . ?\x0126) ; LATIN CAPITAL LETTER H WITH STROKE
     (?$(C(&(B . ?\x0132) ; LATIN CAPITAL LIGATURE IJ
     (?$(C(((B . ?\x013F) ; LATIN CAPITAL LETTER L WITH MIDDLE DOT
     (?$(C()(B . ?\x0141) ; LATIN CAPITAL LETTER L WITH STROKE
     (?$(C(*(B . ?\x00D8) ; LATIN CAPITAL LETTER O WITH STROKE
     (?$(C(+(B . ?\x0152) ; LATIN CAPITAL LIGATURE OE
     (?$(C(,(B . ?\x00BA) ; MASCULINE ORDINAL INDICATOR
     (?$(C(-(B . ?\x00DE) ; LATIN CAPITAL LETTER THORN
     (?$(C(.(B . ?\x0166) ; LATIN CAPITAL LETTER T WITH STROKE
     (?$(C(/(B . ?\x014A) ; LATIN CAPITAL LETTER ENG
     (?$(C(1(B . ?\x3260) ; CIRCLED HANGUL KIYEOK
     (?$(C(2(B . ?\x3261) ; CIRCLED HANGUL NIEUN
     (?$(C(3(B . ?\x3262) ; CIRCLED HANGUL TIKEUT
     (?$(C(4(B . ?\x3263) ; CIRCLED HANGUL RIEUL
     (?$(C(5(B . ?\x3264) ; CIRCLED HANGUL MIEUM
     (?$(C(6(B . ?\x3265) ; CIRCLED HANGUL PIEUP
     (?$(C(7(B . ?\x3266) ; CIRCLED HANGUL SIOS
     (?$(C(8(B . ?\x3267) ; CIRCLED HANGUL IEUNG
     (?$(C(9(B . ?\x3268) ; CIRCLED HANGUL CIEUC
     (?$(C(:(B . ?\x3269) ; CIRCLED HANGUL CHIEUCH
     (?$(C(;(B . ?\x326A) ; CIRCLED HANGUL KHIEUKH
     (?$(C(<(B . ?\x326B) ; CIRCLED HANGUL THIEUTH
     (?$(C(=(B . ?\x326C) ; CIRCLED HANGUL PHIEUPH
     (?$(C(>(B . ?\x326D) ; CIRCLED HANGUL HIEUH
     (?$(C(?(B . ?\x326E) ; CIRCLED HANGUL KIYEOK A
     (?$(C(@(B . ?\x326F) ; CIRCLED HANGUL NIEUN A
     (?$(C(A(B . ?\x3270) ; CIRCLED HANGUL TIKEUT A
     (?$(C(B(B . ?\x3271) ; CIRCLED HANGUL RIEUL A
     (?$(C(C(B . ?\x3272) ; CIRCLED HANGUL MIEUM A
     (?$(C(D(B . ?\x3273) ; CIRCLED HANGUL PIEUP A
     (?$(C(E(B . ?\x3274) ; CIRCLED HANGUL SIOS A
     (?$(C(F(B . ?\x3275) ; CIRCLED HANGUL IEUNG A
     (?$(C(G(B . ?\x3276) ; CIRCLED HANGUL CIEUC A
     (?$(C(H(B . ?\x3277) ; CIRCLED HANGUL CHIEUCH A
     (?$(C(I(B . ?\x3278) ; CIRCLED HANGUL KHIEUKH A
     (?$(C(J(B . ?\x3279) ; CIRCLED HANGUL THIEUTH A
     (?$(C(K(B . ?\x327A) ; CIRCLED HANGUL PHIEUPH A
     (?$(C(L(B . ?\x327B) ; CIRCLED HANGUL HIEUH A
     (?$(C(M(B . ?\x24D0) ; CIRCLED LATIN SMALL LETTER A
     (?$(C(N(B . ?\x24D1) ; CIRCLED LATIN SMALL LETTER B
     (?$(C(O(B . ?\x24D2) ; CIRCLED LATIN SMALL LETTER C
     (?$(C(P(B . ?\x24D3) ; CIRCLED LATIN SMALL LETTER D
     (?$(C(Q(B . ?\x24D4) ; CIRCLED LATIN SMALL LETTER E
     (?$(C(R(B . ?\x24D5) ; CIRCLED LATIN SMALL LETTER F
     (?$(C(S(B . ?\x24D6) ; CIRCLED LATIN SMALL LETTER G
     (?$(C(T(B . ?\x24D7) ; CIRCLED LATIN SMALL LETTER H
     (?$(C(U(B . ?\x24D8) ; CIRCLED LATIN SMALL LETTER I
     (?$(C(V(B . ?\x24D9) ; CIRCLED LATIN SMALL LETTER J
     (?$(C(W(B . ?\x24DA) ; CIRCLED LATIN SMALL LETTER K
     (?$(C(X(B . ?\x24DB) ; CIRCLED LATIN SMALL LETTER L
     (?$(C(Y(B . ?\x24DC) ; CIRCLED LATIN SMALL LETTER M
     (?$(C(Z(B . ?\x24DD) ; CIRCLED LATIN SMALL LETTER N
     (?$(C([(B . ?\x24DE) ; CIRCLED LATIN SMALL LETTER O
     (?$(C(\(B . ?\x24DF) ; CIRCLED LATIN SMALL LETTER P
     (?$(C(](B . ?\x24E0) ; CIRCLED LATIN SMALL LETTER Q
     (?$(C(^(B . ?\x24E1) ; CIRCLED LATIN SMALL LETTER R
     (?$(C(_(B . ?\x24E2) ; CIRCLED LATIN SMALL LETTER S
     (?$(C(`(B . ?\x24E3) ; CIRCLED LATIN SMALL LETTER T
     (?$(C(a(B . ?\x24E4) ; CIRCLED LATIN SMALL LETTER U
     (?$(C(b(B . ?\x24E5) ; CIRCLED LATIN SMALL LETTER V
     (?$(C(c(B . ?\x24E6) ; CIRCLED LATIN SMALL LETTER W
     (?$(C(d(B . ?\x24E7) ; CIRCLED LATIN SMALL LETTER X
     (?$(C(e(B . ?\x24E8) ; CIRCLED LATIN SMALL LETTER Y
     (?$(C(f(B . ?\x24E9) ; CIRCLED LATIN SMALL LETTER Z
     (?$(C(g(B . ?\x2460) ; CIRCLED DIGIT ONE
     (?$(C(h(B . ?\x2461) ; CIRCLED DIGIT TWO
     (?$(C(i(B . ?\x2462) ; CIRCLED DIGIT THREE
     (?$(C(j(B . ?\x2463) ; CIRCLED DIGIT FOUR
     (?$(C(k(B . ?\x2464) ; CIRCLED DIGIT FIVE
     (?$(C(l(B . ?\x2465) ; CIRCLED DIGIT SIX
     (?$(C(m(B . ?\x2466) ; CIRCLED DIGIT SEVEN
     (?$(C(n(B . ?\x2467) ; CIRCLED DIGIT EIGHT
     (?$(C(o(B . ?\x2468) ; CIRCLED DIGIT NINE
     (?$(C(p(B . ?\x2469) ; CIRCLED NUMBER TEN
     (?$(C(q(B . ?\x246A) ; CIRCLED NUMBER ELEVEN
     (?$(C(r(B . ?\x246B) ; CIRCLED NUMBER TWELVE
     (?$(C(s(B . ?\x246C) ; CIRCLED NUMBER THIRTEEN
     (?$(C(t(B . ?\x246D) ; CIRCLED NUMBER FOURTEEN
     (?$(C(u(B . ?\x246E) ; CIRCLED NUMBER FIFTEEN
     (?$(C(v(B . ?\x00BD) ; VULGAR FRACTION ONE HALF
     (?$(C(w(B . ?\x2153) ; VULGAR FRACTION ONE THIRD
     (?$(C(x(B . ?\x2154) ; VULGAR FRACTION TWO THIRDS
     (?$(C(y(B . ?\x00BC) ; VULGAR FRACTION ONE QUARTER
     (?$(C(z(B . ?\x00BE) ; VULGAR FRACTION THREE QUARTERS
     (?$(C({(B . ?\x215B) ; VULGAR FRACTION ONE EIGHTH
     (?$(C(|(B . ?\x215C) ; VULGAR FRACTION THREE EIGHTHS
     (?$(C(}(B . ?\x215D) ; VULGAR FRACTION FIVE EIGHTHS
     (?$(C(~(B . ?\x215E) ; VULGAR FRACTION SEVEN EIGHTHS
     (?$(C)!(B . ?\x00E6) ; LATIN SMALL LIGATURE AE
     (?$(C)"(B . ?\x0111) ; LATIN SMALL LETTER D WITH STROKE
     (?$(C)#(B . ?\x00F0) ; LATIN SMALL LETTER ETH
     (?$(C)$(B . ?\x0127) ; LATIN SMALL LETTER H WITH STROKE
     (?$(C)%(B . ?\x0131) ; LATIN SMALL LETTER DOTLESS I
     (?$(C)&(B . ?\x0133) ; LATIN SMALL LIGATURE IJ
     (?$(C)'(B . ?\x0138) ; LATIN SMALL LETTER KRA
     (?$(C)((B . ?\x0140) ; LATIN SMALL LETTER L WITH MIDDLE DOT
     (?$(C))(B . ?\x0142) ; LATIN SMALL LETTER L WITH STROKE
     (?$(C)*(B . ?\x00F8) ; LATIN SMALL LETTER O WITH STROKE
     (?$(C)+(B . ?\x0153) ; LATIN SMALL LIGATURE OE
     (?$(C),(B . ?\x00DF) ; LATIN SMALL LETTER SHARP S
     (?$(C)-(B . ?\x00FE) ; LATIN SMALL LETTER THORN
     (?$(C).(B . ?\x0167) ; LATIN SMALL LETTER T WITH STROKE
     (?$(C)/(B . ?\x014B) ; LATIN SMALL LETTER ENG
     (?$(C)0(B . ?\x0149) ; LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
     (?$(C)1(B . ?\x3200) ; PARENTHESIZED HANGUL KIYEOK
     (?$(C)2(B . ?\x3201) ; PARENTHESIZED HANGUL NIEUN
     (?$(C)3(B . ?\x3202) ; PARENTHESIZED HANGUL TIKEUT
     (?$(C)4(B . ?\x3203) ; PARENTHESIZED HANGUL RIEUL
     (?$(C)5(B . ?\x3204) ; PARENTHESIZED HANGUL MIEUM
     (?$(C)6(B . ?\x3205) ; PARENTHESIZED HANGUL PIEUP
     (?$(C)7(B . ?\x3206) ; PARENTHESIZED HANGUL SIOS
     (?$(C)8(B . ?\x3207) ; PARENTHESIZED HANGUL IEUNG
     (?$(C)9(B . ?\x3208) ; PARENTHESIZED HANGUL CIEUC
     (?$(C):(B . ?\x3209) ; PARENTHESIZED HANGUL CHIEUCH
     (?$(C);(B . ?\x320A) ; PARENTHESIZED HANGUL KHIEUKH
     (?$(C)<(B . ?\x320B) ; PARENTHESIZED HANGUL THIEUTH
     (?$(C)=(B . ?\x320C) ; PARENTHESIZED HANGUL PHIEUPH
     (?$(C)>(B . ?\x320D) ; PARENTHESIZED HANGUL HIEUH
     (?$(C)?(B . ?\x320E) ; PARENTHESIZED HANGUL KIYEOK A
     (?$(C)@(B . ?\x320F) ; PARENTHESIZED HANGUL NIEUN A
     (?$(C)A(B . ?\x3210) ; PARENTHESIZED HANGUL TIKEUT A
     (?$(C)B(B . ?\x3211) ; PARENTHESIZED HANGUL RIEUL A
     (?$(C)C(B . ?\x3212) ; PARENTHESIZED HANGUL MIEUM A
     (?$(C)D(B . ?\x3213) ; PARENTHESIZED HANGUL PIEUP A
     (?$(C)E(B . ?\x3214) ; PARENTHESIZED HANGUL SIOS A
     (?$(C)F(B . ?\x3215) ; PARENTHESIZED HANGUL IEUNG A
     (?$(C)G(B . ?\x3216) ; PARENTHESIZED HANGUL CIEUC A
     (?$(C)H(B . ?\x3217) ; PARENTHESIZED HANGUL CHIEUCH A
     (?$(C)I(B . ?\x3218) ; PARENTHESIZED HANGUL KHIEUKH A
     (?$(C)J(B . ?\x3219) ; PARENTHESIZED HANGUL THIEUTH A
     (?$(C)K(B . ?\x321A) ; PARENTHESIZED HANGUL PHIEUPH A
     (?$(C)L(B . ?\x321B) ; PARENTHESIZED HANGUL HIEUH A
     (?$(C)M(B . ?\x249C) ; PARENTHESIZED LATIN SMALL LETTER A
     (?$(C)N(B . ?\x249D) ; PARENTHESIZED LATIN SMALL LETTER B
     (?$(C)O(B . ?\x249E) ; PARENTHESIZED LATIN SMALL LETTER C
     (?$(C)P(B . ?\x249F) ; PARENTHESIZED LATIN SMALL LETTER D
     (?$(C)Q(B . ?\x24A0) ; PARENTHESIZED LATIN SMALL LETTER E
     (?$(C)R(B . ?\x24A1) ; PARENTHESIZED LATIN SMALL LETTER F
     (?$(C)S(B . ?\x24A2) ; PARENTHESIZED LATIN SMALL LETTER G
     (?$(C)T(B . ?\x24A3) ; PARENTHESIZED LATIN SMALL LETTER H
     (?$(C)U(B . ?\x24A4) ; PARENTHESIZED LATIN SMALL LETTER I
     (?$(C)V(B . ?\x24A5) ; PARENTHESIZED LATIN SMALL LETTER J
     (?$(C)W(B . ?\x24A6) ; PARENTHESIZED LATIN SMALL LETTER K
     (?$(C)X(B . ?\x24A7) ; PARENTHESIZED LATIN SMALL LETTER L
     (?$(C)Y(B . ?\x24A8) ; PARENTHESIZED LATIN SMALL LETTER M
     (?$(C)Z(B . ?\x24A9) ; PARENTHESIZED LATIN SMALL LETTER N
     (?$(C)[(B . ?\x24AA) ; PARENTHESIZED LATIN SMALL LETTER O
     (?$(C)\(B . ?\x24AB) ; PARENTHESIZED LATIN SMALL LETTER P
     (?$(C)](B . ?\x24AC) ; PARENTHESIZED LATIN SMALL LETTER Q
     (?$(C)^(B . ?\x24AD) ; PARENTHESIZED LATIN SMALL LETTER R
     (?$(C)_(B . ?\x24AE) ; PARENTHESIZED LATIN SMALL LETTER S
     (?$(C)`(B . ?\x24AF) ; PARENTHESIZED LATIN SMALL LETTER T
     (?$(C)a(B . ?\x24B0) ; PARENTHESIZED LATIN SMALL LETTER U
     (?$(C)b(B . ?\x24B1) ; PARENTHESIZED LATIN SMALL LETTER V
     (?$(C)c(B . ?\x24B2) ; PARENTHESIZED LATIN SMALL LETTER W
     (?$(C)d(B . ?\x24B3) ; PARENTHESIZED LATIN SMALL LETTER X
     (?$(C)e(B . ?\x24B4) ; PARENTHESIZED LATIN SMALL LETTER Y
     (?$(C)f(B . ?\x24B5) ; PARENTHESIZED LATIN SMALL LETTER Z
     (?$(C)g(B . ?\x2474) ; PARENTHESIZED DIGIT ONE
     (?$(C)h(B . ?\x2475) ; PARENTHESIZED DIGIT TWO
     (?$(C)i(B . ?\x2476) ; PARENTHESIZED DIGIT THREE
     (?$(C)j(B . ?\x2477) ; PARENTHESIZED DIGIT FOUR
     (?$(C)k(B . ?\x2478) ; PARENTHESIZED DIGIT FIVE
     (?$(C)l(B . ?\x2479) ; PARENTHESIZED DIGIT SIX
     (?$(C)m(B . ?\x247A) ; PARENTHESIZED DIGIT SEVEN
     (?$(C)n(B . ?\x247B) ; PARENTHESIZED DIGIT EIGHT
     (?$(C)o(B . ?\x247C) ; PARENTHESIZED DIGIT NINE
     (?$(C)p(B . ?\x247D) ; PARENTHESIZED NUMBER TEN
     (?$(C)q(B . ?\x247E) ; PARENTHESIZED NUMBER ELEVEN
     (?$(C)r(B . ?\x247F) ; PARENTHESIZED NUMBER TWELVE
     (?$(C)s(B . ?\x2480) ; PARENTHESIZED NUMBER THIRTEEN
     (?$(C)t(B . ?\x2481) ; PARENTHESIZED NUMBER FOURTEEN
     (?$(C)u(B . ?\x2482) ; PARENTHESIZED NUMBER FIFTEEN
     (?$(C)v(B . ?\x00B9) ; SUPERSCRIPT ONE
     (?$(C)w(B . ?\x00B2) ; SUPERSCRIPT TWO
     (?$(C)x(B . ?\x00B3) ; SUPERSCRIPT THREE
     (?$(C)y(B . ?\x2074) ; SUPERSCRIPT FOUR
     (?$(C)z(B . ?\x207F) ; SUPERSCRIPT LATIN SMALL LETTER N
     (?$(C){(B . ?\x2081) ; SUBSCRIPT ONE
     (?$(C)|(B . ?\x2082) ; SUBSCRIPT TWO
     (?$(C)}(B . ?\x2083) ; SUBSCRIPT THREE
     (?$(C)~(B . ?\x2084) ; SUBSCRIPT FOUR
     (?$(C*!(B . ?\x3041) ; HIRAGANA LETTER SMALL A
     (?$(C*"(B . ?\x3042) ; HIRAGANA LETTER A
     (?$(C*#(B . ?\x3043) ; HIRAGANA LETTER SMALL I
     (?$(C*$(B . ?\x3044) ; HIRAGANA LETTER I
     (?$(C*%(B . ?\x3045) ; HIRAGANA LETTER SMALL U
     (?$(C*&(B . ?\x3046) ; HIRAGANA LETTER U
     (?$(C*'(B . ?\x3047) ; HIRAGANA LETTER SMALL E
     (?$(C*((B . ?\x3048) ; HIRAGANA LETTER E
     (?$(C*)(B . ?\x3049) ; HIRAGANA LETTER SMALL O
     (?$(C**(B . ?\x304A) ; HIRAGANA LETTER O
     (?$(C*+(B . ?\x304B) ; HIRAGANA LETTER KA
     (?$(C*,(B . ?\x304C) ; HIRAGANA LETTER GA
     (?$(C*-(B . ?\x304D) ; HIRAGANA LETTER KI
     (?$(C*.(B . ?\x304E) ; HIRAGANA LETTER GI
     (?$(C*/(B . ?\x304F) ; HIRAGANA LETTER KU
     (?$(C*0(B . ?\x3050) ; HIRAGANA LETTER GU
     (?$(C*1(B . ?\x3051) ; HIRAGANA LETTER KE
     (?$(C*2(B . ?\x3052) ; HIRAGANA LETTER GE
     (?$(C*3(B . ?\x3053) ; HIRAGANA LETTER KO
     (?$(C*4(B . ?\x3054) ; HIRAGANA LETTER GO
     (?$(C*5(B . ?\x3055) ; HIRAGANA LETTER SA
     (?$(C*6(B . ?\x3056) ; HIRAGANA LETTER ZA
     (?$(C*7(B . ?\x3057) ; HIRAGANA LETTER SI
     (?$(C*8(B . ?\x3058) ; HIRAGANA LETTER ZI
     (?$(C*9(B . ?\x3059) ; HIRAGANA LETTER SU
     (?$(C*:(B . ?\x305A) ; HIRAGANA LETTER ZU
     (?$(C*;(B . ?\x305B) ; HIRAGANA LETTER SE
     (?$(C*<(B . ?\x305C) ; HIRAGANA LETTER ZE
     (?$(C*=(B . ?\x305D) ; HIRAGANA LETTER SO
     (?$(C*>(B . ?\x305E) ; HIRAGANA LETTER ZO
     (?$(C*?(B . ?\x305F) ; HIRAGANA LETTER TA
     (?$(C*@(B . ?\x3060) ; HIRAGANA LETTER DA
     (?$(C*A(B . ?\x3061) ; HIRAGANA LETTER TI
     (?$(C*B(B . ?\x3062) ; HIRAGANA LETTER DI
     (?$(C*C(B . ?\x3063) ; HIRAGANA LETTER SMALL TU
     (?$(C*D(B . ?\x3064) ; HIRAGANA LETTER TU
     (?$(C*E(B . ?\x3065) ; HIRAGANA LETTER DU
     (?$(C*F(B . ?\x3066) ; HIRAGANA LETTER TE
     (?$(C*G(B . ?\x3067) ; HIRAGANA LETTER DE
     (?$(C*H(B . ?\x3068) ; HIRAGANA LETTER TO
     (?$(C*I(B . ?\x3069) ; HIRAGANA LETTER DO
     (?$(C*J(B . ?\x306A) ; HIRAGANA LETTER NA
     (?$(C*K(B . ?\x306B) ; HIRAGANA LETTER NI
     (?$(C*L(B . ?\x306C) ; HIRAGANA LETTER NU
     (?$(C*M(B . ?\x306D) ; HIRAGANA LETTER NE
     (?$(C*N(B . ?\x306E) ; HIRAGANA LETTER NO
     (?$(C*O(B . ?\x306F) ; HIRAGANA LETTER HA
     (?$(C*P(B . ?\x3070) ; HIRAGANA LETTER BA
     (?$(C*Q(B . ?\x3071) ; HIRAGANA LETTER PA
     (?$(C*R(B . ?\x3072) ; HIRAGANA LETTER HI
     (?$(C*S(B . ?\x3073) ; HIRAGANA LETTER BI
     (?$(C*T(B . ?\x3074) ; HIRAGANA LETTER PI
     (?$(C*U(B . ?\x3075) ; HIRAGANA LETTER HU
     (?$(C*V(B . ?\x3076) ; HIRAGANA LETTER BU
     (?$(C*W(B . ?\x3077) ; HIRAGANA LETTER PU
     (?$(C*X(B . ?\x3078) ; HIRAGANA LETTER HE
     (?$(C*Y(B . ?\x3079) ; HIRAGANA LETTER BE
     (?$(C*Z(B . ?\x307A) ; HIRAGANA LETTER PE
     (?$(C*[(B . ?\x307B) ; HIRAGANA LETTER HO
     (?$(C*\(B . ?\x307C) ; HIRAGANA LETTER BO
     (?$(C*](B . ?\x307D) ; HIRAGANA LETTER PO
     (?$(C*^(B . ?\x307E) ; HIRAGANA LETTER MA
     (?$(C*_(B . ?\x307F) ; HIRAGANA LETTER MI
     (?$(C*`(B . ?\x3080) ; HIRAGANA LETTER MU
     (?$(C*a(B . ?\x3081) ; HIRAGANA LETTER ME
     (?$(C*b(B . ?\x3082) ; HIRAGANA LETTER MO
     (?$(C*c(B . ?\x3083) ; HIRAGANA LETTER SMALL YA
     (?$(C*d(B . ?\x3084) ; HIRAGANA LETTER YA
     (?$(C*e(B . ?\x3085) ; HIRAGANA LETTER SMALL YU
     (?$(C*f(B . ?\x3086) ; HIRAGANA LETTER YU
     (?$(C*g(B . ?\x3087) ; HIRAGANA LETTER SMALL YO
     (?$(C*h(B . ?\x3088) ; HIRAGANA LETTER YO
     (?$(C*i(B . ?\x3089) ; HIRAGANA LETTER RA
     (?$(C*j(B . ?\x308A) ; HIRAGANA LETTER RI
     (?$(C*k(B . ?\x308B) ; HIRAGANA LETTER RU
     (?$(C*l(B . ?\x308C) ; HIRAGANA LETTER RE
     (?$(C*m(B . ?\x308D) ; HIRAGANA LETTER RO
     (?$(C*n(B . ?\x308E) ; HIRAGANA LETTER SMALL WA
     (?$(C*o(B . ?\x308F) ; HIRAGANA LETTER WA
     (?$(C*p(B . ?\x3090) ; HIRAGANA LETTER WI
     (?$(C*q(B . ?\x3091) ; HIRAGANA LETTER WE
     (?$(C*r(B . ?\x3092) ; HIRAGANA LETTER WO
     (?$(C*s(B . ?\x3093) ; HIRAGANA LETTER N
     (?$(C+!(B . ?\x30A1) ; KATAKANA LETTER SMALL A
     (?$(C+"(B . ?\x30A2) ; KATAKANA LETTER A
     (?$(C+#(B . ?\x30A3) ; KATAKANA LETTER SMALL I
     (?$(C+$(B . ?\x30A4) ; KATAKANA LETTER I
     (?$(C+%(B . ?\x30A5) ; KATAKANA LETTER SMALL U
     (?$(C+&(B . ?\x30A6) ; KATAKANA LETTER U
     (?$(C+'(B . ?\x30A7) ; KATAKANA LETTER SMALL E
     (?$(C+((B . ?\x30A8) ; KATAKANA LETTER E
     (?$(C+)(B . ?\x30A9) ; KATAKANA LETTER SMALL O
     (?$(C+*(B . ?\x30AA) ; KATAKANA LETTER O
     (?$(C++(B . ?\x30AB) ; KATAKANA LETTER KA
     (?$(C+,(B . ?\x30AC) ; KATAKANA LETTER GA
     (?$(C+-(B . ?\x30AD) ; KATAKANA LETTER KI
     (?$(C+.(B . ?\x30AE) ; KATAKANA LETTER GI
     (?$(C+/(B . ?\x30AF) ; KATAKANA LETTER KU
     (?$(C+0(B . ?\x30B0) ; KATAKANA LETTER GU
     (?$(C+1(B . ?\x30B1) ; KATAKANA LETTER KE
     (?$(C+2(B . ?\x30B2) ; KATAKANA LETTER GE
     (?$(C+3(B . ?\x30B3) ; KATAKANA LETTER KO
     (?$(C+4(B . ?\x30B4) ; KATAKANA LETTER GO
     (?$(C+5(B . ?\x30B5) ; KATAKANA LETTER SA
     (?$(C+6(B . ?\x30B6) ; KATAKANA LETTER ZA
     (?$(C+7(B . ?\x30B7) ; KATAKANA LETTER SI
     (?$(C+8(B . ?\x30B8) ; KATAKANA LETTER ZI
     (?$(C+9(B . ?\x30B9) ; KATAKANA LETTER SU
     (?$(C+:(B . ?\x30BA) ; KATAKANA LETTER ZU
     (?$(C+;(B . ?\x30BB) ; KATAKANA LETTER SE
     (?$(C+<(B . ?\x30BC) ; KATAKANA LETTER ZE
     (?$(C+=(B . ?\x30BD) ; KATAKANA LETTER SO
     (?$(C+>(B . ?\x30BE) ; KATAKANA LETTER ZO
     (?$(C+?(B . ?\x30BF) ; KATAKANA LETTER TA
     (?$(C+@(B . ?\x30C0) ; KATAKANA LETTER DA
     (?$(C+A(B . ?\x30C1) ; KATAKANA LETTER TI
     (?$(C+B(B . ?\x30C2) ; KATAKANA LETTER DI
     (?$(C+C(B . ?\x30C3) ; KATAKANA LETTER SMALL TU
     (?$(C+D(B . ?\x30C4) ; KATAKANA LETTER TU
     (?$(C+E(B . ?\x30C5) ; KATAKANA LETTER DU
     (?$(C+F(B . ?\x30C6) ; KATAKANA LETTER TE
     (?$(C+G(B . ?\x30C7) ; KATAKANA LETTER DE
     (?$(C+H(B . ?\x30C8) ; KATAKANA LETTER TO
     (?$(C+I(B . ?\x30C9) ; KATAKANA LETTER DO
     (?$(C+J(B . ?\x30CA) ; KATAKANA LETTER NA
     (?$(C+K(B . ?\x30CB) ; KATAKANA LETTER NI
     (?$(C+L(B . ?\x30CC) ; KATAKANA LETTER NU
     (?$(C+M(B . ?\x30CD) ; KATAKANA LETTER NE
     (?$(C+N(B . ?\x30CE) ; KATAKANA LETTER NO
     (?$(C+O(B . ?\x30CF) ; KATAKANA LETTER HA
     (?$(C+P(B . ?\x30D0) ; KATAKANA LETTER BA
     (?$(C+Q(B . ?\x30D1) ; KATAKANA LETTER PA
     (?$(C+R(B . ?\x30D2) ; KATAKANA LETTER HI
     (?$(C+S(B . ?\x30D3) ; KATAKANA LETTER BI
     (?$(C+T(B . ?\x30D4) ; KATAKANA LETTER PI
     (?$(C+U(B . ?\x30D5) ; KATAKANA LETTER HU
     (?$(C+V(B . ?\x30D6) ; KATAKANA LETTER BU
     (?$(C+W(B . ?\x30D7) ; KATAKANA LETTER PU
     (?$(C+X(B . ?\x30D8) ; KATAKANA LETTER HE
     (?$(C+Y(B . ?\x30D9) ; KATAKANA LETTER BE
     (?$(C+Z(B . ?\x30DA) ; KATAKANA LETTER PE
     (?$(C+[(B . ?\x30DB) ; KATAKANA LETTER HO
     (?$(C+\(B . ?\x30DC) ; KATAKANA LETTER BO
     (?$(C+](B . ?\x30DD) ; KATAKANA LETTER PO
     (?$(C+^(B . ?\x30DE) ; KATAKANA LETTER MA
     (?$(C+_(B . ?\x30DF) ; KATAKANA LETTER MI
     (?$(C+`(B . ?\x30E0) ; KATAKANA LETTER MU
     (?$(C+a(B . ?\x30E1) ; KATAKANA LETTER ME
     (?$(C+b(B . ?\x30E2) ; KATAKANA LETTER MO
     (?$(C+c(B . ?\x30E3) ; KATAKANA LETTER SMALL YA
     (?$(C+d(B . ?\x30E4) ; KATAKANA LETTER YA
     (?$(C+e(B . ?\x30E5) ; KATAKANA LETTER SMALL YU
     (?$(C+f(B . ?\x30E6) ; KATAKANA LETTER YU
     (?$(C+g(B . ?\x30E7) ; KATAKANA LETTER SMALL YO
     (?$(C+h(B . ?\x30E8) ; KATAKANA LETTER YO
     (?$(C+i(B . ?\x30E9) ; KATAKANA LETTER RA
     (?$(C+j(B . ?\x30EA) ; KATAKANA LETTER RI
     (?$(C+k(B . ?\x30EB) ; KATAKANA LETTER RU
     (?$(C+l(B . ?\x30EC) ; KATAKANA LETTER RE
     (?$(C+m(B . ?\x30ED) ; KATAKANA LETTER RO
     (?$(C+n(B . ?\x30EE) ; KATAKANA LETTER SMALL WA
     (?$(C+o(B . ?\x30EF) ; KATAKANA LETTER WA
     (?$(C+p(B . ?\x30F0) ; KATAKANA LETTER WI
     (?$(C+q(B . ?\x30F1) ; KATAKANA LETTER WE
     (?$(C+r(B . ?\x30F2) ; KATAKANA LETTER WO
     (?$(C+s(B . ?\x30F3) ; KATAKANA LETTER N
     (?$(C+t(B . ?\x30F4) ; KATAKANA LETTER VU
     (?$(C+u(B . ?\x30F5) ; KATAKANA LETTER SMALL KA
     (?$(C+v(B . ?\x30F6) ; KATAKANA LETTER SMALL KE
     (?$(C,!(B . ?\x0410) ; CYRILLIC CAPITAL LETTER A
     (?$(C,"(B . ?\x0411) ; CYRILLIC CAPITAL LETTER BE
     (?$(C,#(B . ?\x0412) ; CYRILLIC CAPITAL LETTER VE
     (?$(C,$(B . ?\x0413) ; CYRILLIC CAPITAL LETTER GHE
     (?$(C,%(B . ?\x0414) ; CYRILLIC CAPITAL LETTER DE
     (?$(C,&(B . ?\x0415) ; CYRILLIC CAPITAL LETTER IE
     (?$(C,'(B . ?\x0401) ; CYRILLIC CAPITAL LETTER IO
     (?$(C,((B . ?\x0416) ; CYRILLIC CAPITAL LETTER ZHE
     (?$(C,)(B . ?\x0417) ; CYRILLIC CAPITAL LETTER ZE
     (?$(C,*(B . ?\x0418) ; CYRILLIC CAPITAL LETTER I
     (?$(C,+(B . ?\x0419) ; CYRILLIC CAPITAL LETTER SHORT I
     (?$(C,,(B . ?\x041A) ; CYRILLIC CAPITAL LETTER KA
     (?$(C,-(B . ?\x041B) ; CYRILLIC CAPITAL LETTER EL
     (?$(C,.(B . ?\x041C) ; CYRILLIC CAPITAL LETTER EM
     (?$(C,/(B . ?\x041D) ; CYRILLIC CAPITAL LETTER EN
     (?$(C,0(B . ?\x041E) ; CYRILLIC CAPITAL LETTER O
     (?$(C,1(B . ?\x041F) ; CYRILLIC CAPITAL LETTER PE
     (?$(C,2(B . ?\x0420) ; CYRILLIC CAPITAL LETTER ER
     (?$(C,3(B . ?\x0421) ; CYRILLIC CAPITAL LETTER ES
     (?$(C,4(B . ?\x0422) ; CYRILLIC CAPITAL LETTER TE
     (?$(C,5(B . ?\x0423) ; CYRILLIC CAPITAL LETTER U
     (?$(C,6(B . ?\x0424) ; CYRILLIC CAPITAL LETTER EF
     (?$(C,7(B . ?\x0425) ; CYRILLIC CAPITAL LETTER HA
     (?$(C,8(B . ?\x0426) ; CYRILLIC CAPITAL LETTER TSE
     (?$(C,9(B . ?\x0427) ; CYRILLIC CAPITAL LETTER CHE
     (?$(C,:(B . ?\x0428) ; CYRILLIC CAPITAL LETTER SHA
     (?$(C,;(B . ?\x0429) ; CYRILLIC CAPITAL LETTER SHCHA
     (?$(C,<(B . ?\x042A) ; CYRILLIC CAPITAL LETTER HARD SIGN
     (?$(C,=(B . ?\x042B) ; CYRILLIC CAPITAL LETTER YERU
     (?$(C,>(B . ?\x042C) ; CYRILLIC CAPITAL LETTER SOFT SIGN
     (?$(C,?(B . ?\x042D) ; CYRILLIC CAPITAL LETTER E
     (?$(C,@(B . ?\x042E) ; CYRILLIC CAPITAL LETTER YU
     (?$(C,A(B . ?\x042F) ; CYRILLIC CAPITAL LETTER YA
     (?$(C,Q(B . ?\x0430) ; CYRILLIC SMALL LETTER A
     (?$(C,R(B . ?\x0431) ; CYRILLIC SMALL LETTER BE
     (?$(C,S(B . ?\x0432) ; CYRILLIC SMALL LETTER VE
     (?$(C,T(B . ?\x0433) ; CYRILLIC SMALL LETTER GHE
     (?$(C,U(B . ?\x0434) ; CYRILLIC SMALL LETTER DE
     (?$(C,V(B . ?\x0435) ; CYRILLIC SMALL LETTER IE
     (?$(C,W(B . ?\x0451) ; CYRILLIC SMALL LETTER IO
     (?$(C,X(B . ?\x0436) ; CYRILLIC SMALL LETTER ZHE
     (?$(C,Y(B . ?\x0437) ; CYRILLIC SMALL LETTER ZE
     (?$(C,Z(B . ?\x0438) ; CYRILLIC SMALL LETTER I
     (?$(C,[(B . ?\x0439) ; CYRILLIC SMALL LETTER SHORT I
     (?$(C,\(B . ?\x043A) ; CYRILLIC SMALL LETTER KA
     (?$(C,](B . ?\x043B) ; CYRILLIC SMALL LETTER EL
     (?$(C,^(B . ?\x043C) ; CYRILLIC SMALL LETTER EM
     (?$(C,_(B . ?\x043D) ; CYRILLIC SMALL LETTER EN
     (?$(C,`(B . ?\x043E) ; CYRILLIC SMALL LETTER O
     (?$(C,a(B . ?\x043F) ; CYRILLIC SMALL LETTER PE
     (?$(C,b(B . ?\x0440) ; CYRILLIC SMALL LETTER ER
     (?$(C,c(B . ?\x0441) ; CYRILLIC SMALL LETTER ES
     (?$(C,d(B . ?\x0442) ; CYRILLIC SMALL LETTER TE
     (?$(C,e(B . ?\x0443) ; CYRILLIC SMALL LETTER U
     (?$(C,f(B . ?\x0444) ; CYRILLIC SMALL LETTER EF
     (?$(C,g(B . ?\x0445) ; CYRILLIC SMALL LETTER HA
     (?$(C,h(B . ?\x0446) ; CYRILLIC SMALL LETTER TSE
     (?$(C,i(B . ?\x0447) ; CYRILLIC SMALL LETTER CHE
     (?$(C,j(B . ?\x0448) ; CYRILLIC SMALL LETTER SHA
     (?$(C,k(B . ?\x0449) ; CYRILLIC SMALL LETTER SHCHA
     (?$(C,l(B . ?\x044A) ; CYRILLIC SMALL LETTER HARD SIGN
     (?$(C,m(B . ?\x044B) ; CYRILLIC SMALL LETTER YERU
     (?$(C,n(B . ?\x044C) ; CYRILLIC SMALL LETTER SOFT SIGN
     (?$(C,o(B . ?\x044D) ; CYRILLIC SMALL LETTER E
     (?$(C,p(B . ?\x044E) ; CYRILLIC SMALL LETTER YU
     (?$(C,q(B . ?\x044F) ; CYRILLIC SMALL LETTER YA
     (?$(C0!(B . ?\xAC00) ; HANGUL SYLLABLE KIYEOK-A
     (?$(C0"(B . ?\xAC01) ; HANGUL SYLLABLE KIYEOK-A-KIYEOK
     (?$(C0#(B . ?\xAC04) ; HANGUL SYLLABLE KIYEOK-A-NIEUN
     (?$(C0$(B . ?\xAC07) ; HANGUL SYLLABLE KIYEOK-A-TIKEUT
     (?$(C0%(B . ?\xAC08) ; HANGUL SYLLABLE KIYEOK-A-RIEUL
     (?$(C0&(B . ?\xAC09) ; HANGUL SYLLABLE KIYEOK-A-RIEULKIYEOK
     (?$(C0'(B . ?\xAC0A) ; HANGUL SYLLABLE KIYEOK-A-RIEULMIEUM
     (?$(C0((B . ?\xAC10) ; HANGUL SYLLABLE KIYEOK-A-MIEUM
     (?$(C0)(B . ?\xAC11) ; HANGUL SYLLABLE KIYEOK-A-PIEUP
     (?$(C0*(B . ?\xAC12) ; HANGUL SYLLABLE KIYEOK-A-PIEUPSIOS
     (?$(C0+(B . ?\xAC13) ; HANGUL SYLLABLE KIYEOK-A-SIOS
     (?$(C0,(B . ?\xAC14) ; HANGUL SYLLABLE KIYEOK-A-SSANGSIOS
     (?$(C0-(B . ?\xAC15) ; HANGUL SYLLABLE KIYEOK-A-IEUNG
     (?$(C0.(B . ?\xAC16) ; HANGUL SYLLABLE KIYEOK-A-CIEUC
     (?$(C0/(B . ?\xAC17) ; HANGUL SYLLABLE KIYEOK-A-CHIEUCH
     (?$(C00(B . ?\xAC19) ; HANGUL SYLLABLE KIYEOK-A-THIEUTH
     (?$(C01(B . ?\xAC1A) ; HANGUL SYLLABLE KIYEOK-A-PHIEUPH
     (?$(C02(B . ?\xAC1B) ; HANGUL SYLLABLE KIYEOK-A-HIEUH
     (?$(C03(B . ?\xAC1C) ; HANGUL SYLLABLE KIYEOK-AE
     (?$(C04(B . ?\xAC1D) ; HANGUL SYLLABLE KIYEOK-AE-KIYEOK
     (?$(C05(B . ?\xAC20) ; HANGUL SYLLABLE KIYEOK-AE-NIEUN
     (?$(C06(B . ?\xAC24) ; HANGUL SYLLABLE KIYEOK-AE-RIEUL
     (?$(C07(B . ?\xAC2C) ; HANGUL SYLLABLE KIYEOK-AE-MIEUM
     (?$(C08(B . ?\xAC2D) ; HANGUL SYLLABLE KIYEOK-AE-PIEUP
     (?$(C09(B . ?\xAC2F) ; HANGUL SYLLABLE KIYEOK-AE-SIOS
     (?$(C0:(B . ?\xAC30) ; HANGUL SYLLABLE KIYEOK-AE-SSANGSIOS
     (?$(C0;(B . ?\xAC31) ; HANGUL SYLLABLE KIYEOK-AE-IEUNG
     (?$(C0<(B . ?\xAC38) ; HANGUL SYLLABLE KIYEOK-YA
     (?$(C0=(B . ?\xAC39) ; HANGUL SYLLABLE KIYEOK-YA-KIYEOK
     (?$(C0>(B . ?\xAC3C) ; HANGUL SYLLABLE KIYEOK-YA-NIEUN
     (?$(C0?(B . ?\xAC40) ; HANGUL SYLLABLE KIYEOK-YA-RIEUL
     (?$(C0@(B . ?\xAC4B) ; HANGUL SYLLABLE KIYEOK-YA-SIOS
     (?$(C0A(B . ?\xAC4D) ; HANGUL SYLLABLE KIYEOK-YA-IEUNG
     (?$(C0B(B . ?\xAC54) ; HANGUL SYLLABLE KIYEOK-YAE
     (?$(C0C(B . ?\xAC58) ; HANGUL SYLLABLE KIYEOK-YAE-NIEUN
     (?$(C0D(B . ?\xAC5C) ; HANGUL SYLLABLE KIYEOK-YAE-RIEUL
     (?$(C0E(B . ?\xAC70) ; HANGUL SYLLABLE KIYEOK-EO
     (?$(C0F(B . ?\xAC71) ; HANGUL SYLLABLE KIYEOK-EO-KIYEOK
     (?$(C0G(B . ?\xAC74) ; HANGUL SYLLABLE KIYEOK-EO-NIEUN
     (?$(C0H(B . ?\xAC77) ; HANGUL SYLLABLE KIYEOK-EO-TIKEUT
     (?$(C0I(B . ?\xAC78) ; HANGUL SYLLABLE KIYEOK-EO-RIEUL
     (?$(C0J(B . ?\xAC7A) ; HANGUL SYLLABLE KIYEOK-EO-RIEULMIEUM
     (?$(C0K(B . ?\xAC80) ; HANGUL SYLLABLE KIYEOK-EO-MIEUM
     (?$(C0L(B . ?\xAC81) ; HANGUL SYLLABLE KIYEOK-EO-PIEUP
     (?$(C0M(B . ?\xAC83) ; HANGUL SYLLABLE KIYEOK-EO-SIOS
     (?$(C0N(B . ?\xAC84) ; HANGUL SYLLABLE KIYEOK-EO-SSANGSIOS
     (?$(C0O(B . ?\xAC85) ; HANGUL SYLLABLE KIYEOK-EO-IEUNG
     (?$(C0P(B . ?\xAC86) ; HANGUL SYLLABLE KIYEOK-EO-CIEUC
     (?$(C0Q(B . ?\xAC89) ; HANGUL SYLLABLE KIYEOK-EO-THIEUTH
     (?$(C0R(B . ?\xAC8A) ; HANGUL SYLLABLE KIYEOK-EO-PHIEUPH
     (?$(C0S(B . ?\xAC8B) ; HANGUL SYLLABLE KIYEOK-EO-HIEUH
     (?$(C0T(B . ?\xAC8C) ; HANGUL SYLLABLE KIYEOK-E
     (?$(C0U(B . ?\xAC90) ; HANGUL SYLLABLE KIYEOK-E-NIEUN
     (?$(C0V(B . ?\xAC94) ; HANGUL SYLLABLE KIYEOK-E-RIEUL
     (?$(C0W(B . ?\xAC9C) ; HANGUL SYLLABLE KIYEOK-E-MIEUM
     (?$(C0X(B . ?\xAC9D) ; HANGUL SYLLABLE KIYEOK-E-PIEUP
     (?$(C0Y(B . ?\xAC9F) ; HANGUL SYLLABLE KIYEOK-E-SIOS
     (?$(C0Z(B . ?\xACA0) ; HANGUL SYLLABLE KIYEOK-E-SSANGSIOS
     (?$(C0[(B . ?\xACA1) ; HANGUL SYLLABLE KIYEOK-E-IEUNG
     (?$(C0\(B . ?\xACA8) ; HANGUL SYLLABLE KIYEOK-YEO
     (?$(C0](B . ?\xACA9) ; HANGUL SYLLABLE KIYEOK-YEO-KIYEOK
     (?$(C0^(B . ?\xACAA) ; HANGUL SYLLABLE KIYEOK-YEO-SSANGKIYEOK
     (?$(C0_(B . ?\xACAC) ; HANGUL SYLLABLE KIYEOK-YEO-NIEUN
     (?$(C0`(B . ?\xACAF) ; HANGUL SYLLABLE KIYEOK-YEO-TIKEUT
     (?$(C0a(B . ?\xACB0) ; HANGUL SYLLABLE KIYEOK-YEO-RIEUL
     (?$(C0b(B . ?\xACB8) ; HANGUL SYLLABLE KIYEOK-YEO-MIEUM
     (?$(C0c(B . ?\xACB9) ; HANGUL SYLLABLE KIYEOK-YEO-PIEUP
     (?$(C0d(B . ?\xACBB) ; HANGUL SYLLABLE KIYEOK-YEO-SIOS
     (?$(C0e(B . ?\xACBC) ; HANGUL SYLLABLE KIYEOK-YEO-SSANGSIOS
     (?$(C0f(B . ?\xACBD) ; HANGUL SYLLABLE KIYEOK-YEO-IEUNG
     (?$(C0g(B . ?\xACC1) ; HANGUL SYLLABLE KIYEOK-YEO-THIEUTH
     (?$(C0h(B . ?\xACC4) ; HANGUL SYLLABLE KIYEOK-YE
     (?$(C0i(B . ?\xACC8) ; HANGUL SYLLABLE KIYEOK-YE-NIEUN
     (?$(C0j(B . ?\xACCC) ; HANGUL SYLLABLE KIYEOK-YE-RIEUL
     (?$(C0k(B . ?\xACD5) ; HANGUL SYLLABLE KIYEOK-YE-PIEUP
     (?$(C0l(B . ?\xACD7) ; HANGUL SYLLABLE KIYEOK-YE-SIOS
     (?$(C0m(B . ?\xACE0) ; HANGUL SYLLABLE KIYEOK-O
     (?$(C0n(B . ?\xACE1) ; HANGUL SYLLABLE KIYEOK-O-KIYEOK
     (?$(C0o(B . ?\xACE4) ; HANGUL SYLLABLE KIYEOK-O-NIEUN
     (?$(C0p(B . ?\xACE7) ; HANGUL SYLLABLE KIYEOK-O-TIKEUT
     (?$(C0q(B . ?\xACE8) ; HANGUL SYLLABLE KIYEOK-O-RIEUL
     (?$(C0r(B . ?\xACEA) ; HANGUL SYLLABLE KIYEOK-O-RIEULMIEUM
     (?$(C0s(B . ?\xACEC) ; HANGUL SYLLABLE KIYEOK-O-RIEULSIOS
     (?$(C0t(B . ?\xACEF) ; HANGUL SYLLABLE KIYEOK-O-RIEULHIEUH
     (?$(C0u(B . ?\xACF0) ; HANGUL SYLLABLE KIYEOK-O-MIEUM
     (?$(C0v(B . ?\xACF1) ; HANGUL SYLLABLE KIYEOK-O-PIEUP
     (?$(C0w(B . ?\xACF3) ; HANGUL SYLLABLE KIYEOK-O-SIOS
     (?$(C0x(B . ?\xACF5) ; HANGUL SYLLABLE KIYEOK-O-IEUNG
     (?$(C0y(B . ?\xACF6) ; HANGUL SYLLABLE KIYEOK-O-CIEUC
     (?$(C0z(B . ?\xACFC) ; HANGUL SYLLABLE KIYEOK-WA
     (?$(C0{(B . ?\xACFD) ; HANGUL SYLLABLE KIYEOK-WA-KIYEOK
     (?$(C0|(B . ?\xAD00) ; HANGUL SYLLABLE KIYEOK-WA-NIEUN
     (?$(C0}(B . ?\xAD04) ; HANGUL SYLLABLE KIYEOK-WA-RIEUL
     (?$(C0~(B . ?\xAD06) ; HANGUL SYLLABLE KIYEOK-WA-RIEULMIEUM
     (?$(C1!(B . ?\xAD0C) ; HANGUL SYLLABLE KIYEOK-WA-MIEUM
     (?$(C1"(B . ?\xAD0D) ; HANGUL SYLLABLE KIYEOK-WA-PIEUP
     (?$(C1#(B . ?\xAD0F) ; HANGUL SYLLABLE KIYEOK-WA-SIOS
     (?$(C1$(B . ?\xAD11) ; HANGUL SYLLABLE KIYEOK-WA-IEUNG
     (?$(C1%(B . ?\xAD18) ; HANGUL SYLLABLE KIYEOK-WAE
     (?$(C1&(B . ?\xAD1C) ; HANGUL SYLLABLE KIYEOK-WAE-NIEUN
     (?$(C1'(B . ?\xAD20) ; HANGUL SYLLABLE KIYEOK-WAE-RIEUL
     (?$(C1((B . ?\xAD29) ; HANGUL SYLLABLE KIYEOK-WAE-PIEUP
     (?$(C1)(B . ?\xAD2C) ; HANGUL SYLLABLE KIYEOK-WAE-SSANGSIOS
     (?$(C1*(B . ?\xAD2D) ; HANGUL SYLLABLE KIYEOK-WAE-IEUNG
     (?$(C1+(B . ?\xAD34) ; HANGUL SYLLABLE KIYEOK-OE
     (?$(C1,(B . ?\xAD35) ; HANGUL SYLLABLE KIYEOK-OE-KIYEOK
     (?$(C1-(B . ?\xAD38) ; HANGUL SYLLABLE KIYEOK-OE-NIEUN
     (?$(C1.(B . ?\xAD3C) ; HANGUL SYLLABLE KIYEOK-OE-RIEUL
     (?$(C1/(B . ?\xAD44) ; HANGUL SYLLABLE KIYEOK-OE-MIEUM
     (?$(C10(B . ?\xAD45) ; HANGUL SYLLABLE KIYEOK-OE-PIEUP
     (?$(C11(B . ?\xAD47) ; HANGUL SYLLABLE KIYEOK-OE-SIOS
     (?$(C12(B . ?\xAD49) ; HANGUL SYLLABLE KIYEOK-OE-IEUNG
     (?$(C13(B . ?\xAD50) ; HANGUL SYLLABLE KIYEOK-YO
     (?$(C14(B . ?\xAD54) ; HANGUL SYLLABLE KIYEOK-YO-NIEUN
     (?$(C15(B . ?\xAD58) ; HANGUL SYLLABLE KIYEOK-YO-RIEUL
     (?$(C16(B . ?\xAD61) ; HANGUL SYLLABLE KIYEOK-YO-PIEUP
     (?$(C17(B . ?\xAD63) ; HANGUL SYLLABLE KIYEOK-YO-SIOS
     (?$(C18(B . ?\xAD6C) ; HANGUL SYLLABLE KIYEOK-U
     (?$(C19(B . ?\xAD6D) ; HANGUL SYLLABLE KIYEOK-U-KIYEOK
     (?$(C1:(B . ?\xAD70) ; HANGUL SYLLABLE KIYEOK-U-NIEUN
     (?$(C1;(B . ?\xAD73) ; HANGUL SYLLABLE KIYEOK-U-TIKEUT
     (?$(C1<(B . ?\xAD74) ; HANGUL SYLLABLE KIYEOK-U-RIEUL
     (?$(C1=(B . ?\xAD75) ; HANGUL SYLLABLE KIYEOK-U-RIEULKIYEOK
     (?$(C1>(B . ?\xAD76) ; HANGUL SYLLABLE KIYEOK-U-RIEULMIEUM
     (?$(C1?(B . ?\xAD7B) ; HANGUL SYLLABLE KIYEOK-U-RIEULHIEUH
     (?$(C1@(B . ?\xAD7C) ; HANGUL SYLLABLE KIYEOK-U-MIEUM
     (?$(C1A(B . ?\xAD7D) ; HANGUL SYLLABLE KIYEOK-U-PIEUP
     (?$(C1B(B . ?\xAD7F) ; HANGUL SYLLABLE KIYEOK-U-SIOS
     (?$(C1C(B . ?\xAD81) ; HANGUL SYLLABLE KIYEOK-U-IEUNG
     (?$(C1D(B . ?\xAD82) ; HANGUL SYLLABLE KIYEOK-U-CIEUC
     (?$(C1E(B . ?\xAD88) ; HANGUL SYLLABLE KIYEOK-WEO
     (?$(C1F(B . ?\xAD89) ; HANGUL SYLLABLE KIYEOK-WEO-KIYEOK
     (?$(C1G(B . ?\xAD8C) ; HANGUL SYLLABLE KIYEOK-WEO-NIEUN
     (?$(C1H(B . ?\xAD90) ; HANGUL SYLLABLE KIYEOK-WEO-RIEUL
     (?$(C1I(B . ?\xAD9C) ; HANGUL SYLLABLE KIYEOK-WEO-SSANGSIOS
     (?$(C1J(B . ?\xAD9D) ; HANGUL SYLLABLE KIYEOK-WEO-IEUNG
     (?$(C1K(B . ?\xADA4) ; HANGUL SYLLABLE KIYEOK-WE
     (?$(C1L(B . ?\xADB7) ; HANGUL SYLLABLE KIYEOK-WE-SIOS
     (?$(C1M(B . ?\xADC0) ; HANGUL SYLLABLE KIYEOK-WI
     (?$(C1N(B . ?\xADC1) ; HANGUL SYLLABLE KIYEOK-WI-KIYEOK
     (?$(C1O(B . ?\xADC4) ; HANGUL SYLLABLE KIYEOK-WI-NIEUN
     (?$(C1P(B . ?\xADC8) ; HANGUL SYLLABLE KIYEOK-WI-RIEUL
     (?$(C1Q(B . ?\xADD0) ; HANGUL SYLLABLE KIYEOK-WI-MIEUM
     (?$(C1R(B . ?\xADD1) ; HANGUL SYLLABLE KIYEOK-WI-PIEUP
     (?$(C1S(B . ?\xADD3) ; HANGUL SYLLABLE KIYEOK-WI-SIOS
     (?$(C1T(B . ?\xADDC) ; HANGUL SYLLABLE KIYEOK-YU
     (?$(C1U(B . ?\xADE0) ; HANGUL SYLLABLE KIYEOK-YU-NIEUN
     (?$(C1V(B . ?\xADE4) ; HANGUL SYLLABLE KIYEOK-YU-RIEUL
     (?$(C1W(B . ?\xADF8) ; HANGUL SYLLABLE KIYEOK-EU
     (?$(C1X(B . ?\xADF9) ; HANGUL SYLLABLE KIYEOK-EU-KIYEOK
     (?$(C1Y(B . ?\xADFC) ; HANGUL SYLLABLE KIYEOK-EU-NIEUN
     (?$(C1Z(B . ?\xADFF) ; HANGUL SYLLABLE KIYEOK-EU-TIKEUT
     (?$(C1[(B . ?\xAE00) ; HANGUL SYLLABLE KIYEOK-EU-RIEUL
     (?$(C1\(B . ?\xAE01) ; HANGUL SYLLABLE KIYEOK-EU-RIEULKIYEOK
     (?$(C1](B . ?\xAE08) ; HANGUL SYLLABLE KIYEOK-EU-MIEUM
     (?$(C1^(B . ?\xAE09) ; HANGUL SYLLABLE KIYEOK-EU-PIEUP
     (?$(C1_(B . ?\xAE0B) ; HANGUL SYLLABLE KIYEOK-EU-SIOS
     (?$(C1`(B . ?\xAE0D) ; HANGUL SYLLABLE KIYEOK-EU-IEUNG
     (?$(C1a(B . ?\xAE14) ; HANGUL SYLLABLE KIYEOK-YI
     (?$(C1b(B . ?\xAE30) ; HANGUL SYLLABLE KIYEOK-I
     (?$(C1c(B . ?\xAE31) ; HANGUL SYLLABLE KIYEOK-I-KIYEOK
     (?$(C1d(B . ?\xAE34) ; HANGUL SYLLABLE KIYEOK-I-NIEUN
     (?$(C1e(B . ?\xAE37) ; HANGUL SYLLABLE KIYEOK-I-TIKEUT
     (?$(C1f(B . ?\xAE38) ; HANGUL SYLLABLE KIYEOK-I-RIEUL
     (?$(C1g(B . ?\xAE3A) ; HANGUL SYLLABLE KIYEOK-I-RIEULMIEUM
     (?$(C1h(B . ?\xAE40) ; HANGUL SYLLABLE KIYEOK-I-MIEUM
     (?$(C1i(B . ?\xAE41) ; HANGUL SYLLABLE KIYEOK-I-PIEUP
     (?$(C1j(B . ?\xAE43) ; HANGUL SYLLABLE KIYEOK-I-SIOS
     (?$(C1k(B . ?\xAE45) ; HANGUL SYLLABLE KIYEOK-I-IEUNG
     (?$(C1l(B . ?\xAE46) ; HANGUL SYLLABLE KIYEOK-I-CIEUC
     (?$(C1m(B . ?\xAE4A) ; HANGUL SYLLABLE KIYEOK-I-PHIEUPH
     (?$(C1n(B . ?\xAE4C) ; HANGUL SYLLABLE SSANGKIYEOK-A
     (?$(C1o(B . ?\xAE4D) ; HANGUL SYLLABLE SSANGKIYEOK-A-KIYEOK
     (?$(C1p(B . ?\xAE4E) ; HANGUL SYLLABLE SSANGKIYEOK-A-SSANGKIYEOK
     (?$(C1q(B . ?\xAE50) ; HANGUL SYLLABLE SSANGKIYEOK-A-NIEUN
     (?$(C1r(B . ?\xAE54) ; HANGUL SYLLABLE SSANGKIYEOK-A-RIEUL
     (?$(C1s(B . ?\xAE56) ; HANGUL SYLLABLE SSANGKIYEOK-A-RIEULMIEUM
     (?$(C1t(B . ?\xAE5C) ; HANGUL SYLLABLE SSANGKIYEOK-A-MIEUM
     (?$(C1u(B . ?\xAE5D) ; HANGUL SYLLABLE SSANGKIYEOK-A-PIEUP
     (?$(C1v(B . ?\xAE5F) ; HANGUL SYLLABLE SSANGKIYEOK-A-SIOS
     (?$(C1w(B . ?\xAE60) ; HANGUL SYLLABLE SSANGKIYEOK-A-SSANGSIOS
     (?$(C1x(B . ?\xAE61) ; HANGUL SYLLABLE SSANGKIYEOK-A-IEUNG
     (?$(C1y(B . ?\xAE65) ; HANGUL SYLLABLE SSANGKIYEOK-A-THIEUTH
     (?$(C1z(B . ?\xAE68) ; HANGUL SYLLABLE SSANGKIYEOK-AE
     (?$(C1{(B . ?\xAE69) ; HANGUL SYLLABLE SSANGKIYEOK-AE-KIYEOK
     (?$(C1|(B . ?\xAE6C) ; HANGUL SYLLABLE SSANGKIYEOK-AE-NIEUN
     (?$(C1}(B . ?\xAE70) ; HANGUL SYLLABLE SSANGKIYEOK-AE-RIEUL
     (?$(C1~(B . ?\xAE78) ; HANGUL SYLLABLE SSANGKIYEOK-AE-MIEUM
     (?$(C2!(B . ?\xAE79) ; HANGUL SYLLABLE SSANGKIYEOK-AE-PIEUP
     (?$(C2"(B . ?\xAE7B) ; HANGUL SYLLABLE SSANGKIYEOK-AE-SIOS
     (?$(C2#(B . ?\xAE7C) ; HANGUL SYLLABLE SSANGKIYEOK-AE-SSANGSIOS
     (?$(C2$(B . ?\xAE7D) ; HANGUL SYLLABLE SSANGKIYEOK-AE-IEUNG
     (?$(C2%(B . ?\xAE84) ; HANGUL SYLLABLE SSANGKIYEOK-YA
     (?$(C2&(B . ?\xAE85) ; HANGUL SYLLABLE SSANGKIYEOK-YA-KIYEOK
     (?$(C2'(B . ?\xAE8C) ; HANGUL SYLLABLE SSANGKIYEOK-YA-RIEUL
     (?$(C2((B . ?\xAEBC) ; HANGUL SYLLABLE SSANGKIYEOK-EO
     (?$(C2)(B . ?\xAEBD) ; HANGUL SYLLABLE SSANGKIYEOK-EO-KIYEOK
     (?$(C2*(B . ?\xAEBE) ; HANGUL SYLLABLE SSANGKIYEOK-EO-SSANGKIYEOK
     (?$(C2+(B . ?\xAEC0) ; HANGUL SYLLABLE SSANGKIYEOK-EO-NIEUN
     (?$(C2,(B . ?\xAEC4) ; HANGUL SYLLABLE SSANGKIYEOK-EO-RIEUL
     (?$(C2-(B . ?\xAECC) ; HANGUL SYLLABLE SSANGKIYEOK-EO-MIEUM
     (?$(C2.(B . ?\xAECD) ; HANGUL SYLLABLE SSANGKIYEOK-EO-PIEUP
     (?$(C2/(B . ?\xAECF) ; HANGUL SYLLABLE SSANGKIYEOK-EO-SIOS
     (?$(C20(B . ?\xAED0) ; HANGUL SYLLABLE SSANGKIYEOK-EO-SSANGSIOS
     (?$(C21(B . ?\xAED1) ; HANGUL SYLLABLE SSANGKIYEOK-EO-IEUNG
     (?$(C22(B . ?\xAED8) ; HANGUL SYLLABLE SSANGKIYEOK-E
     (?$(C23(B . ?\xAED9) ; HANGUL SYLLABLE SSANGKIYEOK-E-KIYEOK
     (?$(C24(B . ?\xAEDC) ; HANGUL SYLLABLE SSANGKIYEOK-E-NIEUN
     (?$(C25(B . ?\xAEE8) ; HANGUL SYLLABLE SSANGKIYEOK-E-MIEUM
     (?$(C26(B . ?\xAEEB) ; HANGUL SYLLABLE SSANGKIYEOK-E-SIOS
     (?$(C27(B . ?\xAEED) ; HANGUL SYLLABLE SSANGKIYEOK-E-IEUNG
     (?$(C28(B . ?\xAEF4) ; HANGUL SYLLABLE SSANGKIYEOK-YEO
     (?$(C29(B . ?\xAEF8) ; HANGUL SYLLABLE SSANGKIYEOK-YEO-NIEUN
     (?$(C2:(B . ?\xAEFC) ; HANGUL SYLLABLE SSANGKIYEOK-YEO-RIEUL
     (?$(C2;(B . ?\xAF07) ; HANGUL SYLLABLE SSANGKIYEOK-YEO-SIOS
     (?$(C2<(B . ?\xAF08) ; HANGUL SYLLABLE SSANGKIYEOK-YEO-SSANGSIOS
     (?$(C2=(B . ?\xAF0D) ; HANGUL SYLLABLE SSANGKIYEOK-YEO-THIEUTH
     (?$(C2>(B . ?\xAF10) ; HANGUL SYLLABLE SSANGKIYEOK-YE
     (?$(C2?(B . ?\xAF2C) ; HANGUL SYLLABLE SSANGKIYEOK-O
     (?$(C2@(B . ?\xAF2D) ; HANGUL SYLLABLE SSANGKIYEOK-O-KIYEOK
     (?$(C2A(B . ?\xAF30) ; HANGUL SYLLABLE SSANGKIYEOK-O-NIEUN
     (?$(C2B(B . ?\xAF32) ; HANGUL SYLLABLE SSANGKIYEOK-O-NIEUNHIEUH
     (?$(C2C(B . ?\xAF34) ; HANGUL SYLLABLE SSANGKIYEOK-O-RIEUL
     (?$(C2D(B . ?\xAF3C) ; HANGUL SYLLABLE SSANGKIYEOK-O-MIEUM
     (?$(C2E(B . ?\xAF3D) ; HANGUL SYLLABLE SSANGKIYEOK-O-PIEUP
     (?$(C2F(B . ?\xAF3F) ; HANGUL SYLLABLE SSANGKIYEOK-O-SIOS
     (?$(C2G(B . ?\xAF41) ; HANGUL SYLLABLE SSANGKIYEOK-O-IEUNG
     (?$(C2H(B . ?\xAF42) ; HANGUL SYLLABLE SSANGKIYEOK-O-CIEUC
     (?$(C2I(B . ?\xAF43) ; HANGUL SYLLABLE SSANGKIYEOK-O-CHIEUCH
     (?$(C2J(B . ?\xAF48) ; HANGUL SYLLABLE SSANGKIYEOK-WA
     (?$(C2K(B . ?\xAF49) ; HANGUL SYLLABLE SSANGKIYEOK-WA-KIYEOK
     (?$(C2L(B . ?\xAF50) ; HANGUL SYLLABLE SSANGKIYEOK-WA-RIEUL
     (?$(C2M(B . ?\xAF5C) ; HANGUL SYLLABLE SSANGKIYEOK-WA-SSANGSIOS
     (?$(C2N(B . ?\xAF5D) ; HANGUL SYLLABLE SSANGKIYEOK-WA-IEUNG
     (?$(C2O(B . ?\xAF64) ; HANGUL SYLLABLE SSANGKIYEOK-WAE
     (?$(C2P(B . ?\xAF65) ; HANGUL SYLLABLE SSANGKIYEOK-WAE-KIYEOK
     (?$(C2Q(B . ?\xAF79) ; HANGUL SYLLABLE SSANGKIYEOK-WAE-IEUNG
     (?$(C2R(B . ?\xAF80) ; HANGUL SYLLABLE SSANGKIYEOK-OE
     (?$(C2S(B . ?\xAF84) ; HANGUL SYLLABLE SSANGKIYEOK-OE-NIEUN
     (?$(C2T(B . ?\xAF88) ; HANGUL SYLLABLE SSANGKIYEOK-OE-RIEUL
     (?$(C2U(B . ?\xAF90) ; HANGUL SYLLABLE SSANGKIYEOK-OE-MIEUM
     (?$(C2V(B . ?\xAF91) ; HANGUL SYLLABLE SSANGKIYEOK-OE-PIEUP
     (?$(C2W(B . ?\xAF95) ; HANGUL SYLLABLE SSANGKIYEOK-OE-IEUNG
     (?$(C2X(B . ?\xAF9C) ; HANGUL SYLLABLE SSANGKIYEOK-YO
     (?$(C2Y(B . ?\xAFB8) ; HANGUL SYLLABLE SSANGKIYEOK-U
     (?$(C2Z(B . ?\xAFB9) ; HANGUL SYLLABLE SSANGKIYEOK-U-KIYEOK
     (?$(C2[(B . ?\xAFBC) ; HANGUL SYLLABLE SSANGKIYEOK-U-NIEUN
     (?$(C2\(B . ?\xAFC0) ; HANGUL SYLLABLE SSANGKIYEOK-U-RIEUL
     (?$(C2](B . ?\xAFC7) ; HANGUL SYLLABLE SSANGKIYEOK-U-RIEULHIEUH
     (?$(C2^(B . ?\xAFC8) ; HANGUL SYLLABLE SSANGKIYEOK-U-MIEUM
     (?$(C2_(B . ?\xAFC9) ; HANGUL SYLLABLE SSANGKIYEOK-U-PIEUP
     (?$(C2`(B . ?\xAFCB) ; HANGUL SYLLABLE SSANGKIYEOK-U-SIOS
     (?$(C2a(B . ?\xAFCD) ; HANGUL SYLLABLE SSANGKIYEOK-U-IEUNG
     (?$(C2b(B . ?\xAFCE) ; HANGUL SYLLABLE SSANGKIYEOK-U-CIEUC
     (?$(C2c(B . ?\xAFD4) ; HANGUL SYLLABLE SSANGKIYEOK-WEO
     (?$(C2d(B . ?\xAFDC) ; HANGUL SYLLABLE SSANGKIYEOK-WEO-RIEUL
     (?$(C2e(B . ?\xAFE8) ; HANGUL SYLLABLE SSANGKIYEOK-WEO-SSANGSIOS
     (?$(C2f(B . ?\xAFE9) ; HANGUL SYLLABLE SSANGKIYEOK-WEO-IEUNG
     (?$(C2g(B . ?\xAFF0) ; HANGUL SYLLABLE SSANGKIYEOK-WE
     (?$(C2h(B . ?\xAFF1) ; HANGUL SYLLABLE SSANGKIYEOK-WE-KIYEOK
     (?$(C2i(B . ?\xAFF4) ; HANGUL SYLLABLE SSANGKIYEOK-WE-NIEUN
     (?$(C2j(B . ?\xAFF8) ; HANGUL SYLLABLE SSANGKIYEOK-WE-RIEUL
     (?$(C2k(B . ?\xB000) ; HANGUL SYLLABLE SSANGKIYEOK-WE-MIEUM
     (?$(C2l(B . ?\xB001) ; HANGUL SYLLABLE SSANGKIYEOK-WE-PIEUP
     (?$(C2m(B . ?\xB004) ; HANGUL SYLLABLE SSANGKIYEOK-WE-SSANGSIOS
     (?$(C2n(B . ?\xB00C) ; HANGUL SYLLABLE SSANGKIYEOK-WI
     (?$(C2o(B . ?\xB010) ; HANGUL SYLLABLE SSANGKIYEOK-WI-NIEUN
     (?$(C2p(B . ?\xB014) ; HANGUL SYLLABLE SSANGKIYEOK-WI-RIEUL
     (?$(C2q(B . ?\xB01C) ; HANGUL SYLLABLE SSANGKIYEOK-WI-MIEUM
     (?$(C2r(B . ?\xB01D) ; HANGUL SYLLABLE SSANGKIYEOK-WI-PIEUP
     (?$(C2s(B . ?\xB028) ; HANGUL SYLLABLE SSANGKIYEOK-YU
     (?$(C2t(B . ?\xB044) ; HANGUL SYLLABLE SSANGKIYEOK-EU
     (?$(C2u(B . ?\xB045) ; HANGUL SYLLABLE SSANGKIYEOK-EU-KIYEOK
     (?$(C2v(B . ?\xB048) ; HANGUL SYLLABLE SSANGKIYEOK-EU-NIEUN
     (?$(C2w(B . ?\xB04A) ; HANGUL SYLLABLE SSANGKIYEOK-EU-NIEUNHIEUH
     (?$(C2x(B . ?\xB04C) ; HANGUL SYLLABLE SSANGKIYEOK-EU-RIEUL
     (?$(C2y(B . ?\xB04E) ; HANGUL SYLLABLE SSANGKIYEOK-EU-RIEULMIEUM
     (?$(C2z(B . ?\xB053) ; HANGUL SYLLABLE SSANGKIYEOK-EU-RIEULHIEUH
     (?$(C2{(B . ?\xB054) ; HANGUL SYLLABLE SSANGKIYEOK-EU-MIEUM
     (?$(C2|(B . ?\xB055) ; HANGUL SYLLABLE SSANGKIYEOK-EU-PIEUP
     (?$(C2}(B . ?\xB057) ; HANGUL SYLLABLE SSANGKIYEOK-EU-SIOS
     (?$(C2~(B . ?\xB059) ; HANGUL SYLLABLE SSANGKIYEOK-EU-IEUNG
     (?$(C3!(B . ?\xB05D) ; HANGUL SYLLABLE SSANGKIYEOK-EU-THIEUTH
     (?$(C3"(B . ?\xB07C) ; HANGUL SYLLABLE SSANGKIYEOK-I
     (?$(C3#(B . ?\xB07D) ; HANGUL SYLLABLE SSANGKIYEOK-I-KIYEOK
     (?$(C3$(B . ?\xB080) ; HANGUL SYLLABLE SSANGKIYEOK-I-NIEUN
     (?$(C3%(B . ?\xB084) ; HANGUL SYLLABLE SSANGKIYEOK-I-RIEUL
     (?$(C3&(B . ?\xB08C) ; HANGUL SYLLABLE SSANGKIYEOK-I-MIEUM
     (?$(C3'(B . ?\xB08D) ; HANGUL SYLLABLE SSANGKIYEOK-I-PIEUP
     (?$(C3((B . ?\xB08F) ; HANGUL SYLLABLE SSANGKIYEOK-I-SIOS
     (?$(C3)(B . ?\xB091) ; HANGUL SYLLABLE SSANGKIYEOK-I-IEUNG
     (?$(C3*(B . ?\xB098) ; HANGUL SYLLABLE NIEUN-A
     (?$(C3+(B . ?\xB099) ; HANGUL SYLLABLE NIEUN-A-KIYEOK
     (?$(C3,(B . ?\xB09A) ; HANGUL SYLLABLE NIEUN-A-SSANGKIYEOK
     (?$(C3-(B . ?\xB09C) ; HANGUL SYLLABLE NIEUN-A-NIEUN
     (?$(C3.(B . ?\xB09F) ; HANGUL SYLLABLE NIEUN-A-TIKEUT
     (?$(C3/(B . ?\xB0A0) ; HANGUL SYLLABLE NIEUN-A-RIEUL
     (?$(C30(B . ?\xB0A1) ; HANGUL SYLLABLE NIEUN-A-RIEULKIYEOK
     (?$(C31(B . ?\xB0A2) ; HANGUL SYLLABLE NIEUN-A-RIEULMIEUM
     (?$(C32(B . ?\xB0A8) ; HANGUL SYLLABLE NIEUN-A-MIEUM
     (?$(C33(B . ?\xB0A9) ; HANGUL SYLLABLE NIEUN-A-PIEUP
     (?$(C34(B . ?\xB0AB) ; HANGUL SYLLABLE NIEUN-A-SIOS
     (?$(C35(B . ?\xB0AC) ; HANGUL SYLLABLE NIEUN-A-SSANGSIOS
     (?$(C36(B . ?\xB0AD) ; HANGUL SYLLABLE NIEUN-A-IEUNG
     (?$(C37(B . ?\xB0AE) ; HANGUL SYLLABLE NIEUN-A-CIEUC
     (?$(C38(B . ?\xB0AF) ; HANGUL SYLLABLE NIEUN-A-CHIEUCH
     (?$(C39(B . ?\xB0B1) ; HANGUL SYLLABLE NIEUN-A-THIEUTH
     (?$(C3:(B . ?\xB0B3) ; HANGUL SYLLABLE NIEUN-A-HIEUH
     (?$(C3;(B . ?\xB0B4) ; HANGUL SYLLABLE NIEUN-AE
     (?$(C3<(B . ?\xB0B5) ; HANGUL SYLLABLE NIEUN-AE-KIYEOK
     (?$(C3=(B . ?\xB0B8) ; HANGUL SYLLABLE NIEUN-AE-NIEUN
     (?$(C3>(B . ?\xB0BC) ; HANGUL SYLLABLE NIEUN-AE-RIEUL
     (?$(C3?(B . ?\xB0C4) ; HANGUL SYLLABLE NIEUN-AE-MIEUM
     (?$(C3@(B . ?\xB0C5) ; HANGUL SYLLABLE NIEUN-AE-PIEUP
     (?$(C3A(B . ?\xB0C7) ; HANGUL SYLLABLE NIEUN-AE-SIOS
     (?$(C3B(B . ?\xB0C8) ; HANGUL SYLLABLE NIEUN-AE-SSANGSIOS
     (?$(C3C(B . ?\xB0C9) ; HANGUL SYLLABLE NIEUN-AE-IEUNG
     (?$(C3D(B . ?\xB0D0) ; HANGUL SYLLABLE NIEUN-YA
     (?$(C3E(B . ?\xB0D1) ; HANGUL SYLLABLE NIEUN-YA-KIYEOK
     (?$(C3F(B . ?\xB0D4) ; HANGUL SYLLABLE NIEUN-YA-NIEUN
     (?$(C3G(B . ?\xB0D8) ; HANGUL SYLLABLE NIEUN-YA-RIEUL
     (?$(C3H(B . ?\xB0E0) ; HANGUL SYLLABLE NIEUN-YA-MIEUM
     (?$(C3I(B . ?\xB0E5) ; HANGUL SYLLABLE NIEUN-YA-IEUNG
     (?$(C3J(B . ?\xB108) ; HANGUL SYLLABLE NIEUN-EO
     (?$(C3K(B . ?\xB109) ; HANGUL SYLLABLE NIEUN-EO-KIYEOK
     (?$(C3L(B . ?\xB10B) ; HANGUL SYLLABLE NIEUN-EO-KIYEOKSIOS
     (?$(C3M(B . ?\xB10C) ; HANGUL SYLLABLE NIEUN-EO-NIEUN
     (?$(C3N(B . ?\xB110) ; HANGUL SYLLABLE NIEUN-EO-RIEUL
     (?$(C3O(B . ?\xB112) ; HANGUL SYLLABLE NIEUN-EO-RIEULMIEUM
     (?$(C3P(B . ?\xB113) ; HANGUL SYLLABLE NIEUN-EO-RIEULPIEUP
     (?$(C3Q(B . ?\xB118) ; HANGUL SYLLABLE NIEUN-EO-MIEUM
     (?$(C3R(B . ?\xB119) ; HANGUL SYLLABLE NIEUN-EO-PIEUP
     (?$(C3S(B . ?\xB11B) ; HANGUL SYLLABLE NIEUN-EO-SIOS
     (?$(C3T(B . ?\xB11C) ; HANGUL SYLLABLE NIEUN-EO-SSANGSIOS
     (?$(C3U(B . ?\xB11D) ; HANGUL SYLLABLE NIEUN-EO-IEUNG
     (?$(C3V(B . ?\xB123) ; HANGUL SYLLABLE NIEUN-EO-HIEUH
     (?$(C3W(B . ?\xB124) ; HANGUL SYLLABLE NIEUN-E
     (?$(C3X(B . ?\xB125) ; HANGUL SYLLABLE NIEUN-E-KIYEOK
     (?$(C3Y(B . ?\xB128) ; HANGUL SYLLABLE NIEUN-E-NIEUN
     (?$(C3Z(B . ?\xB12C) ; HANGUL SYLLABLE NIEUN-E-RIEUL
     (?$(C3[(B . ?\xB134) ; HANGUL SYLLABLE NIEUN-E-MIEUM
     (?$(C3\(B . ?\xB135) ; HANGUL SYLLABLE NIEUN-E-PIEUP
     (?$(C3](B . ?\xB137) ; HANGUL SYLLABLE NIEUN-E-SIOS
     (?$(C3^(B . ?\xB138) ; HANGUL SYLLABLE NIEUN-E-SSANGSIOS
     (?$(C3_(B . ?\xB139) ; HANGUL SYLLABLE NIEUN-E-IEUNG
     (?$(C3`(B . ?\xB140) ; HANGUL SYLLABLE NIEUN-YEO
     (?$(C3a(B . ?\xB141) ; HANGUL SYLLABLE NIEUN-YEO-KIYEOK
     (?$(C3b(B . ?\xB144) ; HANGUL SYLLABLE NIEUN-YEO-NIEUN
     (?$(C3c(B . ?\xB148) ; HANGUL SYLLABLE NIEUN-YEO-RIEUL
     (?$(C3d(B . ?\xB150) ; HANGUL SYLLABLE NIEUN-YEO-MIEUM
     (?$(C3e(B . ?\xB151) ; HANGUL SYLLABLE NIEUN-YEO-PIEUP
     (?$(C3f(B . ?\xB154) ; HANGUL SYLLABLE NIEUN-YEO-SSANGSIOS
     (?$(C3g(B . ?\xB155) ; HANGUL SYLLABLE NIEUN-YEO-IEUNG
     (?$(C3h(B . ?\xB158) ; HANGUL SYLLABLE NIEUN-YEO-KHIEUKH
     (?$(C3i(B . ?\xB15C) ; HANGUL SYLLABLE NIEUN-YE
     (?$(C3j(B . ?\xB160) ; HANGUL SYLLABLE NIEUN-YE-NIEUN
     (?$(C3k(B . ?\xB178) ; HANGUL SYLLABLE NIEUN-O
     (?$(C3l(B . ?\xB179) ; HANGUL SYLLABLE NIEUN-O-KIYEOK
     (?$(C3m(B . ?\xB17C) ; HANGUL SYLLABLE NIEUN-O-NIEUN
     (?$(C3n(B . ?\xB180) ; HANGUL SYLLABLE NIEUN-O-RIEUL
     (?$(C3o(B . ?\xB182) ; HANGUL SYLLABLE NIEUN-O-RIEULMIEUM
     (?$(C3p(B . ?\xB188) ; HANGUL SYLLABLE NIEUN-O-MIEUM
     (?$(C3q(B . ?\xB189) ; HANGUL SYLLABLE NIEUN-O-PIEUP
     (?$(C3r(B . ?\xB18B) ; HANGUL SYLLABLE NIEUN-O-SIOS
     (?$(C3s(B . ?\xB18D) ; HANGUL SYLLABLE NIEUN-O-IEUNG
     (?$(C3t(B . ?\xB192) ; HANGUL SYLLABLE NIEUN-O-PHIEUPH
     (?$(C3u(B . ?\xB193) ; HANGUL SYLLABLE NIEUN-O-HIEUH
     (?$(C3v(B . ?\xB194) ; HANGUL SYLLABLE NIEUN-WA
     (?$(C3w(B . ?\xB198) ; HANGUL SYLLABLE NIEUN-WA-NIEUN
     (?$(C3x(B . ?\xB19C) ; HANGUL SYLLABLE NIEUN-WA-RIEUL
     (?$(C3y(B . ?\xB1A8) ; HANGUL SYLLABLE NIEUN-WA-SSANGSIOS
     (?$(C3z(B . ?\xB1CC) ; HANGUL SYLLABLE NIEUN-OE
     (?$(C3{(B . ?\xB1D0) ; HANGUL SYLLABLE NIEUN-OE-NIEUN
     (?$(C3|(B . ?\xB1D4) ; HANGUL SYLLABLE NIEUN-OE-RIEUL
     (?$(C3}(B . ?\xB1DC) ; HANGUL SYLLABLE NIEUN-OE-MIEUM
     (?$(C3~(B . ?\xB1DD) ; HANGUL SYLLABLE NIEUN-OE-PIEUP
     (?$(C4!(B . ?\xB1DF) ; HANGUL SYLLABLE NIEUN-OE-SIOS
     (?$(C4"(B . ?\xB1E8) ; HANGUL SYLLABLE NIEUN-YO
     (?$(C4#(B . ?\xB1E9) ; HANGUL SYLLABLE NIEUN-YO-KIYEOK
     (?$(C4$(B . ?\xB1EC) ; HANGUL SYLLABLE NIEUN-YO-NIEUN
     (?$(C4%(B . ?\xB1F0) ; HANGUL SYLLABLE NIEUN-YO-RIEUL
     (?$(C4&(B . ?\xB1F9) ; HANGUL SYLLABLE NIEUN-YO-PIEUP
     (?$(C4'(B . ?\xB1FB) ; HANGUL SYLLABLE NIEUN-YO-SIOS
     (?$(C4((B . ?\xB1FD) ; HANGUL SYLLABLE NIEUN-YO-IEUNG
     (?$(C4)(B . ?\xB204) ; HANGUL SYLLABLE NIEUN-U
     (?$(C4*(B . ?\xB205) ; HANGUL SYLLABLE NIEUN-U-KIYEOK
     (?$(C4+(B . ?\xB208) ; HANGUL SYLLABLE NIEUN-U-NIEUN
     (?$(C4,(B . ?\xB20B) ; HANGUL SYLLABLE NIEUN-U-TIKEUT
     (?$(C4-(B . ?\xB20C) ; HANGUL SYLLABLE NIEUN-U-RIEUL
     (?$(C4.(B . ?\xB214) ; HANGUL SYLLABLE NIEUN-U-MIEUM
     (?$(C4/(B . ?\xB215) ; HANGUL SYLLABLE NIEUN-U-PIEUP
     (?$(C40(B . ?\xB217) ; HANGUL SYLLABLE NIEUN-U-SIOS
     (?$(C41(B . ?\xB219) ; HANGUL SYLLABLE NIEUN-U-IEUNG
     (?$(C42(B . ?\xB220) ; HANGUL SYLLABLE NIEUN-WEO
     (?$(C43(B . ?\xB234) ; HANGUL SYLLABLE NIEUN-WEO-SSANGSIOS
     (?$(C44(B . ?\xB23C) ; HANGUL SYLLABLE NIEUN-WE
     (?$(C45(B . ?\xB258) ; HANGUL SYLLABLE NIEUN-WI
     (?$(C46(B . ?\xB25C) ; HANGUL SYLLABLE NIEUN-WI-NIEUN
     (?$(C47(B . ?\xB260) ; HANGUL SYLLABLE NIEUN-WI-RIEUL
     (?$(C48(B . ?\xB268) ; HANGUL SYLLABLE NIEUN-WI-MIEUM
     (?$(C49(B . ?\xB269) ; HANGUL SYLLABLE NIEUN-WI-PIEUP
     (?$(C4:(B . ?\xB274) ; HANGUL SYLLABLE NIEUN-YU
     (?$(C4;(B . ?\xB275) ; HANGUL SYLLABLE NIEUN-YU-KIYEOK
     (?$(C4<(B . ?\xB27C) ; HANGUL SYLLABLE NIEUN-YU-RIEUL
     (?$(C4=(B . ?\xB284) ; HANGUL SYLLABLE NIEUN-YU-MIEUM
     (?$(C4>(B . ?\xB285) ; HANGUL SYLLABLE NIEUN-YU-PIEUP
     (?$(C4?(B . ?\xB289) ; HANGUL SYLLABLE NIEUN-YU-IEUNG
     (?$(C4@(B . ?\xB290) ; HANGUL SYLLABLE NIEUN-EU
     (?$(C4A(B . ?\xB291) ; HANGUL SYLLABLE NIEUN-EU-KIYEOK
     (?$(C4B(B . ?\xB294) ; HANGUL SYLLABLE NIEUN-EU-NIEUN
     (?$(C4C(B . ?\xB298) ; HANGUL SYLLABLE NIEUN-EU-RIEUL
     (?$(C4D(B . ?\xB299) ; HANGUL SYLLABLE NIEUN-EU-RIEULKIYEOK
     (?$(C4E(B . ?\xB29A) ; HANGUL SYLLABLE NIEUN-EU-RIEULMIEUM
     (?$(C4F(B . ?\xB2A0) ; HANGUL SYLLABLE NIEUN-EU-MIEUM
     (?$(C4G(B . ?\xB2A1) ; HANGUL SYLLABLE NIEUN-EU-PIEUP
     (?$(C4H(B . ?\xB2A3) ; HANGUL SYLLABLE NIEUN-EU-SIOS
     (?$(C4I(B . ?\xB2A5) ; HANGUL SYLLABLE NIEUN-EU-IEUNG
     (?$(C4J(B . ?\xB2A6) ; HANGUL SYLLABLE NIEUN-EU-CIEUC
     (?$(C4K(B . ?\xB2AA) ; HANGUL SYLLABLE NIEUN-EU-PHIEUPH
     (?$(C4L(B . ?\xB2AC) ; HANGUL SYLLABLE NIEUN-YI
     (?$(C4M(B . ?\xB2B0) ; HANGUL SYLLABLE NIEUN-YI-NIEUN
     (?$(C4N(B . ?\xB2B4) ; HANGUL SYLLABLE NIEUN-YI-RIEUL
     (?$(C4O(B . ?\xB2C8) ; HANGUL SYLLABLE NIEUN-I
     (?$(C4P(B . ?\xB2C9) ; HANGUL SYLLABLE NIEUN-I-KIYEOK
     (?$(C4Q(B . ?\xB2CC) ; HANGUL SYLLABLE NIEUN-I-NIEUN
     (?$(C4R(B . ?\xB2D0) ; HANGUL SYLLABLE NIEUN-I-RIEUL
     (?$(C4S(B . ?\xB2D2) ; HANGUL SYLLABLE NIEUN-I-RIEULMIEUM-<3/22/95>
     (?$(C4T(B . ?\xB2D8) ; HANGUL SYLLABLE NIEUN-I-MIEUM
     (?$(C4U(B . ?\xB2D9) ; HANGUL SYLLABLE NIEUN-I-PIEUP
     (?$(C4V(B . ?\xB2DB) ; HANGUL SYLLABLE NIEUN-I-SIOS
     (?$(C4W(B . ?\xB2DD) ; HANGUL SYLLABLE NIEUN-I-IEUNG
     (?$(C4X(B . ?\xB2E2) ; HANGUL SYLLABLE NIEUN-I-PHIEUPH
     (?$(C4Y(B . ?\xB2E4) ; HANGUL SYLLABLE TIKEUT-A
     (?$(C4Z(B . ?\xB2E5) ; HANGUL SYLLABLE TIKEUT-A-KIYEOK
     (?$(C4[(B . ?\xB2E6) ; HANGUL SYLLABLE TIKEUT-A-SSANGKIYEOK
     (?$(C4\(B . ?\xB2E8) ; HANGUL SYLLABLE TIKEUT-A-NIEUN
     (?$(C4](B . ?\xB2EB) ; HANGUL SYLLABLE TIKEUT-A-TIKEUT
     (?$(C4^(B . ?\xB2EC) ; HANGUL SYLLABLE TIKEUT-A-RIEUL
     (?$(C4_(B . ?\xB2ED) ; HANGUL SYLLABLE TIKEUT-A-RIEULKIYEOK
     (?$(C4`(B . ?\xB2EE) ; HANGUL SYLLABLE TIKEUT-A-RIEULMIEUM
     (?$(C4a(B . ?\xB2EF) ; HANGUL SYLLABLE TIKEUT-A-RIEULPIEUP
     (?$(C4b(B . ?\xB2F3) ; HANGUL SYLLABLE TIKEUT-A-RIEULHIEUH
     (?$(C4c(B . ?\xB2F4) ; HANGUL SYLLABLE TIKEUT-A-MIEUM
     (?$(C4d(B . ?\xB2F5) ; HANGUL SYLLABLE TIKEUT-A-PIEUP
     (?$(C4e(B . ?\xB2F7) ; HANGUL SYLLABLE TIKEUT-A-SIOS
     (?$(C4f(B . ?\xB2F8) ; HANGUL SYLLABLE TIKEUT-A-SSANGSIOS
     (?$(C4g(B . ?\xB2F9) ; HANGUL SYLLABLE TIKEUT-A-IEUNG
     (?$(C4h(B . ?\xB2FA) ; HANGUL SYLLABLE TIKEUT-A-CIEUC
     (?$(C4i(B . ?\xB2FB) ; HANGUL SYLLABLE TIKEUT-A-CHIEUCH
     (?$(C4j(B . ?\xB2FF) ; HANGUL SYLLABLE TIKEUT-A-HIEUH
     (?$(C4k(B . ?\xB300) ; HANGUL SYLLABLE TIKEUT-AE
     (?$(C4l(B . ?\xB301) ; HANGUL SYLLABLE TIKEUT-AE-KIYEOK
     (?$(C4m(B . ?\xB304) ; HANGUL SYLLABLE TIKEUT-AE-NIEUN
     (?$(C4n(B . ?\xB308) ; HANGUL SYLLABLE TIKEUT-AE-RIEUL
     (?$(C4o(B . ?\xB310) ; HANGUL SYLLABLE TIKEUT-AE-MIEUM
     (?$(C4p(B . ?\xB311) ; HANGUL SYLLABLE TIKEUT-AE-PIEUP
     (?$(C4q(B . ?\xB313) ; HANGUL SYLLABLE TIKEUT-AE-SIOS
     (?$(C4r(B . ?\xB314) ; HANGUL SYLLABLE TIKEUT-AE-SSANGSIOS
     (?$(C4s(B . ?\xB315) ; HANGUL SYLLABLE TIKEUT-AE-IEUNG
     (?$(C4t(B . ?\xB31C) ; HANGUL SYLLABLE TIKEUT-YA
     (?$(C4u(B . ?\xB354) ; HANGUL SYLLABLE TIKEUT-EO
     (?$(C4v(B . ?\xB355) ; HANGUL SYLLABLE TIKEUT-EO-KIYEOK
     (?$(C4w(B . ?\xB356) ; HANGUL SYLLABLE TIKEUT-EO-SSANGKIYEOK
     (?$(C4x(B . ?\xB358) ; HANGUL SYLLABLE TIKEUT-EO-NIEUN
     (?$(C4y(B . ?\xB35B) ; HANGUL SYLLABLE TIKEUT-EO-TIKEUT
     (?$(C4z(B . ?\xB35C) ; HANGUL SYLLABLE TIKEUT-EO-RIEUL
     (?$(C4{(B . ?\xB35E) ; HANGUL SYLLABLE TIKEUT-EO-RIEULMIEUM
     (?$(C4|(B . ?\xB35F) ; HANGUL SYLLABLE TIKEUT-EO-RIEULPIEUP
     (?$(C4}(B . ?\xB364) ; HANGUL SYLLABLE TIKEUT-EO-MIEUM
     (?$(C4~(B . ?\xB365) ; HANGUL SYLLABLE TIKEUT-EO-PIEUP
     (?$(C5!(B . ?\xB367) ; HANGUL SYLLABLE TIKEUT-EO-SIOS
     (?$(C5"(B . ?\xB369) ; HANGUL SYLLABLE TIKEUT-EO-IEUNG
     (?$(C5#(B . ?\xB36B) ; HANGUL SYLLABLE TIKEUT-EO-CHIEUCH
     (?$(C5$(B . ?\xB36E) ; HANGUL SYLLABLE TIKEUT-EO-PHIEUPH
     (?$(C5%(B . ?\xB370) ; HANGUL SYLLABLE TIKEUT-E
     (?$(C5&(B . ?\xB371) ; HANGUL SYLLABLE TIKEUT-E-KIYEOK
     (?$(C5'(B . ?\xB374) ; HANGUL SYLLABLE TIKEUT-E-NIEUN
     (?$(C5((B . ?\xB378) ; HANGUL SYLLABLE TIKEUT-E-RIEUL
     (?$(C5)(B . ?\xB380) ; HANGUL SYLLABLE TIKEUT-E-MIEUM
     (?$(C5*(B . ?\xB381) ; HANGUL SYLLABLE TIKEUT-E-PIEUP
     (?$(C5+(B . ?\xB383) ; HANGUL SYLLABLE TIKEUT-E-SIOS
     (?$(C5,(B . ?\xB384) ; HANGUL SYLLABLE TIKEUT-E-SSANGSIOS
     (?$(C5-(B . ?\xB385) ; HANGUL SYLLABLE TIKEUT-E-IEUNG
     (?$(C5.(B . ?\xB38C) ; HANGUL SYLLABLE TIKEUT-YEO
     (?$(C5/(B . ?\xB390) ; HANGUL SYLLABLE TIKEUT-YEO-NIEUN
     (?$(C50(B . ?\xB394) ; HANGUL SYLLABLE TIKEUT-YEO-RIEUL
     (?$(C51(B . ?\xB3A0) ; HANGUL SYLLABLE TIKEUT-YEO-SSANGSIOS
     (?$(C52(B . ?\xB3A1) ; HANGUL SYLLABLE TIKEUT-YEO-IEUNG
     (?$(C53(B . ?\xB3A8) ; HANGUL SYLLABLE TIKEUT-YE
     (?$(C54(B . ?\xB3AC) ; HANGUL SYLLABLE TIKEUT-YE-NIEUN
     (?$(C55(B . ?\xB3C4) ; HANGUL SYLLABLE TIKEUT-O
     (?$(C56(B . ?\xB3C5) ; HANGUL SYLLABLE TIKEUT-O-KIYEOK
     (?$(C57(B . ?\xB3C8) ; HANGUL SYLLABLE TIKEUT-O-NIEUN
     (?$(C58(B . ?\xB3CB) ; HANGUL SYLLABLE TIKEUT-O-TIKEUT
     (?$(C59(B . ?\xB3CC) ; HANGUL SYLLABLE TIKEUT-O-RIEUL
     (?$(C5:(B . ?\xB3CE) ; HANGUL SYLLABLE TIKEUT-O-RIEULMIEUM
     (?$(C5;(B . ?\xB3D0) ; HANGUL SYLLABLE TIKEUT-O-RIEULSIOS
     (?$(C5<(B . ?\xB3D4) ; HANGUL SYLLABLE TIKEUT-O-MIEUM
     (?$(C5=(B . ?\xB3D5) ; HANGUL SYLLABLE TIKEUT-O-PIEUP
     (?$(C5>(B . ?\xB3D7) ; HANGUL SYLLABLE TIKEUT-O-SIOS
     (?$(C5?(B . ?\xB3D9) ; HANGUL SYLLABLE TIKEUT-O-IEUNG
     (?$(C5@(B . ?\xB3DB) ; HANGUL SYLLABLE TIKEUT-O-CHIEUCH
     (?$(C5A(B . ?\xB3DD) ; HANGUL SYLLABLE TIKEUT-O-THIEUTH
     (?$(C5B(B . ?\xB3E0) ; HANGUL SYLLABLE TIKEUT-WA
     (?$(C5C(B . ?\xB3E4) ; HANGUL SYLLABLE TIKEUT-WA-NIEUN
     (?$(C5D(B . ?\xB3E8) ; HANGUL SYLLABLE TIKEUT-WA-RIEUL
     (?$(C5E(B . ?\xB3FC) ; HANGUL SYLLABLE TIKEUT-WAE
     (?$(C5F(B . ?\xB410) ; HANGUL SYLLABLE TIKEUT-WAE-SSANGSIOS
     (?$(C5G(B . ?\xB418) ; HANGUL SYLLABLE TIKEUT-OE
     (?$(C5H(B . ?\xB41C) ; HANGUL SYLLABLE TIKEUT-OE-NIEUN
     (?$(C5I(B . ?\xB420) ; HANGUL SYLLABLE TIKEUT-OE-RIEUL
     (?$(C5J(B . ?\xB428) ; HANGUL SYLLABLE TIKEUT-OE-MIEUM
     (?$(C5K(B . ?\xB429) ; HANGUL SYLLABLE TIKEUT-OE-PIEUP
     (?$(C5L(B . ?\xB42B) ; HANGUL SYLLABLE TIKEUT-OE-SIOS
     (?$(C5M(B . ?\xB434) ; HANGUL SYLLABLE TIKEUT-YO
     (?$(C5N(B . ?\xB450) ; HANGUL SYLLABLE TIKEUT-U
     (?$(C5O(B . ?\xB451) ; HANGUL SYLLABLE TIKEUT-U-KIYEOK
     (?$(C5P(B . ?\xB454) ; HANGUL SYLLABLE TIKEUT-U-NIEUN
     (?$(C5Q(B . ?\xB458) ; HANGUL SYLLABLE TIKEUT-U-RIEUL
     (?$(C5R(B . ?\xB460) ; HANGUL SYLLABLE TIKEUT-U-MIEUM
     (?$(C5S(B . ?\xB461) ; HANGUL SYLLABLE TIKEUT-U-PIEUP
     (?$(C5T(B . ?\xB463) ; HANGUL SYLLABLE TIKEUT-U-SIOS
     (?$(C5U(B . ?\xB465) ; HANGUL SYLLABLE TIKEUT-U-IEUNG
     (?$(C5V(B . ?\xB46C) ; HANGUL SYLLABLE TIKEUT-WEO
     (?$(C5W(B . ?\xB480) ; HANGUL SYLLABLE TIKEUT-WEO-SSANGSIOS
     (?$(C5X(B . ?\xB488) ; HANGUL SYLLABLE TIKEUT-WE
     (?$(C5Y(B . ?\xB49D) ; HANGUL SYLLABLE TIKEUT-WE-IEUNG
     (?$(C5Z(B . ?\xB4A4) ; HANGUL SYLLABLE TIKEUT-WI
     (?$(C5[(B . ?\xB4A8) ; HANGUL SYLLABLE TIKEUT-WI-NIEUN
     (?$(C5\(B . ?\xB4AC) ; HANGUL SYLLABLE TIKEUT-WI-RIEUL
     (?$(C5](B . ?\xB4B5) ; HANGUL SYLLABLE TIKEUT-WI-PIEUP
     (?$(C5^(B . ?\xB4B7) ; HANGUL SYLLABLE TIKEUT-WI-SIOS
     (?$(C5_(B . ?\xB4B9) ; HANGUL SYLLABLE TIKEUT-WI-IEUNG
     (?$(C5`(B . ?\xB4C0) ; HANGUL SYLLABLE TIKEUT-YU
     (?$(C5a(B . ?\xB4C4) ; HANGUL SYLLABLE TIKEUT-YU-NIEUN
     (?$(C5b(B . ?\xB4C8) ; HANGUL SYLLABLE TIKEUT-YU-RIEUL
     (?$(C5c(B . ?\xB4D0) ; HANGUL SYLLABLE TIKEUT-YU-MIEUM
     (?$(C5d(B . ?\xB4D5) ; HANGUL SYLLABLE TIKEUT-YU-IEUNG
     (?$(C5e(B . ?\xB4DC) ; HANGUL SYLLABLE TIKEUT-EU
     (?$(C5f(B . ?\xB4DD) ; HANGUL SYLLABLE TIKEUT-EU-KIYEOK
     (?$(C5g(B . ?\xB4E0) ; HANGUL SYLLABLE TIKEUT-EU-NIEUN
     (?$(C5h(B . ?\xB4E3) ; HANGUL SYLLABLE TIKEUT-EU-TIKEUT
     (?$(C5i(B . ?\xB4E4) ; HANGUL SYLLABLE TIKEUT-EU-RIEUL
     (?$(C5j(B . ?\xB4E6) ; HANGUL SYLLABLE TIKEUT-EU-RIEULMIEUM
     (?$(C5k(B . ?\xB4EC) ; HANGUL SYLLABLE TIKEUT-EU-MIEUM
     (?$(C5l(B . ?\xB4ED) ; HANGUL SYLLABLE TIKEUT-EU-PIEUP
     (?$(C5m(B . ?\xB4EF) ; HANGUL SYLLABLE TIKEUT-EU-SIOS
     (?$(C5n(B . ?\xB4F1) ; HANGUL SYLLABLE TIKEUT-EU-IEUNG
     (?$(C5o(B . ?\xB4F8) ; HANGUL SYLLABLE TIKEUT-YI
     (?$(C5p(B . ?\xB514) ; HANGUL SYLLABLE TIKEUT-I
     (?$(C5q(B . ?\xB515) ; HANGUL SYLLABLE TIKEUT-I-KIYEOK
     (?$(C5r(B . ?\xB518) ; HANGUL SYLLABLE TIKEUT-I-NIEUN
     (?$(C5s(B . ?\xB51B) ; HANGUL SYLLABLE TIKEUT-I-TIKEUT
     (?$(C5t(B . ?\xB51C) ; HANGUL SYLLABLE TIKEUT-I-RIEUL
     (?$(C5u(B . ?\xB524) ; HANGUL SYLLABLE TIKEUT-I-MIEUM
     (?$(C5v(B . ?\xB525) ; HANGUL SYLLABLE TIKEUT-I-PIEUP
     (?$(C5w(B . ?\xB527) ; HANGUL SYLLABLE TIKEUT-I-SIOS
     (?$(C5x(B . ?\xB528) ; HANGUL SYLLABLE TIKEUT-I-SSANGSIOS
     (?$(C5y(B . ?\xB529) ; HANGUL SYLLABLE TIKEUT-I-IEUNG
     (?$(C5z(B . ?\xB52A) ; HANGUL SYLLABLE TIKEUT-I-CIEUC
     (?$(C5{(B . ?\xB530) ; HANGUL SYLLABLE SSANGTIKEUT-A
     (?$(C5|(B . ?\xB531) ; HANGUL SYLLABLE SSANGTIKEUT-A-KIYEOK
     (?$(C5}(B . ?\xB534) ; HANGUL SYLLABLE SSANGTIKEUT-A-NIEUN
     (?$(C5~(B . ?\xB538) ; HANGUL SYLLABLE SSANGTIKEUT-A-RIEUL
     (?$(C6!(B . ?\xB540) ; HANGUL SYLLABLE SSANGTIKEUT-A-MIEUM
     (?$(C6"(B . ?\xB541) ; HANGUL SYLLABLE SSANGTIKEUT-A-PIEUP
     (?$(C6#(B . ?\xB543) ; HANGUL SYLLABLE SSANGTIKEUT-A-SIOS
     (?$(C6$(B . ?\xB544) ; HANGUL SYLLABLE SSANGTIKEUT-A-SSANGSIOS
     (?$(C6%(B . ?\xB545) ; HANGUL SYLLABLE SSANGTIKEUT-A-IEUNG
     (?$(C6&(B . ?\xB54B) ; HANGUL SYLLABLE SSANGTIKEUT-A-HIEUH
     (?$(C6'(B . ?\xB54C) ; HANGUL SYLLABLE SSANGTIKEUT-AE
     (?$(C6((B . ?\xB54D) ; HANGUL SYLLABLE SSANGTIKEUT-AE-KIYEOK
     (?$(C6)(B . ?\xB550) ; HANGUL SYLLABLE SSANGTIKEUT-AE-NIEUN
     (?$(C6*(B . ?\xB554) ; HANGUL SYLLABLE SSANGTIKEUT-AE-RIEUL
     (?$(C6+(B . ?\xB55C) ; HANGUL SYLLABLE SSANGTIKEUT-AE-MIEUM
     (?$(C6,(B . ?\xB55D) ; HANGUL SYLLABLE SSANGTIKEUT-AE-PIEUP
     (?$(C6-(B . ?\xB55F) ; HANGUL SYLLABLE SSANGTIKEUT-AE-SIOS
     (?$(C6.(B . ?\xB560) ; HANGUL SYLLABLE SSANGTIKEUT-AE-SSANGSIOS
     (?$(C6/(B . ?\xB561) ; HANGUL SYLLABLE SSANGTIKEUT-AE-IEUNG
     (?$(C60(B . ?\xB5A0) ; HANGUL SYLLABLE SSANGTIKEUT-EO
     (?$(C61(B . ?\xB5A1) ; HANGUL SYLLABLE SSANGTIKEUT-EO-KIYEOK
     (?$(C62(B . ?\xB5A4) ; HANGUL SYLLABLE SSANGTIKEUT-EO-NIEUN
     (?$(C63(B . ?\xB5A8) ; HANGUL SYLLABLE SSANGTIKEUT-EO-RIEUL
     (?$(C64(B . ?\xB5AA) ; HANGUL SYLLABLE SSANGTIKEUT-EO-RIEULMIEUM
     (?$(C65(B . ?\xB5AB) ; HANGUL SYLLABLE SSANGTIKEUT-EO-RIEULPIEUP
     (?$(C66(B . ?\xB5B0) ; HANGUL SYLLABLE SSANGTIKEUT-EO-MIEUM
     (?$(C67(B . ?\xB5B1) ; HANGUL SYLLABLE SSANGTIKEUT-EO-PIEUP
     (?$(C68(B . ?\xB5B3) ; HANGUL SYLLABLE SSANGTIKEUT-EO-SIOS
     (?$(C69(B . ?\xB5B4) ; HANGUL SYLLABLE SSANGTIKEUT-EO-SSANGSIOS
     (?$(C6:(B . ?\xB5B5) ; HANGUL SYLLABLE SSANGTIKEUT-EO-IEUNG
     (?$(C6;(B . ?\xB5BB) ; HANGUL SYLLABLE SSANGTIKEUT-EO-HIEUH
     (?$(C6<(B . ?\xB5BC) ; HANGUL SYLLABLE SSANGTIKEUT-E
     (?$(C6=(B . ?\xB5BD) ; HANGUL SYLLABLE SSANGTIKEUT-E-KIYEOK
     (?$(C6>(B . ?\xB5C0) ; HANGUL SYLLABLE SSANGTIKEUT-E-NIEUN
     (?$(C6?(B . ?\xB5C4) ; HANGUL SYLLABLE SSANGTIKEUT-E-RIEUL
     (?$(C6@(B . ?\xB5CC) ; HANGUL SYLLABLE SSANGTIKEUT-E-MIEUM
     (?$(C6A(B . ?\xB5CD) ; HANGUL SYLLABLE SSANGTIKEUT-E-PIEUP
     (?$(C6B(B . ?\xB5CF) ; HANGUL SYLLABLE SSANGTIKEUT-E-SIOS
     (?$(C6C(B . ?\xB5D0) ; HANGUL SYLLABLE SSANGTIKEUT-E-SSANGSIOS
     (?$(C6D(B . ?\xB5D1) ; HANGUL SYLLABLE SSANGTIKEUT-E-IEUNG
     (?$(C6E(B . ?\xB5D8) ; HANGUL SYLLABLE SSANGTIKEUT-YEO
     (?$(C6F(B . ?\xB5EC) ; HANGUL SYLLABLE SSANGTIKEUT-YEO-SSANGSIOS
     (?$(C6G(B . ?\xB610) ; HANGUL SYLLABLE SSANGTIKEUT-O
     (?$(C6H(B . ?\xB611) ; HANGUL SYLLABLE SSANGTIKEUT-O-KIYEOK
     (?$(C6I(B . ?\xB614) ; HANGUL SYLLABLE SSANGTIKEUT-O-NIEUN
     (?$(C6J(B . ?\xB618) ; HANGUL SYLLABLE SSANGTIKEUT-O-RIEUL
     (?$(C6K(B . ?\xB625) ; HANGUL SYLLABLE SSANGTIKEUT-O-IEUNG
     (?$(C6L(B . ?\xB62C) ; HANGUL SYLLABLE SSANGTIKEUT-WA
     (?$(C6M(B . ?\xB634) ; HANGUL SYLLABLE SSANGTIKEUT-WA-RIEUL
     (?$(C6N(B . ?\xB648) ; HANGUL SYLLABLE SSANGTIKEUT-WAE
     (?$(C6O(B . ?\xB664) ; HANGUL SYLLABLE SSANGTIKEUT-OE
     (?$(C6P(B . ?\xB668) ; HANGUL SYLLABLE SSANGTIKEUT-OE-NIEUN
     (?$(C6Q(B . ?\xB69C) ; HANGUL SYLLABLE SSANGTIKEUT-U
     (?$(C6R(B . ?\xB69D) ; HANGUL SYLLABLE SSANGTIKEUT-U-KIYEOK
     (?$(C6S(B . ?\xB6A0) ; HANGUL SYLLABLE SSANGTIKEUT-U-NIEUN
     (?$(C6T(B . ?\xB6A4) ; HANGUL SYLLABLE SSANGTIKEUT-U-RIEUL
     (?$(C6U(B . ?\xB6AB) ; HANGUL SYLLABLE SSANGTIKEUT-U-RIEULHIEUH
     (?$(C6V(B . ?\xB6AC) ; HANGUL SYLLABLE SSANGTIKEUT-U-MIEUM
     (?$(C6W(B . ?\xB6B1) ; HANGUL SYLLABLE SSANGTIKEUT-U-IEUNG
     (?$(C6X(B . ?\xB6D4) ; HANGUL SYLLABLE SSANGTIKEUT-WE
     (?$(C6Y(B . ?\xB6F0) ; HANGUL SYLLABLE SSANGTIKEUT-WI
     (?$(C6Z(B . ?\xB6F4) ; HANGUL SYLLABLE SSANGTIKEUT-WI-NIEUN
     (?$(C6[(B . ?\xB6F8) ; HANGUL SYLLABLE SSANGTIKEUT-WI-RIEUL
     (?$(C6\(B . ?\xB700) ; HANGUL SYLLABLE SSANGTIKEUT-WI-MIEUM
     (?$(C6](B . ?\xB701) ; HANGUL SYLLABLE SSANGTIKEUT-WI-PIEUP
     (?$(C6^(B . ?\xB705) ; HANGUL SYLLABLE SSANGTIKEUT-WI-IEUNG
     (?$(C6_(B . ?\xB728) ; HANGUL SYLLABLE SSANGTIKEUT-EU
     (?$(C6`(B . ?\xB729) ; HANGUL SYLLABLE SSANGTIKEUT-EU-KIYEOK
     (?$(C6a(B . ?\xB72C) ; HANGUL SYLLABLE SSANGTIKEUT-EU-NIEUN
     (?$(C6b(B . ?\xB72F) ; HANGUL SYLLABLE SSANGTIKEUT-EU-TIKEUT
     (?$(C6c(B . ?\xB730) ; HANGUL SYLLABLE SSANGTIKEUT-EU-RIEUL
     (?$(C6d(B . ?\xB738) ; HANGUL SYLLABLE SSANGTIKEUT-EU-MIEUM
     (?$(C6e(B . ?\xB739) ; HANGUL SYLLABLE SSANGTIKEUT-EU-PIEUP
     (?$(C6f(B . ?\xB73B) ; HANGUL SYLLABLE SSANGTIKEUT-EU-SIOS
     (?$(C6g(B . ?\xB744) ; HANGUL SYLLABLE SSANGTIKEUT-YI
     (?$(C6h(B . ?\xB748) ; HANGUL SYLLABLE SSANGTIKEUT-YI-NIEUN
     (?$(C6i(B . ?\xB74C) ; HANGUL SYLLABLE SSANGTIKEUT-YI-RIEUL
     (?$(C6j(B . ?\xB754) ; HANGUL SYLLABLE SSANGTIKEUT-YI-MIEUM
     (?$(C6k(B . ?\xB755) ; HANGUL SYLLABLE SSANGTIKEUT-YI-PIEUP
     (?$(C6l(B . ?\xB760) ; HANGUL SYLLABLE SSANGTIKEUT-I
     (?$(C6m(B . ?\xB764) ; HANGUL SYLLABLE SSANGTIKEUT-I-NIEUN
     (?$(C6n(B . ?\xB768) ; HANGUL SYLLABLE SSANGTIKEUT-I-RIEUL
     (?$(C6o(B . ?\xB770) ; HANGUL SYLLABLE SSANGTIKEUT-I-MIEUM
     (?$(C6p(B . ?\xB771) ; HANGUL SYLLABLE SSANGTIKEUT-I-PIEUP
     (?$(C6q(B . ?\xB773) ; HANGUL SYLLABLE SSANGTIKEUT-I-SIOS
     (?$(C6r(B . ?\xB775) ; HANGUL SYLLABLE SSANGTIKEUT-I-IEUNG
     (?$(C6s(B . ?\xB77C) ; HANGUL SYLLABLE RIEUL-A
     (?$(C6t(B . ?\xB77D) ; HANGUL SYLLABLE RIEUL-A-KIYEOK
     (?$(C6u(B . ?\xB780) ; HANGUL SYLLABLE RIEUL-A-NIEUN
     (?$(C6v(B . ?\xB784) ; HANGUL SYLLABLE RIEUL-A-RIEUL
     (?$(C6w(B . ?\xB78C) ; HANGUL SYLLABLE RIEUL-A-MIEUM
     (?$(C6x(B . ?\xB78D) ; HANGUL SYLLABLE RIEUL-A-PIEUP
     (?$(C6y(B . ?\xB78F) ; HANGUL SYLLABLE RIEUL-A-SIOS
     (?$(C6z(B . ?\xB790) ; HANGUL SYLLABLE RIEUL-A-SSANGSIOS
     (?$(C6{(B . ?\xB791) ; HANGUL SYLLABLE RIEUL-A-IEUNG
     (?$(C6|(B . ?\xB792) ; HANGUL SYLLABLE RIEUL-A-CIEUC
     (?$(C6}(B . ?\xB796) ; HANGUL SYLLABLE RIEUL-A-PHIEUPH
     (?$(C6~(B . ?\xB797) ; HANGUL SYLLABLE RIEUL-A-HIEUH
     (?$(C7!(B . ?\xB798) ; HANGUL SYLLABLE RIEUL-AE
     (?$(C7"(B . ?\xB799) ; HANGUL SYLLABLE RIEUL-AE-KIYEOK
     (?$(C7#(B . ?\xB79C) ; HANGUL SYLLABLE RIEUL-AE-NIEUN
     (?$(C7$(B . ?\xB7A0) ; HANGUL SYLLABLE RIEUL-AE-RIEUL
     (?$(C7%(B . ?\xB7A8) ; HANGUL SYLLABLE RIEUL-AE-MIEUM
     (?$(C7&(B . ?\xB7A9) ; HANGUL SYLLABLE RIEUL-AE-PIEUP
     (?$(C7'(B . ?\xB7AB) ; HANGUL SYLLABLE RIEUL-AE-SIOS
     (?$(C7((B . ?\xB7AC) ; HANGUL SYLLABLE RIEUL-AE-SSANGSIOS
     (?$(C7)(B . ?\xB7AD) ; HANGUL SYLLABLE RIEUL-AE-IEUNG
     (?$(C7*(B . ?\xB7B4) ; HANGUL SYLLABLE RIEUL-YA
     (?$(C7+(B . ?\xB7B5) ; HANGUL SYLLABLE RIEUL-YA-KIYEOK
     (?$(C7,(B . ?\xB7B8) ; HANGUL SYLLABLE RIEUL-YA-NIEUN
     (?$(C7-(B . ?\xB7C7) ; HANGUL SYLLABLE RIEUL-YA-SIOS
     (?$(C7.(B . ?\xB7C9) ; HANGUL SYLLABLE RIEUL-YA-IEUNG
     (?$(C7/(B . ?\xB7EC) ; HANGUL SYLLABLE RIEUL-EO
     (?$(C70(B . ?\xB7ED) ; HANGUL SYLLABLE RIEUL-EO-KIYEOK
     (?$(C71(B . ?\xB7F0) ; HANGUL SYLLABLE RIEUL-EO-NIEUN
     (?$(C72(B . ?\xB7F4) ; HANGUL SYLLABLE RIEUL-EO-RIEUL
     (?$(C73(B . ?\xB7FC) ; HANGUL SYLLABLE RIEUL-EO-MIEUM
     (?$(C74(B . ?\xB7FD) ; HANGUL SYLLABLE RIEUL-EO-PIEUP
     (?$(C75(B . ?\xB7FF) ; HANGUL SYLLABLE RIEUL-EO-SIOS
     (?$(C76(B . ?\xB800) ; HANGUL SYLLABLE RIEUL-EO-SSANGSIOS
     (?$(C77(B . ?\xB801) ; HANGUL SYLLABLE RIEUL-EO-IEUNG
     (?$(C78(B . ?\xB807) ; HANGUL SYLLABLE RIEUL-EO-HIEUH
     (?$(C79(B . ?\xB808) ; HANGUL SYLLABLE RIEUL-E
     (?$(C7:(B . ?\xB809) ; HANGUL SYLLABLE RIEUL-E-KIYEOK
     (?$(C7;(B . ?\xB80C) ; HANGUL SYLLABLE RIEUL-E-NIEUN
     (?$(C7<(B . ?\xB810) ; HANGUL SYLLABLE RIEUL-E-RIEUL
     (?$(C7=(B . ?\xB818) ; HANGUL SYLLABLE RIEUL-E-MIEUM
     (?$(C7>(B . ?\xB819) ; HANGUL SYLLABLE RIEUL-E-PIEUP
     (?$(C7?(B . ?\xB81B) ; HANGUL SYLLABLE RIEUL-E-SIOS
     (?$(C7@(B . ?\xB81D) ; HANGUL SYLLABLE RIEUL-E-IEUNG
     (?$(C7A(B . ?\xB824) ; HANGUL SYLLABLE RIEUL-YEO
     (?$(C7B(B . ?\xB825) ; HANGUL SYLLABLE RIEUL-YEO-KIYEOK
     (?$(C7C(B . ?\xB828) ; HANGUL SYLLABLE RIEUL-YEO-NIEUN
     (?$(C7D(B . ?\xB82C) ; HANGUL SYLLABLE RIEUL-YEO-RIEUL
     (?$(C7E(B . ?\xB834) ; HANGUL SYLLABLE RIEUL-YEO-MIEUM
     (?$(C7F(B . ?\xB835) ; HANGUL SYLLABLE RIEUL-YEO-PIEUP
     (?$(C7G(B . ?\xB837) ; HANGUL SYLLABLE RIEUL-YEO-SIOS
     (?$(C7H(B . ?\xB838) ; HANGUL SYLLABLE RIEUL-YEO-SSANGSIOS
     (?$(C7I(B . ?\xB839) ; HANGUL SYLLABLE RIEUL-YEO-IEUNG
     (?$(C7J(B . ?\xB840) ; HANGUL SYLLABLE RIEUL-YE
     (?$(C7K(B . ?\xB844) ; HANGUL SYLLABLE RIEUL-YE-NIEUN
     (?$(C7L(B . ?\xB851) ; HANGUL SYLLABLE RIEUL-YE-PIEUP
     (?$(C7M(B . ?\xB853) ; HANGUL SYLLABLE RIEUL-YE-SIOS
     (?$(C7N(B . ?\xB85C) ; HANGUL SYLLABLE RIEUL-O
     (?$(C7O(B . ?\xB85D) ; HANGUL SYLLABLE RIEUL-O-KIYEOK
     (?$(C7P(B . ?\xB860) ; HANGUL SYLLABLE RIEUL-O-NIEUN
     (?$(C7Q(B . ?\xB864) ; HANGUL SYLLABLE RIEUL-O-RIEUL
     (?$(C7R(B . ?\xB86C) ; HANGUL SYLLABLE RIEUL-O-MIEUM
     (?$(C7S(B . ?\xB86D) ; HANGUL SYLLABLE RIEUL-O-PIEUP
     (?$(C7T(B . ?\xB86F) ; HANGUL SYLLABLE RIEUL-O-SIOS
     (?$(C7U(B . ?\xB871) ; HANGUL SYLLABLE RIEUL-O-IEUNG
     (?$(C7V(B . ?\xB878) ; HANGUL SYLLABLE RIEUL-WA
     (?$(C7W(B . ?\xB87C) ; HANGUL SYLLABLE RIEUL-WA-NIEUN
     (?$(C7X(B . ?\xB88D) ; HANGUL SYLLABLE RIEUL-WA-IEUNG
     (?$(C7Y(B . ?\xB8A8) ; HANGUL SYLLABLE RIEUL-WAE-SSANGSIOS
     (?$(C7Z(B . ?\xB8B0) ; HANGUL SYLLABLE RIEUL-OE
     (?$(C7[(B . ?\xB8B4) ; HANGUL SYLLABLE RIEUL-OE-NIEUN
     (?$(C7\(B . ?\xB8B8) ; HANGUL SYLLABLE RIEUL-OE-RIEUL
     (?$(C7](B . ?\xB8C0) ; HANGUL SYLLABLE RIEUL-OE-MIEUM
     (?$(C7^(B . ?\xB8C1) ; HANGUL SYLLABLE RIEUL-OE-PIEUP
     (?$(C7_(B . ?\xB8C3) ; HANGUL SYLLABLE RIEUL-OE-SIOS
     (?$(C7`(B . ?\xB8C5) ; HANGUL SYLLABLE RIEUL-OE-IEUNG
     (?$(C7a(B . ?\xB8CC) ; HANGUL SYLLABLE RIEUL-YO
     (?$(C7b(B . ?\xB8D0) ; HANGUL SYLLABLE RIEUL-YO-NIEUN
     (?$(C7c(B . ?\xB8D4) ; HANGUL SYLLABLE RIEUL-YO-RIEUL
     (?$(C7d(B . ?\xB8DD) ; HANGUL SYLLABLE RIEUL-YO-PIEUP
     (?$(C7e(B . ?\xB8DF) ; HANGUL SYLLABLE RIEUL-YO-SIOS
     (?$(C7f(B . ?\xB8E1) ; HANGUL SYLLABLE RIEUL-YO-IEUNG
     (?$(C7g(B . ?\xB8E8) ; HANGUL SYLLABLE RIEUL-U
     (?$(C7h(B . ?\xB8E9) ; HANGUL SYLLABLE RIEUL-U-KIYEOK
     (?$(C7i(B . ?\xB8EC) ; HANGUL SYLLABLE RIEUL-U-NIEUN
     (?$(C7j(B . ?\xB8F0) ; HANGUL SYLLABLE RIEUL-U-RIEUL
     (?$(C7k(B . ?\xB8F8) ; HANGUL SYLLABLE RIEUL-U-MIEUM
     (?$(C7l(B . ?\xB8F9) ; HANGUL SYLLABLE RIEUL-U-PIEUP
     (?$(C7m(B . ?\xB8FB) ; HANGUL SYLLABLE RIEUL-U-SIOS
     (?$(C7n(B . ?\xB8FD) ; HANGUL SYLLABLE RIEUL-U-IEUNG
     (?$(C7o(B . ?\xB904) ; HANGUL SYLLABLE RIEUL-WEO
     (?$(C7p(B . ?\xB918) ; HANGUL SYLLABLE RIEUL-WEO-SSANGSIOS
     (?$(C7q(B . ?\xB920) ; HANGUL SYLLABLE RIEUL-WE
     (?$(C7r(B . ?\xB93C) ; HANGUL SYLLABLE RIEUL-WI
     (?$(C7s(B . ?\xB93D) ; HANGUL SYLLABLE RIEUL-WI-KIYEOK
     (?$(C7t(B . ?\xB940) ; HANGUL SYLLABLE RIEUL-WI-NIEUN
     (?$(C7u(B . ?\xB944) ; HANGUL SYLLABLE RIEUL-WI-RIEUL
     (?$(C7v(B . ?\xB94C) ; HANGUL SYLLABLE RIEUL-WI-MIEUM
     (?$(C7w(B . ?\xB94F) ; HANGUL SYLLABLE RIEUL-WI-SIOS
     (?$(C7x(B . ?\xB951) ; HANGUL SYLLABLE RIEUL-WI-IEUNG
     (?$(C7y(B . ?\xB958) ; HANGUL SYLLABLE RIEUL-YU
     (?$(C7z(B . ?\xB959) ; HANGUL SYLLABLE RIEUL-YU-KIYEOK
     (?$(C7{(B . ?\xB95C) ; HANGUL SYLLABLE RIEUL-YU-NIEUN
     (?$(C7|(B . ?\xB960) ; HANGUL SYLLABLE RIEUL-YU-RIEUL
     (?$(C7}(B . ?\xB968) ; HANGUL SYLLABLE RIEUL-YU-MIEUM
     (?$(C7~(B . ?\xB969) ; HANGUL SYLLABLE RIEUL-YU-PIEUP
     (?$(C8!(B . ?\xB96B) ; HANGUL SYLLABLE RIEUL-YU-SIOS
     (?$(C8"(B . ?\xB96D) ; HANGUL SYLLABLE RIEUL-YU-IEUNG
     (?$(C8#(B . ?\xB974) ; HANGUL SYLLABLE RIEUL-EU
     (?$(C8$(B . ?\xB975) ; HANGUL SYLLABLE RIEUL-EU-KIYEOK
     (?$(C8%(B . ?\xB978) ; HANGUL SYLLABLE RIEUL-EU-NIEUN
     (?$(C8&(B . ?\xB97C) ; HANGUL SYLLABLE RIEUL-EU-RIEUL
     (?$(C8'(B . ?\xB984) ; HANGUL SYLLABLE RIEUL-EU-MIEUM
     (?$(C8((B . ?\xB985) ; HANGUL SYLLABLE RIEUL-EU-PIEUP
     (?$(C8)(B . ?\xB987) ; HANGUL SYLLABLE RIEUL-EU-SIOS
     (?$(C8*(B . ?\xB989) ; HANGUL SYLLABLE RIEUL-EU-IEUNG
     (?$(C8+(B . ?\xB98A) ; HANGUL SYLLABLE RIEUL-EU-CIEUC
     (?$(C8,(B . ?\xB98D) ; HANGUL SYLLABLE RIEUL-EU-THIEUTH
     (?$(C8-(B . ?\xB98E) ; HANGUL SYLLABLE RIEUL-EU-PHIEUPH
     (?$(C8.(B . ?\xB9AC) ; HANGUL SYLLABLE RIEUL-I
     (?$(C8/(B . ?\xB9AD) ; HANGUL SYLLABLE RIEUL-I-KIYEOK
     (?$(C80(B . ?\xB9B0) ; HANGUL SYLLABLE RIEUL-I-NIEUN
     (?$(C81(B . ?\xB9B4) ; HANGUL SYLLABLE RIEUL-I-RIEUL
     (?$(C82(B . ?\xB9BC) ; HANGUL SYLLABLE RIEUL-I-MIEUM
     (?$(C83(B . ?\xB9BD) ; HANGUL SYLLABLE RIEUL-I-PIEUP
     (?$(C84(B . ?\xB9BF) ; HANGUL SYLLABLE RIEUL-I-SIOS
     (?$(C85(B . ?\xB9C1) ; HANGUL SYLLABLE RIEUL-I-IEUNG
     (?$(C86(B . ?\xB9C8) ; HANGUL SYLLABLE MIEUM-A
     (?$(C87(B . ?\xB9C9) ; HANGUL SYLLABLE MIEUM-A-KIYEOK
     (?$(C88(B . ?\xB9CC) ; HANGUL SYLLABLE MIEUM-A-NIEUN
     (?$(C89(B . ?\xB9CE) ; HANGUL SYLLABLE MIEUM-A-NIEUNHIEUH
     (?$(C8:(B . ?\xB9CF) ; HANGUL SYLLABLE MIEUM-A-TIKEUT
     (?$(C8;(B . ?\xB9D0) ; HANGUL SYLLABLE MIEUM-A-RIEUL
     (?$(C8<(B . ?\xB9D1) ; HANGUL SYLLABLE MIEUM-A-RIEULKIYEOK
     (?$(C8=(B . ?\xB9D2) ; HANGUL SYLLABLE MIEUM-A-RIEULMIEUM
     (?$(C8>(B . ?\xB9D8) ; HANGUL SYLLABLE MIEUM-A-MIEUM
     (?$(C8?(B . ?\xB9D9) ; HANGUL SYLLABLE MIEUM-A-PIEUP
     (?$(C8@(B . ?\xB9DB) ; HANGUL SYLLABLE MIEUM-A-SIOS
     (?$(C8A(B . ?\xB9DD) ; HANGUL SYLLABLE MIEUM-A-IEUNG
     (?$(C8B(B . ?\xB9DE) ; HANGUL SYLLABLE MIEUM-A-CIEUC
     (?$(C8C(B . ?\xB9E1) ; HANGUL SYLLABLE MIEUM-A-THIEUTH
     (?$(C8D(B . ?\xB9E3) ; HANGUL SYLLABLE MIEUM-A-HIEUH
     (?$(C8E(B . ?\xB9E4) ; HANGUL SYLLABLE MIEUM-AE
     (?$(C8F(B . ?\xB9E5) ; HANGUL SYLLABLE MIEUM-AE-KIYEOK
     (?$(C8G(B . ?\xB9E8) ; HANGUL SYLLABLE MIEUM-AE-NIEUN
     (?$(C8H(B . ?\xB9EC) ; HANGUL SYLLABLE MIEUM-AE-RIEUL
     (?$(C8I(B . ?\xB9F4) ; HANGUL SYLLABLE MIEUM-AE-MIEUM
     (?$(C8J(B . ?\xB9F5) ; HANGUL SYLLABLE MIEUM-AE-PIEUP
     (?$(C8K(B . ?\xB9F7) ; HANGUL SYLLABLE MIEUM-AE-SIOS
     (?$(C8L(B . ?\xB9F8) ; HANGUL SYLLABLE MIEUM-AE-SSANGSIOS
     (?$(C8M(B . ?\xB9F9) ; HANGUL SYLLABLE MIEUM-AE-IEUNG
     (?$(C8N(B . ?\xB9FA) ; HANGUL SYLLABLE MIEUM-AE-CIEUC
     (?$(C8O(B . ?\xBA00) ; HANGUL SYLLABLE MIEUM-YA
     (?$(C8P(B . ?\xBA01) ; HANGUL SYLLABLE MIEUM-YA-KIYEOK
     (?$(C8Q(B . ?\xBA08) ; HANGUL SYLLABLE MIEUM-YA-RIEUL
     (?$(C8R(B . ?\xBA15) ; HANGUL SYLLABLE MIEUM-YA-IEUNG
     (?$(C8S(B . ?\xBA38) ; HANGUL SYLLABLE MIEUM-EO
     (?$(C8T(B . ?\xBA39) ; HANGUL SYLLABLE MIEUM-EO-KIYEOK
     (?$(C8U(B . ?\xBA3C) ; HANGUL SYLLABLE MIEUM-EO-NIEUN
     (?$(C8V(B . ?\xBA40) ; HANGUL SYLLABLE MIEUM-EO-RIEUL
     (?$(C8W(B . ?\xBA42) ; HANGUL SYLLABLE MIEUM-EO-RIEULMIEUM
     (?$(C8X(B . ?\xBA48) ; HANGUL SYLLABLE MIEUM-EO-MIEUM
     (?$(C8Y(B . ?\xBA49) ; HANGUL SYLLABLE MIEUM-EO-PIEUP
     (?$(C8Z(B . ?\xBA4B) ; HANGUL SYLLABLE MIEUM-EO-SIOS
     (?$(C8[(B . ?\xBA4D) ; HANGUL SYLLABLE MIEUM-EO-IEUNG
     (?$(C8\(B . ?\xBA4E) ; HANGUL SYLLABLE MIEUM-EO-CIEUC
     (?$(C8](B . ?\xBA53) ; HANGUL SYLLABLE MIEUM-EO-HIEUH
     (?$(C8^(B . ?\xBA54) ; HANGUL SYLLABLE MIEUM-E
     (?$(C8_(B . ?\xBA55) ; HANGUL SYLLABLE MIEUM-E-KIYEOK
     (?$(C8`(B . ?\xBA58) ; HANGUL SYLLABLE MIEUM-E-NIEUN
     (?$(C8a(B . ?\xBA5C) ; HANGUL SYLLABLE MIEUM-E-RIEUL
     (?$(C8b(B . ?\xBA64) ; HANGUL SYLLABLE MIEUM-E-MIEUM
     (?$(C8c(B . ?\xBA65) ; HANGUL SYLLABLE MIEUM-E-PIEUP
     (?$(C8d(B . ?\xBA67) ; HANGUL SYLLABLE MIEUM-E-SIOS
     (?$(C8e(B . ?\xBA68) ; HANGUL SYLLABLE MIEUM-E-SSANGSIOS
     (?$(C8f(B . ?\xBA69) ; HANGUL SYLLABLE MIEUM-E-IEUNG
     (?$(C8g(B . ?\xBA70) ; HANGUL SYLLABLE MIEUM-YEO
     (?$(C8h(B . ?\xBA71) ; HANGUL SYLLABLE MIEUM-YEO-KIYEOK
     (?$(C8i(B . ?\xBA74) ; HANGUL SYLLABLE MIEUM-YEO-NIEUN
     (?$(C8j(B . ?\xBA78) ; HANGUL SYLLABLE MIEUM-YEO-RIEUL
     (?$(C8k(B . ?\xBA83) ; HANGUL SYLLABLE MIEUM-YEO-SIOS
     (?$(C8l(B . ?\xBA84) ; HANGUL SYLLABLE MIEUM-YEO-SSANGSIOS
     (?$(C8m(B . ?\xBA85) ; HANGUL SYLLABLE MIEUM-YEO-IEUNG
     (?$(C8n(B . ?\xBA87) ; HANGUL SYLLABLE MIEUM-YEO-CHIEUCH
     (?$(C8o(B . ?\xBA8C) ; HANGUL SYLLABLE MIEUM-YE
     (?$(C8p(B . ?\xBAA8) ; HANGUL SYLLABLE MIEUM-O
     (?$(C8q(B . ?\xBAA9) ; HANGUL SYLLABLE MIEUM-O-KIYEOK
     (?$(C8r(B . ?\xBAAB) ; HANGUL SYLLABLE MIEUM-O-KIYEOKSIOS
     (?$(C8s(B . ?\xBAAC) ; HANGUL SYLLABLE MIEUM-O-NIEUN
     (?$(C8t(B . ?\xBAB0) ; HANGUL SYLLABLE MIEUM-O-RIEUL
     (?$(C8u(B . ?\xBAB2) ; HANGUL SYLLABLE MIEUM-O-RIEULMIEUM
     (?$(C8v(B . ?\xBAB8) ; HANGUL SYLLABLE MIEUM-O-MIEUM
     (?$(C8w(B . ?\xBAB9) ; HANGUL SYLLABLE MIEUM-O-PIEUP
     (?$(C8x(B . ?\xBABB) ; HANGUL SYLLABLE MIEUM-O-SIOS
     (?$(C8y(B . ?\xBABD) ; HANGUL SYLLABLE MIEUM-O-IEUNG
     (?$(C8z(B . ?\xBAC4) ; HANGUL SYLLABLE MIEUM-WA
     (?$(C8{(B . ?\xBAC8) ; HANGUL SYLLABLE MIEUM-WA-NIEUN
     (?$(C8|(B . ?\xBAD8) ; HANGUL SYLLABLE MIEUM-WA-SSANGSIOS
     (?$(C8}(B . ?\xBAD9) ; HANGUL SYLLABLE MIEUM-WA-IEUNG
     (?$(C8~(B . ?\xBAFC) ; HANGUL SYLLABLE MIEUM-OE
     (?$(C9!(B . ?\xBB00) ; HANGUL SYLLABLE MIEUM-OE-NIEUN
     (?$(C9"(B . ?\xBB04) ; HANGUL SYLLABLE MIEUM-OE-RIEUL
     (?$(C9#(B . ?\xBB0D) ; HANGUL SYLLABLE MIEUM-OE-PIEUP
     (?$(C9$(B . ?\xBB0F) ; HANGUL SYLLABLE MIEUM-OE-SIOS
     (?$(C9%(B . ?\xBB11) ; HANGUL SYLLABLE MIEUM-OE-IEUNG
     (?$(C9&(B . ?\xBB18) ; HANGUL SYLLABLE MIEUM-YO
     (?$(C9'(B . ?\xBB1C) ; HANGUL SYLLABLE MIEUM-YO-NIEUN
     (?$(C9((B . ?\xBB20) ; HANGUL SYLLABLE MIEUM-YO-RIEUL
     (?$(C9)(B . ?\xBB29) ; HANGUL SYLLABLE MIEUM-YO-PIEUP
     (?$(C9*(B . ?\xBB2B) ; HANGUL SYLLABLE MIEUM-YO-SIOS
     (?$(C9+(B . ?\xBB34) ; HANGUL SYLLABLE MIEUM-U
     (?$(C9,(B . ?\xBB35) ; HANGUL SYLLABLE MIEUM-U-KIYEOK
     (?$(C9-(B . ?\xBB36) ; HANGUL SYLLABLE MIEUM-U-SSANGKIYEOK
     (?$(C9.(B . ?\xBB38) ; HANGUL SYLLABLE MIEUM-U-NIEUN
     (?$(C9/(B . ?\xBB3B) ; HANGUL SYLLABLE MIEUM-U-TIKEUT
     (?$(C90(B . ?\xBB3C) ; HANGUL SYLLABLE MIEUM-U-RIEUL
     (?$(C91(B . ?\xBB3D) ; HANGUL SYLLABLE MIEUM-U-RIEULKIYEOK
     (?$(C92(B . ?\xBB3E) ; HANGUL SYLLABLE MIEUM-U-RIEULMIEUM
     (?$(C93(B . ?\xBB44) ; HANGUL SYLLABLE MIEUM-U-MIEUM
     (?$(C94(B . ?\xBB45) ; HANGUL SYLLABLE MIEUM-U-PIEUP
     (?$(C95(B . ?\xBB47) ; HANGUL SYLLABLE MIEUM-U-SIOS
     (?$(C96(B . ?\xBB49) ; HANGUL SYLLABLE MIEUM-U-IEUNG
     (?$(C97(B . ?\xBB4D) ; HANGUL SYLLABLE MIEUM-U-THIEUTH
     (?$(C98(B . ?\xBB4F) ; HANGUL SYLLABLE MIEUM-U-HIEUH
     (?$(C99(B . ?\xBB50) ; HANGUL SYLLABLE MIEUM-WEO
     (?$(C9:(B . ?\xBB54) ; HANGUL SYLLABLE MIEUM-WEO-NIEUN
     (?$(C9;(B . ?\xBB58) ; HANGUL SYLLABLE MIEUM-WEO-RIEUL
     (?$(C9<(B . ?\xBB61) ; HANGUL SYLLABLE MIEUM-WEO-PIEUP
     (?$(C9=(B . ?\xBB63) ; HANGUL SYLLABLE MIEUM-WEO-SIOS
     (?$(C9>(B . ?\xBB6C) ; HANGUL SYLLABLE MIEUM-WE
     (?$(C9?(B . ?\xBB88) ; HANGUL SYLLABLE MIEUM-WI
     (?$(C9@(B . ?\xBB8C) ; HANGUL SYLLABLE MIEUM-WI-NIEUN
     (?$(C9A(B . ?\xBB90) ; HANGUL SYLLABLE MIEUM-WI-RIEUL
     (?$(C9B(B . ?\xBBA4) ; HANGUL SYLLABLE MIEUM-YU
     (?$(C9C(B . ?\xBBA8) ; HANGUL SYLLABLE MIEUM-YU-NIEUN
     (?$(C9D(B . ?\xBBAC) ; HANGUL SYLLABLE MIEUM-YU-RIEUL
     (?$(C9E(B . ?\xBBB4) ; HANGUL SYLLABLE MIEUM-YU-MIEUM
     (?$(C9F(B . ?\xBBB7) ; HANGUL SYLLABLE MIEUM-YU-SIOS
     (?$(C9G(B . ?\xBBC0) ; HANGUL SYLLABLE MIEUM-EU
     (?$(C9H(B . ?\xBBC4) ; HANGUL SYLLABLE MIEUM-EU-NIEUN
     (?$(C9I(B . ?\xBBC8) ; HANGUL SYLLABLE MIEUM-EU-RIEUL
     (?$(C9J(B . ?\xBBD0) ; HANGUL SYLLABLE MIEUM-EU-MIEUM
     (?$(C9K(B . ?\xBBD3) ; HANGUL SYLLABLE MIEUM-EU-SIOS
     (?$(C9L(B . ?\xBBF8) ; HANGUL SYLLABLE MIEUM-I
     (?$(C9M(B . ?\xBBF9) ; HANGUL SYLLABLE MIEUM-I-KIYEOK
     (?$(C9N(B . ?\xBBFC) ; HANGUL SYLLABLE MIEUM-I-NIEUN
     (?$(C9O(B . ?\xBBFF) ; HANGUL SYLLABLE MIEUM-I-TIKEUT
     (?$(C9P(B . ?\xBC00) ; HANGUL SYLLABLE MIEUM-I-RIEUL
     (?$(C9Q(B . ?\xBC02) ; HANGUL SYLLABLE MIEUM-I-RIEULMIEUM
     (?$(C9R(B . ?\xBC08) ; HANGUL SYLLABLE MIEUM-I-MIEUM
     (?$(C9S(B . ?\xBC09) ; HANGUL SYLLABLE MIEUM-I-PIEUP
     (?$(C9T(B . ?\xBC0B) ; HANGUL SYLLABLE MIEUM-I-SIOS
     (?$(C9U(B . ?\xBC0C) ; HANGUL SYLLABLE MIEUM-I-SSANGSIOS
     (?$(C9V(B . ?\xBC0D) ; HANGUL SYLLABLE MIEUM-I-IEUNG
     (?$(C9W(B . ?\xBC0F) ; HANGUL SYLLABLE MIEUM-I-CHIEUCH
     (?$(C9X(B . ?\xBC11) ; HANGUL SYLLABLE MIEUM-I-THIEUTH
     (?$(C9Y(B . ?\xBC14) ; HANGUL SYLLABLE PIEUP-A
     (?$(C9Z(B . ?\xBC15) ; HANGUL SYLLABLE PIEUP-A-KIYEOK
     (?$(C9[(B . ?\xBC16) ; HANGUL SYLLABLE PIEUP-A-SSANGKIYEOK
     (?$(C9\(B . ?\xBC17) ; HANGUL SYLLABLE PIEUP-A-KIYEOKSIOS
     (?$(C9](B . ?\xBC18) ; HANGUL SYLLABLE PIEUP-A-NIEUN
     (?$(C9^(B . ?\xBC1B) ; HANGUL SYLLABLE PIEUP-A-TIKEUT
     (?$(C9_(B . ?\xBC1C) ; HANGUL SYLLABLE PIEUP-A-RIEUL
     (?$(C9`(B . ?\xBC1D) ; HANGUL SYLLABLE PIEUP-A-RIEULKIYEOK
     (?$(C9a(B . ?\xBC1E) ; HANGUL SYLLABLE PIEUP-A-RIEULMIEUM
     (?$(C9b(B . ?\xBC1F) ; HANGUL SYLLABLE PIEUP-A-RIEULPIEUP
     (?$(C9c(B . ?\xBC24) ; HANGUL SYLLABLE PIEUP-A-MIEUM
     (?$(C9d(B . ?\xBC25) ; HANGUL SYLLABLE PIEUP-A-PIEUP
     (?$(C9e(B . ?\xBC27) ; HANGUL SYLLABLE PIEUP-A-SIOS
     (?$(C9f(B . ?\xBC29) ; HANGUL SYLLABLE PIEUP-A-IEUNG
     (?$(C9g(B . ?\xBC2D) ; HANGUL SYLLABLE PIEUP-A-THIEUTH
     (?$(C9h(B . ?\xBC30) ; HANGUL SYLLABLE PIEUP-AE
     (?$(C9i(B . ?\xBC31) ; HANGUL SYLLABLE PIEUP-AE-KIYEOK
     (?$(C9j(B . ?\xBC34) ; HANGUL SYLLABLE PIEUP-AE-NIEUN
     (?$(C9k(B . ?\xBC38) ; HANGUL SYLLABLE PIEUP-AE-RIEUL
     (?$(C9l(B . ?\xBC40) ; HANGUL SYLLABLE PIEUP-AE-MIEUM
     (?$(C9m(B . ?\xBC41) ; HANGUL SYLLABLE PIEUP-AE-PIEUP
     (?$(C9n(B . ?\xBC43) ; HANGUL SYLLABLE PIEUP-AE-SIOS
     (?$(C9o(B . ?\xBC44) ; HANGUL SYLLABLE PIEUP-AE-SSANGSIOS
     (?$(C9p(B . ?\xBC45) ; HANGUL SYLLABLE PIEUP-AE-IEUNG
     (?$(C9q(B . ?\xBC49) ; HANGUL SYLLABLE PIEUP-AE-THIEUTH
     (?$(C9r(B . ?\xBC4C) ; HANGUL SYLLABLE PIEUP-YA
     (?$(C9s(B . ?\xBC4D) ; HANGUL SYLLABLE PIEUP-YA-KIYEOK
     (?$(C9t(B . ?\xBC50) ; HANGUL SYLLABLE PIEUP-YA-NIEUN
     (?$(C9u(B . ?\xBC5D) ; HANGUL SYLLABLE PIEUP-YA-PIEUP
     (?$(C9v(B . ?\xBC84) ; HANGUL SYLLABLE PIEUP-EO
     (?$(C9w(B . ?\xBC85) ; HANGUL SYLLABLE PIEUP-EO-KIYEOK
     (?$(C9x(B . ?\xBC88) ; HANGUL SYLLABLE PIEUP-EO-NIEUN
     (?$(C9y(B . ?\xBC8B) ; HANGUL SYLLABLE PIEUP-EO-TIKEUT
     (?$(C9z(B . ?\xBC8C) ; HANGUL SYLLABLE PIEUP-EO-RIEUL
     (?$(C9{(B . ?\xBC8E) ; HANGUL SYLLABLE PIEUP-EO-RIEULMIEUM
     (?$(C9|(B . ?\xBC94) ; HANGUL SYLLABLE PIEUP-EO-MIEUM
     (?$(C9}(B . ?\xBC95) ; HANGUL SYLLABLE PIEUP-EO-PIEUP
     (?$(C9~(B . ?\xBC97) ; HANGUL SYLLABLE PIEUP-EO-SIOS
     (?$(C:!(B . ?\xBC99) ; HANGUL SYLLABLE PIEUP-EO-IEUNG
     (?$(C:"(B . ?\xBC9A) ; HANGUL SYLLABLE PIEUP-EO-CIEUC
     (?$(C:#(B . ?\xBCA0) ; HANGUL SYLLABLE PIEUP-E
     (?$(C:$(B . ?\xBCA1) ; HANGUL SYLLABLE PIEUP-E-KIYEOK
     (?$(C:%(B . ?\xBCA4) ; HANGUL SYLLABLE PIEUP-E-NIEUN
     (?$(C:&(B . ?\xBCA7) ; HANGUL SYLLABLE PIEUP-E-TIKEUT
     (?$(C:'(B . ?\xBCA8) ; HANGUL SYLLABLE PIEUP-E-RIEUL
     (?$(C:((B . ?\xBCB0) ; HANGUL SYLLABLE PIEUP-E-MIEUM
     (?$(C:)(B . ?\xBCB1) ; HANGUL SYLLABLE PIEUP-E-PIEUP
     (?$(C:*(B . ?\xBCB3) ; HANGUL SYLLABLE PIEUP-E-SIOS
     (?$(C:+(B . ?\xBCB4) ; HANGUL SYLLABLE PIEUP-E-SSANGSIOS
     (?$(C:,(B . ?\xBCB5) ; HANGUL SYLLABLE PIEUP-E-IEUNG
     (?$(C:-(B . ?\xBCBC) ; HANGUL SYLLABLE PIEUP-YEO
     (?$(C:.(B . ?\xBCBD) ; HANGUL SYLLABLE PIEUP-YEO-KIYEOK
     (?$(C:/(B . ?\xBCC0) ; HANGUL SYLLABLE PIEUP-YEO-NIEUN
     (?$(C:0(B . ?\xBCC4) ; HANGUL SYLLABLE PIEUP-YEO-RIEUL
     (?$(C:1(B . ?\xBCCD) ; HANGUL SYLLABLE PIEUP-YEO-PIEUP
     (?$(C:2(B . ?\xBCCF) ; HANGUL SYLLABLE PIEUP-YEO-SIOS
     (?$(C:3(B . ?\xBCD0) ; HANGUL SYLLABLE PIEUP-YEO-SSANGSIOS
     (?$(C:4(B . ?\xBCD1) ; HANGUL SYLLABLE PIEUP-YEO-IEUNG
     (?$(C:5(B . ?\xBCD5) ; HANGUL SYLLABLE PIEUP-YEO-THIEUTH
     (?$(C:6(B . ?\xBCD8) ; HANGUL SYLLABLE PIEUP-YE
     (?$(C:7(B . ?\xBCDC) ; HANGUL SYLLABLE PIEUP-YE-NIEUN
     (?$(C:8(B . ?\xBCF4) ; HANGUL SYLLABLE PIEUP-O
     (?$(C:9(B . ?\xBCF5) ; HANGUL SYLLABLE PIEUP-O-KIYEOK
     (?$(C::(B . ?\xBCF6) ; HANGUL SYLLABLE PIEUP-O-SSANGKIYEOK
     (?$(C:;(B . ?\xBCF8) ; HANGUL SYLLABLE PIEUP-O-NIEUN
     (?$(C:<(B . ?\xBCFC) ; HANGUL SYLLABLE PIEUP-O-RIEUL
     (?$(C:=(B . ?\xBD04) ; HANGUL SYLLABLE PIEUP-O-MIEUM
     (?$(C:>(B . ?\xBD05) ; HANGUL SYLLABLE PIEUP-O-PIEUP
     (?$(C:?(B . ?\xBD07) ; HANGUL SYLLABLE PIEUP-O-SIOS
     (?$(C:@(B . ?\xBD09) ; HANGUL SYLLABLE PIEUP-O-IEUNG
     (?$(C:A(B . ?\xBD10) ; HANGUL SYLLABLE PIEUP-WA
     (?$(C:B(B . ?\xBD14) ; HANGUL SYLLABLE PIEUP-WA-NIEUN
     (?$(C:C(B . ?\xBD24) ; HANGUL SYLLABLE PIEUP-WA-SSANGSIOS
     (?$(C:D(B . ?\xBD2C) ; HANGUL SYLLABLE PIEUP-WAE
     (?$(C:E(B . ?\xBD40) ; HANGUL SYLLABLE PIEUP-WAE-SSANGSIOS
     (?$(C:F(B . ?\xBD48) ; HANGUL SYLLABLE PIEUP-OE
     (?$(C:G(B . ?\xBD49) ; HANGUL SYLLABLE PIEUP-OE-KIYEOK
     (?$(C:H(B . ?\xBD4C) ; HANGUL SYLLABLE PIEUP-OE-NIEUN
     (?$(C:I(B . ?\xBD50) ; HANGUL SYLLABLE PIEUP-OE-RIEUL
     (?$(C:J(B . ?\xBD58) ; HANGUL SYLLABLE PIEUP-OE-MIEUM
     (?$(C:K(B . ?\xBD59) ; HANGUL SYLLABLE PIEUP-OE-PIEUP
     (?$(C:L(B . ?\xBD64) ; HANGUL SYLLABLE PIEUP-YO
     (?$(C:M(B . ?\xBD68) ; HANGUL SYLLABLE PIEUP-YO-NIEUN
     (?$(C:N(B . ?\xBD80) ; HANGUL SYLLABLE PIEUP-U
     (?$(C:O(B . ?\xBD81) ; HANGUL SYLLABLE PIEUP-U-KIYEOK
     (?$(C:P(B . ?\xBD84) ; HANGUL SYLLABLE PIEUP-U-NIEUN
     (?$(C:Q(B . ?\xBD87) ; HANGUL SYLLABLE PIEUP-U-TIKEUT
     (?$(C:R(B . ?\xBD88) ; HANGUL SYLLABLE PIEUP-U-RIEUL
     (?$(C:S(B . ?\xBD89) ; HANGUL SYLLABLE PIEUP-U-RIEULKIYEOK
     (?$(C:T(B . ?\xBD8A) ; HANGUL SYLLABLE PIEUP-U-RIEULMIEUM
     (?$(C:U(B . ?\xBD90) ; HANGUL SYLLABLE PIEUP-U-MIEUM
     (?$(C:V(B . ?\xBD91) ; HANGUL SYLLABLE PIEUP-U-PIEUP
     (?$(C:W(B . ?\xBD93) ; HANGUL SYLLABLE PIEUP-U-SIOS
     (?$(C:X(B . ?\xBD95) ; HANGUL SYLLABLE PIEUP-U-IEUNG
     (?$(C:Y(B . ?\xBD99) ; HANGUL SYLLABLE PIEUP-U-THIEUTH
     (?$(C:Z(B . ?\xBD9A) ; HANGUL SYLLABLE PIEUP-U-PHIEUPH
     (?$(C:[(B . ?\xBD9C) ; HANGUL SYLLABLE PIEUP-WEO
     (?$(C:\(B . ?\xBDA4) ; HANGUL SYLLABLE PIEUP-WEO-RIEUL
     (?$(C:](B . ?\xBDB0) ; HANGUL SYLLABLE PIEUP-WEO-SSANGSIOS
     (?$(C:^(B . ?\xBDB8) ; HANGUL SYLLABLE PIEUP-WE
     (?$(C:_(B . ?\xBDD4) ; HANGUL SYLLABLE PIEUP-WI
     (?$(C:`(B . ?\xBDD5) ; HANGUL SYLLABLE PIEUP-WI-KIYEOK
     (?$(C:a(B . ?\xBDD8) ; HANGUL SYLLABLE PIEUP-WI-NIEUN
     (?$(C:b(B . ?\xBDDC) ; HANGUL SYLLABLE PIEUP-WI-RIEUL
     (?$(C:c(B . ?\xBDE9) ; HANGUL SYLLABLE PIEUP-WI-IEUNG
     (?$(C:d(B . ?\xBDF0) ; HANGUL SYLLABLE PIEUP-YU
     (?$(C:e(B . ?\xBDF4) ; HANGUL SYLLABLE PIEUP-YU-NIEUN
     (?$(C:f(B . ?\xBDF8) ; HANGUL SYLLABLE PIEUP-YU-RIEUL
     (?$(C:g(B . ?\xBE00) ; HANGUL SYLLABLE PIEUP-YU-MIEUM
     (?$(C:h(B . ?\xBE03) ; HANGUL SYLLABLE PIEUP-YU-SIOS
     (?$(C:i(B . ?\xBE05) ; HANGUL SYLLABLE PIEUP-YU-IEUNG
     (?$(C:j(B . ?\xBE0C) ; HANGUL SYLLABLE PIEUP-EU
     (?$(C:k(B . ?\xBE0D) ; HANGUL SYLLABLE PIEUP-EU-KIYEOK
     (?$(C:l(B . ?\xBE10) ; HANGUL SYLLABLE PIEUP-EU-NIEUN
     (?$(C:m(B . ?\xBE14) ; HANGUL SYLLABLE PIEUP-EU-RIEUL
     (?$(C:n(B . ?\xBE1C) ; HANGUL SYLLABLE PIEUP-EU-MIEUM
     (?$(C:o(B . ?\xBE1D) ; HANGUL SYLLABLE PIEUP-EU-PIEUP
     (?$(C:p(B . ?\xBE1F) ; HANGUL SYLLABLE PIEUP-EU-SIOS
     (?$(C:q(B . ?\xBE44) ; HANGUL SYLLABLE PIEUP-I
     (?$(C:r(B . ?\xBE45) ; HANGUL SYLLABLE PIEUP-I-KIYEOK
     (?$(C:s(B . ?\xBE48) ; HANGUL SYLLABLE PIEUP-I-NIEUN
     (?$(C:t(B . ?\xBE4C) ; HANGUL SYLLABLE PIEUP-I-RIEUL
     (?$(C:u(B . ?\xBE4E) ; HANGUL SYLLABLE PIEUP-I-RIEULMIEUM
     (?$(C:v(B . ?\xBE54) ; HANGUL SYLLABLE PIEUP-I-MIEUM
     (?$(C:w(B . ?\xBE55) ; HANGUL SYLLABLE PIEUP-I-PIEUP
     (?$(C:x(B . ?\xBE57) ; HANGUL SYLLABLE PIEUP-I-SIOS
     (?$(C:y(B . ?\xBE59) ; HANGUL SYLLABLE PIEUP-I-IEUNG
     (?$(C:z(B . ?\xBE5A) ; HANGUL SYLLABLE PIEUP-I-CIEUC
     (?$(C:{(B . ?\xBE5B) ; HANGUL SYLLABLE PIEUP-I-CHIEUCH
     (?$(C:|(B . ?\xBE60) ; HANGUL SYLLABLE SSANGPIEUP-A
     (?$(C:}(B . ?\xBE61) ; HANGUL SYLLABLE SSANGPIEUP-A-KIYEOK
     (?$(C:~(B . ?\xBE64) ; HANGUL SYLLABLE SSANGPIEUP-A-NIEUN
     (?$(C;!(B . ?\xBE68) ; HANGUL SYLLABLE SSANGPIEUP-A-RIEUL
     (?$(C;"(B . ?\xBE6A) ; HANGUL SYLLABLE SSANGPIEUP-A-RIEULMIEUM
     (?$(C;#(B . ?\xBE70) ; HANGUL SYLLABLE SSANGPIEUP-A-MIEUM
     (?$(C;$(B . ?\xBE71) ; HANGUL SYLLABLE SSANGPIEUP-A-PIEUP
     (?$(C;%(B . ?\xBE73) ; HANGUL SYLLABLE SSANGPIEUP-A-SIOS
     (?$(C;&(B . ?\xBE74) ; HANGUL SYLLABLE SSANGPIEUP-A-SSANGSIOS
     (?$(C;'(B . ?\xBE75) ; HANGUL SYLLABLE SSANGPIEUP-A-IEUNG
     (?$(C;((B . ?\xBE7B) ; HANGUL SYLLABLE SSANGPIEUP-A-HIEUH
     (?$(C;)(B . ?\xBE7C) ; HANGUL SYLLABLE SSANGPIEUP-AE
     (?$(C;*(B . ?\xBE7D) ; HANGUL SYLLABLE SSANGPIEUP-AE-KIYEOK
     (?$(C;+(B . ?\xBE80) ; HANGUL SYLLABLE SSANGPIEUP-AE-NIEUN
     (?$(C;,(B . ?\xBE84) ; HANGUL SYLLABLE SSANGPIEUP-AE-RIEUL
     (?$(C;-(B . ?\xBE8C) ; HANGUL SYLLABLE SSANGPIEUP-AE-MIEUM
     (?$(C;.(B . ?\xBE8D) ; HANGUL SYLLABLE SSANGPIEUP-AE-PIEUP
     (?$(C;/(B . ?\xBE8F) ; HANGUL SYLLABLE SSANGPIEUP-AE-SIOS
     (?$(C;0(B . ?\xBE90) ; HANGUL SYLLABLE SSANGPIEUP-AE-SSANGSIOS
     (?$(C;1(B . ?\xBE91) ; HANGUL SYLLABLE SSANGPIEUP-AE-IEUNG
     (?$(C;2(B . ?\xBE98) ; HANGUL SYLLABLE SSANGPIEUP-YA
     (?$(C;3(B . ?\xBE99) ; HANGUL SYLLABLE SSANGPIEUP-YA-KIYEOK
     (?$(C;4(B . ?\xBEA8) ; HANGUL SYLLABLE SSANGPIEUP-YA-MIEUM
     (?$(C;5(B . ?\xBED0) ; HANGUL SYLLABLE SSANGPIEUP-EO
     (?$(C;6(B . ?\xBED1) ; HANGUL SYLLABLE SSANGPIEUP-EO-KIYEOK
     (?$(C;7(B . ?\xBED4) ; HANGUL SYLLABLE SSANGPIEUP-EO-NIEUN
     (?$(C;8(B . ?\xBED7) ; HANGUL SYLLABLE SSANGPIEUP-EO-TIKEUT
     (?$(C;9(B . ?\xBED8) ; HANGUL SYLLABLE SSANGPIEUP-EO-RIEUL
     (?$(C;:(B . ?\xBEE0) ; HANGUL SYLLABLE SSANGPIEUP-EO-MIEUM
     (?$(C;;(B . ?\xBEE3) ; HANGUL SYLLABLE SSANGPIEUP-EO-SIOS
     (?$(C;<(B . ?\xBEE4) ; HANGUL SYLLABLE SSANGPIEUP-EO-SSANGSIOS
     (?$(C;=(B . ?\xBEE5) ; HANGUL SYLLABLE SSANGPIEUP-EO-IEUNG
     (?$(C;>(B . ?\xBEEC) ; HANGUL SYLLABLE SSANGPIEUP-E
     (?$(C;?(B . ?\xBF01) ; HANGUL SYLLABLE SSANGPIEUP-E-IEUNG
     (?$(C;@(B . ?\xBF08) ; HANGUL SYLLABLE SSANGPIEUP-YEO
     (?$(C;A(B . ?\xBF09) ; HANGUL SYLLABLE SSANGPIEUP-YEO-KIYEOK
     (?$(C;B(B . ?\xBF18) ; HANGUL SYLLABLE SSANGPIEUP-YEO-MIEUM
     (?$(C;C(B . ?\xBF19) ; HANGUL SYLLABLE SSANGPIEUP-YEO-PIEUP
     (?$(C;D(B . ?\xBF1B) ; HANGUL SYLLABLE SSANGPIEUP-YEO-SIOS
     (?$(C;E(B . ?\xBF1C) ; HANGUL SYLLABLE SSANGPIEUP-YEO-SSANGSIOS
     (?$(C;F(B . ?\xBF1D) ; HANGUL SYLLABLE SSANGPIEUP-YEO-IEUNG
     (?$(C;G(B . ?\xBF40) ; HANGUL SYLLABLE SSANGPIEUP-O
     (?$(C;H(B . ?\xBF41) ; HANGUL SYLLABLE SSANGPIEUP-O-KIYEOK
     (?$(C;I(B . ?\xBF44) ; HANGUL SYLLABLE SSANGPIEUP-O-NIEUN
     (?$(C;J(B . ?\xBF48) ; HANGUL SYLLABLE SSANGPIEUP-O-RIEUL
     (?$(C;K(B . ?\xBF50) ; HANGUL SYLLABLE SSANGPIEUP-O-MIEUM
     (?$(C;L(B . ?\xBF51) ; HANGUL SYLLABLE SSANGPIEUP-O-PIEUP
     (?$(C;M(B . ?\xBF55) ; HANGUL SYLLABLE SSANGPIEUP-O-IEUNG
     (?$(C;N(B . ?\xBF94) ; HANGUL SYLLABLE SSANGPIEUP-OE
     (?$(C;O(B . ?\xBFB0) ; HANGUL SYLLABLE SSANGPIEUP-YO
     (?$(C;P(B . ?\xBFC5) ; HANGUL SYLLABLE SSANGPIEUP-YO-IEUNG
     (?$(C;Q(B . ?\xBFCC) ; HANGUL SYLLABLE SSANGPIEUP-U
     (?$(C;R(B . ?\xBFCD) ; HANGUL SYLLABLE SSANGPIEUP-U-KIYEOK
     (?$(C;S(B . ?\xBFD0) ; HANGUL SYLLABLE SSANGPIEUP-U-NIEUN
     (?$(C;T(B . ?\xBFD4) ; HANGUL SYLLABLE SSANGPIEUP-U-RIEUL
     (?$(C;U(B . ?\xBFDC) ; HANGUL SYLLABLE SSANGPIEUP-U-MIEUM
     (?$(C;V(B . ?\xBFDF) ; HANGUL SYLLABLE SSANGPIEUP-U-SIOS
     (?$(C;W(B . ?\xBFE1) ; HANGUL SYLLABLE SSANGPIEUP-U-IEUNG
     (?$(C;X(B . ?\xC03C) ; HANGUL SYLLABLE SSANGPIEUP-YU
     (?$(C;Y(B . ?\xC051) ; HANGUL SYLLABLE SSANGPIEUP-YU-IEUNG
     (?$(C;Z(B . ?\xC058) ; HANGUL SYLLABLE SSANGPIEUP-EU
     (?$(C;[(B . ?\xC05C) ; HANGUL SYLLABLE SSANGPIEUP-EU-NIEUN
     (?$(C;\(B . ?\xC060) ; HANGUL SYLLABLE SSANGPIEUP-EU-RIEUL
     (?$(C;](B . ?\xC068) ; HANGUL SYLLABLE SSANGPIEUP-EU-MIEUM
     (?$(C;^(B . ?\xC069) ; HANGUL SYLLABLE SSANGPIEUP-EU-PIEUP
     (?$(C;_(B . ?\xC090) ; HANGUL SYLLABLE SSANGPIEUP-I
     (?$(C;`(B . ?\xC091) ; HANGUL SYLLABLE SSANGPIEUP-I-KIYEOK
     (?$(C;a(B . ?\xC094) ; HANGUL SYLLABLE SSANGPIEUP-I-NIEUN
     (?$(C;b(B . ?\xC098) ; HANGUL SYLLABLE SSANGPIEUP-I-RIEUL
     (?$(C;c(B . ?\xC0A0) ; HANGUL SYLLABLE SSANGPIEUP-I-MIEUM
     (?$(C;d(B . ?\xC0A1) ; HANGUL SYLLABLE SSANGPIEUP-I-PIEUP
     (?$(C;e(B . ?\xC0A3) ; HANGUL SYLLABLE SSANGPIEUP-I-SIOS
     (?$(C;f(B . ?\xC0A5) ; HANGUL SYLLABLE SSANGPIEUP-I-IEUNG
     (?$(C;g(B . ?\xC0AC) ; HANGUL SYLLABLE SIOS-A
     (?$(C;h(B . ?\xC0AD) ; HANGUL SYLLABLE SIOS-A-KIYEOK
     (?$(C;i(B . ?\xC0AF) ; HANGUL SYLLABLE SIOS-A-KIYEOKSIOS
     (?$(C;j(B . ?\xC0B0) ; HANGUL SYLLABLE SIOS-A-NIEUN
     (?$(C;k(B . ?\xC0B3) ; HANGUL SYLLABLE SIOS-A-TIKEUT
     (?$(C;l(B . ?\xC0B4) ; HANGUL SYLLABLE SIOS-A-RIEUL
     (?$(C;m(B . ?\xC0B5) ; HANGUL SYLLABLE SIOS-A-RIEULKIYEOK
     (?$(C;n(B . ?\xC0B6) ; HANGUL SYLLABLE SIOS-A-RIEULMIEUM
     (?$(C;o(B . ?\xC0BC) ; HANGUL SYLLABLE SIOS-A-MIEUM
     (?$(C;p(B . ?\xC0BD) ; HANGUL SYLLABLE SIOS-A-PIEUP
     (?$(C;q(B . ?\xC0BF) ; HANGUL SYLLABLE SIOS-A-SIOS
     (?$(C;r(B . ?\xC0C0) ; HANGUL SYLLABLE SIOS-A-SSANGSIOS
     (?$(C;s(B . ?\xC0C1) ; HANGUL SYLLABLE SIOS-A-IEUNG
     (?$(C;t(B . ?\xC0C5) ; HANGUL SYLLABLE SIOS-A-THIEUTH
     (?$(C;u(B . ?\xC0C8) ; HANGUL SYLLABLE SIOS-AE
     (?$(C;v(B . ?\xC0C9) ; HANGUL SYLLABLE SIOS-AE-KIYEOK
     (?$(C;w(B . ?\xC0CC) ; HANGUL SYLLABLE SIOS-AE-NIEUN
     (?$(C;x(B . ?\xC0D0) ; HANGUL SYLLABLE SIOS-AE-RIEUL
     (?$(C;y(B . ?\xC0D8) ; HANGUL SYLLABLE SIOS-AE-MIEUM
     (?$(C;z(B . ?\xC0D9) ; HANGUL SYLLABLE SIOS-AE-PIEUP
     (?$(C;{(B . ?\xC0DB) ; HANGUL SYLLABLE SIOS-AE-SIOS
     (?$(C;|(B . ?\xC0DC) ; HANGUL SYLLABLE SIOS-AE-SSANGSIOS
     (?$(C;}(B . ?\xC0DD) ; HANGUL SYLLABLE SIOS-AE-IEUNG
     (?$(C;~(B . ?\xC0E4) ; HANGUL SYLLABLE SIOS-YA
     (?$(C<!(B . ?\xC0E5) ; HANGUL SYLLABLE SIOS-YA-KIYEOK
     (?$(C<"(B . ?\xC0E8) ; HANGUL SYLLABLE SIOS-YA-NIEUN
     (?$(C<#(B . ?\xC0EC) ; HANGUL SYLLABLE SIOS-YA-RIEUL
     (?$(C<$(B . ?\xC0F4) ; HANGUL SYLLABLE SIOS-YA-MIEUM
     (?$(C<%(B . ?\xC0F5) ; HANGUL SYLLABLE SIOS-YA-PIEUP
     (?$(C<&(B . ?\xC0F7) ; HANGUL SYLLABLE SIOS-YA-SIOS
     (?$(C<'(B . ?\xC0F9) ; HANGUL SYLLABLE SIOS-YA-IEUNG
     (?$(C<((B . ?\xC100) ; HANGUL SYLLABLE SIOS-YAE
     (?$(C<)(B . ?\xC104) ; HANGUL SYLLABLE SIOS-YAE-NIEUN
     (?$(C<*(B . ?\xC108) ; HANGUL SYLLABLE SIOS-YAE-RIEUL
     (?$(C<+(B . ?\xC110) ; HANGUL SYLLABLE SIOS-YAE-MIEUM
     (?$(C<,(B . ?\xC115) ; HANGUL SYLLABLE SIOS-YAE-IEUNG
     (?$(C<-(B . ?\xC11C) ; HANGUL SYLLABLE SIOS-EO
     (?$(C<.(B . ?\xC11D) ; HANGUL SYLLABLE SIOS-EO-KIYEOK
     (?$(C</(B . ?\xC11E) ; HANGUL SYLLABLE SIOS-EO-SSANGKIYEOK
     (?$(C<0(B . ?\xC11F) ; HANGUL SYLLABLE SIOS-EO-KIYEOKSIOS
     (?$(C<1(B . ?\xC120) ; HANGUL SYLLABLE SIOS-EO-NIEUN
     (?$(C<2(B . ?\xC123) ; HANGUL SYLLABLE SIOS-EO-TIKEUT
     (?$(C<3(B . ?\xC124) ; HANGUL SYLLABLE SIOS-EO-RIEUL
     (?$(C<4(B . ?\xC126) ; HANGUL SYLLABLE SIOS-EO-RIEULMIEUM
     (?$(C<5(B . ?\xC127) ; HANGUL SYLLABLE SIOS-EO-RIEULPIEUP
     (?$(C<6(B . ?\xC12C) ; HANGUL SYLLABLE SIOS-EO-MIEUM
     (?$(C<7(B . ?\xC12D) ; HANGUL SYLLABLE SIOS-EO-PIEUP
     (?$(C<8(B . ?\xC12F) ; HANGUL SYLLABLE SIOS-EO-SIOS
     (?$(C<9(B . ?\xC130) ; HANGUL SYLLABLE SIOS-EO-SSANGSIOS
     (?$(C<:(B . ?\xC131) ; HANGUL SYLLABLE SIOS-EO-IEUNG
     (?$(C<;(B . ?\xC136) ; HANGUL SYLLABLE SIOS-EO-PHIEUPH
     (?$(C<<(B . ?\xC138) ; HANGUL SYLLABLE SIOS-E
     (?$(C<=(B . ?\xC139) ; HANGUL SYLLABLE SIOS-E-KIYEOK
     (?$(C<>(B . ?\xC13C) ; HANGUL SYLLABLE SIOS-E-NIEUN
     (?$(C<?(B . ?\xC140) ; HANGUL SYLLABLE SIOS-E-RIEUL
     (?$(C<@(B . ?\xC148) ; HANGUL SYLLABLE SIOS-E-MIEUM
     (?$(C<A(B . ?\xC149) ; HANGUL SYLLABLE SIOS-E-PIEUP
     (?$(C<B(B . ?\xC14B) ; HANGUL SYLLABLE SIOS-E-SIOS
     (?$(C<C(B . ?\xC14C) ; HANGUL SYLLABLE SIOS-E-SSANGSIOS
     (?$(C<D(B . ?\xC14D) ; HANGUL SYLLABLE SIOS-E-IEUNG
     (?$(C<E(B . ?\xC154) ; HANGUL SYLLABLE SIOS-YEO
     (?$(C<F(B . ?\xC155) ; HANGUL SYLLABLE SIOS-YEO-KIYEOK
     (?$(C<G(B . ?\xC158) ; HANGUL SYLLABLE SIOS-YEO-NIEUN
     (?$(C<H(B . ?\xC15C) ; HANGUL SYLLABLE SIOS-YEO-RIEUL
     (?$(C<I(B . ?\xC164) ; HANGUL SYLLABLE SIOS-YEO-MIEUM
     (?$(C<J(B . ?\xC165) ; HANGUL SYLLABLE SIOS-YEO-PIEUP
     (?$(C<K(B . ?\xC167) ; HANGUL SYLLABLE SIOS-YEO-SIOS
     (?$(C<L(B . ?\xC168) ; HANGUL SYLLABLE SIOS-YEO-SSANGSIOS
     (?$(C<M(B . ?\xC169) ; HANGUL SYLLABLE SIOS-YEO-IEUNG
     (?$(C<N(B . ?\xC170) ; HANGUL SYLLABLE SIOS-YE
     (?$(C<O(B . ?\xC174) ; HANGUL SYLLABLE SIOS-YE-NIEUN
     (?$(C<P(B . ?\xC178) ; HANGUL SYLLABLE SIOS-YE-RIEUL
     (?$(C<Q(B . ?\xC185) ; HANGUL SYLLABLE SIOS-YE-IEUNG
     (?$(C<R(B . ?\xC18C) ; HANGUL SYLLABLE SIOS-O
     (?$(C<S(B . ?\xC18D) ; HANGUL SYLLABLE SIOS-O-KIYEOK
     (?$(C<T(B . ?\xC18E) ; HANGUL SYLLABLE SIOS-O-SSANGKIYEOK
     (?$(C<U(B . ?\xC190) ; HANGUL SYLLABLE SIOS-O-NIEUN
     (?$(C<V(B . ?\xC194) ; HANGUL SYLLABLE SIOS-O-RIEUL
     (?$(C<W(B . ?\xC196) ; HANGUL SYLLABLE SIOS-O-RIEULMIEUM
     (?$(C<X(B . ?\xC19C) ; HANGUL SYLLABLE SIOS-O-MIEUM
     (?$(C<Y(B . ?\xC19D) ; HANGUL SYLLABLE SIOS-O-PIEUP
     (?$(C<Z(B . ?\xC19F) ; HANGUL SYLLABLE SIOS-O-SIOS
     (?$(C<[(B . ?\xC1A1) ; HANGUL SYLLABLE SIOS-O-IEUNG
     (?$(C<\(B . ?\xC1A5) ; HANGUL SYLLABLE SIOS-O-THIEUTH
     (?$(C<](B . ?\xC1A8) ; HANGUL SYLLABLE SIOS-WA
     (?$(C<^(B . ?\xC1A9) ; HANGUL SYLLABLE SIOS-WA-KIYEOK
     (?$(C<_(B . ?\xC1AC) ; HANGUL SYLLABLE SIOS-WA-NIEUN
     (?$(C<`(B . ?\xC1B0) ; HANGUL SYLLABLE SIOS-WA-RIEUL
     (?$(C<a(B . ?\xC1BD) ; HANGUL SYLLABLE SIOS-WA-IEUNG
     (?$(C<b(B . ?\xC1C4) ; HANGUL SYLLABLE SIOS-WAE
     (?$(C<c(B . ?\xC1C8) ; HANGUL SYLLABLE SIOS-WAE-NIEUN
     (?$(C<d(B . ?\xC1CC) ; HANGUL SYLLABLE SIOS-WAE-RIEUL
     (?$(C<e(B . ?\xC1D4) ; HANGUL SYLLABLE SIOS-WAE-MIEUM
     (?$(C<f(B . ?\xC1D7) ; HANGUL SYLLABLE SIOS-WAE-SIOS
     (?$(C<g(B . ?\xC1D8) ; HANGUL SYLLABLE SIOS-WAE-SSANGSIOS
     (?$(C<h(B . ?\xC1E0) ; HANGUL SYLLABLE SIOS-OE
     (?$(C<i(B . ?\xC1E4) ; HANGUL SYLLABLE SIOS-OE-NIEUN
     (?$(C<j(B . ?\xC1E8) ; HANGUL SYLLABLE SIOS-OE-RIEUL
     (?$(C<k(B . ?\xC1F0) ; HANGUL SYLLABLE SIOS-OE-MIEUM
     (?$(C<l(B . ?\xC1F1) ; HANGUL SYLLABLE SIOS-OE-PIEUP
     (?$(C<m(B . ?\xC1F3) ; HANGUL SYLLABLE SIOS-OE-SIOS
     (?$(C<n(B . ?\xC1FC) ; HANGUL SYLLABLE SIOS-YO
     (?$(C<o(B . ?\xC1FD) ; HANGUL SYLLABLE SIOS-YO-KIYEOK
     (?$(C<p(B . ?\xC200) ; HANGUL SYLLABLE SIOS-YO-NIEUN
     (?$(C<q(B . ?\xC204) ; HANGUL SYLLABLE SIOS-YO-RIEUL
     (?$(C<r(B . ?\xC20C) ; HANGUL SYLLABLE SIOS-YO-MIEUM
     (?$(C<s(B . ?\xC20D) ; HANGUL SYLLABLE SIOS-YO-PIEUP
     (?$(C<t(B . ?\xC20F) ; HANGUL SYLLABLE SIOS-YO-SIOS
     (?$(C<u(B . ?\xC211) ; HANGUL SYLLABLE SIOS-YO-IEUNG
     (?$(C<v(B . ?\xC218) ; HANGUL SYLLABLE SIOS-U
     (?$(C<w(B . ?\xC219) ; HANGUL SYLLABLE SIOS-U-KIYEOK
     (?$(C<x(B . ?\xC21C) ; HANGUL SYLLABLE SIOS-U-NIEUN
     (?$(C<y(B . ?\xC21F) ; HANGUL SYLLABLE SIOS-U-TIKEUT
     (?$(C<z(B . ?\xC220) ; HANGUL SYLLABLE SIOS-U-RIEUL
     (?$(C<{(B . ?\xC228) ; HANGUL SYLLABLE SIOS-U-MIEUM
     (?$(C<|(B . ?\xC229) ; HANGUL SYLLABLE SIOS-U-PIEUP
     (?$(C<}(B . ?\xC22B) ; HANGUL SYLLABLE SIOS-U-SIOS
     (?$(C<~(B . ?\xC22D) ; HANGUL SYLLABLE SIOS-U-IEUNG
     (?$(C=!(B . ?\xC22F) ; HANGUL SYLLABLE SIOS-U-CHIEUCH
     (?$(C="(B . ?\xC231) ; HANGUL SYLLABLE SIOS-U-THIEUTH
     (?$(C=#(B . ?\xC232) ; HANGUL SYLLABLE SIOS-U-PHIEUPH
     (?$(C=$(B . ?\xC234) ; HANGUL SYLLABLE SIOS-WEO
     (?$(C=%(B . ?\xC248) ; HANGUL SYLLABLE SIOS-WEO-SSANGSIOS
     (?$(C=&(B . ?\xC250) ; HANGUL SYLLABLE SIOS-WE
     (?$(C='(B . ?\xC251) ; HANGUL SYLLABLE SIOS-WE-KIYEOK
     (?$(C=((B . ?\xC254) ; HANGUL SYLLABLE SIOS-WE-NIEUN
     (?$(C=)(B . ?\xC258) ; HANGUL SYLLABLE SIOS-WE-RIEUL
     (?$(C=*(B . ?\xC260) ; HANGUL SYLLABLE SIOS-WE-MIEUM
     (?$(C=+(B . ?\xC265) ; HANGUL SYLLABLE SIOS-WE-IEUNG
     (?$(C=,(B . ?\xC26C) ; HANGUL SYLLABLE SIOS-WI
     (?$(C=-(B . ?\xC26D) ; HANGUL SYLLABLE SIOS-WI-KIYEOK
     (?$(C=.(B . ?\xC270) ; HANGUL SYLLABLE SIOS-WI-NIEUN
     (?$(C=/(B . ?\xC274) ; HANGUL SYLLABLE SIOS-WI-RIEUL
     (?$(C=0(B . ?\xC27C) ; HANGUL SYLLABLE SIOS-WI-MIEUM
     (?$(C=1(B . ?\xC27D) ; HANGUL SYLLABLE SIOS-WI-PIEUP
     (?$(C=2(B . ?\xC27F) ; HANGUL SYLLABLE SIOS-WI-SIOS
     (?$(C=3(B . ?\xC281) ; HANGUL SYLLABLE SIOS-WI-IEUNG
     (?$(C=4(B . ?\xC288) ; HANGUL SYLLABLE SIOS-YU
     (?$(C=5(B . ?\xC289) ; HANGUL SYLLABLE SIOS-YU-KIYEOK
     (?$(C=6(B . ?\xC290) ; HANGUL SYLLABLE SIOS-YU-RIEUL
     (?$(C=7(B . ?\xC298) ; HANGUL SYLLABLE SIOS-YU-MIEUM
     (?$(C=8(B . ?\xC29B) ; HANGUL SYLLABLE SIOS-YU-SIOS
     (?$(C=9(B . ?\xC29D) ; HANGUL SYLLABLE SIOS-YU-IEUNG
     (?$(C=:(B . ?\xC2A4) ; HANGUL SYLLABLE SIOS-EU
     (?$(C=;(B . ?\xC2A5) ; HANGUL SYLLABLE SIOS-EU-KIYEOK
     (?$(C=<(B . ?\xC2A8) ; HANGUL SYLLABLE SIOS-EU-NIEUN
     (?$(C==(B . ?\xC2AC) ; HANGUL SYLLABLE SIOS-EU-RIEUL
     (?$(C=>(B . ?\xC2AD) ; HANGUL SYLLABLE SIOS-EU-RIEULKIYEOK
     (?$(C=?(B . ?\xC2B4) ; HANGUL SYLLABLE SIOS-EU-MIEUM
     (?$(C=@(B . ?\xC2B5) ; HANGUL SYLLABLE SIOS-EU-PIEUP
     (?$(C=A(B . ?\xC2B7) ; HANGUL SYLLABLE SIOS-EU-SIOS
     (?$(C=B(B . ?\xC2B9) ; HANGUL SYLLABLE SIOS-EU-IEUNG
     (?$(C=C(B . ?\xC2DC) ; HANGUL SYLLABLE SIOS-I
     (?$(C=D(B . ?\xC2DD) ; HANGUL SYLLABLE SIOS-I-KIYEOK
     (?$(C=E(B . ?\xC2E0) ; HANGUL SYLLABLE SIOS-I-NIEUN
     (?$(C=F(B . ?\xC2E3) ; HANGUL SYLLABLE SIOS-I-TIKEUT
     (?$(C=G(B . ?\xC2E4) ; HANGUL SYLLABLE SIOS-I-RIEUL
     (?$(C=H(B . ?\xC2EB) ; HANGUL SYLLABLE SIOS-I-RIEULHIEUH
     (?$(C=I(B . ?\xC2EC) ; HANGUL SYLLABLE SIOS-I-MIEUM
     (?$(C=J(B . ?\xC2ED) ; HANGUL SYLLABLE SIOS-I-PIEUP
     (?$(C=K(B . ?\xC2EF) ; HANGUL SYLLABLE SIOS-I-SIOS
     (?$(C=L(B . ?\xC2F1) ; HANGUL SYLLABLE SIOS-I-IEUNG
     (?$(C=M(B . ?\xC2F6) ; HANGUL SYLLABLE SIOS-I-PHIEUPH
     (?$(C=N(B . ?\xC2F8) ; HANGUL SYLLABLE SSANGSIOS-A
     (?$(C=O(B . ?\xC2F9) ; HANGUL SYLLABLE SSANGSIOS-A-KIYEOK
     (?$(C=P(B . ?\xC2FB) ; HANGUL SYLLABLE SSANGSIOS-A-KIYEOKSIOS
     (?$(C=Q(B . ?\xC2FC) ; HANGUL SYLLABLE SSANGSIOS-A-NIEUN
     (?$(C=R(B . ?\xC300) ; HANGUL SYLLABLE SSANGSIOS-A-RIEUL
     (?$(C=S(B . ?\xC308) ; HANGUL SYLLABLE SSANGSIOS-A-MIEUM
     (?$(C=T(B . ?\xC309) ; HANGUL SYLLABLE SSANGSIOS-A-PIEUP
     (?$(C=U(B . ?\xC30C) ; HANGUL SYLLABLE SSANGSIOS-A-SSANGSIOS
     (?$(C=V(B . ?\xC30D) ; HANGUL SYLLABLE SSANGSIOS-A-IEUNG
     (?$(C=W(B . ?\xC313) ; HANGUL SYLLABLE SSANGSIOS-A-HIEUH
     (?$(C=X(B . ?\xC314) ; HANGUL SYLLABLE SSANGSIOS-AE
     (?$(C=Y(B . ?\xC315) ; HANGUL SYLLABLE SSANGSIOS-AE-KIYEOK
     (?$(C=Z(B . ?\xC318) ; HANGUL SYLLABLE SSANGSIOS-AE-NIEUN
     (?$(C=[(B . ?\xC31C) ; HANGUL SYLLABLE SSANGSIOS-AE-RIEUL
     (?$(C=\(B . ?\xC324) ; HANGUL SYLLABLE SSANGSIOS-AE-MIEUM
     (?$(C=](B . ?\xC325) ; HANGUL SYLLABLE SSANGSIOS-AE-PIEUP
     (?$(C=^(B . ?\xC328) ; HANGUL SYLLABLE SSANGSIOS-AE-SSANGSIOS
     (?$(C=_(B . ?\xC329) ; HANGUL SYLLABLE SSANGSIOS-AE-IEUNG
     (?$(C=`(B . ?\xC345) ; HANGUL SYLLABLE SSANGSIOS-YA-IEUNG
     (?$(C=a(B . ?\xC368) ; HANGUL SYLLABLE SSANGSIOS-EO
     (?$(C=b(B . ?\xC369) ; HANGUL SYLLABLE SSANGSIOS-EO-KIYEOK
     (?$(C=c(B . ?\xC36C) ; HANGUL SYLLABLE SSANGSIOS-EO-NIEUN
     (?$(C=d(B . ?\xC370) ; HANGUL SYLLABLE SSANGSIOS-EO-RIEUL
     (?$(C=e(B . ?\xC372) ; HANGUL SYLLABLE SSANGSIOS-EO-RIEULMIEUM
     (?$(C=f(B . ?\xC378) ; HANGUL SYLLABLE SSANGSIOS-EO-MIEUM
     (?$(C=g(B . ?\xC379) ; HANGUL SYLLABLE SSANGSIOS-EO-PIEUP
     (?$(C=h(B . ?\xC37C) ; HANGUL SYLLABLE SSANGSIOS-EO-SSANGSIOS
     (?$(C=i(B . ?\xC37D) ; HANGUL SYLLABLE SSANGSIOS-EO-IEUNG
     (?$(C=j(B . ?\xC384) ; HANGUL SYLLABLE SSANGSIOS-E
     (?$(C=k(B . ?\xC388) ; HANGUL SYLLABLE SSANGSIOS-E-NIEUN
     (?$(C=l(B . ?\xC38C) ; HANGUL SYLLABLE SSANGSIOS-E-RIEUL
     (?$(C=m(B . ?\xC3C0) ; HANGUL SYLLABLE SSANGSIOS-YE-NIEUN
     (?$(C=n(B . ?\xC3D8) ; HANGUL SYLLABLE SSANGSIOS-O
     (?$(C=o(B . ?\xC3D9) ; HANGUL SYLLABLE SSANGSIOS-O-KIYEOK
     (?$(C=p(B . ?\xC3DC) ; HANGUL SYLLABLE SSANGSIOS-O-NIEUN
     (?$(C=q(B . ?\xC3DF) ; HANGUL SYLLABLE SSANGSIOS-O-TIKEUT
     (?$(C=r(B . ?\xC3E0) ; HANGUL SYLLABLE SSANGSIOS-O-RIEUL
     (?$(C=s(B . ?\xC3E2) ; HANGUL SYLLABLE SSANGSIOS-O-RIEULMIEUM
     (?$(C=t(B . ?\xC3E8) ; HANGUL SYLLABLE SSANGSIOS-O-MIEUM
     (?$(C=u(B . ?\xC3E9) ; HANGUL SYLLABLE SSANGSIOS-O-PIEUP
     (?$(C=v(B . ?\xC3ED) ; HANGUL SYLLABLE SSANGSIOS-O-IEUNG
     (?$(C=w(B . ?\xC3F4) ; HANGUL SYLLABLE SSANGSIOS-WA
     (?$(C=x(B . ?\xC3F5) ; HANGUL SYLLABLE SSANGSIOS-WA-KIYEOK
     (?$(C=y(B . ?\xC3F8) ; HANGUL SYLLABLE SSANGSIOS-WA-NIEUN
     (?$(C=z(B . ?\xC408) ; HANGUL SYLLABLE SSANGSIOS-WA-SSANGSIOS
     (?$(C={(B . ?\xC410) ; HANGUL SYLLABLE SSANGSIOS-WAE
     (?$(C=|(B . ?\xC424) ; HANGUL SYLLABLE SSANGSIOS-WAE-SSANGSIOS
     (?$(C=}(B . ?\xC42C) ; HANGUL SYLLABLE SSANGSIOS-OE
     (?$(C=~(B . ?\xC430) ; HANGUL SYLLABLE SSANGSIOS-OE-NIEUN
     (?$(C>!(B . ?\xC434) ; HANGUL SYLLABLE SSANGSIOS-OE-RIEUL
     (?$(C>"(B . ?\xC43C) ; HANGUL SYLLABLE SSANGSIOS-OE-MIEUM
     (?$(C>#(B . ?\xC43D) ; HANGUL SYLLABLE SSANGSIOS-OE-PIEUP
     (?$(C>$(B . ?\xC448) ; HANGUL SYLLABLE SSANGSIOS-YO
     (?$(C>%(B . ?\xC464) ; HANGUL SYLLABLE SSANGSIOS-U
     (?$(C>&(B . ?\xC465) ; HANGUL SYLLABLE SSANGSIOS-U-KIYEOK
     (?$(C>'(B . ?\xC468) ; HANGUL SYLLABLE SSANGSIOS-U-NIEUN
     (?$(C>((B . ?\xC46C) ; HANGUL SYLLABLE SSANGSIOS-U-RIEUL
     (?$(C>)(B . ?\xC474) ; HANGUL SYLLABLE SSANGSIOS-U-MIEUM
     (?$(C>*(B . ?\xC475) ; HANGUL SYLLABLE SSANGSIOS-U-PIEUP
     (?$(C>+(B . ?\xC479) ; HANGUL SYLLABLE SSANGSIOS-U-IEUNG
     (?$(C>,(B . ?\xC480) ; HANGUL SYLLABLE SSANGSIOS-WEO
     (?$(C>-(B . ?\xC494) ; HANGUL SYLLABLE SSANGSIOS-WEO-SSANGSIOS
     (?$(C>.(B . ?\xC49C) ; HANGUL SYLLABLE SSANGSIOS-WE
     (?$(C>/(B . ?\xC4B8) ; HANGUL SYLLABLE SSANGSIOS-WI
     (?$(C>0(B . ?\xC4BC) ; HANGUL SYLLABLE SSANGSIOS-WI-NIEUN
     (?$(C>1(B . ?\xC4E9) ; HANGUL SYLLABLE SSANGSIOS-YU-IEUNG
     (?$(C>2(B . ?\xC4F0) ; HANGUL SYLLABLE SSANGSIOS-EU
     (?$(C>3(B . ?\xC4F1) ; HANGUL SYLLABLE SSANGSIOS-EU-KIYEOK
     (?$(C>4(B . ?\xC4F4) ; HANGUL SYLLABLE SSANGSIOS-EU-NIEUN
     (?$(C>5(B . ?\xC4F8) ; HANGUL SYLLABLE SSANGSIOS-EU-RIEUL
     (?$(C>6(B . ?\xC4FA) ; HANGUL SYLLABLE SSANGSIOS-EU-RIEULMIEUM
     (?$(C>7(B . ?\xC4FF) ; HANGUL SYLLABLE SSANGSIOS-EU-RIEULHIEUH
     (?$(C>8(B . ?\xC500) ; HANGUL SYLLABLE SSANGSIOS-EU-MIEUM
     (?$(C>9(B . ?\xC501) ; HANGUL SYLLABLE SSANGSIOS-EU-PIEUP
     (?$(C>:(B . ?\xC50C) ; HANGUL SYLLABLE SSANGSIOS-YI
     (?$(C>;(B . ?\xC510) ; HANGUL SYLLABLE SSANGSIOS-YI-NIEUN
     (?$(C><(B . ?\xC514) ; HANGUL SYLLABLE SSANGSIOS-YI-RIEUL
     (?$(C>=(B . ?\xC51C) ; HANGUL SYLLABLE SSANGSIOS-YI-MIEUM
     (?$(C>>(B . ?\xC528) ; HANGUL SYLLABLE SSANGSIOS-I
     (?$(C>?(B . ?\xC529) ; HANGUL SYLLABLE SSANGSIOS-I-KIYEOK
     (?$(C>@(B . ?\xC52C) ; HANGUL SYLLABLE SSANGSIOS-I-NIEUN
     (?$(C>A(B . ?\xC530) ; HANGUL SYLLABLE SSANGSIOS-I-RIEUL
     (?$(C>B(B . ?\xC538) ; HANGUL SYLLABLE SSANGSIOS-I-MIEUM
     (?$(C>C(B . ?\xC539) ; HANGUL SYLLABLE SSANGSIOS-I-PIEUP
     (?$(C>D(B . ?\xC53B) ; HANGUL SYLLABLE SSANGSIOS-I-SIOS
     (?$(C>E(B . ?\xC53D) ; HANGUL SYLLABLE SSANGSIOS-I-IEUNG
     (?$(C>F(B . ?\xC544) ; HANGUL SYLLABLE IEUNG-A
     (?$(C>G(B . ?\xC545) ; HANGUL SYLLABLE IEUNG-A-KIYEOK
     (?$(C>H(B . ?\xC548) ; HANGUL SYLLABLE IEUNG-A-NIEUN
     (?$(C>I(B . ?\xC549) ; HANGUL SYLLABLE IEUNG-A-NIEUNCIEUC
     (?$(C>J(B . ?\xC54A) ; HANGUL SYLLABLE IEUNG-A-NIEUNHIEUH
     (?$(C>K(B . ?\xC54C) ; HANGUL SYLLABLE IEUNG-A-RIEUL
     (?$(C>L(B . ?\xC54D) ; HANGUL SYLLABLE IEUNG-A-RIEULKIYEOK
     (?$(C>M(B . ?\xC54E) ; HANGUL SYLLABLE IEUNG-A-RIEULMIEUM
     (?$(C>N(B . ?\xC553) ; HANGUL SYLLABLE IEUNG-A-RIEULHIEUH
     (?$(C>O(B . ?\xC554) ; HANGUL SYLLABLE IEUNG-A-MIEUM
     (?$(C>P(B . ?\xC555) ; HANGUL SYLLABLE IEUNG-A-PIEUP
     (?$(C>Q(B . ?\xC557) ; HANGUL SYLLABLE IEUNG-A-SIOS
     (?$(C>R(B . ?\xC558) ; HANGUL SYLLABLE IEUNG-A-SSANGSIOS
     (?$(C>S(B . ?\xC559) ; HANGUL SYLLABLE IEUNG-A-IEUNG
     (?$(C>T(B . ?\xC55D) ; HANGUL SYLLABLE IEUNG-A-THIEUTH
     (?$(C>U(B . ?\xC55E) ; HANGUL SYLLABLE IEUNG-A-PHIEUPH
     (?$(C>V(B . ?\xC560) ; HANGUL SYLLABLE IEUNG-AE
     (?$(C>W(B . ?\xC561) ; HANGUL SYLLABLE IEUNG-AE-KIYEOK
     (?$(C>X(B . ?\xC564) ; HANGUL SYLLABLE IEUNG-AE-NIEUN
     (?$(C>Y(B . ?\xC568) ; HANGUL SYLLABLE IEUNG-AE-RIEUL
     (?$(C>Z(B . ?\xC570) ; HANGUL SYLLABLE IEUNG-AE-MIEUM
     (?$(C>[(B . ?\xC571) ; HANGUL SYLLABLE IEUNG-AE-PIEUP
     (?$(C>\(B . ?\xC573) ; HANGUL SYLLABLE IEUNG-AE-SIOS
     (?$(C>](B . ?\xC574) ; HANGUL SYLLABLE IEUNG-AE-SSANGSIOS
     (?$(C>^(B . ?\xC575) ; HANGUL SYLLABLE IEUNG-AE-IEUNG
     (?$(C>_(B . ?\xC57C) ; HANGUL SYLLABLE IEUNG-YA
     (?$(C>`(B . ?\xC57D) ; HANGUL SYLLABLE IEUNG-YA-KIYEOK
     (?$(C>a(B . ?\xC580) ; HANGUL SYLLABLE IEUNG-YA-NIEUN
     (?$(C>b(B . ?\xC584) ; HANGUL SYLLABLE IEUNG-YA-RIEUL
     (?$(C>c(B . ?\xC587) ; HANGUL SYLLABLE IEUNG-YA-RIEULPIEUP
     (?$(C>d(B . ?\xC58C) ; HANGUL SYLLABLE IEUNG-YA-MIEUM
     (?$(C>e(B . ?\xC58D) ; HANGUL SYLLABLE IEUNG-YA-PIEUP
     (?$(C>f(B . ?\xC58F) ; HANGUL SYLLABLE IEUNG-YA-SIOS
     (?$(C>g(B . ?\xC591) ; HANGUL SYLLABLE IEUNG-YA-IEUNG
     (?$(C>h(B . ?\xC595) ; HANGUL SYLLABLE IEUNG-YA-THIEUTH
     (?$(C>i(B . ?\xC597) ; HANGUL SYLLABLE IEUNG-YA-HIEUH
     (?$(C>j(B . ?\xC598) ; HANGUL SYLLABLE IEUNG-YAE
     (?$(C>k(B . ?\xC59C) ; HANGUL SYLLABLE IEUNG-YAE-NIEUN
     (?$(C>l(B . ?\xC5A0) ; HANGUL SYLLABLE IEUNG-YAE-RIEUL
     (?$(C>m(B . ?\xC5A9) ; HANGUL SYLLABLE IEUNG-YAE-PIEUP
     (?$(C>n(B . ?\xC5B4) ; HANGUL SYLLABLE IEUNG-EO
     (?$(C>o(B . ?\xC5B5) ; HANGUL SYLLABLE IEUNG-EO-KIYEOK
     (?$(C>p(B . ?\xC5B8) ; HANGUL SYLLABLE IEUNG-EO-NIEUN
     (?$(C>q(B . ?\xC5B9) ; HANGUL SYLLABLE IEUNG-EO-NIEUNCIEUC
     (?$(C>r(B . ?\xC5BB) ; HANGUL SYLLABLE IEUNG-EO-TIKEUT
     (?$(C>s(B . ?\xC5BC) ; HANGUL SYLLABLE IEUNG-EO-RIEUL
     (?$(C>t(B . ?\xC5BD) ; HANGUL SYLLABLE IEUNG-EO-RIEULKIYEOK
     (?$(C>u(B . ?\xC5BE) ; HANGUL SYLLABLE IEUNG-EO-RIEULMIEUM
     (?$(C>v(B . ?\xC5C4) ; HANGUL SYLLABLE IEUNG-EO-MIEUM
     (?$(C>w(B . ?\xC5C5) ; HANGUL SYLLABLE IEUNG-EO-PIEUP
     (?$(C>x(B . ?\xC5C6) ; HANGUL SYLLABLE IEUNG-EO-PIEUPSIOS
     (?$(C>y(B . ?\xC5C7) ; HANGUL SYLLABLE IEUNG-EO-SIOS
     (?$(C>z(B . ?\xC5C8) ; HANGUL SYLLABLE IEUNG-EO-SSANGSIOS
     (?$(C>{(B . ?\xC5C9) ; HANGUL SYLLABLE IEUNG-EO-IEUNG
     (?$(C>|(B . ?\xC5CA) ; HANGUL SYLLABLE IEUNG-EO-CIEUC
     (?$(C>}(B . ?\xC5CC) ; HANGUL SYLLABLE IEUNG-EO-KHIEUKH
     (?$(C>~(B . ?\xC5CE) ; HANGUL SYLLABLE IEUNG-EO-PHIEUPH
     (?$(C?!(B . ?\xC5D0) ; HANGUL SYLLABLE IEUNG-E
     (?$(C?"(B . ?\xC5D1) ; HANGUL SYLLABLE IEUNG-E-KIYEOK
     (?$(C?#(B . ?\xC5D4) ; HANGUL SYLLABLE IEUNG-E-NIEUN
     (?$(C?$(B . ?\xC5D8) ; HANGUL SYLLABLE IEUNG-E-RIEUL
     (?$(C?%(B . ?\xC5E0) ; HANGUL SYLLABLE IEUNG-E-MIEUM
     (?$(C?&(B . ?\xC5E1) ; HANGUL SYLLABLE IEUNG-E-PIEUP
     (?$(C?'(B . ?\xC5E3) ; HANGUL SYLLABLE IEUNG-E-SIOS
     (?$(C?((B . ?\xC5E5) ; HANGUL SYLLABLE IEUNG-E-IEUNG
     (?$(C?)(B . ?\xC5EC) ; HANGUL SYLLABLE IEUNG-YEO
     (?$(C?*(B . ?\xC5ED) ; HANGUL SYLLABLE IEUNG-YEO-KIYEOK
     (?$(C?+(B . ?\xC5EE) ; HANGUL SYLLABLE IEUNG-YEO-SSANGKIYEOK
     (?$(C?,(B . ?\xC5F0) ; HANGUL SYLLABLE IEUNG-YEO-NIEUN
     (?$(C?-(B . ?\xC5F4) ; HANGUL SYLLABLE IEUNG-YEO-RIEUL
     (?$(C?.(B . ?\xC5F6) ; HANGUL SYLLABLE IEUNG-YEO-RIEULMIEUM
     (?$(C?/(B . ?\xC5F7) ; HANGUL SYLLABLE IEUNG-YEO-RIEULPIEUP
     (?$(C?0(B . ?\xC5FC) ; HANGUL SYLLABLE IEUNG-YEO-MIEUM
     (?$(C?1(B . ?\xC5FD) ; HANGUL SYLLABLE IEUNG-YEO-PIEUP
     (?$(C?2(B . ?\xC5FE) ; HANGUL SYLLABLE IEUNG-YEO-PIEUPSIOS
     (?$(C?3(B . ?\xC5FF) ; HANGUL SYLLABLE IEUNG-YEO-SIOS
     (?$(C?4(B . ?\xC600) ; HANGUL SYLLABLE IEUNG-YEO-SSANGSIOS
     (?$(C?5(B . ?\xC601) ; HANGUL SYLLABLE IEUNG-YEO-IEUNG
     (?$(C?6(B . ?\xC605) ; HANGUL SYLLABLE IEUNG-YEO-THIEUTH
     (?$(C?7(B . ?\xC606) ; HANGUL SYLLABLE IEUNG-YEO-PHIEUPH
     (?$(C?8(B . ?\xC607) ; HANGUL SYLLABLE IEUNG-YEO-HIEUH
     (?$(C?9(B . ?\xC608) ; HANGUL SYLLABLE IEUNG-YE
     (?$(C?:(B . ?\xC60C) ; HANGUL SYLLABLE IEUNG-YE-NIEUN
     (?$(C?;(B . ?\xC610) ; HANGUL SYLLABLE IEUNG-YE-RIEUL
     (?$(C?<(B . ?\xC618) ; HANGUL SYLLABLE IEUNG-YE-MIEUM
     (?$(C?=(B . ?\xC619) ; HANGUL SYLLABLE IEUNG-YE-PIEUP
     (?$(C?>(B . ?\xC61B) ; HANGUL SYLLABLE IEUNG-YE-SIOS
     (?$(C??(B . ?\xC61C) ; HANGUL SYLLABLE IEUNG-YE-SSANGSIOS
     (?$(C?@(B . ?\xC624) ; HANGUL SYLLABLE IEUNG-O
     (?$(C?A(B . ?\xC625) ; HANGUL SYLLABLE IEUNG-O-KIYEOK
     (?$(C?B(B . ?\xC628) ; HANGUL SYLLABLE IEUNG-O-NIEUN
     (?$(C?C(B . ?\xC62C) ; HANGUL SYLLABLE IEUNG-O-RIEUL
     (?$(C?D(B . ?\xC62D) ; HANGUL SYLLABLE IEUNG-O-RIEULKIYEOK
     (?$(C?E(B . ?\xC62E) ; HANGUL SYLLABLE IEUNG-O-RIEULMIEUM
     (?$(C?F(B . ?\xC630) ; HANGUL SYLLABLE IEUNG-O-RIEULSIOS
     (?$(C?G(B . ?\xC633) ; HANGUL SYLLABLE IEUNG-O-RIEULHIEUH
     (?$(C?H(B . ?\xC634) ; HANGUL SYLLABLE IEUNG-O-MIEUM
     (?$(C?I(B . ?\xC635) ; HANGUL SYLLABLE IEUNG-O-PIEUP
     (?$(C?J(B . ?\xC637) ; HANGUL SYLLABLE IEUNG-O-SIOS
     (?$(C?K(B . ?\xC639) ; HANGUL SYLLABLE IEUNG-O-IEUNG
     (?$(C?L(B . ?\xC63B) ; HANGUL SYLLABLE IEUNG-O-CHIEUCH
     (?$(C?M(B . ?\xC640) ; HANGUL SYLLABLE IEUNG-WA
     (?$(C?N(B . ?\xC641) ; HANGUL SYLLABLE IEUNG-WA-KIYEOK
     (?$(C?O(B . ?\xC644) ; HANGUL SYLLABLE IEUNG-WA-NIEUN
     (?$(C?P(B . ?\xC648) ; HANGUL SYLLABLE IEUNG-WA-RIEUL
     (?$(C?Q(B . ?\xC650) ; HANGUL SYLLABLE IEUNG-WA-MIEUM
     (?$(C?R(B . ?\xC651) ; HANGUL SYLLABLE IEUNG-WA-PIEUP
     (?$(C?S(B . ?\xC653) ; HANGUL SYLLABLE IEUNG-WA-SIOS
     (?$(C?T(B . ?\xC654) ; HANGUL SYLLABLE IEUNG-WA-SSANGSIOS
     (?$(C?U(B . ?\xC655) ; HANGUL SYLLABLE IEUNG-WA-IEUNG
     (?$(C?V(B . ?\xC65C) ; HANGUL SYLLABLE IEUNG-WAE
     (?$(C?W(B . ?\xC65D) ; HANGUL SYLLABLE IEUNG-WAE-KIYEOK
     (?$(C?X(B . ?\xC660) ; HANGUL SYLLABLE IEUNG-WAE-NIEUN
     (?$(C?Y(B . ?\xC66C) ; HANGUL SYLLABLE IEUNG-WAE-MIEUM
     (?$(C?Z(B . ?\xC66F) ; HANGUL SYLLABLE IEUNG-WAE-SIOS
     (?$(C?[(B . ?\xC671) ; HANGUL SYLLABLE IEUNG-WAE-IEUNG
     (?$(C?\(B . ?\xC678) ; HANGUL SYLLABLE IEUNG-OE
     (?$(C?](B . ?\xC679) ; HANGUL SYLLABLE IEUNG-OE-KIYEOK
     (?$(C?^(B . ?\xC67C) ; HANGUL SYLLABLE IEUNG-OE-NIEUN
     (?$(C?_(B . ?\xC680) ; HANGUL SYLLABLE IEUNG-OE-RIEUL
     (?$(C?`(B . ?\xC688) ; HANGUL SYLLABLE IEUNG-OE-MIEUM
     (?$(C?a(B . ?\xC689) ; HANGUL SYLLABLE IEUNG-OE-PIEUP
     (?$(C?b(B . ?\xC68B) ; HANGUL SYLLABLE IEUNG-OE-SIOS
     (?$(C?c(B . ?\xC68D) ; HANGUL SYLLABLE IEUNG-OE-IEUNG
     (?$(C?d(B . ?\xC694) ; HANGUL SYLLABLE IEUNG-YO
     (?$(C?e(B . ?\xC695) ; HANGUL SYLLABLE IEUNG-YO-KIYEOK
     (?$(C?f(B . ?\xC698) ; HANGUL SYLLABLE IEUNG-YO-NIEUN
     (?$(C?g(B . ?\xC69C) ; HANGUL SYLLABLE IEUNG-YO-RIEUL
     (?$(C?h(B . ?\xC6A4) ; HANGUL SYLLABLE IEUNG-YO-MIEUM
     (?$(C?i(B . ?\xC6A5) ; HANGUL SYLLABLE IEUNG-YO-PIEUP
     (?$(C?j(B . ?\xC6A7) ; HANGUL SYLLABLE IEUNG-YO-SIOS
     (?$(C?k(B . ?\xC6A9) ; HANGUL SYLLABLE IEUNG-YO-IEUNG
     (?$(C?l(B . ?\xC6B0) ; HANGUL SYLLABLE IEUNG-U
     (?$(C?m(B . ?\xC6B1) ; HANGUL SYLLABLE IEUNG-U-KIYEOK
     (?$(C?n(B . ?\xC6B4) ; HANGUL SYLLABLE IEUNG-U-NIEUN
     (?$(C?o(B . ?\xC6B8) ; HANGUL SYLLABLE IEUNG-U-RIEUL
     (?$(C?p(B . ?\xC6B9) ; HANGUL SYLLABLE IEUNG-U-RIEULKIYEOK
     (?$(C?q(B . ?\xC6BA) ; HANGUL SYLLABLE IEUNG-U-RIEULMIEUM
     (?$(C?r(B . ?\xC6C0) ; HANGUL SYLLABLE IEUNG-U-MIEUM
     (?$(C?s(B . ?\xC6C1) ; HANGUL SYLLABLE IEUNG-U-PIEUP
     (?$(C?t(B . ?\xC6C3) ; HANGUL SYLLABLE IEUNG-U-SIOS
     (?$(C?u(B . ?\xC6C5) ; HANGUL SYLLABLE IEUNG-U-IEUNG
     (?$(C?v(B . ?\xC6CC) ; HANGUL SYLLABLE IEUNG-WEO
     (?$(C?w(B . ?\xC6CD) ; HANGUL SYLLABLE IEUNG-WEO-KIYEOK
     (?$(C?x(B . ?\xC6D0) ; HANGUL SYLLABLE IEUNG-WEO-NIEUN
     (?$(C?y(B . ?\xC6D4) ; HANGUL SYLLABLE IEUNG-WEO-RIEUL
     (?$(C?z(B . ?\xC6DC) ; HANGUL SYLLABLE IEUNG-WEO-MIEUM
     (?$(C?{(B . ?\xC6DD) ; HANGUL SYLLABLE IEUNG-WEO-PIEUP
     (?$(C?|(B . ?\xC6E0) ; HANGUL SYLLABLE IEUNG-WEO-SSANGSIOS
     (?$(C?}(B . ?\xC6E1) ; HANGUL SYLLABLE IEUNG-WEO-IEUNG
     (?$(C?~(B . ?\xC6E8) ; HANGUL SYLLABLE IEUNG-WE
     (?$(C@!(B . ?\xC6E9) ; HANGUL SYLLABLE IEUNG-WE-KIYEOK
     (?$(C@"(B . ?\xC6EC) ; HANGUL SYLLABLE IEUNG-WE-NIEUN
     (?$(C@#(B . ?\xC6F0) ; HANGUL SYLLABLE IEUNG-WE-RIEUL
     (?$(C@$(B . ?\xC6F8) ; HANGUL SYLLABLE IEUNG-WE-MIEUM
     (?$(C@%(B . ?\xC6F9) ; HANGUL SYLLABLE IEUNG-WE-PIEUP
     (?$(C@&(B . ?\xC6FD) ; HANGUL SYLLABLE IEUNG-WE-IEUNG
     (?$(C@'(B . ?\xC704) ; HANGUL SYLLABLE IEUNG-WI
     (?$(C@((B . ?\xC705) ; HANGUL SYLLABLE IEUNG-WI-KIYEOK
     (?$(C@)(B . ?\xC708) ; HANGUL SYLLABLE IEUNG-WI-NIEUN
     (?$(C@*(B . ?\xC70C) ; HANGUL SYLLABLE IEUNG-WI-RIEUL
     (?$(C@+(B . ?\xC714) ; HANGUL SYLLABLE IEUNG-WI-MIEUM
     (?$(C@,(B . ?\xC715) ; HANGUL SYLLABLE IEUNG-WI-PIEUP
     (?$(C@-(B . ?\xC717) ; HANGUL SYLLABLE IEUNG-WI-SIOS
     (?$(C@.(B . ?\xC719) ; HANGUL SYLLABLE IEUNG-WI-IEUNG
     (?$(C@/(B . ?\xC720) ; HANGUL SYLLABLE IEUNG-YU
     (?$(C@0(B . ?\xC721) ; HANGUL SYLLABLE IEUNG-YU-KIYEOK
     (?$(C@1(B . ?\xC724) ; HANGUL SYLLABLE IEUNG-YU-NIEUN
     (?$(C@2(B . ?\xC728) ; HANGUL SYLLABLE IEUNG-YU-RIEUL
     (?$(C@3(B . ?\xC730) ; HANGUL SYLLABLE IEUNG-YU-MIEUM
     (?$(C@4(B . ?\xC731) ; HANGUL SYLLABLE IEUNG-YU-PIEUP
     (?$(C@5(B . ?\xC733) ; HANGUL SYLLABLE IEUNG-YU-SIOS
     (?$(C@6(B . ?\xC735) ; HANGUL SYLLABLE IEUNG-YU-IEUNG
     (?$(C@7(B . ?\xC737) ; HANGUL SYLLABLE IEUNG-YU-CHIEUCH
     (?$(C@8(B . ?\xC73C) ; HANGUL SYLLABLE IEUNG-EU
     (?$(C@9(B . ?\xC73D) ; HANGUL SYLLABLE IEUNG-EU-KIYEOK
     (?$(C@:(B . ?\xC740) ; HANGUL SYLLABLE IEUNG-EU-NIEUN
     (?$(C@;(B . ?\xC744) ; HANGUL SYLLABLE IEUNG-EU-RIEUL
     (?$(C@<(B . ?\xC74A) ; HANGUL SYLLABLE IEUNG-EU-RIEULPHIEUPH
     (?$(C@=(B . ?\xC74C) ; HANGUL SYLLABLE IEUNG-EU-MIEUM
     (?$(C@>(B . ?\xC74D) ; HANGUL SYLLABLE IEUNG-EU-PIEUP
     (?$(C@?(B . ?\xC74F) ; HANGUL SYLLABLE IEUNG-EU-SIOS
     (?$(C@@(B . ?\xC751) ; HANGUL SYLLABLE IEUNG-EU-IEUNG
     (?$(C@A(B . ?\xC752) ; HANGUL SYLLABLE IEUNG-EU-CIEUC
     (?$(C@B(B . ?\xC753) ; HANGUL SYLLABLE IEUNG-EU-CHIEUCH
     (?$(C@C(B . ?\xC754) ; HANGUL SYLLABLE IEUNG-EU-KHIEUKH
     (?$(C@D(B . ?\xC755) ; HANGUL SYLLABLE IEUNG-EU-THIEUTH
     (?$(C@E(B . ?\xC756) ; HANGUL SYLLABLE IEUNG-EU-PHIEUPH
     (?$(C@F(B . ?\xC757) ; HANGUL SYLLABLE IEUNG-EU-HIEUH
     (?$(C@G(B . ?\xC758) ; HANGUL SYLLABLE IEUNG-YI
     (?$(C@H(B . ?\xC75C) ; HANGUL SYLLABLE IEUNG-YI-NIEUN
     (?$(C@I(B . ?\xC760) ; HANGUL SYLLABLE IEUNG-YI-RIEUL
     (?$(C@J(B . ?\xC768) ; HANGUL SYLLABLE IEUNG-YI-MIEUM
     (?$(C@K(B . ?\xC76B) ; HANGUL SYLLABLE IEUNG-YI-SIOS
     (?$(C@L(B . ?\xC774) ; HANGUL SYLLABLE IEUNG-I
     (?$(C@M(B . ?\xC775) ; HANGUL SYLLABLE IEUNG-I-KIYEOK
     (?$(C@N(B . ?\xC778) ; HANGUL SYLLABLE IEUNG-I-NIEUN
     (?$(C@O(B . ?\xC77C) ; HANGUL SYLLABLE IEUNG-I-RIEUL
     (?$(C@P(B . ?\xC77D) ; HANGUL SYLLABLE IEUNG-I-RIEULKIYEOK
     (?$(C@Q(B . ?\xC77E) ; HANGUL SYLLABLE IEUNG-I-RIEULMIEUM
     (?$(C@R(B . ?\xC783) ; HANGUL SYLLABLE IEUNG-I-RIEULHIEUH
     (?$(C@S(B . ?\xC784) ; HANGUL SYLLABLE IEUNG-I-MIEUM
     (?$(C@T(B . ?\xC785) ; HANGUL SYLLABLE IEUNG-I-PIEUP
     (?$(C@U(B . ?\xC787) ; HANGUL SYLLABLE IEUNG-I-SIOS
     (?$(C@V(B . ?\xC788) ; HANGUL SYLLABLE IEUNG-I-SSANGSIOS
     (?$(C@W(B . ?\xC789) ; HANGUL SYLLABLE IEUNG-I-IEUNG
     (?$(C@X(B . ?\xC78A) ; HANGUL SYLLABLE IEUNG-I-CIEUC
     (?$(C@Y(B . ?\xC78E) ; HANGUL SYLLABLE IEUNG-I-PHIEUPH
     (?$(C@Z(B . ?\xC790) ; HANGUL SYLLABLE CIEUC-A
     (?$(C@[(B . ?\xC791) ; HANGUL SYLLABLE CIEUC-A-KIYEOK
     (?$(C@\(B . ?\xC794) ; HANGUL SYLLABLE CIEUC-A-NIEUN
     (?$(C@](B . ?\xC796) ; HANGUL SYLLABLE CIEUC-A-NIEUNHIEUH
     (?$(C@^(B . ?\xC797) ; HANGUL SYLLABLE CIEUC-A-TIKEUT
     (?$(C@_(B . ?\xC798) ; HANGUL SYLLABLE CIEUC-A-RIEUL
     (?$(C@`(B . ?\xC79A) ; HANGUL SYLLABLE CIEUC-A-RIEULMIEUM
     (?$(C@a(B . ?\xC7A0) ; HANGUL SYLLABLE CIEUC-A-MIEUM
     (?$(C@b(B . ?\xC7A1) ; HANGUL SYLLABLE CIEUC-A-PIEUP
     (?$(C@c(B . ?\xC7A3) ; HANGUL SYLLABLE CIEUC-A-SIOS
     (?$(C@d(B . ?\xC7A4) ; HANGUL SYLLABLE CIEUC-A-SSANGSIOS
     (?$(C@e(B . ?\xC7A5) ; HANGUL SYLLABLE CIEUC-A-IEUNG
     (?$(C@f(B . ?\xC7A6) ; HANGUL SYLLABLE CIEUC-A-CIEUC
     (?$(C@g(B . ?\xC7AC) ; HANGUL SYLLABLE CIEUC-AE
     (?$(C@h(B . ?\xC7AD) ; HANGUL SYLLABLE CIEUC-AE-KIYEOK
     (?$(C@i(B . ?\xC7B0) ; HANGUL SYLLABLE CIEUC-AE-NIEUN
     (?$(C@j(B . ?\xC7B4) ; HANGUL SYLLABLE CIEUC-AE-RIEUL
     (?$(C@k(B . ?\xC7BC) ; HANGUL SYLLABLE CIEUC-AE-MIEUM
     (?$(C@l(B . ?\xC7BD) ; HANGUL SYLLABLE CIEUC-AE-PIEUP
     (?$(C@m(B . ?\xC7BF) ; HANGUL SYLLABLE CIEUC-AE-SIOS
     (?$(C@n(B . ?\xC7C0) ; HANGUL SYLLABLE CIEUC-AE-SSANGSIOS
     (?$(C@o(B . ?\xC7C1) ; HANGUL SYLLABLE CIEUC-AE-IEUNG
     (?$(C@p(B . ?\xC7C8) ; HANGUL SYLLABLE CIEUC-YA
     (?$(C@q(B . ?\xC7C9) ; HANGUL SYLLABLE CIEUC-YA-KIYEOK
     (?$(C@r(B . ?\xC7CC) ; HANGUL SYLLABLE CIEUC-YA-NIEUN
     (?$(C@s(B . ?\xC7CE) ; HANGUL SYLLABLE CIEUC-YA-NIEUNHIEUH
     (?$(C@t(B . ?\xC7D0) ; HANGUL SYLLABLE CIEUC-YA-RIEUL
     (?$(C@u(B . ?\xC7D8) ; HANGUL SYLLABLE CIEUC-YA-MIEUM
     (?$(C@v(B . ?\xC7DD) ; HANGUL SYLLABLE CIEUC-YA-IEUNG
     (?$(C@w(B . ?\xC7E4) ; HANGUL SYLLABLE CIEUC-YAE
     (?$(C@x(B . ?\xC7E8) ; HANGUL SYLLABLE CIEUC-YAE-NIEUN
     (?$(C@y(B . ?\xC7EC) ; HANGUL SYLLABLE CIEUC-YAE-RIEUL
     (?$(C@z(B . ?\xC800) ; HANGUL SYLLABLE CIEUC-EO
     (?$(C@{(B . ?\xC801) ; HANGUL SYLLABLE CIEUC-EO-KIYEOK
     (?$(C@|(B . ?\xC804) ; HANGUL SYLLABLE CIEUC-EO-NIEUN
     (?$(C@}(B . ?\xC808) ; HANGUL SYLLABLE CIEUC-EO-RIEUL
     (?$(C@~(B . ?\xC80A) ; HANGUL SYLLABLE CIEUC-EO-RIEULMIEUM
     (?$(CA!(B . ?\xC810) ; HANGUL SYLLABLE CIEUC-EO-MIEUM
     (?$(CA"(B . ?\xC811) ; HANGUL SYLLABLE CIEUC-EO-PIEUP
     (?$(CA#(B . ?\xC813) ; HANGUL SYLLABLE CIEUC-EO-SIOS
     (?$(CA$(B . ?\xC815) ; HANGUL SYLLABLE CIEUC-EO-IEUNG
     (?$(CA%(B . ?\xC816) ; HANGUL SYLLABLE CIEUC-EO-CIEUC
     (?$(CA&(B . ?\xC81C) ; HANGUL SYLLABLE CIEUC-E
     (?$(CA'(B . ?\xC81D) ; HANGUL SYLLABLE CIEUC-E-KIYEOK
     (?$(CA((B . ?\xC820) ; HANGUL SYLLABLE CIEUC-E-NIEUN
     (?$(CA)(B . ?\xC824) ; HANGUL SYLLABLE CIEUC-E-RIEUL
     (?$(CA*(B . ?\xC82C) ; HANGUL SYLLABLE CIEUC-E-MIEUM
     (?$(CA+(B . ?\xC82D) ; HANGUL SYLLABLE CIEUC-E-PIEUP
     (?$(CA,(B . ?\xC82F) ; HANGUL SYLLABLE CIEUC-E-SIOS
     (?$(CA-(B . ?\xC831) ; HANGUL SYLLABLE CIEUC-E-IEUNG
     (?$(CA.(B . ?\xC838) ; HANGUL SYLLABLE CIEUC-YEO
     (?$(CA/(B . ?\xC83C) ; HANGUL SYLLABLE CIEUC-YEO-NIEUN
     (?$(CA0(B . ?\xC840) ; HANGUL SYLLABLE CIEUC-YEO-RIEUL
     (?$(CA1(B . ?\xC848) ; HANGUL SYLLABLE CIEUC-YEO-MIEUM
     (?$(CA2(B . ?\xC849) ; HANGUL SYLLABLE CIEUC-YEO-PIEUP
     (?$(CA3(B . ?\xC84C) ; HANGUL SYLLABLE CIEUC-YEO-SSANGSIOS
     (?$(CA4(B . ?\xC84D) ; HANGUL SYLLABLE CIEUC-YEO-IEUNG
     (?$(CA5(B . ?\xC854) ; HANGUL SYLLABLE CIEUC-YE
     (?$(CA6(B . ?\xC870) ; HANGUL SYLLABLE CIEUC-O
     (?$(CA7(B . ?\xC871) ; HANGUL SYLLABLE CIEUC-O-KIYEOK
     (?$(CA8(B . ?\xC874) ; HANGUL SYLLABLE CIEUC-O-NIEUN
     (?$(CA9(B . ?\xC878) ; HANGUL SYLLABLE CIEUC-O-RIEUL
     (?$(CA:(B . ?\xC87A) ; HANGUL SYLLABLE CIEUC-O-RIEULMIEUM
     (?$(CA;(B . ?\xC880) ; HANGUL SYLLABLE CIEUC-O-MIEUM
     (?$(CA<(B . ?\xC881) ; HANGUL SYLLABLE CIEUC-O-PIEUP
     (?$(CA=(B . ?\xC883) ; HANGUL SYLLABLE CIEUC-O-SIOS
     (?$(CA>(B . ?\xC885) ; HANGUL SYLLABLE CIEUC-O-IEUNG
     (?$(CA?(B . ?\xC886) ; HANGUL SYLLABLE CIEUC-O-CIEUC
     (?$(CA@(B . ?\xC887) ; HANGUL SYLLABLE CIEUC-O-CHIEUCH
     (?$(CAA(B . ?\xC88B) ; HANGUL SYLLABLE CIEUC-O-HIEUH
     (?$(CAB(B . ?\xC88C) ; HANGUL SYLLABLE CIEUC-WA
     (?$(CAC(B . ?\xC88D) ; HANGUL SYLLABLE CIEUC-WA-KIYEOK
     (?$(CAD(B . ?\xC894) ; HANGUL SYLLABLE CIEUC-WA-RIEUL
     (?$(CAE(B . ?\xC89D) ; HANGUL SYLLABLE CIEUC-WA-PIEUP
     (?$(CAF(B . ?\xC89F) ; HANGUL SYLLABLE CIEUC-WA-SIOS
     (?$(CAG(B . ?\xC8A1) ; HANGUL SYLLABLE CIEUC-WA-IEUNG
     (?$(CAH(B . ?\xC8A8) ; HANGUL SYLLABLE CIEUC-WAE
     (?$(CAI(B . ?\xC8BC) ; HANGUL SYLLABLE CIEUC-WAE-SSANGSIOS
     (?$(CAJ(B . ?\xC8BD) ; HANGUL SYLLABLE CIEUC-WAE-IEUNG
     (?$(CAK(B . ?\xC8C4) ; HANGUL SYLLABLE CIEUC-OE
     (?$(CAL(B . ?\xC8C8) ; HANGUL SYLLABLE CIEUC-OE-NIEUN
     (?$(CAM(B . ?\xC8CC) ; HANGUL SYLLABLE CIEUC-OE-RIEUL
     (?$(CAN(B . ?\xC8D4) ; HANGUL SYLLABLE CIEUC-OE-MIEUM
     (?$(CAO(B . ?\xC8D5) ; HANGUL SYLLABLE CIEUC-OE-PIEUP
     (?$(CAP(B . ?\xC8D7) ; HANGUL SYLLABLE CIEUC-OE-SIOS
     (?$(CAQ(B . ?\xC8D9) ; HANGUL SYLLABLE CIEUC-OE-IEUNG
     (?$(CAR(B . ?\xC8E0) ; HANGUL SYLLABLE CIEUC-YO
     (?$(CAS(B . ?\xC8E1) ; HANGUL SYLLABLE CIEUC-YO-KIYEOK
     (?$(CAT(B . ?\xC8E4) ; HANGUL SYLLABLE CIEUC-YO-NIEUN
     (?$(CAU(B . ?\xC8F5) ; HANGUL SYLLABLE CIEUC-YO-IEUNG
     (?$(CAV(B . ?\xC8FC) ; HANGUL SYLLABLE CIEUC-U
     (?$(CAW(B . ?\xC8FD) ; HANGUL SYLLABLE CIEUC-U-KIYEOK
     (?$(CAX(B . ?\xC900) ; HANGUL SYLLABLE CIEUC-U-NIEUN
     (?$(CAY(B . ?\xC904) ; HANGUL SYLLABLE CIEUC-U-RIEUL
     (?$(CAZ(B . ?\xC905) ; HANGUL SYLLABLE CIEUC-U-RIEULKIYEOK
     (?$(CA[(B . ?\xC906) ; HANGUL SYLLABLE CIEUC-U-RIEULMIEUM
     (?$(CA\(B . ?\xC90C) ; HANGUL SYLLABLE CIEUC-U-MIEUM
     (?$(CA](B . ?\xC90D) ; HANGUL SYLLABLE CIEUC-U-PIEUP
     (?$(CA^(B . ?\xC90F) ; HANGUL SYLLABLE CIEUC-U-SIOS
     (?$(CA_(B . ?\xC911) ; HANGUL SYLLABLE CIEUC-U-IEUNG
     (?$(CA`(B . ?\xC918) ; HANGUL SYLLABLE CIEUC-WEO
     (?$(CAa(B . ?\xC92C) ; HANGUL SYLLABLE CIEUC-WEO-SSANGSIOS
     (?$(CAb(B . ?\xC934) ; HANGUL SYLLABLE CIEUC-WE
     (?$(CAc(B . ?\xC950) ; HANGUL SYLLABLE CIEUC-WI
     (?$(CAd(B . ?\xC951) ; HANGUL SYLLABLE CIEUC-WI-KIYEOK
     (?$(CAe(B . ?\xC954) ; HANGUL SYLLABLE CIEUC-WI-NIEUN
     (?$(CAf(B . ?\xC958) ; HANGUL SYLLABLE CIEUC-WI-RIEUL
     (?$(CAg(B . ?\xC960) ; HANGUL SYLLABLE CIEUC-WI-MIEUM
     (?$(CAh(B . ?\xC961) ; HANGUL SYLLABLE CIEUC-WI-PIEUP
     (?$(CAi(B . ?\xC963) ; HANGUL SYLLABLE CIEUC-WI-SIOS
     (?$(CAj(B . ?\xC96C) ; HANGUL SYLLABLE CIEUC-YU
     (?$(CAk(B . ?\xC970) ; HANGUL SYLLABLE CIEUC-YU-NIEUN
     (?$(CAl(B . ?\xC974) ; HANGUL SYLLABLE CIEUC-YU-RIEUL
     (?$(CAm(B . ?\xC97C) ; HANGUL SYLLABLE CIEUC-YU-MIEUM
     (?$(CAn(B . ?\xC988) ; HANGUL SYLLABLE CIEUC-EU
     (?$(CAo(B . ?\xC989) ; HANGUL SYLLABLE CIEUC-EU-KIYEOK
     (?$(CAp(B . ?\xC98C) ; HANGUL SYLLABLE CIEUC-EU-NIEUN
     (?$(CAq(B . ?\xC990) ; HANGUL SYLLABLE CIEUC-EU-RIEUL
     (?$(CAr(B . ?\xC998) ; HANGUL SYLLABLE CIEUC-EU-MIEUM
     (?$(CAs(B . ?\xC999) ; HANGUL SYLLABLE CIEUC-EU-PIEUP
     (?$(CAt(B . ?\xC99B) ; HANGUL SYLLABLE CIEUC-EU-SIOS
     (?$(CAu(B . ?\xC99D) ; HANGUL SYLLABLE CIEUC-EU-IEUNG
     (?$(CAv(B . ?\xC9C0) ; HANGUL SYLLABLE CIEUC-I
     (?$(CAw(B . ?\xC9C1) ; HANGUL SYLLABLE CIEUC-I-KIYEOK
     (?$(CAx(B . ?\xC9C4) ; HANGUL SYLLABLE CIEUC-I-NIEUN
     (?$(CAy(B . ?\xC9C7) ; HANGUL SYLLABLE CIEUC-I-TIKEUT
     (?$(CAz(B . ?\xC9C8) ; HANGUL SYLLABLE CIEUC-I-RIEUL
     (?$(CA{(B . ?\xC9CA) ; HANGUL SYLLABLE CIEUC-I-RIEULMIEUM
     (?$(CA|(B . ?\xC9D0) ; HANGUL SYLLABLE CIEUC-I-MIEUM
     (?$(CA}(B . ?\xC9D1) ; HANGUL SYLLABLE CIEUC-I-PIEUP
     (?$(CA~(B . ?\xC9D3) ; HANGUL SYLLABLE CIEUC-I-SIOS
     (?$(CB!(B . ?\xC9D5) ; HANGUL SYLLABLE CIEUC-I-IEUNG
     (?$(CB"(B . ?\xC9D6) ; HANGUL SYLLABLE CIEUC-I-CIEUC
     (?$(CB#(B . ?\xC9D9) ; HANGUL SYLLABLE CIEUC-I-THIEUTH
     (?$(CB$(B . ?\xC9DA) ; HANGUL SYLLABLE CIEUC-I-PHIEUPH
     (?$(CB%(B . ?\xC9DC) ; HANGUL SYLLABLE SSANGCIEUC-A
     (?$(CB&(B . ?\xC9DD) ; HANGUL SYLLABLE SSANGCIEUC-A-KIYEOK
     (?$(CB'(B . ?\xC9E0) ; HANGUL SYLLABLE SSANGCIEUC-A-NIEUN
     (?$(CB((B . ?\xC9E2) ; HANGUL SYLLABLE SSANGCIEUC-A-NIEUNHIEUH
     (?$(CB)(B . ?\xC9E4) ; HANGUL SYLLABLE SSANGCIEUC-A-RIEUL
     (?$(CB*(B . ?\xC9E7) ; HANGUL SYLLABLE SSANGCIEUC-A-RIEULPIEUP
     (?$(CB+(B . ?\xC9EC) ; HANGUL SYLLABLE SSANGCIEUC-A-MIEUM
     (?$(CB,(B . ?\xC9ED) ; HANGUL SYLLABLE SSANGCIEUC-A-PIEUP
     (?$(CB-(B . ?\xC9EF) ; HANGUL SYLLABLE SSANGCIEUC-A-SIOS
     (?$(CB.(B . ?\xC9F0) ; HANGUL SYLLABLE SSANGCIEUC-A-SSANGSIOS
     (?$(CB/(B . ?\xC9F1) ; HANGUL SYLLABLE SSANGCIEUC-A-IEUNG
     (?$(CB0(B . ?\xC9F8) ; HANGUL SYLLABLE SSANGCIEUC-AE
     (?$(CB1(B . ?\xC9F9) ; HANGUL SYLLABLE SSANGCIEUC-AE-KIYEOK
     (?$(CB2(B . ?\xC9FC) ; HANGUL SYLLABLE SSANGCIEUC-AE-NIEUN
     (?$(CB3(B . ?\xCA00) ; HANGUL SYLLABLE SSANGCIEUC-AE-RIEUL
     (?$(CB4(B . ?\xCA08) ; HANGUL SYLLABLE SSANGCIEUC-AE-MIEUM
     (?$(CB5(B . ?\xCA09) ; HANGUL SYLLABLE SSANGCIEUC-AE-PIEUP
     (?$(CB6(B . ?\xCA0B) ; HANGUL SYLLABLE SSANGCIEUC-AE-SIOS
     (?$(CB7(B . ?\xCA0C) ; HANGUL SYLLABLE SSANGCIEUC-AE-SSANGSIOS
     (?$(CB8(B . ?\xCA0D) ; HANGUL SYLLABLE SSANGCIEUC-AE-IEUNG
     (?$(CB9(B . ?\xCA14) ; HANGUL SYLLABLE SSANGCIEUC-YA
     (?$(CB:(B . ?\xCA18) ; HANGUL SYLLABLE SSANGCIEUC-YA-NIEUN
     (?$(CB;(B . ?\xCA29) ; HANGUL SYLLABLE SSANGCIEUC-YA-IEUNG
     (?$(CB<(B . ?\xCA4C) ; HANGUL SYLLABLE SSANGCIEUC-EO
     (?$(CB=(B . ?\xCA4D) ; HANGUL SYLLABLE SSANGCIEUC-EO-KIYEOK
     (?$(CB>(B . ?\xCA50) ; HANGUL SYLLABLE SSANGCIEUC-EO-NIEUN
     (?$(CB?(B . ?\xCA54) ; HANGUL SYLLABLE SSANGCIEUC-EO-RIEUL
     (?$(CB@(B . ?\xCA5C) ; HANGUL SYLLABLE SSANGCIEUC-EO-MIEUM
     (?$(CBA(B . ?\xCA5D) ; HANGUL SYLLABLE SSANGCIEUC-EO-PIEUP
     (?$(CBB(B . ?\xCA5F) ; HANGUL SYLLABLE SSANGCIEUC-EO-SIOS
     (?$(CBC(B . ?\xCA60) ; HANGUL SYLLABLE SSANGCIEUC-EO-SSANGSIOS
     (?$(CBD(B . ?\xCA61) ; HANGUL SYLLABLE SSANGCIEUC-EO-IEUNG
     (?$(CBE(B . ?\xCA68) ; HANGUL SYLLABLE SSANGCIEUC-E
     (?$(CBF(B . ?\xCA7D) ; HANGUL SYLLABLE SSANGCIEUC-E-IEUNG
     (?$(CBG(B . ?\xCA84) ; HANGUL SYLLABLE SSANGCIEUC-YEO
     (?$(CBH(B . ?\xCA98) ; HANGUL SYLLABLE SSANGCIEUC-YEO-SSANGSIOS
     (?$(CBI(B . ?\xCABC) ; HANGUL SYLLABLE SSANGCIEUC-O
     (?$(CBJ(B . ?\xCABD) ; HANGUL SYLLABLE SSANGCIEUC-O-KIYEOK
     (?$(CBK(B . ?\xCAC0) ; HANGUL SYLLABLE SSANGCIEUC-O-NIEUN
     (?$(CBL(B . ?\xCAC4) ; HANGUL SYLLABLE SSANGCIEUC-O-RIEUL
     (?$(CBM(B . ?\xCACC) ; HANGUL SYLLABLE SSANGCIEUC-O-MIEUM
     (?$(CBN(B . ?\xCACD) ; HANGUL SYLLABLE SSANGCIEUC-O-PIEUP
     (?$(CBO(B . ?\xCACF) ; HANGUL SYLLABLE SSANGCIEUC-O-SIOS
     (?$(CBP(B . ?\xCAD1) ; HANGUL SYLLABLE SSANGCIEUC-O-IEUNG
     (?$(CBQ(B . ?\xCAD3) ; HANGUL SYLLABLE SSANGCIEUC-O-CHIEUCH
     (?$(CBR(B . ?\xCAD8) ; HANGUL SYLLABLE SSANGCIEUC-WA
     (?$(CBS(B . ?\xCAD9) ; HANGUL SYLLABLE SSANGCIEUC-WA-KIYEOK
     (?$(CBT(B . ?\xCAE0) ; HANGUL SYLLABLE SSANGCIEUC-WA-RIEUL
     (?$(CBU(B . ?\xCAEC) ; HANGUL SYLLABLE SSANGCIEUC-WA-SSANGSIOS
     (?$(CBV(B . ?\xCAF4) ; HANGUL SYLLABLE SSANGCIEUC-WAE
     (?$(CBW(B . ?\xCB08) ; HANGUL SYLLABLE SSANGCIEUC-WAE-SSANGSIOS
     (?$(CBX(B . ?\xCB10) ; HANGUL SYLLABLE SSANGCIEUC-OE
     (?$(CBY(B . ?\xCB14) ; HANGUL SYLLABLE SSANGCIEUC-OE-NIEUN
     (?$(CBZ(B . ?\xCB18) ; HANGUL SYLLABLE SSANGCIEUC-OE-RIEUL
     (?$(CB[(B . ?\xCB20) ; HANGUL SYLLABLE SSANGCIEUC-OE-MIEUM
     (?$(CB\(B . ?\xCB21) ; HANGUL SYLLABLE SSANGCIEUC-OE-PIEUP
     (?$(CB](B . ?\xCB41) ; HANGUL SYLLABLE SSANGCIEUC-YO-IEUNG
     (?$(CB^(B . ?\xCB48) ; HANGUL SYLLABLE SSANGCIEUC-U
     (?$(CB_(B . ?\xCB49) ; HANGUL SYLLABLE SSANGCIEUC-U-KIYEOK
     (?$(CB`(B . ?\xCB4C) ; HANGUL SYLLABLE SSANGCIEUC-U-NIEUN
     (?$(CBa(B . ?\xCB50) ; HANGUL SYLLABLE SSANGCIEUC-U-RIEUL
     (?$(CBb(B . ?\xCB58) ; HANGUL SYLLABLE SSANGCIEUC-U-MIEUM
     (?$(CBc(B . ?\xCB59) ; HANGUL SYLLABLE SSANGCIEUC-U-PIEUP
     (?$(CBd(B . ?\xCB5D) ; HANGUL SYLLABLE SSANGCIEUC-U-IEUNG
     (?$(CBe(B . ?\xCB64) ; HANGUL SYLLABLE SSANGCIEUC-WEO
     (?$(CBf(B . ?\xCB78) ; HANGUL SYLLABLE SSANGCIEUC-WEO-SSANGSIOS
     (?$(CBg(B . ?\xCB79) ; HANGUL SYLLABLE SSANGCIEUC-WEO-IEUNG
     (?$(CBh(B . ?\xCB9C) ; HANGUL SYLLABLE SSANGCIEUC-WI
     (?$(CBi(B . ?\xCBB8) ; HANGUL SYLLABLE SSANGCIEUC-YU
     (?$(CBj(B . ?\xCBD4) ; HANGUL SYLLABLE SSANGCIEUC-EU
     (?$(CBk(B . ?\xCBE4) ; HANGUL SYLLABLE SSANGCIEUC-EU-MIEUM
     (?$(CBl(B . ?\xCBE7) ; HANGUL SYLLABLE SSANGCIEUC-EU-SIOS
     (?$(CBm(B . ?\xCBE9) ; HANGUL SYLLABLE SSANGCIEUC-EU-IEUNG
     (?$(CBn(B . ?\xCC0C) ; HANGUL SYLLABLE SSANGCIEUC-I
     (?$(CBo(B . ?\xCC0D) ; HANGUL SYLLABLE SSANGCIEUC-I-KIYEOK
     (?$(CBp(B . ?\xCC10) ; HANGUL SYLLABLE SSANGCIEUC-I-NIEUN
     (?$(CBq(B . ?\xCC14) ; HANGUL SYLLABLE SSANGCIEUC-I-RIEUL
     (?$(CBr(B . ?\xCC1C) ; HANGUL SYLLABLE SSANGCIEUC-I-MIEUM
     (?$(CBs(B . ?\xCC1D) ; HANGUL SYLLABLE SSANGCIEUC-I-PIEUP
     (?$(CBt(B . ?\xCC21) ; HANGUL SYLLABLE SSANGCIEUC-I-IEUNG
     (?$(CBu(B . ?\xCC22) ; HANGUL SYLLABLE SSANGCIEUC-I-CIEUC
     (?$(CBv(B . ?\xCC27) ; HANGUL SYLLABLE SSANGCIEUC-I-HIEUH
     (?$(CBw(B . ?\xCC28) ; HANGUL SYLLABLE CHIEUCH-A
     (?$(CBx(B . ?\xCC29) ; HANGUL SYLLABLE CHIEUCH-A-KIYEOK
     (?$(CBy(B . ?\xCC2C) ; HANGUL SYLLABLE CHIEUCH-A-NIEUN
     (?$(CBz(B . ?\xCC2E) ; HANGUL SYLLABLE CHIEUCH-A-NIEUNHIEUH
     (?$(CB{(B . ?\xCC30) ; HANGUL SYLLABLE CHIEUCH-A-RIEUL
     (?$(CB|(B . ?\xCC38) ; HANGUL SYLLABLE CHIEUCH-A-MIEUM
     (?$(CB}(B . ?\xCC39) ; HANGUL SYLLABLE CHIEUCH-A-PIEUP
     (?$(CB~(B . ?\xCC3B) ; HANGUL SYLLABLE CHIEUCH-A-SIOS
     (?$(CC!(B . ?\xCC3C) ; HANGUL SYLLABLE CHIEUCH-A-SSANGSIOS
     (?$(CC"(B . ?\xCC3D) ; HANGUL SYLLABLE CHIEUCH-A-IEUNG
     (?$(CC#(B . ?\xCC3E) ; HANGUL SYLLABLE CHIEUCH-A-CIEUC
     (?$(CC$(B . ?\xCC44) ; HANGUL SYLLABLE CHIEUCH-AE
     (?$(CC%(B . ?\xCC45) ; HANGUL SYLLABLE CHIEUCH-AE-KIYEOK
     (?$(CC&(B . ?\xCC48) ; HANGUL SYLLABLE CHIEUCH-AE-NIEUN
     (?$(CC'(B . ?\xCC4C) ; HANGUL SYLLABLE CHIEUCH-AE-RIEUL
     (?$(CC((B . ?\xCC54) ; HANGUL SYLLABLE CHIEUCH-AE-MIEUM
     (?$(CC)(B . ?\xCC55) ; HANGUL SYLLABLE CHIEUCH-AE-PIEUP
     (?$(CC*(B . ?\xCC57) ; HANGUL SYLLABLE CHIEUCH-AE-SIOS
     (?$(CC+(B . ?\xCC58) ; HANGUL SYLLABLE CHIEUCH-AE-SSANGSIOS
     (?$(CC,(B . ?\xCC59) ; HANGUL SYLLABLE CHIEUCH-AE-IEUNG
     (?$(CC-(B . ?\xCC60) ; HANGUL SYLLABLE CHIEUCH-YA
     (?$(CC.(B . ?\xCC64) ; HANGUL SYLLABLE CHIEUCH-YA-NIEUN
     (?$(CC/(B . ?\xCC66) ; HANGUL SYLLABLE CHIEUCH-YA-NIEUNHIEUH
     (?$(CC0(B . ?\xCC68) ; HANGUL SYLLABLE CHIEUCH-YA-RIEUL
     (?$(CC1(B . ?\xCC70) ; HANGUL SYLLABLE CHIEUCH-YA-MIEUM
     (?$(CC2(B . ?\xCC75) ; HANGUL SYLLABLE CHIEUCH-YA-IEUNG
     (?$(CC3(B . ?\xCC98) ; HANGUL SYLLABLE CHIEUCH-EO
     (?$(CC4(B . ?\xCC99) ; HANGUL SYLLABLE CHIEUCH-EO-KIYEOK
     (?$(CC5(B . ?\xCC9C) ; HANGUL SYLLABLE CHIEUCH-EO-NIEUN
     (?$(CC6(B . ?\xCCA0) ; HANGUL SYLLABLE CHIEUCH-EO-RIEUL
     (?$(CC7(B . ?\xCCA8) ; HANGUL SYLLABLE CHIEUCH-EO-MIEUM
     (?$(CC8(B . ?\xCCA9) ; HANGUL SYLLABLE CHIEUCH-EO-PIEUP
     (?$(CC9(B . ?\xCCAB) ; HANGUL SYLLABLE CHIEUCH-EO-SIOS
     (?$(CC:(B . ?\xCCAC) ; HANGUL SYLLABLE CHIEUCH-EO-SSANGSIOS
     (?$(CC;(B . ?\xCCAD) ; HANGUL SYLLABLE CHIEUCH-EO-IEUNG
     (?$(CC<(B . ?\xCCB4) ; HANGUL SYLLABLE CHIEUCH-E
     (?$(CC=(B . ?\xCCB5) ; HANGUL SYLLABLE CHIEUCH-E-KIYEOK
     (?$(CC>(B . ?\xCCB8) ; HANGUL SYLLABLE CHIEUCH-E-NIEUN
     (?$(CC?(B . ?\xCCBC) ; HANGUL SYLLABLE CHIEUCH-E-RIEUL
     (?$(CC@(B . ?\xCCC4) ; HANGUL SYLLABLE CHIEUCH-E-MIEUM
     (?$(CCA(B . ?\xCCC5) ; HANGUL SYLLABLE CHIEUCH-E-PIEUP
     (?$(CCB(B . ?\xCCC7) ; HANGUL SYLLABLE CHIEUCH-E-SIOS
     (?$(CCC(B . ?\xCCC9) ; HANGUL SYLLABLE CHIEUCH-E-IEUNG
     (?$(CCD(B . ?\xCCD0) ; HANGUL SYLLABLE CHIEUCH-YEO
     (?$(CCE(B . ?\xCCD4) ; HANGUL SYLLABLE CHIEUCH-YEO-NIEUN
     (?$(CCF(B . ?\xCCE4) ; HANGUL SYLLABLE CHIEUCH-YEO-SSANGSIOS
     (?$(CCG(B . ?\xCCEC) ; HANGUL SYLLABLE CHIEUCH-YE
     (?$(CCH(B . ?\xCCF0) ; HANGUL SYLLABLE CHIEUCH-YE-NIEUN
     (?$(CCI(B . ?\xCD01) ; HANGUL SYLLABLE CHIEUCH-YE-IEUNG
     (?$(CCJ(B . ?\xCD08) ; HANGUL SYLLABLE CHIEUCH-O
     (?$(CCK(B . ?\xCD09) ; HANGUL SYLLABLE CHIEUCH-O-KIYEOK
     (?$(CCL(B . ?\xCD0C) ; HANGUL SYLLABLE CHIEUCH-O-NIEUN
     (?$(CCM(B . ?\xCD10) ; HANGUL SYLLABLE CHIEUCH-O-RIEUL
     (?$(CCN(B . ?\xCD18) ; HANGUL SYLLABLE CHIEUCH-O-MIEUM
     (?$(CCO(B . ?\xCD19) ; HANGUL SYLLABLE CHIEUCH-O-PIEUP
     (?$(CCP(B . ?\xCD1B) ; HANGUL SYLLABLE CHIEUCH-O-SIOS
     (?$(CCQ(B . ?\xCD1D) ; HANGUL SYLLABLE CHIEUCH-O-IEUNG
     (?$(CCR(B . ?\xCD24) ; HANGUL SYLLABLE CHIEUCH-WA
     (?$(CCS(B . ?\xCD28) ; HANGUL SYLLABLE CHIEUCH-WA-NIEUN
     (?$(CCT(B . ?\xCD2C) ; HANGUL SYLLABLE CHIEUCH-WA-RIEUL
     (?$(CCU(B . ?\xCD39) ; HANGUL SYLLABLE CHIEUCH-WA-IEUNG
     (?$(CCV(B . ?\xCD5C) ; HANGUL SYLLABLE CHIEUCH-OE
     (?$(CCW(B . ?\xCD60) ; HANGUL SYLLABLE CHIEUCH-OE-NIEUN
     (?$(CCX(B . ?\xCD64) ; HANGUL SYLLABLE CHIEUCH-OE-RIEUL
     (?$(CCY(B . ?\xCD6C) ; HANGUL SYLLABLE CHIEUCH-OE-MIEUM
     (?$(CCZ(B . ?\xCD6D) ; HANGUL SYLLABLE CHIEUCH-OE-PIEUP
     (?$(CC[(B . ?\xCD6F) ; HANGUL SYLLABLE CHIEUCH-OE-SIOS
     (?$(CC\(B . ?\xCD71) ; HANGUL SYLLABLE CHIEUCH-OE-IEUNG
     (?$(CC](B . ?\xCD78) ; HANGUL SYLLABLE CHIEUCH-YO
     (?$(CC^(B . ?\xCD88) ; HANGUL SYLLABLE CHIEUCH-YO-MIEUM
     (?$(CC_(B . ?\xCD94) ; HANGUL SYLLABLE CHIEUCH-U
     (?$(CC`(B . ?\xCD95) ; HANGUL SYLLABLE CHIEUCH-U-KIYEOK
     (?$(CCa(B . ?\xCD98) ; HANGUL SYLLABLE CHIEUCH-U-NIEUN
     (?$(CCb(B . ?\xCD9C) ; HANGUL SYLLABLE CHIEUCH-U-RIEUL
     (?$(CCc(B . ?\xCDA4) ; HANGUL SYLLABLE CHIEUCH-U-MIEUM
     (?$(CCd(B . ?\xCDA5) ; HANGUL SYLLABLE CHIEUCH-U-PIEUP
     (?$(CCe(B . ?\xCDA7) ; HANGUL SYLLABLE CHIEUCH-U-SIOS
     (?$(CCf(B . ?\xCDA9) ; HANGUL SYLLABLE CHIEUCH-U-IEUNG
     (?$(CCg(B . ?\xCDB0) ; HANGUL SYLLABLE CHIEUCH-WEO
     (?$(CCh(B . ?\xCDC4) ; HANGUL SYLLABLE CHIEUCH-WEO-SSANGSIOS
     (?$(CCi(B . ?\xCDCC) ; HANGUL SYLLABLE CHIEUCH-WE
     (?$(CCj(B . ?\xCDD0) ; HANGUL SYLLABLE CHIEUCH-WE-NIEUN
     (?$(CCk(B . ?\xCDE8) ; HANGUL SYLLABLE CHIEUCH-WI
     (?$(CCl(B . ?\xCDEC) ; HANGUL SYLLABLE CHIEUCH-WI-NIEUN
     (?$(CCm(B . ?\xCDF0) ; HANGUL SYLLABLE CHIEUCH-WI-RIEUL
     (?$(CCn(B . ?\xCDF8) ; HANGUL SYLLABLE CHIEUCH-WI-MIEUM
     (?$(CCo(B . ?\xCDF9) ; HANGUL SYLLABLE CHIEUCH-WI-PIEUP
     (?$(CCp(B . ?\xCDFB) ; HANGUL SYLLABLE CHIEUCH-WI-SIOS
     (?$(CCq(B . ?\xCDFD) ; HANGUL SYLLABLE CHIEUCH-WI-IEUNG
     (?$(CCr(B . ?\xCE04) ; HANGUL SYLLABLE CHIEUCH-YU
     (?$(CCs(B . ?\xCE08) ; HANGUL SYLLABLE CHIEUCH-YU-NIEUN
     (?$(CCt(B . ?\xCE0C) ; HANGUL SYLLABLE CHIEUCH-YU-RIEUL
     (?$(CCu(B . ?\xCE14) ; HANGUL SYLLABLE CHIEUCH-YU-MIEUM
     (?$(CCv(B . ?\xCE19) ; HANGUL SYLLABLE CHIEUCH-YU-IEUNG
     (?$(CCw(B . ?\xCE20) ; HANGUL SYLLABLE CHIEUCH-EU
     (?$(CCx(B . ?\xCE21) ; HANGUL SYLLABLE CHIEUCH-EU-KIYEOK
     (?$(CCy(B . ?\xCE24) ; HANGUL SYLLABLE CHIEUCH-EU-NIEUN
     (?$(CCz(B . ?\xCE28) ; HANGUL SYLLABLE CHIEUCH-EU-RIEUL
     (?$(CC{(B . ?\xCE30) ; HANGUL SYLLABLE CHIEUCH-EU-MIEUM
     (?$(CC|(B . ?\xCE31) ; HANGUL SYLLABLE CHIEUCH-EU-PIEUP
     (?$(CC}(B . ?\xCE33) ; HANGUL SYLLABLE CHIEUCH-EU-SIOS
     (?$(CC~(B . ?\xCE35) ; HANGUL SYLLABLE CHIEUCH-EU-IEUNG
     (?$(CD!(B . ?\xCE58) ; HANGUL SYLLABLE CHIEUCH-I
     (?$(CD"(B . ?\xCE59) ; HANGUL SYLLABLE CHIEUCH-I-KIYEOK
     (?$(CD#(B . ?\xCE5C) ; HANGUL SYLLABLE CHIEUCH-I-NIEUN
     (?$(CD$(B . ?\xCE5F) ; HANGUL SYLLABLE CHIEUCH-I-TIKEUT
     (?$(CD%(B . ?\xCE60) ; HANGUL SYLLABLE CHIEUCH-I-RIEUL
     (?$(CD&(B . ?\xCE61) ; HANGUL SYLLABLE CHIEUCH-I-RIEULKIYEOK
     (?$(CD'(B . ?\xCE68) ; HANGUL SYLLABLE CHIEUCH-I-MIEUM
     (?$(CD((B . ?\xCE69) ; HANGUL SYLLABLE CHIEUCH-I-PIEUP
     (?$(CD)(B . ?\xCE6B) ; HANGUL SYLLABLE CHIEUCH-I-SIOS
     (?$(CD*(B . ?\xCE6D) ; HANGUL SYLLABLE CHIEUCH-I-IEUNG
     (?$(CD+(B . ?\xCE74) ; HANGUL SYLLABLE KHIEUKH-A
     (?$(CD,(B . ?\xCE75) ; HANGUL SYLLABLE KHIEUKH-A-KIYEOK
     (?$(CD-(B . ?\xCE78) ; HANGUL SYLLABLE KHIEUKH-A-NIEUN
     (?$(CD.(B . ?\xCE7C) ; HANGUL SYLLABLE KHIEUKH-A-RIEUL
     (?$(CD/(B . ?\xCE84) ; HANGUL SYLLABLE KHIEUKH-A-MIEUM
     (?$(CD0(B . ?\xCE85) ; HANGUL SYLLABLE KHIEUKH-A-PIEUP
     (?$(CD1(B . ?\xCE87) ; HANGUL SYLLABLE KHIEUKH-A-SIOS
     (?$(CD2(B . ?\xCE89) ; HANGUL SYLLABLE KHIEUKH-A-IEUNG
     (?$(CD3(B . ?\xCE90) ; HANGUL SYLLABLE KHIEUKH-AE
     (?$(CD4(B . ?\xCE91) ; HANGUL SYLLABLE KHIEUKH-AE-KIYEOK
     (?$(CD5(B . ?\xCE94) ; HANGUL SYLLABLE KHIEUKH-AE-NIEUN
     (?$(CD6(B . ?\xCE98) ; HANGUL SYLLABLE KHIEUKH-AE-RIEUL
     (?$(CD7(B . ?\xCEA0) ; HANGUL SYLLABLE KHIEUKH-AE-MIEUM
     (?$(CD8(B . ?\xCEA1) ; HANGUL SYLLABLE KHIEUKH-AE-PIEUP
     (?$(CD9(B . ?\xCEA3) ; HANGUL SYLLABLE KHIEUKH-AE-SIOS
     (?$(CD:(B . ?\xCEA4) ; HANGUL SYLLABLE KHIEUKH-AE-SSANGSIOS
     (?$(CD;(B . ?\xCEA5) ; HANGUL SYLLABLE KHIEUKH-AE-IEUNG
     (?$(CD<(B . ?\xCEAC) ; HANGUL SYLLABLE KHIEUKH-YA
     (?$(CD=(B . ?\xCEAD) ; HANGUL SYLLABLE KHIEUKH-YA-KIYEOK
     (?$(CD>(B . ?\xCEC1) ; HANGUL SYLLABLE KHIEUKH-YA-IEUNG
     (?$(CD?(B . ?\xCEE4) ; HANGUL SYLLABLE KHIEUKH-EO
     (?$(CD@(B . ?\xCEE5) ; HANGUL SYLLABLE KHIEUKH-EO-KIYEOK
     (?$(CDA(B . ?\xCEE8) ; HANGUL SYLLABLE KHIEUKH-EO-NIEUN
     (?$(CDB(B . ?\xCEEB) ; HANGUL SYLLABLE KHIEUKH-EO-TIKEUT
     (?$(CDC(B . ?\xCEEC) ; HANGUL SYLLABLE KHIEUKH-EO-RIEUL
     (?$(CDD(B . ?\xCEF4) ; HANGUL SYLLABLE KHIEUKH-EO-MIEUM
     (?$(CDE(B . ?\xCEF5) ; HANGUL SYLLABLE KHIEUKH-EO-PIEUP
     (?$(CDF(B . ?\xCEF7) ; HANGUL SYLLABLE KHIEUKH-EO-SIOS
     (?$(CDG(B . ?\xCEF8) ; HANGUL SYLLABLE KHIEUKH-EO-SSANGSIOS
     (?$(CDH(B . ?\xCEF9) ; HANGUL SYLLABLE KHIEUKH-EO-IEUNG
     (?$(CDI(B . ?\xCF00) ; HANGUL SYLLABLE KHIEUKH-E
     (?$(CDJ(B . ?\xCF01) ; HANGUL SYLLABLE KHIEUKH-E-KIYEOK
     (?$(CDK(B . ?\xCF04) ; HANGUL SYLLABLE KHIEUKH-E-NIEUN
     (?$(CDL(B . ?\xCF08) ; HANGUL SYLLABLE KHIEUKH-E-RIEUL
     (?$(CDM(B . ?\xCF10) ; HANGUL SYLLABLE KHIEUKH-E-MIEUM
     (?$(CDN(B . ?\xCF11) ; HANGUL SYLLABLE KHIEUKH-E-PIEUP
     (?$(CDO(B . ?\xCF13) ; HANGUL SYLLABLE KHIEUKH-E-SIOS
     (?$(CDP(B . ?\xCF15) ; HANGUL SYLLABLE KHIEUKH-E-IEUNG
     (?$(CDQ(B . ?\xCF1C) ; HANGUL SYLLABLE KHIEUKH-YEO
     (?$(CDR(B . ?\xCF20) ; HANGUL SYLLABLE KHIEUKH-YEO-NIEUN
     (?$(CDS(B . ?\xCF24) ; HANGUL SYLLABLE KHIEUKH-YEO-RIEUL
     (?$(CDT(B . ?\xCF2C) ; HANGUL SYLLABLE KHIEUKH-YEO-MIEUM
     (?$(CDU(B . ?\xCF2D) ; HANGUL SYLLABLE KHIEUKH-YEO-PIEUP
     (?$(CDV(B . ?\xCF2F) ; HANGUL SYLLABLE KHIEUKH-YEO-SIOS
     (?$(CDW(B . ?\xCF30) ; HANGUL SYLLABLE KHIEUKH-YEO-SSANGSIOS
     (?$(CDX(B . ?\xCF31) ; HANGUL SYLLABLE KHIEUKH-YEO-IEUNG
     (?$(CDY(B . ?\xCF38) ; HANGUL SYLLABLE KHIEUKH-YE
     (?$(CDZ(B . ?\xCF54) ; HANGUL SYLLABLE KHIEUKH-O
     (?$(CD[(B . ?\xCF55) ; HANGUL SYLLABLE KHIEUKH-O-KIYEOK
     (?$(CD\(B . ?\xCF58) ; HANGUL SYLLABLE KHIEUKH-O-NIEUN
     (?$(CD](B . ?\xCF5C) ; HANGUL SYLLABLE KHIEUKH-O-RIEUL
     (?$(CD^(B . ?\xCF64) ; HANGUL SYLLABLE KHIEUKH-O-MIEUM
     (?$(CD_(B . ?\xCF65) ; HANGUL SYLLABLE KHIEUKH-O-PIEUP
     (?$(CD`(B . ?\xCF67) ; HANGUL SYLLABLE KHIEUKH-O-SIOS
     (?$(CDa(B . ?\xCF69) ; HANGUL SYLLABLE KHIEUKH-O-IEUNG
     (?$(CDb(B . ?\xCF70) ; HANGUL SYLLABLE KHIEUKH-WA
     (?$(CDc(B . ?\xCF71) ; HANGUL SYLLABLE KHIEUKH-WA-KIYEOK
     (?$(CDd(B . ?\xCF74) ; HANGUL SYLLABLE KHIEUKH-WA-NIEUN
     (?$(CDe(B . ?\xCF78) ; HANGUL SYLLABLE KHIEUKH-WA-RIEUL
     (?$(CDf(B . ?\xCF80) ; HANGUL SYLLABLE KHIEUKH-WA-MIEUM
     (?$(CDg(B . ?\xCF85) ; HANGUL SYLLABLE KHIEUKH-WA-IEUNG
     (?$(CDh(B . ?\xCF8C) ; HANGUL SYLLABLE KHIEUKH-WAE
     (?$(CDi(B . ?\xCFA1) ; HANGUL SYLLABLE KHIEUKH-WAE-IEUNG
     (?$(CDj(B . ?\xCFA8) ; HANGUL SYLLABLE KHIEUKH-OE
     (?$(CDk(B . ?\xCFB0) ; HANGUL SYLLABLE KHIEUKH-OE-RIEUL
     (?$(CDl(B . ?\xCFC4) ; HANGUL SYLLABLE KHIEUKH-YO
     (?$(CDm(B . ?\xCFE0) ; HANGUL SYLLABLE KHIEUKH-U
     (?$(CDn(B . ?\xCFE1) ; HANGUL SYLLABLE KHIEUKH-U-KIYEOK
     (?$(CDo(B . ?\xCFE4) ; HANGUL SYLLABLE KHIEUKH-U-NIEUN
     (?$(CDp(B . ?\xCFE8) ; HANGUL SYLLABLE KHIEUKH-U-RIEUL
     (?$(CDq(B . ?\xCFF0) ; HANGUL SYLLABLE KHIEUKH-U-MIEUM
     (?$(CDr(B . ?\xCFF1) ; HANGUL SYLLABLE KHIEUKH-U-PIEUP
     (?$(CDs(B . ?\xCFF3) ; HANGUL SYLLABLE KHIEUKH-U-SIOS
     (?$(CDt(B . ?\xCFF5) ; HANGUL SYLLABLE KHIEUKH-U-IEUNG
     (?$(CDu(B . ?\xCFFC) ; HANGUL SYLLABLE KHIEUKH-WEO
     (?$(CDv(B . ?\xD000) ; HANGUL SYLLABLE KHIEUKH-WEO-NIEUN
     (?$(CDw(B . ?\xD004) ; HANGUL SYLLABLE KHIEUKH-WEO-RIEUL
     (?$(CDx(B . ?\xD011) ; HANGUL SYLLABLE KHIEUKH-WEO-IEUNG
     (?$(CDy(B . ?\xD018) ; HANGUL SYLLABLE KHIEUKH-WE
     (?$(CDz(B . ?\xD02D) ; HANGUL SYLLABLE KHIEUKH-WE-IEUNG
     (?$(CD{(B . ?\xD034) ; HANGUL SYLLABLE KHIEUKH-WI
     (?$(CD|(B . ?\xD035) ; HANGUL SYLLABLE KHIEUKH-WI-KIYEOK
     (?$(CD}(B . ?\xD038) ; HANGUL SYLLABLE KHIEUKH-WI-NIEUN
     (?$(CD~(B . ?\xD03C) ; HANGUL SYLLABLE KHIEUKH-WI-RIEUL
     (?$(CE!(B . ?\xD044) ; HANGUL SYLLABLE KHIEUKH-WI-MIEUM
     (?$(CE"(B . ?\xD045) ; HANGUL SYLLABLE KHIEUKH-WI-PIEUP
     (?$(CE#(B . ?\xD047) ; HANGUL SYLLABLE KHIEUKH-WI-SIOS
     (?$(CE$(B . ?\xD049) ; HANGUL SYLLABLE KHIEUKH-WI-IEUNG
     (?$(CE%(B . ?\xD050) ; HANGUL SYLLABLE KHIEUKH-YU
     (?$(CE&(B . ?\xD054) ; HANGUL SYLLABLE KHIEUKH-YU-NIEUN
     (?$(CE'(B . ?\xD058) ; HANGUL SYLLABLE KHIEUKH-YU-RIEUL
     (?$(CE((B . ?\xD060) ; HANGUL SYLLABLE KHIEUKH-YU-MIEUM
     (?$(CE)(B . ?\xD06C) ; HANGUL SYLLABLE KHIEUKH-EU
     (?$(CE*(B . ?\xD06D) ; HANGUL SYLLABLE KHIEUKH-EU-KIYEOK
     (?$(CE+(B . ?\xD070) ; HANGUL SYLLABLE KHIEUKH-EU-NIEUN
     (?$(CE,(B . ?\xD074) ; HANGUL SYLLABLE KHIEUKH-EU-RIEUL
     (?$(CE-(B . ?\xD07C) ; HANGUL SYLLABLE KHIEUKH-EU-MIEUM
     (?$(CE.(B . ?\xD07D) ; HANGUL SYLLABLE KHIEUKH-EU-PIEUP
     (?$(CE/(B . ?\xD081) ; HANGUL SYLLABLE KHIEUKH-EU-IEUNG
     (?$(CE0(B . ?\xD0A4) ; HANGUL SYLLABLE KHIEUKH-I
     (?$(CE1(B . ?\xD0A5) ; HANGUL SYLLABLE KHIEUKH-I-KIYEOK
     (?$(CE2(B . ?\xD0A8) ; HANGUL SYLLABLE KHIEUKH-I-NIEUN
     (?$(CE3(B . ?\xD0AC) ; HANGUL SYLLABLE KHIEUKH-I-RIEUL
     (?$(CE4(B . ?\xD0B4) ; HANGUL SYLLABLE KHIEUKH-I-MIEUM
     (?$(CE5(B . ?\xD0B5) ; HANGUL SYLLABLE KHIEUKH-I-PIEUP
     (?$(CE6(B . ?\xD0B7) ; HANGUL SYLLABLE KHIEUKH-I-SIOS
     (?$(CE7(B . ?\xD0B9) ; HANGUL SYLLABLE KHIEUKH-I-IEUNG
     (?$(CE8(B . ?\xD0C0) ; HANGUL SYLLABLE THIEUTH-A
     (?$(CE9(B . ?\xD0C1) ; HANGUL SYLLABLE THIEUTH-A-KIYEOK
     (?$(CE:(B . ?\xD0C4) ; HANGUL SYLLABLE THIEUTH-A-NIEUN
     (?$(CE;(B . ?\xD0C8) ; HANGUL SYLLABLE THIEUTH-A-RIEUL
     (?$(CE<(B . ?\xD0C9) ; HANGUL SYLLABLE THIEUTH-A-RIEULKIYEOK
     (?$(CE=(B . ?\xD0D0) ; HANGUL SYLLABLE THIEUTH-A-MIEUM
     (?$(CE>(B . ?\xD0D1) ; HANGUL SYLLABLE THIEUTH-A-PIEUP
     (?$(CE?(B . ?\xD0D3) ; HANGUL SYLLABLE THIEUTH-A-SIOS
     (?$(CE@(B . ?\xD0D4) ; HANGUL SYLLABLE THIEUTH-A-SSANGSIOS
     (?$(CEA(B . ?\xD0D5) ; HANGUL SYLLABLE THIEUTH-A-IEUNG
     (?$(CEB(B . ?\xD0DC) ; HANGUL SYLLABLE THIEUTH-AE
     (?$(CEC(B . ?\xD0DD) ; HANGUL SYLLABLE THIEUTH-AE-KIYEOK
     (?$(CED(B . ?\xD0E0) ; HANGUL SYLLABLE THIEUTH-AE-NIEUN
     (?$(CEE(B . ?\xD0E4) ; HANGUL SYLLABLE THIEUTH-AE-RIEUL
     (?$(CEF(B . ?\xD0EC) ; HANGUL SYLLABLE THIEUTH-AE-MIEUM
     (?$(CEG(B . ?\xD0ED) ; HANGUL SYLLABLE THIEUTH-AE-PIEUP
     (?$(CEH(B . ?\xD0EF) ; HANGUL SYLLABLE THIEUTH-AE-SIOS
     (?$(CEI(B . ?\xD0F0) ; HANGUL SYLLABLE THIEUTH-AE-SSANGSIOS
     (?$(CEJ(B . ?\xD0F1) ; HANGUL SYLLABLE THIEUTH-AE-IEUNG
     (?$(CEK(B . ?\xD0F8) ; HANGUL SYLLABLE THIEUTH-YA
     (?$(CEL(B . ?\xD10D) ; HANGUL SYLLABLE THIEUTH-YA-IEUNG
     (?$(CEM(B . ?\xD130) ; HANGUL SYLLABLE THIEUTH-EO
     (?$(CEN(B . ?\xD131) ; HANGUL SYLLABLE THIEUTH-EO-KIYEOK
     (?$(CEO(B . ?\xD134) ; HANGUL SYLLABLE THIEUTH-EO-NIEUN
     (?$(CEP(B . ?\xD138) ; HANGUL SYLLABLE THIEUTH-EO-RIEUL
     (?$(CEQ(B . ?\xD13A) ; HANGUL SYLLABLE THIEUTH-EO-RIEULMIEUM
     (?$(CER(B . ?\xD140) ; HANGUL SYLLABLE THIEUTH-EO-MIEUM
     (?$(CES(B . ?\xD141) ; HANGUL SYLLABLE THIEUTH-EO-PIEUP
     (?$(CET(B . ?\xD143) ; HANGUL SYLLABLE THIEUTH-EO-SIOS
     (?$(CEU(B . ?\xD144) ; HANGUL SYLLABLE THIEUTH-EO-SSANGSIOS
     (?$(CEV(B . ?\xD145) ; HANGUL SYLLABLE THIEUTH-EO-IEUNG
     (?$(CEW(B . ?\xD14C) ; HANGUL SYLLABLE THIEUTH-E
     (?$(CEX(B . ?\xD14D) ; HANGUL SYLLABLE THIEUTH-E-KIYEOK
     (?$(CEY(B . ?\xD150) ; HANGUL SYLLABLE THIEUTH-E-NIEUN
     (?$(CEZ(B . ?\xD154) ; HANGUL SYLLABLE THIEUTH-E-RIEUL
     (?$(CE[(B . ?\xD15C) ; HANGUL SYLLABLE THIEUTH-E-MIEUM
     (?$(CE\(B . ?\xD15D) ; HANGUL SYLLABLE THIEUTH-E-PIEUP
     (?$(CE](B . ?\xD15F) ; HANGUL SYLLABLE THIEUTH-E-SIOS
     (?$(CE^(B . ?\xD161) ; HANGUL SYLLABLE THIEUTH-E-IEUNG
     (?$(CE_(B . ?\xD168) ; HANGUL SYLLABLE THIEUTH-YEO
     (?$(CE`(B . ?\xD16C) ; HANGUL SYLLABLE THIEUTH-YEO-NIEUN
     (?$(CEa(B . ?\xD17C) ; HANGUL SYLLABLE THIEUTH-YEO-SSANGSIOS
     (?$(CEb(B . ?\xD184) ; HANGUL SYLLABLE THIEUTH-YE
     (?$(CEc(B . ?\xD188) ; HANGUL SYLLABLE THIEUTH-YE-NIEUN
     (?$(CEd(B . ?\xD1A0) ; HANGUL SYLLABLE THIEUTH-O
     (?$(CEe(B . ?\xD1A1) ; HANGUL SYLLABLE THIEUTH-O-KIYEOK
     (?$(CEf(B . ?\xD1A4) ; HANGUL SYLLABLE THIEUTH-O-NIEUN
     (?$(CEg(B . ?\xD1A8) ; HANGUL SYLLABLE THIEUTH-O-RIEUL
     (?$(CEh(B . ?\xD1B0) ; HANGUL SYLLABLE THIEUTH-O-MIEUM
     (?$(CEi(B . ?\xD1B1) ; HANGUL SYLLABLE THIEUTH-O-PIEUP
     (?$(CEj(B . ?\xD1B3) ; HANGUL SYLLABLE THIEUTH-O-SIOS
     (?$(CEk(B . ?\xD1B5) ; HANGUL SYLLABLE THIEUTH-O-IEUNG
     (?$(CEl(B . ?\xD1BA) ; HANGUL SYLLABLE THIEUTH-O-PHIEUPH
     (?$(CEm(B . ?\xD1BC) ; HANGUL SYLLABLE THIEUTH-WA
     (?$(CEn(B . ?\xD1C0) ; HANGUL SYLLABLE THIEUTH-WA-NIEUN
     (?$(CEo(B . ?\xD1D8) ; HANGUL SYLLABLE THIEUTH-WAE
     (?$(CEp(B . ?\xD1F4) ; HANGUL SYLLABLE THIEUTH-OE
     (?$(CEq(B . ?\xD1F8) ; HANGUL SYLLABLE THIEUTH-OE-NIEUN
     (?$(CEr(B . ?\xD207) ; HANGUL SYLLABLE THIEUTH-OE-SIOS
     (?$(CEs(B . ?\xD209) ; HANGUL SYLLABLE THIEUTH-OE-IEUNG
     (?$(CEt(B . ?\xD210) ; HANGUL SYLLABLE THIEUTH-YO
     (?$(CEu(B . ?\xD22C) ; HANGUL SYLLABLE THIEUTH-U
     (?$(CEv(B . ?\xD22D) ; HANGUL SYLLABLE THIEUTH-U-KIYEOK
     (?$(CEw(B . ?\xD230) ; HANGUL SYLLABLE THIEUTH-U-NIEUN
     (?$(CEx(B . ?\xD234) ; HANGUL SYLLABLE THIEUTH-U-RIEUL
     (?$(CEy(B . ?\xD23C) ; HANGUL SYLLABLE THIEUTH-U-MIEUM
     (?$(CEz(B . ?\xD23D) ; HANGUL SYLLABLE THIEUTH-U-PIEUP
     (?$(CE{(B . ?\xD23F) ; HANGUL SYLLABLE THIEUTH-U-SIOS
     (?$(CE|(B . ?\xD241) ; HANGUL SYLLABLE THIEUTH-U-IEUNG
     (?$(CE}(B . ?\xD248) ; HANGUL SYLLABLE THIEUTH-WEO
     (?$(CE~(B . ?\xD25C) ; HANGUL SYLLABLE THIEUTH-WEO-SSANGSIOS
     (?$(CF!(B . ?\xD264) ; HANGUL SYLLABLE THIEUTH-WE
     (?$(CF"(B . ?\xD280) ; HANGUL SYLLABLE THIEUTH-WI
     (?$(CF#(B . ?\xD281) ; HANGUL SYLLABLE THIEUTH-WI-KIYEOK
     (?$(CF$(B . ?\xD284) ; HANGUL SYLLABLE THIEUTH-WI-NIEUN
     (?$(CF%(B . ?\xD288) ; HANGUL SYLLABLE THIEUTH-WI-RIEUL
     (?$(CF&(B . ?\xD290) ; HANGUL SYLLABLE THIEUTH-WI-MIEUM
     (?$(CF'(B . ?\xD291) ; HANGUL SYLLABLE THIEUTH-WI-PIEUP
     (?$(CF((B . ?\xD295) ; HANGUL SYLLABLE THIEUTH-WI-IEUNG
     (?$(CF)(B . ?\xD29C) ; HANGUL SYLLABLE THIEUTH-YU
     (?$(CF*(B . ?\xD2A0) ; HANGUL SYLLABLE THIEUTH-YU-NIEUN
     (?$(CF+(B . ?\xD2A4) ; HANGUL SYLLABLE THIEUTH-YU-RIEUL
     (?$(CF,(B . ?\xD2AC) ; HANGUL SYLLABLE THIEUTH-YU-MIEUM
     (?$(CF-(B . ?\xD2B1) ; HANGUL SYLLABLE THIEUTH-YU-IEUNG
     (?$(CF.(B . ?\xD2B8) ; HANGUL SYLLABLE THIEUTH-EU
     (?$(CF/(B . ?\xD2B9) ; HANGUL SYLLABLE THIEUTH-EU-KIYEOK
     (?$(CF0(B . ?\xD2BC) ; HANGUL SYLLABLE THIEUTH-EU-NIEUN
     (?$(CF1(B . ?\xD2BF) ; HANGUL SYLLABLE THIEUTH-EU-TIKEUT
     (?$(CF2(B . ?\xD2C0) ; HANGUL SYLLABLE THIEUTH-EU-RIEUL
     (?$(CF3(B . ?\xD2C2) ; HANGUL SYLLABLE THIEUTH-EU-RIEULMIEUM
     (?$(CF4(B . ?\xD2C8) ; HANGUL SYLLABLE THIEUTH-EU-MIEUM
     (?$(CF5(B . ?\xD2C9) ; HANGUL SYLLABLE THIEUTH-EU-PIEUP
     (?$(CF6(B . ?\xD2CB) ; HANGUL SYLLABLE THIEUTH-EU-SIOS
     (?$(CF7(B . ?\xD2D4) ; HANGUL SYLLABLE THIEUTH-YI
     (?$(CF8(B . ?\xD2D8) ; HANGUL SYLLABLE THIEUTH-YI-NIEUN
     (?$(CF9(B . ?\xD2DC) ; HANGUL SYLLABLE THIEUTH-YI-RIEUL
     (?$(CF:(B . ?\xD2E4) ; HANGUL SYLLABLE THIEUTH-YI-MIEUM
     (?$(CF;(B . ?\xD2E5) ; HANGUL SYLLABLE THIEUTH-YI-PIEUP
     (?$(CF<(B . ?\xD2F0) ; HANGUL SYLLABLE THIEUTH-I
     (?$(CF=(B . ?\xD2F1) ; HANGUL SYLLABLE THIEUTH-I-KIYEOK
     (?$(CF>(B . ?\xD2F4) ; HANGUL SYLLABLE THIEUTH-I-NIEUN
     (?$(CF?(B . ?\xD2F8) ; HANGUL SYLLABLE THIEUTH-I-RIEUL
     (?$(CF@(B . ?\xD300) ; HANGUL SYLLABLE THIEUTH-I-MIEUM
     (?$(CFA(B . ?\xD301) ; HANGUL SYLLABLE THIEUTH-I-PIEUP
     (?$(CFB(B . ?\xD303) ; HANGUL SYLLABLE THIEUTH-I-SIOS
     (?$(CFC(B . ?\xD305) ; HANGUL SYLLABLE THIEUTH-I-IEUNG
     (?$(CFD(B . ?\xD30C) ; HANGUL SYLLABLE PHIEUPH-A
     (?$(CFE(B . ?\xD30D) ; HANGUL SYLLABLE PHIEUPH-A-KIYEOK
     (?$(CFF(B . ?\xD30E) ; HANGUL SYLLABLE PHIEUPH-A-SSANGKIYEOK
     (?$(CFG(B . ?\xD310) ; HANGUL SYLLABLE PHIEUPH-A-NIEUN
     (?$(CFH(B . ?\xD314) ; HANGUL SYLLABLE PHIEUPH-A-RIEUL
     (?$(CFI(B . ?\xD316) ; HANGUL SYLLABLE PHIEUPH-A-RIEULMIEUM
     (?$(CFJ(B . ?\xD31C) ; HANGUL SYLLABLE PHIEUPH-A-MIEUM
     (?$(CFK(B . ?\xD31D) ; HANGUL SYLLABLE PHIEUPH-A-PIEUP
     (?$(CFL(B . ?\xD31F) ; HANGUL SYLLABLE PHIEUPH-A-SIOS
     (?$(CFM(B . ?\xD320) ; HANGUL SYLLABLE PHIEUPH-A-SSANGSIOS
     (?$(CFN(B . ?\xD321) ; HANGUL SYLLABLE PHIEUPH-A-IEUNG
     (?$(CFO(B . ?\xD325) ; HANGUL SYLLABLE PHIEUPH-A-THIEUTH
     (?$(CFP(B . ?\xD328) ; HANGUL SYLLABLE PHIEUPH-AE
     (?$(CFQ(B . ?\xD329) ; HANGUL SYLLABLE PHIEUPH-AE-KIYEOK
     (?$(CFR(B . ?\xD32C) ; HANGUL SYLLABLE PHIEUPH-AE-NIEUN
     (?$(CFS(B . ?\xD330) ; HANGUL SYLLABLE PHIEUPH-AE-RIEUL
     (?$(CFT(B . ?\xD338) ; HANGUL SYLLABLE PHIEUPH-AE-MIEUM
     (?$(CFU(B . ?\xD339) ; HANGUL SYLLABLE PHIEUPH-AE-PIEUP
     (?$(CFV(B . ?\xD33B) ; HANGUL SYLLABLE PHIEUPH-AE-SIOS
     (?$(CFW(B . ?\xD33C) ; HANGUL SYLLABLE PHIEUPH-AE-SSANGSIOS
     (?$(CFX(B . ?\xD33D) ; HANGUL SYLLABLE PHIEUPH-AE-IEUNG
     (?$(CFY(B . ?\xD344) ; HANGUL SYLLABLE PHIEUPH-YA
     (?$(CFZ(B . ?\xD345) ; HANGUL SYLLABLE PHIEUPH-YA-KIYEOK
     (?$(CF[(B . ?\xD37C) ; HANGUL SYLLABLE PHIEUPH-EO
     (?$(CF\(B . ?\xD37D) ; HANGUL SYLLABLE PHIEUPH-EO-KIYEOK
     (?$(CF](B . ?\xD380) ; HANGUL SYLLABLE PHIEUPH-EO-NIEUN
     (?$(CF^(B . ?\xD384) ; HANGUL SYLLABLE PHIEUPH-EO-RIEUL
     (?$(CF_(B . ?\xD38C) ; HANGUL SYLLABLE PHIEUPH-EO-MIEUM
     (?$(CF`(B . ?\xD38D) ; HANGUL SYLLABLE PHIEUPH-EO-PIEUP
     (?$(CFa(B . ?\xD38F) ; HANGUL SYLLABLE PHIEUPH-EO-SIOS
     (?$(CFb(B . ?\xD390) ; HANGUL SYLLABLE PHIEUPH-EO-SSANGSIOS
     (?$(CFc(B . ?\xD391) ; HANGUL SYLLABLE PHIEUPH-EO-IEUNG
     (?$(CFd(B . ?\xD398) ; HANGUL SYLLABLE PHIEUPH-E
     (?$(CFe(B . ?\xD399) ; HANGUL SYLLABLE PHIEUPH-E-KIYEOK
     (?$(CFf(B . ?\xD39C) ; HANGUL SYLLABLE PHIEUPH-E-NIEUN
     (?$(CFg(B . ?\xD3A0) ; HANGUL SYLLABLE PHIEUPH-E-RIEUL
     (?$(CFh(B . ?\xD3A8) ; HANGUL SYLLABLE PHIEUPH-E-MIEUM
     (?$(CFi(B . ?\xD3A9) ; HANGUL SYLLABLE PHIEUPH-E-PIEUP
     (?$(CFj(B . ?\xD3AB) ; HANGUL SYLLABLE PHIEUPH-E-SIOS
     (?$(CFk(B . ?\xD3AD) ; HANGUL SYLLABLE PHIEUPH-E-IEUNG
     (?$(CFl(B . ?\xD3B4) ; HANGUL SYLLABLE PHIEUPH-YEO
     (?$(CFm(B . ?\xD3B8) ; HANGUL SYLLABLE PHIEUPH-YEO-NIEUN
     (?$(CFn(B . ?\xD3BC) ; HANGUL SYLLABLE PHIEUPH-YEO-RIEUL
     (?$(CFo(B . ?\xD3C4) ; HANGUL SYLLABLE PHIEUPH-YEO-MIEUM
     (?$(CFp(B . ?\xD3C5) ; HANGUL SYLLABLE PHIEUPH-YEO-PIEUP
     (?$(CFq(B . ?\xD3C8) ; HANGUL SYLLABLE PHIEUPH-YEO-SSANGSIOS
     (?$(CFr(B . ?\xD3C9) ; HANGUL SYLLABLE PHIEUPH-YEO-IEUNG
     (?$(CFs(B . ?\xD3D0) ; HANGUL SYLLABLE PHIEUPH-YE
     (?$(CFt(B . ?\xD3D8) ; HANGUL SYLLABLE PHIEUPH-YE-RIEUL
     (?$(CFu(B . ?\xD3E1) ; HANGUL SYLLABLE PHIEUPH-YE-PIEUP
     (?$(CFv(B . ?\xD3E3) ; HANGUL SYLLABLE PHIEUPH-YE-SIOS
     (?$(CFw(B . ?\xD3EC) ; HANGUL SYLLABLE PHIEUPH-O
     (?$(CFx(B . ?\xD3ED) ; HANGUL SYLLABLE PHIEUPH-O-KIYEOK
     (?$(CFy(B . ?\xD3F0) ; HANGUL SYLLABLE PHIEUPH-O-NIEUN
     (?$(CFz(B . ?\xD3F4) ; HANGUL SYLLABLE PHIEUPH-O-RIEUL
     (?$(CF{(B . ?\xD3FC) ; HANGUL SYLLABLE PHIEUPH-O-MIEUM
     (?$(CF|(B . ?\xD3FD) ; HANGUL SYLLABLE PHIEUPH-O-PIEUP
     (?$(CF}(B . ?\xD3FF) ; HANGUL SYLLABLE PHIEUPH-O-SIOS
     (?$(CF~(B . ?\xD401) ; HANGUL SYLLABLE PHIEUPH-O-IEUNG
     (?$(CG!(B . ?\xD408) ; HANGUL SYLLABLE PHIEUPH-WA
     (?$(CG"(B . ?\xD41D) ; HANGUL SYLLABLE PHIEUPH-WA-IEUNG
     (?$(CG#(B . ?\xD440) ; HANGUL SYLLABLE PHIEUPH-OE
     (?$(CG$(B . ?\xD444) ; HANGUL SYLLABLE PHIEUPH-OE-NIEUN
     (?$(CG%(B . ?\xD45C) ; HANGUL SYLLABLE PHIEUPH-YO
     (?$(CG&(B . ?\xD460) ; HANGUL SYLLABLE PHIEUPH-YO-NIEUN
     (?$(CG'(B . ?\xD464) ; HANGUL SYLLABLE PHIEUPH-YO-RIEUL
     (?$(CG((B . ?\xD46D) ; HANGUL SYLLABLE PHIEUPH-YO-PIEUP
     (?$(CG)(B . ?\xD46F) ; HANGUL SYLLABLE PHIEUPH-YO-SIOS
     (?$(CG*(B . ?\xD478) ; HANGUL SYLLABLE PHIEUPH-U
     (?$(CG+(B . ?\xD479) ; HANGUL SYLLABLE PHIEUPH-U-KIYEOK
     (?$(CG,(B . ?\xD47C) ; HANGUL SYLLABLE PHIEUPH-U-NIEUN
     (?$(CG-(B . ?\xD47F) ; HANGUL SYLLABLE PHIEUPH-U-TIKEUT
     (?$(CG.(B . ?\xD480) ; HANGUL SYLLABLE PHIEUPH-U-RIEUL
     (?$(CG/(B . ?\xD482) ; HANGUL SYLLABLE PHIEUPH-U-RIEULMIEUM
     (?$(CG0(B . ?\xD488) ; HANGUL SYLLABLE PHIEUPH-U-MIEUM
     (?$(CG1(B . ?\xD489) ; HANGUL SYLLABLE PHIEUPH-U-PIEUP
     (?$(CG2(B . ?\xD48B) ; HANGUL SYLLABLE PHIEUPH-U-SIOS
     (?$(CG3(B . ?\xD48D) ; HANGUL SYLLABLE PHIEUPH-U-IEUNG
     (?$(CG4(B . ?\xD494) ; HANGUL SYLLABLE PHIEUPH-WEO
     (?$(CG5(B . ?\xD4A9) ; HANGUL SYLLABLE PHIEUPH-WEO-IEUNG
     (?$(CG6(B . ?\xD4CC) ; HANGUL SYLLABLE PHIEUPH-WI
     (?$(CG7(B . ?\xD4D0) ; HANGUL SYLLABLE PHIEUPH-WI-NIEUN
     (?$(CG8(B . ?\xD4D4) ; HANGUL SYLLABLE PHIEUPH-WI-RIEUL
     (?$(CG9(B . ?\xD4DC) ; HANGUL SYLLABLE PHIEUPH-WI-MIEUM
     (?$(CG:(B . ?\xD4DF) ; HANGUL SYLLABLE PHIEUPH-WI-SIOS
     (?$(CG;(B . ?\xD4E8) ; HANGUL SYLLABLE PHIEUPH-YU
     (?$(CG<(B . ?\xD4EC) ; HANGUL SYLLABLE PHIEUPH-YU-NIEUN
     (?$(CG=(B . ?\xD4F0) ; HANGUL SYLLABLE PHIEUPH-YU-RIEUL
     (?$(CG>(B . ?\xD4F8) ; HANGUL SYLLABLE PHIEUPH-YU-MIEUM
     (?$(CG?(B . ?\xD4FB) ; HANGUL SYLLABLE PHIEUPH-YU-SIOS
     (?$(CG@(B . ?\xD4FD) ; HANGUL SYLLABLE PHIEUPH-YU-IEUNG
     (?$(CGA(B . ?\xD504) ; HANGUL SYLLABLE PHIEUPH-EU
     (?$(CGB(B . ?\xD508) ; HANGUL SYLLABLE PHIEUPH-EU-NIEUN
     (?$(CGC(B . ?\xD50C) ; HANGUL SYLLABLE PHIEUPH-EU-RIEUL
     (?$(CGD(B . ?\xD514) ; HANGUL SYLLABLE PHIEUPH-EU-MIEUM
     (?$(CGE(B . ?\xD515) ; HANGUL SYLLABLE PHIEUPH-EU-PIEUP
     (?$(CGF(B . ?\xD517) ; HANGUL SYLLABLE PHIEUPH-EU-SIOS
     (?$(CGG(B . ?\xD53C) ; HANGUL SYLLABLE PHIEUPH-I
     (?$(CGH(B . ?\xD53D) ; HANGUL SYLLABLE PHIEUPH-I-KIYEOK
     (?$(CGI(B . ?\xD540) ; HANGUL SYLLABLE PHIEUPH-I-NIEUN
     (?$(CGJ(B . ?\xD544) ; HANGUL SYLLABLE PHIEUPH-I-RIEUL
     (?$(CGK(B . ?\xD54C) ; HANGUL SYLLABLE PHIEUPH-I-MIEUM
     (?$(CGL(B . ?\xD54D) ; HANGUL SYLLABLE PHIEUPH-I-PIEUP
     (?$(CGM(B . ?\xD54F) ; HANGUL SYLLABLE PHIEUPH-I-SIOS
     (?$(CGN(B . ?\xD551) ; HANGUL SYLLABLE PHIEUPH-I-IEUNG
     (?$(CGO(B . ?\xD558) ; HANGUL SYLLABLE HIEUH-A
     (?$(CGP(B . ?\xD559) ; HANGUL SYLLABLE HIEUH-A-KIYEOK
     (?$(CGQ(B . ?\xD55C) ; HANGUL SYLLABLE HIEUH-A-NIEUN
     (?$(CGR(B . ?\xD560) ; HANGUL SYLLABLE HIEUH-A-RIEUL
     (?$(CGS(B . ?\xD565) ; HANGUL SYLLABLE HIEUH-A-RIEULTHIEUTH
     (?$(CGT(B . ?\xD568) ; HANGUL SYLLABLE HIEUH-A-MIEUM
     (?$(CGU(B . ?\xD569) ; HANGUL SYLLABLE HIEUH-A-PIEUP
     (?$(CGV(B . ?\xD56B) ; HANGUL SYLLABLE HIEUH-A-SIOS
     (?$(CGW(B . ?\xD56D) ; HANGUL SYLLABLE HIEUH-A-IEUNG
     (?$(CGX(B . ?\xD574) ; HANGUL SYLLABLE HIEUH-AE
     (?$(CGY(B . ?\xD575) ; HANGUL SYLLABLE HIEUH-AE-KIYEOK
     (?$(CGZ(B . ?\xD578) ; HANGUL SYLLABLE HIEUH-AE-NIEUN
     (?$(CG[(B . ?\xD57C) ; HANGUL SYLLABLE HIEUH-AE-RIEUL
     (?$(CG\(B . ?\xD584) ; HANGUL SYLLABLE HIEUH-AE-MIEUM
     (?$(CG](B . ?\xD585) ; HANGUL SYLLABLE HIEUH-AE-PIEUP
     (?$(CG^(B . ?\xD587) ; HANGUL SYLLABLE HIEUH-AE-SIOS
     (?$(CG_(B . ?\xD588) ; HANGUL SYLLABLE HIEUH-AE-SSANGSIOS
     (?$(CG`(B . ?\xD589) ; HANGUL SYLLABLE HIEUH-AE-IEUNG
     (?$(CGa(B . ?\xD590) ; HANGUL SYLLABLE HIEUH-YA
     (?$(CGb(B . ?\xD5A5) ; HANGUL SYLLABLE HIEUH-YA-IEUNG
     (?$(CGc(B . ?\xD5C8) ; HANGUL SYLLABLE HIEUH-EO
     (?$(CGd(B . ?\xD5C9) ; HANGUL SYLLABLE HIEUH-EO-KIYEOK
     (?$(CGe(B . ?\xD5CC) ; HANGUL SYLLABLE HIEUH-EO-NIEUN
     (?$(CGf(B . ?\xD5D0) ; HANGUL SYLLABLE HIEUH-EO-RIEUL
     (?$(CGg(B . ?\xD5D2) ; HANGUL SYLLABLE HIEUH-EO-RIEULMIEUM
     (?$(CGh(B . ?\xD5D8) ; HANGUL SYLLABLE HIEUH-EO-MIEUM
     (?$(CGi(B . ?\xD5D9) ; HANGUL SYLLABLE HIEUH-EO-PIEUP
     (?$(CGj(B . ?\xD5DB) ; HANGUL SYLLABLE HIEUH-EO-SIOS
     (?$(CGk(B . ?\xD5DD) ; HANGUL SYLLABLE HIEUH-EO-IEUNG
     (?$(CGl(B . ?\xD5E4) ; HANGUL SYLLABLE HIEUH-E
     (?$(CGm(B . ?\xD5E5) ; HANGUL SYLLABLE HIEUH-E-KIYEOK
     (?$(CGn(B . ?\xD5E8) ; HANGUL SYLLABLE HIEUH-E-NIEUN
     (?$(CGo(B . ?\xD5EC) ; HANGUL SYLLABLE HIEUH-E-RIEUL
     (?$(CGp(B . ?\xD5F4) ; HANGUL SYLLABLE HIEUH-E-MIEUM
     (?$(CGq(B . ?\xD5F5) ; HANGUL SYLLABLE HIEUH-E-PIEUP
     (?$(CGr(B . ?\xD5F7) ; HANGUL SYLLABLE HIEUH-E-SIOS
     (?$(CGs(B . ?\xD5F9) ; HANGUL SYLLABLE HIEUH-E-IEUNG
     (?$(CGt(B . ?\xD600) ; HANGUL SYLLABLE HIEUH-YEO
     (?$(CGu(B . ?\xD601) ; HANGUL SYLLABLE HIEUH-YEO-KIYEOK
     (?$(CGv(B . ?\xD604) ; HANGUL SYLLABLE HIEUH-YEO-NIEUN
     (?$(CGw(B . ?\xD608) ; HANGUL SYLLABLE HIEUH-YEO-RIEUL
     (?$(CGx(B . ?\xD610) ; HANGUL SYLLABLE HIEUH-YEO-MIEUM
     (?$(CGy(B . ?\xD611) ; HANGUL SYLLABLE HIEUH-YEO-PIEUP
     (?$(CGz(B . ?\xD613) ; HANGUL SYLLABLE HIEUH-YEO-SIOS
     (?$(CG{(B . ?\xD614) ; HANGUL SYLLABLE HIEUH-YEO-SSANGSIOS
     (?$(CG|(B . ?\xD615) ; HANGUL SYLLABLE HIEUH-YEO-IEUNG
     (?$(CG}(B . ?\xD61C) ; HANGUL SYLLABLE HIEUH-YE
     (?$(CG~(B . ?\xD620) ; HANGUL SYLLABLE HIEUH-YE-NIEUN
     (?$(CH!(B . ?\xD624) ; HANGUL SYLLABLE HIEUH-YE-RIEUL
     (?$(CH"(B . ?\xD62D) ; HANGUL SYLLABLE HIEUH-YE-PIEUP
     (?$(CH#(B . ?\xD638) ; HANGUL SYLLABLE HIEUH-O
     (?$(CH$(B . ?\xD639) ; HANGUL SYLLABLE HIEUH-O-KIYEOK
     (?$(CH%(B . ?\xD63C) ; HANGUL SYLLABLE HIEUH-O-NIEUN
     (?$(CH&(B . ?\xD640) ; HANGUL SYLLABLE HIEUH-O-RIEUL
     (?$(CH'(B . ?\xD645) ; HANGUL SYLLABLE HIEUH-O-RIEULTHIEUTH
     (?$(CH((B . ?\xD648) ; HANGUL SYLLABLE HIEUH-O-MIEUM
     (?$(CH)(B . ?\xD649) ; HANGUL SYLLABLE HIEUH-O-PIEUP
     (?$(CH*(B . ?\xD64B) ; HANGUL SYLLABLE HIEUH-O-SIOS
     (?$(CH+(B . ?\xD64D) ; HANGUL SYLLABLE HIEUH-O-IEUNG
     (?$(CH,(B . ?\xD651) ; HANGUL SYLLABLE HIEUH-O-THIEUTH
     (?$(CH-(B . ?\xD654) ; HANGUL SYLLABLE HIEUH-WA
     (?$(CH.(B . ?\xD655) ; HANGUL SYLLABLE HIEUH-WA-KIYEOK
     (?$(CH/(B . ?\xD658) ; HANGUL SYLLABLE HIEUH-WA-NIEUN
     (?$(CH0(B . ?\xD65C) ; HANGUL SYLLABLE HIEUH-WA-RIEUL
     (?$(CH1(B . ?\xD667) ; HANGUL SYLLABLE HIEUH-WA-SIOS
     (?$(CH2(B . ?\xD669) ; HANGUL SYLLABLE HIEUH-WA-IEUNG
     (?$(CH3(B . ?\xD670) ; HANGUL SYLLABLE HIEUH-WAE
     (?$(CH4(B . ?\xD671) ; HANGUL SYLLABLE HIEUH-WAE-KIYEOK
     (?$(CH5(B . ?\xD674) ; HANGUL SYLLABLE HIEUH-WAE-NIEUN
     (?$(CH6(B . ?\xD683) ; HANGUL SYLLABLE HIEUH-WAE-SIOS
     (?$(CH7(B . ?\xD685) ; HANGUL SYLLABLE HIEUH-WAE-IEUNG
     (?$(CH8(B . ?\xD68C) ; HANGUL SYLLABLE HIEUH-OE
     (?$(CH9(B . ?\xD68D) ; HANGUL SYLLABLE HIEUH-OE-KIYEOK
     (?$(CH:(B . ?\xD690) ; HANGUL SYLLABLE HIEUH-OE-NIEUN
     (?$(CH;(B . ?\xD694) ; HANGUL SYLLABLE HIEUH-OE-RIEUL
     (?$(CH<(B . ?\xD69D) ; HANGUL SYLLABLE HIEUH-OE-PIEUP
     (?$(CH=(B . ?\xD69F) ; HANGUL SYLLABLE HIEUH-OE-SIOS
     (?$(CH>(B . ?\xD6A1) ; HANGUL SYLLABLE HIEUH-OE-IEUNG
     (?$(CH?(B . ?\xD6A8) ; HANGUL SYLLABLE HIEUH-YO
     (?$(CH@(B . ?\xD6AC) ; HANGUL SYLLABLE HIEUH-YO-NIEUN
     (?$(CHA(B . ?\xD6B0) ; HANGUL SYLLABLE HIEUH-YO-RIEUL
     (?$(CHB(B . ?\xD6B9) ; HANGUL SYLLABLE HIEUH-YO-PIEUP
     (?$(CHC(B . ?\xD6BB) ; HANGUL SYLLABLE HIEUH-YO-SIOS
     (?$(CHD(B . ?\xD6C4) ; HANGUL SYLLABLE HIEUH-U
     (?$(CHE(B . ?\xD6C5) ; HANGUL SYLLABLE HIEUH-U-KIYEOK
     (?$(CHF(B . ?\xD6C8) ; HANGUL SYLLABLE HIEUH-U-NIEUN
     (?$(CHG(B . ?\xD6CC) ; HANGUL SYLLABLE HIEUH-U-RIEUL
     (?$(CHH(B . ?\xD6D1) ; HANGUL SYLLABLE HIEUH-U-RIEULTHIEUTH
     (?$(CHI(B . ?\xD6D4) ; HANGUL SYLLABLE HIEUH-U-MIEUM
     (?$(CHJ(B . ?\xD6D7) ; HANGUL SYLLABLE HIEUH-U-SIOS
     (?$(CHK(B . ?\xD6D9) ; HANGUL SYLLABLE HIEUH-U-IEUNG
     (?$(CHL(B . ?\xD6E0) ; HANGUL SYLLABLE HIEUH-WEO
     (?$(CHM(B . ?\xD6E4) ; HANGUL SYLLABLE HIEUH-WEO-NIEUN
     (?$(CHN(B . ?\xD6E8) ; HANGUL SYLLABLE HIEUH-WEO-RIEUL
     (?$(CHO(B . ?\xD6F0) ; HANGUL SYLLABLE HIEUH-WEO-MIEUM
     (?$(CHP(B . ?\xD6F5) ; HANGUL SYLLABLE HIEUH-WEO-IEUNG
     (?$(CHQ(B . ?\xD6FC) ; HANGUL SYLLABLE HIEUH-WE
     (?$(CHR(B . ?\xD6FD) ; HANGUL SYLLABLE HIEUH-WE-KIYEOK
     (?$(CHS(B . ?\xD700) ; HANGUL SYLLABLE HIEUH-WE-NIEUN
     (?$(CHT(B . ?\xD704) ; HANGUL SYLLABLE HIEUH-WE-RIEUL
     (?$(CHU(B . ?\xD711) ; HANGUL SYLLABLE HIEUH-WE-IEUNG
     (?$(CHV(B . ?\xD718) ; HANGUL SYLLABLE HIEUH-WI
     (?$(CHW(B . ?\xD719) ; HANGUL SYLLABLE HIEUH-WI-KIYEOK
     (?$(CHX(B . ?\xD71C) ; HANGUL SYLLABLE HIEUH-WI-NIEUN
     (?$(CHY(B . ?\xD720) ; HANGUL SYLLABLE HIEUH-WI-RIEUL
     (?$(CHZ(B . ?\xD728) ; HANGUL SYLLABLE HIEUH-WI-MIEUM
     (?$(CH[(B . ?\xD729) ; HANGUL SYLLABLE HIEUH-WI-PIEUP
     (?$(CH\(B . ?\xD72B) ; HANGUL SYLLABLE HIEUH-WI-SIOS
     (?$(CH](B . ?\xD72D) ; HANGUL SYLLABLE HIEUH-WI-IEUNG
     (?$(CH^(B . ?\xD734) ; HANGUL SYLLABLE HIEUH-YU
     (?$(CH_(B . ?\xD735) ; HANGUL SYLLABLE HIEUH-YU-KIYEOK
     (?$(CH`(B . ?\xD738) ; HANGUL SYLLABLE HIEUH-YU-NIEUN
     (?$(CHa(B . ?\xD73C) ; HANGUL SYLLABLE HIEUH-YU-RIEUL
     (?$(CHb(B . ?\xD744) ; HANGUL SYLLABLE HIEUH-YU-MIEUM
     (?$(CHc(B . ?\xD747) ; HANGUL SYLLABLE HIEUH-YU-SIOS
     (?$(CHd(B . ?\xD749) ; HANGUL SYLLABLE HIEUH-YU-IEUNG
     (?$(CHe(B . ?\xD750) ; HANGUL SYLLABLE HIEUH-EU
     (?$(CHf(B . ?\xD751) ; HANGUL SYLLABLE HIEUH-EU-KIYEOK
     (?$(CHg(B . ?\xD754) ; HANGUL SYLLABLE HIEUH-EU-NIEUN
     (?$(CHh(B . ?\xD756) ; HANGUL SYLLABLE HIEUH-EU-NIEUNHIEUH
     (?$(CHi(B . ?\xD757) ; HANGUL SYLLABLE HIEUH-EU-TIKEUT
     (?$(CHj(B . ?\xD758) ; HANGUL SYLLABLE HIEUH-EU-RIEUL
     (?$(CHk(B . ?\xD759) ; HANGUL SYLLABLE HIEUH-EU-RIEULKIYEOK
     (?$(CHl(B . ?\xD760) ; HANGUL SYLLABLE HIEUH-EU-MIEUM
     (?$(CHm(B . ?\xD761) ; HANGUL SYLLABLE HIEUH-EU-PIEUP
     (?$(CHn(B . ?\xD763) ; HANGUL SYLLABLE HIEUH-EU-SIOS
     (?$(CHo(B . ?\xD765) ; HANGUL SYLLABLE HIEUH-EU-IEUNG
     (?$(CHp(B . ?\xD769) ; HANGUL SYLLABLE HIEUH-EU-THIEUTH
     (?$(CHq(B . ?\xD76C) ; HANGUL SYLLABLE HIEUH-YI
     (?$(CHr(B . ?\xD770) ; HANGUL SYLLABLE HIEUH-YI-NIEUN
     (?$(CHs(B . ?\xD774) ; HANGUL SYLLABLE HIEUH-YI-RIEUL
     (?$(CHt(B . ?\xD77C) ; HANGUL SYLLABLE HIEUH-YI-MIEUM
     (?$(CHu(B . ?\xD77D) ; HANGUL SYLLABLE HIEUH-YI-PIEUP
     (?$(CHv(B . ?\xD781) ; HANGUL SYLLABLE HIEUH-YI-IEUNG
     (?$(CHw(B . ?\xD788) ; HANGUL SYLLABLE HIEUH-I
     (?$(CHx(B . ?\xD789) ; HANGUL SYLLABLE HIEUH-I-KIYEOK
     (?$(CHy(B . ?\xD78C) ; HANGUL SYLLABLE HIEUH-I-NIEUN
     (?$(CHz(B . ?\xD790) ; HANGUL SYLLABLE HIEUH-I-RIEUL
     (?$(CH{(B . ?\xD798) ; HANGUL SYLLABLE HIEUH-I-MIEUM
     (?$(CH|(B . ?\xD799) ; HANGUL SYLLABLE HIEUH-I-PIEUP
     (?$(CH}(B . ?\xD79B) ; HANGUL SYLLABLE HIEUH-I-SIOS
     (?$(CH~(B . ?\xD79D) ; HANGUL SYLLABLE HIEUH-I-IEUNG
     (?$(CJ!(B . ?\x4F3D) ; <CJK>
     (?$(CJ"(B . ?\x4F73) ; <CJK>
     (?$(CJ#(B . ?\x5047) ; <CJK>
     (?$(CJ$(B . ?\x50F9) ; <CJK>
     (?$(CJ%(B . ?\x52A0) ; <CJK>
     (?$(CJ&(B . ?\x53EF) ; <CJK>
     (?$(CJ'(B . ?\x5475) ; <CJK>
     (?$(CJ((B . ?\x54E5) ; <CJK>
     (?$(CJ)(B . ?\x5609) ; <CJK>
     (?$(CJ*(B . ?\x5AC1) ; <CJK>
     (?$(CJ+(B . ?\x5BB6) ; <CJK>
     (?$(CJ,(B . ?\x6687) ; <CJK>
     (?$(CJ-(B . ?\x67B6) ; <CJK>
     (?$(CJ.(B . ?\x67B7) ; <CJK>
     (?$(CJ/(B . ?\x67EF) ; <CJK>
     (?$(CJ0(B . ?\x6B4C) ; <CJK>
     (?$(CJ1(B . ?\x73C2) ; <CJK>
     (?$(CJ2(B . ?\x75C2) ; <CJK>
     (?$(CJ3(B . ?\x7A3C) ; <CJK>
     (?$(CJ4(B . ?\x82DB) ; <CJK>
     (?$(CJ5(B . ?\x8304) ; <CJK>
     (?$(CJ6(B . ?\x8857) ; <CJK>
     (?$(CJ7(B . ?\x8888) ; <CJK>
     (?$(CJ8(B . ?\x8A36) ; <CJK>
     (?$(CJ9(B . ?\x8CC8) ; <CJK>
     (?$(CJ:(B . ?\x8DCF) ; <CJK>
     (?$(CJ;(B . ?\x8EFB) ; <CJK>
     (?$(CJ<(B . ?\x8FE6) ; <CJK>
     (?$(CJ=(B . ?\x99D5) ; <CJK>
     (?$(CJ>(B . ?\x523B) ; <CJK>
     (?$(CJ?(B . ?\x5374) ; <CJK>
     (?$(CJ@(B . ?\x5404) ; <CJK>
     (?$(CJA(B . ?\x606A) ; <CJK>
     (?$(CJB(B . ?\x6164) ; <CJK>
     (?$(CJC(B . ?\x6BBC) ; <CJK>
     (?$(CJD(B . ?\x73CF) ; <CJK>
     (?$(CJE(B . ?\x811A) ; <CJK>
     (?$(CJF(B . ?\x89BA) ; <CJK>
     (?$(CJG(B . ?\x89D2) ; <CJK>
     (?$(CJH(B . ?\x95A3) ; <CJK>
     (?$(CJI(B . ?\x4F83) ; <CJK>
     (?$(CJJ(B . ?\x520A) ; <CJK>
     (?$(CJK(B . ?\x58BE) ; <CJK>
     (?$(CJL(B . ?\x5978) ; <CJK>
     (?$(CJM(B . ?\x59E6) ; <CJK>
     (?$(CJN(B . ?\x5E72) ; <CJK>
     (?$(CJO(B . ?\x5E79) ; <CJK>
     (?$(CJP(B . ?\x61C7) ; <CJK>
     (?$(CJQ(B . ?\x63C0) ; <CJK>
     (?$(CJR(B . ?\x6746) ; <CJK>
     (?$(CJS(B . ?\x67EC) ; <CJK>
     (?$(CJT(B . ?\x687F) ; <CJK>
     (?$(CJU(B . ?\x6F97) ; <CJK>
     (?$(CJV(B . ?\x764E) ; <CJK>
     (?$(CJW(B . ?\x770B) ; <CJK>
     (?$(CJX(B . ?\x78F5) ; <CJK>
     (?$(CJY(B . ?\x7A08) ; <CJK>
     (?$(CJZ(B . ?\x7AFF) ; <CJK>
     (?$(CJ[(B . ?\x7C21) ; <CJK>
     (?$(CJ\(B . ?\x809D) ; <CJK>
     (?$(CJ](B . ?\x826E) ; <CJK>
     (?$(CJ^(B . ?\x8271) ; <CJK>
     (?$(CJ_(B . ?\x8AEB) ; <CJK>
     (?$(CJ`(B . ?\x9593) ; <CJK>
     (?$(CJa(B . ?\x4E6B) ; <CJK>
     (?$(CJb(B . ?\x559D) ; <CJK>
     (?$(CJc(B . ?\x66F7) ; <CJK>
     (?$(CJd(B . ?\x6E34) ; <CJK>
     (?$(CJe(B . ?\x78A3) ; <CJK>
     (?$(CJf(B . ?\x7AED) ; <CJK>
     (?$(CJg(B . ?\x845B) ; <CJK>
     (?$(CJh(B . ?\x8910) ; <CJK>
     (?$(CJi(B . ?\x874E) ; <CJK>
     (?$(CJj(B . ?\x97A8) ; <CJK>
     (?$(CJk(B . ?\x52D8) ; <CJK>
     (?$(CJl(B . ?\x574E) ; <CJK>
     (?$(CJm(B . ?\x582A) ; <CJK>
     (?$(CJn(B . ?\x5D4C) ; <CJK>
     (?$(CJo(B . ?\x611F) ; <CJK>
     (?$(CJp(B . ?\x61BE) ; <CJK>
     (?$(CJq(B . ?\x6221) ; <CJK>
     (?$(CJr(B . ?\x6562) ; <CJK>
     (?$(CJs(B . ?\x67D1) ; <CJK>
     (?$(CJt(B . ?\x6A44) ; <CJK>
     (?$(CJu(B . ?\x6E1B) ; <CJK>
     (?$(CJv(B . ?\x7518) ; <CJK>
     (?$(CJw(B . ?\x75B3) ; <CJK>
     (?$(CJx(B . ?\x76E3) ; <CJK>
     (?$(CJy(B . ?\x77B0) ; <CJK>
     (?$(CJz(B . ?\x7D3A) ; <CJK>
     (?$(CJ{(B . ?\x90AF) ; <CJK>
     (?$(CJ|(B . ?\x9451) ; <CJK>
     (?$(CJ}(B . ?\x9452) ; <CJK>
     (?$(CJ~(B . ?\x9F95) ; <CJK>
     (?$(CK!(B . ?\x5323) ; <CJK>
     (?$(CK"(B . ?\x5CAC) ; <CJK>
     (?$(CK#(B . ?\x7532) ; <CJK>
     (?$(CK$(B . ?\x80DB) ; <CJK>
     (?$(CK%(B . ?\x9240) ; <CJK>
     (?$(CK&(B . ?\x9598) ; <CJK>
     (?$(CK'(B . ?\x525B) ; <CJK>
     (?$(CK((B . ?\x5808) ; <CJK>
     (?$(CK)(B . ?\x59DC) ; <CJK>
     (?$(CK*(B . ?\x5CA1) ; <CJK>
     (?$(CK+(B . ?\x5D17) ; <CJK>
     (?$(CK,(B . ?\x5EB7) ; <CJK>
     (?$(CK-(B . ?\x5F3A) ; <CJK>
     (?$(CK.(B . ?\x5F4A) ; <CJK>
     (?$(CK/(B . ?\x6177) ; <CJK>
     (?$(CK0(B . ?\x6C5F) ; <CJK>
     (?$(CK1(B . ?\x757A) ; <CJK>
     (?$(CK2(B . ?\x7586) ; <CJK>
     (?$(CK3(B . ?\x7CE0) ; <CJK>
     (?$(CK4(B . ?\x7D73) ; <CJK>
     (?$(CK5(B . ?\x7DB1) ; <CJK>
     (?$(CK6(B . ?\x7F8C) ; <CJK>
     (?$(CK7(B . ?\x8154) ; <CJK>
     (?$(CK8(B . ?\x8221) ; <CJK>
     (?$(CK9(B . ?\x8591) ; <CJK>
     (?$(CK:(B . ?\x8941) ; <CJK>
     (?$(CK;(B . ?\x8B1B) ; <CJK>
     (?$(CK<(B . ?\x92FC) ; <CJK>
     (?$(CK=(B . ?\x964D) ; <CJK>
     (?$(CK>(B . ?\x9C47) ; <CJK>
     (?$(CK?(B . ?\x4ECB) ; <CJK>
     (?$(CK@(B . ?\x4EF7) ; <CJK>
     (?$(CKA(B . ?\x500B) ; <CJK>
     (?$(CKB(B . ?\x51F1) ; <CJK>
     (?$(CKC(B . ?\x584F) ; <CJK>
     (?$(CKD(B . ?\x6137) ; <CJK>
     (?$(CKE(B . ?\x613E) ; <CJK>
     (?$(CKF(B . ?\x6168) ; <CJK>
     (?$(CKG(B . ?\x6539) ; <CJK>
     (?$(CKH(B . ?\x69EA) ; <CJK>
     (?$(CKI(B . ?\x6F11) ; <CJK>
     (?$(CKJ(B . ?\x75A5) ; <CJK>
     (?$(CKK(B . ?\x7686) ; <CJK>
     (?$(CKL(B . ?\x76D6) ; <CJK>
     (?$(CKM(B . ?\x7B87) ; <CJK>
     (?$(CKN(B . ?\x82A5) ; <CJK>
     (?$(CKO(B . ?\x84CB) ; <CJK>
     (?$(CKP(B . ?\xF900) ; <CJK>
     (?$(CKQ(B . ?\x93A7) ; <CJK>
     (?$(CKR(B . ?\x958B) ; <CJK>
     (?$(CKS(B . ?\x5580) ; <CJK>
     (?$(CKT(B . ?\x5BA2) ; <CJK>
     (?$(CKU(B . ?\x5751) ; <CJK>
     (?$(CKV(B . ?\xF901) ; <CJK>
     (?$(CKW(B . ?\x7CB3) ; <CJK>
     (?$(CKX(B . ?\x7FB9) ; <CJK>
     (?$(CKY(B . ?\x91B5) ; <CJK>
     (?$(CKZ(B . ?\x5028) ; <CJK>
     (?$(CK[(B . ?\x53BB) ; <CJK>
     (?$(CK\(B . ?\x5C45) ; <CJK>
     (?$(CK](B . ?\x5DE8) ; <CJK>
     (?$(CK^(B . ?\x62D2) ; <CJK>
     (?$(CK_(B . ?\x636E) ; <CJK>
     (?$(CK`(B . ?\x64DA) ; <CJK>
     (?$(CKa(B . ?\x64E7) ; <CJK>
     (?$(CKb(B . ?\x6E20) ; <CJK>
     (?$(CKc(B . ?\x70AC) ; <CJK>
     (?$(CKd(B . ?\x795B) ; <CJK>
     (?$(CKe(B . ?\x8DDD) ; <CJK>
     (?$(CKf(B . ?\x8E1E) ; <CJK>
     (?$(CKg(B . ?\xF902) ; <CJK>
     (?$(CKh(B . ?\x907D) ; <CJK>
     (?$(CKi(B . ?\x9245) ; <CJK>
     (?$(CKj(B . ?\x92F8) ; <CJK>
     (?$(CKk(B . ?\x4E7E) ; <CJK>
     (?$(CKl(B . ?\x4EF6) ; <CJK>
     (?$(CKm(B . ?\x5065) ; <CJK>
     (?$(CKn(B . ?\x5DFE) ; <CJK>
     (?$(CKo(B . ?\x5EFA) ; <CJK>
     (?$(CKp(B . ?\x6106) ; <CJK>
     (?$(CKq(B . ?\x6957) ; <CJK>
     (?$(CKr(B . ?\x8171) ; <CJK>
     (?$(CKs(B . ?\x8654) ; <CJK>
     (?$(CKt(B . ?\x8E47) ; <CJK>
     (?$(CKu(B . ?\x9375) ; <CJK>
     (?$(CKv(B . ?\x9A2B) ; <CJK>
     (?$(CKw(B . ?\x4E5E) ; <CJK>
     (?$(CKx(B . ?\x5091) ; <CJK>
     (?$(CKy(B . ?\x6770) ; <CJK>
     (?$(CKz(B . ?\x6840) ; <CJK>
     (?$(CK{(B . ?\x5109) ; <CJK>
     (?$(CK|(B . ?\x528D) ; <CJK>
     (?$(CK}(B . ?\x5292) ; <CJK>
     (?$(CK~(B . ?\x6AA2) ; <CJK>
     (?$(CL!(B . ?\x77BC) ; <CJK>
     (?$(CL"(B . ?\x9210) ; <CJK>
     (?$(CL#(B . ?\x9ED4) ; <CJK>
     (?$(CL$(B . ?\x52AB) ; <CJK>
     (?$(CL%(B . ?\x602F) ; <CJK>
     (?$(CL&(B . ?\x8FF2) ; <CJK>
     (?$(CL'(B . ?\x5048) ; <CJK>
     (?$(CL((B . ?\x61A9) ; <CJK>
     (?$(CL)(B . ?\x63ED) ; <CJK>
     (?$(CL*(B . ?\x64CA) ; <CJK>
     (?$(CL+(B . ?\x683C) ; <CJK>
     (?$(CL,(B . ?\x6A84) ; <CJK>
     (?$(CL-(B . ?\x6FC0) ; <CJK>
     (?$(CL.(B . ?\x8188) ; <CJK>
     (?$(CL/(B . ?\x89A1) ; <CJK>
     (?$(CL0(B . ?\x9694) ; <CJK>
     (?$(CL1(B . ?\x5805) ; <CJK>
     (?$(CL2(B . ?\x727D) ; <CJK>
     (?$(CL3(B . ?\x72AC) ; <CJK>
     (?$(CL4(B . ?\x7504) ; <CJK>
     (?$(CL5(B . ?\x7D79) ; <CJK>
     (?$(CL6(B . ?\x7E6D) ; <CJK>
     (?$(CL7(B . ?\x80A9) ; <CJK>
     (?$(CL8(B . ?\x898B) ; <CJK>
     (?$(CL9(B . ?\x8B74) ; <CJK>
     (?$(CL:(B . ?\x9063) ; <CJK>
     (?$(CL;(B . ?\x9D51) ; <CJK>
     (?$(CL<(B . ?\x6289) ; <CJK>
     (?$(CL=(B . ?\x6C7A) ; <CJK>
     (?$(CL>(B . ?\x6F54) ; <CJK>
     (?$(CL?(B . ?\x7D50) ; <CJK>
     (?$(CL@(B . ?\x7F3A) ; <CJK>
     (?$(CLA(B . ?\x8A23) ; <CJK>
     (?$(CLB(B . ?\x517C) ; <CJK>
     (?$(CLC(B . ?\x614A) ; <CJK>
     (?$(CLD(B . ?\x7B9D) ; <CJK>
     (?$(CLE(B . ?\x8B19) ; <CJK>
     (?$(CLF(B . ?\x9257) ; <CJK>
     (?$(CLG(B . ?\x938C) ; <CJK>
     (?$(CLH(B . ?\x4EAC) ; <CJK>
     (?$(CLI(B . ?\x4FD3) ; <CJK>
     (?$(CLJ(B . ?\x501E) ; <CJK>
     (?$(CLK(B . ?\x50BE) ; <CJK>
     (?$(CLL(B . ?\x5106) ; <CJK>
     (?$(CLM(B . ?\x52C1) ; <CJK>
     (?$(CLN(B . ?\x52CD) ; <CJK>
     (?$(CLO(B . ?\x537F) ; <CJK>
     (?$(CLP(B . ?\x5770) ; <CJK>
     (?$(CLQ(B . ?\x5883) ; <CJK>
     (?$(CLR(B . ?\x5E9A) ; <CJK>
     (?$(CLS(B . ?\x5F91) ; <CJK>
     (?$(CLT(B . ?\x6176) ; <CJK>
     (?$(CLU(B . ?\x61AC) ; <CJK>
     (?$(CLV(B . ?\x64CE) ; <CJK>
     (?$(CLW(B . ?\x656C) ; <CJK>
     (?$(CLX(B . ?\x666F) ; <CJK>
     (?$(CLY(B . ?\x66BB) ; <CJK>
     (?$(CLZ(B . ?\x66F4) ; <CJK>
     (?$(CL[(B . ?\x6897) ; <CJK>
     (?$(CL\(B . ?\x6D87) ; <CJK>
     (?$(CL](B . ?\x7085) ; <CJK>
     (?$(CL^(B . ?\x70F1) ; <CJK>
     (?$(CL_(B . ?\x749F) ; <CJK>
     (?$(CL`(B . ?\x74A5) ; <CJK>
     (?$(CLa(B . ?\x74CA) ; <CJK>
     (?$(CLb(B . ?\x75D9) ; <CJK>
     (?$(CLc(B . ?\x786C) ; <CJK>
     (?$(CLd(B . ?\x78EC) ; <CJK>
     (?$(CLe(B . ?\x7ADF) ; <CJK>
     (?$(CLf(B . ?\x7AF6) ; <CJK>
     (?$(CLg(B . ?\x7D45) ; <CJK>
     (?$(CLh(B . ?\x7D93) ; <CJK>
     (?$(CLi(B . ?\x8015) ; <CJK>
     (?$(CLj(B . ?\x803F) ; <CJK>
     (?$(CLk(B . ?\x811B) ; <CJK>
     (?$(CLl(B . ?\x8396) ; <CJK>
     (?$(CLm(B . ?\x8B66) ; <CJK>
     (?$(CLn(B . ?\x8F15) ; <CJK>
     (?$(CLo(B . ?\x9015) ; <CJK>
     (?$(CLp(B . ?\x93E1) ; <CJK>
     (?$(CLq(B . ?\x9803) ; <CJK>
     (?$(CLr(B . ?\x9838) ; <CJK>
     (?$(CLs(B . ?\x9A5A) ; <CJK>
     (?$(CLt(B . ?\x9BE8) ; <CJK>
     (?$(CLu(B . ?\x4FC2) ; <CJK>
     (?$(CLv(B . ?\x5553) ; <CJK>
     (?$(CLw(B . ?\x583A) ; <CJK>
     (?$(CLx(B . ?\x5951) ; <CJK>
     (?$(CLy(B . ?\x5B63) ; <CJK>
     (?$(CLz(B . ?\x5C46) ; <CJK>
     (?$(CL{(B . ?\x60B8) ; <CJK>
     (?$(CL|(B . ?\x6212) ; <CJK>
     (?$(CL}(B . ?\x6842) ; <CJK>
     (?$(CL~(B . ?\x68B0) ; <CJK>
     (?$(CM!(B . ?\x68E8) ; <CJK>
     (?$(CM"(B . ?\x6EAA) ; <CJK>
     (?$(CM#(B . ?\x754C) ; <CJK>
     (?$(CM$(B . ?\x7678) ; <CJK>
     (?$(CM%(B . ?\x78CE) ; <CJK>
     (?$(CM&(B . ?\x7A3D) ; <CJK>
     (?$(CM'(B . ?\x7CFB) ; <CJK>
     (?$(CM((B . ?\x7E6B) ; <CJK>
     (?$(CM)(B . ?\x7E7C) ; <CJK>
     (?$(CM*(B . ?\x8A08) ; <CJK>
     (?$(CM+(B . ?\x8AA1) ; <CJK>
     (?$(CM,(B . ?\x8C3F) ; <CJK>
     (?$(CM-(B . ?\x968E) ; <CJK>
     (?$(CM.(B . ?\x9DC4) ; <CJK>
     (?$(CM/(B . ?\x53E4) ; <CJK>
     (?$(CM0(B . ?\x53E9) ; <CJK>
     (?$(CM1(B . ?\x544A) ; <CJK>
     (?$(CM2(B . ?\x5471) ; <CJK>
     (?$(CM3(B . ?\x56FA) ; <CJK>
     (?$(CM4(B . ?\x59D1) ; <CJK>
     (?$(CM5(B . ?\x5B64) ; <CJK>
     (?$(CM6(B . ?\x5C3B) ; <CJK>
     (?$(CM7(B . ?\x5EAB) ; <CJK>
     (?$(CM8(B . ?\x62F7) ; <CJK>
     (?$(CM9(B . ?\x6537) ; <CJK>
     (?$(CM:(B . ?\x6545) ; <CJK>
     (?$(CM;(B . ?\x6572) ; <CJK>
     (?$(CM<(B . ?\x66A0) ; <CJK>
     (?$(CM=(B . ?\x67AF) ; <CJK>
     (?$(CM>(B . ?\x69C1) ; <CJK>
     (?$(CM?(B . ?\x6CBD) ; <CJK>
     (?$(CM@(B . ?\x75FC) ; <CJK>
     (?$(CMA(B . ?\x7690) ; <CJK>
     (?$(CMB(B . ?\x777E) ; <CJK>
     (?$(CMC(B . ?\x7A3F) ; <CJK>
     (?$(CMD(B . ?\x7F94) ; <CJK>
     (?$(CME(B . ?\x8003) ; <CJK>
     (?$(CMF(B . ?\x80A1) ; <CJK>
     (?$(CMG(B . ?\x818F) ; <CJK>
     (?$(CMH(B . ?\x82E6) ; <CJK>
     (?$(CMI(B . ?\x82FD) ; <CJK>
     (?$(CMJ(B . ?\x83F0) ; <CJK>
     (?$(CMK(B . ?\x85C1) ; <CJK>
     (?$(CML(B . ?\x8831) ; <CJK>
     (?$(CMM(B . ?\x88B4) ; <CJK>
     (?$(CMN(B . ?\x8AA5) ; <CJK>
     (?$(CMO(B . ?\xF903) ; <CJK>
     (?$(CMP(B . ?\x8F9C) ; <CJK>
     (?$(CMQ(B . ?\x932E) ; <CJK>
     (?$(CMR(B . ?\x96C7) ; <CJK>
     (?$(CMS(B . ?\x9867) ; <CJK>
     (?$(CMT(B . ?\x9AD8) ; <CJK>
     (?$(CMU(B . ?\x9F13) ; <CJK>
     (?$(CMV(B . ?\x54ED) ; <CJK>
     (?$(CMW(B . ?\x659B) ; <CJK>
     (?$(CMX(B . ?\x66F2) ; <CJK>
     (?$(CMY(B . ?\x688F) ; <CJK>
     (?$(CMZ(B . ?\x7A40) ; <CJK>
     (?$(CM[(B . ?\x8C37) ; <CJK>
     (?$(CM\(B . ?\x9D60) ; <CJK>
     (?$(CM](B . ?\x56F0) ; <CJK>
     (?$(CM^(B . ?\x5764) ; <CJK>
     (?$(CM_(B . ?\x5D11) ; <CJK>
     (?$(CM`(B . ?\x6606) ; <CJK>
     (?$(CMa(B . ?\x68B1) ; <CJK>
     (?$(CMb(B . ?\x68CD) ; <CJK>
     (?$(CMc(B . ?\x6EFE) ; <CJK>
     (?$(CMd(B . ?\x7428) ; <CJK>
     (?$(CMe(B . ?\x889E) ; <CJK>
     (?$(CMf(B . ?\x9BE4) ; <CJK>
     (?$(CMg(B . ?\x6C68) ; <CJK>
     (?$(CMh(B . ?\xF904) ; <CJK>
     (?$(CMi(B . ?\x9AA8) ; <CJK>
     (?$(CMj(B . ?\x4F9B) ; <CJK>
     (?$(CMk(B . ?\x516C) ; <CJK>
     (?$(CMl(B . ?\x5171) ; <CJK>
     (?$(CMm(B . ?\x529F) ; <CJK>
     (?$(CMn(B . ?\x5B54) ; <CJK>
     (?$(CMo(B . ?\x5DE5) ; <CJK>
     (?$(CMp(B . ?\x6050) ; <CJK>
     (?$(CMq(B . ?\x606D) ; <CJK>
     (?$(CMr(B . ?\x62F1) ; <CJK>
     (?$(CMs(B . ?\x63A7) ; <CJK>
     (?$(CMt(B . ?\x653B) ; <CJK>
     (?$(CMu(B . ?\x73D9) ; <CJK>
     (?$(CMv(B . ?\x7A7A) ; <CJK>
     (?$(CMw(B . ?\x86A3) ; <CJK>
     (?$(CMx(B . ?\x8CA2) ; <CJK>
     (?$(CMy(B . ?\x978F) ; <CJK>
     (?$(CMz(B . ?\x4E32) ; <CJK>
     (?$(CM{(B . ?\x5BE1) ; <CJK>
     (?$(CM|(B . ?\x6208) ; <CJK>
     (?$(CM}(B . ?\x679C) ; <CJK>
     (?$(CM~(B . ?\x74DC) ; <CJK>
     (?$(CN!(B . ?\x79D1) ; <CJK>
     (?$(CN"(B . ?\x83D3) ; <CJK>
     (?$(CN#(B . ?\x8A87) ; <CJK>
     (?$(CN$(B . ?\x8AB2) ; <CJK>
     (?$(CN%(B . ?\x8DE8) ; <CJK>
     (?$(CN&(B . ?\x904E) ; <CJK>
     (?$(CN'(B . ?\x934B) ; <CJK>
     (?$(CN((B . ?\x9846) ; <CJK>
     (?$(CN)(B . ?\x5ED3) ; <CJK>
     (?$(CN*(B . ?\x69E8) ; <CJK>
     (?$(CN+(B . ?\x85FF) ; <CJK>
     (?$(CN,(B . ?\x90ED) ; <CJK>
     (?$(CN-(B . ?\xF905) ; <CJK>
     (?$(CN.(B . ?\x51A0) ; <CJK>
     (?$(CN/(B . ?\x5B98) ; <CJK>
     (?$(CN0(B . ?\x5BEC) ; <CJK>
     (?$(CN1(B . ?\x6163) ; <CJK>
     (?$(CN2(B . ?\x68FA) ; <CJK>
     (?$(CN3(B . ?\x6B3E) ; <CJK>
     (?$(CN4(B . ?\x704C) ; <CJK>
     (?$(CN5(B . ?\x742F) ; <CJK>
     (?$(CN6(B . ?\x74D8) ; <CJK>
     (?$(CN7(B . ?\x7BA1) ; <CJK>
     (?$(CN8(B . ?\x7F50) ; <CJK>
     (?$(CN9(B . ?\x83C5) ; <CJK>
     (?$(CN:(B . ?\x89C0) ; <CJK>
     (?$(CN;(B . ?\x8CAB) ; <CJK>
     (?$(CN<(B . ?\x95DC) ; <CJK>
     (?$(CN=(B . ?\x9928) ; <CJK>
     (?$(CN>(B . ?\x522E) ; <CJK>
     (?$(CN?(B . ?\x605D) ; <CJK>
     (?$(CN@(B . ?\x62EC) ; <CJK>
     (?$(CNA(B . ?\x9002) ; <CJK>
     (?$(CNB(B . ?\x4F8A) ; <CJK>
     (?$(CNC(B . ?\x5149) ; <CJK>
     (?$(CND(B . ?\x5321) ; <CJK>
     (?$(CNE(B . ?\x58D9) ; <CJK>
     (?$(CNF(B . ?\x5EE3) ; <CJK>
     (?$(CNG(B . ?\x66E0) ; <CJK>
     (?$(CNH(B . ?\x6D38) ; <CJK>
     (?$(CNI(B . ?\x709A) ; <CJK>
     (?$(CNJ(B . ?\x72C2) ; <CJK>
     (?$(CNK(B . ?\x73D6) ; <CJK>
     (?$(CNL(B . ?\x7B50) ; <CJK>
     (?$(CNM(B . ?\x80F1) ; <CJK>
     (?$(CNN(B . ?\x945B) ; <CJK>
     (?$(CNO(B . ?\x5366) ; <CJK>
     (?$(CNP(B . ?\x639B) ; <CJK>
     (?$(CNQ(B . ?\x7F6B) ; <CJK>
     (?$(CNR(B . ?\x4E56) ; <CJK>
     (?$(CNS(B . ?\x5080) ; <CJK>
     (?$(CNT(B . ?\x584A) ; <CJK>
     (?$(CNU(B . ?\x58DE) ; <CJK>
     (?$(CNV(B . ?\x602A) ; <CJK>
     (?$(CNW(B . ?\x6127) ; <CJK>
     (?$(CNX(B . ?\x62D0) ; <CJK>
     (?$(CNY(B . ?\x69D0) ; <CJK>
     (?$(CNZ(B . ?\x9B41) ; <CJK>
     (?$(CN[(B . ?\x5B8F) ; <CJK>
     (?$(CN\(B . ?\x7D18) ; <CJK>
     (?$(CN](B . ?\x80B1) ; <CJK>
     (?$(CN^(B . ?\x8F5F) ; <CJK>
     (?$(CN_(B . ?\x4EA4) ; <CJK>
     (?$(CN`(B . ?\x50D1) ; <CJK>
     (?$(CNa(B . ?\x54AC) ; <CJK>
     (?$(CNb(B . ?\x55AC) ; <CJK>
     (?$(CNc(B . ?\x5B0C) ; <CJK>
     (?$(CNd(B . ?\x5DA0) ; <CJK>
     (?$(CNe(B . ?\x5DE7) ; <CJK>
     (?$(CNf(B . ?\x652A) ; <CJK>
     (?$(CNg(B . ?\x654E) ; <CJK>
     (?$(CNh(B . ?\x6821) ; <CJK>
     (?$(CNi(B . ?\x6A4B) ; <CJK>
     (?$(CNj(B . ?\x72E1) ; <CJK>
     (?$(CNk(B . ?\x768E) ; <CJK>
     (?$(CNl(B . ?\x77EF) ; <CJK>
     (?$(CNm(B . ?\x7D5E) ; <CJK>
     (?$(CNn(B . ?\x7FF9) ; <CJK>
     (?$(CNo(B . ?\x81A0) ; <CJK>
     (?$(CNp(B . ?\x854E) ; <CJK>
     (?$(CNq(B . ?\x86DF) ; <CJK>
     (?$(CNr(B . ?\x8F03) ; <CJK>
     (?$(CNs(B . ?\x8F4E) ; <CJK>
     (?$(CNt(B . ?\x90CA) ; <CJK>
     (?$(CNu(B . ?\x9903) ; <CJK>
     (?$(CNv(B . ?\x9A55) ; <CJK>
     (?$(CNw(B . ?\x9BAB) ; <CJK>
     (?$(CNx(B . ?\x4E18) ; <CJK>
     (?$(CNy(B . ?\x4E45) ; <CJK>
     (?$(CNz(B . ?\x4E5D) ; <CJK>
     (?$(CN{(B . ?\x4EC7) ; <CJK>
     (?$(CN|(B . ?\x4FF1) ; <CJK>
     (?$(CN}(B . ?\x5177) ; <CJK>
     (?$(CN~(B . ?\x52FE) ; <CJK>
     (?$(CO!(B . ?\x5340) ; <CJK>
     (?$(CO"(B . ?\x53E3) ; <CJK>
     (?$(CO#(B . ?\x53E5) ; <CJK>
     (?$(CO$(B . ?\x548E) ; <CJK>
     (?$(CO%(B . ?\x5614) ; <CJK>
     (?$(CO&(B . ?\x5775) ; <CJK>
     (?$(CO'(B . ?\x57A2) ; <CJK>
     (?$(CO((B . ?\x5BC7) ; <CJK>
     (?$(CO)(B . ?\x5D87) ; <CJK>
     (?$(CO*(B . ?\x5ED0) ; <CJK>
     (?$(CO+(B . ?\x61FC) ; <CJK>
     (?$(CO,(B . ?\x62D8) ; <CJK>
     (?$(CO-(B . ?\x6551) ; <CJK>
     (?$(CO.(B . ?\x67B8) ; <CJK>
     (?$(CO/(B . ?\x67E9) ; <CJK>
     (?$(CO0(B . ?\x69CB) ; <CJK>
     (?$(CO1(B . ?\x6B50) ; <CJK>
     (?$(CO2(B . ?\x6BC6) ; <CJK>
     (?$(CO3(B . ?\x6BEC) ; <CJK>
     (?$(CO4(B . ?\x6C42) ; <CJK>
     (?$(CO5(B . ?\x6E9D) ; <CJK>
     (?$(CO6(B . ?\x7078) ; <CJK>
     (?$(CO7(B . ?\x72D7) ; <CJK>
     (?$(CO8(B . ?\x7396) ; <CJK>
     (?$(CO9(B . ?\x7403) ; <CJK>
     (?$(CO:(B . ?\x77BF) ; <CJK>
     (?$(CO;(B . ?\x77E9) ; <CJK>
     (?$(CO<(B . ?\x7A76) ; <CJK>
     (?$(CO=(B . ?\x7D7F) ; <CJK>
     (?$(CO>(B . ?\x8009) ; <CJK>
     (?$(CO?(B . ?\x81FC) ; <CJK>
     (?$(CO@(B . ?\x8205) ; <CJK>
     (?$(COA(B . ?\x820A) ; <CJK>
     (?$(COB(B . ?\x82DF) ; <CJK>
     (?$(COC(B . ?\x8862) ; <CJK>
     (?$(COD(B . ?\x8B33) ; <CJK>
     (?$(COE(B . ?\x8CFC) ; <CJK>
     (?$(COF(B . ?\x8EC0) ; <CJK>
     (?$(COG(B . ?\x9011) ; <CJK>
     (?$(COH(B . ?\x90B1) ; <CJK>
     (?$(COI(B . ?\x9264) ; <CJK>
     (?$(COJ(B . ?\x92B6) ; <CJK>
     (?$(COK(B . ?\x99D2) ; <CJK>
     (?$(COL(B . ?\x9A45) ; <CJK>
     (?$(COM(B . ?\x9CE9) ; <CJK>
     (?$(CON(B . ?\x9DD7) ; <CJK>
     (?$(COO(B . ?\x9F9C) ; <CJK>
     (?$(COP(B . ?\x570B) ; <CJK>
     (?$(COQ(B . ?\x5C40) ; <CJK>
     (?$(COR(B . ?\x83CA) ; <CJK>
     (?$(COS(B . ?\x97A0) ; <CJK>
     (?$(COT(B . ?\x97AB) ; <CJK>
     (?$(COU(B . ?\x9EB4) ; <CJK>
     (?$(COV(B . ?\x541B) ; <CJK>
     (?$(COW(B . ?\x7A98) ; <CJK>
     (?$(COX(B . ?\x7FA4) ; <CJK>
     (?$(COY(B . ?\x88D9) ; <CJK>
     (?$(COZ(B . ?\x8ECD) ; <CJK>
     (?$(CO[(B . ?\x90E1) ; <CJK>
     (?$(CO\(B . ?\x5800) ; <CJK>
     (?$(CO](B . ?\x5C48) ; <CJK>
     (?$(CO^(B . ?\x6398) ; <CJK>
     (?$(CO_(B . ?\x7A9F) ; <CJK>
     (?$(CO`(B . ?\x5BAE) ; <CJK>
     (?$(COa(B . ?\x5F13) ; <CJK>
     (?$(COb(B . ?\x7A79) ; <CJK>
     (?$(COc(B . ?\x7AAE) ; <CJK>
     (?$(COd(B . ?\x828E) ; <CJK>
     (?$(COe(B . ?\x8EAC) ; <CJK>
     (?$(COf(B . ?\x5026) ; <CJK>
     (?$(COg(B . ?\x5238) ; <CJK>
     (?$(COh(B . ?\x52F8) ; <CJK>
     (?$(COi(B . ?\x5377) ; <CJK>
     (?$(COj(B . ?\x5708) ; <CJK>
     (?$(COk(B . ?\x62F3) ; <CJK>
     (?$(COl(B . ?\x6372) ; <CJK>
     (?$(COm(B . ?\x6B0A) ; <CJK>
     (?$(COn(B . ?\x6DC3) ; <CJK>
     (?$(COo(B . ?\x7737) ; <CJK>
     (?$(COp(B . ?\x53A5) ; <CJK>
     (?$(COq(B . ?\x7357) ; <CJK>
     (?$(COr(B . ?\x8568) ; <CJK>
     (?$(COs(B . ?\x8E76) ; <CJK>
     (?$(COt(B . ?\x95D5) ; <CJK>
     (?$(COu(B . ?\x673A) ; <CJK>
     (?$(COv(B . ?\x6AC3) ; <CJK>
     (?$(COw(B . ?\x6F70) ; <CJK>
     (?$(COx(B . ?\x8A6D) ; <CJK>
     (?$(COy(B . ?\x8ECC) ; <CJK>
     (?$(COz(B . ?\x994B) ; <CJK>
     (?$(CO{(B . ?\xF906) ; <CJK>
     (?$(CO|(B . ?\x6677) ; <CJK>
     (?$(CO}(B . ?\x6B78) ; <CJK>
     (?$(CO~(B . ?\x8CB4) ; <CJK>
     (?$(CP!(B . ?\x9B3C) ; <CJK>
     (?$(CP"(B . ?\xF907) ; <CJK>
     (?$(CP#(B . ?\x53EB) ; <CJK>
     (?$(CP$(B . ?\x572D) ; <CJK>
     (?$(CP%(B . ?\x594E) ; <CJK>
     (?$(CP&(B . ?\x63C6) ; <CJK>
     (?$(CP'(B . ?\x69FB) ; <CJK>
     (?$(CP((B . ?\x73EA) ; <CJK>
     (?$(CP)(B . ?\x7845) ; <CJK>
     (?$(CP*(B . ?\x7ABA) ; <CJK>
     (?$(CP+(B . ?\x7AC5) ; <CJK>
     (?$(CP,(B . ?\x7CFE) ; <CJK>
     (?$(CP-(B . ?\x8475) ; <CJK>
     (?$(CP.(B . ?\x898F) ; <CJK>
     (?$(CP/(B . ?\x8D73) ; <CJK>
     (?$(CP0(B . ?\x9035) ; <CJK>
     (?$(CP1(B . ?\x95A8) ; <CJK>
     (?$(CP2(B . ?\x52FB) ; <CJK>
     (?$(CP3(B . ?\x5747) ; <CJK>
     (?$(CP4(B . ?\x7547) ; <CJK>
     (?$(CP5(B . ?\x7B60) ; <CJK>
     (?$(CP6(B . ?\x83CC) ; <CJK>
     (?$(CP7(B . ?\x921E) ; <CJK>
     (?$(CP8(B . ?\xF908) ; <CJK>
     (?$(CP9(B . ?\x6A58) ; <CJK>
     (?$(CP:(B . ?\x514B) ; <CJK>
     (?$(CP;(B . ?\x524B) ; <CJK>
     (?$(CP<(B . ?\x5287) ; <CJK>
     (?$(CP=(B . ?\x621F) ; <CJK>
     (?$(CP>(B . ?\x68D8) ; <CJK>
     (?$(CP?(B . ?\x6975) ; <CJK>
     (?$(CP@(B . ?\x9699) ; <CJK>
     (?$(CPA(B . ?\x50C5) ; <CJK>
     (?$(CPB(B . ?\x52A4) ; <CJK>
     (?$(CPC(B . ?\x52E4) ; <CJK>
     (?$(CPD(B . ?\x61C3) ; <CJK>
     (?$(CPE(B . ?\x65A4) ; <CJK>
     (?$(CPF(B . ?\x6839) ; <CJK>
     (?$(CPG(B . ?\x69FF) ; <CJK>
     (?$(CPH(B . ?\x747E) ; <CJK>
     (?$(CPI(B . ?\x7B4B) ; <CJK>
     (?$(CPJ(B . ?\x82B9) ; <CJK>
     (?$(CPK(B . ?\x83EB) ; <CJK>
     (?$(CPL(B . ?\x89B2) ; <CJK>
     (?$(CPM(B . ?\x8B39) ; <CJK>
     (?$(CPN(B . ?\x8FD1) ; <CJK>
     (?$(CPO(B . ?\x9949) ; <CJK>
     (?$(CPP(B . ?\xF909) ; <CJK>
     (?$(CPQ(B . ?\x4ECA) ; <CJK>
     (?$(CPR(B . ?\x5997) ; <CJK>
     (?$(CPS(B . ?\x64D2) ; <CJK>
     (?$(CPT(B . ?\x6611) ; <CJK>
     (?$(CPU(B . ?\x6A8E) ; <CJK>
     (?$(CPV(B . ?\x7434) ; <CJK>
     (?$(CPW(B . ?\x7981) ; <CJK>
     (?$(CPX(B . ?\x79BD) ; <CJK>
     (?$(CPY(B . ?\x82A9) ; <CJK>
     (?$(CPZ(B . ?\x887E) ; <CJK>
     (?$(CP[(B . ?\x887F) ; <CJK>
     (?$(CP\(B . ?\x895F) ; <CJK>
     (?$(CP](B . ?\xF90A) ; <CJK>
     (?$(CP^(B . ?\x9326) ; <CJK>
     (?$(CP_(B . ?\x4F0B) ; <CJK>
     (?$(CP`(B . ?\x53CA) ; <CJK>
     (?$(CPa(B . ?\x6025) ; <CJK>
     (?$(CPb(B . ?\x6271) ; <CJK>
     (?$(CPc(B . ?\x6C72) ; <CJK>
     (?$(CPd(B . ?\x7D1A) ; <CJK>
     (?$(CPe(B . ?\x7D66) ; <CJK>
     (?$(CPf(B . ?\x4E98) ; <CJK>
     (?$(CPg(B . ?\x5162) ; <CJK>
     (?$(CPh(B . ?\x77DC) ; <CJK>
     (?$(CPi(B . ?\x80AF) ; <CJK>
     (?$(CPj(B . ?\x4F01) ; <CJK>
     (?$(CPk(B . ?\x4F0E) ; <CJK>
     (?$(CPl(B . ?\x5176) ; <CJK>
     (?$(CPm(B . ?\x5180) ; <CJK>
     (?$(CPn(B . ?\x55DC) ; <CJK>
     (?$(CPo(B . ?\x5668) ; <CJK>
     (?$(CPp(B . ?\x573B) ; <CJK>
     (?$(CPq(B . ?\x57FA) ; <CJK>
     (?$(CPr(B . ?\x57FC) ; <CJK>
     (?$(CPs(B . ?\x5914) ; <CJK>
     (?$(CPt(B . ?\x5947) ; <CJK>
     (?$(CPu(B . ?\x5993) ; <CJK>
     (?$(CPv(B . ?\x5BC4) ; <CJK>
     (?$(CPw(B . ?\x5C90) ; <CJK>
     (?$(CPx(B . ?\x5D0E) ; <CJK>
     (?$(CPy(B . ?\x5DF1) ; <CJK>
     (?$(CPz(B . ?\x5E7E) ; <CJK>
     (?$(CP{(B . ?\x5FCC) ; <CJK>
     (?$(CP|(B . ?\x6280) ; <CJK>
     (?$(CP}(B . ?\x65D7) ; <CJK>
     (?$(CP~(B . ?\x65E3) ; <CJK>
     (?$(CQ!(B . ?\x671E) ; <CJK>
     (?$(CQ"(B . ?\x671F) ; <CJK>
     (?$(CQ#(B . ?\x675E) ; <CJK>
     (?$(CQ$(B . ?\x68CB) ; <CJK>
     (?$(CQ%(B . ?\x68C4) ; <CJK>
     (?$(CQ&(B . ?\x6A5F) ; <CJK>
     (?$(CQ'(B . ?\x6B3A) ; <CJK>
     (?$(CQ((B . ?\x6C23) ; <CJK>
     (?$(CQ)(B . ?\x6C7D) ; <CJK>
     (?$(CQ*(B . ?\x6C82) ; <CJK>
     (?$(CQ+(B . ?\x6DC7) ; <CJK>
     (?$(CQ,(B . ?\x7398) ; <CJK>
     (?$(CQ-(B . ?\x7426) ; <CJK>
     (?$(CQ.(B . ?\x742A) ; <CJK>
     (?$(CQ/(B . ?\x7482) ; <CJK>
     (?$(CQ0(B . ?\x74A3) ; <CJK>
     (?$(CQ1(B . ?\x7578) ; <CJK>
     (?$(CQ2(B . ?\x757F) ; <CJK>
     (?$(CQ3(B . ?\x7881) ; <CJK>
     (?$(CQ4(B . ?\x78EF) ; <CJK>
     (?$(CQ5(B . ?\x7941) ; <CJK>
     (?$(CQ6(B . ?\x7947) ; <CJK>
     (?$(CQ7(B . ?\x7948) ; <CJK>
     (?$(CQ8(B . ?\x797A) ; <CJK>
     (?$(CQ9(B . ?\x7B95) ; <CJK>
     (?$(CQ:(B . ?\x7D00) ; <CJK>
     (?$(CQ;(B . ?\x7DBA) ; <CJK>
     (?$(CQ<(B . ?\x7F88) ; <CJK>
     (?$(CQ=(B . ?\x8006) ; <CJK>
     (?$(CQ>(B . ?\x802D) ; <CJK>
     (?$(CQ?(B . ?\x808C) ; <CJK>
     (?$(CQ@(B . ?\x8A18) ; <CJK>
     (?$(CQA(B . ?\x8B4F) ; <CJK>
     (?$(CQB(B . ?\x8C48) ; <CJK>
     (?$(CQC(B . ?\x8D77) ; <CJK>
     (?$(CQD(B . ?\x9321) ; <CJK>
     (?$(CQE(B . ?\x9324) ; <CJK>
     (?$(CQF(B . ?\x98E2) ; <CJK>
     (?$(CQG(B . ?\x9951) ; <CJK>
     (?$(CQH(B . ?\x9A0E) ; <CJK>
     (?$(CQI(B . ?\x9A0F) ; <CJK>
     (?$(CQJ(B . ?\x9A65) ; <CJK>
     (?$(CQK(B . ?\x9E92) ; <CJK>
     (?$(CQL(B . ?\x7DCA) ; <CJK>
     (?$(CQM(B . ?\x4F76) ; <CJK>
     (?$(CQN(B . ?\x5409) ; <CJK>
     (?$(CQO(B . ?\x62EE) ; <CJK>
     (?$(CQP(B . ?\x6854) ; <CJK>
     (?$(CQQ(B . ?\x91D1) ; <CJK>
     (?$(CQR(B . ?\x55AB) ; <CJK>
     (?$(CQS(B . ?\x513A) ; <CJK>
     (?$(CQT(B . ?\xF90B) ; <CJK>
     (?$(CQU(B . ?\xF90C) ; <CJK>
     (?$(CQV(B . ?\x5A1C) ; <CJK>
     (?$(CQW(B . ?\x61E6) ; <CJK>
     (?$(CQX(B . ?\xF90D) ; <CJK>
     (?$(CQY(B . ?\x62CF) ; <CJK>
     (?$(CQZ(B . ?\x62FF) ; <CJK>
     (?$(CQ[(B . ?\xF90E) ; <CJK>
     (?$(CQ\(B . ?\xF90F) ; <CJK>
     (?$(CQ](B . ?\xF910) ; <CJK>
     (?$(CQ^(B . ?\xF911) ; <CJK>
     (?$(CQ_(B . ?\xF912) ; <CJK>
     (?$(CQ`(B . ?\xF913) ; <CJK>
     (?$(CQa(B . ?\x90A3) ; <CJK>
     (?$(CQb(B . ?\xF914) ; <CJK>
     (?$(CQc(B . ?\xF915) ; <CJK>
     (?$(CQd(B . ?\xF916) ; <CJK>
     (?$(CQe(B . ?\xF917) ; <CJK>
     (?$(CQf(B . ?\xF918) ; <CJK>
     (?$(CQg(B . ?\x8AFE) ; <CJK>
     (?$(CQh(B . ?\xF919) ; <CJK>
     (?$(CQi(B . ?\xF91A) ; <CJK>
     (?$(CQj(B . ?\xF91B) ; <CJK>
     (?$(CQk(B . ?\xF91C) ; <CJK>
     (?$(CQl(B . ?\x6696) ; <CJK>
     (?$(CQm(B . ?\xF91D) ; <CJK>
     (?$(CQn(B . ?\x7156) ; <CJK>
     (?$(CQo(B . ?\xF91E) ; <CJK>
     (?$(CQp(B . ?\xF91F) ; <CJK>
     (?$(CQq(B . ?\x96E3) ; <CJK>
     (?$(CQr(B . ?\xF920) ; <CJK>
     (?$(CQs(B . ?\x634F) ; <CJK>
     (?$(CQt(B . ?\x637A) ; <CJK>
     (?$(CQu(B . ?\x5357) ; <CJK>
     (?$(CQv(B . ?\xF921) ; <CJK>
     (?$(CQw(B . ?\x678F) ; <CJK>
     (?$(CQx(B . ?\x6960) ; <CJK>
     (?$(CQy(B . ?\x6E73) ; <CJK>
     (?$(CQz(B . ?\xF922) ; <CJK>
     (?$(CQ{(B . ?\x7537) ; <CJK>
     (?$(CQ|(B . ?\xF923) ; <CJK>
     (?$(CQ}(B . ?\xF924) ; <CJK>
     (?$(CQ~(B . ?\xF925) ; <CJK>
     (?$(CR!(B . ?\x7D0D) ; <CJK>
     (?$(CR"(B . ?\xF926) ; <CJK>
     (?$(CR#(B . ?\xF927) ; <CJK>
     (?$(CR$(B . ?\x8872) ; <CJK>
     (?$(CR%(B . ?\x56CA) ; <CJK>
     (?$(CR&(B . ?\x5A18) ; <CJK>
     (?$(CR'(B . ?\xF928) ; <CJK>
     (?$(CR((B . ?\xF929) ; <CJK>
     (?$(CR)(B . ?\xF92A) ; <CJK>
     (?$(CR*(B . ?\xF92B) ; <CJK>
     (?$(CR+(B . ?\xF92C) ; <CJK>
     (?$(CR,(B . ?\x4E43) ; <CJK>
     (?$(CR-(B . ?\xF92D) ; <CJK>
     (?$(CR.(B . ?\x5167) ; <CJK>
     (?$(CR/(B . ?\x5948) ; <CJK>
     (?$(CR0(B . ?\x67F0) ; <CJK>
     (?$(CR1(B . ?\x8010) ; <CJK>
     (?$(CR2(B . ?\xF92E) ; <CJK>
     (?$(CR3(B . ?\x5973) ; <CJK>
     (?$(CR4(B . ?\x5E74) ; <CJK>
     (?$(CR5(B . ?\x649A) ; <CJK>
     (?$(CR6(B . ?\x79CA) ; <CJK>
     (?$(CR7(B . ?\x5FF5) ; <CJK>
     (?$(CR8(B . ?\x606C) ; <CJK>
     (?$(CR9(B . ?\x62C8) ; <CJK>
     (?$(CR:(B . ?\x637B) ; <CJK>
     (?$(CR;(B . ?\x5BE7) ; <CJK>
     (?$(CR<(B . ?\x5BD7) ; <CJK>
     (?$(CR=(B . ?\x52AA) ; <CJK>
     (?$(CR>(B . ?\xF92F) ; <CJK>
     (?$(CR?(B . ?\x5974) ; <CJK>
     (?$(CR@(B . ?\x5F29) ; <CJK>
     (?$(CRA(B . ?\x6012) ; <CJK>
     (?$(CRB(B . ?\xF930) ; <CJK>
     (?$(CRC(B . ?\xF931) ; <CJK>
     (?$(CRD(B . ?\xF932) ; <CJK>
     (?$(CRE(B . ?\x7459) ; <CJK>
     (?$(CRF(B . ?\xF933) ; <CJK>
     (?$(CRG(B . ?\xF934) ; <CJK>
     (?$(CRH(B . ?\xF935) ; <CJK>
     (?$(CRI(B . ?\xF936) ; <CJK>
     (?$(CRJ(B . ?\xF937) ; <CJK>
     (?$(CRK(B . ?\xF938) ; <CJK>
     (?$(CRL(B . ?\x99D1) ; <CJK>
     (?$(CRM(B . ?\xF939) ; <CJK>
     (?$(CRN(B . ?\xF93A) ; <CJK>
     (?$(CRO(B . ?\xF93B) ; <CJK>
     (?$(CRP(B . ?\xF93C) ; <CJK>
     (?$(CRQ(B . ?\xF93D) ; <CJK>
     (?$(CRR(B . ?\xF93E) ; <CJK>
     (?$(CRS(B . ?\xF93F) ; <CJK>
     (?$(CRT(B . ?\xF940) ; <CJK>
     (?$(CRU(B . ?\xF941) ; <CJK>
     (?$(CRV(B . ?\xF942) ; <CJK>
     (?$(CRW(B . ?\xF943) ; <CJK>
     (?$(CRX(B . ?\x6FC3) ; <CJK>
     (?$(CRY(B . ?\xF944) ; <CJK>
     (?$(CRZ(B . ?\xF945) ; <CJK>
     (?$(CR[(B . ?\x81BF) ; <CJK>
     (?$(CR\(B . ?\x8FB2) ; <CJK>
     (?$(CR](B . ?\x60F1) ; <CJK>
     (?$(CR^(B . ?\xF946) ; <CJK>
     (?$(CR_(B . ?\xF947) ; <CJK>
     (?$(CR`(B . ?\x8166) ; <CJK>
     (?$(CRa(B . ?\xF948) ; <CJK>
     (?$(CRb(B . ?\xF949) ; <CJK>
     (?$(CRc(B . ?\x5C3F) ; <CJK>
     (?$(CRd(B . ?\xF94A) ; <CJK>
     (?$(CRe(B . ?\xF94B) ; <CJK>
     (?$(CRf(B . ?\xF94C) ; <CJK>
     (?$(CRg(B . ?\xF94D) ; <CJK>
     (?$(CRh(B . ?\xF94E) ; <CJK>
     (?$(CRi(B . ?\xF94F) ; <CJK>
     (?$(CRj(B . ?\xF950) ; <CJK>
     (?$(CRk(B . ?\xF951) ; <CJK>
     (?$(CRl(B . ?\x5AE9) ; <CJK>
     (?$(CRm(B . ?\x8A25) ; <CJK>
     (?$(CRn(B . ?\x677B) ; <CJK>
     (?$(CRo(B . ?\x7D10) ; <CJK>
     (?$(CRp(B . ?\xF952) ; <CJK>
     (?$(CRq(B . ?\xF953) ; <CJK>
     (?$(CRr(B . ?\xF954) ; <CJK>
     (?$(CRs(B . ?\xF955) ; <CJK>
     (?$(CRt(B . ?\xF956) ; <CJK>
     (?$(CRu(B . ?\xF957) ; <CJK>
     (?$(CRv(B . ?\x80FD) ; <CJK>
     (?$(CRw(B . ?\xF958) ; <CJK>
     (?$(CRx(B . ?\xF959) ; <CJK>
     (?$(CRy(B . ?\x5C3C) ; <CJK>
     (?$(CRz(B . ?\x6CE5) ; <CJK>
     (?$(CR{(B . ?\x533F) ; <CJK>
     (?$(CR|(B . ?\x6EBA) ; <CJK>
     (?$(CR}(B . ?\x591A) ; <CJK>
     (?$(CR~(B . ?\x8336) ; <CJK>
     (?$(CS!(B . ?\x4E39) ; <CJK>
     (?$(CS"(B . ?\x4EB6) ; <CJK>
     (?$(CS#(B . ?\x4F46) ; <CJK>
     (?$(CS$(B . ?\x55AE) ; <CJK>
     (?$(CS%(B . ?\x5718) ; <CJK>
     (?$(CS&(B . ?\x58C7) ; <CJK>
     (?$(CS'(B . ?\x5F56) ; <CJK>
     (?$(CS((B . ?\x65B7) ; <CJK>
     (?$(CS)(B . ?\x65E6) ; <CJK>
     (?$(CS*(B . ?\x6A80) ; <CJK>
     (?$(CS+(B . ?\x6BB5) ; <CJK>
     (?$(CS,(B . ?\x6E4D) ; <CJK>
     (?$(CS-(B . ?\x77ED) ; <CJK>
     (?$(CS.(B . ?\x7AEF) ; <CJK>
     (?$(CS/(B . ?\x7C1E) ; <CJK>
     (?$(CS0(B . ?\x7DDE) ; <CJK>
     (?$(CS1(B . ?\x86CB) ; <CJK>
     (?$(CS2(B . ?\x8892) ; <CJK>
     (?$(CS3(B . ?\x9132) ; <CJK>
     (?$(CS4(B . ?\x935B) ; <CJK>
     (?$(CS5(B . ?\x64BB) ; <CJK>
     (?$(CS6(B . ?\x6FBE) ; <CJK>
     (?$(CS7(B . ?\x737A) ; <CJK>
     (?$(CS8(B . ?\x75B8) ; <CJK>
     (?$(CS9(B . ?\x9054) ; <CJK>
     (?$(CS:(B . ?\x5556) ; <CJK>
     (?$(CS;(B . ?\x574D) ; <CJK>
     (?$(CS<(B . ?\x61BA) ; <CJK>
     (?$(CS=(B . ?\x64D4) ; <CJK>
     (?$(CS>(B . ?\x66C7) ; <CJK>
     (?$(CS?(B . ?\x6DE1) ; <CJK>
     (?$(CS@(B . ?\x6E5B) ; <CJK>
     (?$(CSA(B . ?\x6F6D) ; <CJK>
     (?$(CSB(B . ?\x6FB9) ; <CJK>
     (?$(CSC(B . ?\x75F0) ; <CJK>
     (?$(CSD(B . ?\x8043) ; <CJK>
     (?$(CSE(B . ?\x81BD) ; <CJK>
     (?$(CSF(B . ?\x8541) ; <CJK>
     (?$(CSG(B . ?\x8983) ; <CJK>
     (?$(CSH(B . ?\x8AC7) ; <CJK>
     (?$(CSI(B . ?\x8B5A) ; <CJK>
     (?$(CSJ(B . ?\x931F) ; <CJK>
     (?$(CSK(B . ?\x6C93) ; <CJK>
     (?$(CSL(B . ?\x7553) ; <CJK>
     (?$(CSM(B . ?\x7B54) ; <CJK>
     (?$(CSN(B . ?\x8E0F) ; <CJK>
     (?$(CSO(B . ?\x905D) ; <CJK>
     (?$(CSP(B . ?\x5510) ; <CJK>
     (?$(CSQ(B . ?\x5802) ; <CJK>
     (?$(CSR(B . ?\x5858) ; <CJK>
     (?$(CSS(B . ?\x5E62) ; <CJK>
     (?$(CST(B . ?\x6207) ; <CJK>
     (?$(CSU(B . ?\x649E) ; <CJK>
     (?$(CSV(B . ?\x68E0) ; <CJK>
     (?$(CSW(B . ?\x7576) ; <CJK>
     (?$(CSX(B . ?\x7CD6) ; <CJK>
     (?$(CSY(B . ?\x87B3) ; <CJK>
     (?$(CSZ(B . ?\x9EE8) ; <CJK>
     (?$(CS[(B . ?\x4EE3) ; <CJK>
     (?$(CS\(B . ?\x5788) ; <CJK>
     (?$(CS](B . ?\x576E) ; <CJK>
     (?$(CS^(B . ?\x5927) ; <CJK>
     (?$(CS_(B . ?\x5C0D) ; <CJK>
     (?$(CS`(B . ?\x5CB1) ; <CJK>
     (?$(CSa(B . ?\x5E36) ; <CJK>
     (?$(CSb(B . ?\x5F85) ; <CJK>
     (?$(CSc(B . ?\x6234) ; <CJK>
     (?$(CSd(B . ?\x64E1) ; <CJK>
     (?$(CSe(B . ?\x73B3) ; <CJK>
     (?$(CSf(B . ?\x81FA) ; <CJK>
     (?$(CSg(B . ?\x888B) ; <CJK>
     (?$(CSh(B . ?\x8CB8) ; <CJK>
     (?$(CSi(B . ?\x968A) ; <CJK>
     (?$(CSj(B . ?\x9EDB) ; <CJK>
     (?$(CSk(B . ?\x5B85) ; <CJK>
     (?$(CSl(B . ?\x5FB7) ; <CJK>
     (?$(CSm(B . ?\x60B3) ; <CJK>
     (?$(CSn(B . ?\x5012) ; <CJK>
     (?$(CSo(B . ?\x5200) ; <CJK>
     (?$(CSp(B . ?\x5230) ; <CJK>
     (?$(CSq(B . ?\x5716) ; <CJK>
     (?$(CSr(B . ?\x5835) ; <CJK>
     (?$(CSs(B . ?\x5857) ; <CJK>
     (?$(CSt(B . ?\x5C0E) ; <CJK>
     (?$(CSu(B . ?\x5C60) ; <CJK>
     (?$(CSv(B . ?\x5CF6) ; <CJK>
     (?$(CSw(B . ?\x5D8B) ; <CJK>
     (?$(CSx(B . ?\x5EA6) ; <CJK>
     (?$(CSy(B . ?\x5F92) ; <CJK>
     (?$(CSz(B . ?\x60BC) ; <CJK>
     (?$(CS{(B . ?\x6311) ; <CJK>
     (?$(CS|(B . ?\x6389) ; <CJK>
     (?$(CS}(B . ?\x6417) ; <CJK>
     (?$(CS~(B . ?\x6843) ; <CJK>
     (?$(CT!(B . ?\x68F9) ; <CJK>
     (?$(CT"(B . ?\x6AC2) ; <CJK>
     (?$(CT#(B . ?\x6DD8) ; <CJK>
     (?$(CT$(B . ?\x6E21) ; <CJK>
     (?$(CT%(B . ?\x6ED4) ; <CJK>
     (?$(CT&(B . ?\x6FE4) ; <CJK>
     (?$(CT'(B . ?\x71FE) ; <CJK>
     (?$(CT((B . ?\x76DC) ; <CJK>
     (?$(CT)(B . ?\x7779) ; <CJK>
     (?$(CT*(B . ?\x79B1) ; <CJK>
     (?$(CT+(B . ?\x7A3B) ; <CJK>
     (?$(CT,(B . ?\x8404) ; <CJK>
     (?$(CT-(B . ?\x89A9) ; <CJK>
     (?$(CT.(B . ?\x8CED) ; <CJK>
     (?$(CT/(B . ?\x8DF3) ; <CJK>
     (?$(CT0(B . ?\x8E48) ; <CJK>
     (?$(CT1(B . ?\x9003) ; <CJK>
     (?$(CT2(B . ?\x9014) ; <CJK>
     (?$(CT3(B . ?\x9053) ; <CJK>
     (?$(CT4(B . ?\x90FD) ; <CJK>
     (?$(CT5(B . ?\x934D) ; <CJK>
     (?$(CT6(B . ?\x9676) ; <CJK>
     (?$(CT7(B . ?\x97DC) ; <CJK>
     (?$(CT8(B . ?\x6BD2) ; <CJK>
     (?$(CT9(B . ?\x7006) ; <CJK>
     (?$(CT:(B . ?\x7258) ; <CJK>
     (?$(CT;(B . ?\x72A2) ; <CJK>
     (?$(CT<(B . ?\x7368) ; <CJK>
     (?$(CT=(B . ?\x7763) ; <CJK>
     (?$(CT>(B . ?\x79BF) ; <CJK>
     (?$(CT?(B . ?\x7BE4) ; <CJK>
     (?$(CT@(B . ?\x7E9B) ; <CJK>
     (?$(CTA(B . ?\x8B80) ; <CJK>
     (?$(CTB(B . ?\x58A9) ; <CJK>
     (?$(CTC(B . ?\x60C7) ; <CJK>
     (?$(CTD(B . ?\x6566) ; <CJK>
     (?$(CTE(B . ?\x65FD) ; <CJK>
     (?$(CTF(B . ?\x66BE) ; <CJK>
     (?$(CTG(B . ?\x6C8C) ; <CJK>
     (?$(CTH(B . ?\x711E) ; <CJK>
     (?$(CTI(B . ?\x71C9) ; <CJK>
     (?$(CTJ(B . ?\x8C5A) ; <CJK>
     (?$(CTK(B . ?\x9813) ; <CJK>
     (?$(CTL(B . ?\x4E6D) ; <CJK>
     (?$(CTM(B . ?\x7A81) ; <CJK>
     (?$(CTN(B . ?\x4EDD) ; <CJK>
     (?$(CTO(B . ?\x51AC) ; <CJK>
     (?$(CTP(B . ?\x51CD) ; <CJK>
     (?$(CTQ(B . ?\x52D5) ; <CJK>
     (?$(CTR(B . ?\x540C) ; <CJK>
     (?$(CTS(B . ?\x61A7) ; <CJK>
     (?$(CTT(B . ?\x6771) ; <CJK>
     (?$(CTU(B . ?\x6850) ; <CJK>
     (?$(CTV(B . ?\x68DF) ; <CJK>
     (?$(CTW(B . ?\x6D1E) ; <CJK>
     (?$(CTX(B . ?\x6F7C) ; <CJK>
     (?$(CTY(B . ?\x75BC) ; <CJK>
     (?$(CTZ(B . ?\x77B3) ; <CJK>
     (?$(CT[(B . ?\x7AE5) ; <CJK>
     (?$(CT\(B . ?\x80F4) ; <CJK>
     (?$(CT](B . ?\x8463) ; <CJK>
     (?$(CT^(B . ?\x9285) ; <CJK>
     (?$(CT_(B . ?\x515C) ; <CJK>
     (?$(CT`(B . ?\x6597) ; <CJK>
     (?$(CTa(B . ?\x675C) ; <CJK>
     (?$(CTb(B . ?\x6793) ; <CJK>
     (?$(CTc(B . ?\x75D8) ; <CJK>
     (?$(CTd(B . ?\x7AC7) ; <CJK>
     (?$(CTe(B . ?\x8373) ; <CJK>
     (?$(CTf(B . ?\xF95A) ; <CJK>
     (?$(CTg(B . ?\x8C46) ; <CJK>
     (?$(CTh(B . ?\x9017) ; <CJK>
     (?$(CTi(B . ?\x982D) ; <CJK>
     (?$(CTj(B . ?\x5C6F) ; <CJK>
     (?$(CTk(B . ?\x81C0) ; <CJK>
     (?$(CTl(B . ?\x829A) ; <CJK>
     (?$(CTm(B . ?\x9041) ; <CJK>
     (?$(CTn(B . ?\x906F) ; <CJK>
     (?$(CTo(B . ?\x920D) ; <CJK>
     (?$(CTp(B . ?\x5F97) ; <CJK>
     (?$(CTq(B . ?\x5D9D) ; <CJK>
     (?$(CTr(B . ?\x6A59) ; <CJK>
     (?$(CTs(B . ?\x71C8) ; <CJK>
     (?$(CTt(B . ?\x767B) ; <CJK>
     (?$(CTu(B . ?\x7B49) ; <CJK>
     (?$(CTv(B . ?\x85E4) ; <CJK>
     (?$(CTw(B . ?\x8B04) ; <CJK>
     (?$(CTx(B . ?\x9127) ; <CJK>
     (?$(CTy(B . ?\x9A30) ; <CJK>
     (?$(CTz(B . ?\x5587) ; <CJK>
     (?$(CT{(B . ?\x61F6) ; <CJK>
     (?$(CT|(B . ?\xF95B) ; <CJK>
     (?$(CT}(B . ?\x7669) ; <CJK>
     (?$(CT~(B . ?\x7F85) ; <CJK>
     (?$(CU!(B . ?\x863F) ; <CJK>
     (?$(CU"(B . ?\x87BA) ; <CJK>
     (?$(CU#(B . ?\x88F8) ; <CJK>
     (?$(CU$(B . ?\x908F) ; <CJK>
     (?$(CU%(B . ?\xF95C) ; <CJK>
     (?$(CU&(B . ?\x6D1B) ; <CJK>
     (?$(CU'(B . ?\x70D9) ; <CJK>
     (?$(CU((B . ?\x73DE) ; <CJK>
     (?$(CU)(B . ?\x7D61) ; <CJK>
     (?$(CU*(B . ?\x843D) ; <CJK>
     (?$(CU+(B . ?\xF95D) ; <CJK>
     (?$(CU,(B . ?\x916A) ; <CJK>
     (?$(CU-(B . ?\x99F1) ; <CJK>
     (?$(CU.(B . ?\xF95E) ; <CJK>
     (?$(CU/(B . ?\x4E82) ; <CJK>
     (?$(CU0(B . ?\x5375) ; <CJK>
     (?$(CU1(B . ?\x6B04) ; <CJK>
     (?$(CU2(B . ?\x6B12) ; <CJK>
     (?$(CU3(B . ?\x703E) ; <CJK>
     (?$(CU4(B . ?\x721B) ; <CJK>
     (?$(CU5(B . ?\x862D) ; <CJK>
     (?$(CU6(B . ?\x9E1E) ; <CJK>
     (?$(CU7(B . ?\x524C) ; <CJK>
     (?$(CU8(B . ?\x8FA3) ; <CJK>
     (?$(CU9(B . ?\x5D50) ; <CJK>
     (?$(CU:(B . ?\x64E5) ; <CJK>
     (?$(CU;(B . ?\x652C) ; <CJK>
     (?$(CU<(B . ?\x6B16) ; <CJK>
     (?$(CU=(B . ?\x6FEB) ; <CJK>
     (?$(CU>(B . ?\x7C43) ; <CJK>
     (?$(CU?(B . ?\x7E9C) ; <CJK>
     (?$(CU@(B . ?\x85CD) ; <CJK>
     (?$(CUA(B . ?\x8964) ; <CJK>
     (?$(CUB(B . ?\x89BD) ; <CJK>
     (?$(CUC(B . ?\x62C9) ; <CJK>
     (?$(CUD(B . ?\x81D8) ; <CJK>
     (?$(CUE(B . ?\x881F) ; <CJK>
     (?$(CUF(B . ?\x5ECA) ; <CJK>
     (?$(CUG(B . ?\x6717) ; <CJK>
     (?$(CUH(B . ?\x6D6A) ; <CJK>
     (?$(CUI(B . ?\x72FC) ; <CJK>
     (?$(CUJ(B . ?\x7405) ; <CJK>
     (?$(CUK(B . ?\x746F) ; <CJK>
     (?$(CUL(B . ?\x8782) ; <CJK>
     (?$(CUM(B . ?\x90DE) ; <CJK>
     (?$(CUN(B . ?\x4F86) ; <CJK>
     (?$(CUO(B . ?\x5D0D) ; <CJK>
     (?$(CUP(B . ?\x5FA0) ; <CJK>
     (?$(CUQ(B . ?\x840A) ; <CJK>
     (?$(CUR(B . ?\x51B7) ; <CJK>
     (?$(CUS(B . ?\x63A0) ; <CJK>
     (?$(CUT(B . ?\x7565) ; <CJK>
     (?$(CUU(B . ?\x4EAE) ; <CJK>
     (?$(CUV(B . ?\x5006) ; <CJK>
     (?$(CUW(B . ?\x5169) ; <CJK>
     (?$(CUX(B . ?\x51C9) ; <CJK>
     (?$(CUY(B . ?\x6881) ; <CJK>
     (?$(CUZ(B . ?\x6A11) ; <CJK>
     (?$(CU[(B . ?\x7CAE) ; <CJK>
     (?$(CU\(B . ?\x7CB1) ; <CJK>
     (?$(CU](B . ?\x7CE7) ; <CJK>
     (?$(CU^(B . ?\x826F) ; <CJK>
     (?$(CU_(B . ?\x8AD2) ; <CJK>
     (?$(CU`(B . ?\x8F1B) ; <CJK>
     (?$(CUa(B . ?\x91CF) ; <CJK>
     (?$(CUb(B . ?\x4FB6) ; <CJK>
     (?$(CUc(B . ?\x5137) ; <CJK>
     (?$(CUd(B . ?\x52F5) ; <CJK>
     (?$(CUe(B . ?\x5442) ; <CJK>
     (?$(CUf(B . ?\x5EEC) ; <CJK>
     (?$(CUg(B . ?\x616E) ; <CJK>
     (?$(CUh(B . ?\x623E) ; <CJK>
     (?$(CUi(B . ?\x65C5) ; <CJK>
     (?$(CUj(B . ?\x6ADA) ; <CJK>
     (?$(CUk(B . ?\x6FFE) ; <CJK>
     (?$(CUl(B . ?\x792A) ; <CJK>
     (?$(CUm(B . ?\x85DC) ; <CJK>
     (?$(CUn(B . ?\x8823) ; <CJK>
     (?$(CUo(B . ?\x95AD) ; <CJK>
     (?$(CUp(B . ?\x9A62) ; <CJK>
     (?$(CUq(B . ?\x9A6A) ; <CJK>
     (?$(CUr(B . ?\x9E97) ; <CJK>
     (?$(CUs(B . ?\x9ECE) ; <CJK>
     (?$(CUt(B . ?\x529B) ; <CJK>
     (?$(CUu(B . ?\x66C6) ; <CJK>
     (?$(CUv(B . ?\x6B77) ; <CJK>
     (?$(CUw(B . ?\x701D) ; <CJK>
     (?$(CUx(B . ?\x792B) ; <CJK>
     (?$(CUy(B . ?\x8F62) ; <CJK>
     (?$(CUz(B . ?\x9742) ; <CJK>
     (?$(CU{(B . ?\x6190) ; <CJK>
     (?$(CU|(B . ?\x6200) ; <CJK>
     (?$(CU}(B . ?\x6523) ; <CJK>
     (?$(CU~(B . ?\x6F23) ; <CJK>
     (?$(CV!(B . ?\x7149) ; <CJK>
     (?$(CV"(B . ?\x7489) ; <CJK>
     (?$(CV#(B . ?\x7DF4) ; <CJK>
     (?$(CV$(B . ?\x806F) ; <CJK>
     (?$(CV%(B . ?\x84EE) ; <CJK>
     (?$(CV&(B . ?\x8F26) ; <CJK>
     (?$(CV'(B . ?\x9023) ; <CJK>
     (?$(CV((B . ?\x934A) ; <CJK>
     (?$(CV)(B . ?\x51BD) ; <CJK>
     (?$(CV*(B . ?\x5217) ; <CJK>
     (?$(CV+(B . ?\x52A3) ; <CJK>
     (?$(CV,(B . ?\x6D0C) ; <CJK>
     (?$(CV-(B . ?\x70C8) ; <CJK>
     (?$(CV.(B . ?\x88C2) ; <CJK>
     (?$(CV/(B . ?\x5EC9) ; <CJK>
     (?$(CV0(B . ?\x6582) ; <CJK>
     (?$(CV1(B . ?\x6BAE) ; <CJK>
     (?$(CV2(B . ?\x6FC2) ; <CJK>
     (?$(CV3(B . ?\x7C3E) ; <CJK>
     (?$(CV4(B . ?\x7375) ; <CJK>
     (?$(CV5(B . ?\x4EE4) ; <CJK>
     (?$(CV6(B . ?\x4F36) ; <CJK>
     (?$(CV7(B . ?\x56F9) ; <CJK>
     (?$(CV8(B . ?\xF95F) ; <CJK>
     (?$(CV9(B . ?\x5CBA) ; <CJK>
     (?$(CV:(B . ?\x5DBA) ; <CJK>
     (?$(CV;(B . ?\x601C) ; <CJK>
     (?$(CV<(B . ?\x73B2) ; <CJK>
     (?$(CV=(B . ?\x7B2D) ; <CJK>
     (?$(CV>(B . ?\x7F9A) ; <CJK>
     (?$(CV?(B . ?\x7FCE) ; <CJK>
     (?$(CV@(B . ?\x8046) ; <CJK>
     (?$(CVA(B . ?\x901E) ; <CJK>
     (?$(CVB(B . ?\x9234) ; <CJK>
     (?$(CVC(B . ?\x96F6) ; <CJK>
     (?$(CVD(B . ?\x9748) ; <CJK>
     (?$(CVE(B . ?\x9818) ; <CJK>
     (?$(CVF(B . ?\x9F61) ; <CJK>
     (?$(CVG(B . ?\x4F8B) ; <CJK>
     (?$(CVH(B . ?\x6FA7) ; <CJK>
     (?$(CVI(B . ?\x79AE) ; <CJK>
     (?$(CVJ(B . ?\x91B4) ; <CJK>
     (?$(CVK(B . ?\x96B7) ; <CJK>
     (?$(CVL(B . ?\x52DE) ; <CJK>
     (?$(CVM(B . ?\xF960) ; <CJK>
     (?$(CVN(B . ?\x6488) ; <CJK>
     (?$(CVO(B . ?\x64C4) ; <CJK>
     (?$(CVP(B . ?\x6AD3) ; <CJK>
     (?$(CVQ(B . ?\x6F5E) ; <CJK>
     (?$(CVR(B . ?\x7018) ; <CJK>
     (?$(CVS(B . ?\x7210) ; <CJK>
     (?$(CVT(B . ?\x76E7) ; <CJK>
     (?$(CVU(B . ?\x8001) ; <CJK>
     (?$(CVV(B . ?\x8606) ; <CJK>
     (?$(CVW(B . ?\x865C) ; <CJK>
     (?$(CVX(B . ?\x8DEF) ; <CJK>
     (?$(CVY(B . ?\x8F05) ; <CJK>
     (?$(CVZ(B . ?\x9732) ; <CJK>
     (?$(CV[(B . ?\x9B6F) ; <CJK>
     (?$(CV\(B . ?\x9DFA) ; <CJK>
     (?$(CV](B . ?\x9E75) ; <CJK>
     (?$(CV^(B . ?\x788C) ; <CJK>
     (?$(CV_(B . ?\x797F) ; <CJK>
     (?$(CV`(B . ?\x7DA0) ; <CJK>
     (?$(CVa(B . ?\x83C9) ; <CJK>
     (?$(CVb(B . ?\x9304) ; <CJK>
     (?$(CVc(B . ?\x9E7F) ; <CJK>
     (?$(CVd(B . ?\x9E93) ; <CJK>
     (?$(CVe(B . ?\x8AD6) ; <CJK>
     (?$(CVf(B . ?\x58DF) ; <CJK>
     (?$(CVg(B . ?\x5F04) ; <CJK>
     (?$(CVh(B . ?\x6727) ; <CJK>
     (?$(CVi(B . ?\x7027) ; <CJK>
     (?$(CVj(B . ?\x74CF) ; <CJK>
     (?$(CVk(B . ?\x7C60) ; <CJK>
     (?$(CVl(B . ?\x807E) ; <CJK>
     (?$(CVm(B . ?\x5121) ; <CJK>
     (?$(CVn(B . ?\x7028) ; <CJK>
     (?$(CVo(B . ?\x7262) ; <CJK>
     (?$(CVp(B . ?\x78CA) ; <CJK>
     (?$(CVq(B . ?\x8CC2) ; <CJK>
     (?$(CVr(B . ?\x8CDA) ; <CJK>
     (?$(CVs(B . ?\x8CF4) ; <CJK>
     (?$(CVt(B . ?\x96F7) ; <CJK>
     (?$(CVu(B . ?\x4E86) ; <CJK>
     (?$(CVv(B . ?\x50DA) ; <CJK>
     (?$(CVw(B . ?\x5BEE) ; <CJK>
     (?$(CVx(B . ?\x5ED6) ; <CJK>
     (?$(CVy(B . ?\x6599) ; <CJK>
     (?$(CVz(B . ?\x71CE) ; <CJK>
     (?$(CV{(B . ?\x7642) ; <CJK>
     (?$(CV|(B . ?\x77AD) ; <CJK>
     (?$(CV}(B . ?\x804A) ; <CJK>
     (?$(CV~(B . ?\x84FC) ; <CJK>
     (?$(CW!(B . ?\x907C) ; <CJK>
     (?$(CW"(B . ?\x9B27) ; <CJK>
     (?$(CW#(B . ?\x9F8D) ; <CJK>
     (?$(CW$(B . ?\x58D8) ; <CJK>
     (?$(CW%(B . ?\x5A41) ; <CJK>
     (?$(CW&(B . ?\x5C62) ; <CJK>
     (?$(CW'(B . ?\x6A13) ; <CJK>
     (?$(CW((B . ?\x6DDA) ; <CJK>
     (?$(CW)(B . ?\x6F0F) ; <CJK>
     (?$(CW*(B . ?\x763B) ; <CJK>
     (?$(CW+(B . ?\x7D2F) ; <CJK>
     (?$(CW,(B . ?\x7E37) ; <CJK>
     (?$(CW-(B . ?\x851E) ; <CJK>
     (?$(CW.(B . ?\x8938) ; <CJK>
     (?$(CW/(B . ?\x93E4) ; <CJK>
     (?$(CW0(B . ?\x964B) ; <CJK>
     (?$(CW1(B . ?\x5289) ; <CJK>
     (?$(CW2(B . ?\x65D2) ; <CJK>
     (?$(CW3(B . ?\x67F3) ; <CJK>
     (?$(CW4(B . ?\x69B4) ; <CJK>
     (?$(CW5(B . ?\x6D41) ; <CJK>
     (?$(CW6(B . ?\x6E9C) ; <CJK>
     (?$(CW7(B . ?\x700F) ; <CJK>
     (?$(CW8(B . ?\x7409) ; <CJK>
     (?$(CW9(B . ?\x7460) ; <CJK>
     (?$(CW:(B . ?\x7559) ; <CJK>
     (?$(CW;(B . ?\x7624) ; <CJK>
     (?$(CW<(B . ?\x786B) ; <CJK>
     (?$(CW=(B . ?\x8B2C) ; <CJK>
     (?$(CW>(B . ?\x985E) ; <CJK>
     (?$(CW?(B . ?\x516D) ; <CJK>
     (?$(CW@(B . ?\x622E) ; <CJK>
     (?$(CWA(B . ?\x9678) ; <CJK>
     (?$(CWB(B . ?\x4F96) ; <CJK>
     (?$(CWC(B . ?\x502B) ; <CJK>
     (?$(CWD(B . ?\x5D19) ; <CJK>
     (?$(CWE(B . ?\x6DEA) ; <CJK>
     (?$(CWF(B . ?\x7DB8) ; <CJK>
     (?$(CWG(B . ?\x8F2A) ; <CJK>
     (?$(CWH(B . ?\x5F8B) ; <CJK>
     (?$(CWI(B . ?\x6144) ; <CJK>
     (?$(CWJ(B . ?\x6817) ; <CJK>
     (?$(CWK(B . ?\xF961) ; <CJK>
     (?$(CWL(B . ?\x9686) ; <CJK>
     (?$(CWM(B . ?\x52D2) ; <CJK>
     (?$(CWN(B . ?\x808B) ; <CJK>
     (?$(CWO(B . ?\x51DC) ; <CJK>
     (?$(CWP(B . ?\x51CC) ; <CJK>
     (?$(CWQ(B . ?\x695E) ; <CJK>
     (?$(CWR(B . ?\x7A1C) ; <CJK>
     (?$(CWS(B . ?\x7DBE) ; <CJK>
     (?$(CWT(B . ?\x83F1) ; <CJK>
     (?$(CWU(B . ?\x9675) ; <CJK>
     (?$(CWV(B . ?\x4FDA) ; <CJK>
     (?$(CWW(B . ?\x5229) ; <CJK>
     (?$(CWX(B . ?\x5398) ; <CJK>
     (?$(CWY(B . ?\x540F) ; <CJK>
     (?$(CWZ(B . ?\x550E) ; <CJK>
     (?$(CW[(B . ?\x5C65) ; <CJK>
     (?$(CW\(B . ?\x60A7) ; <CJK>
     (?$(CW](B . ?\x674E) ; <CJK>
     (?$(CW^(B . ?\x68A8) ; <CJK>
     (?$(CW_(B . ?\x6D6C) ; <CJK>
     (?$(CW`(B . ?\x7281) ; <CJK>
     (?$(CWa(B . ?\x72F8) ; <CJK>
     (?$(CWb(B . ?\x7406) ; <CJK>
     (?$(CWc(B . ?\x7483) ; <CJK>
     (?$(CWd(B . ?\xF962) ; <CJK>
     (?$(CWe(B . ?\x75E2) ; <CJK>
     (?$(CWf(B . ?\x7C6C) ; <CJK>
     (?$(CWg(B . ?\x7F79) ; <CJK>
     (?$(CWh(B . ?\x7FB8) ; <CJK>
     (?$(CWi(B . ?\x8389) ; <CJK>
     (?$(CWj(B . ?\x88CF) ; <CJK>
     (?$(CWk(B . ?\x88E1) ; <CJK>
     (?$(CWl(B . ?\x91CC) ; <CJK>
     (?$(CWm(B . ?\x91D0) ; <CJK>
     (?$(CWn(B . ?\x96E2) ; <CJK>
     (?$(CWo(B . ?\x9BC9) ; <CJK>
     (?$(CWp(B . ?\x541D) ; <CJK>
     (?$(CWq(B . ?\x6F7E) ; <CJK>
     (?$(CWr(B . ?\x71D0) ; <CJK>
     (?$(CWs(B . ?\x7498) ; <CJK>
     (?$(CWt(B . ?\x85FA) ; <CJK>
     (?$(CWu(B . ?\x8EAA) ; <CJK>
     (?$(CWv(B . ?\x96A3) ; <CJK>
     (?$(CWw(B . ?\x9C57) ; <CJK>
     (?$(CWx(B . ?\x9E9F) ; <CJK>
     (?$(CWy(B . ?\x6797) ; <CJK>
     (?$(CWz(B . ?\x6DCB) ; <CJK>
     (?$(CW{(B . ?\x7433) ; <CJK>
     (?$(CW|(B . ?\x81E8) ; <CJK>
     (?$(CW}(B . ?\x9716) ; <CJK>
     (?$(CW~(B . ?\x782C) ; <CJK>
     (?$(CX!(B . ?\x7ACB) ; <CJK>
     (?$(CX"(B . ?\x7B20) ; <CJK>
     (?$(CX#(B . ?\x7C92) ; <CJK>
     (?$(CX$(B . ?\x6469) ; <CJK>
     (?$(CX%(B . ?\x746A) ; <CJK>
     (?$(CX&(B . ?\x75F2) ; <CJK>
     (?$(CX'(B . ?\x78BC) ; <CJK>
     (?$(CX((B . ?\x78E8) ; <CJK>
     (?$(CX)(B . ?\x99AC) ; <CJK>
     (?$(CX*(B . ?\x9B54) ; <CJK>
     (?$(CX+(B . ?\x9EBB) ; <CJK>
     (?$(CX,(B . ?\x5BDE) ; <CJK>
     (?$(CX-(B . ?\x5E55) ; <CJK>
     (?$(CX.(B . ?\x6F20) ; <CJK>
     (?$(CX/(B . ?\x819C) ; <CJK>
     (?$(CX0(B . ?\x83AB) ; <CJK>
     (?$(CX1(B . ?\x9088) ; <CJK>
     (?$(CX2(B . ?\x4E07) ; <CJK>
     (?$(CX3(B . ?\x534D) ; <CJK>
     (?$(CX4(B . ?\x5A29) ; <CJK>
     (?$(CX5(B . ?\x5DD2) ; <CJK>
     (?$(CX6(B . ?\x5F4E) ; <CJK>
     (?$(CX7(B . ?\x6162) ; <CJK>
     (?$(CX8(B . ?\x633D) ; <CJK>
     (?$(CX9(B . ?\x6669) ; <CJK>
     (?$(CX:(B . ?\x66FC) ; <CJK>
     (?$(CX;(B . ?\x6EFF) ; <CJK>
     (?$(CX<(B . ?\x6F2B) ; <CJK>
     (?$(CX=(B . ?\x7063) ; <CJK>
     (?$(CX>(B . ?\x779E) ; <CJK>
     (?$(CX?(B . ?\x842C) ; <CJK>
     (?$(CX@(B . ?\x8513) ; <CJK>
     (?$(CXA(B . ?\x883B) ; <CJK>
     (?$(CXB(B . ?\x8F13) ; <CJK>
     (?$(CXC(B . ?\x9945) ; <CJK>
     (?$(CXD(B . ?\x9C3B) ; <CJK>
     (?$(CXE(B . ?\x551C) ; <CJK>
     (?$(CXF(B . ?\x62B9) ; <CJK>
     (?$(CXG(B . ?\x672B) ; <CJK>
     (?$(CXH(B . ?\x6CAB) ; <CJK>
     (?$(CXI(B . ?\x8309) ; <CJK>
     (?$(CXJ(B . ?\x896A) ; <CJK>
     (?$(CXK(B . ?\x977A) ; <CJK>
     (?$(CXL(B . ?\x4EA1) ; <CJK>
     (?$(CXM(B . ?\x5984) ; <CJK>
     (?$(CXN(B . ?\x5FD8) ; <CJK>
     (?$(CXO(B . ?\x5FD9) ; <CJK>
     (?$(CXP(B . ?\x671B) ; <CJK>
     (?$(CXQ(B . ?\x7DB2) ; <CJK>
     (?$(CXR(B . ?\x7F54) ; <CJK>
     (?$(CXS(B . ?\x8292) ; <CJK>
     (?$(CXT(B . ?\x832B) ; <CJK>
     (?$(CXU(B . ?\x83BD) ; <CJK>
     (?$(CXV(B . ?\x8F1E) ; <CJK>
     (?$(CXW(B . ?\x9099) ; <CJK>
     (?$(CXX(B . ?\x57CB) ; <CJK>
     (?$(CXY(B . ?\x59B9) ; <CJK>
     (?$(CXZ(B . ?\x5A92) ; <CJK>
     (?$(CX[(B . ?\x5BD0) ; <CJK>
     (?$(CX\(B . ?\x6627) ; <CJK>
     (?$(CX](B . ?\x679A) ; <CJK>
     (?$(CX^(B . ?\x6885) ; <CJK>
     (?$(CX_(B . ?\x6BCF) ; <CJK>
     (?$(CX`(B . ?\x7164) ; <CJK>
     (?$(CXa(B . ?\x7F75) ; <CJK>
     (?$(CXb(B . ?\x8CB7) ; <CJK>
     (?$(CXc(B . ?\x8CE3) ; <CJK>
     (?$(CXd(B . ?\x9081) ; <CJK>
     (?$(CXe(B . ?\x9B45) ; <CJK>
     (?$(CXf(B . ?\x8108) ; <CJK>
     (?$(CXg(B . ?\x8C8A) ; <CJK>
     (?$(CXh(B . ?\x964C) ; <CJK>
     (?$(CXi(B . ?\x9A40) ; <CJK>
     (?$(CXj(B . ?\x9EA5) ; <CJK>
     (?$(CXk(B . ?\x5B5F) ; <CJK>
     (?$(CXl(B . ?\x6C13) ; <CJK>
     (?$(CXm(B . ?\x731B) ; <CJK>
     (?$(CXn(B . ?\x76F2) ; <CJK>
     (?$(CXo(B . ?\x76DF) ; <CJK>
     (?$(CXp(B . ?\x840C) ; <CJK>
     (?$(CXq(B . ?\x51AA) ; <CJK>
     (?$(CXr(B . ?\x8993) ; <CJK>
     (?$(CXs(B . ?\x514D) ; <CJK>
     (?$(CXt(B . ?\x5195) ; <CJK>
     (?$(CXu(B . ?\x52C9) ; <CJK>
     (?$(CXv(B . ?\x68C9) ; <CJK>
     (?$(CXw(B . ?\x6C94) ; <CJK>
     (?$(CXx(B . ?\x7704) ; <CJK>
     (?$(CXy(B . ?\x7720) ; <CJK>
     (?$(CXz(B . ?\x7DBF) ; <CJK>
     (?$(CX{(B . ?\x7DEC) ; <CJK>
     (?$(CX|(B . ?\x9762) ; <CJK>
     (?$(CX}(B . ?\x9EB5) ; <CJK>
     (?$(CX~(B . ?\x6EC5) ; <CJK>
     (?$(CY!(B . ?\x8511) ; <CJK>
     (?$(CY"(B . ?\x51A5) ; <CJK>
     (?$(CY#(B . ?\x540D) ; <CJK>
     (?$(CY$(B . ?\x547D) ; <CJK>
     (?$(CY%(B . ?\x660E) ; <CJK>
     (?$(CY&(B . ?\x669D) ; <CJK>
     (?$(CY'(B . ?\x6927) ; <CJK>
     (?$(CY((B . ?\x6E9F) ; <CJK>
     (?$(CY)(B . ?\x76BF) ; <CJK>
     (?$(CY*(B . ?\x7791) ; <CJK>
     (?$(CY+(B . ?\x8317) ; <CJK>
     (?$(CY,(B . ?\x84C2) ; <CJK>
     (?$(CY-(B . ?\x879F) ; <CJK>
     (?$(CY.(B . ?\x9169) ; <CJK>
     (?$(CY/(B . ?\x9298) ; <CJK>
     (?$(CY0(B . ?\x9CF4) ; <CJK>
     (?$(CY1(B . ?\x8882) ; <CJK>
     (?$(CY2(B . ?\x4FAE) ; <CJK>
     (?$(CY3(B . ?\x5192) ; <CJK>
     (?$(CY4(B . ?\x52DF) ; <CJK>
     (?$(CY5(B . ?\x59C6) ; <CJK>
     (?$(CY6(B . ?\x5E3D) ; <CJK>
     (?$(CY7(B . ?\x6155) ; <CJK>
     (?$(CY8(B . ?\x6478) ; <CJK>
     (?$(CY9(B . ?\x6479) ; <CJK>
     (?$(CY:(B . ?\x66AE) ; <CJK>
     (?$(CY;(B . ?\x67D0) ; <CJK>
     (?$(CY<(B . ?\x6A21) ; <CJK>
     (?$(CY=(B . ?\x6BCD) ; <CJK>
     (?$(CY>(B . ?\x6BDB) ; <CJK>
     (?$(CY?(B . ?\x725F) ; <CJK>
     (?$(CY@(B . ?\x7261) ; <CJK>
     (?$(CYA(B . ?\x7441) ; <CJK>
     (?$(CYB(B . ?\x7738) ; <CJK>
     (?$(CYC(B . ?\x77DB) ; <CJK>
     (?$(CYD(B . ?\x8017) ; <CJK>
     (?$(CYE(B . ?\x82BC) ; <CJK>
     (?$(CYF(B . ?\x8305) ; <CJK>
     (?$(CYG(B . ?\x8B00) ; <CJK>
     (?$(CYH(B . ?\x8B28) ; <CJK>
     (?$(CYI(B . ?\x8C8C) ; <CJK>
     (?$(CYJ(B . ?\x6728) ; <CJK>
     (?$(CYK(B . ?\x6C90) ; <CJK>
     (?$(CYL(B . ?\x7267) ; <CJK>
     (?$(CYM(B . ?\x76EE) ; <CJK>
     (?$(CYN(B . ?\x7766) ; <CJK>
     (?$(CYO(B . ?\x7A46) ; <CJK>
     (?$(CYP(B . ?\x9DA9) ; <CJK>
     (?$(CYQ(B . ?\x6B7F) ; <CJK>
     (?$(CYR(B . ?\x6C92) ; <CJK>
     (?$(CYS(B . ?\x5922) ; <CJK>
     (?$(CYT(B . ?\x6726) ; <CJK>
     (?$(CYU(B . ?\x8499) ; <CJK>
     (?$(CYV(B . ?\x536F) ; <CJK>
     (?$(CYW(B . ?\x5893) ; <CJK>
     (?$(CYX(B . ?\x5999) ; <CJK>
     (?$(CYY(B . ?\x5EDF) ; <CJK>
     (?$(CYZ(B . ?\x63CF) ; <CJK>
     (?$(CY[(B . ?\x6634) ; <CJK>
     (?$(CY\(B . ?\x6773) ; <CJK>
     (?$(CY](B . ?\x6E3A) ; <CJK>
     (?$(CY^(B . ?\x732B) ; <CJK>
     (?$(CY_(B . ?\x7AD7) ; <CJK>
     (?$(CY`(B . ?\x82D7) ; <CJK>
     (?$(CYa(B . ?\x9328) ; <CJK>
     (?$(CYb(B . ?\x52D9) ; <CJK>
     (?$(CYc(B . ?\x5DEB) ; <CJK>
     (?$(CYd(B . ?\x61AE) ; <CJK>
     (?$(CYe(B . ?\x61CB) ; <CJK>
     (?$(CYf(B . ?\x620A) ; <CJK>
     (?$(CYg(B . ?\x62C7) ; <CJK>
     (?$(CYh(B . ?\x64AB) ; <CJK>
     (?$(CYi(B . ?\x65E0) ; <CJK>
     (?$(CYj(B . ?\x6959) ; <CJK>
     (?$(CYk(B . ?\x6B66) ; <CJK>
     (?$(CYl(B . ?\x6BCB) ; <CJK>
     (?$(CYm(B . ?\x7121) ; <CJK>
     (?$(CYn(B . ?\x73F7) ; <CJK>
     (?$(CYo(B . ?\x755D) ; <CJK>
     (?$(CYp(B . ?\x7E46) ; <CJK>
     (?$(CYq(B . ?\x821E) ; <CJK>
     (?$(CYr(B . ?\x8302) ; <CJK>
     (?$(CYs(B . ?\x856A) ; <CJK>
     (?$(CYt(B . ?\x8AA3) ; <CJK>
     (?$(CYu(B . ?\x8CBF) ; <CJK>
     (?$(CYv(B . ?\x9727) ; <CJK>
     (?$(CYw(B . ?\x9D61) ; <CJK>
     (?$(CYx(B . ?\x58A8) ; <CJK>
     (?$(CYy(B . ?\x9ED8) ; <CJK>
     (?$(CYz(B . ?\x5011) ; <CJK>
     (?$(CY{(B . ?\x520E) ; <CJK>
     (?$(CY|(B . ?\x543B) ; <CJK>
     (?$(CY}(B . ?\x554F) ; <CJK>
     (?$(CY~(B . ?\x6587) ; <CJK>
     (?$(CZ!(B . ?\x6C76) ; <CJK>
     (?$(CZ"(B . ?\x7D0A) ; <CJK>
     (?$(CZ#(B . ?\x7D0B) ; <CJK>
     (?$(CZ$(B . ?\x805E) ; <CJK>
     (?$(CZ%(B . ?\x868A) ; <CJK>
     (?$(CZ&(B . ?\x9580) ; <CJK>
     (?$(CZ'(B . ?\x96EF) ; <CJK>
     (?$(CZ((B . ?\x52FF) ; <CJK>
     (?$(CZ)(B . ?\x6C95) ; <CJK>
     (?$(CZ*(B . ?\x7269) ; <CJK>
     (?$(CZ+(B . ?\x5473) ; <CJK>
     (?$(CZ,(B . ?\x5A9A) ; <CJK>
     (?$(CZ-(B . ?\x5C3E) ; <CJK>
     (?$(CZ.(B . ?\x5D4B) ; <CJK>
     (?$(CZ/(B . ?\x5F4C) ; <CJK>
     (?$(CZ0(B . ?\x5FAE) ; <CJK>
     (?$(CZ1(B . ?\x672A) ; <CJK>
     (?$(CZ2(B . ?\x68B6) ; <CJK>
     (?$(CZ3(B . ?\x6963) ; <CJK>
     (?$(CZ4(B . ?\x6E3C) ; <CJK>
     (?$(CZ5(B . ?\x6E44) ; <CJK>
     (?$(CZ6(B . ?\x7709) ; <CJK>
     (?$(CZ7(B . ?\x7C73) ; <CJK>
     (?$(CZ8(B . ?\x7F8E) ; <CJK>
     (?$(CZ9(B . ?\x8587) ; <CJK>
     (?$(CZ:(B . ?\x8B0E) ; <CJK>
     (?$(CZ;(B . ?\x8FF7) ; <CJK>
     (?$(CZ<(B . ?\x9761) ; <CJK>
     (?$(CZ=(B . ?\x9EF4) ; <CJK>
     (?$(CZ>(B . ?\x5CB7) ; <CJK>
     (?$(CZ?(B . ?\x60B6) ; <CJK>
     (?$(CZ@(B . ?\x610D) ; <CJK>
     (?$(CZA(B . ?\x61AB) ; <CJK>
     (?$(CZB(B . ?\x654F) ; <CJK>
     (?$(CZC(B . ?\x65FB) ; <CJK>
     (?$(CZD(B . ?\x65FC) ; <CJK>
     (?$(CZE(B . ?\x6C11) ; <CJK>
     (?$(CZF(B . ?\x6CEF) ; <CJK>
     (?$(CZG(B . ?\x739F) ; <CJK>
     (?$(CZH(B . ?\x73C9) ; <CJK>
     (?$(CZI(B . ?\x7DE1) ; <CJK>
     (?$(CZJ(B . ?\x9594) ; <CJK>
     (?$(CZK(B . ?\x5BC6) ; <CJK>
     (?$(CZL(B . ?\x871C) ; <CJK>
     (?$(CZM(B . ?\x8B10) ; <CJK>
     (?$(CZN(B . ?\x525D) ; <CJK>
     (?$(CZO(B . ?\x535A) ; <CJK>
     (?$(CZP(B . ?\x62CD) ; <CJK>
     (?$(CZQ(B . ?\x640F) ; <CJK>
     (?$(CZR(B . ?\x64B2) ; <CJK>
     (?$(CZS(B . ?\x6734) ; <CJK>
     (?$(CZT(B . ?\x6A38) ; <CJK>
     (?$(CZU(B . ?\x6CCA) ; <CJK>
     (?$(CZV(B . ?\x73C0) ; <CJK>
     (?$(CZW(B . ?\x749E) ; <CJK>
     (?$(CZX(B . ?\x7B94) ; <CJK>
     (?$(CZY(B . ?\x7C95) ; <CJK>
     (?$(CZZ(B . ?\x7E1B) ; <CJK>
     (?$(CZ[(B . ?\x818A) ; <CJK>
     (?$(CZ\(B . ?\x8236) ; <CJK>
     (?$(CZ](B . ?\x8584) ; <CJK>
     (?$(CZ^(B . ?\x8FEB) ; <CJK>
     (?$(CZ_(B . ?\x96F9) ; <CJK>
     (?$(CZ`(B . ?\x99C1) ; <CJK>
     (?$(CZa(B . ?\x4F34) ; <CJK>
     (?$(CZb(B . ?\x534A) ; <CJK>
     (?$(CZc(B . ?\x53CD) ; <CJK>
     (?$(CZd(B . ?\x53DB) ; <CJK>
     (?$(CZe(B . ?\x62CC) ; <CJK>
     (?$(CZf(B . ?\x642C) ; <CJK>
     (?$(CZg(B . ?\x6500) ; <CJK>
     (?$(CZh(B . ?\x6591) ; <CJK>
     (?$(CZi(B . ?\x69C3) ; <CJK>
     (?$(CZj(B . ?\x6CEE) ; <CJK>
     (?$(CZk(B . ?\x6F58) ; <CJK>
     (?$(CZl(B . ?\x73ED) ; <CJK>
     (?$(CZm(B . ?\x7554) ; <CJK>
     (?$(CZn(B . ?\x7622) ; <CJK>
     (?$(CZo(B . ?\x76E4) ; <CJK>
     (?$(CZp(B . ?\x76FC) ; <CJK>
     (?$(CZq(B . ?\x78D0) ; <CJK>
     (?$(CZr(B . ?\x78FB) ; <CJK>
     (?$(CZs(B . ?\x792C) ; <CJK>
     (?$(CZt(B . ?\x7D46) ; <CJK>
     (?$(CZu(B . ?\x822C) ; <CJK>
     (?$(CZv(B . ?\x87E0) ; <CJK>
     (?$(CZw(B . ?\x8FD4) ; <CJK>
     (?$(CZx(B . ?\x9812) ; <CJK>
     (?$(CZy(B . ?\x98EF) ; <CJK>
     (?$(CZz(B . ?\x52C3) ; <CJK>
     (?$(CZ{(B . ?\x62D4) ; <CJK>
     (?$(CZ|(B . ?\x64A5) ; <CJK>
     (?$(CZ}(B . ?\x6E24) ; <CJK>
     (?$(CZ~(B . ?\x6F51) ; <CJK>
     (?$(C[!(B . ?\x767C) ; <CJK>
     (?$(C["(B . ?\x8DCB) ; <CJK>
     (?$(C[#(B . ?\x91B1) ; <CJK>
     (?$(C[$(B . ?\x9262) ; <CJK>
     (?$(C[%(B . ?\x9AEE) ; <CJK>
     (?$(C[&(B . ?\x9B43) ; <CJK>
     (?$(C['(B . ?\x5023) ; <CJK>
     (?$(C[((B . ?\x508D) ; <CJK>
     (?$(C[)(B . ?\x574A) ; <CJK>
     (?$(C[*(B . ?\x59A8) ; <CJK>
     (?$(C[+(B . ?\x5C28) ; <CJK>
     (?$(C[,(B . ?\x5E47) ; <CJK>
     (?$(C[-(B . ?\x5F77) ; <CJK>
     (?$(C[.(B . ?\x623F) ; <CJK>
     (?$(C[/(B . ?\x653E) ; <CJK>
     (?$(C[0(B . ?\x65B9) ; <CJK>
     (?$(C[1(B . ?\x65C1) ; <CJK>
     (?$(C[2(B . ?\x6609) ; <CJK>
     (?$(C[3(B . ?\x678B) ; <CJK>
     (?$(C[4(B . ?\x699C) ; <CJK>
     (?$(C[5(B . ?\x6EC2) ; <CJK>
     (?$(C[6(B . ?\x78C5) ; <CJK>
     (?$(C[7(B . ?\x7D21) ; <CJK>
     (?$(C[8(B . ?\x80AA) ; <CJK>
     (?$(C[9(B . ?\x8180) ; <CJK>
     (?$(C[:(B . ?\x822B) ; <CJK>
     (?$(C[;(B . ?\x82B3) ; <CJK>
     (?$(C[<(B . ?\x84A1) ; <CJK>
     (?$(C[=(B . ?\x868C) ; <CJK>
     (?$(C[>(B . ?\x8A2A) ; <CJK>
     (?$(C[?(B . ?\x8B17) ; <CJK>
     (?$(C[@(B . ?\x90A6) ; <CJK>
     (?$(C[A(B . ?\x9632) ; <CJK>
     (?$(C[B(B . ?\x9F90) ; <CJK>
     (?$(C[C(B . ?\x500D) ; <CJK>
     (?$(C[D(B . ?\x4FF3) ; <CJK>
     (?$(C[E(B . ?\xF963) ; <CJK>
     (?$(C[F(B . ?\x57F9) ; <CJK>
     (?$(C[G(B . ?\x5F98) ; <CJK>
     (?$(C[H(B . ?\x62DC) ; <CJK>
     (?$(C[I(B . ?\x6392) ; <CJK>
     (?$(C[J(B . ?\x676F) ; <CJK>
     (?$(C[K(B . ?\x6E43) ; <CJK>
     (?$(C[L(B . ?\x7119) ; <CJK>
     (?$(C[M(B . ?\x76C3) ; <CJK>
     (?$(C[N(B . ?\x80CC) ; <CJK>
     (?$(C[O(B . ?\x80DA) ; <CJK>
     (?$(C[P(B . ?\x88F4) ; <CJK>
     (?$(C[Q(B . ?\x88F5) ; <CJK>
     (?$(C[R(B . ?\x8919) ; <CJK>
     (?$(C[S(B . ?\x8CE0) ; <CJK>
     (?$(C[T(B . ?\x8F29) ; <CJK>
     (?$(C[U(B . ?\x914D) ; <CJK>
     (?$(C[V(B . ?\x966A) ; <CJK>
     (?$(C[W(B . ?\x4F2F) ; <CJK>
     (?$(C[X(B . ?\x4F70) ; <CJK>
     (?$(C[Y(B . ?\x5E1B) ; <CJK>
     (?$(C[Z(B . ?\x67CF) ; <CJK>
     (?$(C[[(B . ?\x6822) ; <CJK>
     (?$(C[\(B . ?\x767D) ; <CJK>
     (?$(C[](B . ?\x767E) ; <CJK>
     (?$(C[^(B . ?\x9B44) ; <CJK>
     (?$(C[_(B . ?\x5E61) ; <CJK>
     (?$(C[`(B . ?\x6A0A) ; <CJK>
     (?$(C[a(B . ?\x7169) ; <CJK>
     (?$(C[b(B . ?\x71D4) ; <CJK>
     (?$(C[c(B . ?\x756A) ; <CJK>
     (?$(C[d(B . ?\xF964) ; <CJK>
     (?$(C[e(B . ?\x7E41) ; <CJK>
     (?$(C[f(B . ?\x8543) ; <CJK>
     (?$(C[g(B . ?\x85E9) ; <CJK>
     (?$(C[h(B . ?\x98DC) ; <CJK>
     (?$(C[i(B . ?\x4F10) ; <CJK>
     (?$(C[j(B . ?\x7B4F) ; <CJK>
     (?$(C[k(B . ?\x7F70) ; <CJK>
     (?$(C[l(B . ?\x95A5) ; <CJK>
     (?$(C[m(B . ?\x51E1) ; <CJK>
     (?$(C[n(B . ?\x5E06) ; <CJK>
     (?$(C[o(B . ?\x68B5) ; <CJK>
     (?$(C[p(B . ?\x6C3E) ; <CJK>
     (?$(C[q(B . ?\x6C4E) ; <CJK>
     (?$(C[r(B . ?\x6CDB) ; <CJK>
     (?$(C[s(B . ?\x72AF) ; <CJK>
     (?$(C[t(B . ?\x7BC4) ; <CJK>
     (?$(C[u(B . ?\x8303) ; <CJK>
     (?$(C[v(B . ?\x6CD5) ; <CJK>
     (?$(C[w(B . ?\x743A) ; <CJK>
     (?$(C[x(B . ?\x50FB) ; <CJK>
     (?$(C[y(B . ?\x5288) ; <CJK>
     (?$(C[z(B . ?\x58C1) ; <CJK>
     (?$(C[{(B . ?\x64D8) ; <CJK>
     (?$(C[|(B . ?\x6A97) ; <CJK>
     (?$(C[}(B . ?\x74A7) ; <CJK>
     (?$(C[~(B . ?\x7656) ; <CJK>
     (?$(C\!(B . ?\x78A7) ; <CJK>
     (?$(C\"(B . ?\x8617) ; <CJK>
     (?$(C\#(B . ?\x95E2) ; <CJK>
     (?$(C\$(B . ?\x9739) ; <CJK>
     (?$(C\%(B . ?\xF965) ; <CJK>
     (?$(C\&(B . ?\x535E) ; <CJK>
     (?$(C\'(B . ?\x5F01) ; <CJK>
     (?$(C\((B . ?\x8B8A) ; <CJK>
     (?$(C\)(B . ?\x8FA8) ; <CJK>
     (?$(C\*(B . ?\x8FAF) ; <CJK>
     (?$(C\+(B . ?\x908A) ; <CJK>
     (?$(C\,(B . ?\x5225) ; <CJK>
     (?$(C\-(B . ?\x77A5) ; <CJK>
     (?$(C\.(B . ?\x9C49) ; <CJK>
     (?$(C\/(B . ?\x9F08) ; <CJK>
     (?$(C\0(B . ?\x4E19) ; <CJK>
     (?$(C\1(B . ?\x5002) ; <CJK>
     (?$(C\2(B . ?\x5175) ; <CJK>
     (?$(C\3(B . ?\x5C5B) ; <CJK>
     (?$(C\4(B . ?\x5E77) ; <CJK>
     (?$(C\5(B . ?\x661E) ; <CJK>
     (?$(C\6(B . ?\x663A) ; <CJK>
     (?$(C\7(B . ?\x67C4) ; <CJK>
     (?$(C\8(B . ?\x68C5) ; <CJK>
     (?$(C\9(B . ?\x70B3) ; <CJK>
     (?$(C\:(B . ?\x7501) ; <CJK>
     (?$(C\;(B . ?\x75C5) ; <CJK>
     (?$(C\<(B . ?\x79C9) ; <CJK>
     (?$(C\=(B . ?\x7ADD) ; <CJK>
     (?$(C\>(B . ?\x8F27) ; <CJK>
     (?$(C\?(B . ?\x9920) ; <CJK>
     (?$(C\@(B . ?\x9A08) ; <CJK>
     (?$(C\A(B . ?\x4FDD) ; <CJK>
     (?$(C\B(B . ?\x5821) ; <CJK>
     (?$(C\C(B . ?\x5831) ; <CJK>
     (?$(C\D(B . ?\x5BF6) ; <CJK>
     (?$(C\E(B . ?\x666E) ; <CJK>
     (?$(C\F(B . ?\x6B65) ; <CJK>
     (?$(C\G(B . ?\x6D11) ; <CJK>
     (?$(C\H(B . ?\x6E7A) ; <CJK>
     (?$(C\I(B . ?\x6F7D) ; <CJK>
     (?$(C\J(B . ?\x73E4) ; <CJK>
     (?$(C\K(B . ?\x752B) ; <CJK>
     (?$(C\L(B . ?\x83E9) ; <CJK>
     (?$(C\M(B . ?\x88DC) ; <CJK>
     (?$(C\N(B . ?\x8913) ; <CJK>
     (?$(C\O(B . ?\x8B5C) ; <CJK>
     (?$(C\P(B . ?\x8F14) ; <CJK>
     (?$(C\Q(B . ?\x4F0F) ; <CJK>
     (?$(C\R(B . ?\x50D5) ; <CJK>
     (?$(C\S(B . ?\x5310) ; <CJK>
     (?$(C\T(B . ?\x535C) ; <CJK>
     (?$(C\U(B . ?\x5B93) ; <CJK>
     (?$(C\V(B . ?\x5FA9) ; <CJK>
     (?$(C\W(B . ?\x670D) ; <CJK>
     (?$(C\X(B . ?\x798F) ; <CJK>
     (?$(C\Y(B . ?\x8179) ; <CJK>
     (?$(C\Z(B . ?\x832F) ; <CJK>
     (?$(C\[(B . ?\x8514) ; <CJK>
     (?$(C\\(B . ?\x8907) ; <CJK>
     (?$(C\](B . ?\x8986) ; <CJK>
     (?$(C\^(B . ?\x8F39) ; <CJK>
     (?$(C\_(B . ?\x8F3B) ; <CJK>
     (?$(C\`(B . ?\x99A5) ; <CJK>
     (?$(C\a(B . ?\x9C12) ; <CJK>
     (?$(C\b(B . ?\x672C) ; <CJK>
     (?$(C\c(B . ?\x4E76) ; <CJK>
     (?$(C\d(B . ?\x4FF8) ; <CJK>
     (?$(C\e(B . ?\x5949) ; <CJK>
     (?$(C\f(B . ?\x5C01) ; <CJK>
     (?$(C\g(B . ?\x5CEF) ; <CJK>
     (?$(C\h(B . ?\x5CF0) ; <CJK>
     (?$(C\i(B . ?\x6367) ; <CJK>
     (?$(C\j(B . ?\x68D2) ; <CJK>
     (?$(C\k(B . ?\x70FD) ; <CJK>
     (?$(C\l(B . ?\x71A2) ; <CJK>
     (?$(C\m(B . ?\x742B) ; <CJK>
     (?$(C\n(B . ?\x7E2B) ; <CJK>
     (?$(C\o(B . ?\x84EC) ; <CJK>
     (?$(C\p(B . ?\x8702) ; <CJK>
     (?$(C\q(B . ?\x9022) ; <CJK>
     (?$(C\r(B . ?\x92D2) ; <CJK>
     (?$(C\s(B . ?\x9CF3) ; <CJK>
     (?$(C\t(B . ?\x4E0D) ; <CJK>
     (?$(C\u(B . ?\x4ED8) ; <CJK>
     (?$(C\v(B . ?\x4FEF) ; <CJK>
     (?$(C\w(B . ?\x5085) ; <CJK>
     (?$(C\x(B . ?\x5256) ; <CJK>
     (?$(C\y(B . ?\x526F) ; <CJK>
     (?$(C\z(B . ?\x5426) ; <CJK>
     (?$(C\{(B . ?\x5490) ; <CJK>
     (?$(C\|(B . ?\x57E0) ; <CJK>
     (?$(C\}(B . ?\x592B) ; <CJK>
     (?$(C\~(B . ?\x5A66) ; <CJK>
     (?$(C]!(B . ?\x5B5A) ; <CJK>
     (?$(C]"(B . ?\x5B75) ; <CJK>
     (?$(C]#(B . ?\x5BCC) ; <CJK>
     (?$(C]$(B . ?\x5E9C) ; <CJK>
     (?$(C]%(B . ?\xF966) ; <CJK>
     (?$(C]&(B . ?\x6276) ; <CJK>
     (?$(C]'(B . ?\x6577) ; <CJK>
     (?$(C]((B . ?\x65A7) ; <CJK>
     (?$(C])(B . ?\x6D6E) ; <CJK>
     (?$(C]*(B . ?\x6EA5) ; <CJK>
     (?$(C]+(B . ?\x7236) ; <CJK>
     (?$(C],(B . ?\x7B26) ; <CJK>
     (?$(C]-(B . ?\x7C3F) ; <CJK>
     (?$(C].(B . ?\x7F36) ; <CJK>
     (?$(C]/(B . ?\x8150) ; <CJK>
     (?$(C]0(B . ?\x8151) ; <CJK>
     (?$(C]1(B . ?\x819A) ; <CJK>
     (?$(C]2(B . ?\x8240) ; <CJK>
     (?$(C]3(B . ?\x8299) ; <CJK>
     (?$(C]4(B . ?\x83A9) ; <CJK>
     (?$(C]5(B . ?\x8A03) ; <CJK>
     (?$(C]6(B . ?\x8CA0) ; <CJK>
     (?$(C]7(B . ?\x8CE6) ; <CJK>
     (?$(C]8(B . ?\x8CFB) ; <CJK>
     (?$(C]9(B . ?\x8D74) ; <CJK>
     (?$(C]:(B . ?\x8DBA) ; <CJK>
     (?$(C];(B . ?\x90E8) ; <CJK>
     (?$(C]<(B . ?\x91DC) ; <CJK>
     (?$(C]=(B . ?\x961C) ; <CJK>
     (?$(C]>(B . ?\x9644) ; <CJK>
     (?$(C]?(B . ?\x99D9) ; <CJK>
     (?$(C]@(B . ?\x9CE7) ; <CJK>
     (?$(C]A(B . ?\x5317) ; <CJK>
     (?$(C]B(B . ?\x5206) ; <CJK>
     (?$(C]C(B . ?\x5429) ; <CJK>
     (?$(C]D(B . ?\x5674) ; <CJK>
     (?$(C]E(B . ?\x58B3) ; <CJK>
     (?$(C]F(B . ?\x5954) ; <CJK>
     (?$(C]G(B . ?\x596E) ; <CJK>
     (?$(C]H(B . ?\x5FFF) ; <CJK>
     (?$(C]I(B . ?\x61A4) ; <CJK>
     (?$(C]J(B . ?\x626E) ; <CJK>
     (?$(C]K(B . ?\x6610) ; <CJK>
     (?$(C]L(B . ?\x6C7E) ; <CJK>
     (?$(C]M(B . ?\x711A) ; <CJK>
     (?$(C]N(B . ?\x76C6) ; <CJK>
     (?$(C]O(B . ?\x7C89) ; <CJK>
     (?$(C]P(B . ?\x7CDE) ; <CJK>
     (?$(C]Q(B . ?\x7D1B) ; <CJK>
     (?$(C]R(B . ?\x82AC) ; <CJK>
     (?$(C]S(B . ?\x8CC1) ; <CJK>
     (?$(C]T(B . ?\x96F0) ; <CJK>
     (?$(C]U(B . ?\xF967) ; <CJK>
     (?$(C]V(B . ?\x4F5B) ; <CJK>
     (?$(C]W(B . ?\x5F17) ; <CJK>
     (?$(C]X(B . ?\x5F7F) ; <CJK>
     (?$(C]Y(B . ?\x62C2) ; <CJK>
     (?$(C]Z(B . ?\x5D29) ; <CJK>
     (?$(C][(B . ?\x670B) ; <CJK>
     (?$(C]\(B . ?\x68DA) ; <CJK>
     (?$(C]](B . ?\x787C) ; <CJK>
     (?$(C]^(B . ?\x7E43) ; <CJK>
     (?$(C]_(B . ?\x9D6C) ; <CJK>
     (?$(C]`(B . ?\x4E15) ; <CJK>
     (?$(C]a(B . ?\x5099) ; <CJK>
     (?$(C]b(B . ?\x5315) ; <CJK>
     (?$(C]c(B . ?\x532A) ; <CJK>
     (?$(C]d(B . ?\x5351) ; <CJK>
     (?$(C]e(B . ?\x5983) ; <CJK>
     (?$(C]f(B . ?\x5A62) ; <CJK>
     (?$(C]g(B . ?\x5E87) ; <CJK>
     (?$(C]h(B . ?\x60B2) ; <CJK>
     (?$(C]i(B . ?\x618A) ; <CJK>
     (?$(C]j(B . ?\x6249) ; <CJK>
     (?$(C]k(B . ?\x6279) ; <CJK>
     (?$(C]l(B . ?\x6590) ; <CJK>
     (?$(C]m(B . ?\x6787) ; <CJK>
     (?$(C]n(B . ?\x69A7) ; <CJK>
     (?$(C]o(B . ?\x6BD4) ; <CJK>
     (?$(C]p(B . ?\x6BD6) ; <CJK>
     (?$(C]q(B . ?\x6BD7) ; <CJK>
     (?$(C]r(B . ?\x6BD8) ; <CJK>
     (?$(C]s(B . ?\x6CB8) ; <CJK>
     (?$(C]t(B . ?\xF968) ; <CJK>
     (?$(C]u(B . ?\x7435) ; <CJK>
     (?$(C]v(B . ?\x75FA) ; <CJK>
     (?$(C]w(B . ?\x7812) ; <CJK>
     (?$(C]x(B . ?\x7891) ; <CJK>
     (?$(C]y(B . ?\x79D5) ; <CJK>
     (?$(C]z(B . ?\x79D8) ; <CJK>
     (?$(C]{(B . ?\x7C83) ; <CJK>
     (?$(C]|(B . ?\x7DCB) ; <CJK>
     (?$(C]}(B . ?\x7FE1) ; <CJK>
     (?$(C]~(B . ?\x80A5) ; <CJK>
     (?$(C^!(B . ?\x813E) ; <CJK>
     (?$(C^"(B . ?\x81C2) ; <CJK>
     (?$(C^#(B . ?\x83F2) ; <CJK>
     (?$(C^$(B . ?\x871A) ; <CJK>
     (?$(C^%(B . ?\x88E8) ; <CJK>
     (?$(C^&(B . ?\x8AB9) ; <CJK>
     (?$(C^'(B . ?\x8B6C) ; <CJK>
     (?$(C^((B . ?\x8CBB) ; <CJK>
     (?$(C^)(B . ?\x9119) ; <CJK>
     (?$(C^*(B . ?\x975E) ; <CJK>
     (?$(C^+(B . ?\x98DB) ; <CJK>
     (?$(C^,(B . ?\x9F3B) ; <CJK>
     (?$(C^-(B . ?\x56AC) ; <CJK>
     (?$(C^.(B . ?\x5B2A) ; <CJK>
     (?$(C^/(B . ?\x5F6C) ; <CJK>
     (?$(C^0(B . ?\x658C) ; <CJK>
     (?$(C^1(B . ?\x6AB3) ; <CJK>
     (?$(C^2(B . ?\x6BAF) ; <CJK>
     (?$(C^3(B . ?\x6D5C) ; <CJK>
     (?$(C^4(B . ?\x6FF1) ; <CJK>
     (?$(C^5(B . ?\x7015) ; <CJK>
     (?$(C^6(B . ?\x725D) ; <CJK>
     (?$(C^7(B . ?\x73AD) ; <CJK>
     (?$(C^8(B . ?\x8CA7) ; <CJK>
     (?$(C^9(B . ?\x8CD3) ; <CJK>
     (?$(C^:(B . ?\x983B) ; <CJK>
     (?$(C^;(B . ?\x6191) ; <CJK>
     (?$(C^<(B . ?\x6C37) ; <CJK>
     (?$(C^=(B . ?\x8058) ; <CJK>
     (?$(C^>(B . ?\x9A01) ; <CJK>
     (?$(C^?(B . ?\x4E4D) ; <CJK>
     (?$(C^@(B . ?\x4E8B) ; <CJK>
     (?$(C^A(B . ?\x4E9B) ; <CJK>
     (?$(C^B(B . ?\x4ED5) ; <CJK>
     (?$(C^C(B . ?\x4F3A) ; <CJK>
     (?$(C^D(B . ?\x4F3C) ; <CJK>
     (?$(C^E(B . ?\x4F7F) ; <CJK>
     (?$(C^F(B . ?\x4FDF) ; <CJK>
     (?$(C^G(B . ?\x50FF) ; <CJK>
     (?$(C^H(B . ?\x53F2) ; <CJK>
     (?$(C^I(B . ?\x53F8) ; <CJK>
     (?$(C^J(B . ?\x5506) ; <CJK>
     (?$(C^K(B . ?\x55E3) ; <CJK>
     (?$(C^L(B . ?\x56DB) ; <CJK>
     (?$(C^M(B . ?\x58EB) ; <CJK>
     (?$(C^N(B . ?\x5962) ; <CJK>
     (?$(C^O(B . ?\x5A11) ; <CJK>
     (?$(C^P(B . ?\x5BEB) ; <CJK>
     (?$(C^Q(B . ?\x5BFA) ; <CJK>
     (?$(C^R(B . ?\x5C04) ; <CJK>
     (?$(C^S(B . ?\x5DF3) ; <CJK>
     (?$(C^T(B . ?\x5E2B) ; <CJK>
     (?$(C^U(B . ?\x5F99) ; <CJK>
     (?$(C^V(B . ?\x601D) ; <CJK>
     (?$(C^W(B . ?\x6368) ; <CJK>
     (?$(C^X(B . ?\x659C) ; <CJK>
     (?$(C^Y(B . ?\x65AF) ; <CJK>
     (?$(C^Z(B . ?\x67F6) ; <CJK>
     (?$(C^[(B . ?\x67FB) ; <CJK>
     (?$(C^\(B . ?\x68AD) ; <CJK>
     (?$(C^](B . ?\x6B7B) ; <CJK>
     (?$(C^^(B . ?\x6C99) ; <CJK>
     (?$(C^_(B . ?\x6CD7) ; <CJK>
     (?$(C^`(B . ?\x6E23) ; <CJK>
     (?$(C^a(B . ?\x7009) ; <CJK>
     (?$(C^b(B . ?\x7345) ; <CJK>
     (?$(C^c(B . ?\x7802) ; <CJK>
     (?$(C^d(B . ?\x793E) ; <CJK>
     (?$(C^e(B . ?\x7940) ; <CJK>
     (?$(C^f(B . ?\x7960) ; <CJK>
     (?$(C^g(B . ?\x79C1) ; <CJK>
     (?$(C^h(B . ?\x7BE9) ; <CJK>
     (?$(C^i(B . ?\x7D17) ; <CJK>
     (?$(C^j(B . ?\x7D72) ; <CJK>
     (?$(C^k(B . ?\x8086) ; <CJK>
     (?$(C^l(B . ?\x820D) ; <CJK>
     (?$(C^m(B . ?\x838E) ; <CJK>
     (?$(C^n(B . ?\x84D1) ; <CJK>
     (?$(C^o(B . ?\x86C7) ; <CJK>
     (?$(C^p(B . ?\x88DF) ; <CJK>
     (?$(C^q(B . ?\x8A50) ; <CJK>
     (?$(C^r(B . ?\x8A5E) ; <CJK>
     (?$(C^s(B . ?\x8B1D) ; <CJK>
     (?$(C^t(B . ?\x8CDC) ; <CJK>
     (?$(C^u(B . ?\x8D66) ; <CJK>
     (?$(C^v(B . ?\x8FAD) ; <CJK>
     (?$(C^w(B . ?\x90AA) ; <CJK>
     (?$(C^x(B . ?\x98FC) ; <CJK>
     (?$(C^y(B . ?\x99DF) ; <CJK>
     (?$(C^z(B . ?\x9E9D) ; <CJK>
     (?$(C^{(B . ?\x524A) ; <CJK>
     (?$(C^|(B . ?\xF969) ; <CJK>
     (?$(C^}(B . ?\x6714) ; <CJK>
     (?$(C^~(B . ?\xF96A) ; <CJK>
     (?$(C_!(B . ?\x5098) ; <CJK>
     (?$(C_"(B . ?\x522A) ; <CJK>
     (?$(C_#(B . ?\x5C71) ; <CJK>
     (?$(C_$(B . ?\x6563) ; <CJK>
     (?$(C_%(B . ?\x6C55) ; <CJK>
     (?$(C_&(B . ?\x73CA) ; <CJK>
     (?$(C_'(B . ?\x7523) ; <CJK>
     (?$(C_((B . ?\x759D) ; <CJK>
     (?$(C_)(B . ?\x7B97) ; <CJK>
     (?$(C_*(B . ?\x849C) ; <CJK>
     (?$(C_+(B . ?\x9178) ; <CJK>
     (?$(C_,(B . ?\x9730) ; <CJK>
     (?$(C_-(B . ?\x4E77) ; <CJK>
     (?$(C_.(B . ?\x6492) ; <CJK>
     (?$(C_/(B . ?\x6BBA) ; <CJK>
     (?$(C_0(B . ?\x715E) ; <CJK>
     (?$(C_1(B . ?\x85A9) ; <CJK>
     (?$(C_2(B . ?\x4E09) ; <CJK>
     (?$(C_3(B . ?\xF96B) ; <CJK>
     (?$(C_4(B . ?\x6749) ; <CJK>
     (?$(C_5(B . ?\x68EE) ; <CJK>
     (?$(C_6(B . ?\x6E17) ; <CJK>
     (?$(C_7(B . ?\x829F) ; <CJK>
     (?$(C_8(B . ?\x8518) ; <CJK>
     (?$(C_9(B . ?\x886B) ; <CJK>
     (?$(C_:(B . ?\x63F7) ; <CJK>
     (?$(C_;(B . ?\x6F81) ; <CJK>
     (?$(C_<(B . ?\x9212) ; <CJK>
     (?$(C_=(B . ?\x98AF) ; <CJK>
     (?$(C_>(B . ?\x4E0A) ; <CJK>
     (?$(C_?(B . ?\x50B7) ; <CJK>
     (?$(C_@(B . ?\x50CF) ; <CJK>
     (?$(C_A(B . ?\x511F) ; <CJK>
     (?$(C_B(B . ?\x5546) ; <CJK>
     (?$(C_C(B . ?\x55AA) ; <CJK>
     (?$(C_D(B . ?\x5617) ; <CJK>
     (?$(C_E(B . ?\x5B40) ; <CJK>
     (?$(C_F(B . ?\x5C19) ; <CJK>
     (?$(C_G(B . ?\x5CE0) ; <CJK>
     (?$(C_H(B . ?\x5E38) ; <CJK>
     (?$(C_I(B . ?\x5E8A) ; <CJK>
     (?$(C_J(B . ?\x5EA0) ; <CJK>
     (?$(C_K(B . ?\x5EC2) ; <CJK>
     (?$(C_L(B . ?\x60F3) ; <CJK>
     (?$(C_M(B . ?\x6851) ; <CJK>
     (?$(C_N(B . ?\x6A61) ; <CJK>
     (?$(C_O(B . ?\x6E58) ; <CJK>
     (?$(C_P(B . ?\x723D) ; <CJK>
     (?$(C_Q(B . ?\x7240) ; <CJK>
     (?$(C_R(B . ?\x72C0) ; <CJK>
     (?$(C_S(B . ?\x76F8) ; <CJK>
     (?$(C_T(B . ?\x7965) ; <CJK>
     (?$(C_U(B . ?\x7BB1) ; <CJK>
     (?$(C_V(B . ?\x7FD4) ; <CJK>
     (?$(C_W(B . ?\x88F3) ; <CJK>
     (?$(C_X(B . ?\x89F4) ; <CJK>
     (?$(C_Y(B . ?\x8A73) ; <CJK>
     (?$(C_Z(B . ?\x8C61) ; <CJK>
     (?$(C_[(B . ?\x8CDE) ; <CJK>
     (?$(C_\(B . ?\x971C) ; <CJK>
     (?$(C_](B . ?\x585E) ; <CJK>
     (?$(C_^(B . ?\x74BD) ; <CJK>
     (?$(C__(B . ?\x8CFD) ; <CJK>
     (?$(C_`(B . ?\x55C7) ; <CJK>
     (?$(C_a(B . ?\xF96C) ; <CJK>
     (?$(C_b(B . ?\x7A61) ; <CJK>
     (?$(C_c(B . ?\x7D22) ; <CJK>
     (?$(C_d(B . ?\x8272) ; <CJK>
     (?$(C_e(B . ?\x7272) ; <CJK>
     (?$(C_f(B . ?\x751F) ; <CJK>
     (?$(C_g(B . ?\x7525) ; <CJK>
     (?$(C_h(B . ?\xF96D) ; <CJK>
     (?$(C_i(B . ?\x7B19) ; <CJK>
     (?$(C_j(B . ?\x5885) ; <CJK>
     (?$(C_k(B . ?\x58FB) ; <CJK>
     (?$(C_l(B . ?\x5DBC) ; <CJK>
     (?$(C_m(B . ?\x5E8F) ; <CJK>
     (?$(C_n(B . ?\x5EB6) ; <CJK>
     (?$(C_o(B . ?\x5F90) ; <CJK>
     (?$(C_p(B . ?\x6055) ; <CJK>
     (?$(C_q(B . ?\x6292) ; <CJK>
     (?$(C_r(B . ?\x637F) ; <CJK>
     (?$(C_s(B . ?\x654D) ; <CJK>
     (?$(C_t(B . ?\x6691) ; <CJK>
     (?$(C_u(B . ?\x66D9) ; <CJK>
     (?$(C_v(B . ?\x66F8) ; <CJK>
     (?$(C_w(B . ?\x6816) ; <CJK>
     (?$(C_x(B . ?\x68F2) ; <CJK>
     (?$(C_y(B . ?\x7280) ; <CJK>
     (?$(C_z(B . ?\x745E) ; <CJK>
     (?$(C_{(B . ?\x7B6E) ; <CJK>
     (?$(C_|(B . ?\x7D6E) ; <CJK>
     (?$(C_}(B . ?\x7DD6) ; <CJK>
     (?$(C_~(B . ?\x7F72) ; <CJK>
     (?$(C`!(B . ?\x80E5) ; <CJK>
     (?$(C`"(B . ?\x8212) ; <CJK>
     (?$(C`#(B . ?\x85AF) ; <CJK>
     (?$(C`$(B . ?\x897F) ; <CJK>
     (?$(C`%(B . ?\x8A93) ; <CJK>
     (?$(C`&(B . ?\x901D) ; <CJK>
     (?$(C`'(B . ?\x92E4) ; <CJK>
     (?$(C`((B . ?\x9ECD) ; <CJK>
     (?$(C`)(B . ?\x9F20) ; <CJK>
     (?$(C`*(B . ?\x5915) ; <CJK>
     (?$(C`+(B . ?\x596D) ; <CJK>
     (?$(C`,(B . ?\x5E2D) ; <CJK>
     (?$(C`-(B . ?\x60DC) ; <CJK>
     (?$(C`.(B . ?\x6614) ; <CJK>
     (?$(C`/(B . ?\x6673) ; <CJK>
     (?$(C`0(B . ?\x6790) ; <CJK>
     (?$(C`1(B . ?\x6C50) ; <CJK>
     (?$(C`2(B . ?\x6DC5) ; <CJK>
     (?$(C`3(B . ?\x6F5F) ; <CJK>
     (?$(C`4(B . ?\x77F3) ; <CJK>
     (?$(C`5(B . ?\x78A9) ; <CJK>
     (?$(C`6(B . ?\x84C6) ; <CJK>
     (?$(C`7(B . ?\x91CB) ; <CJK>
     (?$(C`8(B . ?\x932B) ; <CJK>
     (?$(C`9(B . ?\x4ED9) ; <CJK>
     (?$(C`:(B . ?\x50CA) ; <CJK>
     (?$(C`;(B . ?\x5148) ; <CJK>
     (?$(C`<(B . ?\x5584) ; <CJK>
     (?$(C`=(B . ?\x5B0B) ; <CJK>
     (?$(C`>(B . ?\x5BA3) ; <CJK>
     (?$(C`?(B . ?\x6247) ; <CJK>
     (?$(C`@(B . ?\x657E) ; <CJK>
     (?$(C`A(B . ?\x65CB) ; <CJK>
     (?$(C`B(B . ?\x6E32) ; <CJK>
     (?$(C`C(B . ?\x717D) ; <CJK>
     (?$(C`D(B . ?\x7401) ; <CJK>
     (?$(C`E(B . ?\x7444) ; <CJK>
     (?$(C`F(B . ?\x7487) ; <CJK>
     (?$(C`G(B . ?\x74BF) ; <CJK>
     (?$(C`H(B . ?\x766C) ; <CJK>
     (?$(C`I(B . ?\x79AA) ; <CJK>
     (?$(C`J(B . ?\x7DDA) ; <CJK>
     (?$(C`K(B . ?\x7E55) ; <CJK>
     (?$(C`L(B . ?\x7FA8) ; <CJK>
     (?$(C`M(B . ?\x817A) ; <CJK>
     (?$(C`N(B . ?\x81B3) ; <CJK>
     (?$(C`O(B . ?\x8239) ; <CJK>
     (?$(C`P(B . ?\x861A) ; <CJK>
     (?$(C`Q(B . ?\x87EC) ; <CJK>
     (?$(C`R(B . ?\x8A75) ; <CJK>
     (?$(C`S(B . ?\x8DE3) ; <CJK>
     (?$(C`T(B . ?\x9078) ; <CJK>
     (?$(C`U(B . ?\x9291) ; <CJK>
     (?$(C`V(B . ?\x9425) ; <CJK>
     (?$(C`W(B . ?\x994D) ; <CJK>
     (?$(C`X(B . ?\x9BAE) ; <CJK>
     (?$(C`Y(B . ?\x5368) ; <CJK>
     (?$(C`Z(B . ?\x5C51) ; <CJK>
     (?$(C`[(B . ?\x6954) ; <CJK>
     (?$(C`\(B . ?\x6CC4) ; <CJK>
     (?$(C`](B . ?\x6D29) ; <CJK>
     (?$(C`^(B . ?\x6E2B) ; <CJK>
     (?$(C`_(B . ?\x820C) ; <CJK>
     (?$(C``(B . ?\x859B) ; <CJK>
     (?$(C`a(B . ?\x893B) ; <CJK>
     (?$(C`b(B . ?\x8A2D) ; <CJK>
     (?$(C`c(B . ?\x8AAA) ; <CJK>
     (?$(C`d(B . ?\x96EA) ; <CJK>
     (?$(C`e(B . ?\x9F67) ; <CJK>
     (?$(C`f(B . ?\x5261) ; <CJK>
     (?$(C`g(B . ?\x66B9) ; <CJK>
     (?$(C`h(B . ?\x6BB2) ; <CJK>
     (?$(C`i(B . ?\x7E96) ; <CJK>
     (?$(C`j(B . ?\x87FE) ; <CJK>
     (?$(C`k(B . ?\x8D0D) ; <CJK>
     (?$(C`l(B . ?\x9583) ; <CJK>
     (?$(C`m(B . ?\x965D) ; <CJK>
     (?$(C`n(B . ?\x651D) ; <CJK>
     (?$(C`o(B . ?\x6D89) ; <CJK>
     (?$(C`p(B . ?\x71EE) ; <CJK>
     (?$(C`q(B . ?\xF96E) ; <CJK>
     (?$(C`r(B . ?\x57CE) ; <CJK>
     (?$(C`s(B . ?\x59D3) ; <CJK>
     (?$(C`t(B . ?\x5BAC) ; <CJK>
     (?$(C`u(B . ?\x6027) ; <CJK>
     (?$(C`v(B . ?\x60FA) ; <CJK>
     (?$(C`w(B . ?\x6210) ; <CJK>
     (?$(C`x(B . ?\x661F) ; <CJK>
     (?$(C`y(B . ?\x665F) ; <CJK>
     (?$(C`z(B . ?\x7329) ; <CJK>
     (?$(C`{(B . ?\x73F9) ; <CJK>
     (?$(C`|(B . ?\x76DB) ; <CJK>
     (?$(C`}(B . ?\x7701) ; <CJK>
     (?$(C`~(B . ?\x7B6C) ; <CJK>
     (?$(Ca!(B . ?\x8056) ; <CJK>
     (?$(Ca"(B . ?\x8072) ; <CJK>
     (?$(Ca#(B . ?\x8165) ; <CJK>
     (?$(Ca$(B . ?\x8AA0) ; <CJK>
     (?$(Ca%(B . ?\x9192) ; <CJK>
     (?$(Ca&(B . ?\x4E16) ; <CJK>
     (?$(Ca'(B . ?\x52E2) ; <CJK>
     (?$(Ca((B . ?\x6B72) ; <CJK>
     (?$(Ca)(B . ?\x6D17) ; <CJK>
     (?$(Ca*(B . ?\x7A05) ; <CJK>
     (?$(Ca+(B . ?\x7B39) ; <CJK>
     (?$(Ca,(B . ?\x7D30) ; <CJK>
     (?$(Ca-(B . ?\xF96F) ; <CJK>
     (?$(Ca.(B . ?\x8CB0) ; <CJK>
     (?$(Ca/(B . ?\x53EC) ; <CJK>
     (?$(Ca0(B . ?\x562F) ; <CJK>
     (?$(Ca1(B . ?\x5851) ; <CJK>
     (?$(Ca2(B . ?\x5BB5) ; <CJK>
     (?$(Ca3(B . ?\x5C0F) ; <CJK>
     (?$(Ca4(B . ?\x5C11) ; <CJK>
     (?$(Ca5(B . ?\x5DE2) ; <CJK>
     (?$(Ca6(B . ?\x6240) ; <CJK>
     (?$(Ca7(B . ?\x6383) ; <CJK>
     (?$(Ca8(B . ?\x6414) ; <CJK>
     (?$(Ca9(B . ?\x662D) ; <CJK>
     (?$(Ca:(B . ?\x68B3) ; <CJK>
     (?$(Ca;(B . ?\x6CBC) ; <CJK>
     (?$(Ca<(B . ?\x6D88) ; <CJK>
     (?$(Ca=(B . ?\x6EAF) ; <CJK>
     (?$(Ca>(B . ?\x701F) ; <CJK>
     (?$(Ca?(B . ?\x70A4) ; <CJK>
     (?$(Ca@(B . ?\x71D2) ; <CJK>
     (?$(CaA(B . ?\x7526) ; <CJK>
     (?$(CaB(B . ?\x758F) ; <CJK>
     (?$(CaC(B . ?\x758E) ; <CJK>
     (?$(CaD(B . ?\x7619) ; <CJK>
     (?$(CaE(B . ?\x7B11) ; <CJK>
     (?$(CaF(B . ?\x7BE0) ; <CJK>
     (?$(CaG(B . ?\x7C2B) ; <CJK>
     (?$(CaH(B . ?\x7D20) ; <CJK>
     (?$(CaI(B . ?\x7D39) ; <CJK>
     (?$(CaJ(B . ?\x852C) ; <CJK>
     (?$(CaK(B . ?\x856D) ; <CJK>
     (?$(CaL(B . ?\x8607) ; <CJK>
     (?$(CaM(B . ?\x8A34) ; <CJK>
     (?$(CaN(B . ?\x900D) ; <CJK>
     (?$(CaO(B . ?\x9061) ; <CJK>
     (?$(CaP(B . ?\x90B5) ; <CJK>
     (?$(CaQ(B . ?\x92B7) ; <CJK>
     (?$(CaR(B . ?\x97F6) ; <CJK>
     (?$(CaS(B . ?\x9A37) ; <CJK>
     (?$(CaT(B . ?\x4FD7) ; <CJK>
     (?$(CaU(B . ?\x5C6C) ; <CJK>
     (?$(CaV(B . ?\x675F) ; <CJK>
     (?$(CaW(B . ?\x6D91) ; <CJK>
     (?$(CaX(B . ?\x7C9F) ; <CJK>
     (?$(CaY(B . ?\x7E8C) ; <CJK>
     (?$(CaZ(B . ?\x8B16) ; <CJK>
     (?$(Ca[(B . ?\x8D16) ; <CJK>
     (?$(Ca\(B . ?\x901F) ; <CJK>
     (?$(Ca](B . ?\x5B6B) ; <CJK>
     (?$(Ca^(B . ?\x5DFD) ; <CJK>
     (?$(Ca_(B . ?\x640D) ; <CJK>
     (?$(Ca`(B . ?\x84C0) ; <CJK>
     (?$(Caa(B . ?\x905C) ; <CJK>
     (?$(Cab(B . ?\x98E1) ; <CJK>
     (?$(Cac(B . ?\x7387) ; <CJK>
     (?$(Cad(B . ?\x5B8B) ; <CJK>
     (?$(Cae(B . ?\x609A) ; <CJK>
     (?$(Caf(B . ?\x677E) ; <CJK>
     (?$(Cag(B . ?\x6DDE) ; <CJK>
     (?$(Cah(B . ?\x8A1F) ; <CJK>
     (?$(Cai(B . ?\x8AA6) ; <CJK>
     (?$(Caj(B . ?\x9001) ; <CJK>
     (?$(Cak(B . ?\x980C) ; <CJK>
     (?$(Cal(B . ?\x5237) ; <CJK>
     (?$(Cam(B . ?\xF970) ; <CJK>
     (?$(Can(B . ?\x7051) ; <CJK>
     (?$(Cao(B . ?\x788E) ; <CJK>
     (?$(Cap(B . ?\x9396) ; <CJK>
     (?$(Caq(B . ?\x8870) ; <CJK>
     (?$(Car(B . ?\x91D7) ; <CJK>
     (?$(Cas(B . ?\x4FEE) ; <CJK>
     (?$(Cat(B . ?\x53D7) ; <CJK>
     (?$(Cau(B . ?\x55FD) ; <CJK>
     (?$(Cav(B . ?\x56DA) ; <CJK>
     (?$(Caw(B . ?\x5782) ; <CJK>
     (?$(Cax(B . ?\x58FD) ; <CJK>
     (?$(Cay(B . ?\x5AC2) ; <CJK>
     (?$(Caz(B . ?\x5B88) ; <CJK>
     (?$(Ca{(B . ?\x5CAB) ; <CJK>
     (?$(Ca|(B . ?\x5CC0) ; <CJK>
     (?$(Ca}(B . ?\x5E25) ; <CJK>
     (?$(Ca~(B . ?\x6101) ; <CJK>
     (?$(Cb!(B . ?\x620D) ; <CJK>
     (?$(Cb"(B . ?\x624B) ; <CJK>
     (?$(Cb#(B . ?\x6388) ; <CJK>
     (?$(Cb$(B . ?\x641C) ; <CJK>
     (?$(Cb%(B . ?\x6536) ; <CJK>
     (?$(Cb&(B . ?\x6578) ; <CJK>
     (?$(Cb'(B . ?\x6A39) ; <CJK>
     (?$(Cb((B . ?\x6B8A) ; <CJK>
     (?$(Cb)(B . ?\x6C34) ; <CJK>
     (?$(Cb*(B . ?\x6D19) ; <CJK>
     (?$(Cb+(B . ?\x6F31) ; <CJK>
     (?$(Cb,(B . ?\x71E7) ; <CJK>
     (?$(Cb-(B . ?\x72E9) ; <CJK>
     (?$(Cb.(B . ?\x7378) ; <CJK>
     (?$(Cb/(B . ?\x7407) ; <CJK>
     (?$(Cb0(B . ?\x74B2) ; <CJK>
     (?$(Cb1(B . ?\x7626) ; <CJK>
     (?$(Cb2(B . ?\x7761) ; <CJK>
     (?$(Cb3(B . ?\x79C0) ; <CJK>
     (?$(Cb4(B . ?\x7A57) ; <CJK>
     (?$(Cb5(B . ?\x7AEA) ; <CJK>
     (?$(Cb6(B . ?\x7CB9) ; <CJK>
     (?$(Cb7(B . ?\x7D8F) ; <CJK>
     (?$(Cb8(B . ?\x7DAC) ; <CJK>
     (?$(Cb9(B . ?\x7E61) ; <CJK>
     (?$(Cb:(B . ?\x7F9E) ; <CJK>
     (?$(Cb;(B . ?\x8129) ; <CJK>
     (?$(Cb<(B . ?\x8331) ; <CJK>
     (?$(Cb=(B . ?\x8490) ; <CJK>
     (?$(Cb>(B . ?\x84DA) ; <CJK>
     (?$(Cb?(B . ?\x85EA) ; <CJK>
     (?$(Cb@(B . ?\x8896) ; <CJK>
     (?$(CbA(B . ?\x8AB0) ; <CJK>
     (?$(CbB(B . ?\x8B90) ; <CJK>
     (?$(CbC(B . ?\x8F38) ; <CJK>
     (?$(CbD(B . ?\x9042) ; <CJK>
     (?$(CbE(B . ?\x9083) ; <CJK>
     (?$(CbF(B . ?\x916C) ; <CJK>
     (?$(CbG(B . ?\x9296) ; <CJK>
     (?$(CbH(B . ?\x92B9) ; <CJK>
     (?$(CbI(B . ?\x968B) ; <CJK>
     (?$(CbJ(B . ?\x96A7) ; <CJK>
     (?$(CbK(B . ?\x96A8) ; <CJK>
     (?$(CbL(B . ?\x96D6) ; <CJK>
     (?$(CbM(B . ?\x9700) ; <CJK>
     (?$(CbN(B . ?\x9808) ; <CJK>
     (?$(CbO(B . ?\x9996) ; <CJK>
     (?$(CbP(B . ?\x9AD3) ; <CJK>
     (?$(CbQ(B . ?\x9B1A) ; <CJK>
     (?$(CbR(B . ?\x53D4) ; <CJK>
     (?$(CbS(B . ?\x587E) ; <CJK>
     (?$(CbT(B . ?\x5919) ; <CJK>
     (?$(CbU(B . ?\x5B70) ; <CJK>
     (?$(CbV(B . ?\x5BBF) ; <CJK>
     (?$(CbW(B . ?\x6DD1) ; <CJK>
     (?$(CbX(B . ?\x6F5A) ; <CJK>
     (?$(CbY(B . ?\x719F) ; <CJK>
     (?$(CbZ(B . ?\x7421) ; <CJK>
     (?$(Cb[(B . ?\x74B9) ; <CJK>
     (?$(Cb\(B . ?\x8085) ; <CJK>
     (?$(Cb](B . ?\x83FD) ; <CJK>
     (?$(Cb^(B . ?\x5DE1) ; <CJK>
     (?$(Cb_(B . ?\x5F87) ; <CJK>
     (?$(Cb`(B . ?\x5FAA) ; <CJK>
     (?$(Cba(B . ?\x6042) ; <CJK>
     (?$(Cbb(B . ?\x65EC) ; <CJK>
     (?$(Cbc(B . ?\x6812) ; <CJK>
     (?$(Cbd(B . ?\x696F) ; <CJK>
     (?$(Cbe(B . ?\x6A53) ; <CJK>
     (?$(Cbf(B . ?\x6B89) ; <CJK>
     (?$(Cbg(B . ?\x6D35) ; <CJK>
     (?$(Cbh(B . ?\x6DF3) ; <CJK>
     (?$(Cbi(B . ?\x73E3) ; <CJK>
     (?$(Cbj(B . ?\x76FE) ; <CJK>
     (?$(Cbk(B . ?\x77AC) ; <CJK>
     (?$(Cbl(B . ?\x7B4D) ; <CJK>
     (?$(Cbm(B . ?\x7D14) ; <CJK>
     (?$(Cbn(B . ?\x8123) ; <CJK>
     (?$(Cbo(B . ?\x821C) ; <CJK>
     (?$(Cbp(B . ?\x8340) ; <CJK>
     (?$(Cbq(B . ?\x84F4) ; <CJK>
     (?$(Cbr(B . ?\x8563) ; <CJK>
     (?$(Cbs(B . ?\x8A62) ; <CJK>
     (?$(Cbt(B . ?\x8AC4) ; <CJK>
     (?$(Cbu(B . ?\x9187) ; <CJK>
     (?$(Cbv(B . ?\x931E) ; <CJK>
     (?$(Cbw(B . ?\x9806) ; <CJK>
     (?$(Cbx(B . ?\x99B4) ; <CJK>
     (?$(Cby(B . ?\x620C) ; <CJK>
     (?$(Cbz(B . ?\x8853) ; <CJK>
     (?$(Cb{(B . ?\x8FF0) ; <CJK>
     (?$(Cb|(B . ?\x9265) ; <CJK>
     (?$(Cb}(B . ?\x5D07) ; <CJK>
     (?$(Cb~(B . ?\x5D27) ; <CJK>
     (?$(Cc!(B . ?\x5D69) ; <CJK>
     (?$(Cc"(B . ?\x745F) ; <CJK>
     (?$(Cc#(B . ?\x819D) ; <CJK>
     (?$(Cc$(B . ?\x8768) ; <CJK>
     (?$(Cc%(B . ?\x6FD5) ; <CJK>
     (?$(Cc&(B . ?\x62FE) ; <CJK>
     (?$(Cc'(B . ?\x7FD2) ; <CJK>
     (?$(Cc((B . ?\x8936) ; <CJK>
     (?$(Cc)(B . ?\x8972) ; <CJK>
     (?$(Cc*(B . ?\x4E1E) ; <CJK>
     (?$(Cc+(B . ?\x4E58) ; <CJK>
     (?$(Cc,(B . ?\x50E7) ; <CJK>
     (?$(Cc-(B . ?\x52DD) ; <CJK>
     (?$(Cc.(B . ?\x5347) ; <CJK>
     (?$(Cc/(B . ?\x627F) ; <CJK>
     (?$(Cc0(B . ?\x6607) ; <CJK>
     (?$(Cc1(B . ?\x7E69) ; <CJK>
     (?$(Cc2(B . ?\x8805) ; <CJK>
     (?$(Cc3(B . ?\x965E) ; <CJK>
     (?$(Cc4(B . ?\x4F8D) ; <CJK>
     (?$(Cc5(B . ?\x5319) ; <CJK>
     (?$(Cc6(B . ?\x5636) ; <CJK>
     (?$(Cc7(B . ?\x59CB) ; <CJK>
     (?$(Cc8(B . ?\x5AA4) ; <CJK>
     (?$(Cc9(B . ?\x5C38) ; <CJK>
     (?$(Cc:(B . ?\x5C4E) ; <CJK>
     (?$(Cc;(B . ?\x5C4D) ; <CJK>
     (?$(Cc<(B . ?\x5E02) ; <CJK>
     (?$(Cc=(B . ?\x5F11) ; <CJK>
     (?$(Cc>(B . ?\x6043) ; <CJK>
     (?$(Cc?(B . ?\x65BD) ; <CJK>
     (?$(Cc@(B . ?\x662F) ; <CJK>
     (?$(CcA(B . ?\x6642) ; <CJK>
     (?$(CcB(B . ?\x67BE) ; <CJK>
     (?$(CcC(B . ?\x67F4) ; <CJK>
     (?$(CcD(B . ?\x731C) ; <CJK>
     (?$(CcE(B . ?\x77E2) ; <CJK>
     (?$(CcF(B . ?\x793A) ; <CJK>
     (?$(CcG(B . ?\x7FC5) ; <CJK>
     (?$(CcH(B . ?\x8494) ; <CJK>
     (?$(CcI(B . ?\x84CD) ; <CJK>
     (?$(CcJ(B . ?\x8996) ; <CJK>
     (?$(CcK(B . ?\x8A66) ; <CJK>
     (?$(CcL(B . ?\x8A69) ; <CJK>
     (?$(CcM(B . ?\x8AE1) ; <CJK>
     (?$(CcN(B . ?\x8C55) ; <CJK>
     (?$(CcO(B . ?\x8C7A) ; <CJK>
     (?$(CcP(B . ?\x57F4) ; <CJK>
     (?$(CcQ(B . ?\x5BD4) ; <CJK>
     (?$(CcR(B . ?\x5F0F) ; <CJK>
     (?$(CcS(B . ?\x606F) ; <CJK>
     (?$(CcT(B . ?\x62ED) ; <CJK>
     (?$(CcU(B . ?\x690D) ; <CJK>
     (?$(CcV(B . ?\x6B96) ; <CJK>
     (?$(CcW(B . ?\x6E5C) ; <CJK>
     (?$(CcX(B . ?\x7184) ; <CJK>
     (?$(CcY(B . ?\x7BD2) ; <CJK>
     (?$(CcZ(B . ?\x8755) ; <CJK>
     (?$(Cc[(B . ?\x8B58) ; <CJK>
     (?$(Cc\(B . ?\x8EFE) ; <CJK>
     (?$(Cc](B . ?\x98DF) ; <CJK>
     (?$(Cc^(B . ?\x98FE) ; <CJK>
     (?$(Cc_(B . ?\x4F38) ; <CJK>
     (?$(Cc`(B . ?\x4F81) ; <CJK>
     (?$(Cca(B . ?\x4FE1) ; <CJK>
     (?$(Ccb(B . ?\x547B) ; <CJK>
     (?$(Ccc(B . ?\x5A20) ; <CJK>
     (?$(Ccd(B . ?\x5BB8) ; <CJK>
     (?$(Cce(B . ?\x613C) ; <CJK>
     (?$(Ccf(B . ?\x65B0) ; <CJK>
     (?$(Ccg(B . ?\x6668) ; <CJK>
     (?$(Cch(B . ?\x71FC) ; <CJK>
     (?$(Cci(B . ?\x7533) ; <CJK>
     (?$(Ccj(B . ?\x795E) ; <CJK>
     (?$(Cck(B . ?\x7D33) ; <CJK>
     (?$(Ccl(B . ?\x814E) ; <CJK>
     (?$(Ccm(B . ?\x81E3) ; <CJK>
     (?$(Ccn(B . ?\x8398) ; <CJK>
     (?$(Cco(B . ?\x85AA) ; <CJK>
     (?$(Ccp(B . ?\x85CE) ; <CJK>
     (?$(Ccq(B . ?\x8703) ; <CJK>
     (?$(Ccr(B . ?\x8A0A) ; <CJK>
     (?$(Ccs(B . ?\x8EAB) ; <CJK>
     (?$(Cct(B . ?\x8F9B) ; <CJK>
     (?$(Ccu(B . ?\xF971) ; <CJK>
     (?$(Ccv(B . ?\x8FC5) ; <CJK>
     (?$(Ccw(B . ?\x5931) ; <CJK>
     (?$(Ccx(B . ?\x5BA4) ; <CJK>
     (?$(Ccy(B . ?\x5BE6) ; <CJK>
     (?$(Ccz(B . ?\x6089) ; <CJK>
     (?$(Cc{(B . ?\x5BE9) ; <CJK>
     (?$(Cc|(B . ?\x5C0B) ; <CJK>
     (?$(Cc}(B . ?\x5FC3) ; <CJK>
     (?$(Cc~(B . ?\x6C81) ; <CJK>
     (?$(Cd!(B . ?\xF972) ; <CJK>
     (?$(Cd"(B . ?\x6DF1) ; <CJK>
     (?$(Cd#(B . ?\x700B) ; <CJK>
     (?$(Cd$(B . ?\x751A) ; <CJK>
     (?$(Cd%(B . ?\x82AF) ; <CJK>
     (?$(Cd&(B . ?\x8AF6) ; <CJK>
     (?$(Cd'(B . ?\x4EC0) ; <CJK>
     (?$(Cd((B . ?\x5341) ; <CJK>
     (?$(Cd)(B . ?\xF973) ; <CJK>
     (?$(Cd*(B . ?\x96D9) ; <CJK>
     (?$(Cd+(B . ?\x6C0F) ; <CJK>
     (?$(Cd,(B . ?\x4E9E) ; <CJK>
     (?$(Cd-(B . ?\x4FC4) ; <CJK>
     (?$(Cd.(B . ?\x5152) ; <CJK>
     (?$(Cd/(B . ?\x555E) ; <CJK>
     (?$(Cd0(B . ?\x5A25) ; <CJK>
     (?$(Cd1(B . ?\x5CE8) ; <CJK>
     (?$(Cd2(B . ?\x6211) ; <CJK>
     (?$(Cd3(B . ?\x7259) ; <CJK>
     (?$(Cd4(B . ?\x82BD) ; <CJK>
     (?$(Cd5(B . ?\x83AA) ; <CJK>
     (?$(Cd6(B . ?\x86FE) ; <CJK>
     (?$(Cd7(B . ?\x8859) ; <CJK>
     (?$(Cd8(B . ?\x8A1D) ; <CJK>
     (?$(Cd9(B . ?\x963F) ; <CJK>
     (?$(Cd:(B . ?\x96C5) ; <CJK>
     (?$(Cd;(B . ?\x9913) ; <CJK>
     (?$(Cd<(B . ?\x9D09) ; <CJK>
     (?$(Cd=(B . ?\x9D5D) ; <CJK>
     (?$(Cd>(B . ?\x580A) ; <CJK>
     (?$(Cd?(B . ?\x5CB3) ; <CJK>
     (?$(Cd@(B . ?\x5DBD) ; <CJK>
     (?$(CdA(B . ?\x5E44) ; <CJK>
     (?$(CdB(B . ?\x60E1) ; <CJK>
     (?$(CdC(B . ?\x6115) ; <CJK>
     (?$(CdD(B . ?\x63E1) ; <CJK>
     (?$(CdE(B . ?\x6A02) ; <CJK>
     (?$(CdF(B . ?\x6E25) ; <CJK>
     (?$(CdG(B . ?\x9102) ; <CJK>
     (?$(CdH(B . ?\x9354) ; <CJK>
     (?$(CdI(B . ?\x984E) ; <CJK>
     (?$(CdJ(B . ?\x9C10) ; <CJK>
     (?$(CdK(B . ?\x9F77) ; <CJK>
     (?$(CdL(B . ?\x5B89) ; <CJK>
     (?$(CdM(B . ?\x5CB8) ; <CJK>
     (?$(CdN(B . ?\x6309) ; <CJK>
     (?$(CdO(B . ?\x664F) ; <CJK>
     (?$(CdP(B . ?\x6848) ; <CJK>
     (?$(CdQ(B . ?\x773C) ; <CJK>
     (?$(CdR(B . ?\x96C1) ; <CJK>
     (?$(CdS(B . ?\x978D) ; <CJK>
     (?$(CdT(B . ?\x9854) ; <CJK>
     (?$(CdU(B . ?\x9B9F) ; <CJK>
     (?$(CdV(B . ?\x65A1) ; <CJK>
     (?$(CdW(B . ?\x8B01) ; <CJK>
     (?$(CdX(B . ?\x8ECB) ; <CJK>
     (?$(CdY(B . ?\x95BC) ; <CJK>
     (?$(CdZ(B . ?\x5535) ; <CJK>
     (?$(Cd[(B . ?\x5CA9) ; <CJK>
     (?$(Cd\(B . ?\x5DD6) ; <CJK>
     (?$(Cd](B . ?\x5EB5) ; <CJK>
     (?$(Cd^(B . ?\x6697) ; <CJK>
     (?$(Cd_(B . ?\x764C) ; <CJK>
     (?$(Cd`(B . ?\x83F4) ; <CJK>
     (?$(Cda(B . ?\x95C7) ; <CJK>
     (?$(Cdb(B . ?\x58D3) ; <CJK>
     (?$(Cdc(B . ?\x62BC) ; <CJK>
     (?$(Cdd(B . ?\x72CE) ; <CJK>
     (?$(Cde(B . ?\x9D28) ; <CJK>
     (?$(Cdf(B . ?\x4EF0) ; <CJK>
     (?$(Cdg(B . ?\x592E) ; <CJK>
     (?$(Cdh(B . ?\x600F) ; <CJK>
     (?$(Cdi(B . ?\x663B) ; <CJK>
     (?$(Cdj(B . ?\x6B83) ; <CJK>
     (?$(Cdk(B . ?\x79E7) ; <CJK>
     (?$(Cdl(B . ?\x9D26) ; <CJK>
     (?$(Cdm(B . ?\x5393) ; <CJK>
     (?$(Cdn(B . ?\x54C0) ; <CJK>
     (?$(Cdo(B . ?\x57C3) ; <CJK>
     (?$(Cdp(B . ?\x5D16) ; <CJK>
     (?$(Cdq(B . ?\x611B) ; <CJK>
     (?$(Cdr(B . ?\x66D6) ; <CJK>
     (?$(Cds(B . ?\x6DAF) ; <CJK>
     (?$(Cdt(B . ?\x788D) ; <CJK>
     (?$(Cdu(B . ?\x827E) ; <CJK>
     (?$(Cdv(B . ?\x9698) ; <CJK>
     (?$(Cdw(B . ?\x9744) ; <CJK>
     (?$(Cdx(B . ?\x5384) ; <CJK>
     (?$(Cdy(B . ?\x627C) ; <CJK>
     (?$(Cdz(B . ?\x6396) ; <CJK>
     (?$(Cd{(B . ?\x6DB2) ; <CJK>
     (?$(Cd|(B . ?\x7E0A) ; <CJK>
     (?$(Cd}(B . ?\x814B) ; <CJK>
     (?$(Cd~(B . ?\x984D) ; <CJK>
     (?$(Ce!(B . ?\x6AFB) ; <CJK>
     (?$(Ce"(B . ?\x7F4C) ; <CJK>
     (?$(Ce#(B . ?\x9DAF) ; <CJK>
     (?$(Ce$(B . ?\x9E1A) ; <CJK>
     (?$(Ce%(B . ?\x4E5F) ; <CJK>
     (?$(Ce&(B . ?\x503B) ; <CJK>
     (?$(Ce'(B . ?\x51B6) ; <CJK>
     (?$(Ce((B . ?\x591C) ; <CJK>
     (?$(Ce)(B . ?\x60F9) ; <CJK>
     (?$(Ce*(B . ?\x63F6) ; <CJK>
     (?$(Ce+(B . ?\x6930) ; <CJK>
     (?$(Ce,(B . ?\x723A) ; <CJK>
     (?$(Ce-(B . ?\x8036) ; <CJK>
     (?$(Ce.(B . ?\xF974) ; <CJK>
     (?$(Ce/(B . ?\x91CE) ; <CJK>
     (?$(Ce0(B . ?\x5F31) ; <CJK>
     (?$(Ce1(B . ?\xF975) ; <CJK>
     (?$(Ce2(B . ?\xF976) ; <CJK>
     (?$(Ce3(B . ?\x7D04) ; <CJK>
     (?$(Ce4(B . ?\x82E5) ; <CJK>
     (?$(Ce5(B . ?\x846F) ; <CJK>
     (?$(Ce6(B . ?\x84BB) ; <CJK>
     (?$(Ce7(B . ?\x85E5) ; <CJK>
     (?$(Ce8(B . ?\x8E8D) ; <CJK>
     (?$(Ce9(B . ?\xF977) ; <CJK>
     (?$(Ce:(B . ?\x4F6F) ; <CJK>
     (?$(Ce;(B . ?\xF978) ; <CJK>
     (?$(Ce<(B . ?\xF979) ; <CJK>
     (?$(Ce=(B . ?\x58E4) ; <CJK>
     (?$(Ce>(B . ?\x5B43) ; <CJK>
     (?$(Ce?(B . ?\x6059) ; <CJK>
     (?$(Ce@(B . ?\x63DA) ; <CJK>
     (?$(CeA(B . ?\x6518) ; <CJK>
     (?$(CeB(B . ?\x656D) ; <CJK>
     (?$(CeC(B . ?\x6698) ; <CJK>
     (?$(CeD(B . ?\xF97A) ; <CJK>
     (?$(CeE(B . ?\x694A) ; <CJK>
     (?$(CeF(B . ?\x6A23) ; <CJK>
     (?$(CeG(B . ?\x6D0B) ; <CJK>
     (?$(CeH(B . ?\x7001) ; <CJK>
     (?$(CeI(B . ?\x716C) ; <CJK>
     (?$(CeJ(B . ?\x75D2) ; <CJK>
     (?$(CeK(B . ?\x760D) ; <CJK>
     (?$(CeL(B . ?\x79B3) ; <CJK>
     (?$(CeM(B . ?\x7A70) ; <CJK>
     (?$(CeN(B . ?\xF97B) ; <CJK>
     (?$(CeO(B . ?\x7F8A) ; <CJK>
     (?$(CeP(B . ?\xF97C) ; <CJK>
     (?$(CeQ(B . ?\x8944) ; <CJK>
     (?$(CeR(B . ?\xF97D) ; <CJK>
     (?$(CeS(B . ?\x8B93) ; <CJK>
     (?$(CeT(B . ?\x91C0) ; <CJK>
     (?$(CeU(B . ?\x967D) ; <CJK>
     (?$(CeV(B . ?\xF97E) ; <CJK>
     (?$(CeW(B . ?\x990A) ; <CJK>
     (?$(CeX(B . ?\x5704) ; <CJK>
     (?$(CeY(B . ?\x5FA1) ; <CJK>
     (?$(CeZ(B . ?\x65BC) ; <CJK>
     (?$(Ce[(B . ?\x6F01) ; <CJK>
     (?$(Ce\(B . ?\x7600) ; <CJK>
     (?$(Ce](B . ?\x79A6) ; <CJK>
     (?$(Ce^(B . ?\x8A9E) ; <CJK>
     (?$(Ce_(B . ?\x99AD) ; <CJK>
     (?$(Ce`(B . ?\x9B5A) ; <CJK>
     (?$(Cea(B . ?\x9F6C) ; <CJK>
     (?$(Ceb(B . ?\x5104) ; <CJK>
     (?$(Cec(B . ?\x61B6) ; <CJK>
     (?$(Ced(B . ?\x6291) ; <CJK>
     (?$(Cee(B . ?\x6A8D) ; <CJK>
     (?$(Cef(B . ?\x81C6) ; <CJK>
     (?$(Ceg(B . ?\x5043) ; <CJK>
     (?$(Ceh(B . ?\x5830) ; <CJK>
     (?$(Cei(B . ?\x5F66) ; <CJK>
     (?$(Cej(B . ?\x7109) ; <CJK>
     (?$(Cek(B . ?\x8A00) ; <CJK>
     (?$(Cel(B . ?\x8AFA) ; <CJK>
     (?$(Cem(B . ?\x5B7C) ; <CJK>
     (?$(Cen(B . ?\x8616) ; <CJK>
     (?$(Ceo(B . ?\x4FFA) ; <CJK>
     (?$(Cep(B . ?\x513C) ; <CJK>
     (?$(Ceq(B . ?\x56B4) ; <CJK>
     (?$(Cer(B . ?\x5944) ; <CJK>
     (?$(Ces(B . ?\x63A9) ; <CJK>
     (?$(Cet(B . ?\x6DF9) ; <CJK>
     (?$(Ceu(B . ?\x5DAA) ; <CJK>
     (?$(Cev(B . ?\x696D) ; <CJK>
     (?$(Cew(B . ?\x5186) ; <CJK>
     (?$(Cex(B . ?\x4E88) ; <CJK>
     (?$(Cey(B . ?\x4F59) ; <CJK>
     (?$(Cez(B . ?\xF97F) ; <CJK>
     (?$(Ce{(B . ?\xF980) ; <CJK>
     (?$(Ce|(B . ?\xF981) ; <CJK>
     (?$(Ce}(B . ?\x5982) ; <CJK>
     (?$(Ce~(B . ?\xF982) ; <CJK>
     (?$(Cf!(B . ?\xF983) ; <CJK>
     (?$(Cf"(B . ?\x6B5F) ; <CJK>
     (?$(Cf#(B . ?\x6C5D) ; <CJK>
     (?$(Cf$(B . ?\xF984) ; <CJK>
     (?$(Cf%(B . ?\x74B5) ; <CJK>
     (?$(Cf&(B . ?\x7916) ; <CJK>
     (?$(Cf'(B . ?\xF985) ; <CJK>
     (?$(Cf((B . ?\x8207) ; <CJK>
     (?$(Cf)(B . ?\x8245) ; <CJK>
     (?$(Cf*(B . ?\x8339) ; <CJK>
     (?$(Cf+(B . ?\x8F3F) ; <CJK>
     (?$(Cf,(B . ?\x8F5D) ; <CJK>
     (?$(Cf-(B . ?\xF986) ; <CJK>
     (?$(Cf.(B . ?\x9918) ; <CJK>
     (?$(Cf/(B . ?\xF987) ; <CJK>
     (?$(Cf0(B . ?\xF988) ; <CJK>
     (?$(Cf1(B . ?\xF989) ; <CJK>
     (?$(Cf2(B . ?\x4EA6) ; <CJK>
     (?$(Cf3(B . ?\xF98A) ; <CJK>
     (?$(Cf4(B . ?\x57DF) ; <CJK>
     (?$(Cf5(B . ?\x5F79) ; <CJK>
     (?$(Cf6(B . ?\x6613) ; <CJK>
     (?$(Cf7(B . ?\xF98B) ; <CJK>
     (?$(Cf8(B . ?\xF98C) ; <CJK>
     (?$(Cf9(B . ?\x75AB) ; <CJK>
     (?$(Cf:(B . ?\x7E79) ; <CJK>
     (?$(Cf;(B . ?\x8B6F) ; <CJK>
     (?$(Cf<(B . ?\xF98D) ; <CJK>
     (?$(Cf=(B . ?\x9006) ; <CJK>
     (?$(Cf>(B . ?\x9A5B) ; <CJK>
     (?$(Cf?(B . ?\x56A5) ; <CJK>
     (?$(Cf@(B . ?\x5827) ; <CJK>
     (?$(CfA(B . ?\x59F8) ; <CJK>
     (?$(CfB(B . ?\x5A1F) ; <CJK>
     (?$(CfC(B . ?\x5BB4) ; <CJK>
     (?$(CfD(B . ?\xF98E) ; <CJK>
     (?$(CfE(B . ?\x5EF6) ; <CJK>
     (?$(CfF(B . ?\xF98F) ; <CJK>
     (?$(CfG(B . ?\xF990) ; <CJK>
     (?$(CfH(B . ?\x6350) ; <CJK>
     (?$(CfI(B . ?\x633B) ; <CJK>
     (?$(CfJ(B . ?\xF991) ; <CJK>
     (?$(CfK(B . ?\x693D) ; <CJK>
     (?$(CfL(B . ?\x6C87) ; <CJK>
     (?$(CfM(B . ?\x6CBF) ; <CJK>
     (?$(CfN(B . ?\x6D8E) ; <CJK>
     (?$(CfO(B . ?\x6D93) ; <CJK>
     (?$(CfP(B . ?\x6DF5) ; <CJK>
     (?$(CfQ(B . ?\x6F14) ; <CJK>
     (?$(CfR(B . ?\xF992) ; <CJK>
     (?$(CfS(B . ?\x70DF) ; <CJK>
     (?$(CfT(B . ?\x7136) ; <CJK>
     (?$(CfU(B . ?\x7159) ; <CJK>
     (?$(CfV(B . ?\xF993) ; <CJK>
     (?$(CfW(B . ?\x71C3) ; <CJK>
     (?$(CfX(B . ?\x71D5) ; <CJK>
     (?$(CfY(B . ?\xF994) ; <CJK>
     (?$(CfZ(B . ?\x784F) ; <CJK>
     (?$(Cf[(B . ?\x786F) ; <CJK>
     (?$(Cf\(B . ?\xF995) ; <CJK>
     (?$(Cf](B . ?\x7B75) ; <CJK>
     (?$(Cf^(B . ?\x7DE3) ; <CJK>
     (?$(Cf_(B . ?\xF996) ; <CJK>
     (?$(Cf`(B . ?\x7E2F) ; <CJK>
     (?$(Cfa(B . ?\xF997) ; <CJK>
     (?$(Cfb(B . ?\x884D) ; <CJK>
     (?$(Cfc(B . ?\x8EDF) ; <CJK>
     (?$(Cfd(B . ?\xF998) ; <CJK>
     (?$(Cfe(B . ?\xF999) ; <CJK>
     (?$(Cff(B . ?\xF99A) ; <CJK>
     (?$(Cfg(B . ?\x925B) ; <CJK>
     (?$(Cfh(B . ?\xF99B) ; <CJK>
     (?$(Cfi(B . ?\x9CF6) ; <CJK>
     (?$(Cfj(B . ?\xF99C) ; <CJK>
     (?$(Cfk(B . ?\xF99D) ; <CJK>
     (?$(Cfl(B . ?\xF99E) ; <CJK>
     (?$(Cfm(B . ?\x6085) ; <CJK>
     (?$(Cfn(B . ?\x6D85) ; <CJK>
     (?$(Cfo(B . ?\xF99F) ; <CJK>
     (?$(Cfp(B . ?\x71B1) ; <CJK>
     (?$(Cfq(B . ?\xF9A0) ; <CJK>
     (?$(Cfr(B . ?\xF9A1) ; <CJK>
     (?$(Cfs(B . ?\x95B1) ; <CJK>
     (?$(Cft(B . ?\x53AD) ; <CJK>
     (?$(Cfu(B . ?\xF9A2) ; <CJK>
     (?$(Cfv(B . ?\xF9A3) ; <CJK>
     (?$(Cfw(B . ?\xF9A4) ; <CJK>
     (?$(Cfx(B . ?\x67D3) ; <CJK>
     (?$(Cfy(B . ?\xF9A5) ; <CJK>
     (?$(Cfz(B . ?\x708E) ; <CJK>
     (?$(Cf{(B . ?\x7130) ; <CJK>
     (?$(Cf|(B . ?\x7430) ; <CJK>
     (?$(Cf}(B . ?\x8276) ; <CJK>
     (?$(Cf~(B . ?\x82D2) ; <CJK>
     (?$(Cg!(B . ?\xF9A6) ; <CJK>
     (?$(Cg"(B . ?\x95BB) ; <CJK>
     (?$(Cg#(B . ?\x9AE5) ; <CJK>
     (?$(Cg$(B . ?\x9E7D) ; <CJK>
     (?$(Cg%(B . ?\x66C4) ; <CJK>
     (?$(Cg&(B . ?\xF9A7) ; <CJK>
     (?$(Cg'(B . ?\x71C1) ; <CJK>
     (?$(Cg((B . ?\x8449) ; <CJK>
     (?$(Cg)(B . ?\xF9A8) ; <CJK>
     (?$(Cg*(B . ?\xF9A9) ; <CJK>
     (?$(Cg+(B . ?\x584B) ; <CJK>
     (?$(Cg,(B . ?\xF9AA) ; <CJK>
     (?$(Cg-(B . ?\xF9AB) ; <CJK>
     (?$(Cg.(B . ?\x5DB8) ; <CJK>
     (?$(Cg/(B . ?\x5F71) ; <CJK>
     (?$(Cg0(B . ?\xF9AC) ; <CJK>
     (?$(Cg1(B . ?\x6620) ; <CJK>
     (?$(Cg2(B . ?\x668E) ; <CJK>
     (?$(Cg3(B . ?\x6979) ; <CJK>
     (?$(Cg4(B . ?\x69AE) ; <CJK>
     (?$(Cg5(B . ?\x6C38) ; <CJK>
     (?$(Cg6(B . ?\x6CF3) ; <CJK>
     (?$(Cg7(B . ?\x6E36) ; <CJK>
     (?$(Cg8(B . ?\x6F41) ; <CJK>
     (?$(Cg9(B . ?\x6FDA) ; <CJK>
     (?$(Cg:(B . ?\x701B) ; <CJK>
     (?$(Cg;(B . ?\x702F) ; <CJK>
     (?$(Cg<(B . ?\x7150) ; <CJK>
     (?$(Cg=(B . ?\x71DF) ; <CJK>
     (?$(Cg>(B . ?\x7370) ; <CJK>
     (?$(Cg?(B . ?\xF9AD) ; <CJK>
     (?$(Cg@(B . ?\x745B) ; <CJK>
     (?$(CgA(B . ?\xF9AE) ; <CJK>
     (?$(CgB(B . ?\x74D4) ; <CJK>
     (?$(CgC(B . ?\x76C8) ; <CJK>
     (?$(CgD(B . ?\x7A4E) ; <CJK>
     (?$(CgE(B . ?\x7E93) ; <CJK>
     (?$(CgF(B . ?\xF9AF) ; <CJK>
     (?$(CgG(B . ?\xF9B0) ; <CJK>
     (?$(CgH(B . ?\x82F1) ; <CJK>
     (?$(CgI(B . ?\x8A60) ; <CJK>
     (?$(CgJ(B . ?\x8FCE) ; <CJK>
     (?$(CgK(B . ?\xF9B1) ; <CJK>
     (?$(CgL(B . ?\x9348) ; <CJK>
     (?$(CgM(B . ?\xF9B2) ; <CJK>
     (?$(CgN(B . ?\x9719) ; <CJK>
     (?$(CgO(B . ?\xF9B3) ; <CJK>
     (?$(CgP(B . ?\xF9B4) ; <CJK>
     (?$(CgQ(B . ?\x4E42) ; <CJK>
     (?$(CgR(B . ?\x502A) ; <CJK>
     (?$(CgS(B . ?\xF9B5) ; <CJK>
     (?$(CgT(B . ?\x5208) ; <CJK>
     (?$(CgU(B . ?\x53E1) ; <CJK>
     (?$(CgV(B . ?\x66F3) ; <CJK>
     (?$(CgW(B . ?\x6C6D) ; <CJK>
     (?$(CgX(B . ?\x6FCA) ; <CJK>
     (?$(CgY(B . ?\x730A) ; <CJK>
     (?$(CgZ(B . ?\x777F) ; <CJK>
     (?$(Cg[(B . ?\x7A62) ; <CJK>
     (?$(Cg\(B . ?\x82AE) ; <CJK>
     (?$(Cg](B . ?\x85DD) ; <CJK>
     (?$(Cg^(B . ?\x8602) ; <CJK>
     (?$(Cg_(B . ?\xF9B6) ; <CJK>
     (?$(Cg`(B . ?\x88D4) ; <CJK>
     (?$(Cga(B . ?\x8A63) ; <CJK>
     (?$(Cgb(B . ?\x8B7D) ; <CJK>
     (?$(Cgc(B . ?\x8C6B) ; <CJK>
     (?$(Cgd(B . ?\xF9B7) ; <CJK>
     (?$(Cge(B . ?\x92B3) ; <CJK>
     (?$(Cgf(B . ?\xF9B8) ; <CJK>
     (?$(Cgg(B . ?\x9713) ; <CJK>
     (?$(Cgh(B . ?\x9810) ; <CJK>
     (?$(Cgi(B . ?\x4E94) ; <CJK>
     (?$(Cgj(B . ?\x4F0D) ; <CJK>
     (?$(Cgk(B . ?\x4FC9) ; <CJK>
     (?$(Cgl(B . ?\x50B2) ; <CJK>
     (?$(Cgm(B . ?\x5348) ; <CJK>
     (?$(Cgn(B . ?\x543E) ; <CJK>
     (?$(Cgo(B . ?\x5433) ; <CJK>
     (?$(Cgp(B . ?\x55DA) ; <CJK>
     (?$(Cgq(B . ?\x5862) ; <CJK>
     (?$(Cgr(B . ?\x58BA) ; <CJK>
     (?$(Cgs(B . ?\x5967) ; <CJK>
     (?$(Cgt(B . ?\x5A1B) ; <CJK>
     (?$(Cgu(B . ?\x5BE4) ; <CJK>
     (?$(Cgv(B . ?\x609F) ; <CJK>
     (?$(Cgw(B . ?\xF9B9) ; <CJK>
     (?$(Cgx(B . ?\x61CA) ; <CJK>
     (?$(Cgy(B . ?\x6556) ; <CJK>
     (?$(Cgz(B . ?\x65FF) ; <CJK>
     (?$(Cg{(B . ?\x6664) ; <CJK>
     (?$(Cg|(B . ?\x68A7) ; <CJK>
     (?$(Cg}(B . ?\x6C5A) ; <CJK>
     (?$(Cg~(B . ?\x6FB3) ; <CJK>
     (?$(Ch!(B . ?\x70CF) ; <CJK>
     (?$(Ch"(B . ?\x71AC) ; <CJK>
     (?$(Ch#(B . ?\x7352) ; <CJK>
     (?$(Ch$(B . ?\x7B7D) ; <CJK>
     (?$(Ch%(B . ?\x8708) ; <CJK>
     (?$(Ch&(B . ?\x8AA4) ; <CJK>
     (?$(Ch'(B . ?\x9C32) ; <CJK>
     (?$(Ch((B . ?\x9F07) ; <CJK>
     (?$(Ch)(B . ?\x5C4B) ; <CJK>
     (?$(Ch*(B . ?\x6C83) ; <CJK>
     (?$(Ch+(B . ?\x7344) ; <CJK>
     (?$(Ch,(B . ?\x7389) ; <CJK>
     (?$(Ch-(B . ?\x923A) ; <CJK>
     (?$(Ch.(B . ?\x6EAB) ; <CJK>
     (?$(Ch/(B . ?\x7465) ; <CJK>
     (?$(Ch0(B . ?\x761F) ; <CJK>
     (?$(Ch1(B . ?\x7A69) ; <CJK>
     (?$(Ch2(B . ?\x7E15) ; <CJK>
     (?$(Ch3(B . ?\x860A) ; <CJK>
     (?$(Ch4(B . ?\x5140) ; <CJK>
     (?$(Ch5(B . ?\x58C5) ; <CJK>
     (?$(Ch6(B . ?\x64C1) ; <CJK>
     (?$(Ch7(B . ?\x74EE) ; <CJK>
     (?$(Ch8(B . ?\x7515) ; <CJK>
     (?$(Ch9(B . ?\x7670) ; <CJK>
     (?$(Ch:(B . ?\x7FC1) ; <CJK>
     (?$(Ch;(B . ?\x9095) ; <CJK>
     (?$(Ch<(B . ?\x96CD) ; <CJK>
     (?$(Ch=(B . ?\x9954) ; <CJK>
     (?$(Ch>(B . ?\x6E26) ; <CJK>
     (?$(Ch?(B . ?\x74E6) ; <CJK>
     (?$(Ch@(B . ?\x7AA9) ; <CJK>
     (?$(ChA(B . ?\x7AAA) ; <CJK>
     (?$(ChB(B . ?\x81E5) ; <CJK>
     (?$(ChC(B . ?\x86D9) ; <CJK>
     (?$(ChD(B . ?\x8778) ; <CJK>
     (?$(ChE(B . ?\x8A1B) ; <CJK>
     (?$(ChF(B . ?\x5A49) ; <CJK>
     (?$(ChG(B . ?\x5B8C) ; <CJK>
     (?$(ChH(B . ?\x5B9B) ; <CJK>
     (?$(ChI(B . ?\x68A1) ; <CJK>
     (?$(ChJ(B . ?\x6900) ; <CJK>
     (?$(ChK(B . ?\x6D63) ; <CJK>
     (?$(ChL(B . ?\x73A9) ; <CJK>
     (?$(ChM(B . ?\x7413) ; <CJK>
     (?$(ChN(B . ?\x742C) ; <CJK>
     (?$(ChO(B . ?\x7897) ; <CJK>
     (?$(ChP(B . ?\x7DE9) ; <CJK>
     (?$(ChQ(B . ?\x7FEB) ; <CJK>
     (?$(ChR(B . ?\x8118) ; <CJK>
     (?$(ChS(B . ?\x8155) ; <CJK>
     (?$(ChT(B . ?\x839E) ; <CJK>
     (?$(ChU(B . ?\x8C4C) ; <CJK>
     (?$(ChV(B . ?\x962E) ; <CJK>
     (?$(ChW(B . ?\x9811) ; <CJK>
     (?$(ChX(B . ?\x66F0) ; <CJK>
     (?$(ChY(B . ?\x5F80) ; <CJK>
     (?$(ChZ(B . ?\x65FA) ; <CJK>
     (?$(Ch[(B . ?\x6789) ; <CJK>
     (?$(Ch\(B . ?\x6C6A) ; <CJK>
     (?$(Ch](B . ?\x738B) ; <CJK>
     (?$(Ch^(B . ?\x502D) ; <CJK>
     (?$(Ch_(B . ?\x5A03) ; <CJK>
     (?$(Ch`(B . ?\x6B6A) ; <CJK>
     (?$(Cha(B . ?\x77EE) ; <CJK>
     (?$(Chb(B . ?\x5916) ; <CJK>
     (?$(Chc(B . ?\x5D6C) ; <CJK>
     (?$(Chd(B . ?\x5DCD) ; <CJK>
     (?$(Che(B . ?\x7325) ; <CJK>
     (?$(Chf(B . ?\x754F) ; <CJK>
     (?$(Chg(B . ?\xF9BA) ; <CJK>
     (?$(Chh(B . ?\xF9BB) ; <CJK>
     (?$(Chi(B . ?\x50E5) ; <CJK>
     (?$(Chj(B . ?\x51F9) ; <CJK>
     (?$(Chk(B . ?\x582F) ; <CJK>
     (?$(Chl(B . ?\x592D) ; <CJK>
     (?$(Chm(B . ?\x5996) ; <CJK>
     (?$(Chn(B . ?\x59DA) ; <CJK>
     (?$(Cho(B . ?\x5BE5) ; <CJK>
     (?$(Chp(B . ?\xF9BC) ; <CJK>
     (?$(Chq(B . ?\xF9BD) ; <CJK>
     (?$(Chr(B . ?\x5DA2) ; <CJK>
     (?$(Chs(B . ?\x62D7) ; <CJK>
     (?$(Cht(B . ?\x6416) ; <CJK>
     (?$(Chu(B . ?\x6493) ; <CJK>
     (?$(Chv(B . ?\x64FE) ; <CJK>
     (?$(Chw(B . ?\xF9BE) ; <CJK>
     (?$(Chx(B . ?\x66DC) ; <CJK>
     (?$(Chy(B . ?\xF9BF) ; <CJK>
     (?$(Chz(B . ?\x6A48) ; <CJK>
     (?$(Ch{(B . ?\xF9C0) ; <CJK>
     (?$(Ch|(B . ?\x71FF) ; <CJK>
     (?$(Ch}(B . ?\x7464) ; <CJK>
     (?$(Ch~(B . ?\xF9C1) ; <CJK>
     (?$(Ci!(B . ?\x7A88) ; <CJK>
     (?$(Ci"(B . ?\x7AAF) ; <CJK>
     (?$(Ci#(B . ?\x7E47) ; <CJK>
     (?$(Ci$(B . ?\x7E5E) ; <CJK>
     (?$(Ci%(B . ?\x8000) ; <CJK>
     (?$(Ci&(B . ?\x8170) ; <CJK>
     (?$(Ci'(B . ?\xF9C2) ; <CJK>
     (?$(Ci((B . ?\x87EF) ; <CJK>
     (?$(Ci)(B . ?\x8981) ; <CJK>
     (?$(Ci*(B . ?\x8B20) ; <CJK>
     (?$(Ci+(B . ?\x9059) ; <CJK>
     (?$(Ci,(B . ?\xF9C3) ; <CJK>
     (?$(Ci-(B . ?\x9080) ; <CJK>
     (?$(Ci.(B . ?\x9952) ; <CJK>
     (?$(Ci/(B . ?\x617E) ; <CJK>
     (?$(Ci0(B . ?\x6B32) ; <CJK>
     (?$(Ci1(B . ?\x6D74) ; <CJK>
     (?$(Ci2(B . ?\x7E1F) ; <CJK>
     (?$(Ci3(B . ?\x8925) ; <CJK>
     (?$(Ci4(B . ?\x8FB1) ; <CJK>
     (?$(Ci5(B . ?\x4FD1) ; <CJK>
     (?$(Ci6(B . ?\x50AD) ; <CJK>
     (?$(Ci7(B . ?\x5197) ; <CJK>
     (?$(Ci8(B . ?\x52C7) ; <CJK>
     (?$(Ci9(B . ?\x57C7) ; <CJK>
     (?$(Ci:(B . ?\x5889) ; <CJK>
     (?$(Ci;(B . ?\x5BB9) ; <CJK>
     (?$(Ci<(B . ?\x5EB8) ; <CJK>
     (?$(Ci=(B . ?\x6142) ; <CJK>
     (?$(Ci>(B . ?\x6995) ; <CJK>
     (?$(Ci?(B . ?\x6D8C) ; <CJK>
     (?$(Ci@(B . ?\x6E67) ; <CJK>
     (?$(CiA(B . ?\x6EB6) ; <CJK>
     (?$(CiB(B . ?\x7194) ; <CJK>
     (?$(CiC(B . ?\x7462) ; <CJK>
     (?$(CiD(B . ?\x7528) ; <CJK>
     (?$(CiE(B . ?\x752C) ; <CJK>
     (?$(CiF(B . ?\x8073) ; <CJK>
     (?$(CiG(B . ?\x8338) ; <CJK>
     (?$(CiH(B . ?\x84C9) ; <CJK>
     (?$(CiI(B . ?\x8E0A) ; <CJK>
     (?$(CiJ(B . ?\x9394) ; <CJK>
     (?$(CiK(B . ?\x93DE) ; <CJK>
     (?$(CiL(B . ?\xF9C4) ; <CJK>
     (?$(CiM(B . ?\x4E8E) ; <CJK>
     (?$(CiN(B . ?\x4F51) ; <CJK>
     (?$(CiO(B . ?\x5076) ; <CJK>
     (?$(CiP(B . ?\x512A) ; <CJK>
     (?$(CiQ(B . ?\x53C8) ; <CJK>
     (?$(CiR(B . ?\x53CB) ; <CJK>
     (?$(CiS(B . ?\x53F3) ; <CJK>
     (?$(CiT(B . ?\x5B87) ; <CJK>
     (?$(CiU(B . ?\x5BD3) ; <CJK>
     (?$(CiV(B . ?\x5C24) ; <CJK>
     (?$(CiW(B . ?\x611A) ; <CJK>
     (?$(CiX(B . ?\x6182) ; <CJK>
     (?$(CiY(B . ?\x65F4) ; <CJK>
     (?$(CiZ(B . ?\x725B) ; <CJK>
     (?$(Ci[(B . ?\x7397) ; <CJK>
     (?$(Ci\(B . ?\x7440) ; <CJK>
     (?$(Ci](B . ?\x76C2) ; <CJK>
     (?$(Ci^(B . ?\x7950) ; <CJK>
     (?$(Ci_(B . ?\x7991) ; <CJK>
     (?$(Ci`(B . ?\x79B9) ; <CJK>
     (?$(Cia(B . ?\x7D06) ; <CJK>
     (?$(Cib(B . ?\x7FBD) ; <CJK>
     (?$(Cic(B . ?\x828B) ; <CJK>
     (?$(Cid(B . ?\x85D5) ; <CJK>
     (?$(Cie(B . ?\x865E) ; <CJK>
     (?$(Cif(B . ?\x8FC2) ; <CJK>
     (?$(Cig(B . ?\x9047) ; <CJK>
     (?$(Cih(B . ?\x90F5) ; <CJK>
     (?$(Cii(B . ?\x91EA) ; <CJK>
     (?$(Cij(B . ?\x9685) ; <CJK>
     (?$(Cik(B . ?\x96E8) ; <CJK>
     (?$(Cil(B . ?\x96E9) ; <CJK>
     (?$(Cim(B . ?\x52D6) ; <CJK>
     (?$(Cin(B . ?\x5F67) ; <CJK>
     (?$(Cio(B . ?\x65ED) ; <CJK>
     (?$(Cip(B . ?\x6631) ; <CJK>
     (?$(Ciq(B . ?\x682F) ; <CJK>
     (?$(Cir(B . ?\x715C) ; <CJK>
     (?$(Cis(B . ?\x7A36) ; <CJK>
     (?$(Cit(B . ?\x90C1) ; <CJK>
     (?$(Ciu(B . ?\x980A) ; <CJK>
     (?$(Civ(B . ?\x4E91) ; <CJK>
     (?$(Ciw(B . ?\xF9C5) ; <CJK>
     (?$(Cix(B . ?\x6A52) ; <CJK>
     (?$(Ciy(B . ?\x6B9E) ; <CJK>
     (?$(Ciz(B . ?\x6F90) ; <CJK>
     (?$(Ci{(B . ?\x7189) ; <CJK>
     (?$(Ci|(B . ?\x8018) ; <CJK>
     (?$(Ci}(B . ?\x82B8) ; <CJK>
     (?$(Ci~(B . ?\x8553) ; <CJK>
     (?$(Cj!(B . ?\x904B) ; <CJK>
     (?$(Cj"(B . ?\x9695) ; <CJK>
     (?$(Cj#(B . ?\x96F2) ; <CJK>
     (?$(Cj$(B . ?\x97FB) ; <CJK>
     (?$(Cj%(B . ?\x851A) ; <CJK>
     (?$(Cj&(B . ?\x9B31) ; <CJK>
     (?$(Cj'(B . ?\x4E90) ; <CJK>
     (?$(Cj((B . ?\x718A) ; <CJK>
     (?$(Cj)(B . ?\x96C4) ; <CJK>
     (?$(Cj*(B . ?\x5143) ; <CJK>
     (?$(Cj+(B . ?\x539F) ; <CJK>
     (?$(Cj,(B . ?\x54E1) ; <CJK>
     (?$(Cj-(B . ?\x5713) ; <CJK>
     (?$(Cj.(B . ?\x5712) ; <CJK>
     (?$(Cj/(B . ?\x57A3) ; <CJK>
     (?$(Cj0(B . ?\x5A9B) ; <CJK>
     (?$(Cj1(B . ?\x5AC4) ; <CJK>
     (?$(Cj2(B . ?\x5BC3) ; <CJK>
     (?$(Cj3(B . ?\x6028) ; <CJK>
     (?$(Cj4(B . ?\x613F) ; <CJK>
     (?$(Cj5(B . ?\x63F4) ; <CJK>
     (?$(Cj6(B . ?\x6C85) ; <CJK>
     (?$(Cj7(B . ?\x6D39) ; <CJK>
     (?$(Cj8(B . ?\x6E72) ; <CJK>
     (?$(Cj9(B . ?\x6E90) ; <CJK>
     (?$(Cj:(B . ?\x7230) ; <CJK>
     (?$(Cj;(B . ?\x733F) ; <CJK>
     (?$(Cj<(B . ?\x7457) ; <CJK>
     (?$(Cj=(B . ?\x82D1) ; <CJK>
     (?$(Cj>(B . ?\x8881) ; <CJK>
     (?$(Cj?(B . ?\x8F45) ; <CJK>
     (?$(Cj@(B . ?\x9060) ; <CJK>
     (?$(CjA(B . ?\xF9C6) ; <CJK>
     (?$(CjB(B . ?\x9662) ; <CJK>
     (?$(CjC(B . ?\x9858) ; <CJK>
     (?$(CjD(B . ?\x9D1B) ; <CJK>
     (?$(CjE(B . ?\x6708) ; <CJK>
     (?$(CjF(B . ?\x8D8A) ; <CJK>
     (?$(CjG(B . ?\x925E) ; <CJK>
     (?$(CjH(B . ?\x4F4D) ; <CJK>
     (?$(CjI(B . ?\x5049) ; <CJK>
     (?$(CjJ(B . ?\x50DE) ; <CJK>
     (?$(CjK(B . ?\x5371) ; <CJK>
     (?$(CjL(B . ?\x570D) ; <CJK>
     (?$(CjM(B . ?\x59D4) ; <CJK>
     (?$(CjN(B . ?\x5A01) ; <CJK>
     (?$(CjO(B . ?\x5C09) ; <CJK>
     (?$(CjP(B . ?\x6170) ; <CJK>
     (?$(CjQ(B . ?\x6690) ; <CJK>
     (?$(CjR(B . ?\x6E2D) ; <CJK>
     (?$(CjS(B . ?\x7232) ; <CJK>
     (?$(CjT(B . ?\x744B) ; <CJK>
     (?$(CjU(B . ?\x7DEF) ; <CJK>
     (?$(CjV(B . ?\x80C3) ; <CJK>
     (?$(CjW(B . ?\x840E) ; <CJK>
     (?$(CjX(B . ?\x8466) ; <CJK>
     (?$(CjY(B . ?\x853F) ; <CJK>
     (?$(CjZ(B . ?\x875F) ; <CJK>
     (?$(Cj[(B . ?\x885B) ; <CJK>
     (?$(Cj\(B . ?\x8918) ; <CJK>
     (?$(Cj](B . ?\x8B02) ; <CJK>
     (?$(Cj^(B . ?\x9055) ; <CJK>
     (?$(Cj_(B . ?\x97CB) ; <CJK>
     (?$(Cj`(B . ?\x9B4F) ; <CJK>
     (?$(Cja(B . ?\x4E73) ; <CJK>
     (?$(Cjb(B . ?\x4F91) ; <CJK>
     (?$(Cjc(B . ?\x5112) ; <CJK>
     (?$(Cjd(B . ?\x516A) ; <CJK>
     (?$(Cje(B . ?\xF9C7) ; <CJK>
     (?$(Cjf(B . ?\x552F) ; <CJK>
     (?$(Cjg(B . ?\x55A9) ; <CJK>
     (?$(Cjh(B . ?\x5B7A) ; <CJK>
     (?$(Cji(B . ?\x5BA5) ; <CJK>
     (?$(Cjj(B . ?\x5E7C) ; <CJK>
     (?$(Cjk(B . ?\x5E7D) ; <CJK>
     (?$(Cjl(B . ?\x5EBE) ; <CJK>
     (?$(Cjm(B . ?\x60A0) ; <CJK>
     (?$(Cjn(B . ?\x60DF) ; <CJK>
     (?$(Cjo(B . ?\x6108) ; <CJK>
     (?$(Cjp(B . ?\x6109) ; <CJK>
     (?$(Cjq(B . ?\x63C4) ; <CJK>
     (?$(Cjr(B . ?\x6538) ; <CJK>
     (?$(Cjs(B . ?\x6709) ; <CJK>
     (?$(Cjt(B . ?\xF9C8) ; <CJK>
     (?$(Cju(B . ?\x67D4) ; <CJK>
     (?$(Cjv(B . ?\x67DA) ; <CJK>
     (?$(Cjw(B . ?\xF9C9) ; <CJK>
     (?$(Cjx(B . ?\x6961) ; <CJK>
     (?$(Cjy(B . ?\x6962) ; <CJK>
     (?$(Cjz(B . ?\x6CB9) ; <CJK>
     (?$(Cj{(B . ?\x6D27) ; <CJK>
     (?$(Cj|(B . ?\xF9CA) ; <CJK>
     (?$(Cj}(B . ?\x6E38) ; <CJK>
     (?$(Cj~(B . ?\xF9CB) ; <CJK>
     (?$(Ck!(B . ?\x6FE1) ; <CJK>
     (?$(Ck"(B . ?\x7336) ; <CJK>
     (?$(Ck#(B . ?\x7337) ; <CJK>
     (?$(Ck$(B . ?\xF9CC) ; <CJK>
     (?$(Ck%(B . ?\x745C) ; <CJK>
     (?$(Ck&(B . ?\x7531) ; <CJK>
     (?$(Ck'(B . ?\xF9CD) ; <CJK>
     (?$(Ck((B . ?\x7652) ; <CJK>
     (?$(Ck)(B . ?\xF9CE) ; <CJK>
     (?$(Ck*(B . ?\xF9CF) ; <CJK>
     (?$(Ck+(B . ?\x7DAD) ; <CJK>
     (?$(Ck,(B . ?\x81FE) ; <CJK>
     (?$(Ck-(B . ?\x8438) ; <CJK>
     (?$(Ck.(B . ?\x88D5) ; <CJK>
     (?$(Ck/(B . ?\x8A98) ; <CJK>
     (?$(Ck0(B . ?\x8ADB) ; <CJK>
     (?$(Ck1(B . ?\x8AED) ; <CJK>
     (?$(Ck2(B . ?\x8E30) ; <CJK>
     (?$(Ck3(B . ?\x8E42) ; <CJK>
     (?$(Ck4(B . ?\x904A) ; <CJK>
     (?$(Ck5(B . ?\x903E) ; <CJK>
     (?$(Ck6(B . ?\x907A) ; <CJK>
     (?$(Ck7(B . ?\x9149) ; <CJK>
     (?$(Ck8(B . ?\x91C9) ; <CJK>
     (?$(Ck9(B . ?\x936E) ; <CJK>
     (?$(Ck:(B . ?\xF9D0) ; <CJK>
     (?$(Ck;(B . ?\xF9D1) ; <CJK>
     (?$(Ck<(B . ?\x5809) ; <CJK>
     (?$(Ck=(B . ?\xF9D2) ; <CJK>
     (?$(Ck>(B . ?\x6BD3) ; <CJK>
     (?$(Ck?(B . ?\x8089) ; <CJK>
     (?$(Ck@(B . ?\x80B2) ; <CJK>
     (?$(CkA(B . ?\xF9D3) ; <CJK>
     (?$(CkB(B . ?\xF9D4) ; <CJK>
     (?$(CkC(B . ?\x5141) ; <CJK>
     (?$(CkD(B . ?\x596B) ; <CJK>
     (?$(CkE(B . ?\x5C39) ; <CJK>
     (?$(CkF(B . ?\xF9D5) ; <CJK>
     (?$(CkG(B . ?\xF9D6) ; <CJK>
     (?$(CkH(B . ?\x6F64) ; <CJK>
     (?$(CkI(B . ?\x73A7) ; <CJK>
     (?$(CkJ(B . ?\x80E4) ; <CJK>
     (?$(CkK(B . ?\x8D07) ; <CJK>
     (?$(CkL(B . ?\xF9D7) ; <CJK>
     (?$(CkM(B . ?\x9217) ; <CJK>
     (?$(CkN(B . ?\x958F) ; <CJK>
     (?$(CkO(B . ?\xF9D8) ; <CJK>
     (?$(CkP(B . ?\xF9D9) ; <CJK>
     (?$(CkQ(B . ?\xF9DA) ; <CJK>
     (?$(CkR(B . ?\xF9DB) ; <CJK>
     (?$(CkS(B . ?\x807F) ; <CJK>
     (?$(CkT(B . ?\x620E) ; <CJK>
     (?$(CkU(B . ?\x701C) ; <CJK>
     (?$(CkV(B . ?\x7D68) ; <CJK>
     (?$(CkW(B . ?\x878D) ; <CJK>
     (?$(CkX(B . ?\xF9DC) ; <CJK>
     (?$(CkY(B . ?\x57A0) ; <CJK>
     (?$(CkZ(B . ?\x6069) ; <CJK>
     (?$(Ck[(B . ?\x6147) ; <CJK>
     (?$(Ck\(B . ?\x6BB7) ; <CJK>
     (?$(Ck](B . ?\x8ABE) ; <CJK>
     (?$(Ck^(B . ?\x9280) ; <CJK>
     (?$(Ck_(B . ?\x96B1) ; <CJK>
     (?$(Ck`(B . ?\x4E59) ; <CJK>
     (?$(Cka(B . ?\x541F) ; <CJK>
     (?$(Ckb(B . ?\x6DEB) ; <CJK>
     (?$(Ckc(B . ?\x852D) ; <CJK>
     (?$(Ckd(B . ?\x9670) ; <CJK>
     (?$(Cke(B . ?\x97F3) ; <CJK>
     (?$(Ckf(B . ?\x98EE) ; <CJK>
     (?$(Ckg(B . ?\x63D6) ; <CJK>
     (?$(Ckh(B . ?\x6CE3) ; <CJK>
     (?$(Cki(B . ?\x9091) ; <CJK>
     (?$(Ckj(B . ?\x51DD) ; <CJK>
     (?$(Ckk(B . ?\x61C9) ; <CJK>
     (?$(Ckl(B . ?\x81BA) ; <CJK>
     (?$(Ckm(B . ?\x9DF9) ; <CJK>
     (?$(Ckn(B . ?\x4F9D) ; <CJK>
     (?$(Cko(B . ?\x501A) ; <CJK>
     (?$(Ckp(B . ?\x5100) ; <CJK>
     (?$(Ckq(B . ?\x5B9C) ; <CJK>
     (?$(Ckr(B . ?\x610F) ; <CJK>
     (?$(Cks(B . ?\x61FF) ; <CJK>
     (?$(Ckt(B . ?\x64EC) ; <CJK>
     (?$(Cku(B . ?\x6905) ; <CJK>
     (?$(Ckv(B . ?\x6BC5) ; <CJK>
     (?$(Ckw(B . ?\x7591) ; <CJK>
     (?$(Ckx(B . ?\x77E3) ; <CJK>
     (?$(Cky(B . ?\x7FA9) ; <CJK>
     (?$(Ckz(B . ?\x8264) ; <CJK>
     (?$(Ck{(B . ?\x858F) ; <CJK>
     (?$(Ck|(B . ?\x87FB) ; <CJK>
     (?$(Ck}(B . ?\x8863) ; <CJK>
     (?$(Ck~(B . ?\x8ABC) ; <CJK>
     (?$(Cl!(B . ?\x8B70) ; <CJK>
     (?$(Cl"(B . ?\x91AB) ; <CJK>
     (?$(Cl#(B . ?\x4E8C) ; <CJK>
     (?$(Cl$(B . ?\x4EE5) ; <CJK>
     (?$(Cl%(B . ?\x4F0A) ; <CJK>
     (?$(Cl&(B . ?\xF9DD) ; <CJK>
     (?$(Cl'(B . ?\xF9DE) ; <CJK>
     (?$(Cl((B . ?\x5937) ; <CJK>
     (?$(Cl)(B . ?\x59E8) ; <CJK>
     (?$(Cl*(B . ?\xF9DF) ; <CJK>
     (?$(Cl+(B . ?\x5DF2) ; <CJK>
     (?$(Cl,(B . ?\x5F1B) ; <CJK>
     (?$(Cl-(B . ?\x5F5B) ; <CJK>
     (?$(Cl.(B . ?\x6021) ; <CJK>
     (?$(Cl/(B . ?\xF9E0) ; <CJK>
     (?$(Cl0(B . ?\xF9E1) ; <CJK>
     (?$(Cl1(B . ?\xF9E2) ; <CJK>
     (?$(Cl2(B . ?\xF9E3) ; <CJK>
     (?$(Cl3(B . ?\x723E) ; <CJK>
     (?$(Cl4(B . ?\x73E5) ; <CJK>
     (?$(Cl5(B . ?\xF9E4) ; <CJK>
     (?$(Cl6(B . ?\x7570) ; <CJK>
     (?$(Cl7(B . ?\x75CD) ; <CJK>
     (?$(Cl8(B . ?\xF9E5) ; <CJK>
     (?$(Cl9(B . ?\x79FB) ; <CJK>
     (?$(Cl:(B . ?\xF9E6) ; <CJK>
     (?$(Cl;(B . ?\x800C) ; <CJK>
     (?$(Cl<(B . ?\x8033) ; <CJK>
     (?$(Cl=(B . ?\x8084) ; <CJK>
     (?$(Cl>(B . ?\x82E1) ; <CJK>
     (?$(Cl?(B . ?\x8351) ; <CJK>
     (?$(Cl@(B . ?\xF9E7) ; <CJK>
     (?$(ClA(B . ?\xF9E8) ; <CJK>
     (?$(ClB(B . ?\x8CBD) ; <CJK>
     (?$(ClC(B . ?\x8CB3) ; <CJK>
     (?$(ClD(B . ?\x9087) ; <CJK>
     (?$(ClE(B . ?\xF9E9) ; <CJK>
     (?$(ClF(B . ?\xF9EA) ; <CJK>
     (?$(ClG(B . ?\x98F4) ; <CJK>
     (?$(ClH(B . ?\x990C) ; <CJK>
     (?$(ClI(B . ?\xF9EB) ; <CJK>
     (?$(ClJ(B . ?\xF9EC) ; <CJK>
     (?$(ClK(B . ?\x7037) ; <CJK>
     (?$(ClL(B . ?\x76CA) ; <CJK>
     (?$(ClM(B . ?\x7FCA) ; <CJK>
     (?$(ClN(B . ?\x7FCC) ; <CJK>
     (?$(ClO(B . ?\x7FFC) ; <CJK>
     (?$(ClP(B . ?\x8B1A) ; <CJK>
     (?$(ClQ(B . ?\x4EBA) ; <CJK>
     (?$(ClR(B . ?\x4EC1) ; <CJK>
     (?$(ClS(B . ?\x5203) ; <CJK>
     (?$(ClT(B . ?\x5370) ; <CJK>
     (?$(ClU(B . ?\xF9ED) ; <CJK>
     (?$(ClV(B . ?\x54BD) ; <CJK>
     (?$(ClW(B . ?\x56E0) ; <CJK>
     (?$(ClX(B . ?\x59FB) ; <CJK>
     (?$(ClY(B . ?\x5BC5) ; <CJK>
     (?$(ClZ(B . ?\x5F15) ; <CJK>
     (?$(Cl[(B . ?\x5FCD) ; <CJK>
     (?$(Cl\(B . ?\x6E6E) ; <CJK>
     (?$(Cl](B . ?\xF9EE) ; <CJK>
     (?$(Cl^(B . ?\xF9EF) ; <CJK>
     (?$(Cl_(B . ?\x7D6A) ; <CJK>
     (?$(Cl`(B . ?\x8335) ; <CJK>
     (?$(Cla(B . ?\xF9F0) ; <CJK>
     (?$(Clb(B . ?\x8693) ; <CJK>
     (?$(Clc(B . ?\x8A8D) ; <CJK>
     (?$(Cld(B . ?\xF9F1) ; <CJK>
     (?$(Cle(B . ?\x976D) ; <CJK>
     (?$(Clf(B . ?\x9777) ; <CJK>
     (?$(Clg(B . ?\xF9F2) ; <CJK>
     (?$(Clh(B . ?\xF9F3) ; <CJK>
     (?$(Cli(B . ?\x4E00) ; <CJK>
     (?$(Clj(B . ?\x4F5A) ; <CJK>
     (?$(Clk(B . ?\x4F7E) ; <CJK>
     (?$(Cll(B . ?\x58F9) ; <CJK>
     (?$(Clm(B . ?\x65E5) ; <CJK>
     (?$(Cln(B . ?\x6EA2) ; <CJK>
     (?$(Clo(B . ?\x9038) ; <CJK>
     (?$(Clp(B . ?\x93B0) ; <CJK>
     (?$(Clq(B . ?\x99B9) ; <CJK>
     (?$(Clr(B . ?\x4EFB) ; <CJK>
     (?$(Cls(B . ?\x58EC) ; <CJK>
     (?$(Clt(B . ?\x598A) ; <CJK>
     (?$(Clu(B . ?\x59D9) ; <CJK>
     (?$(Clv(B . ?\x6041) ; <CJK>
     (?$(Clw(B . ?\xF9F4) ; <CJK>
     (?$(Clx(B . ?\xF9F5) ; <CJK>
     (?$(Cly(B . ?\x7A14) ; <CJK>
     (?$(Clz(B . ?\xF9F6) ; <CJK>
     (?$(Cl{(B . ?\x834F) ; <CJK>
     (?$(Cl|(B . ?\x8CC3) ; <CJK>
     (?$(Cl}(B . ?\x5165) ; <CJK>
     (?$(Cl~(B . ?\x5344) ; <CJK>
     (?$(Cm!(B . ?\xF9F7) ; <CJK>
     (?$(Cm"(B . ?\xF9F8) ; <CJK>
     (?$(Cm#(B . ?\xF9F9) ; <CJK>
     (?$(Cm$(B . ?\x4ECD) ; <CJK>
     (?$(Cm%(B . ?\x5269) ; <CJK>
     (?$(Cm&(B . ?\x5B55) ; <CJK>
     (?$(Cm'(B . ?\x82BF) ; <CJK>
     (?$(Cm((B . ?\x4ED4) ; <CJK>
     (?$(Cm)(B . ?\x523A) ; <CJK>
     (?$(Cm*(B . ?\x54A8) ; <CJK>
     (?$(Cm+(B . ?\x59C9) ; <CJK>
     (?$(Cm,(B . ?\x59FF) ; <CJK>
     (?$(Cm-(B . ?\x5B50) ; <CJK>
     (?$(Cm.(B . ?\x5B57) ; <CJK>
     (?$(Cm/(B . ?\x5B5C) ; <CJK>
     (?$(Cm0(B . ?\x6063) ; <CJK>
     (?$(Cm1(B . ?\x6148) ; <CJK>
     (?$(Cm2(B . ?\x6ECB) ; <CJK>
     (?$(Cm3(B . ?\x7099) ; <CJK>
     (?$(Cm4(B . ?\x716E) ; <CJK>
     (?$(Cm5(B . ?\x7386) ; <CJK>
     (?$(Cm6(B . ?\x74F7) ; <CJK>
     (?$(Cm7(B . ?\x75B5) ; <CJK>
     (?$(Cm8(B . ?\x78C1) ; <CJK>
     (?$(Cm9(B . ?\x7D2B) ; <CJK>
     (?$(Cm:(B . ?\x8005) ; <CJK>
     (?$(Cm;(B . ?\x81EA) ; <CJK>
     (?$(Cm<(B . ?\x8328) ; <CJK>
     (?$(Cm=(B . ?\x8517) ; <CJK>
     (?$(Cm>(B . ?\x85C9) ; <CJK>
     (?$(Cm?(B . ?\x8AEE) ; <CJK>
     (?$(Cm@(B . ?\x8CC7) ; <CJK>
     (?$(CmA(B . ?\x96CC) ; <CJK>
     (?$(CmB(B . ?\x4F5C) ; <CJK>
     (?$(CmC(B . ?\x52FA) ; <CJK>
     (?$(CmD(B . ?\x56BC) ; <CJK>
     (?$(CmE(B . ?\x65AB) ; <CJK>
     (?$(CmF(B . ?\x6628) ; <CJK>
     (?$(CmG(B . ?\x707C) ; <CJK>
     (?$(CmH(B . ?\x70B8) ; <CJK>
     (?$(CmI(B . ?\x7235) ; <CJK>
     (?$(CmJ(B . ?\x7DBD) ; <CJK>
     (?$(CmK(B . ?\x828D) ; <CJK>
     (?$(CmL(B . ?\x914C) ; <CJK>
     (?$(CmM(B . ?\x96C0) ; <CJK>
     (?$(CmN(B . ?\x9D72) ; <CJK>
     (?$(CmO(B . ?\x5B71) ; <CJK>
     (?$(CmP(B . ?\x68E7) ; <CJK>
     (?$(CmQ(B . ?\x6B98) ; <CJK>
     (?$(CmR(B . ?\x6F7A) ; <CJK>
     (?$(CmS(B . ?\x76DE) ; <CJK>
     (?$(CmT(B . ?\x5C91) ; <CJK>
     (?$(CmU(B . ?\x66AB) ; <CJK>
     (?$(CmV(B . ?\x6F5B) ; <CJK>
     (?$(CmW(B . ?\x7BB4) ; <CJK>
     (?$(CmX(B . ?\x7C2A) ; <CJK>
     (?$(CmY(B . ?\x8836) ; <CJK>
     (?$(CmZ(B . ?\x96DC) ; <CJK>
     (?$(Cm[(B . ?\x4E08) ; <CJK>
     (?$(Cm\(B . ?\x4ED7) ; <CJK>
     (?$(Cm](B . ?\x5320) ; <CJK>
     (?$(Cm^(B . ?\x5834) ; <CJK>
     (?$(Cm_(B . ?\x58BB) ; <CJK>
     (?$(Cm`(B . ?\x58EF) ; <CJK>
     (?$(Cma(B . ?\x596C) ; <CJK>
     (?$(Cmb(B . ?\x5C07) ; <CJK>
     (?$(Cmc(B . ?\x5E33) ; <CJK>
     (?$(Cmd(B . ?\x5E84) ; <CJK>
     (?$(Cme(B . ?\x5F35) ; <CJK>
     (?$(Cmf(B . ?\x638C) ; <CJK>
     (?$(Cmg(B . ?\x66B2) ; <CJK>
     (?$(Cmh(B . ?\x6756) ; <CJK>
     (?$(Cmi(B . ?\x6A1F) ; <CJK>
     (?$(Cmj(B . ?\x6AA3) ; <CJK>
     (?$(Cmk(B . ?\x6B0C) ; <CJK>
     (?$(Cml(B . ?\x6F3F) ; <CJK>
     (?$(Cmm(B . ?\x7246) ; <CJK>
     (?$(Cmn(B . ?\xF9FA) ; <CJK>
     (?$(Cmo(B . ?\x7350) ; <CJK>
     (?$(Cmp(B . ?\x748B) ; <CJK>
     (?$(Cmq(B . ?\x7AE0) ; <CJK>
     (?$(Cmr(B . ?\x7CA7) ; <CJK>
     (?$(Cms(B . ?\x8178) ; <CJK>
     (?$(Cmt(B . ?\x81DF) ; <CJK>
     (?$(Cmu(B . ?\x81E7) ; <CJK>
     (?$(Cmv(B . ?\x838A) ; <CJK>
     (?$(Cmw(B . ?\x846C) ; <CJK>
     (?$(Cmx(B . ?\x8523) ; <CJK>
     (?$(Cmy(B . ?\x8594) ; <CJK>
     (?$(Cmz(B . ?\x85CF) ; <CJK>
     (?$(Cm{(B . ?\x88DD) ; <CJK>
     (?$(Cm|(B . ?\x8D13) ; <CJK>
     (?$(Cm}(B . ?\x91AC) ; <CJK>
     (?$(Cm~(B . ?\x9577) ; <CJK>
     (?$(Cn!(B . ?\x969C) ; <CJK>
     (?$(Cn"(B . ?\x518D) ; <CJK>
     (?$(Cn#(B . ?\x54C9) ; <CJK>
     (?$(Cn$(B . ?\x5728) ; <CJK>
     (?$(Cn%(B . ?\x5BB0) ; <CJK>
     (?$(Cn&(B . ?\x624D) ; <CJK>
     (?$(Cn'(B . ?\x6750) ; <CJK>
     (?$(Cn((B . ?\x683D) ; <CJK>
     (?$(Cn)(B . ?\x6893) ; <CJK>
     (?$(Cn*(B . ?\x6E3D) ; <CJK>
     (?$(Cn+(B . ?\x6ED3) ; <CJK>
     (?$(Cn,(B . ?\x707D) ; <CJK>
     (?$(Cn-(B . ?\x7E21) ; <CJK>
     (?$(Cn.(B . ?\x88C1) ; <CJK>
     (?$(Cn/(B . ?\x8CA1) ; <CJK>
     (?$(Cn0(B . ?\x8F09) ; <CJK>
     (?$(Cn1(B . ?\x9F4B) ; <CJK>
     (?$(Cn2(B . ?\x9F4E) ; <CJK>
     (?$(Cn3(B . ?\x722D) ; <CJK>
     (?$(Cn4(B . ?\x7B8F) ; <CJK>
     (?$(Cn5(B . ?\x8ACD) ; <CJK>
     (?$(Cn6(B . ?\x931A) ; <CJK>
     (?$(Cn7(B . ?\x4F47) ; <CJK>
     (?$(Cn8(B . ?\x4F4E) ; <CJK>
     (?$(Cn9(B . ?\x5132) ; <CJK>
     (?$(Cn:(B . ?\x5480) ; <CJK>
     (?$(Cn;(B . ?\x59D0) ; <CJK>
     (?$(Cn<(B . ?\x5E95) ; <CJK>
     (?$(Cn=(B . ?\x62B5) ; <CJK>
     (?$(Cn>(B . ?\x6775) ; <CJK>
     (?$(Cn?(B . ?\x696E) ; <CJK>
     (?$(Cn@(B . ?\x6A17) ; <CJK>
     (?$(CnA(B . ?\x6CAE) ; <CJK>
     (?$(CnB(B . ?\x6E1A) ; <CJK>
     (?$(CnC(B . ?\x72D9) ; <CJK>
     (?$(CnD(B . ?\x732A) ; <CJK>
     (?$(CnE(B . ?\x75BD) ; <CJK>
     (?$(CnF(B . ?\x7BB8) ; <CJK>
     (?$(CnG(B . ?\x7D35) ; <CJK>
     (?$(CnH(B . ?\x82E7) ; <CJK>
     (?$(CnI(B . ?\x83F9) ; <CJK>
     (?$(CnJ(B . ?\x8457) ; <CJK>
     (?$(CnK(B . ?\x85F7) ; <CJK>
     (?$(CnL(B . ?\x8A5B) ; <CJK>
     (?$(CnM(B . ?\x8CAF) ; <CJK>
     (?$(CnN(B . ?\x8E87) ; <CJK>
     (?$(CnO(B . ?\x9019) ; <CJK>
     (?$(CnP(B . ?\x90B8) ; <CJK>
     (?$(CnQ(B . ?\x96CE) ; <CJK>
     (?$(CnR(B . ?\x9F5F) ; <CJK>
     (?$(CnS(B . ?\x52E3) ; <CJK>
     (?$(CnT(B . ?\x540A) ; <CJK>
     (?$(CnU(B . ?\x5AE1) ; <CJK>
     (?$(CnV(B . ?\x5BC2) ; <CJK>
     (?$(CnW(B . ?\x6458) ; <CJK>
     (?$(CnX(B . ?\x6575) ; <CJK>
     (?$(CnY(B . ?\x6EF4) ; <CJK>
     (?$(CnZ(B . ?\x72C4) ; <CJK>
     (?$(Cn[(B . ?\xF9FB) ; <CJK>
     (?$(Cn\(B . ?\x7684) ; <CJK>
     (?$(Cn](B . ?\x7A4D) ; <CJK>
     (?$(Cn^(B . ?\x7B1B) ; <CJK>
     (?$(Cn_(B . ?\x7C4D) ; <CJK>
     (?$(Cn`(B . ?\x7E3E) ; <CJK>
     (?$(Cna(B . ?\x7FDF) ; <CJK>
     (?$(Cnb(B . ?\x837B) ; <CJK>
     (?$(Cnc(B . ?\x8B2B) ; <CJK>
     (?$(Cnd(B . ?\x8CCA) ; <CJK>
     (?$(Cne(B . ?\x8D64) ; <CJK>
     (?$(Cnf(B . ?\x8DE1) ; <CJK>
     (?$(Cng(B . ?\x8E5F) ; <CJK>
     (?$(Cnh(B . ?\x8FEA) ; <CJK>
     (?$(Cni(B . ?\x8FF9) ; <CJK>
     (?$(Cnj(B . ?\x9069) ; <CJK>
     (?$(Cnk(B . ?\x93D1) ; <CJK>
     (?$(Cnl(B . ?\x4F43) ; <CJK>
     (?$(Cnm(B . ?\x4F7A) ; <CJK>
     (?$(Cnn(B . ?\x50B3) ; <CJK>
     (?$(Cno(B . ?\x5168) ; <CJK>
     (?$(Cnp(B . ?\x5178) ; <CJK>
     (?$(Cnq(B . ?\x524D) ; <CJK>
     (?$(Cnr(B . ?\x526A) ; <CJK>
     (?$(Cns(B . ?\x5861) ; <CJK>
     (?$(Cnt(B . ?\x587C) ; <CJK>
     (?$(Cnu(B . ?\x5960) ; <CJK>
     (?$(Cnv(B . ?\x5C08) ; <CJK>
     (?$(Cnw(B . ?\x5C55) ; <CJK>
     (?$(Cnx(B . ?\x5EDB) ; <CJK>
     (?$(Cny(B . ?\x609B) ; <CJK>
     (?$(Cnz(B . ?\x6230) ; <CJK>
     (?$(Cn{(B . ?\x6813) ; <CJK>
     (?$(Cn|(B . ?\x6BBF) ; <CJK>
     (?$(Cn}(B . ?\x6C08) ; <CJK>
     (?$(Cn~(B . ?\x6FB1) ; <CJK>
     (?$(Co!(B . ?\x714E) ; <CJK>
     (?$(Co"(B . ?\x7420) ; <CJK>
     (?$(Co#(B . ?\x7530) ; <CJK>
     (?$(Co$(B . ?\x7538) ; <CJK>
     (?$(Co%(B . ?\x7551) ; <CJK>
     (?$(Co&(B . ?\x7672) ; <CJK>
     (?$(Co'(B . ?\x7B4C) ; <CJK>
     (?$(Co((B . ?\x7B8B) ; <CJK>
     (?$(Co)(B . ?\x7BAD) ; <CJK>
     (?$(Co*(B . ?\x7BC6) ; <CJK>
     (?$(Co+(B . ?\x7E8F) ; <CJK>
     (?$(Co,(B . ?\x8A6E) ; <CJK>
     (?$(Co-(B . ?\x8F3E) ; <CJK>
     (?$(Co.(B . ?\x8F49) ; <CJK>
     (?$(Co/(B . ?\x923F) ; <CJK>
     (?$(Co0(B . ?\x9293) ; <CJK>
     (?$(Co1(B . ?\x9322) ; <CJK>
     (?$(Co2(B . ?\x942B) ; <CJK>
     (?$(Co3(B . ?\x96FB) ; <CJK>
     (?$(Co4(B . ?\x985A) ; <CJK>
     (?$(Co5(B . ?\x986B) ; <CJK>
     (?$(Co6(B . ?\x991E) ; <CJK>
     (?$(Co7(B . ?\x5207) ; <CJK>
     (?$(Co8(B . ?\x622A) ; <CJK>
     (?$(Co9(B . ?\x6298) ; <CJK>
     (?$(Co:(B . ?\x6D59) ; <CJK>
     (?$(Co;(B . ?\x7664) ; <CJK>
     (?$(Co<(B . ?\x7ACA) ; <CJK>
     (?$(Co=(B . ?\x7BC0) ; <CJK>
     (?$(Co>(B . ?\x7D76) ; <CJK>
     (?$(Co?(B . ?\x5360) ; <CJK>
     (?$(Co@(B . ?\x5CBE) ; <CJK>
     (?$(CoA(B . ?\x5E97) ; <CJK>
     (?$(CoB(B . ?\x6F38) ; <CJK>
     (?$(CoC(B . ?\x70B9) ; <CJK>
     (?$(CoD(B . ?\x7C98) ; <CJK>
     (?$(CoE(B . ?\x9711) ; <CJK>
     (?$(CoF(B . ?\x9B8E) ; <CJK>
     (?$(CoG(B . ?\x9EDE) ; <CJK>
     (?$(CoH(B . ?\x63A5) ; <CJK>
     (?$(CoI(B . ?\x647A) ; <CJK>
     (?$(CoJ(B . ?\x8776) ; <CJK>
     (?$(CoK(B . ?\x4E01) ; <CJK>
     (?$(CoL(B . ?\x4E95) ; <CJK>
     (?$(CoM(B . ?\x4EAD) ; <CJK>
     (?$(CoN(B . ?\x505C) ; <CJK>
     (?$(CoO(B . ?\x5075) ; <CJK>
     (?$(CoP(B . ?\x5448) ; <CJK>
     (?$(CoQ(B . ?\x59C3) ; <CJK>
     (?$(CoR(B . ?\x5B9A) ; <CJK>
     (?$(CoS(B . ?\x5E40) ; <CJK>
     (?$(CoT(B . ?\x5EAD) ; <CJK>
     (?$(CoU(B . ?\x5EF7) ; <CJK>
     (?$(CoV(B . ?\x5F81) ; <CJK>
     (?$(CoW(B . ?\x60C5) ; <CJK>
     (?$(CoX(B . ?\x633A) ; <CJK>
     (?$(CoY(B . ?\x653F) ; <CJK>
     (?$(CoZ(B . ?\x6574) ; <CJK>
     (?$(Co[(B . ?\x65CC) ; <CJK>
     (?$(Co\(B . ?\x6676) ; <CJK>
     (?$(Co](B . ?\x6678) ; <CJK>
     (?$(Co^(B . ?\x67FE) ; <CJK>
     (?$(Co_(B . ?\x6968) ; <CJK>
     (?$(Co`(B . ?\x6A89) ; <CJK>
     (?$(Coa(B . ?\x6B63) ; <CJK>
     (?$(Cob(B . ?\x6C40) ; <CJK>
     (?$(Coc(B . ?\x6DC0) ; <CJK>
     (?$(Cod(B . ?\x6DE8) ; <CJK>
     (?$(Coe(B . ?\x6E1F) ; <CJK>
     (?$(Cof(B . ?\x6E5E) ; <CJK>
     (?$(Cog(B . ?\x701E) ; <CJK>
     (?$(Coh(B . ?\x70A1) ; <CJK>
     (?$(Coi(B . ?\x738E) ; <CJK>
     (?$(Coj(B . ?\x73FD) ; <CJK>
     (?$(Cok(B . ?\x753A) ; <CJK>
     (?$(Col(B . ?\x775B) ; <CJK>
     (?$(Com(B . ?\x7887) ; <CJK>
     (?$(Con(B . ?\x798E) ; <CJK>
     (?$(Coo(B . ?\x7A0B) ; <CJK>
     (?$(Cop(B . ?\x7A7D) ; <CJK>
     (?$(Coq(B . ?\x7CBE) ; <CJK>
     (?$(Cor(B . ?\x7D8E) ; <CJK>
     (?$(Cos(B . ?\x8247) ; <CJK>
     (?$(Cot(B . ?\x8A02) ; <CJK>
     (?$(Cou(B . ?\x8AEA) ; <CJK>
     (?$(Cov(B . ?\x8C9E) ; <CJK>
     (?$(Cow(B . ?\x912D) ; <CJK>
     (?$(Cox(B . ?\x914A) ; <CJK>
     (?$(Coy(B . ?\x91D8) ; <CJK>
     (?$(Coz(B . ?\x9266) ; <CJK>
     (?$(Co{(B . ?\x92CC) ; <CJK>
     (?$(Co|(B . ?\x9320) ; <CJK>
     (?$(Co}(B . ?\x9706) ; <CJK>
     (?$(Co~(B . ?\x9756) ; <CJK>
     (?$(Cp!(B . ?\x975C) ; <CJK>
     (?$(Cp"(B . ?\x9802) ; <CJK>
     (?$(Cp#(B . ?\x9F0E) ; <CJK>
     (?$(Cp$(B . ?\x5236) ; <CJK>
     (?$(Cp%(B . ?\x5291) ; <CJK>
     (?$(Cp&(B . ?\x557C) ; <CJK>
     (?$(Cp'(B . ?\x5824) ; <CJK>
     (?$(Cp((B . ?\x5E1D) ; <CJK>
     (?$(Cp)(B . ?\x5F1F) ; <CJK>
     (?$(Cp*(B . ?\x608C) ; <CJK>
     (?$(Cp+(B . ?\x63D0) ; <CJK>
     (?$(Cp,(B . ?\x68AF) ; <CJK>
     (?$(Cp-(B . ?\x6FDF) ; <CJK>
     (?$(Cp.(B . ?\x796D) ; <CJK>
     (?$(Cp/(B . ?\x7B2C) ; <CJK>
     (?$(Cp0(B . ?\x81CD) ; <CJK>
     (?$(Cp1(B . ?\x85BA) ; <CJK>
     (?$(Cp2(B . ?\x88FD) ; <CJK>
     (?$(Cp3(B . ?\x8AF8) ; <CJK>
     (?$(Cp4(B . ?\x8E44) ; <CJK>
     (?$(Cp5(B . ?\x918D) ; <CJK>
     (?$(Cp6(B . ?\x9664) ; <CJK>
     (?$(Cp7(B . ?\x969B) ; <CJK>
     (?$(Cp8(B . ?\x973D) ; <CJK>
     (?$(Cp9(B . ?\x984C) ; <CJK>
     (?$(Cp:(B . ?\x9F4A) ; <CJK>
     (?$(Cp;(B . ?\x4FCE) ; <CJK>
     (?$(Cp<(B . ?\x5146) ; <CJK>
     (?$(Cp=(B . ?\x51CB) ; <CJK>
     (?$(Cp>(B . ?\x52A9) ; <CJK>
     (?$(Cp?(B . ?\x5632) ; <CJK>
     (?$(Cp@(B . ?\x5F14) ; <CJK>
     (?$(CpA(B . ?\x5F6B) ; <CJK>
     (?$(CpB(B . ?\x63AA) ; <CJK>
     (?$(CpC(B . ?\x64CD) ; <CJK>
     (?$(CpD(B . ?\x65E9) ; <CJK>
     (?$(CpE(B . ?\x6641) ; <CJK>
     (?$(CpF(B . ?\x66FA) ; <CJK>
     (?$(CpG(B . ?\x66F9) ; <CJK>
     (?$(CpH(B . ?\x671D) ; <CJK>
     (?$(CpI(B . ?\x689D) ; <CJK>
     (?$(CpJ(B . ?\x68D7) ; <CJK>
     (?$(CpK(B . ?\x69FD) ; <CJK>
     (?$(CpL(B . ?\x6F15) ; <CJK>
     (?$(CpM(B . ?\x6F6E) ; <CJK>
     (?$(CpN(B . ?\x7167) ; <CJK>
     (?$(CpO(B . ?\x71E5) ; <CJK>
     (?$(CpP(B . ?\x722A) ; <CJK>
     (?$(CpQ(B . ?\x74AA) ; <CJK>
     (?$(CpR(B . ?\x773A) ; <CJK>
     (?$(CpS(B . ?\x7956) ; <CJK>
     (?$(CpT(B . ?\x795A) ; <CJK>
     (?$(CpU(B . ?\x79DF) ; <CJK>
     (?$(CpV(B . ?\x7A20) ; <CJK>
     (?$(CpW(B . ?\x7A95) ; <CJK>
     (?$(CpX(B . ?\x7C97) ; <CJK>
     (?$(CpY(B . ?\x7CDF) ; <CJK>
     (?$(CpZ(B . ?\x7D44) ; <CJK>
     (?$(Cp[(B . ?\x7E70) ; <CJK>
     (?$(Cp\(B . ?\x8087) ; <CJK>
     (?$(Cp](B . ?\x85FB) ; <CJK>
     (?$(Cp^(B . ?\x86A4) ; <CJK>
     (?$(Cp_(B . ?\x8A54) ; <CJK>
     (?$(Cp`(B . ?\x8ABF) ; <CJK>
     (?$(Cpa(B . ?\x8D99) ; <CJK>
     (?$(Cpb(B . ?\x8E81) ; <CJK>
     (?$(Cpc(B . ?\x9020) ; <CJK>
     (?$(Cpd(B . ?\x906D) ; <CJK>
     (?$(Cpe(B . ?\x91E3) ; <CJK>
     (?$(Cpf(B . ?\x963B) ; <CJK>
     (?$(Cpg(B . ?\x96D5) ; <CJK>
     (?$(Cph(B . ?\x9CE5) ; <CJK>
     (?$(Cpi(B . ?\x65CF) ; <CJK>
     (?$(Cpj(B . ?\x7C07) ; <CJK>
     (?$(Cpk(B . ?\x8DB3) ; <CJK>
     (?$(Cpl(B . ?\x93C3) ; <CJK>
     (?$(Cpm(B . ?\x5B58) ; <CJK>
     (?$(Cpn(B . ?\x5C0A) ; <CJK>
     (?$(Cpo(B . ?\x5352) ; <CJK>
     (?$(Cpp(B . ?\x62D9) ; <CJK>
     (?$(Cpq(B . ?\x731D) ; <CJK>
     (?$(Cpr(B . ?\x5027) ; <CJK>
     (?$(Cps(B . ?\x5B97) ; <CJK>
     (?$(Cpt(B . ?\x5F9E) ; <CJK>
     (?$(Cpu(B . ?\x60B0) ; <CJK>
     (?$(Cpv(B . ?\x616B) ; <CJK>
     (?$(Cpw(B . ?\x68D5) ; <CJK>
     (?$(Cpx(B . ?\x6DD9) ; <CJK>
     (?$(Cpy(B . ?\x742E) ; <CJK>
     (?$(Cpz(B . ?\x7A2E) ; <CJK>
     (?$(Cp{(B . ?\x7D42) ; <CJK>
     (?$(Cp|(B . ?\x7D9C) ; <CJK>
     (?$(Cp}(B . ?\x7E31) ; <CJK>
     (?$(Cp~(B . ?\x816B) ; <CJK>
     (?$(Cq!(B . ?\x8E2A) ; <CJK>
     (?$(Cq"(B . ?\x8E35) ; <CJK>
     (?$(Cq#(B . ?\x937E) ; <CJK>
     (?$(Cq$(B . ?\x9418) ; <CJK>
     (?$(Cq%(B . ?\x4F50) ; <CJK>
     (?$(Cq&(B . ?\x5750) ; <CJK>
     (?$(Cq'(B . ?\x5DE6) ; <CJK>
     (?$(Cq((B . ?\x5EA7) ; <CJK>
     (?$(Cq)(B . ?\x632B) ; <CJK>
     (?$(Cq*(B . ?\x7F6A) ; <CJK>
     (?$(Cq+(B . ?\x4E3B) ; <CJK>
     (?$(Cq,(B . ?\x4F4F) ; <CJK>
     (?$(Cq-(B . ?\x4F8F) ; <CJK>
     (?$(Cq.(B . ?\x505A) ; <CJK>
     (?$(Cq/(B . ?\x59DD) ; <CJK>
     (?$(Cq0(B . ?\x80C4) ; <CJK>
     (?$(Cq1(B . ?\x546A) ; <CJK>
     (?$(Cq2(B . ?\x5468) ; <CJK>
     (?$(Cq3(B . ?\x55FE) ; <CJK>
     (?$(Cq4(B . ?\x594F) ; <CJK>
     (?$(Cq5(B . ?\x5B99) ; <CJK>
     (?$(Cq6(B . ?\x5DDE) ; <CJK>
     (?$(Cq7(B . ?\x5EDA) ; <CJK>
     (?$(Cq8(B . ?\x665D) ; <CJK>
     (?$(Cq9(B . ?\x6731) ; <CJK>
     (?$(Cq:(B . ?\x67F1) ; <CJK>
     (?$(Cq;(B . ?\x682A) ; <CJK>
     (?$(Cq<(B . ?\x6CE8) ; <CJK>
     (?$(Cq=(B . ?\x6D32) ; <CJK>
     (?$(Cq>(B . ?\x6E4A) ; <CJK>
     (?$(Cq?(B . ?\x6F8D) ; <CJK>
     (?$(Cq@(B . ?\x70B7) ; <CJK>
     (?$(CqA(B . ?\x73E0) ; <CJK>
     (?$(CqB(B . ?\x7587) ; <CJK>
     (?$(CqC(B . ?\x7C4C) ; <CJK>
     (?$(CqD(B . ?\x7D02) ; <CJK>
     (?$(CqE(B . ?\x7D2C) ; <CJK>
     (?$(CqF(B . ?\x7DA2) ; <CJK>
     (?$(CqG(B . ?\x821F) ; <CJK>
     (?$(CqH(B . ?\x86DB) ; <CJK>
     (?$(CqI(B . ?\x8A3B) ; <CJK>
     (?$(CqJ(B . ?\x8A85) ; <CJK>
     (?$(CqK(B . ?\x8D70) ; <CJK>
     (?$(CqL(B . ?\x8E8A) ; <CJK>
     (?$(CqM(B . ?\x8F33) ; <CJK>
     (?$(CqN(B . ?\x9031) ; <CJK>
     (?$(CqO(B . ?\x914E) ; <CJK>
     (?$(CqP(B . ?\x9152) ; <CJK>
     (?$(CqQ(B . ?\x9444) ; <CJK>
     (?$(CqR(B . ?\x99D0) ; <CJK>
     (?$(CqS(B . ?\x7AF9) ; <CJK>
     (?$(CqT(B . ?\x7CA5) ; <CJK>
     (?$(CqU(B . ?\x4FCA) ; <CJK>
     (?$(CqV(B . ?\x5101) ; <CJK>
     (?$(CqW(B . ?\x51C6) ; <CJK>
     (?$(CqX(B . ?\x57C8) ; <CJK>
     (?$(CqY(B . ?\x5BEF) ; <CJK>
     (?$(CqZ(B . ?\x5CFB) ; <CJK>
     (?$(Cq[(B . ?\x6659) ; <CJK>
     (?$(Cq\(B . ?\x6A3D) ; <CJK>
     (?$(Cq](B . ?\x6D5A) ; <CJK>
     (?$(Cq^(B . ?\x6E96) ; <CJK>
     (?$(Cq_(B . ?\x6FEC) ; <CJK>
     (?$(Cq`(B . ?\x710C) ; <CJK>
     (?$(Cqa(B . ?\x756F) ; <CJK>
     (?$(Cqb(B . ?\x7AE3) ; <CJK>
     (?$(Cqc(B . ?\x8822) ; <CJK>
     (?$(Cqd(B . ?\x9021) ; <CJK>
     (?$(Cqe(B . ?\x9075) ; <CJK>
     (?$(Cqf(B . ?\x96CB) ; <CJK>
     (?$(Cqg(B . ?\x99FF) ; <CJK>
     (?$(Cqh(B . ?\x8301) ; <CJK>
     (?$(Cqi(B . ?\x4E2D) ; <CJK>
     (?$(Cqj(B . ?\x4EF2) ; <CJK>
     (?$(Cqk(B . ?\x8846) ; <CJK>
     (?$(Cql(B . ?\x91CD) ; <CJK>
     (?$(Cqm(B . ?\x537D) ; <CJK>
     (?$(Cqn(B . ?\x6ADB) ; <CJK>
     (?$(Cqo(B . ?\x696B) ; <CJK>
     (?$(Cqp(B . ?\x6C41) ; <CJK>
     (?$(Cqq(B . ?\x847A) ; <CJK>
     (?$(Cqr(B . ?\x589E) ; <CJK>
     (?$(Cqs(B . ?\x618E) ; <CJK>
     (?$(Cqt(B . ?\x66FE) ; <CJK>
     (?$(Cqu(B . ?\x62EF) ; <CJK>
     (?$(Cqv(B . ?\x70DD) ; <CJK>
     (?$(Cqw(B . ?\x7511) ; <CJK>
     (?$(Cqx(B . ?\x75C7) ; <CJK>
     (?$(Cqy(B . ?\x7E52) ; <CJK>
     (?$(Cqz(B . ?\x84B8) ; <CJK>
     (?$(Cq{(B . ?\x8B49) ; <CJK>
     (?$(Cq|(B . ?\x8D08) ; <CJK>
     (?$(Cq}(B . ?\x4E4B) ; <CJK>
     (?$(Cq~(B . ?\x53EA) ; <CJK>
     (?$(Cr!(B . ?\x54AB) ; <CJK>
     (?$(Cr"(B . ?\x5730) ; <CJK>
     (?$(Cr#(B . ?\x5740) ; <CJK>
     (?$(Cr$(B . ?\x5FD7) ; <CJK>
     (?$(Cr%(B . ?\x6301) ; <CJK>
     (?$(Cr&(B . ?\x6307) ; <CJK>
     (?$(Cr'(B . ?\x646F) ; <CJK>
     (?$(Cr((B . ?\x652F) ; <CJK>
     (?$(Cr)(B . ?\x65E8) ; <CJK>
     (?$(Cr*(B . ?\x667A) ; <CJK>
     (?$(Cr+(B . ?\x679D) ; <CJK>
     (?$(Cr,(B . ?\x67B3) ; <CJK>
     (?$(Cr-(B . ?\x6B62) ; <CJK>
     (?$(Cr.(B . ?\x6C60) ; <CJK>
     (?$(Cr/(B . ?\x6C9A) ; <CJK>
     (?$(Cr0(B . ?\x6F2C) ; <CJK>
     (?$(Cr1(B . ?\x77E5) ; <CJK>
     (?$(Cr2(B . ?\x7825) ; <CJK>
     (?$(Cr3(B . ?\x7949) ; <CJK>
     (?$(Cr4(B . ?\x7957) ; <CJK>
     (?$(Cr5(B . ?\x7D19) ; <CJK>
     (?$(Cr6(B . ?\x80A2) ; <CJK>
     (?$(Cr7(B . ?\x8102) ; <CJK>
     (?$(Cr8(B . ?\x81F3) ; <CJK>
     (?$(Cr9(B . ?\x829D) ; <CJK>
     (?$(Cr:(B . ?\x82B7) ; <CJK>
     (?$(Cr;(B . ?\x8718) ; <CJK>
     (?$(Cr<(B . ?\x8A8C) ; <CJK>
     (?$(Cr=(B . ?\xF9FC) ; <CJK>
     (?$(Cr>(B . ?\x8D04) ; <CJK>
     (?$(Cr?(B . ?\x8DBE) ; <CJK>
     (?$(Cr@(B . ?\x9072) ; <CJK>
     (?$(CrA(B . ?\x76F4) ; <CJK>
     (?$(CrB(B . ?\x7A19) ; <CJK>
     (?$(CrC(B . ?\x7A37) ; <CJK>
     (?$(CrD(B . ?\x7E54) ; <CJK>
     (?$(CrE(B . ?\x8077) ; <CJK>
     (?$(CrF(B . ?\x5507) ; <CJK>
     (?$(CrG(B . ?\x55D4) ; <CJK>
     (?$(CrH(B . ?\x5875) ; <CJK>
     (?$(CrI(B . ?\x632F) ; <CJK>
     (?$(CrJ(B . ?\x6422) ; <CJK>
     (?$(CrK(B . ?\x6649) ; <CJK>
     (?$(CrL(B . ?\x664B) ; <CJK>
     (?$(CrM(B . ?\x686D) ; <CJK>
     (?$(CrN(B . ?\x699B) ; <CJK>
     (?$(CrO(B . ?\x6B84) ; <CJK>
     (?$(CrP(B . ?\x6D25) ; <CJK>
     (?$(CrQ(B . ?\x6EB1) ; <CJK>
     (?$(CrR(B . ?\x73CD) ; <CJK>
     (?$(CrS(B . ?\x7468) ; <CJK>
     (?$(CrT(B . ?\x74A1) ; <CJK>
     (?$(CrU(B . ?\x755B) ; <CJK>
     (?$(CrV(B . ?\x75B9) ; <CJK>
     (?$(CrW(B . ?\x76E1) ; <CJK>
     (?$(CrX(B . ?\x771E) ; <CJK>
     (?$(CrY(B . ?\x778B) ; <CJK>
     (?$(CrZ(B . ?\x79E6) ; <CJK>
     (?$(Cr[(B . ?\x7E09) ; <CJK>
     (?$(Cr\(B . ?\x7E1D) ; <CJK>
     (?$(Cr](B . ?\x81FB) ; <CJK>
     (?$(Cr^(B . ?\x852F) ; <CJK>
     (?$(Cr_(B . ?\x8897) ; <CJK>
     (?$(Cr`(B . ?\x8A3A) ; <CJK>
     (?$(Cra(B . ?\x8CD1) ; <CJK>
     (?$(Crb(B . ?\x8EEB) ; <CJK>
     (?$(Crc(B . ?\x8FB0) ; <CJK>
     (?$(Crd(B . ?\x9032) ; <CJK>
     (?$(Cre(B . ?\x93AD) ; <CJK>
     (?$(Crf(B . ?\x9663) ; <CJK>
     (?$(Crg(B . ?\x9673) ; <CJK>
     (?$(Crh(B . ?\x9707) ; <CJK>
     (?$(Cri(B . ?\x4F84) ; <CJK>
     (?$(Crj(B . ?\x53F1) ; <CJK>
     (?$(Crk(B . ?\x59EA) ; <CJK>
     (?$(Crl(B . ?\x5AC9) ; <CJK>
     (?$(Crm(B . ?\x5E19) ; <CJK>
     (?$(Crn(B . ?\x684E) ; <CJK>
     (?$(Cro(B . ?\x74C6) ; <CJK>
     (?$(Crp(B . ?\x75BE) ; <CJK>
     (?$(Crq(B . ?\x79E9) ; <CJK>
     (?$(Crr(B . ?\x7A92) ; <CJK>
     (?$(Crs(B . ?\x81A3) ; <CJK>
     (?$(Crt(B . ?\x86ED) ; <CJK>
     (?$(Cru(B . ?\x8CEA) ; <CJK>
     (?$(Crv(B . ?\x8DCC) ; <CJK>
     (?$(Crw(B . ?\x8FED) ; <CJK>
     (?$(Crx(B . ?\x659F) ; <CJK>
     (?$(Cry(B . ?\x6715) ; <CJK>
     (?$(Crz(B . ?\xF9FD) ; <CJK>
     (?$(Cr{(B . ?\x57F7) ; <CJK>
     (?$(Cr|(B . ?\x6F57) ; <CJK>
     (?$(Cr}(B . ?\x7DDD) ; <CJK>
     (?$(Cr~(B . ?\x8F2F) ; <CJK>
     (?$(Cs!(B . ?\x93F6) ; <CJK>
     (?$(Cs"(B . ?\x96C6) ; <CJK>
     (?$(Cs#(B . ?\x5FB5) ; <CJK>
     (?$(Cs$(B . ?\x61F2) ; <CJK>
     (?$(Cs%(B . ?\x6F84) ; <CJK>
     (?$(Cs&(B . ?\x4E14) ; <CJK>
     (?$(Cs'(B . ?\x4F98) ; <CJK>
     (?$(Cs((B . ?\x501F) ; <CJK>
     (?$(Cs)(B . ?\x53C9) ; <CJK>
     (?$(Cs*(B . ?\x55DF) ; <CJK>
     (?$(Cs+(B . ?\x5D6F) ; <CJK>
     (?$(Cs,(B . ?\x5DEE) ; <CJK>
     (?$(Cs-(B . ?\x6B21) ; <CJK>
     (?$(Cs.(B . ?\x6B64) ; <CJK>
     (?$(Cs/(B . ?\x78CB) ; <CJK>
     (?$(Cs0(B . ?\x7B9A) ; <CJK>
     (?$(Cs1(B . ?\xF9FE) ; <CJK>
     (?$(Cs2(B . ?\x8E49) ; <CJK>
     (?$(Cs3(B . ?\x8ECA) ; <CJK>
     (?$(Cs4(B . ?\x906E) ; <CJK>
     (?$(Cs5(B . ?\x6349) ; <CJK>
     (?$(Cs6(B . ?\x643E) ; <CJK>
     (?$(Cs7(B . ?\x7740) ; <CJK>
     (?$(Cs8(B . ?\x7A84) ; <CJK>
     (?$(Cs9(B . ?\x932F) ; <CJK>
     (?$(Cs:(B . ?\x947F) ; <CJK>
     (?$(Cs;(B . ?\x9F6A) ; <CJK>
     (?$(Cs<(B . ?\x64B0) ; <CJK>
     (?$(Cs=(B . ?\x6FAF) ; <CJK>
     (?$(Cs>(B . ?\x71E6) ; <CJK>
     (?$(Cs?(B . ?\x74A8) ; <CJK>
     (?$(Cs@(B . ?\x74DA) ; <CJK>
     (?$(CsA(B . ?\x7AC4) ; <CJK>
     (?$(CsB(B . ?\x7C12) ; <CJK>
     (?$(CsC(B . ?\x7E82) ; <CJK>
     (?$(CsD(B . ?\x7CB2) ; <CJK>
     (?$(CsE(B . ?\x7E98) ; <CJK>
     (?$(CsF(B . ?\x8B9A) ; <CJK>
     (?$(CsG(B . ?\x8D0A) ; <CJK>
     (?$(CsH(B . ?\x947D) ; <CJK>
     (?$(CsI(B . ?\x9910) ; <CJK>
     (?$(CsJ(B . ?\x994C) ; <CJK>
     (?$(CsK(B . ?\x5239) ; <CJK>
     (?$(CsL(B . ?\x5BDF) ; <CJK>
     (?$(CsM(B . ?\x64E6) ; <CJK>
     (?$(CsN(B . ?\x672D) ; <CJK>
     (?$(CsO(B . ?\x7D2E) ; <CJK>
     (?$(CsP(B . ?\x50ED) ; <CJK>
     (?$(CsQ(B . ?\x53C3) ; <CJK>
     (?$(CsR(B . ?\x5879) ; <CJK>
     (?$(CsS(B . ?\x6158) ; <CJK>
     (?$(CsT(B . ?\x6159) ; <CJK>
     (?$(CsU(B . ?\x61FA) ; <CJK>
     (?$(CsV(B . ?\x65AC) ; <CJK>
     (?$(CsW(B . ?\x7AD9) ; <CJK>
     (?$(CsX(B . ?\x8B92) ; <CJK>
     (?$(CsY(B . ?\x8B96) ; <CJK>
     (?$(CsZ(B . ?\x5009) ; <CJK>
     (?$(Cs[(B . ?\x5021) ; <CJK>
     (?$(Cs\(B . ?\x5275) ; <CJK>
     (?$(Cs](B . ?\x5531) ; <CJK>
     (?$(Cs^(B . ?\x5A3C) ; <CJK>
     (?$(Cs_(B . ?\x5EE0) ; <CJK>
     (?$(Cs`(B . ?\x5F70) ; <CJK>
     (?$(Csa(B . ?\x6134) ; <CJK>
     (?$(Csb(B . ?\x655E) ; <CJK>
     (?$(Csc(B . ?\x660C) ; <CJK>
     (?$(Csd(B . ?\x6636) ; <CJK>
     (?$(Cse(B . ?\x66A2) ; <CJK>
     (?$(Csf(B . ?\x69CD) ; <CJK>
     (?$(Csg(B . ?\x6EC4) ; <CJK>
     (?$(Csh(B . ?\x6F32) ; <CJK>
     (?$(Csi(B . ?\x7316) ; <CJK>
     (?$(Csj(B . ?\x7621) ; <CJK>
     (?$(Csk(B . ?\x7A93) ; <CJK>
     (?$(Csl(B . ?\x8139) ; <CJK>
     (?$(Csm(B . ?\x8259) ; <CJK>
     (?$(Csn(B . ?\x83D6) ; <CJK>
     (?$(Cso(B . ?\x84BC) ; <CJK>
     (?$(Csp(B . ?\x50B5) ; <CJK>
     (?$(Csq(B . ?\x57F0) ; <CJK>
     (?$(Csr(B . ?\x5BC0) ; <CJK>
     (?$(Css(B . ?\x5BE8) ; <CJK>
     (?$(Cst(B . ?\x5F69) ; <CJK>
     (?$(Csu(B . ?\x63A1) ; <CJK>
     (?$(Csv(B . ?\x7826) ; <CJK>
     (?$(Csw(B . ?\x7DB5) ; <CJK>
     (?$(Csx(B . ?\x83DC) ; <CJK>
     (?$(Csy(B . ?\x8521) ; <CJK>
     (?$(Csz(B . ?\x91C7) ; <CJK>
     (?$(Cs{(B . ?\x91F5) ; <CJK>
     (?$(Cs|(B . ?\x518A) ; <CJK>
     (?$(Cs}(B . ?\x67F5) ; <CJK>
     (?$(Cs~(B . ?\x7B56) ; <CJK>
     (?$(Ct!(B . ?\x8CAC) ; <CJK>
     (?$(Ct"(B . ?\x51C4) ; <CJK>
     (?$(Ct#(B . ?\x59BB) ; <CJK>
     (?$(Ct$(B . ?\x60BD) ; <CJK>
     (?$(Ct%(B . ?\x8655) ; <CJK>
     (?$(Ct&(B . ?\x501C) ; <CJK>
     (?$(Ct'(B . ?\xF9FF) ; <CJK>
     (?$(Ct((B . ?\x5254) ; <CJK>
     (?$(Ct)(B . ?\x5C3A) ; <CJK>
     (?$(Ct*(B . ?\x617D) ; <CJK>
     (?$(Ct+(B . ?\x621A) ; <CJK>
     (?$(Ct,(B . ?\x62D3) ; <CJK>
     (?$(Ct-(B . ?\x64F2) ; <CJK>
     (?$(Ct.(B . ?\x65A5) ; <CJK>
     (?$(Ct/(B . ?\x6ECC) ; <CJK>
     (?$(Ct0(B . ?\x7620) ; <CJK>
     (?$(Ct1(B . ?\x810A) ; <CJK>
     (?$(Ct2(B . ?\x8E60) ; <CJK>
     (?$(Ct3(B . ?\x965F) ; <CJK>
     (?$(Ct4(B . ?\x96BB) ; <CJK>
     (?$(Ct5(B . ?\x4EDF) ; <CJK>
     (?$(Ct6(B . ?\x5343) ; <CJK>
     (?$(Ct7(B . ?\x5598) ; <CJK>
     (?$(Ct8(B . ?\x5929) ; <CJK>
     (?$(Ct9(B . ?\x5DDD) ; <CJK>
     (?$(Ct:(B . ?\x64C5) ; <CJK>
     (?$(Ct;(B . ?\x6CC9) ; <CJK>
     (?$(Ct<(B . ?\x6DFA) ; <CJK>
     (?$(Ct=(B . ?\x7394) ; <CJK>
     (?$(Ct>(B . ?\x7A7F) ; <CJK>
     (?$(Ct?(B . ?\x821B) ; <CJK>
     (?$(Ct@(B . ?\x85A6) ; <CJK>
     (?$(CtA(B . ?\x8CE4) ; <CJK>
     (?$(CtB(B . ?\x8E10) ; <CJK>
     (?$(CtC(B . ?\x9077) ; <CJK>
     (?$(CtD(B . ?\x91E7) ; <CJK>
     (?$(CtE(B . ?\x95E1) ; <CJK>
     (?$(CtF(B . ?\x9621) ; <CJK>
     (?$(CtG(B . ?\x97C6) ; <CJK>
     (?$(CtH(B . ?\x51F8) ; <CJK>
     (?$(CtI(B . ?\x54F2) ; <CJK>
     (?$(CtJ(B . ?\x5586) ; <CJK>
     (?$(CtK(B . ?\x5FB9) ; <CJK>
     (?$(CtL(B . ?\x64A4) ; <CJK>
     (?$(CtM(B . ?\x6F88) ; <CJK>
     (?$(CtN(B . ?\x7DB4) ; <CJK>
     (?$(CtO(B . ?\x8F1F) ; <CJK>
     (?$(CtP(B . ?\x8F4D) ; <CJK>
     (?$(CtQ(B . ?\x9435) ; <CJK>
     (?$(CtR(B . ?\x50C9) ; <CJK>
     (?$(CtS(B . ?\x5C16) ; <CJK>
     (?$(CtT(B . ?\x6CBE) ; <CJK>
     (?$(CtU(B . ?\x6DFB) ; <CJK>
     (?$(CtV(B . ?\x751B) ; <CJK>
     (?$(CtW(B . ?\x77BB) ; <CJK>
     (?$(CtX(B . ?\x7C3D) ; <CJK>
     (?$(CtY(B . ?\x7C64) ; <CJK>
     (?$(CtZ(B . ?\x8A79) ; <CJK>
     (?$(Ct[(B . ?\x8AC2) ; <CJK>
     (?$(Ct\(B . ?\x581E) ; <CJK>
     (?$(Ct](B . ?\x59BE) ; <CJK>
     (?$(Ct^(B . ?\x5E16) ; <CJK>
     (?$(Ct_(B . ?\x6377) ; <CJK>
     (?$(Ct`(B . ?\x7252) ; <CJK>
     (?$(Cta(B . ?\x758A) ; <CJK>
     (?$(Ctb(B . ?\x776B) ; <CJK>
     (?$(Ctc(B . ?\x8ADC) ; <CJK>
     (?$(Ctd(B . ?\x8CBC) ; <CJK>
     (?$(Cte(B . ?\x8F12) ; <CJK>
     (?$(Ctf(B . ?\x5EF3) ; <CJK>
     (?$(Ctg(B . ?\x6674) ; <CJK>
     (?$(Cth(B . ?\x6DF8) ; <CJK>
     (?$(Cti(B . ?\x807D) ; <CJK>
     (?$(Ctj(B . ?\x83C1) ; <CJK>
     (?$(Ctk(B . ?\x8ACB) ; <CJK>
     (?$(Ctl(B . ?\x9751) ; <CJK>
     (?$(Ctm(B . ?\x9BD6) ; <CJK>
     (?$(Ctn(B . ?\xFA00) ; <CJK>
     (?$(Cto(B . ?\x5243) ; <CJK>
     (?$(Ctp(B . ?\x66FF) ; <CJK>
     (?$(Ctq(B . ?\x6D95) ; <CJK>
     (?$(Ctr(B . ?\x6EEF) ; <CJK>
     (?$(Cts(B . ?\x7DE0) ; <CJK>
     (?$(Ctt(B . ?\x8AE6) ; <CJK>
     (?$(Ctu(B . ?\x902E) ; <CJK>
     (?$(Ctv(B . ?\x905E) ; <CJK>
     (?$(Ctw(B . ?\x9AD4) ; <CJK>
     (?$(Ctx(B . ?\x521D) ; <CJK>
     (?$(Cty(B . ?\x527F) ; <CJK>
     (?$(Ctz(B . ?\x54E8) ; <CJK>
     (?$(Ct{(B . ?\x6194) ; <CJK>
     (?$(Ct|(B . ?\x6284) ; <CJK>
     (?$(Ct}(B . ?\x62DB) ; <CJK>
     (?$(Ct~(B . ?\x68A2) ; <CJK>
     (?$(Cu!(B . ?\x6912) ; <CJK>
     (?$(Cu"(B . ?\x695A) ; <CJK>
     (?$(Cu#(B . ?\x6A35) ; <CJK>
     (?$(Cu$(B . ?\x7092) ; <CJK>
     (?$(Cu%(B . ?\x7126) ; <CJK>
     (?$(Cu&(B . ?\x785D) ; <CJK>
     (?$(Cu'(B . ?\x7901) ; <CJK>
     (?$(Cu((B . ?\x790E) ; <CJK>
     (?$(Cu)(B . ?\x79D2) ; <CJK>
     (?$(Cu*(B . ?\x7A0D) ; <CJK>
     (?$(Cu+(B . ?\x8096) ; <CJK>
     (?$(Cu,(B . ?\x8278) ; <CJK>
     (?$(Cu-(B . ?\x82D5) ; <CJK>
     (?$(Cu.(B . ?\x8349) ; <CJK>
     (?$(Cu/(B . ?\x8549) ; <CJK>
     (?$(Cu0(B . ?\x8C82) ; <CJK>
     (?$(Cu1(B . ?\x8D85) ; <CJK>
     (?$(Cu2(B . ?\x9162) ; <CJK>
     (?$(Cu3(B . ?\x918B) ; <CJK>
     (?$(Cu4(B . ?\x91AE) ; <CJK>
     (?$(Cu5(B . ?\x4FC3) ; <CJK>
     (?$(Cu6(B . ?\x56D1) ; <CJK>
     (?$(Cu7(B . ?\x71ED) ; <CJK>
     (?$(Cu8(B . ?\x77D7) ; <CJK>
     (?$(Cu9(B . ?\x8700) ; <CJK>
     (?$(Cu:(B . ?\x89F8) ; <CJK>
     (?$(Cu;(B . ?\x5BF8) ; <CJK>
     (?$(Cu<(B . ?\x5FD6) ; <CJK>
     (?$(Cu=(B . ?\x6751) ; <CJK>
     (?$(Cu>(B . ?\x90A8) ; <CJK>
     (?$(Cu?(B . ?\x53E2) ; <CJK>
     (?$(Cu@(B . ?\x585A) ; <CJK>
     (?$(CuA(B . ?\x5BF5) ; <CJK>
     (?$(CuB(B . ?\x60A4) ; <CJK>
     (?$(CuC(B . ?\x6181) ; <CJK>
     (?$(CuD(B . ?\x6460) ; <CJK>
     (?$(CuE(B . ?\x7E3D) ; <CJK>
     (?$(CuF(B . ?\x8070) ; <CJK>
     (?$(CuG(B . ?\x8525) ; <CJK>
     (?$(CuH(B . ?\x9283) ; <CJK>
     (?$(CuI(B . ?\x64AE) ; <CJK>
     (?$(CuJ(B . ?\x50AC) ; <CJK>
     (?$(CuK(B . ?\x5D14) ; <CJK>
     (?$(CuL(B . ?\x6700) ; <CJK>
     (?$(CuM(B . ?\x589C) ; <CJK>
     (?$(CuN(B . ?\x62BD) ; <CJK>
     (?$(CuO(B . ?\x63A8) ; <CJK>
     (?$(CuP(B . ?\x690E) ; <CJK>
     (?$(CuQ(B . ?\x6978) ; <CJK>
     (?$(CuR(B . ?\x6A1E) ; <CJK>
     (?$(CuS(B . ?\x6E6B) ; <CJK>
     (?$(CuT(B . ?\x76BA) ; <CJK>
     (?$(CuU(B . ?\x79CB) ; <CJK>
     (?$(CuV(B . ?\x82BB) ; <CJK>
     (?$(CuW(B . ?\x8429) ; <CJK>
     (?$(CuX(B . ?\x8ACF) ; <CJK>
     (?$(CuY(B . ?\x8DA8) ; <CJK>
     (?$(CuZ(B . ?\x8FFD) ; <CJK>
     (?$(Cu[(B . ?\x9112) ; <CJK>
     (?$(Cu\(B . ?\x914B) ; <CJK>
     (?$(Cu](B . ?\x919C) ; <CJK>
     (?$(Cu^(B . ?\x9310) ; <CJK>
     (?$(Cu_(B . ?\x9318) ; <CJK>
     (?$(Cu`(B . ?\x939A) ; <CJK>
     (?$(Cua(B . ?\x96DB) ; <CJK>
     (?$(Cub(B . ?\x9A36) ; <CJK>
     (?$(Cuc(B . ?\x9C0D) ; <CJK>
     (?$(Cud(B . ?\x4E11) ; <CJK>
     (?$(Cue(B . ?\x755C) ; <CJK>
     (?$(Cuf(B . ?\x795D) ; <CJK>
     (?$(Cug(B . ?\x7AFA) ; <CJK>
     (?$(Cuh(B . ?\x7B51) ; <CJK>
     (?$(Cui(B . ?\x7BC9) ; <CJK>
     (?$(Cuj(B . ?\x7E2E) ; <CJK>
     (?$(Cuk(B . ?\x84C4) ; <CJK>
     (?$(Cul(B . ?\x8E59) ; <CJK>
     (?$(Cum(B . ?\x8E74) ; <CJK>
     (?$(Cun(B . ?\x8EF8) ; <CJK>
     (?$(Cuo(B . ?\x9010) ; <CJK>
     (?$(Cup(B . ?\x6625) ; <CJK>
     (?$(Cuq(B . ?\x693F) ; <CJK>
     (?$(Cur(B . ?\x7443) ; <CJK>
     (?$(Cus(B . ?\x51FA) ; <CJK>
     (?$(Cut(B . ?\x672E) ; <CJK>
     (?$(Cuu(B . ?\x9EDC) ; <CJK>
     (?$(Cuv(B . ?\x5145) ; <CJK>
     (?$(Cuw(B . ?\x5FE0) ; <CJK>
     (?$(Cux(B . ?\x6C96) ; <CJK>
     (?$(Cuy(B . ?\x87F2) ; <CJK>
     (?$(Cuz(B . ?\x885D) ; <CJK>
     (?$(Cu{(B . ?\x8877) ; <CJK>
     (?$(Cu|(B . ?\x60B4) ; <CJK>
     (?$(Cu}(B . ?\x81B5) ; <CJK>
     (?$(Cu~(B . ?\x8403) ; <CJK>
     (?$(Cv!(B . ?\x8D05) ; <CJK>
     (?$(Cv"(B . ?\x53D6) ; <CJK>
     (?$(Cv#(B . ?\x5439) ; <CJK>
     (?$(Cv$(B . ?\x5634) ; <CJK>
     (?$(Cv%(B . ?\x5A36) ; <CJK>
     (?$(Cv&(B . ?\x5C31) ; <CJK>
     (?$(Cv'(B . ?\x708A) ; <CJK>
     (?$(Cv((B . ?\x7FE0) ; <CJK>
     (?$(Cv)(B . ?\x805A) ; <CJK>
     (?$(Cv*(B . ?\x8106) ; <CJK>
     (?$(Cv+(B . ?\x81ED) ; <CJK>
     (?$(Cv,(B . ?\x8DA3) ; <CJK>
     (?$(Cv-(B . ?\x9189) ; <CJK>
     (?$(Cv.(B . ?\x9A5F) ; <CJK>
     (?$(Cv/(B . ?\x9DF2) ; <CJK>
     (?$(Cv0(B . ?\x5074) ; <CJK>
     (?$(Cv1(B . ?\x4EC4) ; <CJK>
     (?$(Cv2(B . ?\x53A0) ; <CJK>
     (?$(Cv3(B . ?\x60FB) ; <CJK>
     (?$(Cv4(B . ?\x6E2C) ; <CJK>
     (?$(Cv5(B . ?\x5C64) ; <CJK>
     (?$(Cv6(B . ?\x4F88) ; <CJK>
     (?$(Cv7(B . ?\x5024) ; <CJK>
     (?$(Cv8(B . ?\x55E4) ; <CJK>
     (?$(Cv9(B . ?\x5CD9) ; <CJK>
     (?$(Cv:(B . ?\x5E5F) ; <CJK>
     (?$(Cv;(B . ?\x6065) ; <CJK>
     (?$(Cv<(B . ?\x6894) ; <CJK>
     (?$(Cv=(B . ?\x6CBB) ; <CJK>
     (?$(Cv>(B . ?\x6DC4) ; <CJK>
     (?$(Cv?(B . ?\x71BE) ; <CJK>
     (?$(Cv@(B . ?\x75D4) ; <CJK>
     (?$(CvA(B . ?\x75F4) ; <CJK>
     (?$(CvB(B . ?\x7661) ; <CJK>
     (?$(CvC(B . ?\x7A1A) ; <CJK>
     (?$(CvD(B . ?\x7A49) ; <CJK>
     (?$(CvE(B . ?\x7DC7) ; <CJK>
     (?$(CvF(B . ?\x7DFB) ; <CJK>
     (?$(CvG(B . ?\x7F6E) ; <CJK>
     (?$(CvH(B . ?\x81F4) ; <CJK>
     (?$(CvI(B . ?\x86A9) ; <CJK>
     (?$(CvJ(B . ?\x8F1C) ; <CJK>
     (?$(CvK(B . ?\x96C9) ; <CJK>
     (?$(CvL(B . ?\x99B3) ; <CJK>
     (?$(CvM(B . ?\x9F52) ; <CJK>
     (?$(CvN(B . ?\x5247) ; <CJK>
     (?$(CvO(B . ?\x52C5) ; <CJK>
     (?$(CvP(B . ?\x98ED) ; <CJK>
     (?$(CvQ(B . ?\x89AA) ; <CJK>
     (?$(CvR(B . ?\x4E03) ; <CJK>
     (?$(CvS(B . ?\x67D2) ; <CJK>
     (?$(CvT(B . ?\x6F06) ; <CJK>
     (?$(CvU(B . ?\x4FB5) ; <CJK>
     (?$(CvV(B . ?\x5BE2) ; <CJK>
     (?$(CvW(B . ?\x6795) ; <CJK>
     (?$(CvX(B . ?\x6C88) ; <CJK>
     (?$(CvY(B . ?\x6D78) ; <CJK>
     (?$(CvZ(B . ?\x741B) ; <CJK>
     (?$(Cv[(B . ?\x7827) ; <CJK>
     (?$(Cv\(B . ?\x91DD) ; <CJK>
     (?$(Cv](B . ?\x937C) ; <CJK>
     (?$(Cv^(B . ?\x87C4) ; <CJK>
     (?$(Cv_(B . ?\x79E4) ; <CJK>
     (?$(Cv`(B . ?\x7A31) ; <CJK>
     (?$(Cva(B . ?\x5FEB) ; <CJK>
     (?$(Cvb(B . ?\x4ED6) ; <CJK>
     (?$(Cvc(B . ?\x54A4) ; <CJK>
     (?$(Cvd(B . ?\x553E) ; <CJK>
     (?$(Cve(B . ?\x58AE) ; <CJK>
     (?$(Cvf(B . ?\x59A5) ; <CJK>
     (?$(Cvg(B . ?\x60F0) ; <CJK>
     (?$(Cvh(B . ?\x6253) ; <CJK>
     (?$(Cvi(B . ?\x62D6) ; <CJK>
     (?$(Cvj(B . ?\x6736) ; <CJK>
     (?$(Cvk(B . ?\x6955) ; <CJK>
     (?$(Cvl(B . ?\x8235) ; <CJK>
     (?$(Cvm(B . ?\x9640) ; <CJK>
     (?$(Cvn(B . ?\x99B1) ; <CJK>
     (?$(Cvo(B . ?\x99DD) ; <CJK>
     (?$(Cvp(B . ?\x502C) ; <CJK>
     (?$(Cvq(B . ?\x5353) ; <CJK>
     (?$(Cvr(B . ?\x5544) ; <CJK>
     (?$(Cvs(B . ?\x577C) ; <CJK>
     (?$(Cvt(B . ?\xFA01) ; <CJK>
     (?$(Cvu(B . ?\x6258) ; <CJK>
     (?$(Cvv(B . ?\xFA02) ; <CJK>
     (?$(Cvw(B . ?\x64E2) ; <CJK>
     (?$(Cvx(B . ?\x666B) ; <CJK>
     (?$(Cvy(B . ?\x67DD) ; <CJK>
     (?$(Cvz(B . ?\x6FC1) ; <CJK>
     (?$(Cv{(B . ?\x6FEF) ; <CJK>
     (?$(Cv|(B . ?\x7422) ; <CJK>
     (?$(Cv}(B . ?\x7438) ; <CJK>
     (?$(Cv~(B . ?\x8A17) ; <CJK>
     (?$(Cw!(B . ?\x9438) ; <CJK>
     (?$(Cw"(B . ?\x5451) ; <CJK>
     (?$(Cw#(B . ?\x5606) ; <CJK>
     (?$(Cw$(B . ?\x5766) ; <CJK>
     (?$(Cw%(B . ?\x5F48) ; <CJK>
     (?$(Cw&(B . ?\x619A) ; <CJK>
     (?$(Cw'(B . ?\x6B4E) ; <CJK>
     (?$(Cw((B . ?\x7058) ; <CJK>
     (?$(Cw)(B . ?\x70AD) ; <CJK>
     (?$(Cw*(B . ?\x7DBB) ; <CJK>
     (?$(Cw+(B . ?\x8A95) ; <CJK>
     (?$(Cw,(B . ?\x596A) ; <CJK>
     (?$(Cw-(B . ?\x812B) ; <CJK>
     (?$(Cw.(B . ?\x63A2) ; <CJK>
     (?$(Cw/(B . ?\x7708) ; <CJK>
     (?$(Cw0(B . ?\x803D) ; <CJK>
     (?$(Cw1(B . ?\x8CAA) ; <CJK>
     (?$(Cw2(B . ?\x5854) ; <CJK>
     (?$(Cw3(B . ?\x642D) ; <CJK>
     (?$(Cw4(B . ?\x69BB) ; <CJK>
     (?$(Cw5(B . ?\x5B95) ; <CJK>
     (?$(Cw6(B . ?\x5E11) ; <CJK>
     (?$(Cw7(B . ?\x6E6F) ; <CJK>
     (?$(Cw8(B . ?\xFA03) ; <CJK>
     (?$(Cw9(B . ?\x8569) ; <CJK>
     (?$(Cw:(B . ?\x514C) ; <CJK>
     (?$(Cw;(B . ?\x53F0) ; <CJK>
     (?$(Cw<(B . ?\x592A) ; <CJK>
     (?$(Cw=(B . ?\x6020) ; <CJK>
     (?$(Cw>(B . ?\x614B) ; <CJK>
     (?$(Cw?(B . ?\x6B86) ; <CJK>
     (?$(Cw@(B . ?\x6C70) ; <CJK>
     (?$(CwA(B . ?\x6CF0) ; <CJK>
     (?$(CwB(B . ?\x7B1E) ; <CJK>
     (?$(CwC(B . ?\x80CE) ; <CJK>
     (?$(CwD(B . ?\x82D4) ; <CJK>
     (?$(CwE(B . ?\x8DC6) ; <CJK>
     (?$(CwF(B . ?\x90B0) ; <CJK>
     (?$(CwG(B . ?\x98B1) ; <CJK>
     (?$(CwH(B . ?\xFA04) ; <CJK>
     (?$(CwI(B . ?\x64C7) ; <CJK>
     (?$(CwJ(B . ?\x6FA4) ; <CJK>
     (?$(CwK(B . ?\x6491) ; <CJK>
     (?$(CwL(B . ?\x6504) ; <CJK>
     (?$(CwM(B . ?\x514E) ; <CJK>
     (?$(CwN(B . ?\x5410) ; <CJK>
     (?$(CwO(B . ?\x571F) ; <CJK>
     (?$(CwP(B . ?\x8A0E) ; <CJK>
     (?$(CwQ(B . ?\x615F) ; <CJK>
     (?$(CwR(B . ?\x6876) ; <CJK>
     (?$(CwS(B . ?\xFA05) ; <CJK>
     (?$(CwT(B . ?\x75DB) ; <CJK>
     (?$(CwU(B . ?\x7B52) ; <CJK>
     (?$(CwV(B . ?\x7D71) ; <CJK>
     (?$(CwW(B . ?\x901A) ; <CJK>
     (?$(CwX(B . ?\x5806) ; <CJK>
     (?$(CwY(B . ?\x69CC) ; <CJK>
     (?$(CwZ(B . ?\x817F) ; <CJK>
     (?$(Cw[(B . ?\x892A) ; <CJK>
     (?$(Cw\(B . ?\x9000) ; <CJK>
     (?$(Cw](B . ?\x9839) ; <CJK>
     (?$(Cw^(B . ?\x5078) ; <CJK>
     (?$(Cw_(B . ?\x5957) ; <CJK>
     (?$(Cw`(B . ?\x59AC) ; <CJK>
     (?$(Cwa(B . ?\x6295) ; <CJK>
     (?$(Cwb(B . ?\x900F) ; <CJK>
     (?$(Cwc(B . ?\x9B2A) ; <CJK>
     (?$(Cwd(B . ?\x615D) ; <CJK>
     (?$(Cwe(B . ?\x7279) ; <CJK>
     (?$(Cwf(B . ?\x95D6) ; <CJK>
     (?$(Cwg(B . ?\x5761) ; <CJK>
     (?$(Cwh(B . ?\x5A46) ; <CJK>
     (?$(Cwi(B . ?\x5DF4) ; <CJK>
     (?$(Cwj(B . ?\x628A) ; <CJK>
     (?$(Cwk(B . ?\x64AD) ; <CJK>
     (?$(Cwl(B . ?\x64FA) ; <CJK>
     (?$(Cwm(B . ?\x6777) ; <CJK>
     (?$(Cwn(B . ?\x6CE2) ; <CJK>
     (?$(Cwo(B . ?\x6D3E) ; <CJK>
     (?$(Cwp(B . ?\x722C) ; <CJK>
     (?$(Cwq(B . ?\x7436) ; <CJK>
     (?$(Cwr(B . ?\x7834) ; <CJK>
     (?$(Cws(B . ?\x7F77) ; <CJK>
     (?$(Cwt(B . ?\x82AD) ; <CJK>
     (?$(Cwu(B . ?\x8DDB) ; <CJK>
     (?$(Cwv(B . ?\x9817) ; <CJK>
     (?$(Cww(B . ?\x5224) ; <CJK>
     (?$(Cwx(B . ?\x5742) ; <CJK>
     (?$(Cwy(B . ?\x677F) ; <CJK>
     (?$(Cwz(B . ?\x7248) ; <CJK>
     (?$(Cw{(B . ?\x74E3) ; <CJK>
     (?$(Cw|(B . ?\x8CA9) ; <CJK>
     (?$(Cw}(B . ?\x8FA6) ; <CJK>
     (?$(Cw~(B . ?\x9211) ; <CJK>
     (?$(Cx!(B . ?\x962A) ; <CJK>
     (?$(Cx"(B . ?\x516B) ; <CJK>
     (?$(Cx#(B . ?\x53ED) ; <CJK>
     (?$(Cx$(B . ?\x634C) ; <CJK>
     (?$(Cx%(B . ?\x4F69) ; <CJK>
     (?$(Cx&(B . ?\x5504) ; <CJK>
     (?$(Cx'(B . ?\x6096) ; <CJK>
     (?$(Cx((B . ?\x6557) ; <CJK>
     (?$(Cx)(B . ?\x6C9B) ; <CJK>
     (?$(Cx*(B . ?\x6D7F) ; <CJK>
     (?$(Cx+(B . ?\x724C) ; <CJK>
     (?$(Cx,(B . ?\x72FD) ; <CJK>
     (?$(Cx-(B . ?\x7A17) ; <CJK>
     (?$(Cx.(B . ?\x8987) ; <CJK>
     (?$(Cx/(B . ?\x8C9D) ; <CJK>
     (?$(Cx0(B . ?\x5F6D) ; <CJK>
     (?$(Cx1(B . ?\x6F8E) ; <CJK>
     (?$(Cx2(B . ?\x70F9) ; <CJK>
     (?$(Cx3(B . ?\x81A8) ; <CJK>
     (?$(Cx4(B . ?\x610E) ; <CJK>
     (?$(Cx5(B . ?\x4FBF) ; <CJK>
     (?$(Cx6(B . ?\x504F) ; <CJK>
     (?$(Cx7(B . ?\x6241) ; <CJK>
     (?$(Cx8(B . ?\x7247) ; <CJK>
     (?$(Cx9(B . ?\x7BC7) ; <CJK>
     (?$(Cx:(B . ?\x7DE8) ; <CJK>
     (?$(Cx;(B . ?\x7FE9) ; <CJK>
     (?$(Cx<(B . ?\x904D) ; <CJK>
     (?$(Cx=(B . ?\x97AD) ; <CJK>
     (?$(Cx>(B . ?\x9A19) ; <CJK>
     (?$(Cx?(B . ?\x8CB6) ; <CJK>
     (?$(Cx@(B . ?\x576A) ; <CJK>
     (?$(CxA(B . ?\x5E73) ; <CJK>
     (?$(CxB(B . ?\x67B0) ; <CJK>
     (?$(CxC(B . ?\x840D) ; <CJK>
     (?$(CxD(B . ?\x8A55) ; <CJK>
     (?$(CxE(B . ?\x5420) ; <CJK>
     (?$(CxF(B . ?\x5B16) ; <CJK>
     (?$(CxG(B . ?\x5E63) ; <CJK>
     (?$(CxH(B . ?\x5EE2) ; <CJK>
     (?$(CxI(B . ?\x5F0A) ; <CJK>
     (?$(CxJ(B . ?\x6583) ; <CJK>
     (?$(CxK(B . ?\x80BA) ; <CJK>
     (?$(CxL(B . ?\x853D) ; <CJK>
     (?$(CxM(B . ?\x9589) ; <CJK>
     (?$(CxN(B . ?\x965B) ; <CJK>
     (?$(CxO(B . ?\x4F48) ; <CJK>
     (?$(CxP(B . ?\x5305) ; <CJK>
     (?$(CxQ(B . ?\x530D) ; <CJK>
     (?$(CxR(B . ?\x530F) ; <CJK>
     (?$(CxS(B . ?\x5486) ; <CJK>
     (?$(CxT(B . ?\x54FA) ; <CJK>
     (?$(CxU(B . ?\x5703) ; <CJK>
     (?$(CxV(B . ?\x5E03) ; <CJK>
     (?$(CxW(B . ?\x6016) ; <CJK>
     (?$(CxX(B . ?\x629B) ; <CJK>
     (?$(CxY(B . ?\x62B1) ; <CJK>
     (?$(CxZ(B . ?\x6355) ; <CJK>
     (?$(Cx[(B . ?\xFA06) ; <CJK>
     (?$(Cx\(B . ?\x6CE1) ; <CJK>
     (?$(Cx](B . ?\x6D66) ; <CJK>
     (?$(Cx^(B . ?\x75B1) ; <CJK>
     (?$(Cx_(B . ?\x7832) ; <CJK>
     (?$(Cx`(B . ?\x80DE) ; <CJK>
     (?$(Cxa(B . ?\x812F) ; <CJK>
     (?$(Cxb(B . ?\x82DE) ; <CJK>
     (?$(Cxc(B . ?\x8461) ; <CJK>
     (?$(Cxd(B . ?\x84B2) ; <CJK>
     (?$(Cxe(B . ?\x888D) ; <CJK>
     (?$(Cxf(B . ?\x8912) ; <CJK>
     (?$(Cxg(B . ?\x900B) ; <CJK>
     (?$(Cxh(B . ?\x92EA) ; <CJK>
     (?$(Cxi(B . ?\x98FD) ; <CJK>
     (?$(Cxj(B . ?\x9B91) ; <CJK>
     (?$(Cxk(B . ?\x5E45) ; <CJK>
     (?$(Cxl(B . ?\x66B4) ; <CJK>
     (?$(Cxm(B . ?\x66DD) ; <CJK>
     (?$(Cxn(B . ?\x7011) ; <CJK>
     (?$(Cxo(B . ?\x7206) ; <CJK>
     (?$(Cxp(B . ?\xFA07) ; <CJK>
     (?$(Cxq(B . ?\x4FF5) ; <CJK>
     (?$(Cxr(B . ?\x527D) ; <CJK>
     (?$(Cxs(B . ?\x5F6A) ; <CJK>
     (?$(Cxt(B . ?\x6153) ; <CJK>
     (?$(Cxu(B . ?\x6753) ; <CJK>
     (?$(Cxv(B . ?\x6A19) ; <CJK>
     (?$(Cxw(B . ?\x6F02) ; <CJK>
     (?$(Cxx(B . ?\x74E2) ; <CJK>
     (?$(Cxy(B . ?\x7968) ; <CJK>
     (?$(Cxz(B . ?\x8868) ; <CJK>
     (?$(Cx{(B . ?\x8C79) ; <CJK>
     (?$(Cx|(B . ?\x98C7) ; <CJK>
     (?$(Cx}(B . ?\x98C4) ; <CJK>
     (?$(Cx~(B . ?\x9A43) ; <CJK>
     (?$(Cy!(B . ?\x54C1) ; <CJK>
     (?$(Cy"(B . ?\x7A1F) ; <CJK>
     (?$(Cy#(B . ?\x6953) ; <CJK>
     (?$(Cy$(B . ?\x8AF7) ; <CJK>
     (?$(Cy%(B . ?\x8C4A) ; <CJK>
     (?$(Cy&(B . ?\x98A8) ; <CJK>
     (?$(Cy'(B . ?\x99AE) ; <CJK>
     (?$(Cy((B . ?\x5F7C) ; <CJK>
     (?$(Cy)(B . ?\x62AB) ; <CJK>
     (?$(Cy*(B . ?\x75B2) ; <CJK>
     (?$(Cy+(B . ?\x76AE) ; <CJK>
     (?$(Cy,(B . ?\x88AB) ; <CJK>
     (?$(Cy-(B . ?\x907F) ; <CJK>
     (?$(Cy.(B . ?\x9642) ; <CJK>
     (?$(Cy/(B . ?\x5339) ; <CJK>
     (?$(Cy0(B . ?\x5F3C) ; <CJK>
     (?$(Cy1(B . ?\x5FC5) ; <CJK>
     (?$(Cy2(B . ?\x6CCC) ; <CJK>
     (?$(Cy3(B . ?\x73CC) ; <CJK>
     (?$(Cy4(B . ?\x7562) ; <CJK>
     (?$(Cy5(B . ?\x758B) ; <CJK>
     (?$(Cy6(B . ?\x7B46) ; <CJK>
     (?$(Cy7(B . ?\x82FE) ; <CJK>
     (?$(Cy8(B . ?\x999D) ; <CJK>
     (?$(Cy9(B . ?\x4E4F) ; <CJK>
     (?$(Cy:(B . ?\x903C) ; <CJK>
     (?$(Cy;(B . ?\x4E0B) ; <CJK>
     (?$(Cy<(B . ?\x4F55) ; <CJK>
     (?$(Cy=(B . ?\x53A6) ; <CJK>
     (?$(Cy>(B . ?\x590F) ; <CJK>
     (?$(Cy?(B . ?\x5EC8) ; <CJK>
     (?$(Cy@(B . ?\x6630) ; <CJK>
     (?$(CyA(B . ?\x6CB3) ; <CJK>
     (?$(CyB(B . ?\x7455) ; <CJK>
     (?$(CyC(B . ?\x8377) ; <CJK>
     (?$(CyD(B . ?\x8766) ; <CJK>
     (?$(CyE(B . ?\x8CC0) ; <CJK>
     (?$(CyF(B . ?\x9050) ; <CJK>
     (?$(CyG(B . ?\x971E) ; <CJK>
     (?$(CyH(B . ?\x9C15) ; <CJK>
     (?$(CyI(B . ?\x58D1) ; <CJK>
     (?$(CyJ(B . ?\x5B78) ; <CJK>
     (?$(CyK(B . ?\x8650) ; <CJK>
     (?$(CyL(B . ?\x8B14) ; <CJK>
     (?$(CyM(B . ?\x9DB4) ; <CJK>
     (?$(CyN(B . ?\x5BD2) ; <CJK>
     (?$(CyO(B . ?\x6068) ; <CJK>
     (?$(CyP(B . ?\x608D) ; <CJK>
     (?$(CyQ(B . ?\x65F1) ; <CJK>
     (?$(CyR(B . ?\x6C57) ; <CJK>
     (?$(CyS(B . ?\x6F22) ; <CJK>
     (?$(CyT(B . ?\x6FA3) ; <CJK>
     (?$(CyU(B . ?\x701A) ; <CJK>
     (?$(CyV(B . ?\x7F55) ; <CJK>
     (?$(CyW(B . ?\x7FF0) ; <CJK>
     (?$(CyX(B . ?\x9591) ; <CJK>
     (?$(CyY(B . ?\x9592) ; <CJK>
     (?$(CyZ(B . ?\x9650) ; <CJK>
     (?$(Cy[(B . ?\x97D3) ; <CJK>
     (?$(Cy\(B . ?\x5272) ; <CJK>
     (?$(Cy](B . ?\x8F44) ; <CJK>
     (?$(Cy^(B . ?\x51FD) ; <CJK>
     (?$(Cy_(B . ?\x542B) ; <CJK>
     (?$(Cy`(B . ?\x54B8) ; <CJK>
     (?$(Cya(B . ?\x5563) ; <CJK>
     (?$(Cyb(B . ?\x558A) ; <CJK>
     (?$(Cyc(B . ?\x6ABB) ; <CJK>
     (?$(Cyd(B . ?\x6DB5) ; <CJK>
     (?$(Cye(B . ?\x7DD8) ; <CJK>
     (?$(Cyf(B . ?\x8266) ; <CJK>
     (?$(Cyg(B . ?\x929C) ; <CJK>
     (?$(Cyh(B . ?\x9677) ; <CJK>
     (?$(Cyi(B . ?\x9E79) ; <CJK>
     (?$(Cyj(B . ?\x5408) ; <CJK>
     (?$(Cyk(B . ?\x54C8) ; <CJK>
     (?$(Cyl(B . ?\x76D2) ; <CJK>
     (?$(Cym(B . ?\x86E4) ; <CJK>
     (?$(Cyn(B . ?\x95A4) ; <CJK>
     (?$(Cyo(B . ?\x95D4) ; <CJK>
     (?$(Cyp(B . ?\x965C) ; <CJK>
     (?$(Cyq(B . ?\x4EA2) ; <CJK>
     (?$(Cyr(B . ?\x4F09) ; <CJK>
     (?$(Cys(B . ?\x59EE) ; <CJK>
     (?$(Cyt(B . ?\x5AE6) ; <CJK>
     (?$(Cyu(B . ?\x5DF7) ; <CJK>
     (?$(Cyv(B . ?\x6052) ; <CJK>
     (?$(Cyw(B . ?\x6297) ; <CJK>
     (?$(Cyx(B . ?\x676D) ; <CJK>
     (?$(Cyy(B . ?\x6841) ; <CJK>
     (?$(Cyz(B . ?\x6C86) ; <CJK>
     (?$(Cy{(B . ?\x6E2F) ; <CJK>
     (?$(Cy|(B . ?\x7F38) ; <CJK>
     (?$(Cy}(B . ?\x809B) ; <CJK>
     (?$(Cy~(B . ?\x822A) ; <CJK>
     (?$(Cz!(B . ?\xFA08) ; <CJK>
     (?$(Cz"(B . ?\xFA09) ; <CJK>
     (?$(Cz#(B . ?\x9805) ; <CJK>
     (?$(Cz$(B . ?\x4EA5) ; <CJK>
     (?$(Cz%(B . ?\x5055) ; <CJK>
     (?$(Cz&(B . ?\x54B3) ; <CJK>
     (?$(Cz'(B . ?\x5793) ; <CJK>
     (?$(Cz((B . ?\x595A) ; <CJK>
     (?$(Cz)(B . ?\x5B69) ; <CJK>
     (?$(Cz*(B . ?\x5BB3) ; <CJK>
     (?$(Cz+(B . ?\x61C8) ; <CJK>
     (?$(Cz,(B . ?\x6977) ; <CJK>
     (?$(Cz-(B . ?\x6D77) ; <CJK>
     (?$(Cz.(B . ?\x7023) ; <CJK>
     (?$(Cz/(B . ?\x87F9) ; <CJK>
     (?$(Cz0(B . ?\x89E3) ; <CJK>
     (?$(Cz1(B . ?\x8A72) ; <CJK>
     (?$(Cz2(B . ?\x8AE7) ; <CJK>
     (?$(Cz3(B . ?\x9082) ; <CJK>
     (?$(Cz4(B . ?\x99ED) ; <CJK>
     (?$(Cz5(B . ?\x9AB8) ; <CJK>
     (?$(Cz6(B . ?\x52BE) ; <CJK>
     (?$(Cz7(B . ?\x6838) ; <CJK>
     (?$(Cz8(B . ?\x5016) ; <CJK>
     (?$(Cz9(B . ?\x5E78) ; <CJK>
     (?$(Cz:(B . ?\x674F) ; <CJK>
     (?$(Cz;(B . ?\x8347) ; <CJK>
     (?$(Cz<(B . ?\x884C) ; <CJK>
     (?$(Cz=(B . ?\x4EAB) ; <CJK>
     (?$(Cz>(B . ?\x5411) ; <CJK>
     (?$(Cz?(B . ?\x56AE) ; <CJK>
     (?$(Cz@(B . ?\x73E6) ; <CJK>
     (?$(CzA(B . ?\x9115) ; <CJK>
     (?$(CzB(B . ?\x97FF) ; <CJK>
     (?$(CzC(B . ?\x9909) ; <CJK>
     (?$(CzD(B . ?\x9957) ; <CJK>
     (?$(CzE(B . ?\x9999) ; <CJK>
     (?$(CzF(B . ?\x5653) ; <CJK>
     (?$(CzG(B . ?\x589F) ; <CJK>
     (?$(CzH(B . ?\x865B) ; <CJK>
     (?$(CzI(B . ?\x8A31) ; <CJK>
     (?$(CzJ(B . ?\x61B2) ; <CJK>
     (?$(CzK(B . ?\x6AF6) ; <CJK>
     (?$(CzL(B . ?\x737B) ; <CJK>
     (?$(CzM(B . ?\x8ED2) ; <CJK>
     (?$(CzN(B . ?\x6B47) ; <CJK>
     (?$(CzO(B . ?\x96AA) ; <CJK>
     (?$(CzP(B . ?\x9A57) ; <CJK>
     (?$(CzQ(B . ?\x5955) ; <CJK>
     (?$(CzR(B . ?\x7200) ; <CJK>
     (?$(CzS(B . ?\x8D6B) ; <CJK>
     (?$(CzT(B . ?\x9769) ; <CJK>
     (?$(CzU(B . ?\x4FD4) ; <CJK>
     (?$(CzV(B . ?\x5CF4) ; <CJK>
     (?$(CzW(B . ?\x5F26) ; <CJK>
     (?$(CzX(B . ?\x61F8) ; <CJK>
     (?$(CzY(B . ?\x665B) ; <CJK>
     (?$(CzZ(B . ?\x6CEB) ; <CJK>
     (?$(Cz[(B . ?\x70AB) ; <CJK>
     (?$(Cz\(B . ?\x7384) ; <CJK>
     (?$(Cz](B . ?\x73B9) ; <CJK>
     (?$(Cz^(B . ?\x73FE) ; <CJK>
     (?$(Cz_(B . ?\x7729) ; <CJK>
     (?$(Cz`(B . ?\x774D) ; <CJK>
     (?$(Cza(B . ?\x7D43) ; <CJK>
     (?$(Czb(B . ?\x7D62) ; <CJK>
     (?$(Czc(B . ?\x7E23) ; <CJK>
     (?$(Czd(B . ?\x8237) ; <CJK>
     (?$(Cze(B . ?\x8852) ; <CJK>
     (?$(Czf(B . ?\xFA0A) ; <CJK>
     (?$(Czg(B . ?\x8CE2) ; <CJK>
     (?$(Czh(B . ?\x9249) ; <CJK>
     (?$(Czi(B . ?\x986F) ; <CJK>
     (?$(Czj(B . ?\x5B51) ; <CJK>
     (?$(Czk(B . ?\x7A74) ; <CJK>
     (?$(Czl(B . ?\x8840) ; <CJK>
     (?$(Czm(B . ?\x9801) ; <CJK>
     (?$(Czn(B . ?\x5ACC) ; <CJK>
     (?$(Czo(B . ?\x4FE0) ; <CJK>
     (?$(Czp(B . ?\x5354) ; <CJK>
     (?$(Czq(B . ?\x593E) ; <CJK>
     (?$(Czr(B . ?\x5CFD) ; <CJK>
     (?$(Czs(B . ?\x633E) ; <CJK>
     (?$(Czt(B . ?\x6D79) ; <CJK>
     (?$(Czu(B . ?\x72F9) ; <CJK>
     (?$(Czv(B . ?\x8105) ; <CJK>
     (?$(Czw(B . ?\x8107) ; <CJK>
     (?$(Czx(B . ?\x83A2) ; <CJK>
     (?$(Czy(B . ?\x92CF) ; <CJK>
     (?$(Czz(B . ?\x9830) ; <CJK>
     (?$(Cz{(B . ?\x4EA8) ; <CJK>
     (?$(Cz|(B . ?\x5144) ; <CJK>
     (?$(Cz}(B . ?\x5211) ; <CJK>
     (?$(Cz~(B . ?\x578B) ; <CJK>
     (?$(C{!(B . ?\x5F62) ; <CJK>
     (?$(C{"(B . ?\x6CC2) ; <CJK>
     (?$(C{#(B . ?\x6ECE) ; <CJK>
     (?$(C{$(B . ?\x7005) ; <CJK>
     (?$(C{%(B . ?\x7050) ; <CJK>
     (?$(C{&(B . ?\x70AF) ; <CJK>
     (?$(C{'(B . ?\x7192) ; <CJK>
     (?$(C{((B . ?\x73E9) ; <CJK>
     (?$(C{)(B . ?\x7469) ; <CJK>
     (?$(C{*(B . ?\x834A) ; <CJK>
     (?$(C{+(B . ?\x87A2) ; <CJK>
     (?$(C{,(B . ?\x8861) ; <CJK>
     (?$(C{-(B . ?\x9008) ; <CJK>
     (?$(C{.(B . ?\x90A2) ; <CJK>
     (?$(C{/(B . ?\x93A3) ; <CJK>
     (?$(C{0(B . ?\x99A8) ; <CJK>
     (?$(C{1(B . ?\x516E) ; <CJK>
     (?$(C{2(B . ?\x5F57) ; <CJK>
     (?$(C{3(B . ?\x60E0) ; <CJK>
     (?$(C{4(B . ?\x6167) ; <CJK>
     (?$(C{5(B . ?\x66B3) ; <CJK>
     (?$(C{6(B . ?\x8559) ; <CJK>
     (?$(C{7(B . ?\x8E4A) ; <CJK>
     (?$(C{8(B . ?\x91AF) ; <CJK>
     (?$(C{9(B . ?\x978B) ; <CJK>
     (?$(C{:(B . ?\x4E4E) ; <CJK>
     (?$(C{;(B . ?\x4E92) ; <CJK>
     (?$(C{<(B . ?\x547C) ; <CJK>
     (?$(C{=(B . ?\x58D5) ; <CJK>
     (?$(C{>(B . ?\x58FA) ; <CJK>
     (?$(C{?(B . ?\x597D) ; <CJK>
     (?$(C{@(B . ?\x5CB5) ; <CJK>
     (?$(C{A(B . ?\x5F27) ; <CJK>
     (?$(C{B(B . ?\x6236) ; <CJK>
     (?$(C{C(B . ?\x6248) ; <CJK>
     (?$(C{D(B . ?\x660A) ; <CJK>
     (?$(C{E(B . ?\x6667) ; <CJK>
     (?$(C{F(B . ?\x6BEB) ; <CJK>
     (?$(C{G(B . ?\x6D69) ; <CJK>
     (?$(C{H(B . ?\x6DCF) ; <CJK>
     (?$(C{I(B . ?\x6E56) ; <CJK>
     (?$(C{J(B . ?\x6EF8) ; <CJK>
     (?$(C{K(B . ?\x6F94) ; <CJK>
     (?$(C{L(B . ?\x6FE0) ; <CJK>
     (?$(C{M(B . ?\x6FE9) ; <CJK>
     (?$(C{N(B . ?\x705D) ; <CJK>
     (?$(C{O(B . ?\x72D0) ; <CJK>
     (?$(C{P(B . ?\x7425) ; <CJK>
     (?$(C{Q(B . ?\x745A) ; <CJK>
     (?$(C{R(B . ?\x74E0) ; <CJK>
     (?$(C{S(B . ?\x7693) ; <CJK>
     (?$(C{T(B . ?\x795C) ; <CJK>
     (?$(C{U(B . ?\x7CCA) ; <CJK>
     (?$(C{V(B . ?\x7E1E) ; <CJK>
     (?$(C{W(B . ?\x80E1) ; <CJK>
     (?$(C{X(B . ?\x82A6) ; <CJK>
     (?$(C{Y(B . ?\x846B) ; <CJK>
     (?$(C{Z(B . ?\x84BF) ; <CJK>
     (?$(C{[(B . ?\x864E) ; <CJK>
     (?$(C{\(B . ?\x865F) ; <CJK>
     (?$(C{](B . ?\x8774) ; <CJK>
     (?$(C{^(B . ?\x8B77) ; <CJK>
     (?$(C{_(B . ?\x8C6A) ; <CJK>
     (?$(C{`(B . ?\x93AC) ; <CJK>
     (?$(C{a(B . ?\x9800) ; <CJK>
     (?$(C{b(B . ?\x9865) ; <CJK>
     (?$(C{c(B . ?\x60D1) ; <CJK>
     (?$(C{d(B . ?\x6216) ; <CJK>
     (?$(C{e(B . ?\x9177) ; <CJK>
     (?$(C{f(B . ?\x5A5A) ; <CJK>
     (?$(C{g(B . ?\x660F) ; <CJK>
     (?$(C{h(B . ?\x6DF7) ; <CJK>
     (?$(C{i(B . ?\x6E3E) ; <CJK>
     (?$(C{j(B . ?\x743F) ; <CJK>
     (?$(C{k(B . ?\x9B42) ; <CJK>
     (?$(C{l(B . ?\x5FFD) ; <CJK>
     (?$(C{m(B . ?\x60DA) ; <CJK>
     (?$(C{n(B . ?\x7B0F) ; <CJK>
     (?$(C{o(B . ?\x54C4) ; <CJK>
     (?$(C{p(B . ?\x5F18) ; <CJK>
     (?$(C{q(B . ?\x6C5E) ; <CJK>
     (?$(C{r(B . ?\x6CD3) ; <CJK>
     (?$(C{s(B . ?\x6D2A) ; <CJK>
     (?$(C{t(B . ?\x70D8) ; <CJK>
     (?$(C{u(B . ?\x7D05) ; <CJK>
     (?$(C{v(B . ?\x8679) ; <CJK>
     (?$(C{w(B . ?\x8A0C) ; <CJK>
     (?$(C{x(B . ?\x9D3B) ; <CJK>
     (?$(C{y(B . ?\x5316) ; <CJK>
     (?$(C{z(B . ?\x548C) ; <CJK>
     (?$(C{{(B . ?\x5B05) ; <CJK>
     (?$(C{|(B . ?\x6A3A) ; <CJK>
     (?$(C{}(B . ?\x706B) ; <CJK>
     (?$(C{~(B . ?\x7575) ; <CJK>
     (?$(C|!(B . ?\x798D) ; <CJK>
     (?$(C|"(B . ?\x79BE) ; <CJK>
     (?$(C|#(B . ?\x82B1) ; <CJK>
     (?$(C|$(B . ?\x83EF) ; <CJK>
     (?$(C|%(B . ?\x8A71) ; <CJK>
     (?$(C|&(B . ?\x8B41) ; <CJK>
     (?$(C|'(B . ?\x8CA8) ; <CJK>
     (?$(C|((B . ?\x9774) ; <CJK>
     (?$(C|)(B . ?\xFA0B) ; <CJK>
     (?$(C|*(B . ?\x64F4) ; <CJK>
     (?$(C|+(B . ?\x652B) ; <CJK>
     (?$(C|,(B . ?\x78BA) ; <CJK>
     (?$(C|-(B . ?\x78BB) ; <CJK>
     (?$(C|.(B . ?\x7A6B) ; <CJK>
     (?$(C|/(B . ?\x4E38) ; <CJK>
     (?$(C|0(B . ?\x559A) ; <CJK>
     (?$(C|1(B . ?\x5950) ; <CJK>
     (?$(C|2(B . ?\x5BA6) ; <CJK>
     (?$(C|3(B . ?\x5E7B) ; <CJK>
     (?$(C|4(B . ?\x60A3) ; <CJK>
     (?$(C|5(B . ?\x63DB) ; <CJK>
     (?$(C|6(B . ?\x6B61) ; <CJK>
     (?$(C|7(B . ?\x6665) ; <CJK>
     (?$(C|8(B . ?\x6853) ; <CJK>
     (?$(C|9(B . ?\x6E19) ; <CJK>
     (?$(C|:(B . ?\x7165) ; <CJK>
     (?$(C|;(B . ?\x74B0) ; <CJK>
     (?$(C|<(B . ?\x7D08) ; <CJK>
     (?$(C|=(B . ?\x9084) ; <CJK>
     (?$(C|>(B . ?\x9A69) ; <CJK>
     (?$(C|?(B . ?\x9C25) ; <CJK>
     (?$(C|@(B . ?\x6D3B) ; <CJK>
     (?$(C|A(B . ?\x6ED1) ; <CJK>
     (?$(C|B(B . ?\x733E) ; <CJK>
     (?$(C|C(B . ?\x8C41) ; <CJK>
     (?$(C|D(B . ?\x95CA) ; <CJK>
     (?$(C|E(B . ?\x51F0) ; <CJK>
     (?$(C|F(B . ?\x5E4C) ; <CJK>
     (?$(C|G(B . ?\x5FA8) ; <CJK>
     (?$(C|H(B . ?\x604D) ; <CJK>
     (?$(C|I(B . ?\x60F6) ; <CJK>
     (?$(C|J(B . ?\x6130) ; <CJK>
     (?$(C|K(B . ?\x614C) ; <CJK>
     (?$(C|L(B . ?\x6643) ; <CJK>
     (?$(C|M(B . ?\x6644) ; <CJK>
     (?$(C|N(B . ?\x69A5) ; <CJK>
     (?$(C|O(B . ?\x6CC1) ; <CJK>
     (?$(C|P(B . ?\x6E5F) ; <CJK>
     (?$(C|Q(B . ?\x6EC9) ; <CJK>
     (?$(C|R(B . ?\x6F62) ; <CJK>
     (?$(C|S(B . ?\x714C) ; <CJK>
     (?$(C|T(B . ?\x749C) ; <CJK>
     (?$(C|U(B . ?\x7687) ; <CJK>
     (?$(C|V(B . ?\x7BC1) ; <CJK>
     (?$(C|W(B . ?\x7C27) ; <CJK>
     (?$(C|X(B . ?\x8352) ; <CJK>
     (?$(C|Y(B . ?\x8757) ; <CJK>
     (?$(C|Z(B . ?\x9051) ; <CJK>
     (?$(C|[(B . ?\x968D) ; <CJK>
     (?$(C|\(B . ?\x9EC3) ; <CJK>
     (?$(C|](B . ?\x532F) ; <CJK>
     (?$(C|^(B . ?\x56DE) ; <CJK>
     (?$(C|_(B . ?\x5EFB) ; <CJK>
     (?$(C|`(B . ?\x5F8A) ; <CJK>
     (?$(C|a(B . ?\x6062) ; <CJK>
     (?$(C|b(B . ?\x6094) ; <CJK>
     (?$(C|c(B . ?\x61F7) ; <CJK>
     (?$(C|d(B . ?\x6666) ; <CJK>
     (?$(C|e(B . ?\x6703) ; <CJK>
     (?$(C|f(B . ?\x6A9C) ; <CJK>
     (?$(C|g(B . ?\x6DEE) ; <CJK>
     (?$(C|h(B . ?\x6FAE) ; <CJK>
     (?$(C|i(B . ?\x7070) ; <CJK>
     (?$(C|j(B . ?\x736A) ; <CJK>
     (?$(C|k(B . ?\x7E6A) ; <CJK>
     (?$(C|l(B . ?\x81BE) ; <CJK>
     (?$(C|m(B . ?\x8334) ; <CJK>
     (?$(C|n(B . ?\x86D4) ; <CJK>
     (?$(C|o(B . ?\x8AA8) ; <CJK>
     (?$(C|p(B . ?\x8CC4) ; <CJK>
     (?$(C|q(B . ?\x5283) ; <CJK>
     (?$(C|r(B . ?\x7372) ; <CJK>
     (?$(C|s(B . ?\x5B96) ; <CJK>
     (?$(C|t(B . ?\x6A6B) ; <CJK>
     (?$(C|u(B . ?\x9404) ; <CJK>
     (?$(C|v(B . ?\x54EE) ; <CJK>
     (?$(C|w(B . ?\x5686) ; <CJK>
     (?$(C|x(B . ?\x5B5D) ; <CJK>
     (?$(C|y(B . ?\x6548) ; <CJK>
     (?$(C|z(B . ?\x6585) ; <CJK>
     (?$(C|{(B . ?\x66C9) ; <CJK>
     (?$(C||(B . ?\x689F) ; <CJK>
     (?$(C|}(B . ?\x6D8D) ; <CJK>
     (?$(C|~(B . ?\x6DC6) ; <CJK>
     (?$(C}!(B . ?\x723B) ; <CJK>
     (?$(C}"(B . ?\x80B4) ; <CJK>
     (?$(C}#(B . ?\x9175) ; <CJK>
     (?$(C}$(B . ?\x9A4D) ; <CJK>
     (?$(C}%(B . ?\x4FAF) ; <CJK>
     (?$(C}&(B . ?\x5019) ; <CJK>
     (?$(C}'(B . ?\x539A) ; <CJK>
     (?$(C}((B . ?\x540E) ; <CJK>
     (?$(C})(B . ?\x543C) ; <CJK>
     (?$(C}*(B . ?\x5589) ; <CJK>
     (?$(C}+(B . ?\x55C5) ; <CJK>
     (?$(C},(B . ?\x5E3F) ; <CJK>
     (?$(C}-(B . ?\x5F8C) ; <CJK>
     (?$(C}.(B . ?\x673D) ; <CJK>
     (?$(C}/(B . ?\x7166) ; <CJK>
     (?$(C}0(B . ?\x73DD) ; <CJK>
     (?$(C}1(B . ?\x9005) ; <CJK>
     (?$(C}2(B . ?\x52DB) ; <CJK>
     (?$(C}3(B . ?\x52F3) ; <CJK>
     (?$(C}4(B . ?\x5864) ; <CJK>
     (?$(C}5(B . ?\x58CE) ; <CJK>
     (?$(C}6(B . ?\x7104) ; <CJK>
     (?$(C}7(B . ?\x718F) ; <CJK>
     (?$(C}8(B . ?\x71FB) ; <CJK>
     (?$(C}9(B . ?\x85B0) ; <CJK>
     (?$(C}:(B . ?\x8A13) ; <CJK>
     (?$(C};(B . ?\x6688) ; <CJK>
     (?$(C}<(B . ?\x85A8) ; <CJK>
     (?$(C}=(B . ?\x55A7) ; <CJK>
     (?$(C}>(B . ?\x6684) ; <CJK>
     (?$(C}?(B . ?\x714A) ; <CJK>
     (?$(C}@(B . ?\x8431) ; <CJK>
     (?$(C}A(B . ?\x5349) ; <CJK>
     (?$(C}B(B . ?\x5599) ; <CJK>
     (?$(C}C(B . ?\x6BC1) ; <CJK>
     (?$(C}D(B . ?\x5F59) ; <CJK>
     (?$(C}E(B . ?\x5FBD) ; <CJK>
     (?$(C}F(B . ?\x63EE) ; <CJK>
     (?$(C}G(B . ?\x6689) ; <CJK>
     (?$(C}H(B . ?\x7147) ; <CJK>
     (?$(C}I(B . ?\x8AF1) ; <CJK>
     (?$(C}J(B . ?\x8F1D) ; <CJK>
     (?$(C}K(B . ?\x9EBE) ; <CJK>
     (?$(C}L(B . ?\x4F11) ; <CJK>
     (?$(C}M(B . ?\x643A) ; <CJK>
     (?$(C}N(B . ?\x70CB) ; <CJK>
     (?$(C}O(B . ?\x7566) ; <CJK>
     (?$(C}P(B . ?\x8667) ; <CJK>
     (?$(C}Q(B . ?\x6064) ; <CJK>
     (?$(C}R(B . ?\x8B4E) ; <CJK>
     (?$(C}S(B . ?\x9DF8) ; <CJK>
     (?$(C}T(B . ?\x5147) ; <CJK>
     (?$(C}U(B . ?\x51F6) ; <CJK>
     (?$(C}V(B . ?\x5308) ; <CJK>
     (?$(C}W(B . ?\x6D36) ; <CJK>
     (?$(C}X(B . ?\x80F8) ; <CJK>
     (?$(C}Y(B . ?\x9ED1) ; <CJK>
     (?$(C}Z(B . ?\x6615) ; <CJK>
     (?$(C}[(B . ?\x6B23) ; <CJK>
     (?$(C}\(B . ?\x7098) ; <CJK>
     (?$(C}](B . ?\x75D5) ; <CJK>
     (?$(C}^(B . ?\x5403) ; <CJK>
     (?$(C}_(B . ?\x5C79) ; <CJK>
     (?$(C}`(B . ?\x7D07) ; <CJK>
     (?$(C}a(B . ?\x8A16) ; <CJK>
     (?$(C}b(B . ?\x6B20) ; <CJK>
     (?$(C}c(B . ?\x6B3D) ; <CJK>
     (?$(C}d(B . ?\x6B46) ; <CJK>
     (?$(C}e(B . ?\x5438) ; <CJK>
     (?$(C}f(B . ?\x6070) ; <CJK>
     (?$(C}g(B . ?\x6D3D) ; <CJK>
     (?$(C}h(B . ?\x7FD5) ; <CJK>
     (?$(C}i(B . ?\x8208) ; <CJK>
     (?$(C}j(B . ?\x50D6) ; <CJK>
     (?$(C}k(B . ?\x51DE) ; <CJK>
     (?$(C}l(B . ?\x559C) ; <CJK>
     (?$(C}m(B . ?\x566B) ; <CJK>
     (?$(C}n(B . ?\x56CD) ; <CJK>
     (?$(C}o(B . ?\x59EC) ; <CJK>
     (?$(C}p(B . ?\x5B09) ; <CJK>
     (?$(C}q(B . ?\x5E0C) ; <CJK>
     (?$(C}r(B . ?\x6199) ; <CJK>
     (?$(C}s(B . ?\x6198) ; <CJK>
     (?$(C}t(B . ?\x6231) ; <CJK>
     (?$(C}u(B . ?\x665E) ; <CJK>
     (?$(C}v(B . ?\x66E6) ; <CJK>
     (?$(C}w(B . ?\x7199) ; <CJK>
     (?$(C}x(B . ?\x71B9) ; <CJK>
     (?$(C}y(B . ?\x71BA) ; <CJK>
     (?$(C}z(B . ?\x72A7) ; <CJK>
     (?$(C}{(B . ?\x79A7) ; <CJK>
     (?$(C}|(B . ?\x7A00) ; <CJK>
     (?$(C}}(B . ?\x7FB2) ; <CJK>
     (?$(C}~(B . ?\x8A70) ; <CJK>
     )))

(provide 'uksc5601)

;;; uksc5601.el ends here
 