/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : fbdelay.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitFBDelay
|
| Description : DSPKitFBDelay
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_FBDELAY_H_
#define _DSPKIT_FBDELAY_H_

#include "processo.h"

class DSPKitFBDelay : public DSPKitProcessor
{
  public:

    DSPKitFBDelay ();
    ~DSPKitFBDelay ();
    long setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    long getSample (double &outputSample);

  protected:

    double delayTime;
    double *buffer;
    long   bufSize;
    long   oldestSampleIndex;
    long   lastSampleIndex;
    long   haveSamples;
    long   endOfInput;
};

#endif

/***************************************************************************/
