/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : delay.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDelay
|
| Description : DSPKitDelay
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_DELAY_H_
#define _DSPKIT_DELAY_H_

#include "processo.h"

class DSPKitDelay : public DSPKitProcessor
{
  public:

    DSPKitDelay ();
    ~DSPKitDelay ();
    long setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    long getSample (double &outputSample);

  protected:

    double delayTime;
    double *buffer;
    long   bufSize;
    long   oldestSampleIndex;
    long   lastSampleIndex;
    long   haveSamples;
    long   endOfInput;
};

#endif

/***************************************************************************/
