/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb/vdkb_actstack.h>
#include <vdkb/vdkb_text.h>
/*
 */
ActionDelete::ActionDelete(VDKBText* text, int start, int end): 
  ActionText(text,start)
    { 
      char* p = text->GetChars(start,end);
      if(p)
	{
	  buf = new char[(end-start)+1];
	  strncpy(buf,p,end-start);
	  buf[end-start] = '\0';
	  g_free(p);
	}
    }
/*
 */
void ActionDelete::undo()
{
text->Pointer = pos;
if(buf)
  text->TextInsert(buf,-1);
}
/*
 */ 
void ActionInsert::undo()
{
text->Pointer = pos;
text->ForwardDelete(len);
}

//==============================================
/*
 */
ActionStack::~ActionStack()
{
delete[] base;
}

/*
flush stack
 */
void
ActionStack::flush()
{
Action* action;
while((action = pop()) != (Action*) 0)
      delete action;

}

//==============================================
/*
implement a push with overflow
control.
Logic:
1. when stack goes on overflow creta a temp stack (half of this)
2. load temp stack with this (first half of this will be pushed)
3. flushes this
4. reload this with temp
5. push on this last refused action
So this stack mantain always almost more recent half
of this stack
 */
bool
VDKBActionStack::push(Action* t)
{
  bool result = ActionStack::push(t);
  if(result)
    return true;
  // overflow
  // makes a new temp stack
  ActionStack temp(MAX_ACTIONSTACK/2);
  while(temp.push(pop()));
  // flushes this
  flush();
  // reload this with temp
  for(;! temp.isEmpty();)
    ActionStack::push(temp.pop());
  // push last refused action;
  ActionStack::push(t);
  return true;
}


