/*
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers.

   $Id: global.h,v 1.87 1999/08/18 20:42:54 tiggr Exp $  */

#import <ltt/ltt.h>
#import <tom/trt.h>
#import "TLPatches.h"
#import "LTTPatches.h"

@class OTMCompound, OTMCustomMethod, OTMExpr, OTMInstance, OTMMeta, OTMMethod;
@class OTMTuple, OTMTypeTuple, OTMType, OTMTop, OTMVariable;

extern id CO_OTMAlias, CO_OTMAliasAlias, CO_OTMAnyRefType, CO_OTMAnyType;
extern id CO_OTMArgument, CO_OTMAsm, CO_OTMAssignment, CO_OTMBasic, CO_OTMBind;
extern id CO_OTMBreak, CO_OTMBuiltinMethod, CO_OTMCast, CO_OTMCatch;
extern id CO_OTMClass, CO_OTMCompound, CO_OTMCondExpr, CO_OTMConstant;
extern id CO_OTMContinue, CO_OTMCustomMethod, CO_OTMDynamicType;
extern id CO_OTMEntity, CO_OTMError, CO_OTMExpr, CO_OTMExtension;
extern id CO_OTMForeignExpr, CO_OTMForeignType, CO_OTMIdentifier;
extern id CO_OTMInstance, CO_OTMInvocation, CO_OTMITE, CO_OTMLoop;
extern id CO_OTMLocalVar, CO_OTMMeta, CO_OTMMetaRef, CO_OTMMethod;
extern id CO_OTMModAssign, CO_OTMNumberCST, CO_OTMObjectVar, CO_OTMOld;
extern id CO_OTMRefVar, CO_OTMReturn, CO_OTMSelector, CO_OTMStringCST;
extern id CO_OTMTop, CO_OTMTuple, CO_OTMType, CO_OTMTypeTuple;
extern id CO_OTMUnvocation, CO_OTMUnwind, CO_OTMVariable, CO_OTMLabel;

extern int indent_level;

extern int current_line;
extern id <TLString> current_filename;

/* The name of the unit a file of which we are compiling.  */
extern id <TLString> top_unit_name;

/* The basename of the file we are to compile.  */
extern TLString *input_basename;

/* The current compound.  */
extern OTMCompound *current_compound;

/* The output file.  */
extern id <TLOutputStream> of;

/* The extensions output to the output file.  */
extern TLSet *extensions_output;

/* The meta involved in the meta or method or whatever currently being
   output to the output file, be it as a declaration, or as a definition.  */
extern LTTMeta *output_current_context;

/* Similarly, the method.  */
extern OTMCustomMethod *output_current_method;

/* The current meta being scrutinized.  */
extern LTTMeta *current_either;

/* Iff !0, the resolver will do single-unit resolution.  */
extern int flag_1;

/* Iff !0, we should not run GC.  */
extern int flag_inhibit_gc;

/* Iff !0, conditions handlers are skipped.  */
extern int flag_suppress_conditions;

/* Iff !0, the C output should be readable and debuggable.  */
extern int flag_readable;

/* Iff !0, do not issue warnings about empty expressions.  */
extern int flag_inhibit_empty;

/* Iff !0, do not warn about unqualified redeclaration.  */
extern int flag_inhibit_unqualified_redeclare;

/* Iff !0, do not warn about double-slash comments.  */
extern int flag_inhibit_comment;

/* The number of times `-v' was specified on the command line.  */
extern int flag_verbose;

/* Determine how lookups are output.  */
extern int flag_lookup, flag_super;

/* Iff !0, the code is compiled for atomic GC.  Otherwise, it can handle
   incremental GC.  (If the compiler configuration value of STACK_PROTECT
   is SP_MARK, it can always handle incremental GC and this flag does not
   matter.

   XXX Maybe the value of STACK_PROTECT should be the default value of
   FLAG_ATOMIC_GC...)  */
extern int flag_atomic_gc;

/* Iff !0, identifiers are traced to ease debugging.  */
extern int flag_trace_identifiers;

/* Iff !0, use trt_ext_address to extract extension addresses.  */
extern int flag_check_extension_address;

/* The basename of this program.  */
extern id <TLString> prog;

/* The version information, as defined in `version.m'.  */
extern char *long_version, *short_version;

/* The current unit.  */
extern LTTUnit *current_unit;

/* The name of the extension fields of the state class and instance.  */
extern id <TLString> tom_i_state_field_name;
extern id <TLString> tom_c_state_field_name;

/* The main extension of the Common instance.  */
extern LTTExtension *common_main_ext;

/* The type matching any other type and the one matching any other
   reference type.  */
extern OTMType *the_any_type;
extern OTMType *the_any_ref_type;

/* The void, nil and any_type expressions.  */
extern OTMExpr *void_expr, *nil_expr, *any_type_expr;

/* Some classes/instances needed by the compiler.  */
extern OTMInstance *tom_string_instance;
extern OTMInstance *tom_condition_instance;
extern OTMInstance *tom_condition_class_instance;

/* The index number of the next argument.  */
extern int next_arg;

/* Emit the assignment of RHS to the LHS, and return the LHS.  */
OTMExpr *emit_assignment (OTMExpr *lhs, OTMExpr *rhs);

/* Emit code to check conditions.  */
void emit_conditions_pre (OTMCustomMethod *m);
void emit_conditions_post (OTMCustomMethod *m);

void exit_compound (void);
OTMCompound *enter_compound (void);

/* Emit an `old' assignment.  */
OTMExpr *emit_old_expr (OTMExpr *e);

/* Add the variable V to the current compound, and return it.  */
OTMExpr *emit_local_var (OTMVariable *v);

/* Emit the local var and initialize it with EXPR, of the default value of
   the type if EXPR is NIL.  */
void init_local_var (OTMVariable *v, OTMType *t, OTMExpr *expr);

/* Emit the statement S to the current compound.  */
void emit_statement (id s);

/* Resolve, elaborate and emit the expression E, returning its value.  */
OTMExpr *emit_expr (OTMExpr *e);

/* Return a tuple of temporary variables, which has the type T.  */
OTMTuple *temp_tuple_with_type (OTMTypeTuple *t, BOOL reuse);

/* Return a temporary variable with the type T.  */
OTMVariable *temp_var_with_type (OTMType *t, BOOL reuse);

/* Return a temporary variable, or a tuple of them, with the type T.  */
OTMExpr *temp_something_with_type (OTMType *t, BOOL reuse);

/* Return a valid NIL expression for the type T.  */
OTMExpr *nil_something_with_type (OTMType *t);

/********** Building invocations **********/
/* Build and return a single argument method invocation.  */
id invocation (OTMExpr *rcv, id name, OTMExpr *args);

/* Invoke invocation with the RCV and the name and arguments from the PART
   list.  If IS_SUPER, this actually is an invocation of `super' (and RCV
   should be self).  If, on top of that, !!SUPER_CONFINED, only that super
   is to be considered.  */
id build_invocation (id rcv, TLCons *part,
		     BOOL is_super, OTMMeta *super_confined);

/* Build and return an operator invocation with 1 argument.  */
id op_invocation1 (id name, OTMExpr *arg1);

/* Build and return an operator invocation with 2 arguments.  */
id op_invocation2 (id name, OTMExpr *arg1, OTMExpr *arg2);

/********** misc **********/

void load_file (LTTFile *file, id <TLString> meta_name,
		BOOL interface, BOOL must);

void load_interface (LTTInstance *ins);

void parse_file (id <TLString> name, LTTUnit *unit, FILE *f);

/* Return the name of the accessor method for the public variable named
   NAME.  */
id <TLString> accessor_method_name (id <TLString> name);

/* Return the name of the modifier method for the mutable variable named
   NAME.  */
id <TLString> modifier_method_name (id <TLString> name);

/* Printing names.  */
id method_name (OTMMethod *c, BOOL print_meta);
id method_name1 (id name, id args);
id method_name2 (id parts, id args);
id type_name (OTMType *c);
id <TLString> type_name_list (TLCons *l);

id <TLString> types_description (TLVector *v);
id <TLString> elements_type_description (TLVector *v, int skip);

#define ROUND(X, Y)  \
  ({					\
    __typeof__ (X) _x = (X);		\
    __typeof__ (Y) _y = (Y);		\
    __typeof__ (X) _z = _x + _y - 1;	\
    _z - (_z % _y);			\
  })

typedef enum
{
  OQ_STATIC	= 0x01,

#define OQ_STATIC_MASK		0x01

  OQ_DEFERRED	= 0x02,

#define OQ_DEFERRED_MASK	0x02

  OQ_REDEFINE	= 0x04,
  OQ_REDECLARE	= 0x08,
  OQ_REDO	= OQ_REDEFINE | OQ_REDECLARE,

#define OQ_REDO_MASK		0x0c

  OQ_PUBLIC	= 0x10,
  OQ_PROTECTED	= 0x20,
  OQ_PRIVATE	= 0x40,
  OQ_PROTECTION	= OQ_PUBLIC | OQ_PROTECTED | OQ_PRIVATE,

#define OQ_PROTECTION_MASK	0x70

  OQ_OUTPUT_DECL = 0x80,

#define OQ_OUTPUT_DECL_MASK	0x80

  OQ_MUTABLE	= 0x0100,

#define OQ_MUTABLE_MASK		0x0100

} otm_qualifiers;

#define MASK_SELECT(V, M)	((V) & (M))
#define MASK_SET(V, M, A)	(((V) & ~(M)) | (A))

#define Q_STATIC(Q)		MASK_SELECT (Q, OQ_STATIC_MASK)
#define Q_SET_STATIC(Q, V)	MASK_SET (Q, OQ_STATIC_MASK, V)

#define Q_DEFERRED(Q)		MASK_SELECT (Q, OQ_DEFERRED_MASK)
#define Q_SET_DEFERRED(Q, V)	MASK_SET (Q, OQ_DEFERRED_MASK, V)

#define Q_REDO(Q)		MASK_SELECT (Q, OQ_REDO_MASK)
#define Q_SET_REDO(Q, V)	MASK_SET (Q, OQ_REDO_MASK, V)

#define Q_PROTECTION(Q)		MASK_SELECT (Q, OQ_PROTECTION_MASK)
#define Q_SET_PROTECTION(Q, V)	MASK_SET (Q, OQ_PROTECTION_MASK, V)

#define Q_OUTPUT_DECL(Q)	MASK_SELECT (Q, OQ_OUTPUT_DECL_MASK)
#define Q_SET_OUTPUT_DECL(Q, V)	MASK_SET (Q, OQ_OUTPUT_DECL_MASK, V)

#define Q_MUTABLE(Q)		MASK_SELECT (Q, OQ_MUTABLE_MASK)
#define Q_SET_MUTABLE(Q, V)	MASK_SET (Q, OQ_MUTABLE_MASK, V)

/* Given a single qualifier, return its textual name.  */
id <TLString> qualifier_name (otm_qualifiers p);

/* Mask the qualifiers from Q, issueing warnings about them.  */
otm_qualifiers mask_qualifiers (otm_qualifiers value, otm_qualifiers mask);

/* The hashtable for uniqing string constants, and the ones actually used.  */
extern TLDictionary *strings, *used_strings;

/* The set of uniqued identifiers.  */
extern TLSet *identifiers;

/* The uniqued `:'.  */
extern TLString *unique_identifier_colon;

/* Return the uniqued identifier S.  */
extern TLString *unique_identifier (id <TLString> s);

/* This should not be here.  */
#undef YY_DECL
#define YY_DECL int otm_lex (YYSTYPE *lvalp)
extern char *yytext;

int otm_parse (void);

/* The current class or the current instance.
   Only one of these will ever be !NIL.  */
extern LTTClass *current_class;
extern LTTInstance *current_instance;

/* This is either the CURRENT_CLASS or the CURRENT_INSTANCE, whichever is
   !nil (they can't be both).  */
extern LTTMeta *current_either;

/* The current extension.  The main definition of a class or instance is
   also an extension.  It is called the main extension.  */
extern LTTExtension *current_extension;

/* In a definition or declaration, the current method.  */
extern OTMCustomMethod *current_method;

/* The lists of postponed aliases and supers.  */
extern TLCons *postponed_aliases;
extern TLCons *postponed_state_supers, *postponed_behaviour_supers;

/* Handle any postponed supers.  Iff MUST, all supers must have been
   resolved after this call.  */
void do_postponed_supers (BOOL must);

/* Resolve the expression EXPR in the context of the EXPECTED_TYPES.  For
   a given class type, any subclass will do.  Return the properly typed
   expression.  If !EXPECTED_TYPES, the CONVERTIBLE indicates that the
   expression is enclosed in a type cast, and the type of the expression
   should match CONVERTIBLE convertibly.  */
OTMExpr *resolve_expr (OTMExpr *expr, TLCons *expected,
		       OTMType *convertible, OTMType *context);

/* Cast the expression EXPR to the DESIRED_TYPE, if the type of the
   expression is not EQ that type, but only in case both types are
   OTMMeta's.  */
OTMExpr *implicit_cast (OTMExpr *expr, OTMType *desired_type);

/* Default implementation for use by entities which can only have one type
   (or which have already resolved their type), such as OTMExpr,
   TLNumber...  */
TLCons *default_resolve_expr (OTMType *t, TLCons *expected,
			      OTMType *to, OTMType *context,
			      int *indices, int index);

/* Intersect the type lists A and B, which are derived from the list C.
   This implies that if C is empty, A and B are unrelated.  Otherwise, A
   and B only contain elements from C, in the same order.  */
TLCons *types_intersect (TLCons *a, TLCons *b, TLCons *c);

/* Compare the type lists A and B, which are derived from the list C.  */
BOOL types_equal (TLCons *a, TLCons *b, TLCons *c);

/* Add the type T to the type list a and return the (new) list.  */
TLCons *types_add_element (OTMType *t, TLCons *a);

/* Add to A those types from C which T matches.  */
TLCons *types_add_elt_ordered (OTMType *t, TLCons *a, TLCons *c);

/* Return the type in A which the type T matches best.  INDEX is the
   actual type index to use.  Iff ARG_NOT_PROTO, the type must match
   convertibly to the types in A, otherwise, the types in A must match
   convertibly to the type T.  */
OTMType *types_element_of (OTMType *t, TLCons *a, OTMType *context,
			   int *indices, int index, BOOL arg_not_proto);
