<copyright> ByteStream class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: ByteStream.t,v 1.13 1998/01/05 01:05:12 tiggr Exp $</id>
    </copyright>

<doc> Instances of the {ByteStream} class are an abstraction of the UNIX
    file descriptors.  </doc>
implementation class
ByteStream: Descriptor, InputOutputStream

end;

implementation instance
ByteStream

/******************** InputStream ********************/
<doc> <h4>InputStream</h4>  </doc>

<doc> Read a byte and return it, raising an exception on end-of-file or
    error.  </doc>
extern byte
  read;

<doc> Read a byte and return it, returning {EOF} on end-of-file.  </doc>
extern int
  read;

<doc> Have the {buffer} read at most {num} bytes from the receiving
    {ByteStream} starting at {start}.  </doc>
int
  readRange (int, int) (start, num)
       into MutableByteArray buffer
{
  = [buffer readRange (start, num) fromByteStream self];
}

/******************** OutputStream ********************/
<doc> <h4>OutputStream</h4>  </doc>

extern void
  write byte b;

extern int
  write byte b;

extern int
  writeBytes int num
	from pointer address;

end;
