/* Interface to TLLLambda class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLLLambda.h,v 1.1 1998/01/08 16:13:22 tiggr Exp $  */

#import "TLString.h"

@class TLCons, TLSymbol;

/* [pp65] List of supported lambda keywords.  */
extern TLSymbol *Slambda_list_keywords;

@interface TLLLambda: TLObject
{
  id <TLString> documentation;
  TLCons *args_proto;
  TLCons *body;
}

+(TLLLambda *) lambdaWithArguments: (TLCons *) arglist body: (TLCons *) b;
-initWithArguments: (TLCons *) arglist body: (TLCons *) b;

-(id <TLString>) documentation;
-(TLCons *) prototype;
-(TLCons *) body;

@end
