/* Implementation of TLFilename class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLFilename.m,v 1.1 1998/01/08 16:11:36 tiggr Exp $  */

#import "tl/support.h"
#import "tl/TLFilename.h"
#import <stdlib.h>
#import <sys/param.h>

@implementation TLString (TLFilename)

-(id <TLString>) basename
{
  TLRange *r = [self rangeOfString: @"/" options: TLSEARCH_BACKWARD];

  return (r ? [self stringWithRange: [TLRange rangeWithStart: 1 + [r _start]
				      length: -1]] : self);
} /* -basename */

-(id <TLString>) expandedFilenameRelativeTo: (id <TLString>) dir
{
  if (len < 1 || *c_string == '/')
    return (self);

  if (*c_string == '~')
    {
      if (len == 1 || c_string[1] == '/')
	return ([isa stringWithFormat: @"%s%s", getenv ("HOME"), c_string + 1]);
    }
  else
    {
      if (!dir)
	{
	  char buf[MAXPATHLEN + 1];

	  /* XXX Check.  */
	  getcwd (buf, sizeof (buf));
	  dir = [isa stringWithFormat: @"%s", buf];
	}
      return ([isa stringWithFormat: @"%@/%s", dir, c_string]);
    }

  return (self);
} /* -expandedFilenameRelativeTo: */

-(id <TLString>) expandedFilename
{
  return ([self expandedFilenameRelativeTo: nil]);
} /* -expandedFilename */

-(BOOL) _fileExistsP
{
  return (!access (c_string, F_OK));
} /* _fileExistsP */

@end
