/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTExtension.m,v 1.17 1998/01/05 00:57:59 tiggr Exp $  */

#import "ltt.h"

@implementation LTTExtension

+(LTTExtension *) extensionWithName: (TLString *) n
			       file: (LTTFile *) f
			       meta: (LTTMeta *) m
{
  LTTExtension *e = [[self gcAlloc] initWithName: n file: f meta: m];
  id foo = semantics_for_extension (e);

  [e setSemantics: foo];

  return e;
}

-(void) addStaticVariable: (LTTVariable *) v
{
  if (!vars_static)
    ASGN_IVAR (vars_static, [TLDictionary dictionary]);

  [vars_static setObject: v forKey: [[v lttName] internal]];
}

-(void) addVariable: (LTTVariable *) v
{
  if (!vars_order)
    {
      ASGN_IVAR (vars_keyed, [TLDictionary dictionary]);
      ASGN_IVAR (vars_order, [TLVector vector]);
    }

  [vars_keyed setObject: v forKey: [[v lttName] internal]];
  [vars_order addElement: v];
}

-(void) gcReference
{
  MARK (meta);
  MARK (vars_keyed);
  MARK (vars_order);
  MARK (vars_static);

  [super gcReference];
}

-(BOOL) hasStaticVariables
{
  return !!vars_static;
}

-(BOOL) hasVariables
{
  return !!vars_order;
}

-(id) initWithName: (TLString *) n
	      file: (LTTFile *) f
	      meta: (LTTMeta *) m
{
  id <TLString> s = [[m lttName] external];
  char c = [m classp] ? 'c' : 'i';

  s = (n ? formac (nil, @"%c_%@_%@", c, s, quote (n))
       : formac (nil, @"%c_%@", c, s));

  [super initWithName: [CO_LTTName nameWithInternal: n external: s] file: f];

  meta = m;
  [meta addExtension: self];
  [[f unit] addExtension: self];

  return self;
}

-(BOOL) isMainExtension
{
  return ![name internal];
}

-(LTTMeta *) meta
{
  return meta;
}

-(int) numVariables
{
  return [vars_order length];
}

-(id <TLString>) outputExtensionDescriptionName
{
  return formac (nil, @"%@%@", TO_EXT_DESC_PREFIX, [name external]);
}

-(id <TLString>) outputExtensionFieldName
{
  return [name external];
}

-(id <TLString>) outputExtensionIdentityName
{
  return formac (nil, @"%@%@", TO_EXT_ID_PREFIX, [name external]);
}

-(id <TLString>) outputExtensionStructName
{
  return formac (nil, @"%@%@", TO_EXT_STRUCT_PREFIX, [name external]);
}

-(id <TLEnumerator>) staticVariables;
{
  return vars_static ? [vars_static valueEnumerator] : nil;
}

-(id <TLEnumerator>) variables
{
  return [vars_order enumerator];
}

@end
