/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIVariable.m,v 1.5 1998/01/05 00:57:19 tiggr Exp $  */

#define LTIVARIABLE_DECLARE_PRIVATE_METHODS
#import "LTIVariable.h"

@implementation LTIVariable

-(void) gcReference
{
  MARK (static_name);

  [super gcReference];
}

-(BOOL) isLocal
{
  return th_local;
}

-(void) setLocalName: (id <TLString>) sn
{
  [self setStaticName: sn];
  th_local = 1;
}

-(void) setStaticName: (id <TLString>) sn
{
  ASGN_IVAR (static_name, sn);
}

-(id <TLString>) staticName
{
  return static_name;
}

@end
