/* Generic alpha.
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>

   Copyright (C) 1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: alpha.h,v 1.3 1999/01/05 11:55:25 tiggr Exp $  */

#define BUILTIN_RETURN_TYPE  \
union						\
{						\
  struct { tom_int i; } i;			\
  struct { tom_long l; } l;			\
  struct { void *p; } p;			\
  struct { tom_int a, b; tom_double d; } d;	\
  struct { tom_int a, b; tom_float f; } f;	\
}

/* 6 general registers and 6 floating point registers.  */
#define APPLY_ARGS_REG_SIZE  (6 * sizeof (tom_long) + 6 * sizeof (tom_double))

#define APPLY_ARGS_START(SEL)  \
  do									\
    {									\
      int offset = 0;

/* This is too large, since we only take the SELF and CMD into account as
   being passed in a register.  */
#define APPLY_ARGS_STACK_SIZE(SEL)  \
  (sizeof (tom_double) * (SEL)->in->num + sizeof (void *) * (SEL)->out->num)

#define APPLY_ARGS_EMIT_INT_VALUE(TYPE, VALUE)  \
    ({									\
      TYPE *addr;							\
									\
      if (offset < 6 * 8)						\
	addr = (void *) &args->reg[8 + offset];				\
      else								\
	addr = (void *) ((char *) args->stack + (offset - 6 * 8));	\
      offset += 8;							\
      *addr = (VALUE);							\
      addr;})
	
/* Add a byte value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_BYTE(VALUE)  \
  APPLY_ARGS_EMIT_LONG ((tom_long) (VALUE))

/* Add a char value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_CHAR(VALUE)  \
  APPLY_ARGS_EMIT_LONG ((tom_long) (VALUE))

/* Add an int value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT(VALUE)  \
  APPLY_ARGS_EMIT_LONG ((tom_long) (VALUE))

/* Add a long value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_LONG(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (tom_long, VALUE)

/* Add a float value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_FLOAT(VALUE)  \
    ({									\
      void *addr;							\
									\
      if (offset < 6 * 8)						\
	{								\
	  addr = (void *) &args->reg[8 + 6 * 8 + offset];		\
	  *(tom_double *) addr = (VALUE);				\
	}								\
      else								\
	{								\
	  addr = (void *) ((char *) args->stack + (offset - 6 * 8));	\
	  *(tom_float *) addr = (VALUE);				\
	}								\
      offset += 8;							\
      addr;})

/* Add a double value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_DOUBLE(VALUE)  \
    ({									 \
      tom_double *addr;							 \
									 \
      if (offset < 6 * 8)						 \
	addr = (void *) &args->reg[8 + 6 * 8 + offset];			 \
      else								 \
	addr = (void *) ((char *) args->stack + (offset - 6 * 8));	 \
      *addr = (VALUE);							 \
      offset += 8;							 \
      addr;})

/* Add a selector to the ARGS being built.  */
#define APPLY_ARGS_EMIT_SELECTOR(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a reference to the ARGS being built.  */
#define APPLY_ARGS_EMIT_REFERENCE(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a pointer to the ARGS being built.  */
#define APPLY_ARGS_EMIT_POINTER(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (void *, VALUE)

#define APPLY_ARGS_ACTUAL_SIZE()  \
    (offset > 6 * 8 ? offset - 6 * 8 : 0)

#define APPLY_ARGS_END()  \
    } while (0)
