/* C routines for the C unit.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: glue.c,v 1.13 1998/03/23 17:31:25 tiggr Exp $  */

#include "C-r.h"
#include <trt/trt.h>

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_LIBC_H
#include <libc.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define D_D(NAME) \
tom_double								\
C3 (c_C_Math_d_, NAME, _d) (tom_object self, selector cmd,		\
			    tom_double a)				\
{									\
  return NAME (a);							\
}

#define D_DD(NAME) \
tom_double								\
C3 (c_C_Math_d_, NAME, __dd_) (tom_object self, selector cmd,		\
			      tom_double a, tom_double b)		\
{									\
  return NAME (a, b);							\
}

#define D_ID(NAME) \
tom_double								\
C3 (c_C_Math_d_, NAME, __id_) (tom_object self, selector cmd,		\
			      tom_int a, tom_double b)			\
{									\
  return NAME (a, b);							\
}

#define D_DI(NAME) \
tom_double								\
C3 (c_C_Math_d_, NAME, __di_) (tom_object self, selector cmd,		\
			      tom_double a, tom_int b)			\
{									\
  return NAME (a, b);							\
}

#define I_D(NAME) \
tom_int									\
C3 (c_C_Math_i_, NAME, _d) (tom_object self, selector cmd,		\
			   tom_double a)				\
{									\
  return NAME (a);							\
}

D_DD (hypot)
D_D (lgamma)
D_D (erf)
D_D (erfc)
D_D (j0)
D_D (j1)
D_ID (jn)
D_D (y0)
D_D (y1)
D_ID (yn)
D_D (acos)
D_D (asin)
D_D (atan)
D_DD (atan2)
D_D (cos)
D_D (sin)
D_D (tan)
D_D (cosh)
D_D (sinh)
D_D (tanh)
D_D (exp)
D_DI (ldexp)
D_D (log)
D_D (log10)
D_DD (pow)
D_D (sqrt)
D_D (ceil)
D_D (fabs)
D_D (floor)
D_DD (fmod)

#define I_I(NAME) \
void									\
C3 (c_C_Std_i_, NAME, _i) (tom_object self, selector cmd, int a)	\
{									\
  return NAME (a);							\
}

#define V_I(NAME) \
void									\
C3 (c_C_Std_v_, NAME, _i) (tom_object self, selector cmd, int a)	\
{									\
  NAME (a);								\
}

#define V_V(NAME) \
void							\
C2 (c_C_Std_v_, NAME) (tom_object self, selector cmd)	\
{							\
  NAME ();						\
}

V_V (abort)
V_I (sleep)
