#
# Tcl Library for tkCVS
#
 
# 
# $Id: commit.tcl,v 1.11.2.4 1999/08/24 04:50:04 dorothyr Exp $
#
# Set up a small commit dialog.
#

proc commit_setup {} {
  global cvsglb

  toplevel .commit
  frame .commit.top -border 8
  frame .commit.vers
  frame .commit.comment
  frame .commit.down -relief groove -border 2

  pack .commit.top -side top -fill x
  pack .commit.down -side bottom -fill x
  pack .commit.vers -side top -fill y
  pack .commit.comment -side top -fill both -expand 1

  label .commit.lvers -text "Specify Revision (-r) (usually ignore)" -anchor w
  entry .commit.tvers -relief sunken -textvariable version

  pack .commit.lvers .commit.tvers -in .commit.vers \
    -side left -fill x -pady 3


  label .commit.lcomment -text "Please enter a log" -anchor w
  text .commit.tcomment -relief sunken -width 70 -height 10 \
    -wrap word -border 2 -setgrid yes

  pack .commit.lcomment -in .commit.comment \
    -side left -fill x -pady 3
  pack .commit.tcomment -in .commit.comment \
    -side left -fill both -expand 1 -pady 3

  # Explain what it means to "commit" files
  message .commit.message -justify left -aspect 500 -relief groove \
    -text "This will commit changes from your \
           local, working directory into the repository, recursively.

\
          For any local (sub)directories or files that are on a branch, \
           your changes will be added to the end of that branch.  \
           This includes new or deleted files as well as modifications.

\
          For any local (sub)directories or files that have \
           a non-branch tag, a branch will be created, and \
           your changes will be placed on that branch.  \
           (CVS bug.  Sorry.)

\
          For all other (sub)directories, your changes will be \
           added to the end of the main trunk."

  pack .commit.message -in .commit.top -padx 2 -pady 5


  button .commit.ok -text "OK" \
    -command {
      cvs_commit $version [.commit.tcomment get 1.0 end] $cvsglb(commit_list)
      if {$cvscfg(auto_status) == "true"} {
        setup_dir
      }
      wm withdraw .commit
    }
  # Ugly hack.  Just a copy of above.  Need to work on this.  -JW
  button .commit.apply -text "Apply" \
    -command {
      cvs_commit $version [.commit.tcomment get 1.0 end] $cvsglb(commit_list)
      if {$cvscfg(auto_status) == "true"} {
        setup_dir
      }
    }
  button .commit.clear -text "ClearAll" -command {
    set version ""
    .commit.tcomment delete 1.0 end
    }
  button .commit.quit -text "Quit" -command { wm withdraw .commit }
 
  pack .commit.ok .commit.apply .commit.clear .commit.quit -in .commit.down \
    -side left -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1
 
  wm withdraw .commit
  wm title .commit "Commit Changes to a Module"
  wm minsize .commit 1 1
}

proc commit_run {} {
  global incvs
  global cvsglb

  if {! $incvs} {
    cvsfail "This directory is not in CVS.\nPlease import it first."
    return 1
  }

  # If marked files, commit these.  If no marked files, then
  # commit any files selected via listbox selection mechanism.
  # The cvsglb(commit_list) list remembers the list of files
  # to be committed.
  set cvsglb(commit_list) [workdir_list_files]
  wm deiconify .commit
  raise .commit
}
