class EXAMPLE02
--
-- This example shows how to list the contents of a directory
-- using class BASIC_DIRECTORY.
--

creation make

feature {NONE}

   make is
      do
         if argument_count /= 1 then
            io.put_string("usage : example02 <directory_name>%N");
         else
            list_directory(argument(1));
         end;
      end;

   list_directory(path: STRING) is
      local
         d: BASIC_DIRECTORY;
         i: INTEGER;
      do
         std_output.put_string("Trying to list %"");
         std_output.put_string(path);
         std_output.put_string("%".%N");
         !!d.make;
         if d.set_path(path) then
            std_output.put_integer(d.count);
            std_output.put_string(" item(s) (file or directory) in %"");
            std_output.put_string(d.path);
            std_output.put_string("%".%N");
            from
               i := d.lower;
            until
               i > d.upper
            loop
               std_output.put_character('%T');
               std_output.put_string(d.name(i));
               std_output.put_character('%N');
               i := i + 1;
            end;
         else
            std_output.put_string("Unable to open directory %"");
            std_output.put_string(path);
            std_output.put_string("%".%N");
         end;
      end;

end -- EXAMPLE02
