      SUBROUTINE PZOPTEE( ICTXT, NOUT, SUBPTR, SCODE, SNAME )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER            ICTXT, NOUT, SCODE
*     ..
*     .. Array Arguments ..
      CHARACTER*(*)      SNAME
*     ..
*     .. Subroutine Arguments ..
      EXTERNAL           SUBPTR
*     ..
*
*  Purpose
*  =======
*
*  PZOPTEE tests whether PBLAS respond correctly to a bad option
*  argument.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  SUBPTR  (local input) PBLAS SUBROUTINE
*          SUBPTR must be declared EXTERNAL in the calling subroutine.
*
*  SCODE   (global input) INTEGER
*          The calling sequence code.
*
*  SNAME   (global input) CHARACTER*(*)
*          The subroutine name calling this subprogram.
*
* ======================================================================
*
*  Calling sequence encodings
*  ==========================
*
*  code Formal argument list                                Examples
*
*  11   (n,      v1,v2)                                     _SWAP, _COPY
*  12   (n,s1,   v1   )                                     _SCAL, _SCAL
*  13   (n,s1,   v1,v2)                                     _AXPY, _DOT_
*  14   (n,s1,i1,v1   )                                     _AMAX
*  15   (n,u1,   v1   )                                     _ASUM, _NRM2
*
*  21   (     trans,     m,n,s1,m1,v1,s2,v2)                _GEMV
*  22   (uplo,             n,s1,m1,v1,s2,v2)                _SYMV, _HEMV
*  23   (uplo,trans,diag,  n,   m1,v1      )                _TRMV, _TRSV
*  24   (                m,n,s1,v1,v2,m1)                   _GER_
*  25   (uplo,             n,s1,v1,   m1)                   _SYR
*  26   (uplo,             n,u1,v1,   m1)                   _HER
*  27   (uplo,             n,s1,v1,v2,m1)                   _SYR2, _HER2
*
*  31   (          transa,transb,     m,n,k,s1,m1,m2,s2,m3) _GEMM
*  32   (side,uplo,                   m,n,  s1,m1,m2,s2,m3) _SYMM, _HEMM
*  33   (     uplo,trans,               n,k,s1,m1,   s2,m3) _SYRK
*  34   (     uplo,trans,               n,k,u1,m1,   u2,m3) _HERK
*  35   (     uplo,trans,               n,k,s1,m1,m2,s2,m3) _SYR2K
*  36   (     uplo,trans,               n,k,s1,m1,m2,u2,m3) _HER2K
*  37   (                             m,n,  s1,m1,   s2,m3) _TRAN_
*  38   (side,uplo,transa,       diag,m,n,  s1,m1,m2      ) _TRMM, _TRSM
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      INTEGER             ARGPOS
*     ..
*     .. External Subroutines ..
      EXTERNAL            ZCHKOPT
*     ..
*     .. Executable Statements ..
*
*     Level 2 PBLAS
*
      IF( SCODE.EQ.21 ) THEN
*
*        Check 1st (and only) option
*
         ARGPOS = 1
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
      ELSE IF( SCODE.EQ.22 .OR. SCODE.EQ.25 .OR. SCODE.EQ.26 .OR.
     $         SCODE.EQ.27 ) THEN
*
*        Check 1st (and only) option
*
         ARGPOS = 1
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'U', ARGPOS )
*
      ELSE IF( SCODE.EQ.23 ) THEN
*
*        Check 1st option
*
         ARGPOS = 1
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'U', ARGPOS )
*
*        Check second option
*
         ARGPOS = 2
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*        Check third option
*
         ARGPOS = 3
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'D', ARGPOS )
*
*     Level 3 PBLAS
*
      ELSE IF( SCODE.EQ.31 ) THEN
*
*        Check 1st option
*
         ARGPOS = 1
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*        Check second option
*
         ARGPOS = 2
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'B', ARGPOS )
*
      ELSE IF( SCODE.EQ.32 ) THEN
*
*        Check 1st option
*
         ARGPOS = 1
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'S', ARGPOS )
*
*        Check second option
*
         ARGPOS = 2
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'U', ARGPOS )
*
      ELSE IF( SCODE.EQ.33 .OR. SCODE.EQ.34 .OR. SCODE.EQ.35 .OR.
     $         SCODE.EQ.36 ) THEN
*
*        Check 1st option
*
         ARGPOS = 1
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'U', ARGPOS )
*
*        Check second option
*
         ARGPOS = 2
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
      ELSE IF( SCODE.EQ.38 ) THEN
*
*        Check 1st option
*
         ARGPOS = 1
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'S', ARGPOS )
*
*        Check second option
*
         ARGPOS = 2
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'U', ARGPOS )
*
*        Check third option
*
         ARGPOS = 3
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*        Check 4'th option
*
         ARGPOS = 4
         CALL ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'D', ARGPOS )
*
      END IF
*
      RETURN
*
*     End of PZOPTEE
*
      END
      SUBROUTINE ZCHKOPT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, ARGNAM,
     $                   ARGPOS )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER           ARGNAM
      INTEGER             ARGPOS, ICTXT, NOUT, SCODE
*     ..
*     .. Array Arguments ..
      CHARACTER*(*)       SNAME
*     ..
*     .. Subroutines Arguments ..
      EXTERNAL            SUBPTR
*     ..
*
*  Purpose
*  =======
*
*  ZCHKOPT tests the option ARGNAM in any PBLAS routine.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  SUBPTR  (local input) PBLAS SUBROUTINE
*          SUBPTR must be declared EXTERNAL in the calling subroutine.
*
*  SCODE   (global input) INTEGER
*          The calling sequence code.
*
*  SNAME   (global input) CHARACTER*(*)
*          The subroutine name calling this subprogram.
*
*  ARGNAM  (global input) CHARACTER*(*)
*          The name of the option to be checked. ARGNAM should be
*          'D', 'S', 'TA', 'TB', or 'U',
*
*  ARGPOS  (global input) INTEGER
*          ARGPOS indicates the position of the option ARGNAM to be
*          tested.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      INTEGER            INFOT
*     ..
*     .. External Subroutines ..
      EXTERNAL           ZCALLSUB, PCHKPBE, ZSETPBLAS
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. Scalars in Common ..
      CHARACTER          DIAG, SIDE, TRANSA, TRANSB, UPLO
*     ..
*     .. Common blocks ..
      COMMON /PBLASC/DIAG, SIDE, TRANSA, TRANSB, UPLO
*     ..
*     .. Executable Statements ..
*
*     Reiniatilize the dummy arguments to correct values
*
      CALL ZSETPBLAS( ICTXT )
*
      IF( LSAME( ARGNAM, 'D' ) ) THEN
*
*        Generate bad DIAG option
*
         DIAG = '/'
*
      ELSE IF( LSAME( ARGNAM, 'S' ) ) THEN
*
*        Generate bad SIDE option
*
         SIDE = '/'
*
      ELSE IF( LSAME( ARGNAM, 'A' ) ) THEN
*
*        Generate bad TRANSA option
*
         TRANSA = '/'
*
      ELSE IF( LSAME( ARGNAM, 'B' ) ) THEN
*
*        Generate bad TRANSB option
*
         TRANSB = '/'
*
      ELSE IF( LSAME( ARGNAM, 'U' ) ) THEN
*
*        Generate bad UPLO option
*
         UPLO = '/'
*
      END IF
*
*     Set INFOT to the position of the bad dimension argument
*
      INFOT = ARGPOS
*
*     Call the PBLAS routine
*
      CALL ZCALLSUB( SUBPTR, SCODE )
      CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
      RETURN
*
*     End of ZCHKOPT
*
      END
      SUBROUTINE PZDIMEE( ICTXT, NOUT, SUBPTR, SCODE, SNAME )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER            ICTXT, NOUT, SCODE
*     ..
*     .. Array Arguments ..
      CHARACTER*(*)      SNAME
*     ..
*     .. Subroutine Arguments ..
      EXTERNAL           SUBPTR
*     ..
*
*  Purpose
*  =======
*
*  PZDIMEE tests whether PBLAS respond correctly to a bad dimension
*  argument.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  SUBPTR  (local input) PBLAS SUBROUTINE
*          SUBPTR must be declared EXTERNAL in the calling subroutine.
*
*  SCODE   (global input) INTEGER
*          The calling sequence code.
*
*  SNAME   (global input) CHARACTER*(*)
*          The subroutine name calling this subprogram.
*
* ======================================================================
*
*  Calling sequence encodings
*  ==========================
*
*  code Formal argument list                                Examples
*
*  11   (n,      v1,v2)                                     _SWAP, _COPY
*  12   (n,s1,   v1   )                                     _SCAL, _SCAL
*  13   (n,s1,   v1,v2)                                     _AXPY, _DOT_
*  14   (n,s1,i1,v1   )                                     _AMAX
*  15   (n,u1,   v1   )                                     _ASUM, _NRM2
*
*  21   (     trans,     m,n,s1,m1,v1,s2,v2)                _GEMV
*  22   (uplo,             n,s1,m1,v1,s2,v2)                _SYMV, _HEMV
*  23   (uplo,trans,diag,  n,   m1,v1      )                _TRMV, _TRSV
*  24   (                m,n,s1,v1,v2,m1)                   _GER_
*  25   (uplo,             n,s1,v1,   m1)                   _SYR
*  26   (uplo,             n,u1,v1,   m1)                   _HER
*  27   (uplo,             n,s1,v1,v2,m1)                   _SYR2, _HER2
*
*  31   (          transa,transb,     m,n,k,s1,m1,m2,s2,m3) _GEMM
*  32   (side,uplo,                   m,n,  s1,m1,m2,s2,m3) _SYMM, _HEMM
*  33   (     uplo,trans,               n,k,s1,m1,   s2,m3) _SYRK
*  34   (     uplo,trans,               n,k,u1,m1,   u2,m3) _HERK
*  35   (     uplo,trans,               n,k,s1,m1,m2,s2,m3) _SYR2K
*  36   (     uplo,trans,               n,k,s1,m1,m2,u2,m3) _HER2K
*  37   (                             m,n,  s1,m1,   s2,m3) _TRAN_
*  38   (side,uplo,transa,       diag,m,n,  s1,m1,m2      ) _TRMM, _TRSM
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      INTEGER             ARGPOS
*     ..
*     .. External Subroutines ..
      EXTERNAL            ZCHKDIM
*     ..
*     .. Executable Statements ..
*
*     Level 1 PBLAS
*
      IF( SCODE.EQ.11 .OR. SCODE.EQ.12 .OR. SCODE.EQ.13 .OR.
     $    SCODE.EQ.14 .OR. SCODE.EQ.15 ) THEN
*
*        Check 1st (and only) dimension
*
         ARGPOS = 1
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
*     Level 2 PBLAS
*
      ELSE IF( SCODE.EQ.21 ) THEN
*
*        Check 1st dimension
*
         ARGPOS = 2
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'M', ARGPOS )
*
*        Check second dimension
*
         ARGPOS = 3
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
      ELSE IF( SCODE.EQ.22 .OR. SCODE.EQ.25 .OR. SCODE.EQ.26 .OR.
     $         SCODE.EQ.27 ) THEN
*
*        Check 1st (and only) dimension
*
         ARGPOS = 2
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
      ELSE IF( SCODE.EQ.23 ) THEN
*
*        Check 1st (and only) dimension
*
         ARGPOS = 4
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
      ELSE IF( SCODE.EQ.24 ) THEN
*
*        Check 1st dimension
*
         ARGPOS = 1
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'M', ARGPOS )
*
*        Check second dimension
*
         ARGPOS = 2
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
*     Level 3 PBLAS
*
      ELSE IF( SCODE.EQ.31 ) THEN
*
*        Check 1st dimension
*
         ARGPOS = 3
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'M', ARGPOS )
*
*        Check second dimension
*
         ARGPOS = 4
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
*        Check third dimension
*
         ARGPOS = 5
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'K', ARGPOS )
*
      ELSE IF( SCODE.EQ.32 ) THEN
*
*        Check first dimension
*
         ARGPOS = 3
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'M', ARGPOS )
*
*        Check second dimension
*
         ARGPOS = 4
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
      ELSE IF( SCODE.EQ.33 .OR. SCODE.EQ.34 .OR. SCODE.EQ.35 .OR.
     $         SCODE.EQ.36 ) THEN
*
*        Check first dimension
*
         ARGPOS = 3
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
*        Check second dimension
*
         ARGPOS = 4
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'K', ARGPOS )
*
      ELSE IF( SCODE.EQ.37 ) THEN
*
*        Check first dimension
*
         ARGPOS = 1
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'M', ARGPOS )
*
*        Check second dimension
*
         ARGPOS = 2
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
      ELSE IF( SCODE.EQ.38 ) THEN
*
*        Check first dimension
*
         ARGPOS = 5
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'M', ARGPOS )
*
*        Check second dimension
*
         ARGPOS = 6
         CALL ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'N', ARGPOS )
*
      END IF
*
      RETURN
*
*     End of PZDIMEE
*
      END
      SUBROUTINE ZCHKDIM( ICTXT, NOUT, SUBPTR, SCODE, SNAME, ARGNAM,
     $                   ARGPOS )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER           ARGNAM
      INTEGER             ARGPOS, ICTXT, NOUT, SCODE
*     ..
*     .. Array Arguments ..
      CHARACTER*(*)       SNAME
*     ..
*     .. Subroutines Arguments ..
      EXTERNAL            SUBPTR
*     ..
*
*  Purpose
*  =======
*
*  ZCHKDIM tests the dimension ARGNAM in any PBLAS routine.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  SUBPTR  (local input) PBLAS SUBROUTINE
*          SUBPTR must be declared EXTERNAL in the calling subroutine.
*
*  SCODE   (global input) INTEGER
*          The calling sequence code.
*
*  SNAME   (global input) CHARACTER*(*)
*          The subroutine name calling this subprogram.
*
*  ARGNAM  (global input) CHARACTER
*          The name of the dimension to be checked. ARGNAM should be
*          'M', 'N' or 'K'.
*
*  ARGPOS  (global input) INTEGER
*          ARGPOS indicates the position of the dimension ARGNAM to be
*          tested.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      INTEGER            INFOT
*     ..
*     .. External Subroutines ..
      EXTERNAL           ZCALLSUB, PCHKPBE, ZSETPBLAS
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. Scalars in Common ..
      INTEGER            KDIM, MDIM, NDIM
*     ..
*     .. Common blocks ..
      COMMON /PBLASN/KDIM, MDIM, NDIM
*     ..
*     .. Executable Statements ..
*
*     Reiniatilize the dummy arguments to correct values
*
      CALL ZSETPBLAS( ICTXT )
*
      IF( LSAME( ARGNAM, 'M' ) ) THEN
*
*        Generate bad MDIM
*
         MDIM = -1
*
      ELSE IF( LSAME( ARGNAM, 'N' ) ) THEN
*
*        Generate bad NDIM
*
         NDIM = -1
*
      ELSE
*
*        Generate bad KDIM
*
         KDIM = -1
*
      END IF
*
*     Set INFOT to the position of the bad dimension argument
*
      INFOT = ARGPOS
*
*     Call the PBLAS routine
*
      CALL ZCALLSUB( SUBPTR, SCODE )
      CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
      RETURN
*
*     End of ZCHKDIM
*
      END
      SUBROUTINE PZVECEE( ICTXT, NOUT, SUBPTR, SCODE, SNAME )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER             ICTXT, NOUT, SCODE
*     ..
*     .. Array Arguments ..
      CHARACTER*7         SNAME
*     ..
*     .. Subroutine Arguments ..
      EXTERNAL            SUBPTR
*     ..
*
*  Purpose
*  =======
*
*  PZVECEE tests whether PBLAS respond correctly to a bad vector
*  argument. Each vector <vec> is described by: <vec>, I<vec>, J<vec>,
*  DESC<vec>, INC<vec>. Out of all these, only I<vec>, J<vec>,
*  DESC<vec>, and INC<vec> are testable.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  SUBPTR  (local input) PBLAS SUBROUTINE
*          SUBPTR must be declared EXTERNAL in the calling subroutine.
*
*  SCODE   (global input) INTEGER
*          The calling sequence code.
*
*  SNAME   (global input) CHARACTER*(*)
*          The subroutine name calling this subprogram.
*
* ======================================================================
*
*  Calling sequence encodings
*  ==========================
*
*  code Formal argument list                                Examples
*
*  11   (n,      v1,v2)                                     _SWAP, _COPY
*  12   (n,s1,   v1   )                                     _SCAL, _SCAL
*  13   (n,s1,   v1,v2)                                     _AXPY, _DOT_
*  14   (n,s1,i1,v1   )                                     _AMAX
*  15   (n,u1,   v1   )                                     _ASUM, _NRM2
*
*  21   (     trans,     m,n,s1,m1,v1,s2,v2)                _GEMV
*  22   (uplo,             n,s1,m1,v1,s2,v2)                _SYMV, _HEMV
*  23   (uplo,trans,diag,  n,   m1,v1      )                _TRMV, _TRSV
*  24   (                m,n,s1,v1,v2,m1)                   _GER_
*  25   (uplo,             n,s1,v1,   m1)                   _SYR
*  26   (uplo,             n,u1,v1,   m1)                   _HER
*  27   (uplo,             n,s1,v1,v2,m1)                   _SYR2, _HER2
*
*  31   (          transa,transb,     m,n,k,s1,m1,m2,s2,m3) _GEMM
*  32   (side,uplo,                   m,n,  s1,m1,m2,s2,m3) _SYMM, _HEMM
*  33   (     uplo,trans,               n,k,s1,m1,   s2,m3) _SYRK
*  34   (     uplo,trans,               n,k,u1,m1,   u2,m3) _HERK
*  35   (     uplo,trans,               n,k,s1,m1,m2,s2,m3) _SYR2K
*  36   (     uplo,trans,               n,k,s1,m1,m2,u2,m3) _HER2K
*  37   (                             m,n,  s1,m1,   s2,m3) _TRAN_
*  38   (side,uplo,transa,       diag,m,n,  s1,m1,m2      ) _TRMM, _TRSM
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      INTEGER             ARGPOS
*     ..
*     .. External Subroutines ..
      EXTERNAL            ZCHKMAT
*     ..
*     .. Executable Statements ..
*
*     Level 1 PBLAS
*
      IF( SCODE.EQ.11 ) THEN
*
*        Check first vector
*
         ARGPOS = 2
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
*        Check second vector
*
         ARGPOS = 7
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'Y', ARGPOS )
*
      ELSE IF( SCODE.EQ.12 .OR. SCODE.EQ.15 ) THEN
*
*        Check first (and only) vector
*
         ARGPOS = 3
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
      ELSE IF( SCODE.EQ.13 ) THEN
*
*        Check first vector
*
         ARGPOS = 3
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
*        Check second vector
*
         ARGPOS = 8
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'Y', ARGPOS )
*
      ELSE IF( SCODE.EQ.14 ) THEN
*
*        Check first (and only) vector
*
         ARGPOS = 4
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
*     Level 2 PBLAS
*
      ELSE IF( SCODE.EQ.21 ) THEN
*
*        Check first vector
*
         ARGPOS = 9
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
*        Check second vector
*
         ARGPOS = 15
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'Y', ARGPOS )
*
      ELSE IF( SCODE.EQ.22 ) THEN
*
*        Check first vector
*
         ARGPOS = 8
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
*        Check second vector
*
         ARGPOS = 14
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'Y', ARGPOS )
*
      ELSE IF( SCODE.EQ.23 ) THEN
*
*        Check first (and only) vector
*
         ARGPOS = 9
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
      ELSE IF( SCODE.EQ.24 .OR. SCODE.EQ.27 ) THEN
*
*        Check first vector
*
         ARGPOS = 4
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
*        Check second vector
*
         ARGPOS = 9
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'Y', ARGPOS )
*
      ELSE IF( SCODE.EQ.26 .OR. SCODE.EQ.27 ) THEN
*
*        Check first (and only) vector
*
         ARGPOS = 4
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'X', ARGPOS )
*
      END IF
*
      RETURN
*
*     End of PZVECEE
*
      END
      SUBROUTINE PZMATEE( ICTXT, NOUT, SUBPTR, SCODE, SNAME )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER             ICTXT, NOUT, SCODE
*     ..
*     .. Array Arguments ..
      CHARACTER*7         SNAME
*     ..
*     .. Subroutine Arguments ..
      EXTERNAL            SUBPTR
*     ..
*
*  Purpose
*  =======
*
*  PZMATEE tests whether PBLAS respond correctly to a bad matrix
*  argument. Each matrix <mat> is described by: <mat>, I<mat>, J<mat>,
*  DESC<mat>. Out of all these, only I<mat>, J<mat>, and DESC<mat> are
*  testable.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  SUBPTR  (local input) PBLAS SUBROUTINE
*          SUBPTR must be declared EXTERNAL in the calling subroutine.
*
*  SCODE   (global input) INTEGER
*          The calling sequence code.
*
*  SNAME   (global input) CHARACTER*(*)
*          The subroutine name calling this subprogram.
*
* ======================================================================
*
*  Calling sequence encodings
*  ==========================
*
*  code Formal argument list                                Examples
*
*  11   (n,      v1,v2)                                     _SWAP, _COPY
*  12   (n,s1,   v1   )                                     _SCAL, _SCAL
*  13   (n,s1,   v1,v2)                                     _AXPY, _DOT_
*  14   (n,s1,i1,v1   )                                     _AMAX
*  15   (n,u1,   v1   )                                     _ASUM, _NRM2
*
*  21   (     trans,     m,n,s1,m1,v1,s2,v2)                _GEMV
*  22   (uplo,             n,s1,m1,v1,s2,v2)                _SYMV, _HEMV
*  23   (uplo,trans,diag,  n,   m1,v1      )                _TRMV, _TRSV
*  24   (                m,n,s1,v1,v2,m1)                   _GER_
*  25   (uplo,             n,s1,v1,   m1)                   _SYR
*  26   (uplo,             n,u1,v1,   m1)                   _HER
*  27   (uplo,             n,s1,v1,v2,m1)                   _SYR2, _HER2
*
*  31   (          transa,transb,     m,n,k,s1,m1,m2,s2,m3) _GEMM
*  32   (side,uplo,                   m,n,  s1,m1,m2,s2,m3) _SYMM, _HEMM
*  33   (     uplo,trans,               n,k,s1,m1,   s2,m3) _SYRK
*  34   (     uplo,trans,               n,k,u1,m1,   u2,m3) _HERK
*  35   (     uplo,trans,               n,k,s1,m1,m2,s2,m3) _SYR2K
*  36   (     uplo,trans,               n,k,s1,m1,m2,u2,m3) _HER2K
*  37   (                             m,n,  s1,m1,   s2,m3) _TRAN_
*  38   (side,uplo,transa,       diag,m,n,  s1,m1,m2      ) _TRMM, _TRSM
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      INTEGER             ARGPOS
*     ..
*     .. External Subroutines ..
      EXTERNAL            ZCHKMAT
*     ..
*     .. Executable Statements ..
*
*     Level 2 PBLAS
*
      IF( SCODE.EQ.21 .OR. SCODE.EQ.23 ) THEN
*
*        Check first (and only) matrix
*
         ARGPOS = 5
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
      ELSE IF( SCODE.EQ.22 ) THEN
*
*        Check first (and only) matrix
*
         ARGPOS = 4
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
      ELSE IF( SCODE.EQ.24 .OR. SCODE.EQ.27 ) THEN
*
*        Check first (and only) matrix
*
         ARGPOS = 14
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
      ELSE IF( SCODE.EQ.25 .OR. SCODE.EQ.26 ) THEN
*
*        Check first (and only) matrix
*
         ARGPOS = 9
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*     Level 3 PBLAS
*
      ELSE IF( SCODE.EQ.31 ) THEN
*
*        Check first matrix
*
         ARGPOS = 7
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*        Check second matrix
*
         ARGPOS = 11
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'B', ARGPOS )
*
*        Check 3'nd matrix
*
         ARGPOS = 16
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'C', ARGPOS )
*
      ELSE IF( SCODE.EQ.32 .OR. SCODE.EQ.35 .OR. SCODE.EQ.36 ) THEN
*
*        Check first matrix
*
         ARGPOS = 6
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*        Check second matrix
*
         ARGPOS = 10
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'B', ARGPOS )
*
*        Check 3'nd matrix
*
         ARGPOS = 15
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'C', ARGPOS )
*
      ELSE IF( SCODE.EQ.33 .OR. SCODE.EQ.34 ) THEN
*
*        Check first matrix
*
         ARGPOS = 6
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*        Check second matrix
*
         ARGPOS = 11
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'C', ARGPOS )
*
      ELSE IF( SCODE.EQ.37 ) THEN
*
*        Check first matrix
*
         ARGPOS = 4
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*        Check second matrix
*
         ARGPOS = 9
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'C', ARGPOS )
*
      ELSE IF( SCODE.EQ.38 ) THEN
*
*        Check first matrix
*
         ARGPOS = 8
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'A', ARGPOS )
*
*        Check second matrix
*
         ARGPOS = 12
         CALL ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, 'B', ARGPOS )
*
      END IF
*
      RETURN
*
*     End of PZMATEE
*
      END
      SUBROUTINE ZSETPBLAS( ICTXT )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER            ICTXT
*     ..
*
*  Purpose
*  =======
*
*  ZSETPBLAS initializes *all* the dummy arguments to correct values.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   RONE
      COMPLEX*16         ONE
      PARAMETER          ( ONE = ( 1.0D+0, 0.0D+0 ), RONE = 1.0D+0 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           DESCSET
*     ..
*     .. Scalars in Common ..
      CHARACTER          DIAG, SIDE, TRANSA, TRANSB, UPLO
      INTEGER            IA, IB, IC, INCX, INCY, ISCLR, IX, IY, JA, JB,
     $                   JC, JX, JY, KDIM, MDIM, NDIM
      DOUBLE PRECISION   USCLR
      COMPLEX*16         SCLR
*     ..
*     .. Arrays in Common ..
      INTEGER            DESCA( DLEN_ ), DESCB( DLEN_ ), DESCC( DLEN_ ),
     $                   DESCX( DLEN_ ), DESCY( DLEN_ )
      COMPLEX*16         A( 2, 2 ), B( 2, 2 ), C( 2, 2 ), X( 2 ), Y( 2 )
*     ..
*     .. Common blocks ..
      COMMON /PBLASC/DIAG, SIDE, TRANSA, TRANSB, UPLO
      COMMON /PBLASD/DESCA, DESCB, DESCC, DESCX, DESCY
      COMMON /PBLASI/IA, IB, IC, INCX, INCY, ISCLR, IX, IY, JA, JB, JC,
     $               JX, JY
      COMMON /PBLASM/A, B, C
      COMMON /PBLASN/KDIM, MDIM, NDIM
      COMMON /PBLASS/SCLR, USCLR
      COMMON /PBLASV/X, Y
*     ..
*     .. Executable Statements ..
*
*     Set default values for options
*
      DIAG = 'N'
      SIDE = 'L'
      TRANSA = 'N'
      TRANSB = 'N'
      UPLO = 'U'
*
*     Set default values for scalars
*
      KDIM = 1
      MDIM = 1
      NDIM = 1
      ISCLR = 1
      SCLR = ONE
      USCLR = RONE
*
*     Set default values for distributed matrix A
*
      A( 1, 1 ) = ONE
      A( 2, 1 ) = ONE
      A( 1, 2 ) = ONE
      A( 2, 2 ) = ONE
      IA = 1
      JA = 1
      CALL DESCSET( DESCA, 2, 2, 1, 1, 0, 0, ICTXT, 2 )
*
*     Set default values for distributed matrix B
*
      B( 1, 1 ) = ONE
      B( 2, 1 ) = ONE
      B( 1, 2 ) = ONE
      B( 2, 2 ) = ONE
      IB = 1
      JB = 1
      CALL DESCSET( DESCB, 2, 2, 1, 1, 0, 0, ICTXT, 2 )
*
*     Set default values for distributed matrix C
*
      C( 1, 1 ) = ONE
      C( 2, 1 ) = ONE
      C( 1, 2 ) = ONE
      C( 2, 2 ) = ONE
      IC = 1
      JC = 1
      CALL DESCSET( DESCC, 2, 2, 1, 1, 0, 0, ICTXT, 2 )
*
*     Set default values for distributed matrix X
*
      X( 1 ) = ONE
      X( 2 ) = ONE
      IX = 1
      JX = 1
      CALL DESCSET( DESCX, 2, 1, 1, 1, 0, 0, ICTXT, 2 )
      INCX = 1
*
*     Set default values for distributed matrix Y
*
      Y( 1 ) = ONE
      Y( 2 ) = ONE
      IY = 1
      JY = 1
      CALL DESCSET( DESCY, 2, 1, 1, 1, 0, 0, ICTXT, 2 )
      INCY = 1
*
      RETURN
*
*     End of ZSETPBLAS
*
      END
      SUBROUTINE ZCHKMAT( ICTXT, NOUT, SUBPTR, SCODE, SNAME, ARGNAM,
     $                    ARGPOS )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER           ARGNAM
      INTEGER             ARGPOS, ICTXT, NOUT, SCODE
*     ..
*     .. Array Arguments ..
      CHARACTER*(*)       SNAME
*     ..
*     .. Subroutines Arguments ..
      EXTERNAL            SUBPTR
*     ..
*
*  Purpose
*  =======
*
*  ZCHKMAT tests the matrix (or vector) ARGNAM in any PBLAS routine.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  SUBPTR  (local input) PBLAS SUBROUTINE
*          SUBPTR must be declared EXTERNAL in the calling subroutine.
*
*  SCODE   (global input) INTEGER
*          The calling sequence code.
*
*  SNAME   (global input) CHARACTER*(*)
*          The subroutine name calling this subprogram.
*
*  ARGNAM  (global input) CHARACTER
*          The name of the matrix (or vector) to be checked. ARGNAM
*          should be 'A', 'B' or 'C' when one wants to check a matrix,
*          and 'X' or 'Y' for a vector.
*
*  ARGPOS  (global input) INTEGER
*          ARGPOS indicates the position of the first argument of the
*          matrix (or vector) ARGNAM.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      INTEGER             DESCMULT
      PARAMETER           ( DESCMULT = 100 )
*     ..
*     .. Local Scalars ..
      INTEGER             I, INFOT, NPROW, NPCOL, MYROW, MYCOL
*     ..
*     .. External Subroutines ..
      EXTERNAL            BLACS_GRIDINFO, ZCALLSUB, PCHKPBE, ZSETPBLAS
*     ..
*     .. External Functions ..
      LOGICAL             LSAME
      EXTERNAL            LSAME
*     ..
*     .. Scalars in Common ..
      INTEGER            IA, IB, IC, INCX, INCY, ISCLR, IX, IY, JA, JB,
     $                   JC, JX, JY
*     ..
*     .. Arrays in Common ..
      INTEGER            DESCA( DLEN_ ), DESCB( DLEN_ ),
     $                   DESCC( DLEN_ ), DESCX( DLEN_ ), DESCY( DLEN_ )
*     ..
*     .. Common blocks ..
      COMMON /PBLASD/DESCA, DESCB, DESCC, DESCX, DESCY
      COMMON /PBLASI/IA, IB, IC, INCX, INCY, ISCLR, IX, IY, JA, JB, JC,
     $               JX, JY
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      IF( LSAME( ARGNAM, 'A' ) ) THEN
*
*        Check IA. Set all other OK, bad IA
*
         CALL ZSETPBLAS( ICTXT )
         IA    = -1
         INFOT = ARGPOS + 1
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check JA. Set all other OK, bad JA
*
         CALL ZSETPBLAS( ICTXT )
         JA    = -1
         INFOT = ARGPOS + 2
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check DESCA. Set all other OK, bad DESCA
*
         DO 10 I = 1, DLEN_
*
*           Set I'th entry of DESCA to incorrect value, rest ok.
*
            CALL ZSETPBLAS( ICTXT )
            DESCA( I ) =  -1
            INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
            CALL ZCALLSUB( SUBPTR, SCODE )
            CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*           Extra tests for RSRCA, CSRCA, LDA
*
            IF( ( I.EQ.RSRC_ ) .OR. ( I.EQ.CSRC_ ) .OR.
     $          ( I.EQ.LLD_ ) ) THEN
*
               CALL ZSETPBLAS( ICTXT )
*
*              Test RSRCA >= NPROW
*
               IF( I.EQ.RSRC_ )
     $            DESCA( I ) =  NPROW
*
*              Test CSRCA >= NPCOL
*
               IF( I.EQ.CSRC_ )
     $            DESCA( I ) =  NPCOL
*
*              Test LDA >= MAX(1, NUMROC(...)). Set to 1 as mat 2x2.
*
               IF( I.EQ.LLD_ ) THEN
                  IF( MYROW.EQ.0 .AND.MYCOL.EQ.0 ) THEN
                     DESCA( I ) = 1
                  ELSE
                     DESCA( I ) = 0
                  END IF
               END IF
*
               INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
               CALL ZCALLSUB( SUBPTR, SCODE )
               CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
            END IF
*
   10    CONTINUE
*
      ELSE IF( LSAME( ARGNAM, 'B' ) ) THEN
*
*        Check IB. Set all other OK, bad IB
*
         CALL ZSETPBLAS( ICTXT )
         IB    = -1
         INFOT = ARGPOS + 1
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check JB. Set all other OK, bad JB
*
         CALL ZSETPBLAS( ICTXT )
         JB    = -1
         INFOT = ARGPOS + 2
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check DESCB. Set all other OK, bad DESCB
*
         DO 20 I = 1, DLEN_
*
*           Set I'th entry of DESCB to incorrect value, rest ok.
*
            CALL ZSETPBLAS( ICTXT )
            DESCB( I ) =  -1
            INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
            CALL ZCALLSUB( SUBPTR, SCODE )
            CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*           Extra tests for RSRCB, CSRCB, LDB
*
            IF( ( I.EQ.RSRC_ ) .OR. ( I.EQ.CSRC_ ) .OR.
     $          ( I.EQ.LLD_ ) ) THEN
*
               CALL ZSETPBLAS( ICTXT )
*
*              Test RSRCB >= NPROW
*
               IF( I.EQ.RSRC_ )
     $            DESCB( I ) =  NPROW
*
*              Test CSRCB >= NPCOL
*
               IF( I.EQ.CSRC_ )
     $            DESCB( I ) =  NPCOL
*
*              Test LDB >= MAX(1, NUMROC(...)). Set to 1 as mat 2x2.
*
               IF( I.EQ.LLD_ ) THEN
                  IF( MYROW.EQ.0 .AND.MYCOL.EQ.0 ) THEN
                     DESCB( I ) = 1
                  ELSE
                     DESCB( I ) = 0
                  END IF
               END IF
*
               INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
               CALL ZCALLSUB( SUBPTR, SCODE )
               CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
            END IF
*
   20    CONTINUE
*
      ELSE IF( LSAME( ARGNAM, 'C' ) ) THEN
*
*        Check IC. Set all other OK, bad IC
*
         CALL ZSETPBLAS( ICTXT )
         IC    = -1
         INFOT = ARGPOS + 1
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check JC. Set all other OK, bad JC
*
         CALL ZSETPBLAS( ICTXT )
         JC    = -1
         INFOT = ARGPOS + 2
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check DESCC. Set all other OK, bad DESCC
*
         DO 30 I = 1, DLEN_
*
*           Set I'th entry of DESCC to incorrect value, rest ok.
*
            CALL ZSETPBLAS( ICTXT )
            DESCC( I ) =  -1
            INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
            CALL ZCALLSUB( SUBPTR, SCODE )
            CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*           Extra tests for RSRCC, CSRCC, LDC
*
            IF( ( I.EQ.RSRC_ ) .OR. ( I.EQ.CSRC_ ) .OR.
     $          ( I.EQ.LLD_ ) ) THEN
*
               CALL ZSETPBLAS( ICTXT )
*
*              Test RSRCC >= NPROW
*
               IF( I.EQ.RSRC_ )
     $            DESCC( I ) =  NPROW
*
*              Test CSRCC >= NPCOL
*
               IF( I.EQ.CSRC_ )
     $            DESCC( I ) =  NPCOL
*
*              Test LDC >= MAX(1, NUMROC(...)). Set to 1 as mat 2x2.
*
               IF( I.EQ.LLD_ ) THEN
                  IF( MYROW.EQ.0 .AND.MYCOL.EQ.0 ) THEN
                     DESCC( I ) = 1
                  ELSE
                     DESCC( I ) = 0
                  END IF
               END IF
*
               INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
               CALL ZCALLSUB( SUBPTR, SCODE )
               CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
            END IF
*
   30    CONTINUE
*
      ELSE IF( LSAME( ARGNAM, 'X' ) ) THEN
*
*        Check IX. Set all other OK, bad IX
*
         CALL ZSETPBLAS( ICTXT )
         IX    = -1
         INFOT = ARGPOS + 1
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check JX. Set all other OK, bad JX
*
         CALL ZSETPBLAS( ICTXT )
         JX    = -1
         INFOT = ARGPOS + 2
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check DESCX. Set all other OK, bad DESCX
*
         DO 40 I = 1, DLEN_
*
*           Set I'th entry of DESCX to incorrect value, rest ok.
*
            CALL ZSETPBLAS( ICTXT )
            DESCX( I ) =  -1
            INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
            CALL ZCALLSUB( SUBPTR, SCODE )
            CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*           Extra tests for RSRCX, CSRCX, LDX
*
            IF( ( I.EQ.RSRC_ ) .OR. ( I.EQ.CSRC_ ) .OR.
     $          ( I.EQ.LLD_ ) ) THEN
*
               CALL ZSETPBLAS( ICTXT )
*
*              Test RSRCX >= NPROW
*
               IF( I.EQ.RSRC_ )
     $            DESCX( I ) =  NPROW
*
*              Test CSRCX >= NPCOL
*
               IF( I.EQ.CSRC_ )
     $            DESCX( I ) =  NPCOL
*
*              Test LDX >= MAX(1, NUMROC(...)). Set to 1 as mat 2x2.
*
               IF( I.EQ.LLD_ ) THEN
                  IF( MYROW.EQ.0 .AND.MYCOL.EQ.0 ) THEN
                     DESCX( I ) = 1
                  ELSE
                     DESCX( I ) = 0
                  END IF
               END IF
*
               INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
               CALL ZCALLSUB( SUBPTR, SCODE )
               CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
            END IF
*
   40    CONTINUE
*
*        Check INCX. Set all other OK, bad INCX
*
         CALL ZSETPBLAS( ICTXT )
         INCX  =  -1
         INFOT = ARGPOS + 4
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
      ELSE
*
*        Check IY. Set all other OK, bad IY
*
         CALL ZSETPBLAS( ICTXT )
         IY    = -1
         INFOT = ARGPOS + 1
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check JY. Set all other OK, bad JY
*
         CALL ZSETPBLAS( ICTXT )
         JY    = -1
         INFOT = ARGPOS + 2
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*        Check DESCY. Set all other OK, bad DESCY
*
         DO 50 I = 1, DLEN_
*
*           Set I'th entry of DESCY to incorrect value, rest ok.
*
            CALL ZSETPBLAS( ICTXT )
            DESCY( I ) =  -1
            INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
            CALL ZCALLSUB( SUBPTR, SCODE )
            CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
*           Extra tests for RSRCY, CSRCY, LDY
*
            IF( ( I.EQ.RSRC_ ) .OR. ( I.EQ.CSRC_ ) .OR.
     $          ( I.EQ.LLD_ ) ) THEN
*
               CALL ZSETPBLAS( ICTXT )
*
*              Test RSRCY >= NPROW
*
               IF( I.EQ.RSRC_ )
     $            DESCY( I ) = NPROW
*
*              Test CSRCY >= NPCOL
*
               IF( I.EQ.CSRC_ )
     $            DESCY( I ) = NPCOL
*
*              Test LDY >= MAX(1, NUMROC(...)). Set to 1 as mat 2x2.
*
               IF( I.EQ.LLD_ ) THEN
                  IF( MYROW.EQ.0 .AND.MYCOL.EQ.0 ) THEN
                     DESCY( I ) = 1
                  ELSE
                     DESCY( I ) = 0
                  END IF
               END IF
*
               INFOT = ( ( ARGPOS + 3 ) * DESCMULT ) + I
               CALL ZCALLSUB( SUBPTR, SCODE )
               CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
            END IF
*
   50    CONTINUE
*
*        Check INCY. Set all other OK, bad INCY
*
         CALL ZSETPBLAS( ICTXT )
         INCY =  -1
         INFOT = ARGPOS + 4
         CALL ZCALLSUB( SUBPTR, SCODE )
         CALL PCHKPBE( ICTXT, NOUT, SNAME, INFOT )
*
      END IF
*
      RETURN
*
*     End of ZCHKMAT
*
      END
      SUBROUTINE ZCALLSUB( SUBPTR, SCODE )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER             SCODE
*     ..
*     .. Subroutine Arguments ..
      EXTERNAL            SUBPTR
*     ..
*
*  Purpose
*  =======
*
*  ZCALLSUB calls the subroutine SUBPTR with the calling sequence
*  identified by SCODE.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  SUBPTR  (local input) PBLAS SUBROUTINE
*          SUBPTR must be declared EXTERNAL in the calling subroutine.
*
*  SCODE   (global input) INTEGER
*          The calling sequence code.
*
* ======================================================================
*
*  Calling sequence encodings
*  ==========================
*
*  code Formal argument list                                Examples
*
*  11   (n,      v1,v2)                                     _SWAP, _COPY
*  12   (n,s1,   v1   )                                     _SCAL, _SCAL
*  13   (n,s1,   v1,v2)                                     _AXPY, _DOT_
*  14   (n,s1,i1,v1   )                                     _AMAX
*  15   (n,u1,   v1   )                                     _ASUM, _NRM2
*
*  21   (     trans,     m,n,s1,m1,v1,s2,v2)                _GEMV
*  22   (uplo,             n,s1,m1,v1,s2,v2)                _SYMV, _HEMV
*  23   (uplo,trans,diag,  n,   m1,v1      )                _TRMV, _TRSV
*  24   (                m,n,s1,v1,v2,m1)                   _GER_
*  25   (uplo,             n,s1,v1,   m1)                   _SYR
*  26   (uplo,             n,u1,v1,   m1)                   _HER
*  27   (uplo,             n,s1,v1,v2,m1)                   _SYR2, _HER2
*
*  31   (          transa,transb,     m,n,k,s1,m1,m2,s2,m3) _GEMM
*  32   (side,uplo,                   m,n,  s1,m1,m2,s2,m3) _SYMM, _HEMM
*  33   (     uplo,trans,               n,k,s1,m1,   s2,m3) _SYRK
*  34   (     uplo,trans,               n,k,u1,m1,   u2,m3) _HERK
*  35   (     uplo,trans,               n,k,s1,m1,m2,s2,m3) _SYR2K
*  36   (     uplo,trans,               n,k,s1,m1,m2,u2,m3) _HER2K
*  37   (                             m,n,  s1,m1,   s2,m3) _TRAN_
*  38   (side,uplo,transa,       diag,m,n,  s1,m1,m2      ) _TRMM, _TRSM
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Scalars in Common ..
      CHARACTER          DIAG, SIDE, TRANSA, TRANSB, UPLO
      INTEGER            IA, IB, IC, INCX, INCY, ISCLR, IX, IY, JA, JB,
     $                   JC, JX, JY, KDIM, MDIM, NDIM
      DOUBLE PRECISION   USCLR
      COMPLEX*16         SCLR
*     ..
*     .. Arrays in Common ..
      INTEGER            DESCA( DLEN_ ), DESCB( DLEN_ ),
     $                   DESCC( DLEN_ ), DESCX( DLEN_ ), DESCY( DLEN_ )
      COMPLEX*16         A( 2, 2 ), B( 2, 2 ), C( 2, 2 ), X( 2 ), Y( 2 )
*     ..
*     .. Common blocks ..
      COMMON /PBLASC/DIAG, SIDE, TRANSA, TRANSB, UPLO
      COMMON /PBLASD/DESCA, DESCB, DESCC, DESCX, DESCY
      COMMON /PBLASI/IA, IB, IC, INCX, INCY, ISCLR, IX, IY, JA, JB, JC,
     $               JX, JY
      COMMON /PBLASM/A, B, C
      COMMON /PBLASN/KDIM, MDIM, NDIM
      COMMON /PBLASS/SCLR, USCLR
      COMMON /PBLASV/X, Y
*     ..
*     .. Executable Statements ..
*
*     Level 1 PBLAS
*
      IF( SCODE.EQ.11 ) THEN
*
         CALL SUBPTR( NDIM, X, IX, JX, DESCX, INCX, Y, IY, JY, DESCY,
     $                INCY )
*
      ELSE IF( SCODE.EQ.12 ) THEN
*
         CALL SUBPTR( NDIM, SCLR, X, IX, JX, DESCX, INCX )
*
      ELSE IF( SCODE.EQ.13 ) THEN
*
         CALL SUBPTR( NDIM, SCLR, X, IX, JX, DESCX, INCX, Y, IY, JY,
     $                DESCY, INCY )
*
      ELSE IF( SCODE.EQ.14 ) THEN
*
         CALL SUBPTR( NDIM, SCLR, ISCLR, X, IX, JX, DESCX, INCX )
*
      ELSE IF( SCODE.EQ.15 ) THEN
*
         CALL SUBPTR( NDIM, USCLR, X, IX, JX, DESCX, INCX )
*
*     Level 2 PBLAS
*
      ELSE IF( SCODE.EQ.21 ) THEN
*
         CALL SUBPTR( TRANSA, MDIM, NDIM, SCLR, A, IA, JA, DESCA, X, IX,
     $                JX, DESCX, INCX, SCLR, Y, IY, JY, DESCY, INCY )
*
      ELSE IF( SCODE.EQ.22 ) THEN
*
         CALL SUBPTR( UPLO, NDIM, SCLR, A, IA, JA, DESCA, X, IX, JX,
     $                DESCX, INCX, SCLR, Y, IY, JY, DESCY, INCY )
*
      ELSE IF( SCODE.EQ.23 ) THEN
*
         CALL SUBPTR( UPLO, TRANSA, DIAG, NDIM, A, IA, JA, DESCA, X, IX,
     $                JX, DESCX, INCX )
*
      ELSE IF( SCODE.EQ.24 ) THEN
*
         CALL SUBPTR( MDIM, NDIM, SCLR, X, IX, JX, DESCX, INCX, Y, IY,
     $                JY, DESCY, INCY, A, IA, JA, DESCA )
*
      ELSE IF( SCODE.EQ.25 ) THEN
*
         CALL SUBPTR( UPLO, NDIM, SCLR, X, IX, JX, DESCX, INCX, A, IA,
     $                JA, DESCA )
*
      ELSE IF( SCODE.EQ.26 ) THEN
*
         CALL SUBPTR( UPLO, NDIM, USCLR, X, IX, JX, DESCX, INCX, A, IA,
     $                JA, DESCA )
*
      ELSE IF( SCODE.EQ.27 ) THEN
*
         CALL SUBPTR( UPLO, NDIM, SCLR, X, IX, JX, DESCX, INCX, Y, IY,
     $                JY, DESCY, INCY, A, IA, JA, DESCA )
*
*     Level 3 PBLAS
*
      ELSE IF( SCODE.EQ.31 ) THEN
*
         CALL SUBPTR( TRANSA, TRANSB, MDIM, NDIM, KDIM, SCLR, A, IA, JA,
     $                DESCA, B, IB, JB, DESCB, SCLR, C, IC, JC, DESCC )
*
      ELSE IF( SCODE.EQ.32 ) THEN
*
         CALL SUBPTR( SIDE, UPLO, MDIM, NDIM, SCLR, A, IA, JA, DESCA, B,
     $                IB, JB, DESCB, SCLR, C, IC, JC, DESCC )
*
      ELSE IF( SCODE.EQ.33 ) THEN
*
         CALL SUBPTR( UPLO, TRANSA, NDIM, KDIM, SCLR, A, IA, JA, DESCA,
     $                SCLR, C, IC, JC, DESCC )
*
      ELSE IF( SCODE.EQ.34 ) THEN
*
         CALL SUBPTR( UPLO, TRANSA, NDIM, KDIM, USCLR, A, IA, JA, DESCA,
     $                USCLR, C, IC, JC, DESCC )
*
      ELSE IF( SCODE.EQ.35 ) THEN
*
         CALL SUBPTR( UPLO, TRANSA, NDIM, KDIM, SCLR, A, IA, JA, DESCA,
     $                B, IB, JB, DESCB, SCLR, C, IC, JC, DESCC )
*
      ELSE IF( SCODE.EQ.36 ) THEN
*
         CALL SUBPTR( UPLO, TRANSA, NDIM, KDIM, SCLR, A, IA, JA, DESCA,
     $                B, IB, JB, DESCB, USCLR, C, IC, JC, DESCC )
*
      ELSE IF( SCODE.EQ.37 ) THEN
*
         CALL SUBPTR( MDIM, NDIM, SCLR, A, IA, JA, DESCA, SCLR, C, IC,
     $                JC, DESCC )
*
      ELSE IF( SCODE.EQ.38 ) THEN
*
         CALL SUBPTR( SIDE, UPLO, TRANSA, DIAG, MDIM, NDIM, SCLR, A, IA,
     $                JA, DESCA, B, IB, JB, DESCB )
*
      END IF
*
      RETURN
*
*     End of ZCALLSUB
*
      END
      SUBROUTINE ZERRSET( ERR, ERRMAX, XTRUE, X )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar arguments ..
      DOUBLE PRECISION   ERR, ERRMAX
      COMPLEX*16         X, XTRUE
*     ..
*
*  Purpose
*  =======
*
*  ZERRSET computes the absolute difference ERR = |XTRUE - X| and
*  compares it with zero. ERRMAX accumulates the absolute error
*  difference.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ERR     (local output) DOUBLE PRECISION
*          The absolute difference |XTRUE - X|.
*
*  ERRMAX  (local input/local output) DOUBLE PRECISION
*          The accumulated error ERRMAX = MAX( ERRMAX, ERR ).
*
*  XTRUE   (local input) COMPLEX*16
*          The true value.
*
*  X       (local input) COMPLEX*16
*          The value to be compared to XTRUE.
*
*  =====================================================================
*
*     .. External Functions ..
      DOUBLE PRECISION   DDIFF
      EXTERNAL           DDIFF
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DIMAG, MAX
*     ..
*     .. Executable Statements ..
*
      ERR = ABS( DDIFF( DBLE( XTRUE ), DBLE( X ) ) )
      ERR = MAX( ERR, ABS( DDIFF( DIMAG( XTRUE ), DIMAG( X ) ) ) )
*
      ERRMAX = MAX( ERRMAX, ERR )
*
      RETURN
*
*     End of ZERRSET
*
      END
      SUBROUTINE PZCHKVIN( ERRMAX, N, X, PX, IX, JX, DESCX, INCX, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar arguments ..
      INTEGER            INCX, INFO, IX, JX, N
      DOUBLE PRECISION   ERRMAX
*     ..
*     .. Array arguments ..
      INTEGER            DESCX( * )
      COMPLEX*16         PX( * ), X( * )
*     ..
*
*  Purpose
*  =======
*
*  PZCHKVIN checks that the distributed matrix sub( PX ) remained
*  unchanged. The local array entries are compared element by element,
*  and their difference is tested against 0.0 as well as the epsilon
*  machine. Notice that this difference should be numerically exactly
*  the zero machine, but because of the possible movement of some of
*  the data we flagged differently a difference less than twice the
*  epsilon machine. The largest error is also returned.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ERRMAX  (global output) DOUBLE PRECISION
*          The largest absolute element-wise difference between sub( X )
*          and sub( PX ).
*
*  N       (global input) INTEGER
*          The length of the vector operand sub( X ). N >= 0.
*
*  X       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( M_ ),*). This array contains
*          a local copy of the entire distributed matrix PX to be
*          checked.
*
*  PX      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PX.
*
*  IX      (global input) INTEGER
*          The row index in the global array X indicating the first
*          row of sub( X ).
*
*  JX      (global input) INTEGER
*          The column index in the global array X indicating the
*          first column of sub( X ).
*
*  DESCX   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix X.
*
*  INCX    (global input) INTEGER
*          The global increment for the elements of X. Only two values
*          of INCX are supported in this version, namely 1 and M_X.
*          INCX must not be zero.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO = 0, no error has been found.
*          If INFO > 0, the maximum abolute error found is in (0,eps].
*          If INFO < 0, the maximum abolute error found is in (eps,+oo).
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IB, ICTXT, ICURCOL, ICURROW, IIX, IN, IXCOL,
     $                   IXROW, J, JB, JJX, JN, KK, LDX, LDPX, LL,
     $                   MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   ERR, EPS
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, ZERRSET, DGAMX2D
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, NUMROC
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ICEIL, NUMROC, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DIMAG, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
      ICTXT = DESCX( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      INFO = 0
      ERRMAX = ZERO
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      CALL INFOG2L( IX, JX, DESCX, NPROW, NPCOL, MYROW, MYCOL, IIX, JJX,
     $              IXROW, IXCOL )
*
      IF( N.EQ.0 )
     $   RETURN
*
      LDX = DESCX( M_ )
      LDPX = DESCX( LLD_ )
*
      IF( N.EQ.1 ) THEN
*
         IF( MYROW.EQ.IXROW .AND. MYCOL.EQ.IXCOL )
     $      CALL ZERRSET( ERR, ERRMAX, X( IX+(JX-1)*LDX ),
     $                    PX( IIX+(JJX-1)*LDPX ) )
*
      ELSE IF( INCX.EQ.DESCX( M_ ) ) THEN
*
*        sub( X ) is a row vector
*
         JN = MIN( ICEIL( JX, DESCX( NB_ ) ) * DESCX( NB_ ), JX+N-1 )
*
         IF( MYROW.EQ.IXROW ) THEN
*
            ICURCOL = IXCOL
            IF( MYCOL.EQ.ICURCOL ) THEN
               DO 10 J = JX, JN
                  CALL ZERRSET( ERR, ERRMAX, X( IX+(J-1)*LDX ),
     $                          PX( IIX+(JJX-1)*LDPX ) )
                  JJX = JJX + 1
   10          CONTINUE
            END IF
            ICURCOL = MOD( ICURCOL+1, NPCOL )
*
            DO 30 J = JN+1, JX+N-1, DESCX( NB_ )
               JB = MIN( JX+N-J, DESCX( NB_ ) )
*
               IF( MYCOL.EQ.ICURCOL ) THEN
*
                  DO 20 KK = 0, JB-1
                     CALL ZERRSET( ERR, ERRMAX, X( IX+(J+KK-1)*LDX ),
     $                             PX( IIX+(JJX+KK-1)*LDPX ) )
   20             CONTINUE
*
                  JJX = JJX + JB
*
               END IF
*
               ICURCOL = MOD( ICURCOL+1, NPCOL )
*
   30       CONTINUE
*
         END IF
*
      ELSE
*
*        sub( X ) is a column vector
*
         IN = MIN( ICEIL( IX, DESCX( MB_ ) ) * DESCX( MB_ ), IX+N-1 )
*
         IF( MYCOL.EQ.IXCOL ) THEN
*
            ICURROW = IXROW
            IF( MYROW.EQ.ICURROW ) THEN
               DO 40 I = IX, IN
                  CALL ZERRSET( ERR, ERRMAX, X( I+(JX-1)*LDX ),
     $                          PX( IIX+(JJX-1)*LDPX ) )
                  IIX = IIX + 1
   40          CONTINUE
            END IF
            ICURROW = MOD( ICURROW+1, NPROW )
*
            DO 60 I = IN+1, IX+N-1, DESCX( MB_ )
               IB = MIN( IX+N-I, DESCX( MB_ ) )
*
               IF( MYROW.EQ.ICURROW ) THEN
*
                  DO 50 KK = 0, IB-1
                     CALL ZERRSET( ERR, ERRMAX, X( I+KK+(JX-1)*LDX ),
     $                             PX( IIX+KK+(JJX-1)*LDPX ) )
   50             CONTINUE
*
                  IIX = IIX + IB
*
               END IF
*
               ICURROW = MOD( ICURROW+1, NPROW )
*
   60       CONTINUE
*
         END IF
*
      END IF
*
      CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERRMAX, 1, KK, LL, -1,
     $              -1, -1 )
*
      IF( ERRMAX.GT.ZERO .AND. ERRMAX.LE.EPS ) THEN
         INFO = 1
      ELSE IF( ERRMAX.GT.EPS ) THEN
         INFO = -1
      END IF
*
      RETURN
*
*     End of PZCHKVIN
*
      END
      SUBROUTINE PZCHKVOUT( N, X, PX, IX, JX, DESCX, INCX, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar arguments ..
      INTEGER            INCX, INFO, IX, JX, N
*     ..
*     .. Array arguments ..
      INTEGER            DESCX( * )
      COMPLEX*16         PX( * ), X( * )
*     ..
*
*  Purpose
*  =======
*
*  PZCHKVOUT checks that the distributed matrix PX \ sub( PX )
*  remained unchanged. The local array entries are compared element by
*  element, and their difference is tested against 0.0 as well as the
*  epsilon machine. Notice that this difference should be numerically
*  exactly the zero machine, but because of the possible movement of
*  some of the data we flagged differently a difference less than
*  twice the epsilon machine. The largest error is reported.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  N       (global input) INTEGER
*          The length of the vector operand sub( X ). N >= 0.
*
*  X       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( M_ ),*). This array contains
*          a local copy of the entire distributed matrix PX to be
*          checked.
*
*  PX      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PX.
*
*  IX      (global input) INTEGER
*          The row index in the global array X indicating the first
*          row of sub( X ).
*
*  JX      (global input) INTEGER
*          The column index in the global array X indicating the
*          first column of sub( X ).
*
*  DESCX   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix X.
*
*  INCX    (global input) INTEGER
*          The global increment for the elements of X. Only two values
*          of INCX are supported in this version, namely 1 and M_X.
*          INCX must not be zero.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO = 0, no error has been found.
*          If INFO > 0, the maximum abolute error found is in (0,eps].
*          If INFO < 0, the maximum abolute error found is in (eps,+oo).
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IB, ICTXT, ICURCOL, ICURROW, II, IIX, IXCOL,
     $                   IXROW, J, JB, JJ, JJX, KK, LDX, LDPX, LL,
     $                   MPALL, MYCOL, MYROW, NPCOL, NPROW, NQALL
      DOUBLE PRECISION   EPS, ERR, ERRMAX
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, ZERRSET, DGAMX2D
*     ..
*     .. External Functions ..
      INTEGER            NUMROC
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           NUMROC, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DIMAG, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
      ICTXT = DESCX( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      CALL INFOG2L( IX, JX, DESCX, NPROW, NPCOL, MYROW, MYCOL, IIX, JJX,
     $              IXROW, IXCOL )
      MPALL = NUMROC( DESCX( M_ ), DESCX( MB_ ), MYROW, DESCX( RSRC_ ),
     $                NPROW )
      NQALL = NUMROC( DESCX( N_ ), DESCX( NB_ ), MYCOL, DESCX( CSRC_ ),
     $                NPCOL )
*
      INFO = 0
      ERRMAX = ZERO
      LDX = DESCX( M_ )
      LDPX = DESCX( LLD_ )
*
      IF( INCX.EQ.DESCX( M_ ) ) THEN
*
*        sub( X ) is a row vector
*
         II = 1
         ICURROW = DESCX( RSRC_ )
*
         DO 40 I = 1, DESCX( M_ ), DESCX( MB_ )
            IB = MIN( DESCX( M_ ) - I + 1, DESCX( MB_ ) )
*
            J = MOD( MYCOL - DESCX( CSRC_ ) + NPCOL, NPCOL ) *
     $          DESCX( NB_ ) + 1
*
            IF( MYROW.EQ.ICURROW ) THEN
*
               DO 30 JJ = 1, NQALL, DESCX( NB_ )
                  JB = MIN( NQALL-JJ+1, DESCX( NB_ ) )
*
                  DO 20 KK = 0, JB-1
                     DO 10 LL = 0, IB-1
                        IF( I+LL.NE.IX .OR. J+KK.LT.JX .OR.
     $                      J+KK.GT.JX+N-1 )
     $                     CALL ZERRSET( ERR, ERRMAX,
     $                                   X( I+LL+(J+KK-1)*LDX ),
     $                                   PX( II+LL+(JJ+KK-1)*LDPX ) )
   10                CONTINUE
   20             CONTINUE
                  J = J + NPCOL*DESCX( NB_ )
*
   30          CONTINUE
*
               II = II + IB
*
            END IF
*
            ICURROW = MOD( ICURROW + 1, NPROW )
*
   40    CONTINUE
*
      ELSE
*
*        sub( X ) is a column vector
*
         JJ = 1
         ICURCOL = DESCX( CSRC_ )
*
         DO 80 J = 1, DESCX( N_ ), DESCX( NB_ )
            JB = MIN( DESCX( N_ ) - J + 1, DESCX( NB_ ) )
*
            I = MOD( MYROW - DESCX( RSRC_ ) + NPROW, NPROW ) *
     $          DESCX( MB_ ) + 1
*
            IF( MYCOL.EQ.ICURCOL ) THEN
*
               DO 70 II = 1, MPALL, DESCX( MB_ )
                  IB = MIN( MPALL-II+1, DESCX( MB_ ) )
*
                  DO 60 KK = 0, JB-1
                     DO 50 LL = 0, IB-1
                        IF( J+KK.NE.JX .OR. I+LL.LT.IX .OR.
     $                      I+LL.GT.IX+N-1 )
     $                     CALL ZERRSET( ERR, ERRMAX,
     $                                   X( I+LL+(J+KK-1)*LDX ),
     $                                   PX( II+LL+(JJ+KK-1)*LDPX ) )
   50                CONTINUE
   60             CONTINUE
                  I = I + NPROW*DESCX( MB_ )
*
   70          CONTINUE
*
               JJ = JJ + JB
*
            END IF
*
            ICURCOL = MOD( ICURCOL + 1, NPCOL )
*                                                           INSERT MODE
   80    CONTINUE
*
      END IF
*
      CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERRMAX, 1, KK, LL, -1,
     $              -1, -1 )
*
      IF( ERRMAX.GT.ZERO .AND. ERRMAX.LE.EPS ) THEN
         INFO = 1
      ELSE IF( ERRMAX.GT.EPS ) THEN
         INFO = -1
      END IF
*
      RETURN
*
*     End of PZCHKVOUT
*
      END
      SUBROUTINE PZCHKMIN( ERRMAX, M, N, A, PA, IA, JA, DESCA, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar arguments ..
      INTEGER            INFO, IA, JA, M, N
      DOUBLE PRECISION   ERRMAX
*     ..
*     .. Array arguments ..
      INTEGER            DESCA( * )
      COMPLEX*16         PA( * ), A( * )
*     ..
*
*  Purpose
*  =======
*
*  PZCHKMIN checks that the distributed matrix sub( PA ) remained
*  unchanged. The local array entries are compared element by element,
*  and their difference is tested against 0.0 as well as the epsilon
*  machine. Notice that this difference should be numerically exactly
*  the zero machine, but because of the possible movement of some of
*  the data we flagged differently a difference less than twice the
*  epsilon machine. The largest error is also returned.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ERRMAX  (global input/global output) DOUBLE PRECISION
*          The largest absolute element-wise difference between sub( A )
*          and sub( PA ).
*
*  M       (global input) INTEGER
*          The number of rows of the distributed submatrix sub( PA ).
*          M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns of the distributed submatrix sub( PA ).
*          N >= 0.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA( M_ ),*). This array contains
*          a local copy of the entire distributed matrix PX to be
*          checked.
*
*  PA      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PA.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO = 0, no error has been found.
*          If INFO > 0, the maximum abolute error found is in (0,eps].
*          If INFO < 0, the maximum abolute error found is in (eps,+oo).
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            H, I, IB, ICTXT, ICURCOL, ICURROW, II, IIA, IN,
     $                   IACOL, IAROW, J, JB, JJ, JJA, JN, K, KK, LDA,
     $                   LDPA, LL, MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   ERR, EPS
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, ZERRSET, DGAMX2D
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, NUMROC
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ICEIL, NUMROC, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DIMAG, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      INFO = 0
      ERRMAX = ZERO
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
      ICURROW = IAROW
      ICURCOL = IACOL
      II = IIA
      JJ = JJA
      LDA = DESCA( M_ )
      LDPA = DESCA( LLD_ )
*
*     Handle the first block of column separately
*
      JN = MIN( ICEIL( JA, DESCA( NB_ ) ) * DESCA( NB_ ), JA+N-1 )
      JB = JN-JA+1
      DO 40 H = 0, JB-1
         IN = MIN( ICEIL( IA, DESCA( MB_ ) ) * DESCA( MB_ ), IA+M-1 )
         IB = IN-IA+1
         IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
            DO 10 K = 0, IB-1
               CALL ZERRSET( ERR, ERRMAX, A( IA+K+(JA+H-1)*LDA ),
     $                       PA( II+K+(JJ+H-1)*LDPA ) )
   10       CONTINUE
         END IF
         IF( MYROW.EQ.ICURROW )
     $      II = II + IB
         ICURROW = MOD( ICURROW+1, NPROW )
*
*        Loop over remaining block of rows
*
         DO 30 I = IN+1, IA+M-1, DESCA( MB_ )
            IB = MIN( DESCA( MB_ ), IA+M-I )
            IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
               DO 20 K = 0, IB-1
                  CALL ZERRSET( ERR, ERRMAX, A( I+K+(JA+H-1)*LDA ),
     $                          PA( II+K+(JJ+H-1)*LDPA ) )
   20          CONTINUE
            END IF
            IF( MYROW.EQ.ICURROW )
     $         II = II + IB
            ICURROW = MOD( ICURROW+1, NPROW )
   30    CONTINUE
*
        II = IIA
        ICURROW = IAROW
   40 CONTINUE
*
      IF( MYCOL.EQ.ICURCOL )
     $   JJ = JJ + JB
      ICURCOL = MOD( ICURCOL+1, NPCOL )
      CALL BLACS_BARRIER( ICTXT, 'All' )
*
*     Loop over remaining column blocks
*
      DO 90 J = JN+1, JA+N-1, DESCA( NB_ )
         JB = MIN(  DESCA( NB_ ), JA+N-J )
         DO 80 H = 0, JB-1
            IN = MIN( ICEIL( IA, DESCA( MB_ ) ) * DESCA( MB_ ), IA+M-1 )
            IB = IN-IA+1
            IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
               DO 50 K = 0, IB-1
                  CALL ZERRSET( ERR, ERRMAX, A( IA+K+(J+H-1)*LDA ),
     $                          PA( II+K+(JJ+H-1)*LDPA ) )
   50          CONTINUE
            END IF
            IF( MYROW.EQ.ICURROW )
     $         II = II + IB
            ICURROW = MOD( ICURROW+1, NPROW )
*
*           Loop over remaining block of rows
*
            DO 70 I = IN+1, IA+M-1, DESCA( MB_ )
               IB = MIN( DESCA( MB_ ), IA+M-I )
               IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
                  DO 60 K = 0, IB-1
                     CALL ZERRSET( ERR, ERRMAX, A( I+K+(J+H-1)*LDA ),
     $                             PA( II+K+(JJ+H-1)*LDPA ) )
   60             CONTINUE
               END IF
               IF( MYROW.EQ.ICURROW )
     $            II = II + IB
               ICURROW = MOD( ICURROW+1, NPROW )
   70       CONTINUE
*
            II = IIA
            ICURROW = IAROW
   80    CONTINUE
*
         IF( MYCOL.EQ.ICURCOL )
     $      JJ = JJ + JB
         ICURCOL = MOD( ICURCOL+1, NPCOL )
*
   90 CONTINUE
*
      CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERRMAX, 1, KK, LL, -1,
     $              -1, -1 )
*
      IF( ERRMAX.GT.ZERO .AND. ERRMAX.LE.EPS ) THEN
         INFO = 1
      ELSE IF( ERRMAX.GT.EPS ) THEN
         INFO = -1
      END IF
*
      RETURN
*
*     End of PZCHKMIN
*
      END
      SUBROUTINE PZCHKMOUT( M, N, A, PA, IA, JA, DESCA, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar arguments ..
      INTEGER            INFO, IA, JA, M, N
*     ..
*     .. Array arguments ..
      INTEGER            DESCA( * )
      COMPLEX*16         A( * ), PA( * )
*     ..
*
*  Purpose
*  =======
*
*  PZCHKMOUT checks that the distributed matrix PA \ sub( PA )
*  remained unchanged. The local array entries are compared element by
*  element, and their difference is tested against 0.0 as well as the
*  epsilon machine. Notice that this difference should be numerically
*  exactly the zero machine, but because of the possible movement of
*  some of the data we flagged differently a difference less than
*  twice the epsilon machine. The largest error is reported.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  M       (global input) INTEGER
*          The number of rows of the distributed submatrix sub( PA ).
*          M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns of the distributed submatrix sub( PA ).
*          N >= 0.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA(M_),*). This array contains
*          a local copy of the entire distributed matrix PA to be
*          checked.
*
*  PA      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA(LLD_),*). This array contains
*          the local pieces of the distributed matrix PA.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO = 0, no error has been found.
*          If INFO > 0, the maximum abolute error found is in (0,eps].
*          If INFO < 0, the maximum abolute error found is in (eps,+oo).
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IB, ICTXT, ICURCOL, II, IIA,
     $                   IACOL, IAROW, J, JB, JJ, JJA, KK, LDA, LDPA,
     $                   LL, MPALL, MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   EPS, ERR, ERRMAX
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, ZERRSET, DGAMX2D
*     ..
*     .. External Functions ..
      INTEGER            NUMROC
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           NUMROC, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DIMAG, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
      MPALL = NUMROC( DESCA( M_ ), DESCA( MB_ ), MYROW, DESCA( RSRC_ ),
     $                NPROW )
*
      INFO = 0
      ERRMAX = ZERO
      LDA = DESCA( M_ )
      LDPA = DESCA( LLD_ )
*
      JJ = 1
      ICURCOL = DESCA( CSRC_ )
*
      DO 40 J = 1, DESCA( N_ ), DESCA( NB_ )
         JB = MIN( DESCA( N_ ) - J + 1, DESCA( NB_ ) )
*
         I = MOD( MYROW - DESCA( RSRC_ ) + NPROW, NPROW )*DESCA( MB_ )
     $       + 1
*
         IF( MYCOL.EQ.ICURCOL ) THEN
*
            DO 30 II = 1, MPALL, DESCA( MB_ )
               IB = MIN( MPALL-II+1, DESCA( MB_ ) )
*
               DO 20 KK = 0, JB-1
                  DO 10 LL = 0, IB-1
                     IF( I+LL.LT.IA .OR. I+LL.GT.IA+M-1 .OR.
     $                   J+KK.LT.JA .OR. J+KK.GT.JA+N-1 )
     $                  CALL ZERRSET( ERR, ERRMAX,
     $                                A( I+LL+(J+KK-1)*LDA ),
     $                                PA( II+LL+(JJ+KK-1)*LDPA ) )
   10             CONTINUE
   20          CONTINUE
               I = I + NPROW*DESCA( MB_ )
*
   30       CONTINUE
*
            JJ = JJ + JB
*
         END IF
*
         ICURCOL = MOD( ICURCOL + 1, NPCOL )
*                                                           INSERT MODE
   40 CONTINUE
*
      CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERRMAX, 1, KK, LL, -1,
     $              -1, -1 )
*
      IF( ERRMAX.GT.ZERO .AND. ERRMAX.LE.EPS ) THEN
         INFO = 1
      ELSE IF( ERRMAX.GT.EPS ) THEN
         INFO = -1
      END IF
*
      RETURN
*
*     End of PZCHKMOUT
*
      END
      SUBROUTINE PBZMATGEN( ICTXT, AFORM, DIAG, M, N, MB, NB, A, LDA,
     $                      IAROW, IACOL, ISEED, IROFF, IRNUM, ICOFF,
     $                      ICNUM, MYROW, MYCOL, NPROW, NPCOL )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER*1        AFORM, DIAG
      INTEGER            IACOL, IAROW, ICNUM, ICOFF, ICTXT, IRNUM,
     $                   IROFF, ISEED, LDA, M, MB, MYCOL, MYROW, N,
     $                   NB, NPCOL, NPROW
*     ..
*     .. Array Arguments ..
      COMPLEX*16         A( LDA, * )
*     ..
*
*  Purpose
*  =======
*
*  PBZMATGEN : Parallel Complex Double precision MATrix GENerator.
*  Generate (or regenerate) a distributed matrix A (or sub-matrix of A).
*
*  Warning
*  =======
*
*  This version of the matrix generator always generate double precision
*  random numbers. In the single precision versions, these numbers are
*  truncated using the FORTRAN intrinsic function REAL.
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  AFORM   (global input) CHARACTER*1
*          if AFORM = 'S' : A is returned is a symmetric matrix.
*          if AFORM = 'H' : A is returned is a Hermitian matrix.
*          if AFORM = 'T' : A is overwritten with the transpose of
*                           what would normally be generated.
*          if AFORM = 'C' : A is overwritten with the conjugate trans-
*                           pose of what would normally be generated.
*          if AFORM = 'N' : a random matrix is generated.
*
*  DIAG    (global input) CHARACTER*1
*          if DIAG = 'D' : A is diagonally dominant.
*
*  M       (global input) INTEGER
*          The number of rows in the generated distributed matrix.
*
*  N       (global input) INTEGER
*          The number of columns in the generated distributed
*          matrix.
*
*  MB      (global input) INTEGER
*          The row blocking factor of the distributed matrix A.
*
*  NB      (global input) INTEGER
*          The column blocking factor of the distributed matrix A.
*
*  A       (local output) COMPLEX*16, pointer into the local memory
*          to an array of dimension ( LDA, * ) containing the local
*          pieces of the distributed matrix.
*
*  LDA     (local input) INTEGER
*          The leading dimension of the array containing the local
*          pieces of the distributed matrix A.
*
*  IAROW   (global input) INTEGER
*          The row processor coordinate which holds the first block
*          of the distributed matrix A.
*
*  IACOL   (global input) INTEGER
*          The column processor coordinate which holds the first
*          block of the distributed matrix A.
*
*  ISEED   (global input) INTEGER
*          The seed number to generate the distributed matrix A.
*
*  IROFF   (local input) INTEGER
*          The number of local rows of A that have already been
*          generated.  It should be a multiple of MB.
*
*  IRNUM   (local input) INTEGER
*          The number of local rows to be generated.
*
*  ICOFF   (local input) INTEGER
*          The number of local columns of A that have already been
*          generated.  It should be a multiple of NB.
*
*  ICNUM   (local input) INTEGER
*          The number of local columns to be generated.
*
*  MYROW   (local input) INTEGER
*          The row process coordinate of the calling process.
*
*  MYCOL   (local input) INTEGER
*          The column process coordinate of the calling process.
*
*  NPROW   (global input) INTEGER
*          The number of process rows in the grid.
*
*  NPCOL   (global input) INTEGER
*          The number of process columns in the grid.
*
*  Notes
*  =====
*
*  The code is originally developed by David Walker, ORNL,
*  and modified by Jaeyoung Choi, ORNL.
*
*  Reference: G. Fox et al.
*  Section 12.3 of "Solving problems on concurrent processors Vol. I"
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            MULT0, MULT1, IADD0, IADD1
      PARAMETER        ( MULT0 = 20077, MULT1 = 16838, IADD0 = 12345,
     $                   IADD1 = 0 )
      DOUBLE PRECISION   ZERO
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            SYMM, HERM, TRAN
      INTEGER            I, IC, IK, INFO, IOFFC, IOFFR, IR, J, JK,
     $                   JUMP1, JUMP2, JUMP3, JUMP4, JUMP5, JUMP6,
     $                   JUMP7, MAXMN, MEND, MOFF, MP, MRCOL, MRROW,
     $                   NEND, NOFF, NPMB, NQ, NQNB
      DOUBLE PRECISION   DUMMY
*     ..
*     .. Local Arrays ..
      INTEGER            IADD( 2 ), IA1( 2 ), IA2( 2 ), IA3( 2 ),
     $                   IA4( 2 ), IA5( 2 ), IB1( 2 ), IB2( 2 ),
     $                   IB3( 2 ), IC1( 2 ), IC2( 2 ), IC3( 2 ),
     $                   IC4( 2 ), IC5( 2 ), IRAN1( 2 ), IRAN2( 2 ),
     $                   IRAN3( 2 ), IRAN4( 2 ), ITMP1( 2 ), ITMP2( 2 ),
     $                   ITMP3( 2 ), JSEED( 2 ), MULT( 2 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           JUMPIT, PXERBLA, SETRAN, XJUMPM
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DCMPLX, DCONJG, DIMAG, MAX, MOD
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL, NUMROC
      DOUBLE PRECISION   PDRAND
      EXTERNAL           ICEIL, NUMROC, LSAME, PDRAND
*     ..
*     .. Executable Statements ..
*
*     Test the input arguments
*
      MP   = NUMROC( M, MB, MYROW, IAROW, NPROW )
      NQ   = NUMROC( N, NB, MYCOL, IACOL, NPCOL )
      SYMM = LSAME( AFORM, 'S' )
      HERM = LSAME( AFORM, 'H' )
      TRAN = LSAME( AFORM, 'T' )
*
      INFO = 0
      IF( .NOT.( SYMM.OR.HERM.OR.TRAN ) .AND.
     $    .NOT.LSAME( AFORM, 'C' ) .AND.
     $    .NOT.LSAME( AFORM, 'N' ) ) THEN
         INFO = 2
      ELSE IF( .NOT.LSAME( DIAG, 'D' ) .AND.
     $         .NOT.LSAME( DIAG, 'N' )        ) THEN
         INFO = 3
      ELSE IF( SYMM.OR.HERM ) THEN
         IF( M.NE.N ) THEN
            INFO = 5
         ELSE IF( MB.NE.NB ) THEN
            INFO = 7
         END IF
      ELSE IF( M.LT.0 ) THEN
         INFO = 4
      ELSE IF( N.LT.0 ) THEN
         INFO = 5
      ELSE IF( MB.LT.1 ) THEN
         INFO = 6
      ELSE IF( NB.LT.1 ) THEN
         INFO = 7
      ELSE IF( LDA.LT.0 ) THEN
         INFO = 9
      ELSE IF( IAROW.LT.0 .OR. IAROW.GE.NPROW ) THEN
         INFO = 10
      ELSE IF( IACOL.LT.0 .OR. IACOL.GE.NPCOL ) THEN
         INFO = 11
      ELSE IF( MOD( IROFF, MB ).GT.0 ) THEN
         INFO = 13
      ELSE IF( IRNUM.GT.( MP-IROFF ) ) THEN
         INFO = 14
      ELSE IF( MOD( ICOFF, NB ).GT.0 ) THEN
         INFO = 15
      ELSE IF( ICNUM.GT.( NQ - ICOFF ) ) THEN
         INFO = 16
      ELSE IF( MYROW.LT.0 .OR. MYROW.GE.NPROW ) THEN
         INFO = 17
      ELSE IF( MYCOL.LT.0 .OR. MYCOL.GE.NPCOL ) THEN
         INFO = 18
      END IF
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PBZMATGEN', INFO )
         RETURN
      END IF
*
      MRROW = MOD( NPROW + MYROW - IAROW, NPROW )
      MRCOL = MOD( NPCOL + MYCOL - IACOL, NPCOL )
      NPMB  = NPROW * MB
      NQNB  = NPCOL * NB
      MOFF  = IROFF / MB
      NOFF  = ICOFF / NB
      MEND  = ICEIL( IRNUM, MB ) + MOFF
      NEND  = ICEIL( ICNUM, NB ) + NOFF
*
      MULT( 1 )  = MULT0
      MULT( 2 )  = MULT1
      IADD( 1 )  = IADD0
      IADD( 2 )  = IADD1
      JSEED( 1 ) = ISEED
      JSEED( 2 ) = 0
*
*     Symmetric or Hermitian matrix will be generated.
*
      IF( SYMM.OR.HERM ) THEN
*
*        First, generate the lower triangular part (with diagonal block)
*
         JUMP1 = 1
         JUMP2 = 2*NPMB
         JUMP3 = 2*M
         JUMP4 = NQNB
         JUMP5 = NB
         JUMP6 = MRCOL
         JUMP7 = 2*MB * MRROW
*
         CALL XJUMPM( JUMP1, MULT, IADD, JSEED, IRAN1, IA1,   IC1 )
         CALL XJUMPM( JUMP2, MULT, IADD, IRAN1, ITMP1, IA2,   IC2 )
         CALL XJUMPM( JUMP3, MULT, IADD, IRAN1, ITMP1, IA3,   IC3 )
         CALL XJUMPM( JUMP4, IA3,  IC3,  IRAN1, ITMP1, IA4,   IC4 )
         CALL XJUMPM( JUMP5, IA3,  IC3,  IRAN1, ITMP1, IA5,   IC5 )
         CALL XJUMPM( JUMP6, IA5,  IC5,  IRAN1, ITMP3, ITMP1, ITMP2 )
         CALL XJUMPM( JUMP7, MULT, IADD, ITMP3, IRAN1, ITMP1, ITMP2 )
         CALL XJUMPM( NOFF,  IA4,  IC4,  IRAN1, ITMP1, ITMP2, ITMP3 )
         CALL XJUMPM( MOFF,  IA2,  IC2,  ITMP1, IRAN1, ITMP2, ITMP3 )
         CALL SETRAN( IRAN1, IA1,  IC1 )
*
         DO 10 I = 1, 2
            IB1( I ) = IRAN1( I )
            IB2( I ) = IRAN1( I )
            IB3( I ) = IRAN1( I )
   10    CONTINUE
*
         JK = 1
         DO 80 IC = NOFF+1, NEND
            IOFFC = ( ( IC - 1 ) * NPCOL + MRCOL ) * NB
            DO 70 I = 1, NB
               IF( JK.GT.ICNUM )
     $            GO TO 90
*
               IK = 1
               DO 50 IR = MOFF+1, MEND
                  IOFFR = ( ( IR - 1 ) * NPROW + MRROW ) * MB
*
                  IF( IOFFR.GT.IOFFC ) THEN
                     DO 20 J = 1, MB
                        IF( IK.GT.IRNUM )
     $                     GO TO 60
                        A( IK, JK ) = DCMPLX( PDRAND( 0 ), PDRAND( 0 ) )
                        IK = IK + 1
   20                CONTINUE
*
                  ELSE IF( IOFFC.EQ.IOFFR ) THEN
                     IK = IK + I - 1
                     IF( IK.GT.IRNUM )
     $                  GO TO 60
                     DO 30 J = 1, I-1
                        A( IK, JK ) = DCMPLX( PDRAND( 0 ), PDRAND( 0 ) )
   30                CONTINUE
                     IF( SYMM ) THEN
                        A( IK, JK ) = DCMPLX( PDRAND( 0 ), PDRAND( 0 ) )
                     ELSE
                        A( IK, JK ) = DCMPLX( PDRAND( 0 ), ZERO )
                        DUMMY = PDRAND( 0 )
                     END IF
                     DO 40 J = 1, MB-I
                        IF( IK+J.GT.IRNUM )
     $                     GO TO 60
                        A( IK+J, JK ) = DCMPLX( PDRAND( 0 ),
     $                                          PDRAND( 0 ) )
                        IF( HERM ) THEN
                           A( IK, JK+J ) = DCONJG( A( IK+J, JK ) )
                        ELSE
                           A( IK, JK+J ) = A( IK+J, JK )
                        END IF
   40                CONTINUE
                     IK = IK + MB - I + 1
                  ELSE
                     IK = IK + MB
                  END IF
*
                  CALL JUMPIT( IA2, IC2, IB1, IRAN2 )
                  IB1( 1 ) = IRAN2( 1 )
                  IB1( 2 ) = IRAN2( 2 )
   50          CONTINUE
*
   60          CONTINUE
               JK = JK + 1
               CALL JUMPIT( IA3, IC3, IB2, IRAN3 )
               IB1( 1 ) = IRAN3( 1 )
               IB1( 2 ) = IRAN3( 2 )
               IB2( 1 ) = IRAN3( 1 )
               IB2( 2 ) = IRAN3( 2 )
   70       CONTINUE
*
            CALL JUMPIT( IA4, IC4, IB3, IRAN4 )
            IB1( 1 ) = IRAN4( 1 )
            IB1( 2 ) = IRAN4( 2 )
            IB2( 1 ) = IRAN4( 1 )
            IB2( 2 ) = IRAN4( 2 )
            IB3( 1 ) = IRAN4( 1 )
            IB3( 2 ) = IRAN4( 2 )
   80    CONTINUE
*
*        Next, generate the upper triangular part.
*
   90    CONTINUE
         MULT( 1 )  = MULT0
         MULT( 2 )  = MULT1
         IADD( 1 )  = IADD0
         IADD( 2 )  = IADD1
         JSEED( 1 ) = ISEED
         JSEED( 2 ) = 0
*
         JUMP1 = 1
         JUMP2 = 2*NQNB
         JUMP3 = 2*N
         JUMP4 = NPMB
         JUMP5 = MB
         JUMP6 = MRROW
         JUMP7 = 2*NB * MRCOL
*
         CALL XJUMPM( JUMP1, MULT, IADD, JSEED, IRAN1, IA1,   IC1 )
         CALL XJUMPM( JUMP2, MULT, IADD, IRAN1, ITMP1, IA2,   IC2 )
         CALL XJUMPM( JUMP3, MULT, IADD, IRAN1, ITMP1, IA3,   IC3 )
         CALL XJUMPM( JUMP4, IA3,  IC3,  IRAN1, ITMP1, IA4,   IC4 )
         CALL XJUMPM( JUMP5, IA3,  IC3,  IRAN1, ITMP1, IA5,   IC5 )
         CALL XJUMPM( JUMP6, IA5,  IC5,  IRAN1, ITMP3, ITMP1, ITMP2 )
         CALL XJUMPM( JUMP7, MULT, IADD, ITMP3, IRAN1, ITMP1, ITMP2 )
         CALL XJUMPM( MOFF,  IA4,  IC4,  IRAN1, ITMP1, ITMP2, ITMP3 )
         CALL XJUMPM( NOFF,  IA2,  IC2,  ITMP1, IRAN1, ITMP2, ITMP3 )
         CALL SETRAN( IRAN1, IA1,  IC1 )
*
         DO 100 I = 1, 2
            IB1( I ) = IRAN1( I )
            IB2( I ) = IRAN1( I )
            IB3( I ) = IRAN1( I )
  100    CONTINUE
*
         IK = 1
         DO 150 IR = MOFF+1, MEND
            IOFFR = ( ( IR - 1 ) * NPROW + MRROW ) * MB
            DO 140 J = 1, MB
               IF( IK.GT.IRNUM )
     $            GO TO 160
               JK = 1
               DO 120 IC = NOFF+1, NEND
                  IOFFC = ( ( IC - 1 ) * NPCOL + MRCOL ) * NB
                  IF( IOFFC.GT.IOFFR ) THEN
                     DO 110 I = 1, NB
                        IF( JK.GT.ICNUM )
     $                     GO TO 130
                        IF( SYMM ) THEN
                           A( IK, JK ) = DCMPLX( PDRAND( 0 ),
     $                                           PDRAND( 0 ) )
                        ELSE
                           A( IK, JK ) = DCMPLX( PDRAND( 0 ),
     $                                          -PDRAND( 0 ) )
                        END IF
                        JK = JK + 1
  110                CONTINUE
                  ELSE
                     JK = JK + NB
                  END IF
                  CALL JUMPIT( IA2, IC2, IB1, IRAN2 )
                  IB1( 1 ) = IRAN2( 1 )
                  IB1( 2 ) = IRAN2( 2 )
  120          CONTINUE
*
  130          CONTINUE
               IK = IK + 1
               CALL JUMPIT( IA3, IC3, IB2, IRAN3 )
               IB1( 1 ) = IRAN3( 1 )
               IB1( 2 ) = IRAN3( 2 )
               IB2( 1 ) = IRAN3( 1 )
               IB2( 2 ) = IRAN3( 2 )
  140       CONTINUE
*
            CALL JUMPIT( IA4, IC4, IB3, IRAN4 )
            IB1( 1 ) = IRAN4( 1 )
            IB1( 2 ) = IRAN4( 2 )
            IB2( 1 ) = IRAN4( 1 )
            IB2( 2 ) = IRAN4( 2 )
            IB3( 1 ) = IRAN4( 1 )
            IB3( 2 ) = IRAN4( 2 )
  150    CONTINUE
  160    CONTINUE
*
*     (Conjugate) Transposed matrix A will be generated.
*
      ELSE IF( TRAN .OR. LSAME( AFORM, 'C' ) ) THEN
*
         JUMP1 = 1
         JUMP2 = 2*NQNB
         JUMP3 = 2*N
         JUMP4 = NPMB
         JUMP5 = MB
         JUMP6 = MRROW
         JUMP7 = 2*NB * MRCOL
*
         CALL XJUMPM( JUMP1, MULT, IADD, JSEED, IRAN1, IA1,   IC1 )
         CALL XJUMPM( JUMP2, MULT, IADD, IRAN1, ITMP1, IA2,   IC2 )
         CALL XJUMPM( JUMP3, MULT, IADD, IRAN1, ITMP1, IA3,   IC3 )
         CALL XJUMPM( JUMP4, IA3,  IC3,  IRAN1, ITMP1, IA4,   IC4 )
         CALL XJUMPM( JUMP5, IA3,  IC3,  IRAN1, ITMP1, IA5,   IC5 )
         CALL XJUMPM( JUMP6, IA5,  IC5,  IRAN1, ITMP3, ITMP1, ITMP2 )
         CALL XJUMPM( JUMP7, MULT, IADD, ITMP3, IRAN1, ITMP1, ITMP2 )
         CALL XJUMPM( MOFF,  IA4,  IC4,  IRAN1, ITMP1, ITMP2, ITMP3 )
         CALL XJUMPM( NOFF,  IA2,  IC2,  ITMP1, IRAN1, ITMP2, ITMP3 )
         CALL SETRAN( IRAN1, IA1,  IC1 )
*
         DO 170 I = 1, 2
            IB1( I ) = IRAN1( I )
            IB2( I ) = IRAN1( I )
            IB3( I ) = IRAN1( I )
  170    CONTINUE
*
         IK = 1
         DO 220 IR = MOFF+1, MEND
            IOFFR = ( ( IR - 1 ) * NPROW + MRROW ) * MB
            DO 210 J = 1, MB
               IF( IK.GT.IRNUM )
     $            GO TO 230
               JK = 1
               DO 190 IC = NOFF+1, NEND
                  IOFFC = ( ( IC - 1 ) * NPCOL + MRCOL ) * NB
                  DO 180 I = 1, NB
                     IF( JK.GT.ICNUM )
     $                  GO TO 200
                     IF( TRAN ) THEN
                        A( IK, JK ) = DCMPLX( PDRAND( 0 ),
     $                                        PDRAND( 0 ) )
                     ELSE
                        A( IK, JK ) = DCMPLX( PDRAND( 0 ),
     $                                       -PDRAND( 0 ) )
                     END IF
                     JK = JK + 1
  180             CONTINUE
                  CALL JUMPIT( IA2, IC2, IB1, IRAN2 )
                  IB1( 1 ) = IRAN2( 1 )
                  IB1( 2 ) = IRAN2( 2 )
  190          CONTINUE
*
  200          CONTINUE
               IK = IK + 1
               CALL JUMPIT( IA3, IC3, IB2, IRAN3 )
               IB1( 1 ) = IRAN3( 1 )
               IB1( 2 ) = IRAN3( 2 )
               IB2( 1 ) = IRAN3( 1 )
               IB2( 2 ) = IRAN3( 2 )
  210       CONTINUE
*
            CALL JUMPIT( IA4, IC4, IB3, IRAN4 )
            IB1( 1 ) = IRAN4( 1 )
            IB1( 2 ) = IRAN4( 2 )
            IB2( 1 ) = IRAN4( 1 )
            IB2( 2 ) = IRAN4( 2 )
            IB3( 1 ) = IRAN4( 1 )
            IB3( 2 ) = IRAN4( 2 )
  220    CONTINUE
  230    CONTINUE
*
*     A random matrix is generated.
*
      ELSE
*
         JUMP1 = 1
         JUMP2 = 2*NPMB
         JUMP3 = 2*M
         JUMP4 = NQNB
         JUMP5 = NB
         JUMP6 = MRCOL
         JUMP7 = 2*MB * MRROW
*
         CALL XJUMPM( JUMP1, MULT, IADD, JSEED, IRAN1, IA1,   IC1 )
         CALL XJUMPM( JUMP2, MULT, IADD, IRAN1, ITMP1, IA2,   IC2 )
         CALL XJUMPM( JUMP3, MULT, IADD, IRAN1, ITMP1, IA3,   IC3 )
         CALL XJUMPM( JUMP4, IA3,  IC3,  IRAN1, ITMP1, IA4,   IC4 )
         CALL XJUMPM( JUMP5, IA3,  IC3,  IRAN1, ITMP1, IA5,   IC5 )
         CALL XJUMPM( JUMP6, IA5,  IC5,  IRAN1, ITMP3, ITMP1, ITMP2 )
         CALL XJUMPM( JUMP7, MULT, IADD, ITMP3, IRAN1, ITMP1, ITMP2 )
         CALL XJUMPM( NOFF,  IA4,  IC4,  IRAN1, ITMP1, ITMP2, ITMP3 )
         CALL XJUMPM( MOFF,  IA2,  IC2,  ITMP1, IRAN1, ITMP2, ITMP3 )
         CALL SETRAN( IRAN1, IA1,  IC1 )
*
         DO 240 I = 1, 2
            IB1( I ) = IRAN1( I )
            IB2( I ) = IRAN1( I )
            IB3( I ) = IRAN1( I )
  240    CONTINUE
*
         JK = 1
         DO 290 IC = NOFF+1, NEND
            IOFFC = ( ( IC - 1 ) * NPCOL + MRCOL ) * NB
            DO 280 I = 1, NB
               IF( JK.GT.ICNUM )
     $            GO TO 300
               IK = 1
               DO 260 IR = MOFF+1, MEND
                  IOFFR = ( ( IR - 1 ) * NPROW + MRROW ) * MB
                  DO 250 J = 1, MB
                     IF( IK.GT.IRNUM )
     $                  GO TO 270
                     A( IK, JK ) = DCMPLX( PDRAND( 0 ), PDRAND( 0 ) )
                     IK = IK + 1
  250             CONTINUE
                  CALL JUMPIT( IA2, IC2, IB1, IRAN2 )
                  IB1( 1 ) = IRAN2( 1 )
                  IB1( 2 ) = IRAN2( 2 )
  260          CONTINUE
*
  270          CONTINUE
               JK = JK + 1
               CALL JUMPIT( IA3, IC3, IB2, IRAN3 )
               IB1( 1 ) = IRAN3( 1 )
               IB1( 2 ) = IRAN3( 2 )
               IB2( 1 ) = IRAN3( 1 )
               IB2( 2 ) = IRAN3( 2 )
  280       CONTINUE
*
            CALL JUMPIT( IA4, IC4, IB3, IRAN4 )
            IB1( 1 ) = IRAN4( 1 )
            IB1( 2 ) = IRAN4( 2 )
            IB2( 1 ) = IRAN4( 1 )
            IB2( 2 ) = IRAN4( 2 )
            IB3( 1 ) = IRAN4( 1 )
            IB3( 2 ) = IRAN4( 2 )
  290    CONTINUE
  300    CONTINUE
      END IF
*
*     Diagonally dominant matrix will be generated.
*
      IF( LSAME( DIAG, 'D' ) ) THEN
         IF( MB.NE.NB ) THEN
            WRITE(*,*) 'Diagonally dominant matrices with rowNB not'//
     $                 ' equal colNB is not supported!'
            RETURN
         END IF
*
         MAXMN = MAX( M, N )
         JK = 1
         DO 340 IC = NOFF+1, NEND
            IOFFC = ( ( IC-1 ) * NPCOL + MRCOL ) * NB
            IK = 1
            DO 320 IR = MOFF+1, MEND
               IOFFR = ( ( IR-1 ) * NPROW + MRROW ) * MB
               IF( IOFFC.EQ.IOFFR ) THEN
                  DO 310 J = 0, MB-1
                     IF( IK.GT.IRNUM )
     $                  GO TO 330
                     IF( HERM ) THEN
                        A( IK, JK+J ) = DCMPLX( ABS( DBLE(
     $                  A( IK, JK+J ) ) ) + 2 * MAXMN, ZERO )
                     ELSE
                        A( IK, JK + J ) = DCMPLX( ABS( DBLE(
     $                  A( IK, JK + J ) ) ) + MAXMN, ABS( DIMAG(
     $                  A( IK, JK + J ) ) ) + MAXMN )
                     END IF
                     IK = IK + 1
  310             CONTINUE
               ELSE
                  IK = IK + MB
               END IF
  320       CONTINUE
  330       CONTINUE
            JK = JK + NB
  340    CONTINUE
      END IF
*
      RETURN
*
*     End of PBZMATGEN
*
      END
      SUBROUTINE ZMPRNT( ICTXT, NOUT, M, N, A, LDA, IRPRNT, ICPRNT,
     $                        CMATNM )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER            ICPRNT, ICTXT, IRPRNT, LDA, M, N, NOUT
*     ..
*     .. Array Arguments ..
      CHARACTER*(*)      CMATNM
      COMPLEX*16         A( LDA, * )
*     ..
*
*  Purpose
*  =======
*
*  ZMPRNT prints to the standard output an array A of size M x N.
*  Only the process of coordinates (IRPRNT, ICPRNT) is printing.
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr.
*
*  M       (global input) INTEGER
*          The number of rows of the matrix A. M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns of the matrix A. N >= 0.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to a local array of dimension (LDA,*) containing the M-by-N
*          matrix to be printed.
*
*  LDA     (local input) INTEGER
*          The leading Dimension of the local array A to be printed.
*
*  IRPRNT  (global input) INTEGER
*          The row index of the printing process.
*
*  ICPRNT  (global input) INTEGER
*          The column index of the printing process.
*
*  CMATNM  (global input) CHARACTER*(*)
*          Identifier of the matrix to be printed.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, J, MYCOL, MYROW, NPCOL, NPROW
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, DIMAG
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      IF( MYROW.EQ.IRPRNT .AND. MYCOL.EQ.ICPRNT ) THEN
*
         WRITE( NOUT, FMT = * )
         DO 20 J = 1, N
*
            DO 10 I = 1, M
*
               WRITE( NOUT, FMT = 9999 ) CMATNM, I, J,
     $                         DBLE( A( I, J ) ), DIMAG( A( I, J ) )
*
   10       CONTINUE
*
   20    CONTINUE
*
      END IF
*
 9999 FORMAT( A,'(',I6,',',I6,')=', D30.18, '+i*(', D30.18, ')' )
*
      RETURN
*
*     End of ZMPRNT
*
      END
      SUBROUTINE ZVPRNT( ICTXT, NOUT, N, X, INCX, IRPRNT, ICPRNT,
     $                   CVECNM )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER            ICPRNT, ICTXT, INCX, IRPRNT, N, NOUT
*     ..
*     .. Array Arguments ..
      CHARACTER*(*)      CVECNM
      COMPLEX*16         X( * )
*     ..
*
*  Purpose
*  =======
*
*  ZVPRNT prints to the standard output a vector X of size N.
*  Only the process of coordinates (IRPRNT, ICPRNT) is printing.
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr.
*
*  N       (global input) INTEGER
*          The length of the vector X. N >= 0.
*
*  X       (local input) COMPLEX*16
*          The vector to be printed.
*             x( i )  = X( 1 + ( i - 1 )*INCX ), 1 <= i <= n.
*
*  INCX    (input) INTEGER
*          The increment between successive values of the vector X.
*          INCX > 0.
*
*  IRPRNT  (global input) INTEGER
*          The row index of the printing process.
*
*  ICPRNT  (global input) INTEGER
*          The column index of the printing process.
*
*  CVECNM  (global input) CHARACTER*(*)
*          Identifier of the vector to be printed.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, MYCOL, MYROW, NPCOL, NPROW
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, DIMAG
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      IF( MYROW.EQ.IRPRNT .AND. MYCOL.EQ.ICPRNT ) THEN
*
         WRITE( NOUT, FMT = * )
         DO 10 I = 1, 1 + ( N-1 )*INCX, INCX
*
            WRITE( NOUT, FMT = 9999 ) CVECNM, I, DBLE( X( I ) ),
     $                                DIMAG( X( I ) )
*
   10    CONTINUE
*
      END IF
*
 9999 FORMAT( A,'(',I6,')=', D30.18, '+i*(', D30.18, ')' )
*
      RETURN
*
*     End of ZVPRNT
*
      END
      SUBROUTINE PZMVCH( ICTXT, TRANS, M, N, ALPHA, A, IA, JA, DESCA,
     $                   X, IX, JX, DESCX, INCX, BETA, Y, PY, IY, JY,
     $                   DESCY, INCY, G, ERR, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          TRANS
      INTEGER            ICTXT, IA, INCX, INCY, INFO, IX, IY, JA, JX,
     $                   JY, M, N
      DOUBLE PRECISION   ERR
      COMPLEX*16         ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCX( * ), DESCY( * )
      DOUBLE PRECISION   G( * )
      COMPLEX*16         A( * ), PY( * ), X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*  PZMVCH checks the results of the computational tests.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  TRANS   (global input) CHARACTER
*          TRANS specifies which matrix-vector product is to be
*          computed:
*                    If TRANS = 'T', y = beta * y + A**T * x,
*                    else if TRANS = 'C', y = beta * y + A**H * x,
*                    otherwise y = beta * y + A * x.
*
*  M       (global input) INTEGER
*          The number of rows of the operand matrix A. M >= 0.
*
*  N       (global input) INTEGER
*          The number of rows of the operand matrix A. N >= 0.
*
*  ALPHA   (global input) COMPLEX*16
*          The scalar alpha.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  X       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IX      (global input) INTEGER
*          The row index in the global array X indicating the first
*          row of sub( X ).
*
*  JX      (global input) INTEGER
*          The column index in the global array X indicating the
*          first column of sub( X ).
*
*  DESCX   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix X.
*
*  INCX    (global input) INTEGER
*          The global increment for the elements of X. Only two values
*          of INCX are supported in this version, namely 1 and M_X.
*          INCX must not be zero.
*
*  BETA    (global input) COMPLEX*16
*          The scalar beta.
*
*  Y       (local input/local output) COMPLEX*16 pointer into the
*          local memory to an array of dimension (DESCY( M_ ),*). This
*          array contains a local copy of the initial entire distribu-
*          ted matrix PY.
*
*  PY      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCY( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PY.
*
*  IY      (global input) INTEGER
*          The row index in the global array Y indicating the first
*          row of sub( Y ).
*
*  JY      (global input) INTEGER
*          The column index in the global array Y indicating the
*          first column of sub( Y ).
*
*  DESCY   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix Y.
*
*  INCY    (global input) INTEGER
*          The global increment for the elements of Y. Only two values
*          of INCY are supported in this version, namely 1 and M_Y.
*          INCY must not be zero.
*
*  G       (workspace) DOUBLE PRECISION array of dimension >= MAX(M,N).
*          G is used to compute the gauges.
*
*  ERR     (global output) DOUBLE PRECISION
*          The largest error in absolute value.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO <> 0, the result is less than half accurate.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   RZERO, RONE
      PARAMETER          ( RZERO = 0.0D+0, RONE = 1.0D+0 )
      COMPLEX*16         ZERO
      PARAMETER          ( ZERO = ( 0.0D+0, 0.0D+0 ) )
*     ..
*     .. Local Scalars ..
      LOGICAL            CTRAN, TRAN
      INTEGER            I, IB, ICURCOL, ICURROW, IIY, JJY, IN, IOFFA,
     $                   IOFFX, IOFFY, IYCOL, IYROW, J, JB, JN, KK, LDA,
     $                   LDPY, LDX, LDY, ML, MYCOL, MYROW, NL, NPCOL,
     $                   NPROW
      DOUBLE PRECISION   EPS, ERRI, GTMP
      COMPLEX*16         C, YTMP
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, IGSUM2D, DGAMX2D
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ICEIL, LSAME, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DCONJG, DIMAG, MAX, MIN, MOD, SQRT
*     ..
*     .. Statement Functions ..
      DOUBLE PRECISION   ABS1
*     ..
*     .. Statement Function definitions ..
      ABS1( C ) = ABS( DBLE( C ) ) + ABS( DIMAG( C ) )
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      TRAN = LSAME( TRANS, 'T' )
      CTRAN = LSAME( TRANS, 'C' )
      IF( TRAN.OR.CTRAN ) THEN
         ML = N
         NL = M
      ELSE
         ML = M
         NL = N
      END IF
*
      LDA = MAX( 1, DESCA( M_ ) )
      LDX = MAX( 1, DESCX( M_ ) )
      LDY = MAX( 1, DESCY( M_ ) )
*
*     Compute expected result in Y using data in A, X and Y.
*     Compute gauges in G. This part of the computation is performed
*     by every process in the mesh.
*
      IOFFY = IY + ( JY - 1 ) * LDY
      DO 40 I = 1, ML
         YTMP = ZERO
         GTMP = RZERO
         IOFFX = IX + ( JX - 1 ) * LDX
         IF( TRAN )THEN
            IOFFA = IA + ( JA + I - 2 ) * LDA
            DO 10 J = 1, NL
               YTMP = YTMP + A( IOFFA ) * X( IOFFX )
               GTMP = GTMP + ABS1( A( IOFFA ) ) * ABS1( X( IOFFX ) )
               IOFFA = IOFFA + 1
               IOFFX = IOFFX + INCX
   10       CONTINUE
         ELSE IF( CTRAN )THEN
            IOFFA = IA + ( JA + I - 2 ) * LDA
            DO 20 J = 1, NL
               YTMP = YTMP + DCONJG( A( IOFFA ) ) * X( IOFFX )
               GTMP = GTMP + ABS1( A( IOFFA ) ) * ABS1( X( IOFFX ) )
               IOFFA = IOFFA + 1
               IOFFX = IOFFX + INCX
   20       CONTINUE
         ELSE
            IOFFA = IA + I - 1 + ( JA - 1 ) * LDA
            DO 30 J = 1, NL
               YTMP = YTMP + A( IOFFA ) * X( IOFFX )
               GTMP = GTMP + ABS1( A( IOFFA ) ) * ABS1( X( IOFFX ) )
               IOFFA = IOFFA + LDA
               IOFFX = IOFFX + INCX
   30       CONTINUE
         END IF
         G( I ) = ABS1( ALPHA )*GTMP + ABS1( BETA ) * ABS1( Y( IOFFY ) )
         Y( IOFFY ) = ALPHA * YTMP + BETA * Y( IOFFY )
         IOFFY = IOFFY + INCY
   40 CONTINUE
*
*     Compute the error ratio for this result.
*
      ERR  = RZERO
      INFO = 0
      LDPY = DESCY( LLD_ )
      IOFFY = IY + ( JY - 1 ) * LDY
      CALL INFOG2L( IY, JY, DESCY, NPROW, NPCOL, MYROW, MYCOL, IIY,
     $              JJY, IYROW, IYCOL )
      ICURROW = IYROW
      ICURCOL = IYCOL
*
      IF( INCY.EQ.DESCY( M_ ) ) THEN
*
*        sub( Y ) is a row vector
*
         JN = MIN( ICEIL( JY, DESCY( NB_ ) ) * DESCY( NB_ ), JY+ML-1 )
         JB = JN - JY + 1
*
         DO 50 J = JY, JN
*
            IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
               ERRI = ABS( PY( IIY+(JJY-1)*LDPY ) - Y( IOFFY ) ) / EPS
               IF( G( J-JY+1 ).NE.RZERO )
     $            ERRI = ERRI / G( J-JY+1 )
               ERR = MAX( ERR, ERRI )
               IF( ERR*SQRT( EPS ).GE.RONE )
     $            INFO = 1
               JJY = JJY + 1
            END IF
*
            IOFFY = IOFFY + INCY
*
   50    CONTINUE
*
         ICURCOL = MOD( ICURCOL+1, NPCOL )
*
         DO 70 J = JN+1, JY+ML-1, DESCY( NB_ )
            JB = MIN( JY+ML-J, DESCY( NB_ ) )
*
            DO 60 KK = 0, JB-1
*
               IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
                  ERRI = ABS( PY( IIY+(JJY-1)*LDPY ) - Y( IOFFY ) )/EPS
                  IF( G( J+KK-JY+1 ).NE.RZERO )
     $               ERRI = ERRI / G( J+KK-JY+1 )
                  ERR = MAX( ERR, ERRI )
                  IF( ERR*SQRT( EPS ).GE.RONE )
     $               INFO = 1
                  JJY = JJY + 1
               END IF
*
               IOFFY = IOFFY + INCY
*
   60       CONTINUE
*
            ICURCOL = MOD( ICURCOL+1, NPCOL )
*
   70    CONTINUE
*
      ELSE
*
*        sub( Y ) is a column vector
*
         IN = MIN( ICEIL( IY, DESCY( MB_ ) ) * DESCY( MB_ ), IY+ML-1 )
         IB = IN - IY + 1
*
         DO 80 I = IY, IN
*
            IF( MYCOL.EQ.ICURCOL .AND. MYROW.EQ.ICURROW ) THEN
               ERRI = ABS( PY( IIY+(JJY-1)*LDPY ) - Y( IOFFY ) ) / EPS
               IF( G( I-IY+1 ).NE.RZERO )
     $            ERRI = ERRI / G( I-IY+1 )
               ERR = MAX( ERR, ERRI )
               IF( ERR*SQRT( EPS ).GE.RONE )
     $            INFO = 1
               IIY = IIY + 1
            END IF
*
            IOFFY = IOFFY + INCY
*
   80    CONTINUE
*
         ICURROW = MOD( ICURROW+1, NPROW )
*
         DO 100 I = IN+1, IY+ML-1, DESCY( MB_ )
            IB = MIN( IY+ML-I, DESCY( MB_ ) )
*
            DO 90 KK = 0, IB-1
*
               IF( MYCOL.EQ.ICURCOL .AND. MYROW.EQ.ICURROW ) THEN
                  ERRI = ABS( PY( IIY+(JJY-1)*LDPY ) - Y( IOFFY ) )/EPS
                  IF( G( I+KK-IY+1 ).NE.RZERO )
     $               ERRI = ERRI / G( I+KK-IY+1 )
                  ERR = MAX( ERR, ERRI )
                  IF( ERR*SQRT( EPS ).GE.RONE )
     $               INFO = 1
                  IIY = IIY + 1
               END IF
*
               IOFFY = IOFFY + INCY
*
   90       CONTINUE
*
            ICURROW = MOD( ICURROW+1, NPROW )
*
  100    CONTINUE
*
      END IF
*
*     If INFO = 0, all results are at least half accurate.
*
      CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, -1, MYCOL )
      CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERR, 1, I, J, -1, -1,
     $              MYCOL )
*
      RETURN
*
*     End of PZMVCH
*
      END
      SUBROUTINE PZVMCH( ICTXT, TRANS, UPLO, M, N, ALPHA, X, IX, JX,
     $                   DESCX, INCX, Y, IY, JY, DESCY, INCY, A, PA, IA,
     $                   JA, DESCA, G, ERR, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          TRANS, UPLO
      INTEGER            ICTXT, IA, INCX, INCY, INFO, IX, IY, JA, JX,
     $                   JY, M, N
      DOUBLE PRECISION   ERR
      COMPLEX*16         ALPHA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCX( * ), DESCY( * )
      DOUBLE PRECISION   G( * )
      COMPLEX*16         A( * ), PA( * ), X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*  PZVMCH checks the results of the computational tests.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  TRANS   (global input) CHARACTER
*          TRANS specifies the operation to be performed in the complex
*          cases: if TRANS = 'C, A := A + alpha*X*(Y**H), and otherwise
*          A := A + alpha*X*(Y**T).
*
*  UPLO    (global input) CHARACTER
*          UPLO specifies which part of the matrix A is to be
*          referenced:
*             If UPLO = 'L', only the lower triangular part,
*             If UPLO = 'U', only the upper triangular part,
*             else the entire matrix is to be referenced.
*
*  M       (global input) INTEGER
*          The number of rows of the operand matrix A. M >= 0.
*
*  N       (global input) INTEGER
*          The number of rows of the operand matrix A. N >= 0.
*
*  ALPHA   (global input) COMPLEX*16
*          The scalar alpha.
*
*  X       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IX      (global input) INTEGER
*          The row index in the global array X indicating the first
*          row of sub( X ).
*
*  JX      (global input) INTEGER
*          The column index in the global array X indicating the
*          first column of sub( X ).
*
*  DESCX   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix X.
*
*  INCX    (global input) INTEGER
*          The global increment for the elements of X. Only two values
*          of INCX are supported in this version, namely 1 and M_X.
*          INCX must not be zero.
*
*  Y       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCY( M_ ),*). This array
*          contains a local copy of the initial entire distributed
*          matrix PY.
*
*  IY      (global input) INTEGER
*          The row index in the global array Y indicating the first
*          row of sub( Y ).
*
*  JY      (global input) INTEGER
*          The column index in the global array Y indicating the
*          first column of sub( Y ).
*
*  DESCY   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix Y.
*
*  INCY    (global input) INTEGER
*          The global increment for the elements of Y. Only two values
*          of INCY are supported in this version, namely 1 and M_Y.
*          INCY must not be zero.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  PA      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PA.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  G       (workspace) DOUBLE PRECISION array of dimension >= MAX(M,N).
*          G is used to compute the gauges.
*
*  ERR     (global output) DOUBLE PRECISION
*          The largest error in absolute value.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO <> 0, the result is less than half accurate.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            CTRAN, LOWER, UPPER
      INTEGER            I, IB, IBEG, ICURROW, IEND, IIA, JJA, IN,
     $                   IOFFA, IOFFX, IOFFY, IACOL, IAROW, J, KK, LDA,
     $                   LDPA, LDX, LDY, MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   EPS, ERRI, GTMP
      COMPLEX*16         C, ATMP
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, IGSUM2D, DGAMX2D
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ICEIL, LSAME, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DCONJG, DIMAG, MAX, MIN, MOD, SQRT
*     ..
*     .. Statement Functions ..
      DOUBLE PRECISION   ABS1
*     ..
*     .. Statement Function definitions ..
      ABS1( C ) = ABS( DBLE( C ) ) + ABS( DIMAG( C ) )
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      CTRAN = LSAME( TRANS, 'C' )
      UPPER = LSAME( UPLO, 'U' )
      LOWER = LSAME( UPLO, 'L' )
*
      LDA = MAX( 1, DESCA( M_ ) )
      LDX = MAX( 1, DESCX( M_ ) )
      LDY = MAX( 1, DESCY( M_ ) )
*
*     Compute expected result in A using data in A, X and Y.
*     Compute gauges in G. This part of the computation is performed
*     by every process in the mesh.
*
      DO 50 J = 1, N
*
         IOFFY = IY + ( JY - 1 ) * LDY + ( J - 1 ) * INCY
*
         IF( LOWER ) THEN
            IBEG = J
            IEND = M
         ELSE IF( UPPER ) THEN
            IBEG = 1
            IEND = J
         ELSE
            IBEG = 1
            IEND = M
         END IF
*
         DO 10 I = IBEG, IEND
            IOFFX = IX + ( JX - 1 ) * LDX + ( I - 1 ) * INCX
            IOFFA = IA + I - 1 + ( JA + J - 2 ) * LDA
            IF( CTRAN ) THEN
               ATMP = X( IOFFX ) * DCONJG( Y( IOFFY ) )
            ELSE
               ATMP = X( IOFFX ) * Y( IOFFY )
            END IF
            GTMP = ABS1( X( IOFFX ) ) * ABS1( Y( IOFFY ) )
            G( I ) = ABS1( ALPHA ) * GTMP + ABS1( A( IOFFA ) )
            A( IOFFA ) = ALPHA*ATMP + A( IOFFA )
*
   10    CONTINUE
*
*        Compute the error ratio for this result.
*
         INFO = 0
         ERR  = ZERO
         LDPA = DESCA( LLD_ )
         IOFFA = IA + ( JA + J - 2 ) * LDA
         CALL INFOG2L( IA, JA+J-1, DESCA, NPROW, NPCOL, MYROW, MYCOL,
     $                 IIA, JJA, IAROW, IACOL )
*
         IF( MYCOL.EQ.IACOL ) THEN
*
            ICURROW = IAROW
            IN = MIN( ICEIL( IA, DESCA( MB_ ) ) * DESCA( MB_ ), IA+M-1 )
            IB = IN - IA + 1
*
            DO 20 I = IA, IN
*
               IF( MYROW.EQ.ICURROW ) THEN
                  ERRI = ABS( PA( IIA+(JJA-1)*LDPA ) - A( IOFFA ) )/EPS
                  IF( G( I-IA+1 ).NE.ZERO )
     $               ERRI = ERRI / G( I-IA+1 )
                  ERR = MAX( ERR, ERRI )
                  IF( ERR*SQRT( EPS ).GE.ONE )
     $               INFO = 1
                  IIA = IIA + 1
               END IF
*
               IOFFA = IOFFA + 1
*
   20       CONTINUE
*
            ICURROW = MOD( ICURROW+1, NPROW )
*
            DO 40 I = IN+1, IA+M-1, DESCA( MB_ )
               IB = MIN( IA+M-I, DESCA( MB_ ) )
*
               DO 30 KK = 0, IB-1
*
                  IF( MYROW.EQ.ICURROW ) THEN
                     ERRI = ABS( PA( IIA+(JJA-1)*LDPA )-A( IOFFA ) )/EPS
                     IF( G( I+KK-IA+1 ).NE.ZERO )
     $                  ERRI = ERRI / G( I+KK-IA+1 )
                     ERR = MAX( ERR, ERRI )
                     IF( ERR*SQRT( EPS ).GE.ONE )
     $                  INFO = 1
                     IIA = IIA + 1
                  END IF
*
                  IOFFA = IOFFA + 1
*
   30          CONTINUE
*
               ICURROW = MOD( ICURROW+1, NPROW )
*
   40       CONTINUE
*
         END IF
*
*        If INFO = 0, all results are at least half accurate.
*
         CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, -1, MYCOL )
         CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERR, 1, I, J, -1, -1,
     $                 MYCOL )
         IF( INFO.NE.0 )
     $      GO TO 60
*
   50 CONTINUE
*
   60 CONTINUE
*
      RETURN
*
*     End of PZVMCH
*
      END
      SUBROUTINE PZVMCH2( ICTXT, UPLO, M, N, ALPHA, X, IX, JX, DESCX,
     $                    INCX, Y, IY, JY, DESCY, INCY, A, PA, IA, JA,
     $                    DESCA, G, ERR, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            ICTXT, IA, INCX, INCY, INFO, IX, IY, JA, JX,
     $                   JY, M, N
      DOUBLE PRECISION   ERR
      COMPLEX*16         ALPHA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCX( * ), DESCY( * )
      DOUBLE PRECISION   G( * )
      COMPLEX*16         A( * ), PA( * ), X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*  PZVMCH2 checks the results of the computational tests.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  UPLO    (global input) CHARACTER
*          UPLO specifies which part of the matrix A is to be
*          referenced:
*             If UPLO = 'L', only the lower triangular part,
*             If UPLO = 'U', only the upper triangular part,
*             else the entire matrix is to be referenced.
*
*  M       (global input) INTEGER
*          The number of rows of the operand matrix A. M >= 0.
*
*  N       (global input) INTEGER
*          The number of rows of the operand matrix A. N >= 0.
*
*  ALPHA   (global input) COMPLEX*16
*          The scalar alpha.
*
*  X       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( M_ ),*). This array
*          contains a local copy of the initial entire distributed
*          matrix.
*
*  IX      (global input) INTEGER
*          The row index in the global array X indicating the first
*          row of sub( X ).
*
*  JX      (global input) INTEGER
*          The column index in the global array X indicating the
*          first column of sub( X ).
*
*  DESCX   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix X.
*
*  INCX    (global input) INTEGER
*          The global increment for the elements of X. Only two values
*          of INCX are supported in this version, namely 1 and M_X.
*          INCX must not be zero.
*
*  Y       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCY( M_ ),*). This array
*          contains a local copy of the initial entire distributed
*          matrix PY.
*
*  IY      (global input) INTEGER
*          The row index in the global array Y indicating the first
*          row of sub( Y ).
*
*  JY      (global input) INTEGER
*          The column index in the global array Y indicating the
*          first column of sub( Y ).
*
*  DESCY   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix Y.
*
*  INCY    (global input) INTEGER
*          The global increment for the elements of Y. Only two values
*          of INCY are supported in this version, namely 1 and M_Y.
*          INCY must not be zero.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCX( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  PA      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PA.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  G       (workspace) DOUBLE PRECISION array of dimension >= MAX(M,N).
*          G is used to compute the gauges.
*
*  ERR     (global output) DOUBLE PRECISION
*          The largest error in absolute value.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO <> 0, the result is less than half accurate.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            LOWER, UPPER
      INTEGER            I, IB, IBEG, ICURROW, IEND, IIA, JJA, IN,
     $                   IOFFA, IOFFXI, IOFFXJ, IOFFYI, IOFFYJ, IACOL,
     $                   IAROW, J, KK, LDA, LDPA, LDX, LDY, MYCOL,
     $                   MYROW, NPCOL, NPROW
      DOUBLE PRECISION   EPS, ERRI, GTMP
      COMPLEX*16         C, ATMP
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, IGSUM2D, DGAMX2D
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ICEIL, LSAME, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DCONJG, DIMAG, MAX, MIN, MOD, SQRT
*     ..
*     .. Statement Functions ..
      DOUBLE PRECISION   ABS1
*     ..
*     .. Statement Function definitions ..
      ABS1( C ) = ABS( DBLE( C ) ) + ABS( DIMAG( C ) )
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      UPPER = LSAME( UPLO, 'U' )
      LOWER = LSAME( UPLO, 'L' )
*
      LDA = MAX( 1, DESCA( M_ ) )
      LDX = MAX( 1, DESCX( M_ ) )
      LDY = MAX( 1, DESCY( M_ ) )
*
*     Compute expected result in A using data in A, X and Y.
*     Compute gauges in G. This part of the computation is performed
*     by every process in the mesh.
*
      DO 50 J = 1, N
*
         IOFFXJ = IX + ( JX - 1 ) * LDX + ( J - 1 ) * INCX
         IOFFYJ = IY + ( JY - 1 ) * LDY + ( J - 1 ) * INCY
*
         IF( LOWER ) THEN
            IBEG = J
            IEND = M
         ELSE IF( UPPER ) THEN
            IBEG = 1
            IEND = J
         ELSE
            IBEG = 1
            IEND = M
         END IF
*
         DO 10 I = IBEG, IEND
            IOFFA = IA + I - 1 + ( JA + J - 2 ) * LDA
            IOFFXI = IX + ( JX - 1 ) * LDX + ( I - 1 ) * INCX
            IOFFYI = IY + ( JY - 1 ) * LDY + ( I - 1 ) * INCY
            ATMP = ALPHA * X( IOFFXI ) * DCONJG( Y( IOFFYJ ) )
            ATMP = ATMP + Y( IOFFYI ) * DCONJG( ALPHA * X( IOFFXJ ) )
            GTMP = ABS1( ALPHA * X( IOFFXI ) ) * ABS1( Y( IOFFYJ ) )
            GTMP = GTMP + ABS1( Y( IOFFYI ) ) *
     $                    ABS1( DCONJG( ALPHA * X( IOFFXJ ) ) )
            G( I ) = GTMP + ABS1( A( IOFFA ) )
            A( IOFFA ) = A( IOFFA ) + ATMP
*
   10    CONTINUE
*
*        Compute the error ratio for this result.
*
         INFO = 0
         ERR  = ZERO
         LDPA = DESCA( LLD_ )
         IOFFA = IA + ( JA + J - 2 ) * LDA
         CALL INFOG2L( IA, JA+J-1, DESCA, NPROW, NPCOL, MYROW, MYCOL,
     $                 IIA, JJA, IAROW, IACOL )
*
         IF( MYCOL.EQ.IACOL ) THEN
*
            ICURROW = IAROW
            IN = MIN( ICEIL( IA, DESCA( MB_ ) ) * DESCA( MB_ ), IA+M-1 )
            IB = IN - IA + 1
*
            DO 20 I = IA, IN
*
               IF( MYROW.EQ.ICURROW ) THEN
                  ERRI = ABS( PA( IIA+(JJA-1)*LDPA ) - A( IOFFA ) )/EPS
                  IF( G( I-IA+1 ).NE.ZERO )
     $               ERRI = ERRI / G( I-IA+1 )
                  ERR = MAX( ERR, ERRI )
                  IF( ERR*SQRT( EPS ).GE.ONE )
     $               INFO = 1
                  IIA = IIA + 1
               END IF
*
               IOFFA = IOFFA + 1
*
   20       CONTINUE
*
            ICURROW = MOD( ICURROW+1, NPROW )
*
            DO 40 I = IN+1, IA+M-1, DESCA( MB_ )
               IB = MIN( IA+M-I, DESCA( MB_ ) )
*
               DO 30 KK = 0, IB-1
*
                  IF( MYROW.EQ.ICURROW ) THEN
                     ERRI = ABS( PA( IIA+(JJA-1)*LDPA )-A( IOFFA ) )/EPS
                     IF( G( I+KK-IA+1 ).NE.ZERO )
     $                  ERRI = ERRI / G( I+KK-IA+1 )
                     ERR = MAX( ERR, ERRI )
                     IF( ERR*SQRT( EPS ).GE.ONE )
     $                  INFO = 1
                     IIA = IIA + 1
                  END IF
*
                  IOFFA = IOFFA + 1
*
   30          CONTINUE
*
               ICURROW = MOD( ICURROW+1, NPROW )
*
   40       CONTINUE
*
         END IF
*
*        If INFO = 0, all results are at least half accurate.
*
         CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, -1, MYCOL )
         CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERR, 1, I, J, -1, -1,
     $                 MYCOL )
         IF( INFO.NE.0 )
     $      GO TO 60
*
   50 CONTINUE
*
   60 CONTINUE
*
      RETURN
*
*     End of PZVMCH2
*
      END
      SUBROUTINE PZMMCH( ICTXT, TRANSA, TRANSB, M, N, K, ALPHA, A, IA,
     $                   JA, DESCA, B, IB, JB, DESCB, BETA, C, PC, IC,
     $                   JC, DESCC, CT, G, ERR, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          TRANSA, TRANSB
      INTEGER            ICTXT, IA, IB, IC, INFO, JA, JB, JC, K, M, N
      DOUBLE PRECISION   ERR
      COMPLEX*16         ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * ), DESCC( * )
      DOUBLE PRECISION   G( * )
      COMPLEX*16         A( * ), B( * ), C( * ), CT( * ), PC( * )
*     ..
*
*  Purpose
*  =======
*
*  PZMMCH checks the results of the computational tests.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  TRANSA  (global input) CHARACTER
*          TRANSA specifies whether the matrix A has to be transposed
*          or not before computing the matrix-matrix product.
*
*  TRANSB  (global input) CHARACTER
*          TRANSB specifies whether the matrix B has to be transposed
*          or not before computing the matrix-matrix product.
*
*  M       (global input) INTEGER
*          The number of rows of the operand matrix C. M >= 0.
*
*  N       (global input) INTEGER
*          The number of rows of the operand matrix C. N >= 0.
*
*  K       (global input) INTEGER
*          The number of columns (resp. rows) of A when TRANSA = 'N'
*          (resp. TRANSA <> 'N') in PxGEMM, PxSYRK, PxSYR2K, PxHERK
*          and PxHER2K.
*
*  ALPHA   (global input) COMPLEX*16
*          The scalar alpha.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  B       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCB( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IB      (global input) INTEGER
*          The row index in the global array B indicating the first
*          row of sub( B ).
*
*  JB      (global input) INTEGER
*          The column index in the global array B indicating the
*          first column of sub( B ).
*
*  DESCB   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix B.
*
*  BETA    (global input) COMPLEX*16
*          The scalar beta.
*
*  C       (local input/local output) COMPLEX*16 pointer into the
*          local memory to an array of dimension (DESCC( M_ ),*). This
*          array contains a local copy of the initial entire distribu-
*          ted matrix PC.
*
*  PC      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCC( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PC.
*
*  IC      (global input) INTEGER
*          The row index in the global array C indicating the first
*          row of sub( C ).
*
*  JC      (global input) INTEGER
*          The column index in the global array C indicating the
*          first column of sub( C ).
*
*  DESCC   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix C.
*
*  CT      (workspace) COMPLEX*16 array, dimension >= MAX(M,N,K).
*          CT holds a copy of the current column of C.
*
*  G       (workspace) DOUBLE PRECISION array, dimension >= MAX(M,N,K).
*          G is used to compute the gauges.
*
*  ERR     (global output) DOUBLE PRECISION
*          The largest error in absolute value.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO <> 0, the result is less than half accurate.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   RZERO, RONE
      PARAMETER          ( RZERO = 0.0D+0, RONE = 1.0D+0 )
      COMPLEX*16         ZERO
      PARAMETER          ( ZERO = ( 0.0D+0, 0.0D+0 ) )
*     ..
*     .. Local Scalars ..
      LOGICAL            CTRANA, CTRANB, TRANA, TRANB
      INTEGER            I, IBB, ICURROW, IIC, JJC, IN, IOFFA, IOFFB,
     $                   IOFFC, ICCOL, ICROW, J, KK, LDA, LDPC, LDB,
     $                   LDC, MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   EPS, ERRI
      COMPLEX*16         Z
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, IGSUM2D, DGAMX2D
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ICEIL, LSAME, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DCONJG, DIMAG, MAX, MIN, MOD, SQRT
*     ..
*     .. Statement Functions ..
      DOUBLE PRECISION   ABS1
*     ..
*     .. Statement Function definitions ..
      ABS1( Z ) = ABS( DBLE( Z ) ) + ABS( DIMAG( Z ) )
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      TRANA = LSAME( TRANSA, 'T' ).OR.LSAME( TRANSA, 'C' )
      TRANB = LSAME( TRANSB, 'T' ).OR.LSAME( TRANSB, 'C' )
      CTRANA = LSAME( TRANSA, 'C' )
      CTRANB = LSAME( TRANSB, 'C' )
*
      LDA = MAX( 1, DESCA( M_ ) )
      LDB = MAX( 1, DESCB( M_ ) )
      LDC = MAX( 1, DESCC( M_ ) )
*
*     Compute expected result in C using data in A, B and C.
*     Compute gauges in G. This part of the computation is performed
*     by every process in the mesh.
*
      DO 240 J = 1, N
*
         IOFFC = IC + ( JC + J - 2 ) * LDC
         DO 10 I = 1, M
            CT( I ) = ZERO
            G( I )  = RZERO
   10    CONTINUE
*
         IF( .NOT.TRANA .AND. .NOT.TRANB ) THEN
            DO 30 KK = 1, K
               IOFFB = IB + KK - 1 + ( JB + J - 2 ) * LDB
               DO 20 I = 1, M
                  IOFFA = IA + I - 1 + ( JA + KK - 2 ) * LDA
                  CT( I ) = CT( I ) + A( IOFFA ) * B( IOFFB )
                  G( I ) = G( I ) + ABS( A( IOFFA ) ) *
     $                     ABS( B( IOFFB ) )
   20          CONTINUE
   30       CONTINUE
         ELSE IF( TRANA .AND. .NOT.TRANB ) THEN
            IF( CTRANA ) THEN
               DO 50 KK = 1, K
                  IOFFB = IB + KK - 1 + ( JB + J - 2 ) * LDB
                  DO 40 I = 1, M
                     IOFFA = IA + KK - 1 + ( JA + I - 2 ) * LDA
                     CT( I ) = CT( I ) + DCONJG( A( IOFFA ) ) *
     $                                   B( IOFFB )
                     G( I ) = G( I ) + ABS1( A( IOFFA ) ) *
     $                        ABS1( B( IOFFB ) )
   40             CONTINUE
   50          CONTINUE
            ELSE
               DO 70 KK = 1, K
                  IOFFB = IB + KK - 1 + ( JB + J - 2 ) * LDB
                  DO 60 I = 1, M
                     IOFFA = IA + KK - 1 + ( JA + I - 2 ) * LDA
                     CT( I ) = CT( I ) + A( IOFFA ) * B( IOFFB )
                     G( I ) = G( I ) + ABS1( A( IOFFA ) ) *
     $                        ABS1( B( IOFFB ) )
   60             CONTINUE
   70          CONTINUE
            END IF
         ELSE IF( .NOT.TRANA .AND. TRANB ) THEN
            IF( CTRANB ) THEN
               DO 90 KK = 1, K
                  IOFFB = IB + J - 1 + ( JB + KK - 2 ) * LDB
                  DO 80 I = 1, M
                     IOFFA = IA + I - 1 + ( JA + KK - 2 ) * LDA
                     CT( I ) = CT( I ) + A( IOFFA ) *
     $                                   DCONJG( B( IOFFB ) )
                     G( I ) = G( I ) + ABS1( A( IOFFA ) ) *
     $                        ABS1( B( IOFFB ) )
   80             CONTINUE
   90          CONTINUE
            ELSE
               DO 110 KK = 1, K
                  IOFFB = IB + J - 1 + ( JB + KK - 2 ) * LDB
                  DO 100 I = 1, M
                     IOFFA = IA + I - 1 + ( JA + KK - 2 ) * LDA
                     CT( I ) = CT( I ) + A( IOFFA ) * B( IOFFB )
                     G( I ) = G( I ) + ABS1( A( IOFFA ) ) *
     $                        ABS1( B( IOFFB ) )
  100             CONTINUE
  110          CONTINUE
            END IF
         ELSE IF( TRANA .AND. TRANB ) THEN
            IF( CTRANA ) THEN
               IF( CTRANB ) THEN
                  DO 130 KK = 1, K
                     IOFFB = IB + J - 1 + ( JB + KK - 2 ) * LDB
                     DO 120 I = 1, M
                        IOFFA = IA + KK - 1 + ( JA + I - 2 ) * LDA
                        CT( I ) = CT( I ) + DCONJG( A( IOFFA ) ) *
     $                                      DCONJG( B( IOFFB ) )
                        G( I ) = G( I ) + ABS1( A( IOFFA ) ) *
     $                           ABS1( B( IOFFB ) )
  120                CONTINUE
  130             CONTINUE
               ELSE
                  DO 150 KK = 1, K
                     IOFFB = IB + J - 1 + ( JB + KK - 2 ) * LDB
                     DO 140 I = 1, M
                        IOFFA = IA + KK - 1 + ( JA + I - 2 ) * LDA
                        CT( I ) = CT( I ) + DCONJG( A( IOFFA ) ) *
     $                                      B( IOFFB )
                        G( I ) = G( I ) + ABS1( A( IOFFA ) ) *
     $                           ABS1( B( IOFFB ) )
  140                CONTINUE
  150             CONTINUE
               END IF
            ELSE
               IF( CTRANB ) THEN
                  DO 170 KK = 1, K
                     IOFFB = IB + J - 1 + ( JB + KK - 2 ) * LDB
                     DO 160 I = 1, M
                        IOFFA = IA + KK - 1 + ( JA + I - 2 ) * LDA
                        CT( I ) = CT( I ) + A( IOFFA ) *
     $                                      DCONJG( B( IOFFB ) )
                        G( I ) = G( I ) + ABS1( A( IOFFA ) ) *
     $                           ABS1( B( IOFFB ) )
  160                CONTINUE
  170             CONTINUE
               ELSE
                  DO 190 KK = 1, K
                     IOFFB = IB + J - 1 + ( JB + KK - 2 ) * LDB
                     DO 180 I = 1, M
                        IOFFA = IA + KK - 1 + ( JA + I - 2 ) * LDA
                        CT( I ) = CT( I ) + A( IOFFA ) * B( IOFFB )
                        G( I ) = G( I ) + ABS1( A( IOFFA ) ) *
     $                           ABS1( B( IOFFB ) )
  180                CONTINUE
  190             CONTINUE
               END IF
            END IF
         END IF
*
         DO 200 I = 1, M
            CT( I ) = ALPHA*CT( I ) + BETA * C( IOFFC )
            G( I ) = ABS1( ALPHA )*G( I ) +
     $               ABS1( BETA )*ABS1( C( IOFFC ) )
            C( IOFFC ) = CT( I )
            IOFFC = IOFFC + 1
  200    CONTINUE
*
*        Compute the error ratio for this result.
*
         ERR  = RZERO
         INFO = 0
         LDPC = DESCC( LLD_ )
         IOFFC = IC + ( JC + J - 2 ) * LDC
         CALL INFOG2L( IC, JC+J-1, DESCC, NPROW, NPCOL, MYROW, MYCOL,
     $                 IIC, JJC, ICROW, ICCOL )
         ICURROW = ICROW
*
         IF( MYCOL.EQ.ICCOL ) THEN
*
            IN = MIN( ICEIL( IC, DESCC( MB_ ) ) * DESCC( MB_ ), IC+M-1 )
            IBB = IN - IC + 1
*
            DO 210 I = IC, IN
*
               IF( MYROW.EQ.ICURROW ) THEN
                  ERRI = ABS( PC( IIC+(JJC-1)*LDPC ) -
     $                        C( IOFFC ) ) / EPS
                  IF( G( I-IC+1 ).NE.RZERO )
     $               ERRI = ERRI / G( I-IC+1 )
                  ERR = MAX( ERR, ERRI )
                  IF( ERR*SQRT( EPS ).GE.RONE )
     $               INFO = 1
                  IIC = IIC + 1
               END IF
*
               IOFFC = IOFFC + 1
*
  210       CONTINUE
*
            ICURROW = MOD( ICURROW+1, NPROW )
*
            DO 230 I = IN+1, IC+M-1, DESCC( MB_ )
               IBB = MIN( IC+M-I, DESCC( MB_ ) )
*
               DO 220 KK = 0, IBB-1
*
                  IF( MYROW.EQ.ICURROW ) THEN
                     ERRI = ABS( PC( IIC+(JJC-1)*LDPC ) -
     $                           C( IOFFC ) )/EPS
                     IF( G( I+KK-IC+1 ).NE.RZERO )
     $                  ERRI = ERRI / G( I+KK-IC+1 )
                     ERR = MAX( ERR, ERRI )
                     IF( ERR*SQRT( EPS ).GE.RONE )
     $                  INFO = 1
                     IIC = IIC + 1
                  END IF
*
                  IOFFC = IOFFC + 1
*
  220          CONTINUE
*
               ICURROW = MOD( ICURROW+1, NPROW )
*
  230       CONTINUE
*
         END IF
*
*        If INFO = 0, all results are at least half accurate.
*
         CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, -1, MYCOL )
         CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERR, 1, I, J, -1, -1,
     $                 MYCOL )
         IF( INFO.NE.0 )
     $      GO TO 250
*
  240 CONTINUE
*
  250 CONTINUE
*
      RETURN
*
*     End of PZMMCH
*
      END
      SUBROUTINE PZMMCH1( ICTXT, UPLO, TRANS, N, K, ALPHA, A, IA, JA,
     $                    DESCA, BETA, C, PC, IC, JC, DESCC, CT, G,
     $                    ERR, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          TRANS, UPLO
      INTEGER            ICTXT, IA, IC, INFO, JA, JC, K, N
      DOUBLE PRECISION   ERR
      COMPLEX*16         ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCC( * )
      DOUBLE PRECISION   G( * )
      COMPLEX*16         A( * ), C( * ), CT( * ), PC( * )
*     ..
*
*  Purpose
*  =======
*
*  PZMMCH1 checks the results of the computational tests.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  UPLO    (global input) CHARACTER
*          UPLO specifies which part of C should contain the result.
*
*  TRANS   (global input) CHARACTER
*          TRANSA specifies whether the matrix A has to be transposed
*          or not before computing the matrix-matrix product.
*
*  N       (global input) INTEGER
*          The order the operand matrix C. N >= 0.
*
*  K       (global input) INTEGER
*          The number of columns (resp. rows) of A when TRANSA = 'N'
*          (resp. TRANSA <> 'N').
*
*  ALPHA   (global input) COMPLEX*16
*          The scalar alpha.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  BETA    (global input) COMPLEX*16
*          The scalar beta.
*
*  C       (local input/local output) COMPLEX*16 pointer into the
*          local memory to an array of dimension (DESCC( M_ ),*). This
*          array contains a local copy of the initial entire distribu-
*          ted matrix PY.
*
*  PC      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCC( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PC.
*
*  IC      (global input) INTEGER
*          The row index in the global array C indicating the first
*          row of sub( C ).
*
*  JC      (global input) INTEGER
*          The column index in the global array C indicating the
*          first column of sub( C ).
*
*  DESCC   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix C.
*
*  CT      (workspace) COMPLEX*16 array, dimension >= MAX(M,N,K).
*          CT holds a copy of the current column of C.
*
*  G       (workspace) DOUBLE PRECISION array, dimension >= MAX(M,N,K).
*          G is used to compute the gauges.
*
*  ERR     (global output) DOUBLE PRECISION
*          The largest error in absolute value.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO <> 0, the result is less than half accurate.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   RZERO, RONE
      PARAMETER          ( RZERO = 0.0D+0, RONE = 1.0D+0 )
      COMPLEX*16         ZERO
      PARAMETER          ( ZERO = ( 0.0D+0, 0.0D+0 ) )
*     ..
*     .. Local Scalars ..
      LOGICAL            HTRAN, NOTRAN, TRAN, UPPER
      INTEGER            I, IBB, IBEG, IEND, ICURROW, IIC, JJC, IN,
     $                   IOFFAK, IOFFAN, IOFFC, ICCOL, ICROW, J, KK,
     $                   LDA, LDPC, LDC, MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   EPS, ERRI
      COMPLEX*16         Z
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, IGSUM2D, DGAMX2D
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ICEIL, LSAME, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DCONJG, DIMAG, MAX, MIN, MOD, SQRT
*     ..
*     .. Statement Functions ..
      DOUBLE PRECISION   ABS1
*     ..
*     .. Statement Function definitions ..
      ABS1( Z ) = ABS( DBLE( Z ) ) + ABS( DIMAG( Z ) )
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      UPPER = LSAME( UPLO, 'U' )
      NOTRAN = LSAME( TRANS, 'N' )
      TRAN = LSAME( TRANS, 'T' )
      HTRAN = LSAME( TRANS, 'H' )
*
      LDA = MAX( 1, DESCA( M_ ) )
      LDC = MAX( 1, DESCC( M_ ) )
*
*     Compute expected result in C using data in A, B and C.
*     Compute gauges in G. This part of the computation is performed
*     by every process in the mesh.
*
      DO 140 J = 1, N
*
         IF( UPPER ) THEN
            IBEG = 1
            IEND = J
         ELSE
            IBEG = J
            IEND = N
         END IF
*
         DO 10 I = IBEG, IEND
            CT( I ) = ZERO
            G( I )  = RZERO
   10    CONTINUE
*
         IF( NOTRAN ) THEN
            DO 30 KK = 1, K
               IOFFAK = IA + J - 1 + ( JA + KK - 2 ) * LDA
               DO 20 I = IBEG, IEND
                  IOFFAN = IA + I - 1 + ( JA + KK - 2 ) * LDA
                  CT( I ) = CT( I ) + A( IOFFAK ) * A( IOFFAN )
                  G( I ) = G( I ) + ABS1( A( IOFFAK ) ) *
     $                     ABS1( A( IOFFAN ) )
   20          CONTINUE
   30       CONTINUE
         ELSE IF( TRAN ) THEN
            DO 50 KK = 1, K
               IOFFAK = IA + KK - 1 + ( JA + J - 2 ) * LDA
               DO 40 I = IBEG, IEND
                  IOFFAN = IA + KK - 1 + ( JA + I - 2 ) * LDA
                  CT( I ) = CT( I ) + A( IOFFAK ) * A( IOFFAN )
                  G( I ) = G( I ) + ABS1( A( IOFFAK ) ) *
     $                     ABS1( A( IOFFAN ) )
   40          CONTINUE
   50       CONTINUE
         ELSE IF( HTRAN ) THEN
            DO 70 KK = 1, K
               IOFFAK = IA + J - 1 + ( JA + KK - 2 ) * LDA
               DO 60 I = IBEG, IEND
                  IOFFAN = IA + I - 1 + ( JA + KK - 2 ) * LDA
                  CT( I ) = CT( I ) + A( IOFFAN ) *
     $                      DCONJG( A( IOFFAK ) )
                  G( I ) = G( I ) + ABS1( A( IOFFAK ) ) *
     $                     ABS1( A( IOFFAN ) )
   60          CONTINUE
   70       CONTINUE
         ELSE
            DO 90 KK = 1, K
               IOFFAK = IA + KK - 1 + ( JA + J - 2 ) * LDA
               DO 80 I = IBEG, IEND
                  IOFFAN = IA + KK - 1 + ( JA + I - 2 ) * LDA
                  CT( I ) = CT( I ) + DCONJG( A( IOFFAN ) ) *
     $                      A( IOFFAK )
                  G( I ) = G( I ) + ABS1( DCONJG( A( IOFFAN ) ) ) *
     $                     ABS1( A( IOFFAK ) )
   80          CONTINUE
   90       CONTINUE
         END IF
*
         IOFFC = IC + IBEG - 1 + ( JC + J - 2 ) * LDC
*
         DO 100 I = IBEG, IEND
            CT( I ) = ALPHA*CT( I ) + BETA * C( IOFFC )
            G( I ) = ABS1( ALPHA )*G( I ) +
     $               ABS1( BETA )*ABS1( C( IOFFC ) )
            C( IOFFC ) = CT( I )
            IOFFC = IOFFC + 1
  100    CONTINUE
*
*        Compute the error ratio for this result.
*
         ERR  = RZERO
         INFO = 0
         LDPC = DESCC( LLD_ )
         IOFFC = IC + ( JC + J - 2 ) * LDC
         CALL INFOG2L( IC, JC+J-1, DESCC, NPROW, NPCOL, MYROW, MYCOL,
     $                 IIC, JJC, ICROW, ICCOL )
         ICURROW = ICROW
*
         IF( MYCOL.EQ.ICCOL ) THEN
*
            IN = MIN( ICEIL( IC, DESCC( MB_ ) ) * DESCC( MB_ ), IC+N-1 )
            IBB = IN - IC + 1
*
            DO 110 I = IC, IN
*
               IF( MYROW.EQ.ICURROW ) THEN
                  ERRI = ABS( PC( IIC+(JJC-1)*LDPC ) -
     $                        C( IOFFC ) ) / EPS
                  IF( G( I-IC+1 ).NE.RZERO )
     $               ERRI = ERRI / G( I-IC+1 )
                  ERR = MAX( ERR, ERRI )
                  IF( ERR*SQRT( EPS ).GE.RONE )
     $               INFO = 1
                  IIC = IIC + 1
               END IF
*
               IOFFC = IOFFC + 1
*
  110       CONTINUE
*
            ICURROW = MOD( ICURROW+1, NPROW )
*
            DO 130 I = IN+1, IC+N-1, DESCC( MB_ )
               IBB = MIN( IC+N-I, DESCC( MB_ ) )
*
               DO 120 KK = 0, IBB-1
*
                  IF( MYROW.EQ.ICURROW ) THEN
                     ERRI = ABS( PC( IIC+(JJC-1)*LDPC ) -
     $                           C( IOFFC ) )/EPS
                     IF( G( I+KK-IC+1 ).NE.RZERO )
     $                  ERRI = ERRI / G( I+KK-IC+1 )
                     ERR = MAX( ERR, ERRI )
                     IF( ERR*SQRT( EPS ).GE.RONE )
     $                  INFO = 1
                     IIC = IIC + 1
                  END IF
*
                  IOFFC = IOFFC + 1
*
  120          CONTINUE
*
               ICURROW = MOD( ICURROW+1, NPROW )
*
  130       CONTINUE
*
         END IF
*
*        If INFO = 0, all results are at least half accurate.
*
         CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, -1, MYCOL )
         CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERR, 1, I, J, -1, -1,
     $                 MYCOL )
         IF( INFO.NE.0 )
     $      GO TO 150
*
  140 CONTINUE
*
  150 CONTINUE
*
      RETURN
*
*     End of PZMMCH1
*
      END
      SUBROUTINE PZMMCH2( ICTXT, UPLO, TRANS, N, K, ALPHA, A, IA, JA,
     $                    DESCA, B, IB, JB, DESCB, BETA, C, PC, IC, JC,
     $                    DESCC, CT, G, ERR, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          TRANS, UPLO
      INTEGER            ICTXT, IA, IB, IC, INFO, JA, JB, JC, K, N
      DOUBLE PRECISION   ERR
      COMPLEX*16         ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * ), DESCC( * )
      DOUBLE PRECISION   G( * )
      COMPLEX*16         A( * ), B( * ), C( * ), CT( * ),
     $                   PC( * )
*     ..
*
*  Purpose
*  =======
*
*  PZMMCH2 checks the results of the computational tests.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  UPLO    (global input) CHARACTER
*          UPLO specifies which part of C should contain the result.
*
*  TRANS   (global input) CHARACTER
*          TRANSA specifies whether the matrix A has to be transposed
*          or not before computing the matrix-matrix product.
*
*  N       (global input) INTEGER
*          The order the operand matrix C. N >= 0.
*
*  K       (global input) INTEGER
*          The number of columns (resp. rows) of A when TRANSA = 'N'
*          (resp. TRANSA <> 'N').
*
*  ALPHA   (global input) COMPLEX*16
*          The scalar alpha.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  B       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCB( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IB      (global input) INTEGER
*          The row index in the global array B indicating the first
*          row of sub( B ).
*
*  JB      (global input) INTEGER
*          The column index in the global array B indicating the
*          first column of sub( B ).
*
*  DESCB   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix B.
*
*  BETA    (global input) COMPLEX*16
*          The scalar beta.
*
*  C       (local input/local output) COMPLEX*16 pointer into the
*          local memory to an array of dimension (DESCC( M_ ),*). This
*          array contains a local copy of the initial entire distribu-
*          ted matrix PY.
*
*  PC      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCC( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PC.
*
*  IC      (global input) INTEGER
*          The row index in the global array C indicating the first
*          row of sub( C ).
*
*  JC      (global input) INTEGER
*          The column index in the global array C indicating the
*          first column of sub( C ).
*
*  DESCC   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix C.
*
*  CT      (workspace) COMPLEX*16 array, dimension >= MAX(M,N,K).
*          CT holds a copy of the current column of C.
*
*  G       (workspace) DOUBLE PRECISION array, dimension >= MAX(M,N,K).
*          G is used to compute the gauges.
*
*  ERR     (global output) DOUBLE PRECISION
*          The largest error in absolute value.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO <> 0, the result is less than half accurate.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   RZERO, RONE
      PARAMETER          ( RZERO = 0.0D+0, RONE = 1.0D+0 )
      COMPLEX*16         ZERO
      PARAMETER          ( ZERO = ( 0.0D+0, 0.0D+0 ) )
*     ..
*     .. Local Scalars ..
      LOGICAL            HTRAN, NOTRAN, TRAN, UPPER
      INTEGER            I, IBB, IBEG, IEND, ICURROW, IIC, JJC, IN,
     $                   IOFFAK, IOFFAN, IOFFBK, IOFFBN, IOFFC, ICCOL,
     $                   ICROW, J, KK, LDA, LDB, LDPC, LDC, MYCOL,
     $                   MYROW, NPCOL, NPROW
      DOUBLE PRECISION   EPS, ERRI
      COMPLEX*16         Z
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, IGSUM2D, DGAMX2D
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           ICEIL, LSAME, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DBLE, DCONJG, DIMAG, MAX, MIN, MOD, SQRT
*     ..
*     .. Statement Functions ..
      DOUBLE PRECISION   ABS1
*     ..
*     .. Statement Function definitions ..
      ABS1( Z ) = ABS( DBLE( Z ) ) + ABS( DIMAG( Z ) )
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      EPS = PDLAMCH( ICTXT, 'eps' )
*
      UPPER = LSAME( UPLO, 'U' )
      HTRAN = LSAME( TRANS, 'H' )
      NOTRAN = LSAME( TRANS, 'N' )
      TRAN = LSAME( TRANS, 'T' )
*
      LDA = MAX( 1, DESCA( M_ ) )
      LDB = MAX( 1, DESCB( M_ ) )
      LDC = MAX( 1, DESCC( M_ ) )
*
*     Compute expected result in C using data in A, B and C.
*     Compute gauges in G. This part of the computation is performed
*     by every process in the mesh.
*
      DO 140 J = 1, N
*
         IF( UPPER ) THEN
            IBEG = 1
            IEND = J
         ELSE
            IBEG = J
            IEND = N
         END IF
*
         DO 10 I = IBEG, IEND
            CT( I ) = ZERO
            G( I )  = RZERO
   10    CONTINUE
*
         IF( NOTRAN ) THEN
            DO 30 KK = 1, K
               IOFFAK = IA + J - 1 + ( JA + KK - 2 ) * LDA
               IOFFBK = IB + J - 1 + ( JB + KK - 2 ) * LDB
               DO 20 I = IBEG, IEND
                  IOFFAN = IA + I - 1 + ( JA + KK - 2 ) * LDA
                  IOFFBN = IB + I - 1 + ( JB + KK - 2 ) * LDB
                  CT( I ) = CT( I ) + ALPHA * (
     $                      A( IOFFAN ) * B( IOFFBK ) +
     $                      B( IOFFBN ) * A( IOFFAK ) )
                  G( I ) = G( I ) + ABS( ALPHA ) * (
     $                     ABS1( A( IOFFAN ) ) * ABS1( B( IOFFBK ) ) +
     $                     ABS1( B( IOFFBN ) ) * ABS1( A( IOFFAK ) ) )
   20          CONTINUE
   30       CONTINUE
         ELSE IF( TRAN ) THEN
            DO 50 KK = 1, K
               IOFFAK = IA + KK - 1 + ( JA + J - 2 ) * LDA
               IOFFBK = IB + KK - 1 + ( JB + J - 2 ) * LDB
               DO 40 I = IBEG, IEND
                  IOFFAN = IA + KK - 1 + ( JA + I - 2 ) * LDA
                  IOFFBN = IB + KK - 1 + ( JB + I - 2 ) * LDB
                  CT( I ) = CT( I ) + ALPHA * (
     $                      A( IOFFAN ) * B( IOFFBK ) +
     $                      B( IOFFBN ) * A( IOFFAK ) )
                  G( I ) = G( I ) + ABS( ALPHA ) * (
     $                     ABS1( A( IOFFAN ) ) * ABS1( B( IOFFBK ) ) +
     $                     ABS1( B( IOFFBN ) ) * ABS1( A( IOFFAK ) ) )
   40          CONTINUE
   50       CONTINUE
         ELSE IF( HTRAN ) THEN
            DO 70 KK = 1, K
               IOFFAK = IA + J - 1 + ( JA + KK - 2 ) * LDA
               IOFFBK = IB + J - 1 + ( JB + KK - 2 ) * LDB
               DO 60 I = IBEG, IEND
                  IOFFAN = IA + I - 1 + ( JA + KK - 2 ) * LDA
                  IOFFBN = IB + I - 1 + ( JB + KK - 2 ) * LDB
                  CT( I ) = CT( I ) +
     $                ALPHA * A( IOFFAN ) * DCONJG( B( IOFFBK ) ) +
     $                B( IOFFBN ) * DCONJG( ALPHA * A( IOFFAK ) )
                  G( I ) = G( I ) + ABS1( ALPHA ) * (
     $                     ABS1( A( IOFFAN ) ) * ABS1( B( IOFFBK ) ) +
     $                     ABS1( B( IOFFBN ) ) * ABS1( A( IOFFAK ) ) )
   60          CONTINUE
   70       CONTINUE
         ELSE
            DO 90 KK = 1, K
               IOFFAK = IA + KK - 1 + ( JA + J - 2 ) * LDA
               IOFFBK = IB + KK - 1 + ( JB + J - 2 ) * LDB
               DO 80 I = IBEG, IEND
                  IOFFAN = IA + KK - 1 + ( JA + I - 2 ) * LDA
                  IOFFBN = IB + KK - 1 + ( JB + I - 2 ) * LDB
                  CT( I ) = CT( I ) +
     $                   ALPHA * DCONJG( A( IOFFAN ) ) * B( IOFFBK ) +
     $                   DCONJG( ALPHA * B( IOFFBN ) ) * A( IOFFAK )
                  G( I ) = G( I ) + ABS1( ALPHA ) * (
     $                   ABS1( DCONJG( A( IOFFAN ) ) * B( IOFFBK ) ) +
     $                   ABS1( DCONJG( B( IOFFBN ) ) * A( IOFFAK ) ) )
   80          CONTINUE
   90       CONTINUE
         END IF
*
         IOFFC = IC + IBEG - 1 + ( JC + J - 2 ) * LDC
*
         DO 100 I = IBEG, IEND
            CT( I ) = CT( I ) + BETA * C( IOFFC )
            G( I ) = G( I ) + ABS1( BETA )*ABS1( C( IOFFC ) )
            C( IOFFC ) = CT( I )
            IOFFC = IOFFC + 1
  100    CONTINUE
*
*        Compute the error ratio for this result.
*
         ERR  = RZERO
         INFO = 0
         LDPC = DESCC( LLD_ )
         IOFFC = IC + ( JC + J - 2 ) * LDC
         CALL INFOG2L( IC, JC+J-1, DESCC, NPROW, NPCOL, MYROW, MYCOL,
     $                 IIC, JJC, ICROW, ICCOL )
         ICURROW = ICROW
*
         IF( MYCOL.EQ.ICCOL ) THEN
*
            IN = MIN( ICEIL( IC, DESCC( MB_ ) ) * DESCC( MB_ ), IC+N-1 )
            IBB = IN - IC + 1
*
            DO 110 I = IC, IN
*
               IF( MYROW.EQ.ICURROW ) THEN
                  ERRI = ABS( PC( IIC+(JJC-1)*LDPC ) -
     $                        C( IOFFC ) ) / EPS
                  IF( G( I-IC+1 ).NE.RZERO )
     $               ERRI = ERRI / G( I-IC+1 )
                  ERR = MAX( ERR, ERRI )
                  IF( ERR*SQRT( EPS ).GE.RONE )
     $               INFO = 1
                  IIC = IIC + 1
               END IF
*
               IOFFC = IOFFC + 1
*
  110       CONTINUE
*
            ICURROW = MOD( ICURROW+1, NPROW )
*
            DO 130 I = IN+1, IC+N-1, DESCC( MB_ )
               IBB = MIN( IC+N-I, DESCC( MB_ ) )
*
               DO 120 KK = 0, IBB-1
*
                  IF( MYROW.EQ.ICURROW ) THEN
                     ERRI = ABS( PC( IIC+(JJC-1)*LDPC ) -
     $                           C( IOFFC ) )/EPS
                     IF( G( I+KK-IC+1 ).NE.RZERO )
     $                  ERRI = ERRI / G( I+KK-IC+1 )
                     ERR = MAX( ERR, ERRI )
                     IF( ERR*SQRT( EPS ).GE.RONE )
     $                  INFO = 1
                     IIC = IIC + 1
                  END IF
*
                  IOFFC = IOFFC + 1
*
  120          CONTINUE
*
               ICURROW = MOD( ICURROW+1, NPROW )
*
  130       CONTINUE
*
         END IF
*
*        If INFO = 0, all results are at least half accurate.
*
         CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, -1, MYCOL )
         CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERR, 1, I, J, -1, -1,
     $                 MYCOL )
         IF( INFO.NE.0 )
     $      GO TO 150
*
  140 CONTINUE
*
  150 CONTINUE
*
      RETURN
*
*     End of PZMMCH2
*
      END
      SUBROUTINE PZMMCH3( TRANS, M, N, ALPHA, A, IA, JA, DESCA, BETA,
     $                    C, PC, IC, JC, DESCC, ERR, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          TRANS
      INTEGER            IA, IC, INFO, JA, JC, M, N
      DOUBLE PRECISION   ERR
      COMPLEX*16         ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCC( * )
      COMPLEX*16         A( * ), C( * ), PC( * )
*     ..
*
*  Purpose
*  =======
*
*  PZMMCH3 checks the results of the computational tests.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  TRANS   (global input) CHARACTER
*          TRANS  specifies whether the matrix A has to be transposed
*          or not before computing the matrix-matrix addition.
*
*  M       (global input) INTEGER
*          The number of rows of the operand matrix C. M >= 0.
*
*  N       (global input) INTEGER
*          The number of rows of the operand matrix C. N >= 0.
*
*  ALPHA   (global input) COMPLEX*16
*          The scalar alpha.
*
*  A       (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCA( M_ ),*). This array contains
*          a local copy of the initial entire distributed matrix.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  BETA    (global input) COMPLEX*16
*          The scalar beta.
*
*  C       (local input/local output) COMPLEX*16 pointer into the
*          local memory to an array of dimension (DESCC( M_ ),*). This
*          array contains a local copy of the initial entire distribu-
*          ted matrix PC.
*
*  PC      (local input) COMPLEX*16 pointer into the local memory
*          to an array of dimension (DESCC( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PC.
*
*  IC      (global input) INTEGER
*          The row index in the global array C indicating the first
*          row of sub( C ).
*
*  JC      (global input) INTEGER
*          The column index in the global array C indicating the
*          first column of sub( C ).
*
*  DESCC   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix C.
*
*  ERR     (global output) DOUBLE PRECISION
*          The largest error in absolute value.
*
*  INFO    (global output) INTEGER
*          On exit, if INFO <> 0, the result is less than half accurate.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            CTRAN, NOTRAN
      INTEGER            I, ICCOL, ICROW, ICTXT, IIC, IOFFA, IOFFC, J,
     $                   JJC, LDA, LDC, LDPC, MYCOL, MYROW, NPCOL,
     $                   NPROW
      DOUBLE PRECISION   ERR0, ERRI, PREC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DGAMX2D, IGSUM2D, INFOG2L,
     $                   ZERRAXPBY
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           LSAME, PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, DCONJG, MAX
*     ..
*     .. Executable Statements ..
*
      ICTXT = DESCC( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      PREC = PDLAMCH( ICTXT, 'eps' )
*
      NOTRAN = LSAME( TRANS, 'N' )
      CTRAN = LSAME( TRANS, 'C' )
*
*     Compute expected result in C using data in A and C. This part of
*     the computation is performed by every process in the mesh.
*
      INFO = 0
      ERR = ZERO
*
      LDA = MAX( 1, DESCA( M_ ) )
      LDC = MAX( 1, DESCC( M_ ) )
      LDPC = MAX( 1, DESCC( LLD_ ) )
      IOFFA = IA + ( JA - 1 ) * LDA
      IOFFC = IC + ( JC - 1 ) * LDC
*
      IF( NOTRAN ) THEN
*
         DO 20 J = JC, JC + N - 1
*
            IOFFC = IC + ( J - 1 )*LDC
            IOFFA = IA + ( JA + J - JC )*LDA
*
            DO 10 I = IC, IC + M - 1
*
               CALL ZERRAXPBY( ERRI, ALPHA, A( IOFFA ), BETA,
     $                         C( IOFFC ), PREC )
               CALL INFOG2L( I, J, DESCC, NPROW, NPCOL, MYROW, MYCOL,
     $                       IIC, JJC, ICROW, ICCOL )
               IF( MYROW.EQ.ICROW .AND. MYCOL.EQ.ICCOL ) THEN
                  ERR0 = ABS( PC( IIC+(JJC-1)*LDPC )-C( IOFFC ) )
                  IF( ERR0.GT.ERRI )
     $               INFO = 1
                  ERR = MAX( ERR, ERR0 )
               END IF
*
               IOFFA = IOFFA + 1
               IOFFC = IOFFC + 1
*
   10       CONTINUE
*
   20    CONTINUE
*
      ELSE IF( CTRAN ) THEN
*
         DO 40 J = JC, JC + N - 1
*
            IOFFC = IC + ( J - 1 )*DESCC( M_ )
            IOFFA = IA + ( J - JC ) + ( JA - 1 )*DESCA( M_ )
*
            DO 30 I = IC, IC + M - 1
*
               CALL ZERRAXPBY( ERRI, ALPHA, DCONJG( A( IOFFA ) ), BETA,
     $                         C( IOFFC ), PREC )
*
               CALL INFOG2L( I, J, DESCC, NPROW, NPCOL, MYROW, MYCOL,
     $                       IIC, JJC, ICROW, ICCOL )
               IF( MYROW.EQ.ICROW .AND. MYCOL.EQ.ICCOL ) THEN
                  ERR0 = ABS( PC( IIC+(JJC-1)*LDPC )-C( IOFFC ) )
                  IF( ERR0.GT.ERRI )
     $               INFO = 1
                  ERR = MAX( ERR, ERR0 )
               END IF
*
               IOFFC = IOFFC + 1
               IOFFA = IOFFA + DESCA( M_ )
*
   30       CONTINUE
*
   40    CONTINUE
*
      ELSE
*
         DO 60 J = JC, JC + N - 1
*
            IOFFC = IC + ( J - 1 )*DESCC( M_ )
            IOFFA = IA + ( J - JC ) + ( JA - 1 )*DESCA( M_ )
*
            DO 50 I = IC, IC + M - 1
*
               CALL ZERRAXPBY( ERRI, ALPHA, A( IOFFA ), BETA,
     $                         C( IOFFC ), PREC )
               CALL INFOG2L( I, J, DESCC, NPROW, NPCOL, MYROW, MYCOL,
     $                       IIC, JJC, ICROW, ICCOL )
               IF( MYROW.EQ.ICROW .AND. MYCOL.EQ.ICCOL ) THEN
                  ERR0 = ABS( PC( IIC+(JJC-1)*LDPC )-C( IOFFC ) )
                  IF( ERR0.GT.ERRI )
     $               INFO = 1
                  ERR = MAX( ERR, ERR0 )
               END IF
*
               IOFFC = IOFFC + 1
               IOFFA = IOFFA + DESCA( M_ )
*
   50       CONTINUE
*
   60    CONTINUE
*
      END IF
*
*     If INFO = 0, all results are at least half accurate.
*
      CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, -1, MYCOL )
      CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, ERR, 1, I, J, -1, -1,
     $              MYCOL )
*
      RETURN
*
*     End of PZMMCH3
*
      END
      SUBROUTINE ZERRAXPBY( ERRBND, ALPHA, X, BETA, Y, PREC )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      DOUBLE PRECISION   ERRBND, PREC
      COMPLEX*16         ALPHA, BETA, X, Y
*     ..
*
*  Purpose
*  =======
*
*  ZERRAXPBY computes Y := BETA*Y + ALPHA * X serially and returns
*  a scaled relative acceptable error bound on the result.
*
*  Arguments
*  =========
*
*  ERRBND   (global output) DOUBLE PRECISION
*           A scaled relative acceptable error bound (see below for
*           further details).
*
*  ALPHA    (global input) COMPLEX*16
*           The scale factor ALPHA.
*
*  X        (global input) COMPLEX*16
*           The vector entry to be scaled and added.
*
*  BETA     (global input) COMPLEX*16
*           The scale factor ALPHA.
*
*  Y        (global input/global output) COMPLEX*16
*           The vector entry to be added to itself.
*
*  PREC     (global input) DOUBLE PRECISION
*           The machine precision.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ONE, TWO, ZERO
      PARAMETER          ( ONE = 1.0D+0, TWO = 2.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      DOUBLE PRECISION   ADDBND, FACT, SUMINEG, SUMIPOS, SUMRNEG,
     $                   SUMRPOS
      COMPLEX*16         TMP
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, DIMAG, MAX
*     ..
*     .. Executable Statements ..
*
      SUMIPOS = ZERO
      SUMINEG = ZERO
      SUMRPOS = ZERO
      SUMRNEG = ZERO
      FACT = ONE + TWO * PREC
      ADDBND = TWO * TWO * TWO * PREC
*
      TMP = ALPHA * X
      IF( DBLE( TMP ).GE.ZERO ) THEN
         SUMRPOS = SUMRPOS + DBLE( TMP ) * FACT
      ELSE
         SUMRNEG = SUMRNEG - DBLE( TMP ) * FACT
      END IF
      IF( DIMAG( TMP ).GE.ZERO ) THEN
         SUMIPOS = SUMIPOS + DIMAG( TMP ) * FACT
      ELSE
         SUMINEG = SUMINEG - DIMAG( TMP ) * FACT
      END IF
*
      TMP = BETA * Y
      IF( DBLE( TMP ).GE.ZERO ) THEN
         SUMRPOS = SUMRPOS + DBLE( TMP ) * FACT
      ELSE
         SUMRNEG = SUMRNEG - DBLE( TMP ) * FACT
      END IF
      IF( DIMAG( TMP ).GE.ZERO ) THEN
         SUMIPOS = SUMIPOS + DIMAG( TMP ) * FACT
      ELSE
         SUMINEG = SUMINEG - DIMAG( TMP ) * FACT
      END IF
*
      Y = ( BETA * Y ) + ( ALPHA * X )
*
      ERRBND = ADDBND * MAX( MAX( SUMRPOS, SUMRNEG ),
     $                       MAX( SUMIPOS, SUMINEG ) )
*
      RETURN
*
*     End of ZERRAXPBY
*
      END
