
;;
;; commit the current state of the persistent store
;; (not particularly thread safe... if you have
;; one thread writing into the pstore while another
;; is trying to commit, the commit could never complete,
;; fail, and if it did, it won't necessarily represent
;; the state of the store a the time (commit) was
;; called

;;
;; if called with just one argument, doesn't change the root object
;;

(define (commit (ps <persistent-store>) 
		#optional (root default: (root-object ps)))
  (let ((reloc (make-object-table)))
    (let loop ((i 0))
      (let ((cf (pstore-commit* ps root reloc)))
	(if (pair? cf)
	    (begin
	      (copy-in* ps reloc cf)
	      (loop (+ i 1)))
	    ;;
	    ;; return the new commit record ID
	    ;;
	    cf)))))
