
(define-class <lss> (<object>)
  (lss-raw-ptr type: <fixnum>))

(define-class <lss-error> (<condition>)
  (lss-error-number type: <fixnum>))

(define-method display-object ((self <lss-error>) port)
  (format port "** LSS Error ~d **\n" (lss-error-number self)))

;;;

(define-lss-glue (lss-open* (file <raw-string>)
			    (writable <raw-bool>)
			    generation)
  literals: ((& <lss-error>))
{
  LSS *l;
  int opts = LSS_OPEN + (writable ? LSS_RDWR : LSS_RDONLY);

  if (truish(generation))
    {
      l = lss_open( file, opts + LSS_BACKLEVEL, fx2int( generation ) );
    }
  else
    {
      l = lss_open( file, opts );
    }
  if (!l)
    {
      raise_error( make2( TLREFB(0), NIL_OBJ, int2fx( errno ) ) );
    }
  REG0 = C_PTR_TO_OBJ(LSS *,l);
  RETURN1();
})

(define-lss-glue (lss-create* (file <raw-string>) (fmode <raw-int>))
  literals: ((& <lss-error>))
{
  LSS *l;

  errno = 0;
  l = lss_open( file, LSS_CREATE, fmode );

  if (!l)
    {
      raise_error( make2( TLREFB(0), NIL_OBJ, int2fx( errno ) ) );
    }
  REG0 = C_PTR_TO_OBJ(LSS *,l);
  RETURN1();
})

(define-lss-glue (lss-commit (lss <lss>))
{
  REG0 = int2fx( lss_commit( lss ) );
  RETURN1();
})

(define-lss-glue (lss-read (lss <lss>) (record_num <raw-int>))
{
  LSSAccess *a = lss_read_access( lss, record_num );
  zipbuf b[2];
  obj str;
  size_t len;

  len = lss_access_bytes( a );
  str = bvec_alloc( len + 1, string_class );

  b[0].ptr = PTR_TO_DATAPTR( str );
  b[0].limit = (char *)b[0].ptr + len;
  b[1].ptr = NULL;

  lss_readv( lss, b, a );
  lss_read_release( lss, a );
  REG0 = str;
  RETURN1();
})

(define-lss-glue (lss-write* (lss <lss>) 
			     (record_num <raw-int>)
			     (data <bvec>)
			     (start <raw-int>)
			     (end <raw-int>)
			     zip)
{
  UINT_8 *ptr = data;
  zip_algorithm *za = NULL;

  if (truish(zip))
    za = lss_find_zip_algorithm( string_text(zip) );
  lss_write( lss, record_num, ptr + start, end - start, za );
  RETURN0();
})


;;;
;;;  somewhat more friendly procedures
;;;

(define (lss-create (file <string>) #optional (mode default: #o666))
  (make <lss>
	lss-raw-ptr: (lss-create* file mode)))

(define (lss-open (file <string>) #optional gen (read-only? default: #f))
  (make <lss>
	lss-raw-ptr: (lss-open* file (not read-only?) gen)))

(define (lss-write (lss <lss>) 
		   (record-number <fixnum>) 
		   (str <string>) 
		   #optional zip)
  (lss-write* lss 
	      record-number
	      str
	      0
	      (string-length str)
	      zip))

(define-lss-glue (lss-file (lss <lss>))
{
  REG0 = make_string( lss_filename( lss, -1 ) );
  RETURN1();
})

(define-lss-glue (lss-close (lss <lss>))
{
  lss_close( lss );
  RETURN0();
})
