/*-----------------------------------------------------------------*-C-*---
 * File:    handc/platform/bsd/dynlink.c
 *
 *          Contributed by HIROSHI OOTA <oota@POBoxes.com>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest info.
 *
 * File version:     1.2
 * File mod date:    1999.09.30 06:19:59
 * System build:     v0.7.3.1-b39, 1999-12-25
 *
 * Purpose:          FreeBSD dynamic linking interface
 *------------------------------------------------------------------------*/

#include <stdio.h>
#include <dlfcn.h>

#ifndef	RTLD_NOW
#define	RTLD_NOW	DL_LAZY
#endif
void *resolve_link_symbol( void *info, const char *sym )
{
  return dlsym( info, sym );
}

void *dynamic_link_file( const char *path )
{
  return dlopen( path, RTLD_NOW );
}

char *dynamic_link_errors( void )
{
  return dlerror();
}

void done_resolving( void *info )
{
}

void init_dynamic_link( const char *argv0 )
{
}


