/* Header for module newasm, generated by p2c */
#ifndef NEWASM_H
#define NEWASM_H


#ifdef NEWASM_G
# define vextern
#else
# define vextern extern
#endif


#define na_scale        65536L

#define na_rbias        1023



/*32 bits*/

typedef Char na_chararray[];


typedef union na_word {
  short i;
  unsigned short u;
  struct {
    Char c1, c2;
  } U7;
  struct {
    uchar ub1, ub2;
  } U8;
  struct {
    char sb1, sb2;
  } U9;
  unsigned short b4;
  unsigned short b2;
  unsigned short b;
  Char str[2];
} na_word;

typedef na_word na_wordarray[];

typedef Anyptr na_long;
#define na_long na_longword

typedef union na_long {
  long i;
  struct {
    short i1, i2;
  } U2;
  struct {
    short x, y;
  } U3;
  struct {
    unsigned short u1, u2;
  } U4;
  struct {
    char fill1;
    Signed int s3 : 24;
  } U5;
  struct {
    uchar fill2;
    unsigned u3 : 24;
  } U6;
  Char c[4];
  uchar ub[4];
  long sb;
  unsigned long b4;
  unsigned long b2;
  unsigned long b;
  Anyptr sr;
  Char str[4];
  Char *sp;
  Anyptr p;
  double *rp;
  na_word *wp;
  union na_long *lp;
  union na_quadword *qp;
  struct na_strlistrec *sl;
  Char *cap;
  na_word *wap;
  union na_long *lap;
  union na_quadword *qap;
  struct {
    unsigned sign : 1, mag : 31;
  } U27;
  long *setp;
  struct {
    na_word w1, w2;
  } U99;
} na_long;

#undef na_long
typedef na_long na_longwordarray[];

typedef union na_quadword {
  struct {
    long i1, i2;
  } U1;
  short si[4];
  unsigned short su[4];
  Char c[8];
  uchar ub[8];
  short sb[4];
  uchar b4[8];
  uchar b2[8];
  uchar b[8];
  struct {
    Anyptr sr1, sr2;
  } U13;
  double r;
  Char str[8];
  struct {
    Char *sp1, *sp2;
  } U16;
  struct {
    Anyptr p1, p2;
  } U17;
  struct {
    double *rp1, *rp2;
  } U18;
  struct {
    na_word *wp1, *wp2;
  } U19;
  struct {
    na_long *lp1, *lp2;
  } U20;
  struct {
    union na_quadword *qp1, *qp2;
  } U21;
  struct {
    struct na_strlistrec *sl1, *sl2;
  } U22;
  struct {
    Char *cap1, *cap2;
  } U23;
  struct {
    na_word *wap1, *wap2;
  } U24;
  struct {
    na_long *lap1, *lap2;
  } U25;
  struct {
    union na_quadword *qap1, *qap2;
  } U26;
  _PROCEDURE pr;
  struct {
    unsigned rsign : 1, rexp : 11, rmant1 : 20;
    long rmant2;
  } U28;
  na_word w[4];
  struct {
    na_long l1, l2;
  } U99;
} na_quadword;

typedef na_quadword na_quadwordarray[];

typedef struct na_strlistrec {
  struct na_strlistrec *next;
  na_long value;   /*user-defined*/
  Char kind;   /*user-defined*/
  Char len;   /*for internal use*/
  Char s[256];   /*not entirely allocated*/
} na_strlistrec;



/* p2c: newasm.imp, line 161:
 * Note: Absolute-addressed variable P_nil2 was generated [116] */
extern Anyptr *P_nil2;


typedef na_strlistrec na_strlist;

extern Void na_fillbyte PP((long *d, long w, long n));
extern Void na_fillword PP((long *d, long w, long n));
extern Void na_fill PP((long *d, long w, long n));
extern Void na_fillp PP((Anyptr d, long w, long n));
extern Void na_move PP((long *s, long *d, long size));
extern Void na_movep PP((Anyptr s, Anyptr d, long size));
extern Void na_exch PP((long *s, long *d, long size));
extern Void na_exchp PP((Anyptr s, Anyptr d, long size));
extern long na_comp PP((long *a, long *b, long size));
extern long na_compp PP((Anyptr a, Anyptr b, long size));
extern long na_scaneq PP((long *s, long what, long size));
extern long na_scaneqp PP((Anyptr s, long what, long size));
extern long na_scanne PP((long *s, long what, long size));

extern long na_scannep PP((Anyptr s, long what, long size));
extern Void na_new PP((Anyptr *p, long s));
extern Void na_dispose PP((Anyptr *p, long s));
extern Void na_alloc PP((Anyptr *p, long s));
extern Void na_outeralloc PP((Anyptr *p, long s, long parframe));
extern Void na_free PP((Anyptr *p));

extern long na_memavail PV();
extern long na_and PP((long x, long y));
extern long na_bic PP((long x, long y));
extern long na_or PP((long x, long y));
extern long na_xor PP((long x, long y));
extern long na_not PP((long x));
extern boolean na_mask PP((long x, long y));
extern boolean na_test PP((long n, long x));
extern Void na_set PP((long n, long *x));
extern Void na_clear PP((long n, long *x));
extern long na_log2 PP((long n));
extern long na_po2 PP((long n));
extern long na_lobits PP((long n));
extern long na_hibits PP((long n));
extern long na_asl PP((long n, long x));
extern long na_lsl PP((long n, long x));

extern long na_rol PP((long n, long x));
extern Void na_bfclr PP((long *v, long offset, long size));
extern Void na_bfset PP((long *v, long offset, long size));
extern Void na_bfchg PP((long *v, long offset, long size));
extern boolean na_bftst PP((long *v, long offset, long size));
extern Void na_bffill PP((long *v, long offset, long size, int b));
extern Void na_bfmove PP((long *s, long soff, long *d, long doff, long size));
extern Void na_bfrev PP((long *v, long offset, long size));
extern Void na_bfins PP((long *v, long offset, long size, long val));
extern long na_bfextu PP((long *v, long offset, long size));
extern long na_bfexts PP((long *v, long offset, long size));
extern long na_bfffo PP((long *v, long offset, long size));
extern long na_bfffz PP((long *v, long offset, long size));

extern long na_bfcount PP((long *v, long offset, long size));
extern long na_setcard PP((long *s));
extern long na_setlast PP((long *s));
extern long na_setnext PP((long *s, long offset));

extern long na_setnextnot PP((long *s, long offset));
extern long P_imax PP((long a, long b));
extern long P_imin PP((long a, long b));
extern long P_isgn PP((long a));
extern double P_rmax PP((double a, double b));
extern double P_rmin PP((double a, double b));

extern long P_rsgn PP((double a));
extern long P_imax2 PP((long a, long b));
extern long P_imin2 PP((long a, long b));
extern long P_imax3 PP((long a, long b, long c));
extern long P_imin3 PP((long a, long b, long c));
extern long P_imax4 PP((long a, long b, long c, long d));
extern long P_imin4 PP((long a, long b, long c, long d));
extern Void P_iswap2 PP((long *a, long *b));
extern Void P_isort2 PP((long *a, long *b));
extern Void P_isort3 PP((long *a, long *b, long *c));
extern Void P_isort4 PP((long *a, long *b, long *c, long *d));
extern long P_ibound PP((long min, long i, long max));
extern boolean P_ibetween PP((long min, long i, long max));
extern boolean P_ibetweenm PP((long min, long i, long max, long margin));
extern Void P_iamin PP((long *min, long i));
extern Void P_iamax PP((long *max, long i));

extern Void P_iaminmax PP((long *min, long *max, long i));
extern long P_isqrt PP((long n));

extern long P_ipow PP((long y, long x));
extern long na_add PP((long a, long b));
extern long na_sub PP((long a, long b));
extern Void na_addc PP((long *a, long b, boolean *c));
extern Void na_subc PP((long *a, long b, boolean *c));
extern long na_smul PP((long a, long b));
extern long na_umul PP((long a, long b));
extern na_quadword na_smul64 PP((long a, long b));
extern na_quadword na_umul64 PP((long a, long b));
extern Void na_udiv64 PP((na_quadword *q, long *r, na_quadword a, long b));

extern Void na_sdiv64 PP((na_quadword *q, long *r, na_quadword a, long b));
extern Void P_return PV();
extern Void P_returnb PP((int b));
extern Void P_returnc PP((int c));
extern Void P_returni PP((long i));
extern Void P_returnp PP((Anyptr p));

extern Void P_returnr PP((double r));
extern Anyptr na_rtosr PP((double r));

extern double na_srtor PP((Anyptr sr));
extern double na_stor PP((long s));
extern long na_rtos PP((double r));
extern long na_sm PP((long a, long b));
extern long na_sd PP((long a, long b));
extern long na_strunc PP((long s));
extern long na_sround PP((long s));
extern long na_sint PP((long s));
extern long na_sfrac PP((long s));
extern long na_itos PP((long s));

extern long na_ssqrt PP((long s));
extern Void na_compint PP((na_long a, na_long b, long *res));
extern Void na_compstr PP((na_long a, na_long b, long *res));


extern Void na_qsort PP((na_long *a, long n, _PROCEDURE comp));
extern Void strsafeappend PP((Char *s, Char *s2));
extern Void strappendc PP((Char *s, int ch));
extern Char *strupper PP((Char *Result, Char *s));
extern Char *strlower PP((Char *Result, Char *s));
extern Char charupper PP((int ch));
extern Char charlower PP((int ch));
extern Char *strpart PP((Char *Result, Char *s, long first, long last));
extern Char *strlast PP((Char *Result, Char *s, long num));
extern Char *strljust PP((Char *Result, Char *s, long wid));
extern Char *strrjust PP((Char *Result, Char *s, long wid));
extern Char *strcjust PP((Char *Result, Char *s, long wid));
extern boolean strbegins PP((Char *s1, Char *s2));
extern boolean strends PP((Char *s1, Char *s2));
extern boolean strcibegins PP((Char *s1, Char *s2));
extern boolean strciends PP((Char *s1, Char *s2));
extern boolean strequal PP((Char *s1, Char *s2));
extern long strsubcmp PP((long n, Char *s1, long i1, Char *s2, long i2));
extern boolean strcisubcmp PP((long n, Char *s1, long i1, Char *s2, long i2));
extern Void strsubst PP((Char *repl, Char *s, long index, long size));
extern Char *strint PP((Char *Result, long i));
extern Char *strint2 PP((Char *Result, long i, long w));
extern Char *strreal PP((Char *Result, double r));
extern Char *strchar PP((Char *Result, int ch));
extern long strreadint PP((Char *s));
extern double strreadreal PP((Char *s));
extern long strposb PP((Char *s1, Char *s2, long i));
extern long strposc PP((Char *s1, int ch, long i));
extern long strposcset PP((Char *s1, Char *s2, long i));
extern long strposbcset PP((Char *s1, Char *s2, long i));
extern long strcipos2 PP((Char *s1, Char *s2, long i));
extern long strciposb PP((Char *s1, Char *s2, long i));
extern boolean strcontains PP((Char *s1, Char *s2));
extern boolean strsubset PP((Char *s1, Char *s2));
extern boolean strcommon PP((Char *s1, Char *s2));
extern long strlenv PP((Char *s));
extern Char *strhex PP((Char *Result, long i, long w));
extern Char *strbinary PP((Char *Result, long i, long w));
extern Char *strdate PP((Char *Result, Char *opts));
extern Void strword PP((Char *s, Char *word));
extern Void strword2 PP((Char *s, Char *word));
extern Void strcomment PP((Char *s, Char *bracket));
extern Void strcompress PP((Char *s, Char *chars, int all));
extern Void strdispose PP((Char **sp));

extern Void strchange PP((Char **sp, Char *s));
extern Void strlist_init PP((na_strlistrec **base));
extern na_strlistrec *strlist_find PP((na_strlistrec *base, Char *s));
extern na_strlistrec *strlist_cifind PP((na_strlistrec *base, Char *s));
extern Void strlist_change PP((na_strlistrec **base, na_strlistrec **ptr,
			       Char *s));
extern Void strlist_remove PP((na_strlistrec **base, Char *s));
extern Void strlist_delete PP((na_strlistrec **base, na_strlistrec *ptr));
extern Void strlist_dispose PP((na_strlistrec **ptr));
extern Void strlist_empty PP((na_strlistrec **base));
extern Void strlist_copy PP((na_strlistrec **dest, na_strlistrec *src));

extern Void na_bfand PP((long *s, long soff, long *d, long doff, long size));
extern Void na_bfbic PP((long *s, long soff, long *d, long doff, long size));
extern Void na_bfor PP((long *s, long soff, long *d, long doff, long size));
extern Void na_bfxor PP((long *s, long soff, long *d, long doff, long size));
extern Char *strnew PP((Char *s));
extern na_strlist *strlist_add PP((na_strlist **base, Char *s));
extern na_strlist *strlist_append PP((na_strlist **base, Char *s));
extern na_strlist *strlist_insert PP((na_strlist **base, Char *s));

extern Void strlist_dump PP((FILE *f, na_strlistrec *base));


#undef vextern

#endif /*NEWASM_H*/

/* End. */
