/*
 * GSCTST.C - test of contour routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MAIN - start it off here */

main()
   {int i, k, l, kmax, lmax, kxl;
    int id, lncolor, lnstyle, centering;
    REAL *x, *y, *f, r, t, lnwidth;
    REAL xmin, xmax, ymin, ymax, fmin, fmax;
    PG_device *SCR_dev, *PS_dev, *CGM_dev;
    PG_graph *data;

/* set up the graphics window */
    SCR_dev = PG_make_device("WINDOW", "COLOR", "PGS Contour Test");

    PG_white_background(SCR_dev, TRUE);
    PG_set_viewport_pos(SCR_dev, 0.250, 0.150);
    PG_set_viewport_shape(SCR_dev, 0.500, 0.0, 0.500/0.333);
    PG_set_border_width(SCR_dev, 5);

    PG_open_device(SCR_dev, 0.05, 0.2, 0.45, 0.45);

    PS_dev = PG_make_device("PS", "MONOCHROME", "gsctst");
    PG_open_device(PS_dev, 0.0, 0.0, 0.0, 0.0);

    CGM_dev = PG_make_device("CGM", "MONOCHROME", "gsctst");
    PG_open_device(CGM_dev, 0.0, 0.0, 0.0, 0.0);

/* set up data */
    kmax      = 20;
    lmax      = 20;
    xmin      = -5.0;
    xmax      = 5.0;
    ymin      = -5.0;
    ymax      = 5.0;
    kxl       = kmax*lmax;
    x         = FMAKE_N(REAL, kxl, "GSCTST.C:x");
    y         = FMAKE_N(REAL, kxl, "GSCTST.C:y");
    f         = FMAKE_N(REAL, kxl, "GSCTST.C:f");
    id        = 'A';
    lncolor   = SCR_dev->BLUE;
    lnwidth   = 0.0;
    lnstyle   = SOLID;
    centering = N_CENT;

    for (k = 0; k < kmax; k++)
        for (l = 0; l < lmax; l++)
            {i    = l*kmax + k;
             x[i] = k/10.0 - 5.0;
             y[i] = l/10.0 - 5.0;
             r    = x[i]*x[i] + y[i]*y[i];
             t    = 5.0*atan(y[i]/(x[i] + SMALL));
             r    = POW(r, 0.125);
             f[i] = exp(-r)*(1.0 + 0.1*cos(t));};

    PG_iso_limit(f, kxl, &fmin, &fmax);

    data = PG_make_graph_r2_r1(id, "{x, y}->f", FALSE,
                               kmax, lmax, centering, x, y, f, "xy", "f");

    data->info = PG_set_tds_info(data->info, PLOT_CONTOUR, CARTESIAN,
				 lnstyle, lncolor, 10, 1.0,
				 lnwidth, 0.0, 0.0, 0.0, HUGE);

    PG_contour_plot(SCR_dev, data);
    PG_contour_plot(PS_dev, data);
    PG_contour_plot(CGM_dev, data);

    SC_pause();

    PG_close_device(SCR_dev);
    PG_close_device(PS_dev);
    PG_close_device(CGM_dev);

    exit(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
