/*
 * Copyright (c) 1997-1998,2000 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
/*
 * "interrupt" handler
 */
struct sigcontext;

int
set_signal_handler(int sig, void (*handler)(int, int, struct sigcontext *));

int open_eth(char *ifname, char *myaddr,
	unsigned int *buflen, int no_ieee802_3);

void register_async_fd(int fd, unsigned iotype,
		       void (*callback)(void *), void *arg);
void unregister_async_fd(int fd);

#define IOTYPE_READ	1
#define IOTYPE_WRITE	2

int threaded_read(int fd, void* buf, size_t len);
int threaded_write(int fd, const void* buf, size_t len);
int threaded_connect(int fd, struct sockaddr* addr, size_t len);
int threaded_accept(int fd, struct sockaddr* addr, size_t* len);
int threaded_recvfrom(int fd, void* buf, size_t len, int flags,
		      struct sockaddr* from, int* fromlen);
int threaded_sendto(int fd, const void* buf, size_t len, int flags,
		    struct sockaddr* to, int tolen);
