
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: ccomplex.h,v 1.2 1999/07/06 19:48:08 stes Exp $
 */

#ifndef __CACOMPLEX_HEADER__
#define __CACOMPLEX_HEADER__

#include "cobject.h"

@interface Complex : CAObject
{
  id real;
  id imaginary;
}

+ real:aReal;
- _setUpReal:aReal imaginary:anotherReal;
+ real:aReal imaginary:anotherReal;
- copy;
- deepCopy;
- real:aReal imaginary:anotherReal;
- real:aReal;
- imaginary:aReal;
- symbol:aSymbol;

- real;
- imaginary;
- (BOOL) isReal;
- (BOOL) notReal;
- (unsigned) hash;
- (BOOL) isEqual:b;

- conjugate;
- conjugateSelf;
- norm;
- asReal;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;

- I;
- one;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- (BOOL) isUnit;
- square;
- multiplyReal:b;
- multiplySelfReal:b;
- multiply:b;
- power:(int)n;

- divideReal:b;
- divideSelfReal:b;
- divide:b;
- inverse;
- quotientReal:b;
- quotientSelfReal:b;
- quotient:b;
- remainder:b quotient:(id *)q;

- gcd:b;

- printOn:(IOD)aFile;
@end

#endif /* __CACOMPLEX_HEADER__ */
 
