
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: ccomplex.h,v 1.2 1999/07/06 19:47:59 stes Exp $
 */

#ifndef __CACOMPLEX_HEADER__
#define __CACOMPLEX_HEADER__

#include "cobject.h"

@interface Complex : CAObject
{
  id real;
  id imaginary;
}

+ real:aReal;
+ real:aReal imaginary:anotherReal;
- copy;
- deepCopy;

- real;
- imaginary;
- (BOOL) isReal;
- (BOOL) notReal;
- (unsigned) hash;
- (BOOL) isEqual:b;

- conjugate;
- norm;
- asReal;

- zero;
- (BOOL) isZero;
- (BOOL) isOpposite:b;
- negate;
- double;
- add:b;
- subtract:b;

- I;
- one;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- (BOOL) isUnit;
- square;
- multiply:b;
- power:(int)n;

- divide:b;
- inverse;
- quotient:b;
- remainder:b quotient:(id *)q;

- gcd:b;

- printOn:(IOD)aFile;
@end

#endif /* __CACOMPLEX_HEADER__ */
 
