Summary: Libsigc++ -- The Typesafe Signal Framework for C++
%define lib_name sigc++
Name: lib%{lib_name}
Version: 0.8.5
Release: 6
Copyright: LGPL
Source: ftp://ftp.ece.ucdavis.edu/pub/kenelson/libsigc++/%{name}-%{version}.tar.gz
Url: http://www.ece.ucdavis.edu/~kenelson/libsigc++/
Vendor: Karl E. Nelson <kenelson@ece.ucdavis.edu>
Packager: Dmitry V. Levin <ldv@fandra.org>
Group: System Environment/Libraries
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
This library implements a full callback system for use in
widget libraries, abstract interfaces, and general
programming. Originally part of the Gtk-- widget set,
libsigc++ is now a seperate library to provide for more
general use. It is the most complete library of its kind with the
ablity to connect an abstract callback to a class method,
function, or function object. It contains adaptor classes for
connection of dissimilar callbacks and has an ease of use
unmatched by other C++ callback libraries.


%prep
%setup -q

%build

%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux"
%endif

if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%{prefix}
else
  CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%{prefix}
fi

make

%install
rm -rf $RPM_BUILD_ROOT
install -d -m 755 $RPM_BUILD_ROOT%{prefix}/{{include,lib}/%{lib_name}}
make install INSTALL="%(which install) -p" prefix=$RPM_BUILD_ROOT%{prefix}

cp -a examples tests $RPM_BUILD_ROOT%{prefix}/lib/%{lib_name}/
rm -f `find $RPM_BUILD_ROOT%{prefix}/lib/%{lib_name}/examples -name "Makefile.*"`
rm -f `find $RPM_BUILD_ROOT%{prefix}/lib/%{lib_name}/tests -name "Makefile.*"`
rm -f `find $RPM_BUILD_ROOT%{prefix}/lib/%{lib_name}/examples -name "*.o"`
rm -f `find $RPM_BUILD_ROOT%{prefix}/lib/%{lib_name}/tests -name "*.o"`
rm -rf $RPM_BUILD_ROOT%{prefix}/lib/%{lib_name}/tests/*/.libs
rm -f doc/Makefile*

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README AUTHORS IDEAS NEWS TODO COPYING* doc
%{prefix}/include/%{lib_name}
%{prefix}/lib/libsigc*
%{prefix}/lib/%{lib_name}
%{prefix}/bin/*
%{prefix}/share/aclocal/sigc++.m4

%changelog
* Thu Aug 12 1999 Karl Nelson <kenelson@ece.ucdavis.edu>
- updated source field and merged conflicts between revisions.

* Tue Aug 10 1999 Dmitry V. Levin <ldv@fandra.org>
- updated Prefix and BuildRoot fields

* Thu Aug  5 1999 Herbert Valerio Riedel <hvr@hvrlab.dhs.org>
- made sure configure works on all alphas

* Sun Jul  7 1999 Karl Nelson <kenelson@ece.ucdavis.edu>
- Added autoconf macro for sigc.

* Tue Jun 11 1999 Karl Nelson <kenelson@ece.ucdavis.edu>
- Made into a .in to keep version field up to date 
- Still need to do release by hand

* Tue Jun  7 1999 Dmitry V. Levin <ldv@fandra.org>
- added Vendor and Packager fields

* Tue Jun  5 1999 Dmitry V. Levin <ldv@fandra.org>
- updated to 0.8.0

* Tue Jun  1 1999 Dmitry V. Levin <ldv@fandra.org>
- initial revision
