/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD/NJN
 *
 *	$Id: hcc.c,v 6.23 1999/08/05 06:54:53 jsquyres Exp $
 *
 *	Function:	- wrapper for C program compilation
 */

#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <lam_config.h>
#include <args.h>
#include <boot.h>
#include <portable.h>

#ifndef DEFTCC
#define DEFTCC LAM_CC
#endif

/*
 * external functions
 */
extern int		cnfexec();
extern char		*getenv();

/*
 * local variables
 */
static char		ph[LAM_PATH_MAX];
static char		plib[LAM_PATH_MAX];
static char		extra[LAM_PATH_MAX];

int
main(argc, argv)

int			argc;
char			*argv[];

{
	int		ac;		/* cc # args */
	int		status;		/* cc return code */
	int		i;		/* favourite index */
	int		fl_libs;	/* add libs to command line */
	int		fl_show;	/* show what would be done */
	int             fl_building;    /* are we building LAM right now? */
	char		**av;		/* cc arg vector */
	char		**sys;		/* system dependent arg vector */
	char		*phome;		/* installation dir */
	char		*tcc;		/* cc tool */
#if LAM_WANT_ROMIO || LAM_WANT_MPI2CPP
	int             fd;
#if LAM_WANT_MPI2CPP
	char            *env;
	int             fl_want_mpi2cpp = 0;
#endif
#if LAM_WANT_ROMIO
	int             fl_want_romio = 0;
#endif
#endif

	phome = getenv("LAMHOME");
	if (phome == 0) phome = getenv("TROLLIUSHOME");
	if (phome == 0) phome = DEFP;

	if ((strlen(phome) + 32) >= LAM_PATH_MAX) {
	  char buffer[32];

	  snprintf(buffer, 32, "%d", LAM_PATH_MAX - 32);
	  show_help("compile", "phome-too-long", phome, buffer, "hcc", NULL);
	  exit(1);
	}
/*
 * Form include directory pathname.
 */
	strcpy(ph, "-I");
	strcat(ph, phome);
	strcat(ph, STRSDIR);
	strcat(ph, "include");
/*
 * Form library directory pathname.
 */
	strcpy(plib, "-L");
	strcat(plib, phome);
	strcat(plib, STRSDIR);
	strcat(plib, "lib");

	tcc = getenv("LAMHCC");
	if (tcc == 0) tcc = getenv("TROLLIUSHCC");
	if (tcc == 0) tcc = DEFTCC;

	if ((av = sfh_argv_break(tcc, ' ')) == 0) {
	  show_help(NULL, "lib-call-fail", "sfh_argv_break", NULL);
	  exit(errno);
	}

	ac = sfh_argv_count(av);
/*
 * Add system dependent defines.
 */
	fl_show = 0;
	fl_libs = 1;
	fl_building = 0;

	for (i = 1; i < argc; ++i) {
		if (strcmp(argv[i], "-showme") == 0) {
			fl_show = 1;
		} else if (strcmp(argv[i], "-c") == 0) {
			fl_libs = 0;
		} else if (strcmp(argv[i], "-building-lam") == 0) {
			fl_building = 1;
		}
	}

/*
 * If we're building LAM right now, #define LAM_BUILDING to be 1 so
 * that we don't try to include mpi++.h and mpio.h in mpi.h
 */
	if (fl_building) {
	  strcpy(extra, "-DBUILDING_LAM=1");
	  sfh_argv_add(&ac, &av, extra);
	} 
/* 
 * If we're not building LAM, check to see if we want ROMIO and the 
 * MPI 2 C++ bindings.  Optimize a bit -- if we're only doing -c, don't
 * check for ROMIO because it doesn't need any -I arguments
 */
#if LAM_WANT_ROMIO || LAM_WANT_MPI2CPP
	else {
#if LAM_WANT_ROMIO
	  if (fl_libs) {
	    strcpy(extra, plib + 2);
	    strcat(extra, "/libmpio.a");
	    fd = open(extra, O_RDONLY);
	    if (fd >= 0) {
	      fl_want_romio = 1;
	      close(fd);
	    } else
	      fl_want_romio = 0;
	  }
#endif

#if LAM_WANT_MPI2CPP
	  strcpy(extra, plib + 2);
	  strcat(extra, "/libmpi++.a");
	  fd = open(extra, O_RDONLY);
	  if (fd >= 0) {
	    fl_want_mpi2cpp = 1;

	    /* Only add the -I if we came in from hcp */

	    env = getenv("LAM_IS_COMPILING_CPP");
	    if (env && strcmp(env, "yes") == 0) {
	      strcpy(extra, ph);
	      strcat(extra, "/mpi2c++");
	      sfh_argv_add(&ac, &av, extra);
	    }
	    close(fd);
	  } else
	    fl_want_mpi2cpp = 0;
#endif
	}
#endif

	sfh_argv_add(&ac, &av, ph);
	if (fl_libs) {
		sfh_argv_add(&ac, &av, plib);
/*
 * Add system dependent link arguments.
 */
		if (strlen(HBIND) > 0) {
			if ((sys = sfh_argv_break(HBIND, ' ')) == 0) {
			  show_help(NULL, "lib-call-fail", "sfh_argv_break", 
				    NULL);
			  exit(errno);
			}

			for ( ; *sys; sys++) {
				sfh_argv_add(&ac, &av, *sys);
			}
		}
	}

	for (i = 1; i < argc; ++i) {
		if (strcmp(argv[i], "-showme")) {
			sfh_argv_add(&ac, &av, argv[i]);
		}
	}

	if (fl_libs) {
/*
 * Do we want MPI 2 C++ bindings support?
 * Tricky -- we have to test for presence of libmpi++.a first, because
 * hcc is used to build libmpi++.a.  Chicken and egg problem.
 */
#if LAM_WANT_MPI2CPP
		if (fl_want_mpi2cpp == 1) {
		    sfh_argv_add(&ac, &av, "-lmpi++");
		}
#endif
/*
 * Do we want ROMIO support?
 * Tricky -- we have to test for presence of libmpio.a first, because
 * hcc is used to build libmpio.a.  Chicken and egg problem.
 */
#if LAM_WANT_ROMIO
		if (fl_want_romio == 1) {
		  sfh_argv_add(&ac, &av, "-lmpio");
#if HAVE_LIBAIO
		  sfh_argv_add(&ac, &av, "-laio");
#endif
		}
#endif
/*
 * Add standard LAM libraries.
 */
	        sfh_argv_add(&ac, &av, "-lmpi");
#if LAM_WANT_IMPI
		/* Argh.  Don't ask. */
		sfh_argv_add(&ac, &av, "-limpi");
		sfh_argv_add(&ac, &av, "-lmpi");
		sfh_argv_add(&ac, &av, "-limpi");
#endif
		sfh_argv_add(&ac, &av, "-ltstdio");
		sfh_argv_add(&ac, &av, "-ltrillium");
		sfh_argv_add(&ac, &av, "-largs");
		sfh_argv_add(&ac, &av, "-lt");
/*
 * Add system dependent libraries.
 */
		if (strlen(SYSLIBS) > 0) {
			if ((sys = sfh_argv_break(SYSLIBS, ' ')) == 0) {
			  show_help(NULL, "lib-call-fail", "sfh_argv_break", 
				    NULL);
			  exit(errno);
			}

			for ( ; *sys; sys++) {
				sfh_argv_add(&ac, &av, *sys);
			}
		}
	}

	if (fl_show) {
		for (i = 0; i < ac; i++) {
			printf("%s ", av[i]);
		}
		printf("\n");
	} else {
		status = cnfexec(av);

		if (status != 0) {
		  if (errno != 0)
		    perror("hcc");
		  exit(status);
		}
	}

	return(0);
}
